/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.core.command.subcommand;

import eu.kennytv.maintenance.core.MaintenancePlugin;
import eu.kennytv.maintenance.core.command.CommandInfo;
import eu.kennytv.maintenance.core.util.SenderInfo;
import java.util.concurrent.TimeUnit;

public final class DumpCommand
extends CommandInfo {
    private long lastDump;

    public DumpCommand(MaintenancePlugin plugin) {
        super(plugin, "dump");
    }

    @Override
    public void execute(SenderInfo sender, String[] args) {
        if (this.checkArgs(sender, args, 1)) {
            return;
        }
        if (System.currentTimeMillis() - this.lastDump < TimeUnit.MINUTES.toMillis(5L)) {
            sender.sendMessage(this.plugin.getPrefix() + "\u00a7cYou can only create a dump every 5 minutes!");
            return;
        }
        this.lastDump = System.currentTimeMillis();
        sender.sendMessage(this.plugin.getPrefix() + "\u00a77The dump is being created, this might take a moment.");
        this.plugin.async(() -> {
            String key = this.plugin.pasteDump();
            if (key == null) {
                if (sender.isPlayer()) {
                    sender.sendMessage(this.plugin.getPrefix() + "\u00a7cCould not paste dump (see the console for details)");
                }
                return;
            }
            String url = "https://hastebin.com/" + key;
            sender.sendMessage(this.plugin.getPrefix() + "\u00a7c" + url);
            if (sender.isPlayer()) {
                this.plugin.getCommandManager().sendDumpMessage(sender, url);
            }
        });
    }
}

