/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.core.command;

import eu.kennytv.maintenance.core.MaintenancePlugin;
import eu.kennytv.maintenance.core.Settings;
import eu.kennytv.maintenance.core.command.CommandInfo;
import eu.kennytv.maintenance.core.command.subcommand.AbortTimerCommand;
import eu.kennytv.maintenance.core.command.subcommand.DebugCommand;
import eu.kennytv.maintenance.core.command.subcommand.DumpCommand;
import eu.kennytv.maintenance.core.command.subcommand.EndtimerCommand;
import eu.kennytv.maintenance.core.command.subcommand.HelpCommand;
import eu.kennytv.maintenance.core.command.subcommand.MotdCommand;
import eu.kennytv.maintenance.core.command.subcommand.ReloadCommand;
import eu.kennytv.maintenance.core.command.subcommand.RemoveMotdCommand;
import eu.kennytv.maintenance.core.command.subcommand.ScheduleTimerCommand;
import eu.kennytv.maintenance.core.command.subcommand.SetMotdCommand;
import eu.kennytv.maintenance.core.command.subcommand.StarttimerCommand;
import eu.kennytv.maintenance.core.command.subcommand.ToggleCommand;
import eu.kennytv.maintenance.core.command.subcommand.UpdateCommand;
import eu.kennytv.maintenance.core.command.subcommand.WhitelistAddCommand;
import eu.kennytv.maintenance.core.command.subcommand.WhitelistCommand;
import eu.kennytv.maintenance.core.command.subcommand.WhitelistRemoveCommand;
import eu.kennytv.maintenance.core.util.SenderInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class MaintenanceCommand {
    protected final MaintenancePlugin plugin;
    protected final Settings settings;
    private final Map<String, CommandInfo> commandExecutors = new LinkedHashMap<String, CommandInfo>();
    private final List<CommandInfo> commands = new ArrayList<CommandInfo>();
    private final HelpCommand help;

    protected MaintenanceCommand(MaintenancePlugin plugin, Settings settings) {
        this.plugin = plugin;
        this.settings = settings;
        this.help = new HelpCommand(plugin);
    }

    protected void registerCommands() {
        this.add(this.help, "help");
        this.add(new ReloadCommand(this.plugin), "reload");
        this.addToggleAndTimerCommands();
        this.add(new WhitelistCommand(this.plugin), "whitelist");
        this.add(new WhitelistAddCommand(this.plugin), "add");
        this.add(new WhitelistRemoveCommand(this.plugin), "remove");
        this.add(new SetMotdCommand(this.plugin), "setmotd");
        this.add(new RemoveMotdCommand(this.plugin), "removemotd");
        this.add(new MotdCommand(this.plugin), "motd");
        this.add(new UpdateCommand(this.plugin), "update", "forceupdate");
        this.add(new DumpCommand(this.plugin), "dump");
        this.add(new DebugCommand(this.plugin), "debug");
    }

    protected void add(CommandInfo command, String ... aliases) {
        this.commands.add(command);
        for (String alias : aliases) {
            this.commandExecutors.put(alias, command);
        }
    }

    public void execute(SenderInfo sender, String[] args) {
        if (!sender.hasMaintenancePermission("command")) {
            sender.send(this.settings.getMessage("noPermission", new String[0]));
            return;
        }
        if (args.length == 0) {
            this.help.sendUsage(sender);
            return;
        }
        CommandInfo command = this.commandExecutors.get(args[0].toLowerCase());
        if (command == null) {
            this.help.sendUsage(sender);
            return;
        }
        if (!command.hasPermission(sender)) {
            sender.send(this.settings.getMessage("noPermission", new String[0]));
            return;
        }
        command.execute(sender, args);
    }

    public List<String> getSuggestions(SenderInfo sender, String[] args) {
        if (!sender.hasMaintenancePermission("command") || args.length == 0) {
            return Collections.emptyList();
        }
        String s = args[0].toLowerCase();
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry<String, CommandInfo> entry : this.commandExecutors.entrySet()) {
                String command = entry.getKey();
                CommandInfo info = entry.getValue();
                if (!info.isVisible() || !command.startsWith(s) || !info.hasPermission(sender)) continue;
                list.add(command);
            }
            return list;
        }
        CommandInfo info = this.commandExecutors.get(args[0]);
        return info != null && info.hasPermission(sender) ? info.getTabCompletion(sender, args) : Collections.emptyList();
    }

    public boolean checkTimerArgs(SenderInfo sender, String time, boolean taskCheck) {
        if (!this.plugin.isNumeric(time)) {
            return true;
        }
        if (taskCheck && this.plugin.isTaskRunning()) {
            sender.send(this.settings.getMessage("timerAlreadyRunning", new String[0]));
            return true;
        }
        int minutes = Integer.parseInt(time);
        if (minutes > 40320) {
            sender.send(this.settings.getMessage("timerTooLong", new String[0]));
            return true;
        }
        if (minutes < 1) {
            sender.sendMessage("\u00a78\u00a7o[kennytv whispers to you] \u00a77\u00a7oThink about running a timer for a negative amount of minutes. Doesn't work \u00a7lthat \u00a77\u00a7owell.");
            return true;
        }
        return false;
    }

    public boolean checkTimerArgs(SenderInfo sender, String time) {
        return this.checkTimerArgs(sender, time, true);
    }

    protected void addToggleAndTimerCommands() {
        this.add(new ToggleCommand(this.plugin), "on", "off");
        this.add(new StarttimerCommand(this.plugin), "starttimer", "start");
        this.add(new EndtimerCommand(this.plugin), "endtimer", "end");
        this.add(new ScheduleTimerCommand(this.plugin), "scheduletimer", "schedule");
        this.add(new AbortTimerCommand(this.plugin), "aborttimer", "abort");
    }

    public void checkForUpdate(SenderInfo sender) {
        if (this.plugin.updateAvailable()) {
            sender.sendMessage(this.plugin.getPrefix() + "\u00a7cNewest version available: \u00a7aVersion " + this.plugin.getNewestVersion() + "\u00a7c, you're on \u00a7a" + this.plugin.getVersion());
            sender.sendMessage(this.plugin.getPrefix() + "\u00a7c\u00a7lWARNING: \u00a7cYou will have to restart the server to prevent further issues and to complete the update! If you can't do that, don't update!");
            this.sendUpdateMessage(sender);
        } else {
            sender.sendMessage(this.plugin.getPrefix() + "\u00a7aYou already have the latest version of the plugin!");
        }
    }

    protected void sendUpdateMessage(SenderInfo sender) {
        sender.sendMessage(this.plugin.getPrefix() + "\u00a7eUse \u00a7c\u00a7l/maintenance forceupdate \u00a7eto update!");
    }

    public List<String> getServersCompletion(String s) {
        return null;
    }

    public List<String> getMaintenanceServersCompletion(String s) {
        return null;
    }

    public List<String> getPlayersCompletion() {
        return null;
    }

    public abstract void sendDumpMessage(SenderInfo var1, String var2);

    public List<CommandInfo> getCommands() {
        return this.commands;
    }
}

