/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.sponge.util;

import eu.kennytv.maintenance.core.util.SenderInfo;
import eu.kennytv.maintenance.lib.kyori.adventure.text.Component;
import eu.kennytv.maintenance.lib.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import eu.kennytv.maintenance.sponge.util.ComponentUtil;
import java.util.UUID;
import net.kyori.adventure.identity.Identity;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.Identifiable;

public final class SpongeSenderInfo
implements SenderInfo {
    private final CommandCause cause;

    public SpongeSenderInfo(CommandCause cause) {
        this.cause = cause;
    }

    @Override
    public UUID getUuid() {
        return this.cause instanceof Player ? ((Identifiable)this.cause).uniqueId() : null;
    }

    @Override
    public String getName() {
        return this.cause.friendlyIdentifier().orElse(this.cause.identifier());
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.cause.hasPermission(permission);
    }

    @Override
    @Deprecated
    public void sendMessage(String message) {
        this.send(LegacyComponentSerializer.legacySection().deserialize(message));
    }

    @Override
    public void send(Component component) {
        this.cause.sendMessage(Identity.nil(), ComponentUtil.toSponge(component));
    }

    public void send(net.kyori.adventure.text.Component component) {
        this.cause.sendMessage(Identity.nil(), component);
    }

    @Override
    public boolean isPlayer() {
        return this.cause instanceof Player;
    }
}

