/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.sponge.listener;

import eu.kennytv.maintenance.core.Settings;
import eu.kennytv.maintenance.sponge.MaintenanceSpongePlugin;
import eu.kennytv.maintenance.sponge.util.ComponentUtil;
import java.util.List;
import java.util.UUID;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.server.ClientPingServerEvent;
import org.spongepowered.api.profile.GameProfile;

public final class ClientPingServerListener {
    private final MaintenanceSpongePlugin plugin;
    private final Settings settings;

    public ClientPingServerListener(MaintenanceSpongePlugin plugin, Settings settings) {
        this.plugin = plugin;
        this.settings = settings;
    }

    @Listener(order=Order.LAST)
    public void proxyPing(ClientPingServerEvent event) {
        if (!this.settings.isMaintenance()) {
            return;
        }
        ClientPingServerEvent.Response response = event.response();
        if (this.settings.hasCustomPlayerCountMessage()) {
            response.players().ifPresent(players -> players.setMax(0));
        }
        if (this.settings.isEnablePingMessages()) {
            response.setDescription(ComponentUtil.toSponge(this.settings.getRandomPingMessage()));
        }
        if (this.settings.hasCustomPlayerCountHoverMessage()) {
            response.players().ifPresent(players -> {
                List profiles = players.profiles();
                profiles.clear();
                for (String string : this.settings.getLegacyParsedPlayerCountHoverLines()) {
                    profiles.add(GameProfile.of((UUID)UUID.randomUUID(), (String)string));
                }
            });
        }
        if (this.settings.hasCustomIcon() && this.plugin.getFavicon() != null) {
            response.setFavicon(this.plugin.getFavicon());
        }
    }
}

