/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.sponge.listener;

import eu.kennytv.maintenance.core.Settings;
import eu.kennytv.maintenance.core.listener.JoinListenerBase;
import eu.kennytv.maintenance.lib.kyori.adventure.text.Component;
import eu.kennytv.maintenance.sponge.MaintenanceSpongePlugin;
import eu.kennytv.maintenance.sponge.util.ComponentUtil;
import eu.kennytv.maintenance.sponge.util.SpongePlayer;
import eu.kennytv.maintenance.sponge.util.SpongeUser;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.service.permission.Subject;

public final class ClientConnectionListener
extends JoinListenerBase {
    private final MaintenanceSpongePlugin plugin;

    public ClientConnectionListener(MaintenanceSpongePlugin plugin, Settings settings) {
        super(plugin, settings);
        this.plugin = plugin;
    }

    @Listener
    public void login(ServerSideConnectionEvent.Login event) {
        if (this.shouldKick(new SpongeUser(event.user()), false)) {
            event.setCancelled(true);
            event.setMessage(ComponentUtil.toSponge(this.settings.getKickMessage()));
            if (this.settings.isJoinNotifications()) {
                this.broadcastJoinNotification(event.user().name());
            }
        }
    }

    @Listener
    public void join(ServerSideConnectionEvent.Join event) {
        this.updateCheck(new SpongePlayer(event.player()));
    }

    @Override
    protected void broadcastJoinNotification(String name) {
        Component component = this.settings.getMessage("joinNotification", "%PLAYER%", name);
        for (ServerPlayer player : Sponge.server().onlinePlayers()) {
            if (!this.plugin.hasPermission((Subject)player, "joinnotification")) continue;
            player.sendMessage(ComponentUtil.toSponge(component));
        }
    }
}

