/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.sponge.command;

import eu.kennytv.maintenance.core.Settings;
import eu.kennytv.maintenance.core.command.MaintenanceCommand;
import eu.kennytv.maintenance.core.util.SenderInfo;
import eu.kennytv.maintenance.sponge.MaintenanceSpongePlugin;
import eu.kennytv.maintenance.sponge.util.SpongeSenderInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.permission.Subject;

public final class MaintenanceSpongeCommand
extends MaintenanceCommand
implements Command.Raw {
    private final MaintenanceSpongePlugin plugin;
    private static final String[] EMPTY = new String[0];
    private static final String[] EMPTY_SINGLE = new String[]{""};

    public MaintenanceSpongeCommand(MaintenanceSpongePlugin plugin, Settings settings) {
        super(plugin, settings);
        this.plugin = plugin;
        this.registerCommands();
    }

    public CommandResult process(CommandCause cause, ArgumentReader.Mutable argument) {
        String input = argument.input();
        this.execute(new SpongeSenderInfo(cause), input.isEmpty() ? EMPTY : input.split(" ", 0));
        return CommandResult.success();
    }

    public List<CommandCompletion> complete(CommandCause cause, ArgumentReader.Mutable argument) {
        String input = argument.input();
        return this.getSuggestions(new SpongeSenderInfo(cause), input.isEmpty() ? EMPTY_SINGLE : input.split(" ", -1)).stream().map(CommandCompletion::of).collect(Collectors.toList());
    }

    public boolean canExecute(CommandCause cause) {
        return this.plugin.hasPermission((Subject)cause, "command");
    }

    public Optional<Component> shortDescription(CommandCause cause) {
        return Optional.of(Component.text((String)"Maintenance main-command"));
    }

    public Optional<Component> extendedDescription(CommandCause cause) {
        return this.shortDescription(cause);
    }

    public Optional<Component> help(CommandCause cause) {
        return Optional.empty();
    }

    public Component usage(CommandCause cause) {
        return null;
    }

    @Override
    public void sendDumpMessage(SenderInfo sender, String url) {
        SpongeSenderInfo spongeSender = (SpongeSenderInfo)sender;
        spongeSender.send((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(this.plugin.translate(this.plugin.getPrefix() + "\u00a77Click here to copy the link"))).clickEvent(ClickEvent.suggestCommand((String)url))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)this.plugin.translate("\u00a7aClick here to copy the link")))).build());
    }

    @Override
    public List<String> getPlayersCompletion() {
        ArrayList<String> list = new ArrayList<String>();
        for (Player player : this.plugin.getServer().onlinePlayers()) {
            list.add(player.name());
        }
        return list;
    }
}

