/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.sponge;

import com.google.inject.Inject;
import eu.kennytv.maintenance.core.MaintenancePlugin;
import eu.kennytv.maintenance.core.Settings;
import eu.kennytv.maintenance.core.dump.PluginDump;
import eu.kennytv.maintenance.core.hook.ServerListPlusHook;
import eu.kennytv.maintenance.core.util.SenderInfo;
import eu.kennytv.maintenance.core.util.ServerType;
import eu.kennytv.maintenance.lib.bstats.sponge.Metrics;
import eu.kennytv.maintenance.sponge.command.MaintenanceSpongeCommand;
import eu.kennytv.maintenance.sponge.listener.ClientConnectionListener;
import eu.kennytv.maintenance.sponge.listener.ClientPingServerListener;
import eu.kennytv.maintenance.sponge.util.ComponentUtil;
import eu.kennytv.maintenance.sponge.util.LoggerWrapper;
import eu.kennytv.maintenance.sponge.util.SpongePlayer;
import eu.kennytv.maintenance.sponge.util.SpongeTask;
import eu.kennytv.maintenance.sponge.util.SpongeUser;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.Game;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Server;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.registrar.CommandRegistrar;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.lifecycle.StartingEngineEvent;
import org.spongepowered.api.event.lifecycle.StoppingEngineEvent;
import org.spongepowered.api.network.status.Favicon;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.builtin.jvm.Plugin;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.plugin.metadata.model.PluginContributor;

@Plugin(value="maintenance")
public final class MaintenanceSpongePlugin
extends MaintenancePlugin {
    private final Logger logger;
    private final PluginContainer container;
    private final Game game;
    private Favicon favicon;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path dataFolder;

    @Inject
    public MaintenanceSpongePlugin(PluginContainer container, Game game, org.apache.logging.log4j.Logger logger, Metrics.Factory metricsFactory) {
        super("4.2.1", ServerType.SPONGE);
        this.container = container;
        this.game = game;
        this.logger = new LoggerWrapper(logger);
        metricsFactory.make(16501);
    }

    @Listener
    public void onEnable(StartingEngineEvent<Server> event) {
        this.settings = new Settings(this, "mysql", "proxied-maintenance-servers", "fallback", "waiting-server", "playercountmessage", "commands-on-single-maintenance-enable", "commands-on-single-maintenance-disable");
        this.sendEnableMessage();
        MaintenanceSpongeCommand command = new MaintenanceSpongeCommand(this, this.settings);
        this.commandManager = command;
        ((CommandRegistrar)this.game.server().commandManager().registrar(Command.Raw.class).get()).register(this.container, (Object)command, "maintenance", new String[]{"mt"});
        EventManager em = this.game.eventManager();
        em.registerListeners(this.container, (Object)new ClientPingServerListener(this, this.settings));
        em.registerListeners(this.container, (Object)new ClientConnectionListener(this, this.settings));
        this.continueLastEndtimer();
        PluginManager pluginManager = this.game.pluginManager();
        pluginManager.plugin("serverlistplus").map(PluginContainer::instance).ifPresent(serverListPlus -> {
            this.serverListPlusHook = new ServerListPlusHook(serverListPlus);
            if (this.settings.isEnablePingMessages()) {
                this.serverListPlusHook.setEnabled(!this.settings.isMaintenance());
            }
            this.logger.info("Enabled ServerListPlus integration!");
        });
    }

    @Listener
    public void onDisable(StoppingEngineEvent<Server> event) {
        this.disable();
    }

    @Override
    public eu.kennytv.maintenance.core.util.Task startMaintenanceRunnable(Runnable runnable) {
        Task task = Task.builder().plugin(this.container).execute(runnable).interval(1L, TimeUnit.SECONDS).build();
        return new SpongeTask(this.game.server().scheduler().submit(task));
    }

    @Override
    public void async(Runnable runnable) {
        Task task = Task.builder().plugin(this.container).execute(runnable).build();
        this.game.asyncScheduler().submit(task);
    }

    @Override
    protected void executeConsoleCommand(String command) {
        try {
            this.game.server().commandManager().process(command);
        }
        catch (CommandException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void broadcast(eu.kennytv.maintenance.lib.kyori.adventure.text.Component component) {
        this.game.server().sendMessage(ComponentUtil.toSponge(component));
    }

    @Override
    public void sendUpdateNotification(SenderInfo sender) {
        try {
            BuildableComponent component = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(this.translate(this.getPrefix()))).append(this.translate("\u00a7cDownload it at: \u00a76https://hangar.papermc.io/kennytv/Maintenance"))).append(this.translate(" \u00a77\u00a7l\u00a7o(CLICK ME)"))).clickEvent(ClickEvent.openUrl((URL)new URL("https://hangar.papermc.io/kennytv/Maintenance")))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)this.translate("\u00a77\u00a7l\u00a7o(CLICK ME)")))).build();
            ((SpongePlayer)sender).send((Component)component);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CompletableFuture<@Nullable SenderInfo> getOfflinePlayer(String name) {
        Optional player = this.game.server().player(name);
        if (player.isPresent()) {
            return CompletableFuture.completedFuture(new SpongePlayer((ServerPlayer)player.get()));
        }
        return this.game.server().userManager().load(name).thenApply(optional -> optional.map(SpongeUser::new).orElse(null));
    }

    @Override
    public CompletableFuture<@Nullable SenderInfo> getOfflinePlayer(UUID uuid) {
        Optional player = this.game.server().player(uuid);
        if (player.isPresent()) {
            return CompletableFuture.completedFuture(new SpongePlayer((ServerPlayer)player.get()));
        }
        return this.game.server().userManager().load(uuid).thenApply(optional -> optional.map(SpongeUser::new).orElse(null));
    }

    @Override
    protected void kickPlayers() {
        Component component = ComponentUtil.toSponge(this.settings.getKickMessage());
        for (ServerPlayer player : this.getServer().onlinePlayers()) {
            if (this.hasPermission((Subject)player, "bypass") || this.settings.isWhitelisted(player.uniqueId())) continue;
            player.kick(component);
        }
    }

    @Override
    public File getDataFolder() {
        return this.dataFolder.toFile();
    }

    @Override
    public File getPluginFile() {
        throw new UnsupportedOperationException("grumbles");
    }

    @Override
    protected int getOnlinePlayers() {
        return this.getServer().onlinePlayers().size();
    }

    @Override
    protected int getMaxPlayers() {
        return this.getServer().maxPlayers();
    }

    @Override
    protected String getPluginFolder() {
        return "mods/";
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getServerVersion() {
        return this.game.platform().container(Platform.Component.IMPLEMENTATION).toString();
    }

    @Override
    public List<PluginDump> getPlugins() {
        return this.game.pluginManager().plugins().stream().map(plugin -> {
            PluginMetadata metadata = plugin.metadata();
            List<String> contributors = metadata.contributors().stream().map(PluginContributor::name).collect(Collectors.toList());
            String id = metadata.id();
            return new PluginDump(id + "/" + metadata.name().orElse(id), metadata.version().toString(), contributors);
        }).collect(Collectors.toList());
    }

    @Override
    protected void loadIcon(File file) throws IOException {
        this.favicon = Favicon.load((BufferedImage)ImageIO.read(file));
    }

    public boolean hasPermission(Subject sender, String permission) {
        return sender.hasPermission("maintenance." + permission) || sender.hasPermission("maintenance.admin");
    }

    public Server getServer() {
        return this.game.server();
    }

    public Favicon getFavicon() {
        return this.favicon;
    }

    @Deprecated
    public Component translate(String s) {
        return LegacyComponentSerializer.legacySection().deserialize(s);
    }
}

