/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.core.listener;

import eu.kennytv.maintenance.core.MaintenancePlugin;
import eu.kennytv.maintenance.core.Settings;
import eu.kennytv.maintenance.core.util.SenderInfo;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public abstract class JoinListenerBase {
    protected final MaintenancePlugin plugin;
    protected final Settings settings;
    private final Set<UUID> notifiedPlayers = new HashSet<UUID>();

    protected JoinListenerBase(MaintenancePlugin plugin, Settings settings) {
        this.plugin = plugin;
        this.settings = settings;
    }

    protected boolean shouldKick(SenderInfo sender, boolean updateCheck) {
        if (!this.settings.isMaintenance() || sender.hasMaintenancePermission("bypass") || this.settings.isWhitelisted(sender.getUuid())) {
            if (updateCheck) {
                this.updateCheck(sender);
            }
            return false;
        }
        return true;
    }

    protected boolean shouldKick(SenderInfo sender) {
        return this.shouldKick(sender, true);
    }

    protected void updateCheck(SenderInfo sender) {
        if (!this.settings.hasUpdateChecks()) {
            return;
        }
        if (!sender.hasPermission("maintenance.admin") || this.notifiedPlayers.contains(sender.getUuid())) {
            return;
        }
        this.plugin.async(() -> {
            if (!this.plugin.updateAvailable()) {
                return;
            }
            this.notifiedPlayers.add(sender.getUuid());
            sender.sendMessage(this.plugin.getPrefix() + "\u00a7cThere is a newer version available: \u00a7aVersion " + this.plugin.getNewestVersion() + "\u00a7c, you're on \u00a7a" + this.plugin.getVersion());
            this.plugin.sendUpdateNotification(sender);
        });
    }

    protected abstract void broadcastJoinNotification(String var1);
}

