/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.core.config;

import eu.kennytv.maintenance.core.config.Config;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ConfigSection {
    protected final Config root;
    protected final String currentPath;
    protected Map<String, Object> values;

    ConfigSection(Config root, String currentPath) {
        this(root, currentPath, new HashMap<String, Object>());
    }

    ConfigSection(Config root, String currentPath, Map<String, Object> values) {
        this.root = root;
        this.currentPath = currentPath;
        this.values = values;
    }

    @Nullable
    public <E> E get(String key) {
        return (E)this.getObject(key);
    }

    @Nullable
    public <E> E get(String key, @Nullable E def) {
        Object o = this.getObject(key);
        return (E)(o != null ? o : def);
    }

    @Nullable
    public Object getObject(String key) {
        return this.getObject(key, null);
    }

    @Nullable
    public Object getObject(String key, Object def) {
        int i2;
        int i1 = -1;
        ConfigSection section = this;
        while ((i1 = key.indexOf(46, i2 = i1 + 1)) != -1) {
            if ((section = section.getSection(key.substring(i2, i1))) != null) continue;
            return def;
        }
        String subKey = key.substring(i2);
        if (section == this) {
            Object result = this.values.get(subKey);
            return result != null ? result : def;
        }
        return section.getObject(subKey, def);
    }

    @Nullable
    public <E> E getOrSet(String key, @Nullable E def) {
        Object o = this.getObject(key);
        if (o != null) {
            return (E)o;
        }
        this.set(key, def);
        return def;
    }

    @Nullable
    public ConfigSection getSection(String key) {
        Object o = this.getObject(key);
        if (!(o instanceof Map)) {
            return null;
        }
        return new ConfigSection(this.getRoot(), this.getFullKeyInPath(key), (Map)o);
    }

    public boolean contains(String key) {
        return this.getObject(key) != null;
    }

    public void set(String key, @Nullable Object value) {
        if (value == null) {
            this.values.remove(key);
            this.getRoot().getComments().remove(this.getFullKeyInPath(key));
        } else {
            this.values.put(key, value);
        }
    }

    public void remove(String key) {
        this.set(key, null);
    }

    public Set<String> getKeys() {
        return this.values.keySet();
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean def) {
        Object o = this.getObject(key);
        return o instanceof Boolean ? (Boolean)o : def;
    }

    @Nullable
    public String getString(String key) {
        return (String)this.get(key);
    }

    @Nullable
    public String getString(String key, @Nullable String def) {
        Object o = this.getObject(key);
        return o instanceof String ? (String)o : def;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int def) {
        Object o = this.getObject(key);
        return o instanceof Number ? ((Number)o).intValue() : def;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double def) {
        Object o = this.getObject(key);
        return o instanceof Number ? ((Number)o).doubleValue() : def;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long def) {
        Object o = this.getObject(key);
        return o instanceof Number ? ((Number)o).longValue() : def;
    }

    @Nullable
    public List<String> getStringList(String key) {
        return (List)this.get(key);
    }

    @Nullable
    public List<String> getStringList(String key, @Nullable List<String> def) {
        List<String> list = (List<String>)this.get(key);
        return list != null ? list : def;
    }

    @Nullable
    public List<Integer> getIntList(String key) {
        return (List)this.get(key);
    }

    @Nullable
    public List<Integer> getIntList(String key, @Nullable List<Integer> def) {
        List<Integer> list = (List<Integer>)this.get(key);
        return list != null ? list : def;
    }

    public Config getRoot() {
        return this.root;
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    protected String getFullKeyInPath(String key) {
        return this.currentPath.isEmpty() ? key : this.currentPath + "." + key;
    }
}

