/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.bungee.command;

import eu.kennytv.maintenance.bungee.MaintenanceBungeePlugin;
import eu.kennytv.maintenance.bungee.util.BungeeSenderInfo;
import eu.kennytv.maintenance.core.proxy.SettingsProxy;
import eu.kennytv.maintenance.core.proxy.command.MaintenanceProxyCommand;
import eu.kennytv.maintenance.core.util.SenderInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public final class MaintenanceBungeeCommand
extends MaintenanceProxyCommand {
    private final MaintenanceBungeePlugin plugin;

    public MaintenanceBungeeCommand(MaintenanceBungeePlugin plugin, SettingsProxy settings) {
        super(plugin, settings);
        this.plugin = plugin;
        this.registerCommands();
    }

    @Override
    protected void sendUpdateMessage(SenderInfo sender) {
        TextComponent tc = new TextComponent("\u00a76\u00d7 \u00a78[\u00a7aUpdate\u00a78]");
        tc.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/maintenance forceupdate"));
        tc.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"\u00a7aClick here to update the plugin")));
        tc.addExtra(" \u00a78< \u00a77Or use the command \u00a7c/maintenance forceupdate");
        ((BungeeSenderInfo)sender).sendMessage(tc);
    }

    @Override
    public List<String> getServersCompletion(String s) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : this.plugin.getProxy().getServers().entrySet()) {
            String serverName = ((ServerInfo)entry.getValue()).getName();
            if (!((String)entry.getKey()).toLowerCase().startsWith(s) || this.plugin.getSettingsProxy().getMaintenanceServers().contains(serverName)) continue;
            list.add(serverName);
        }
        return list;
    }

    @Override
    public void sendDumpMessage(SenderInfo sender, String url) {
        BungeeSenderInfo bungeeSender = (BungeeSenderInfo)sender;
        TextComponent clickText = new TextComponent(this.plugin.getPrefix() + "\u00a77Click here to copy the link");
        clickText.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, url));
        clickText.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"\u00a7aClick here to copy the link")));
        bungeeSender.sendMessage(clickText);
    }

    @Override
    public List<String> getPlayersCompletion() {
        ArrayList<String> list = new ArrayList<String>();
        for (ProxiedPlayer p : this.plugin.getProxy().getPlayers()) {
            list.add(p.getName());
        }
        return list;
    }
}

