/*
 * Decompiled with CFR 0.152.
 */
package eu.jonahbauer.android.preference.annotations.processor.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import eu.jonahbauer.android.preference.annotations.PreferenceGroup;
import eu.jonahbauer.android.preference.annotations.Preferences;
import eu.jonahbauer.android.preference.annotations.processor.ClassNames;
import eu.jonahbauer.android.preference.annotations.processor.StringUtils;
import eu.jonahbauer.android.preference.annotations.processor.TypeUtils;
import eu.jonahbauer.android.preference.annotations.processor.model.Context;
import eu.jonahbauer.android.preference.annotations.processor.model.PreferenceGroupSpec;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

public final class PreferencesSpec {
    private final JavaFile file;

    public static PreferencesSpec create(ProcessingEnvironment env, Element element, Preferences root) {
        Context context = new Context(env, element);
        if (!PreferencesSpec.check(context, root)) {
            return null;
        }
        context.setFluent(root.fluent());
        context.setEditor(root.editor());
        ClassName name = PreferencesSpec.name(root);
        context.setRoot(name);
        TypeName r = TypeName.get((TypeMirror)TypeUtils.mirror(root, Preferences::r));
        context.setR(r);
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)name);
        if (root.makeFile()) {
            builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        }
        builder.addMethod(PreferencesSpec.constructor(root));
        FieldSpec sharedPreferencesField = FieldSpec.builder((TypeName)ClassNames.SHARED_PREFERENCES, (String)"sharedPreferences", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build();
        context.setSharedPreferences(sharedPreferencesField);
        builder.addField(sharedPreferencesField);
        MethodSpec.Builder initMethod = PreferencesSpec.init(sharedPreferencesField);
        PreferenceGroup[] groups = root.value();
        for (int i = 0; i < groups.length; ++i) {
            PreferenceGroupSpec spec = PreferenceGroupSpec.create(context, i, groups[i]);
            if (spec == null) continue;
            spec.apply(builder);
            initMethod.addStatement("$N = new $T(pResources)", new Object[]{spec.getField(), spec.getName()});
        }
        builder.addMethod(initMethod.build());
        builder.addMethod(PreferencesSpec.clear(sharedPreferencesField));
        builder.addMethod(PreferencesSpec.getSharedPreferences(sharedPreferencesField));
        return new PreferencesSpec(JavaFile.builder((String)name.packageName(), (TypeSpec)builder.build()).indent("    ").build());
    }

    private static boolean check(Context context, Preferences root) {
        if (!StringUtils.isFQCN(root.name())) {
            context.error("Illegal preference class name: %s", root.name());
            return false;
        }
        return true;
    }

    private static ClassName name(Preferences root) {
        return ClassName.get((String)(root.name().lastIndexOf(46) != -1 ? root.name().substring(0, root.name().lastIndexOf(46)) : ""), (String)(root.name().lastIndexOf(46) != -1 ? root.name().substring(root.name().lastIndexOf(46) + 1) : root.name()), (String[])new String[0]);
    }

    private static MethodSpec constructor(Preferences root) {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{root.makeFile() ? Modifier.PRIVATE : Modifier.PROTECTED}).addStatement("throw new $T($S)", new Object[]{ClassNames.ILLEGAL_STATE_EXCEPTION, "This class is not supposed to be instantiated."}).build();
    }

    private static MethodSpec.Builder init(FieldSpec sharedPreferencesField) {
        return MethodSpec.methodBuilder((String)"init").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter((TypeName)ClassNames.SHARED_PREFERENCES, "pSharedPreferences", new Modifier[0]).addParameter((TypeName)ClassNames.RESOURCES, "pResources", new Modifier[0]).addJavadoc("Initialize this preference class to use the given {@link $T}\n", new Object[]{ClassNames.SHARED_PREFERENCES}).addJavadoc("This function is supposed to be called from the applications {@code onCreate()} method.\n", new Object[0]).addJavadoc("@param pSharedPreferences the {@link $T} to be used. Not {@code null}.\n", new Object[]{ClassNames.SHARED_PREFERENCES}).addJavadoc("@param pResources the {@link $T} from which the preference keys should be loaded. Not {@code null}.\n", new Object[]{ClassNames.RESOURCES}).addJavadoc("@throws $T if this preference class has already been initialized.\n", new Object[]{ClassNames.ILLEGAL_STATE_EXCEPTION}).addCode(CodeBlock.builder().beginControlFlow("if ($N != null)", new Object[]{sharedPreferencesField}).addStatement("throw new $T($S)", new Object[]{ClassNames.ILLEGAL_STATE_EXCEPTION, "Preferences have already been initialized."}).endControlFlow().addStatement("$T.requireNonNull(pSharedPreferences, $S)", new Object[]{ClassNames.OBJECTS, "SharedPreferences must not be null."}).addStatement("$T.requireNonNull(pResources, $S)", new Object[]{ClassNames.OBJECTS, "Resources must not be null."}).addStatement("$N = pSharedPreferences", new Object[]{sharedPreferencesField}).build());
    }

    private static MethodSpec clear(FieldSpec sharedPreferencesField) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"clear").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        return PreferencesSpec.addInitCheck(builder, sharedPreferencesField).addStatement("$N.edit().clear().apply()", new Object[]{sharedPreferencesField}).addJavadoc("@see $T#clear()", new Object[]{ClassNames.SHARED_PREFERENCES_EDITOR}).build();
    }

    private static MethodSpec getSharedPreferences(FieldSpec sharedPreferencesField) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getSharedPreferences").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassNames.SHARED_PREFERENCES).addJavadoc("Returns the underlying {@link $T} instance.\n", new Object[]{ClassNames.SHARED_PREFERENCES}).addJavadoc("Modifying the underlying {@code SharedPreferences} instance is not recommended as it can\n", new Object[0]).addJavadoc("lead to invalid data which can cause {@code PreferenceSerializer}s to throw exceptions.\n", new Object[0]).addJavadoc("@throws $T if this preference class has not yet been initialized.\n", new Object[]{ClassNames.ILLEGAL_STATE_EXCEPTION}).addJavadoc("@return the underlying {@code SharedPreferences} instance", new Object[0]);
        return PreferencesSpec.addInitCheck(builder, sharedPreferencesField).addStatement("return $N", new Object[]{sharedPreferencesField}).build();
    }

    static MethodSpec.Builder addInitCheck(MethodSpec.Builder builder, FieldSpec sharedPreferencesField) {
        return builder.beginControlFlow("if ($N == null)", new Object[]{sharedPreferencesField}).addStatement("throw new $T($S)", new Object[]{ClassNames.ILLEGAL_STATE_EXCEPTION, "Preferences have not yet been initialized."}).endControlFlow();
    }

    public PreferencesSpec(JavaFile file) {
        this.file = file;
    }

    public JavaFile getFile() {
        return this.file;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreferencesSpec)) {
            return false;
        }
        PreferencesSpec other = (PreferencesSpec)o;
        JavaFile this$file = this.getFile();
        JavaFile other$file = other.getFile();
        return !(this$file == null ? other$file != null : !this$file.equals(other$file));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaFile $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        return result;
    }

    public String toString() {
        return "PreferencesSpec(file=" + this.getFile() + ")";
    }
}

