/*
 * Decompiled with CFR 0.152.
 */
package eu.jonahbauer.android.preference.annotations.processor.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public final class Context {
    private final ProcessingEnvironment env;
    private final Element element;
    private TypeName r;
    private ClassName root;
    private FieldSpec sharedPreferences;
    private boolean fluent;
    private boolean editor;

    public boolean isSame(TypeMirror type, Class<?> clazz, Class<?> ... typeParameters) {
        Types types = this.env.getTypeUtils();
        if (typeParameters == null || typeParameters.length == 0) {
            return types.isSameType(types.erasure(type), types.erasure(this.getType(clazz, new Class[0])));
        }
        return types.isSameType(type, this.getType(clazz, typeParameters));
    }

    public boolean isEnum(TypeMirror type) {
        Types utils = this.env.getTypeUtils();
        for (TypeMirror typeMirror : utils.directSupertypes(type)) {
            if (!this.isSame(typeMirror, Enum.class, new Class[0])) continue;
            return true;
        }
        return false;
    }

    public TypeMirror tryUnbox(TypeMirror type) {
        try {
            return this.env.getTypeUtils().unboxedType(type);
        }
        catch (IllegalArgumentException e) {
            return type;
        }
    }

    public TypeMirror tryBox(TypeMirror type) {
        if (type instanceof PrimitiveType) {
            return this.env.getTypeUtils().boxedClass((PrimitiveType)type).asType();
        }
        return type;
    }

    public DeclaredType getType(Class<?> clazz, Class<?> ... typeParameters) {
        Types types = this.env.getTypeUtils();
        Elements elements = this.env.getElementUtils();
        TypeElement element = elements.getTypeElement(clazz.getName());
        if (typeParameters == null || typeParameters.length == 0) {
            return types.getDeclaredType(element, new TypeMirror[0]);
        }
        return types.getDeclaredType(element, (TypeMirror[])Arrays.stream(typeParameters).map(Class::getName).map(elements::getTypeElement).map(Element::asType).toArray(TypeMirror[]::new));
    }

    public void error(String message, Object ... args) {
        this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args), this.element);
    }

    public Context(ProcessingEnvironment env, Element element) {
        this.env = env;
        this.element = element;
    }

    public ProcessingEnvironment getEnv() {
        return this.env;
    }

    public Element getElement() {
        return this.element;
    }

    public TypeName getR() {
        return this.r;
    }

    public ClassName getRoot() {
        return this.root;
    }

    public FieldSpec getSharedPreferences() {
        return this.sharedPreferences;
    }

    public boolean isFluent() {
        return this.fluent;
    }

    public boolean isEditor() {
        return this.editor;
    }

    public void setR(TypeName r) {
        this.r = r;
    }

    public void setRoot(ClassName root) {
        this.root = root;
    }

    public void setSharedPreferences(FieldSpec sharedPreferences) {
        this.sharedPreferences = sharedPreferences;
    }

    public void setFluent(boolean fluent) {
        this.fluent = fluent;
    }

    public void setEditor(boolean editor) {
        this.editor = editor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Context)) {
            return false;
        }
        Context other = (Context)o;
        if (this.isFluent() != other.isFluent()) {
            return false;
        }
        if (this.isEditor() != other.isEditor()) {
            return false;
        }
        ProcessingEnvironment this$env = this.getEnv();
        ProcessingEnvironment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        Element this$element = this.getElement();
        Element other$element = other.getElement();
        if (this$element == null ? other$element != null : !((Object)this$element).equals(other$element)) {
            return false;
        }
        TypeName this$r = this.getR();
        TypeName other$r = other.getR();
        if (this$r == null ? other$r != null : !this$r.equals(other$r)) {
            return false;
        }
        ClassName this$root = this.getRoot();
        ClassName other$root = other.getRoot();
        if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
            return false;
        }
        FieldSpec this$sharedPreferences = this.getSharedPreferences();
        FieldSpec other$sharedPreferences = other.getSharedPreferences();
        return !(this$sharedPreferences == null ? other$sharedPreferences != null : !this$sharedPreferences.equals(other$sharedPreferences));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFluent() ? 79 : 97);
        result = result * 59 + (this.isEditor() ? 79 : 97);
        ProcessingEnvironment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        Element $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : ((Object)$element).hashCode());
        TypeName $r = this.getR();
        result = result * 59 + ($r == null ? 43 : $r.hashCode());
        ClassName $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        FieldSpec $sharedPreferences = this.getSharedPreferences();
        result = result * 59 + ($sharedPreferences == null ? 43 : $sharedPreferences.hashCode());
        return result;
    }

    public String toString() {
        return "Context(env=" + this.getEnv() + ", element=" + this.getElement() + ", r=" + this.getR() + ", root=" + this.getRoot() + ", sharedPreferences=" + this.getSharedPreferences() + ", fluent=" + this.isFluent() + ", editor=" + this.isEditor() + ")";
    }

    public Map<String, String> getOptions() {
        return this.getEnv().getOptions();
    }

    public Messager getMessager() {
        return this.getEnv().getMessager();
    }

    public Filer getFiler() {
        return this.getEnv().getFiler();
    }

    public Elements getElementUtils() {
        return this.getEnv().getElementUtils();
    }

    public Types getTypeUtils() {
        return this.getEnv().getTypeUtils();
    }

    public SourceVersion getSourceVersion() {
        return this.getEnv().getSourceVersion();
    }

    public Locale getLocale() {
        return this.getEnv().getLocale();
    }
}

