/*
 * Decompiled with CFR 0.152.
 */
package eu.jonahbauer.android.preference.annotations.serializer;

import eu.jonahbauer.android.preference.annotations.serializer.PreferenceSerializationException;
import eu.jonahbauer.android.preference.annotations.serializer.PreferenceSerializer;

public final class EnumPreferenceSerializer<T extends Enum<T>>
implements PreferenceSerializer<T, String> {
    private final Class<T> clazz;

    public EnumPreferenceSerializer(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public String serialize(T value) {
        if (value == null) {
            return null;
        }
        return ((Enum)value).name();
    }

    @Override
    public T deserialize(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Enum.valueOf(this.clazz, value);
        }
        catch (IllegalArgumentException e) {
            throw new PreferenceSerializationException(e);
        }
    }
}

