/*
 * Decompiled with CFR 0.152.
 */
package eu.jonahbauer.android.preference.annotations.processor.model;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import eu.jonahbauer.android.preference.annotations.Preference;
import eu.jonahbauer.android.preference.annotations.processor.StringUtils;
import eu.jonahbauer.android.preference.annotations.processor.model.Context;
import eu.jonahbauer.android.preference.annotations.processor.model.SerializerSpec;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class PreferenceSpec {
    private static final Map<String, String> GETTER = Map.of("boolean", "var value = $N.getBoolean($N, $L)", "byte", "var value = (byte) $N.getInt($N, $L)", "char", "var value = (char) $N.getInt($N, $L)", "short", "var value = (short) $N.getInt($N, $L)", "int", "var value = $N.getInt($N, $L)", "long", "var value = $N.getLong($N, $L)", "float", "var value = $N.getFloat($N, $L)", "double", "var value = Double.longBitsToDouble($N.getLong($N, $L))", "java.lang.String", "var value = $N.getString($N, $S)", "java.util.Set<java.lang.String>", "var value = $N.getStringSet($N, $L)");
    private static final Map<String, String> SETTER = Map.of("boolean", "$N.edit().putBoolean($N, serializedValue).apply()", "byte", "$N.edit().putInt($N, (int) serializedValue).apply()", "char", "$N.edit().putInt($N, (int) serializedValue).apply()", "short", "$N.edit().putInt($N, (int) serializedValue).apply()", "int", "$N.edit().putInt($N, (int) serializedValue).apply()", "long", "$N.edit().putLong($N, serializedValue).apply()", "float", "$N.edit().putFloat($N, serializedValue).apply()", "double", "$N.edit().putLong($N, Double.doubleToRawLongBits(serializedValue)).apply()", "java.lang.String", "$N.edit().putString($N, serializedValue).apply()", "java.util.Set<java.lang.String>", "$N.edit().putStringSet($N, serializedValue).apply()");
    private final String name;
    private final FieldSpec key;
    private final FieldSpec serializer;
    private final MethodSpec getter;
    private final MethodSpec setter;
    private final TypeMirror serializedType;
    private final TypeMirror deserializedType;

    public static PreferenceSpec create(Context context, int index, Preference preference) {
        if (!PreferenceSpec.check(context, preference)) {
            return null;
        }
        SerializerSpec serializerSpec = SerializerSpec.create(context, index, preference);
        if (!PreferenceSpec.checkType(context, serializerSpec.getSerializedType())) {
            context.error("Unsupported preference type: %s", serializerSpec.getSerializedType());
            return null;
        }
        FieldSpec key = FieldSpec.builder(String.class, (String)("key$" + index), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        return new PreferenceSpec(context, preference, key, serializerSpec);
    }

    public PreferenceSpec(Context context, Preference preference, FieldSpec key, SerializerSpec serializerSpec) {
        this.name = StringUtils.getMethodName(preference.name());
        this.key = key;
        this.serializer = serializerSpec.getSerializer();
        this.serializedType = serializerSpec.getSerializedType();
        this.deserializedType = serializerSpec.getDeserializedType();
        FieldSpec sharedPreferences = context.getSharedPreferences();
        boolean fluent = context.isFluent();
        Object defaultValue = PreferenceSpec.getDefaultValue(preference, this.serializedType);
        String description = preference.description();
        if (this.serializedType.getKind() == TypeKind.VOID) {
            this.getter = null;
            this.setter = null;
        } else {
            MethodSpec.Builder getter = MethodSpec.methodBuilder((String)StringUtils.getGetterName(this.name, this.serializedType, fluent)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)this.deserializedType)).addStatement(GETTER.get(this.serializedType.toString()), new Object[]{sharedPreferences, key, defaultValue}).addStatement(this.serializer == null ? "return value" : "return $N.deserialize(value)", new Object[]{this.serializer});
            PreferenceSpec.addJavadoc(getter, description, this.serializedType, defaultValue);
            this.getter = getter.build();
            MethodSpec.Builder setter = MethodSpec.methodBuilder((String)StringUtils.getSetterName(this.name, fluent)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.get((TypeMirror)this.deserializedType), "value", new Modifier[0]).addStatement(this.serializer == null ? "var serializedValue = value" : "var serializedValue = $N.serialize(value)", new Object[]{this.serializer}).addStatement(SETTER.get(this.serializedType.toString()), new Object[]{sharedPreferences, key});
            PreferenceSpec.addJavadoc(setter, description, this.serializedType, defaultValue);
            this.setter = setter.build();
        }
    }

    public void apply(TypeSpec.Builder builder) {
        if (this.getter != null) {
            builder.addMethod(this.getter);
        }
        if (this.setter != null) {
            builder.addMethod(this.setter);
        }
        if (this.serializer != null) {
            builder.addField(this.serializer);
        }
        builder.addField(this.key);
    }

    private static boolean check(Context context, Preference preference) {
        if (!StringUtils.isJavaIdentifier(preference.name())) {
            context.error("Illegal preference name: %s", preference.name());
            return false;
        }
        return true;
    }

    private static boolean checkType(Context context, TypeMirror type) {
        switch (type.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case VOID: {
                return true;
            }
            case DECLARED: {
                return context.isSame(type, String.class, new Class[0]) || context.isSame(type, Set.class, String.class);
            }
        }
        return false;
    }

    private static Object getDefaultValue(Preference preference, TypeMirror type) {
        if (!"__NO_DEFAULT_VALUE__".equals(preference.defaultValue())) {
            return preference.defaultValue();
        }
        switch (type.getKind()) {
            case BOOLEAN: {
                return false;
            }
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return 0;
            }
            case VOID: 
            case DECLARED: 
            case ARRAY: 
            case NULL: {
                return null;
            }
        }
        throw new RuntimeException();
    }

    private static void addJavadoc(MethodSpec.Builder method, String description, TypeMirror type, Object defaultValue) {
        if (description.isEmpty()) {
            return;
        }
        method.addJavadoc(description, new Object[0]);
        if (type.getKind() == TypeKind.DECLARED && String.class.getName().equals(type.toString())) {
            method.addJavadoc("\n(default: $S)", new Object[]{defaultValue});
        } else {
            method.addJavadoc("\n(default: $L)", new Object[]{defaultValue});
        }
    }

    public String getName() {
        return this.name;
    }

    public FieldSpec getKey() {
        return this.key;
    }

    public FieldSpec getSerializer() {
        return this.serializer;
    }

    public MethodSpec getGetter() {
        return this.getter;
    }

    public MethodSpec getSetter() {
        return this.setter;
    }

    public TypeMirror getSerializedType() {
        return this.serializedType;
    }

    public TypeMirror getDeserializedType() {
        return this.deserializedType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreferenceSpec)) {
            return false;
        }
        PreferenceSpec other = (PreferenceSpec)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        FieldSpec this$key = this.getKey();
        FieldSpec other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        FieldSpec this$serializer = this.getSerializer();
        FieldSpec other$serializer = other.getSerializer();
        if (this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer)) {
            return false;
        }
        MethodSpec this$getter = this.getGetter();
        MethodSpec other$getter = other.getGetter();
        if (this$getter == null ? other$getter != null : !this$getter.equals(other$getter)) {
            return false;
        }
        MethodSpec this$setter = this.getSetter();
        MethodSpec other$setter = other.getSetter();
        if (this$setter == null ? other$setter != null : !this$setter.equals(other$setter)) {
            return false;
        }
        TypeMirror this$serializedType = this.getSerializedType();
        TypeMirror other$serializedType = other.getSerializedType();
        if (this$serializedType == null ? other$serializedType != null : !((Object)this$serializedType).equals(other$serializedType)) {
            return false;
        }
        TypeMirror this$deserializedType = this.getDeserializedType();
        TypeMirror other$deserializedType = other.getDeserializedType();
        return !(this$deserializedType == null ? other$deserializedType != null : !((Object)this$deserializedType).equals(other$deserializedType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        FieldSpec $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        FieldSpec $serializer = this.getSerializer();
        result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
        MethodSpec $getter = this.getGetter();
        result = result * 59 + ($getter == null ? 43 : $getter.hashCode());
        MethodSpec $setter = this.getSetter();
        result = result * 59 + ($setter == null ? 43 : $setter.hashCode());
        TypeMirror $serializedType = this.getSerializedType();
        result = result * 59 + ($serializedType == null ? 43 : ((Object)$serializedType).hashCode());
        TypeMirror $deserializedType = this.getDeserializedType();
        result = result * 59 + ($deserializedType == null ? 43 : ((Object)$deserializedType).hashCode());
        return result;
    }

    public String toString() {
        return "PreferenceSpec(name=" + this.getName() + ", key=" + this.getKey() + ", serializer=" + this.getSerializer() + ", getter=" + this.getGetter() + ", setter=" + this.getSetter() + ", serializedType=" + this.getSerializedType() + ", deserializedType=" + this.getDeserializedType() + ")";
    }
}

