/*
 * Decompiled with CFR 0.152.
 */
package eu.jonahbauer.android.preference.annotations.processor.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import eu.jonahbauer.android.preference.annotations.processor.ClassNames;
import eu.jonahbauer.android.preference.annotations.processor.StringUtils;
import eu.jonahbauer.android.preference.annotations.processor.model.Context;
import eu.jonahbauer.android.preference.annotations.processor.model.PreferenceSpec;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class PreferenceEditorSpec {
    private static final String EDITOR_CLASS_NAME = "Editor";
    private static final String EDITOR_FIELD_NAME = "editor";
    private static final Map<String, String> SETTER = Map.of("boolean", "$N.putBoolean($N, serializedValue)", "byte", "$N.putInt($N, (int) serializedValue)", "char", "$N.putInt($N, (int) serializedValue)", "short", "$N.putInt($N, (int) serializedValue)", "int", "$N.putInt($N, (int) serializedValue)", "long", "$N.putLong($N, serializedValue)", "float", "$N.putFloat($N, serializedValue)", "double", "$N.putLong($N, Double.doubleToRawLongBits(serializedValue))", "java.lang.String", "$N.putString($N, serializedValue)", "java.util.Set<java.lang.String>", "$N.putStringSet($N, serializedValue)");
    private final MethodSpec accessor;
    private final TypeSpec type;

    public static PreferenceEditorSpec create(Context context, ClassName parent, List<PreferenceSpec> preferences) {
        ClassName name = parent.nestedClass(EDITOR_CLASS_NAME);
        FieldSpec editor = FieldSpec.builder((TypeName)ClassNames.SHARED_PREFERENCES_EDITOR, (String)EDITOR_FIELD_NAME, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("sharedPreferences.edit()", new Object[0]).build();
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        TypeSpec.Builder type = TypeSpec.classBuilder((ClassName)name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(constructor).addField(editor);
        for (PreferenceSpec preference : preferences) {
            MethodSpec setter = PreferenceEditorSpec.setter(context, name, preference, editor);
            if (setter == null) continue;
            type.addMethod(setter);
        }
        type.addMethod(PreferenceEditorSpec.apply(editor));
        type.addMethod(PreferenceEditorSpec.commit(editor));
        return new PreferenceEditorSpec(PreferenceEditorSpec.accessor(name), type.build());
    }

    public void apply(TypeSpec.Builder builder) {
        builder.addMethod(this.accessor);
        builder.addType(this.type);
    }

    private static MethodSpec setter(Context context, ClassName name, PreferenceSpec preference, FieldSpec editor) {
        TypeMirror serializedType = preference.getSerializedType();
        if (serializedType.getKind() == TypeKind.VOID) {
            return null;
        }
        TypeMirror deserializedType = preference.getDeserializedType();
        FieldSpec serializer = preference.getSerializer();
        FieldSpec key = preference.getKey();
        String methodName = StringUtils.getSetterName(preference.getName(), context.isFluent());
        return MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)name).addParameter(TypeName.get((TypeMirror)deserializedType), "value", new Modifier[0]).addStatement(serializer == null ? "var serializedValue = value" : "var serializedValue = $N.serialize(value)", new Object[]{serializer}).addStatement(SETTER.get(serializedType.toString()), new Object[]{editor, key}).addStatement("return this", new Object[0]).build();
    }

    private static MethodSpec apply(FieldSpec editor) {
        return MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$N.apply()", new Object[]{editor}).addJavadoc("Commit your preferences changes back from this Editor to the {@code SharedPreferences} object it is editing. This atomically performs the requested modifications, replacing whatever is currently in the SharedPreferences. ", new Object[0]).addJavadoc("\n@see $T#apply()", new Object[]{ClassNames.SHARED_PREFERENCES_EDITOR}).build();
    }

    private static MethodSpec commit(FieldSpec editor) {
        return MethodSpec.methodBuilder((String)"commit").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addStatement("return $N.commit()", new Object[]{editor}).addJavadoc("Commit your preferences changes back from this Editor to the {@code SharedPreferences} object it is editing. This atomically performs the requested modifications, replacing whatever is currently in the SharedPreferences.", new Object[0]).addJavadoc("\n@see $T#commit()", new Object[]{ClassNames.SHARED_PREFERENCES_EDITOR}).build();
    }

    private static MethodSpec accessor(ClassName name) {
        return MethodSpec.methodBuilder((String)"edit").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)name).addStatement("return new $T()", new Object[]{name}).addJavadoc("Create a new Editor for these preferences, through which you can make modifications to the data in the preferences and atomically commit those changes back to the SharedPreferences object.", new Object[0]).addJavadoc("\n@see $T#edit()", new Object[]{ClassNames.SHARED_PREFERENCES}).build();
    }

    public PreferenceEditorSpec(MethodSpec accessor, TypeSpec type) {
        this.accessor = accessor;
        this.type = type;
    }

    public MethodSpec getAccessor() {
        return this.accessor;
    }

    public TypeSpec getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreferenceEditorSpec)) {
            return false;
        }
        PreferenceEditorSpec other = (PreferenceEditorSpec)o;
        MethodSpec this$accessor = this.getAccessor();
        MethodSpec other$accessor = other.getAccessor();
        if (this$accessor == null ? other$accessor != null : !this$accessor.equals(other$accessor)) {
            return false;
        }
        TypeSpec this$type = this.getType();
        TypeSpec other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MethodSpec $accessor = this.getAccessor();
        result = result * 59 + ($accessor == null ? 43 : $accessor.hashCode());
        TypeSpec $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "PreferenceEditorSpec(accessor=" + this.getAccessor() + ", type=" + this.getType() + ")";
    }
}

