/*
 * Decompiled with CFR 0.152.
 */
package eu.joaocosta.minart.backend;

import eu.joaocosta.minart.audio.AudioClip;
import eu.joaocosta.minart.audio.AudioPlayer;
import eu.joaocosta.minart.audio.AudioQueue;
import eu.joaocosta.minart.audio.AudioWave;
import eu.joaocosta.minart.audio.LowLevelAudioPlayer;
import eu.joaocosta.minart.backend.subsystem.LowLevelSubsystem;
import eu.joaocosta.minart.runtime.LoopFrequency$;
import java.io.Serializable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001B\u000b\u0017\u0001}AQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013%\u0011\u0007\u0003\u00046\u0001\u0001\u0006IA\r\u0005\nm\u0001\u0001\r\u00111A\u0005\n]B\u0011B\u0011\u0001A\u0002\u0003\u0007I\u0011B\"\t\u0013%\u0003\u0001\u0019!A!B\u0013A\u0004\"\u0003&\u0001\u0001\u0004\u0005\r\u0011\"\u0003L\u0011%\u0019\u0006\u00011AA\u0002\u0013%A\u000bC\u0005W\u0001\u0001\u0007\t\u0011)Q\u0005\u0019\")q\u000b\u0001C\t1\")\u0011\f\u0001C\t5\")A\r\u0001C\t1\"9Q\r\u0001b\u0001\n\u00171\u0007BB7\u0001A\u0003%q\rC\u0003o\u0001\u0011%q\u000eC\u0003t\u0001\u0011\u0005A\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\u0007\u007f\u0002!\t!!\u0003\t\r\u00055\u0001\u0001\"\u0001Y\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001f\u0011qBS1wC\u0006+H-[8QY\u0006LXM\u001d\u0006\u0003/a\tqAY1dW\u0016tGM\u0003\u0002\u001a5\u00051Q.\u001b8beRT!a\u0007\u000f\u0002\u0013)|\u0017m\\2pgR\f'\"A\u000f\u0002\u0005\u0015,8\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(U5\t\u0001F\u0003\u0002*1\u0005)\u0011-\u001e3j_&\u00111\u0006\u000b\u0002\u0014\u0019><H*\u001a<fY\u0006+H-[8QY\u0006LXM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0002\"a\f\u0001\u000e\u0003Y\t!\u0003\u001d:fK6\u0004H/\u001b<f\u0007\u0006dGNY1dWV\t!\u0007\u0005\u0002\"g%\u0011AG\t\u0002\u0005\u0019>tw-A\nqe\u0016,W\u000e\u001d;jm\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007%\u0001\bt_V\u00148-\u001a#bi\u0006d\u0015N\\3\u0016\u0003a\u0002\"!\u000f!\u000e\u0003iR!a\u000f\u001f\u0002\u000fM\fW\u000e\u001d7fI*\u0011QHP\u0001\u0006g>,h\u000e\u001a\u0006\u0002\u007f\u0005)!.\u0019<bq&\u0011\u0011I\u000f\u0002\u000f'>,(oY3ECR\fG*\u001b8f\u0003I\u0019x.\u001e:dK\u0012\u000bG/\u0019'j]\u0016|F%Z9\u0015\u0005\u0011;\u0005CA\u0011F\u0013\t1%E\u0001\u0003V]&$\bb\u0002%\u0006\u0003\u0003\u0005\r\u0001O\u0001\u0004q\u0012\n\u0014aD:pkJ\u001cW\rR1uC2Kg.\u001a\u0011\u0002\u0013Ad\u0017-_)vKV,W#\u0001'\u0011\u00055\u0003fBA\u0014O\u0013\ty\u0005&\u0001\u0006Bk\u0012Lw.U;fk\u0016L!!\u0015*\u0003-5+H\u000e^5DQ\u0006tg.\u001a7Bk\u0012Lw.U;fk\u0016T!a\u0014\u0015\u0002\u001bAd\u0017-_)vKV,w\fJ3r)\t!U\u000bC\u0004I\u0011\u0005\u0005\t\u0019\u0001'\u0002\u0015Ad\u0017-_)vKV,\u0007%\u0001\u0006v]N\fg-Z%oSR$\u0012\u0001R\u0001\u0014k:\u001c\u0018MZ3BaBd\u0017pU3ui&twm\u001d\u000b\u00037\n\u0004\"\u0001X0\u000f\u0005\u001dj\u0016B\u00010)\u0003-\tU\u000fZ5p!2\f\u00170\u001a:\n\u0005\u0001\f'\u0001C*fiRLgnZ:\u000b\u0005yC\u0003\"B2\f\u0001\u0004Y\u0016\u0001C:fiRLgnZ:\u0002\u001bUt7/\u00194f\t\u0016\u001cHO]8z\u0003\t)7-F\u0001h!\tA7.D\u0001j\u0015\tQ'%\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001\\5\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u0005A1-\u00197mE\u0006\u001c7\u000eF\u0001q!\rA\u0017\u000fR\u0005\u0003e&\u0014aAR;ukJ,\u0017\u0001\u00029mCf$2\u0001R;{\u0011\u00151\b\u00031\u0001x\u0003\u0011\u0019G.\u001b9\u0011\u0005\u001dB\u0018BA=)\u0005%\tU\u000fZ5p\u00072L\u0007\u000fC\u0003|!\u0001\u0007A0A\u0004dQ\u0006tg.\u001a7\u0011\u0005\u0005j\u0018B\u0001@#\u0005\rIe\u000e^\u0001\nSN\u0004F.Y=j]\u001e$\"!a\u0001\u0011\u0007\u0005\n)!C\u0002\u0002\b\t\u0012qAQ8pY\u0016\fg\u000e\u0006\u0003\u0002\u0004\u0005-\u0001\"B>\u0013\u0001\u0004a\u0018\u0001B:u_B$2\u0001RA\t\u0011\u0015YH\u00031\u0001}\u0001")
public class JavaAudioPlayer
implements LowLevelAudioPlayer {
    private final long preemptiveCallback;
    private SourceDataLine sourceDataLine;
    private AudioQueue.MultiChannelAudioQueue playQueue;
    private final ExecutionContext ec;
    private AudioPlayer.Settings defaultSettings;
    private AudioPlayer.Settings _settings;
    private boolean eu$joaocosta$minart$backend$subsystem$LowLevelSubsystem$Simple$$_isCreated;
    private volatile boolean bitmap$0;

    public Object settings() {
        return LowLevelSubsystem.Simple.settings$((LowLevelSubsystem.Simple)this);
    }

    public boolean isCreated() {
        return LowLevelSubsystem.Simple.isCreated$((LowLevelSubsystem.Simple)this);
    }

    public LowLevelSubsystem.Simple init(Object settings) {
        return LowLevelSubsystem.Simple.init$((LowLevelSubsystem.Simple)this, (Object)settings);
    }

    public void changeSettings(Object newSettings) {
        LowLevelSubsystem.Simple.changeSettings$((LowLevelSubsystem.Simple)this, (Object)newSettings);
    }

    public void close() {
        LowLevelSubsystem.Simple.close$((LowLevelSubsystem.Simple)this);
    }

    public <SettingsB, SubsystemB extends LowLevelSubsystem<SettingsB>> LowLevelSubsystem.Composite<AudioPlayer.Settings, SettingsB, LowLevelSubsystem<AudioPlayer.Settings>, SubsystemB> $plus$plus(SubsystemB that) {
        return LowLevelSubsystem.$plus$plus$((LowLevelSubsystem)this, that);
    }

    public void play(AudioClip clip) {
        AudioPlayer.play$((AudioPlayer)this, (AudioClip)clip);
    }

    public void play(AudioWave wave) {
        AudioPlayer.play$((AudioPlayer)this, (AudioWave)wave);
    }

    public void play(AudioWave wave, int channel) {
        AudioPlayer.play$((AudioPlayer)this, (AudioWave)wave, (int)channel);
    }

    private AudioPlayer.Settings defaultSettings$lzycompute() {
        JavaAudioPlayer javaAudioPlayer = this;
        synchronized (javaAudioPlayer) {
            if (!this.bitmap$0) {
                this.defaultSettings = LowLevelAudioPlayer.defaultSettings$((LowLevelAudioPlayer)this);
                this.bitmap$0 = true;
            }
        }
        return this.defaultSettings;
    }

    public AudioPlayer.Settings defaultSettings() {
        if (!this.bitmap$0) {
            return this.defaultSettings$lzycompute();
        }
        return this.defaultSettings;
    }

    public AudioPlayer.Settings _settings() {
        return this._settings;
    }

    public void _settings_$eq(AudioPlayer.Settings x$1) {
        this._settings = x$1;
    }

    public boolean eu$joaocosta$minart$backend$subsystem$LowLevelSubsystem$Simple$$_isCreated() {
        return this.eu$joaocosta$minart$backend$subsystem$LowLevelSubsystem$Simple$$_isCreated;
    }

    public void eu$joaocosta$minart$backend$subsystem$LowLevelSubsystem$Simple$$_isCreated_$eq(boolean x$1) {
        this.eu$joaocosta$minart$backend$subsystem$LowLevelSubsystem$Simple$$_isCreated = x$1;
    }

    private long preemptiveCallback() {
        return this.preemptiveCallback;
    }

    private SourceDataLine sourceDataLine() {
        return this.sourceDataLine;
    }

    private void sourceDataLine_$eq(SourceDataLine x$1) {
        this.sourceDataLine = x$1;
    }

    private AudioQueue.MultiChannelAudioQueue playQueue() {
        return this.playQueue;
    }

    private void playQueue_$eq(AudioQueue.MultiChannelAudioQueue x$1) {
        this.playQueue = x$1;
    }

    public void unsafeInit() {
    }

    public AudioPlayer.Settings unsafeApplySettings(AudioPlayer.Settings settings) {
        AudioFormat format = new AudioFormat(settings.sampleRate(), 16, 1, true, false);
        this.playQueue_$eq(new AudioQueue.MultiChannelAudioQueue(settings.sampleRate()));
        this.sourceDataLine_$eq(AudioSystem.getSourceDataLine(format));
        this.sourceDataLine().open(format, settings.bufferSize());
        this.sourceDataLine().start();
        return settings;
    }

    public void unsafeDestroy() {
        this.stop();
        this.sourceDataLine().close();
    }

    private ExecutionContext ec() {
        return this.ec;
    }

    private Future<BoxedUnit> callback() {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            while (this.playQueue().nonEmpty()) {
                Object object;
                int available = this.sourceDataLine().available();
                if (available > 0) {
                    int samples = Math.min(this.playQueue().size(), available / 2);
                    byte[] buf = (byte[])scala.package$.MODULE$.Iterator().fill(samples, (Function0 & Serializable)() -> {
                        double next = this.playQueue().dequeue();
                        int n = (int)(Math.min(Math.max(-1.0, next), 1.0) * (double)Short.MAX_VALUE);
                        return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)}));
                    }).flatten(Predef$.MODULE$.$conforms()).toArray((ClassTag)ClassTag$.MODULE$.Byte());
                    this.sourceDataLine().write(buf, 0, samples * 2);
                    int bufferedMillis = 1000 * samples / ((AudioPlayer.Settings)this.settings()).sampleRate();
                    object = package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> Thread.sleep(Math.max(0L, (long)bufferedMillis - this.preemptiveCallback())));
                    continue;
                }
                object = BoxedUnit.UNIT;
            }
        }, this.ec());
    }

    public void play(AudioClip clip, int channel) {
        boolean alreadyPlaying = this.isPlaying();
        this.playQueue().enqueue(clip, channel);
        if (!alreadyPlaying) {
            this.callback();
            return;
        }
    }

    public boolean isPlaying() {
        return this.playQueue().nonEmpty();
    }

    public boolean isPlaying(int channel) {
        return this.playQueue().nonEmpty(channel);
    }

    public void stop() {
        this.playQueue().clear();
    }

    public void stop(int channel) {
        this.playQueue().clear(channel);
    }

    public JavaAudioPlayer() {
        AudioPlayer.$init$((AudioPlayer)this);
        LowLevelSubsystem.$init$((LowLevelSubsystem)this);
        LowLevelSubsystem.Simple.$init$((LowLevelSubsystem.Simple)this);
        LowLevelAudioPlayer.$init$((LowLevelAudioPlayer)this);
        this.preemptiveCallback = LoopFrequency$.MODULE$.hz15().millis();
        this.ec = ExecutionContext$.MODULE$.global();
    }
}

