/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.io;

import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.simple.SimpleVariantGraphSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

@Provider
@Produces(value={"application/graphml+xml"})
public class VariantGraphGraphMLMessageBodyWriter
implements MessageBodyWriter<VariantGraph> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return VariantGraph.class.isAssignableFrom(type);
    }

    public long getSize(VariantGraph variantGraph, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(VariantGraph graph, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        XMLStreamWriter xml = null;
        try {
            httpHeaders.add((Object)"Content-Type", (Object)"application/graphml+xml");
            try (OutputStream responseStream = entityStream;){
                xml = XMLOutputFactory.newInstance().createXMLStreamWriter(responseStream);
                xml.writeStartDocument();
                new SimpleVariantGraphSerializer(graph).toGraphML(xml);
                xml.writeEndDocument();
            }
            finally {
                if (xml != null) {
                    xml.close();
                }
            }
        }
        catch (XMLStreamException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

