/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.io;

import eu.interedition.collatex.CollationAlgorithm;
import eu.interedition.collatex.CollationAlgorithmFactory;
import eu.interedition.collatex.dekker.InspectableCollationAlgorithm;
import eu.interedition.collatex.io.VariantGraphJSONMessageBodyWriter;
import eu.interedition.collatex.matching.EditDistanceTokenComparator;
import eu.interedition.collatex.matching.EqualityTokenComparator;
import eu.interedition.collatex.simple.SimpleCollation;
import eu.interedition.collatex.simple.SimplePatternTokenizer;
import eu.interedition.collatex.simple.SimpleToken;
import eu.interedition.collatex.simple.SimpleTokenNormalizers;
import eu.interedition.collatex.simple.SimpleWitness;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/json"})
public class SimpleCollationJSONMessageBodyReader
implements MessageBodyReader<SimpleCollation> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return SimpleCollation.class.isAssignableFrom(type);
    }

    public SimpleCollation readFrom(Class<SimpleCollation> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try (JsonReader reader = Json.createReader((InputStream)entityStream);){
            JsonArray witnessesNode;
            JsonStructure collationNode = reader.read();
            if (collationNode.getValueType() != JsonValue.ValueType.OBJECT) {
                throw new IOException("Expecting JSON object");
            }
            JsonObject collationObject = (JsonObject)collationNode;
            try {
                witnessesNode = collationObject.getJsonArray("witnesses");
            }
            catch (ClassCastException e) {
                throw new IOException("Expecting 'witnesses' array");
            }
            ArrayList<SimpleWitness> witnesses = new ArrayList<SimpleWitness>(witnessesNode.size());
            for (JsonValue witnessNode : witnessesNode) {
                String witnessId;
                if (witnessNode.getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IOException("Expecting witness object");
                }
                JsonObject witnessObject = (JsonObject)witnessNode;
                try {
                    witnessId = witnessObject.getString("id").trim();
                }
                catch (ClassCastException e) {
                    throw new IOException("Expected textual witness 'id'");
                }
                if (witnessId.length() == 0) {
                    throw new IOException("Empty witness 'id' encountered");
                }
                SimpleWitness witness = new SimpleWitness(witnessId);
                if (witnesses.contains(witness)) {
                    throw new IOException(String.format("Duplicate sigil for witness '%s", witness));
                }
                JsonValue contentNode = (JsonValue)witnessObject.get((Object)"content");
                JsonValue tokensNode = (JsonValue)witnessObject.get((Object)"tokens");
                if (contentNode == null && tokensNode == null) {
                    throw new IOException(String.format("Expected either 'tokens' or 'content' field in witness \"%s\"", witness));
                }
                if (tokensNode != null) {
                    if (tokensNode.getValueType() != JsonValue.ValueType.ARRAY) {
                        throw new IOException(String.format("Expected 'tokens' array in witness \"%s\"", witness));
                    }
                    JsonArray tokensArray = (JsonArray)tokensNode;
                    ArrayList<VariantGraphJSONMessageBodyWriter.Token> tokens = new ArrayList<VariantGraphJSONMessageBodyWriter.Token>(tokensArray.size());
                    for (JsonValue tokenNode : tokensArray) {
                        String normalizedTokenContent;
                        String tokenContent;
                        if (tokenNode.getValueType() != JsonValue.ValueType.OBJECT) {
                            throw new IOException(String.format("Expected token object in 'tokens' field in witness \"%s\"", witness));
                        }
                        JsonObject tokenObject = (JsonObject)tokenNode;
                        try {
                            tokenContent = tokenObject.getString("t");
                        }
                        catch (ClassCastException | NullPointerException e) {
                            throw new IOException(String.format("Expected textual token content field 't' in witness \"%s\"", witness));
                        }
                        if (tokenObject.containsKey((Object)"n")) {
                            try {
                                normalizedTokenContent = tokenObject.getString("n");
                            }
                            catch (ClassCastException e) {
                                throw new IOException(String.format("Expected textual normalized token content in witness \"%s\"", witness));
                            }
                        } else {
                            normalizedTokenContent = (String)SimpleWitness.TOKEN_NORMALIZER.apply(tokenContent);
                        }
                        if (normalizedTokenContent == null || normalizedTokenContent.length() == 0) {
                            throw new IOException(String.format("Empty token encountered in witness \"%s\"", witness));
                        }
                        tokens.add(new VariantGraphJSONMessageBodyWriter.Token(witness, tokenContent, normalizedTokenContent, tokenObject));
                    }
                    witness.setTokens(tokens);
                } else {
                    if (contentNode.getValueType() != JsonValue.ValueType.STRING) {
                        throw new IOException(String.format("Expected 'content' text field in witness \"%s\"", witness));
                    }
                    witness.setTokenContents((Stream)SimplePatternTokenizer.BY_WS_OR_PUNCT.apply(((JsonString)contentNode).getString()), SimpleTokenNormalizers.LC_TRIM_WS);
                }
                witnesses.add(witness);
            }
            if (witnesses.isEmpty()) {
                throw new IOException("No witnesses in collation");
            }
            EqualityTokenComparator tokenComparator = null;
            JsonValue tokenComparatorNode = (JsonValue)collationObject.get((Object)"tokenComparator");
            if (tokenComparatorNode != null && tokenComparatorNode.getValueType() == JsonValue.ValueType.OBJECT) {
                JsonObject tokenComparatorObject = (JsonObject)tokenComparatorNode;
                try {
                    if ("levenshtein".equals(tokenComparatorObject.getString("type"))) {
                        int configuredDistance = tokenComparatorObject.getInt("distance", 0);
                        tokenComparator = new EditDistanceTokenComparator(configuredDistance == 0 ? 1 : configuredDistance);
                    }
                }
                catch (ClassCastException configuredDistance) {
                    // empty catch block
                }
            }
            if (tokenComparator == null) {
                tokenComparator = new EqualityTokenComparator();
            }
            CollationAlgorithm collationAlgorithm = null;
            JsonValue collationAlgorithmNode = (JsonValue)collationObject.get((Object)"algorithm");
            if (collationAlgorithmNode != null && collationAlgorithmNode.getValueType() == JsonValue.ValueType.STRING) {
                String collationAlgorithmValue = ((JsonString)collationAlgorithmNode).getString();
                if ("needleman-wunsch".equalsIgnoreCase(collationAlgorithmValue)) {
                    collationAlgorithm = CollationAlgorithmFactory.needlemanWunsch((Comparator)tokenComparator);
                } else if ("gst".equalsIgnoreCase(collationAlgorithmValue)) {
                    collationAlgorithm = CollationAlgorithmFactory.greedyStringTiling((Comparator)tokenComparator, (int)2);
                } else if ("medite".equalsIgnoreCase(collationAlgorithmValue)) {
                    collationAlgorithm = CollationAlgorithmFactory.medite((Comparator)tokenComparator, (Function)SimpleToken.TOKEN_MATCH_EVALUATOR);
                }
            }
            if (collationAlgorithm == null) {
                collationAlgorithm = CollationAlgorithmFactory.dekker((Comparator)tokenComparator);
            }
            boolean joined = true;
            try {
                joined = collationObject.getBoolean("joined", true);
            }
            catch (ClassCastException contentNode) {
                // empty catch block
            }
            if (collationAlgorithm instanceof InspectableCollationAlgorithm) {
                boolean mergeTranspositions = true;
                try {
                    mergeTranspositions = collationObject.getBoolean("transpositions", true);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                ((InspectableCollationAlgorithm)collationAlgorithm).setMergeTranspositions(mergeTranspositions);
            }
            SimpleCollation simpleCollation = new SimpleCollation(witnesses, collationAlgorithm, joined);
            return simpleCollation;
        }
    }
}

