/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.http;

import eu.interedition.collatex.simple.SimpleCollation;
import eu.interedition.collatex.simple.SimpleToken;
import eu.interedition.collatex.simple.SimpleWitness;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

@Path(value="/")
public class CollateResource {
    private final File staticPath;
    private final Date initial = new Date();
    private final int maxCollationSize;
    private final ExecutorService executor;

    public CollateResource(String staticPath, int maxParallelCollations, int maxCollationSize) {
        this.staticPath = staticPath == null || "".equals(staticPath) ? null : new File(staticPath);
        this.maxCollationSize = maxCollationSize;
        this.executor = Executors.newFixedThreadPool(maxParallelCollations, (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    public Response index(@Context Request request) throws IOException {
        return this.stream(request, "index.html");
    }

    @GET
    @Path(value="darwin")
    public Response darwin(@Context Request request) throws IOException {
        return this.stream(request, "darwin.html");
    }

    @Path(value="collate")
    @GET
    public Response noContent(@Context HttpHeaders hh) throws NoSuchMethodException {
        return this.corsSupport(hh, Response.noContent()).build();
    }

    @Path(value="collate")
    @OPTIONS
    public Response collateOptions(@Context HttpHeaders hh) {
        return this.corsSupport(hh, Response.ok()).build();
    }

    @Path(value="collate")
    @POST
    public Response collate(SimpleCollation collation, @Context HttpHeaders hh) throws ExecutionException, InterruptedException {
        if (this.maxCollationSize > 0) {
            for (SimpleWitness witness : collation.getWitnesses()) {
                int witnessLength = witness.getTokens().stream().filter(t -> t instanceof SimpleToken).map(t -> (SimpleToken)t).collect(Collectors.summingInt(t -> t.getContent().length()));
                if (witnessLength <= this.maxCollationSize) continue;
                return Response.status((Response.StatusType)new /* Unavailable Anonymous Inner Class!! */).build();
            }
        }
        return this.corsSupport(hh, Response.ok(this.executor.submit(new /* Unavailable Anonymous Inner Class!! */).get())).build();
    }

    Response.ResponseBuilder corsSupport(@Context HttpHeaders hh, Response.ResponseBuilder response) {
        MultivaluedMap requestHeaders = hh.getRequestHeaders();
        response.header("Access-Control-Allow-Origin", Optional.ofNullable(requestHeaders.getFirst((Object)"Origin")).orElse("*"));
        response.header("Access-Control-Allow-Methods", Optional.ofNullable(requestHeaders.getFirst((Object)"Access-Control-Request-Method")).orElse("GET, POST, HEAD, OPTIONS"));
        response.header("Access-Control-Allow-Headers", Optional.ofNullable(requestHeaders.getFirst((Object)"Access-Control-Request-Headers")).orElse("Content-Type, Accept, X-Requested-With"));
        response.header("Access-Control-Max-Age", (Object)"86400");
        response.header("Access-Control-Allow-Credentials", (Object)"true");
        return response;
    }

    @Path(value="{path: .+?\\.((html)|(css)|(js)|(png)|(ico))}")
    @GET
    public Response stream(@Context Request request, @PathParam(value="path") String path) throws IOException {
        Response.ResponseBuilder preconditions;
        InputStream stream = null;
        Date lastModified = this.initial;
        if (this.staticPath == null) {
            stream = this.getClass().getResourceAsStream("/static/" + path);
        } else {
            File file = new File(this.staticPath, path);
            if (file.isFile() && file.getCanonicalPath().startsWith(this.staticPath.getCanonicalPath())) {
                stream = new FileInputStream(file);
                lastModified = new Date(file.lastModified());
            }
        }
        if (stream == null) {
            throw new NotFoundException();
        }
        if (request.getMethod().equals("GET") && (preconditions = request.evaluatePreconditions(lastModified)) != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new WebApplicationException(preconditions.build());
        }
        String extension = this.getExtension(path);
        String contentType = "application/octet-stream";
        if ("html".equals(extension)) {
            contentType = "text/html";
        } else if ("js".equals(extension)) {
            contentType = "text/javascript";
        } else if ("css".equals(extension)) {
            contentType = "text/css";
        } else if ("png".equals(extension)) {
            contentType = "image/png";
        } else if ("ico".equals(extension)) {
            contentType = "image/x-icon";
        }
        return Response.ok().entity((Object)stream).lastModified(lastModified).type(contentType).build();
    }

    private String getExtension(String path) {
        int lastIndexOf = path.lastIndexOf(".");
        if (lastIndexOf != -1 && lastIndexOf != 0) {
            return path.substring(lastIndexOf + 1);
        }
        return "";
    }
}

