/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.io;

import eu.interedition.collatex.VariantGraph;
import eu.interedition.collatex.simple.SimpleVariantGraphSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"image/svg+xml"})
public class VariantGraphSVGMessageBodyWriter
implements MessageBodyWriter<VariantGraph> {
    private String dotPath;
    private final ExecutorService processThreads = Executors.newCachedThreadPool();

    public VariantGraphSVGMessageBodyWriter(String dotPath) {
        this.dotPath = dotPath;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return VariantGraph.class.isAssignableFrom(type);
    }

    public long getSize(VariantGraph variantGraph, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return 0L;
    }

    public void writeTo(VariantGraph graph, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (this.dotPath == null) {
            throw new WebApplicationException(Response.Status.NO_CONTENT);
        }
        StringWriter dot = new StringWriter();
        new SimpleVariantGraphSerializer(graph).toDot((Writer)dot);
        Process dotProc = new ProcessBuilder(this.dotPath, "-Grankdir=LR", "-Gid=VariantGraph", "-Tsvg").start();
        StringWriter errors = new StringWriter();
        try {
            ((CompletableFuture)CompletableFuture.allOf(CompletableFuture.runAsync(() -> {
                char[] buf = new char[8192];
                try (InputStreamReader errorStream = new InputStreamReader(dotProc.getErrorStream());){
                    int len;
                    while ((len = errorStream.read(buf)) >= 0) {
                        errors.write(buf, 0, len);
                    }
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            }, this.processThreads), CompletableFuture.runAsync(() -> {
                try (OutputStreamWriter dotProcStream = new OutputStreamWriter(dotProc.getOutputStream(), "UTF-8");){
                    dotProcStream.write(dot.toString());
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            }, this.processThreads), CompletableFuture.runAsync(() -> {
                httpHeaders.add((Object)"Content-Type", (Object)"image/svg+xml");
                byte[] buf = new byte[8192];
                try (InputStream in = dotProc.getInputStream();
                     OutputStream out = entityStream;){
                    int len;
                    while ((len = in.read(buf)) >= 0) {
                        out.write(buf, 0, len);
                    }
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            }, this.processThreads), CompletableFuture.runAsync(() -> {
                try {
                    if (dotProc.waitFor() != 0) {
                        throw new CompletionException(new IllegalStateException(errors.toString()));
                    }
                }
                catch (InterruptedException e) {
                    throw new CompletionException(e);
                }
            }, this.processThreads)).exceptionally(t -> {
                throw new WebApplicationException(t);
            })).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

