/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex.http;

import eu.interedition.collatex.http.CollateResource;
import eu.interedition.collatex.io.IOExceptionMapper;
import eu.interedition.collatex.io.SimpleCollationJSONMessageBodyReader;
import eu.interedition.collatex.io.VariantGraphDotMessageBodyWriter;
import eu.interedition.collatex.io.VariantGraphGraphMLMessageBodyWriter;
import eu.interedition.collatex.io.VariantGraphJSONMessageBodyWriter;
import eu.interedition.collatex.io.VariantGraphSVGMessageBodyWriter;
import eu.interedition.collatex.io.VariantGraphTEIMessageBodyWriter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Application;

/*
 * Exception performing whole class analysis ignored.
 */
public class CollateApplication
extends Application {
    private static final Logger LOG = Logger.getLogger(CollateApplication.class.getName());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String detectDotPath() {
        String[] stringArray = new String[]{"which dot", "where dot.exe"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String detectionCommand = stringArray[n2];
            try {
                Process process = Runtime.getRuntime().exec(detectionCommand);
                try (BufferedReader processReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));){
                    CompletableFuture<Optional> path = CompletableFuture.supplyAsync(() -> processReader.lines().map(String::trim).filter(l -> l.toLowerCase().contains("dot")).findFirst());
                    process.waitFor();
                    String dotPath = (String)path.get().get();
                    LOG.info(() -> "Detected GraphViz' dot at '" + dotPath + "'");
                    String string = dotPath;
                    return string;
                }
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, detectionCommand, t);
                ++n2;
            }
        }
        return null;
    }

    public Set<Class<?>> getClasses() {
        HashSet s = new HashSet();
        s.add(SimpleCollationJSONMessageBodyReader.class);
        s.add(VariantGraphJSONMessageBodyWriter.class);
        s.add(VariantGraphTEIMessageBodyWriter.class);
        s.add(VariantGraphGraphMLMessageBodyWriter.class);
        s.add(VariantGraphDotMessageBodyWriter.class);
        s.add(IOExceptionMapper.class);
        return s;
    }

    public Set<Object> getSingletons() {
        HashSet<Object> singletons = new HashSet<Object>();
        singletons.add(new CollateResource("", 10, 0));
        singletons.add(new VariantGraphSVGMessageBodyWriter(CollateApplication.detectDotPath()));
        return singletons;
    }
}

