/*
 * Decompiled with CFR 0.152.
 */
package eu.inn.metrics.common;

import eu.inn.metrics.common.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class Sink<T> {
    private final int sinkSize;
    private final LinkedBlockingQueue<Option<T>> sink;
    private final AtomicInteger nonEmptyElementsCount = new AtomicInteger(0);

    public Sink(int sinkSize) {
        this.sinkSize = sinkSize;
        this.sink = new LinkedBlockingQueue(sinkSize);
    }

    public boolean add(T element) {
        boolean needInsertElement;
        Option<T> option = Option.create(element);
        boolean bl = needInsertElement = !this.queueFullOfEmptyElements() || option.isDefined();
        if (needInsertElement) {
            return this.insertAndSlide(option);
        }
        return false;
    }

    public List<T> getAll() {
        Option[] options = this.sink.toArray(new Option[0]);
        ArrayList list = new ArrayList(options.length);
        for (Option option : options) {
            if (!option.isDefined()) continue;
            list.add(option.get());
        }
        return list;
    }

    private boolean queueFullOfEmptyElements() {
        return this.sink.size() == this.sinkSize && this.nonEmptyElementsCount.get() == 0;
    }

    private boolean insertAndSlide(Option<T> option) {
        Option<T> polled;
        if (this.sink.size() == this.sinkSize && (polled = this.sink.poll()).isDefined()) {
            this.nonEmptyElementsCount.decrementAndGet();
        }
        if (option.isDefined()) {
            this.nonEmptyElementsCount.incrementAndGet();
        }
        return this.sink.add(option);
    }
}

