/*
 * Decompiled with CFR 0.152.
 */
package eu.inn.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import eu.inn.metrics.MetricBuilder;
import eu.inn.metrics.MetricBuilderFactory;
import eu.inn.metrics.common.TimeWindowReservoirBuilder;
import eu.inn.metrics.sed.SlidingExponentialDecayingReservoir;
import java.util.concurrent.TimeUnit;

public class TimeWindowMetricBuilderFactory
implements MetricBuilderFactory {
    private final TimeWindowReservoirBuilder reservoirBuilder;
    private final MetricBuilder<Histogram> HISTOGRAMS = new MetricBuilder<Histogram>(){

        @Override
        public Histogram newMetric() {
            return new Histogram(TimeWindowMetricBuilderFactory.this.reservoirBuilder.build());
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Histogram.class.isInstance(metric);
        }
    };
    private final MetricBuilder<Timer> TIMERS = new MetricBuilder<Timer>(){

        @Override
        public Timer newMetric() {
            return new Timer(TimeWindowMetricBuilderFactory.this.reservoirBuilder.build());
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Timer.class.isInstance(metric);
        }
    };
    private final MetricBuilder<Counter> COUNTERS = new MetricBuilder<Counter>(){

        @Override
        public Counter newMetric() {
            return new Counter();
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Counter.class.isInstance(metric);
        }
    };
    private final MetricBuilder<Meter> METERS = new MetricBuilder<Meter>(){

        @Override
        public Meter newMetric() {
            return new Meter();
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Meter.class.isInstance(metric);
        }
    };

    public TimeWindowMetricBuilderFactory() {
        this(15L, TimeUnit.SECONDS);
    }

    public TimeWindowMetricBuilderFactory(long window, TimeUnit windowUnit) {
        this(1L, TimeUnit.SECONDS, window, windowUnit);
    }

    public TimeWindowMetricBuilderFactory(long flushPeriod, TimeUnit flushUnit, long window, TimeUnit windowUnit) {
        this(SlidingExponentialDecayingReservoir.builder().flushEvery(flushPeriod, flushUnit).window(window, windowUnit));
    }

    public TimeWindowMetricBuilderFactory(TimeWindowReservoirBuilder reservoirBuilder) {
        this.reservoirBuilder = reservoirBuilder;
    }

    @Override
    public MetricBuilder<Histogram> histogramsBuilder() {
        return this.HISTOGRAMS;
    }

    @Override
    public MetricBuilder<Timer> timersBuilder() {
        return this.TIMERS;
    }

    @Override
    public MetricBuilder<Counter> countersBuilder() {
        return this.COUNTERS;
    }

    @Override
    public MetricBuilder<Meter> metersBuilder() {
        return this.METERS;
    }
}

