/*
 * Decompiled with CFR 0.152.
 */
package eu.inn.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import eu.inn.metrics.MetricBuilder;
import eu.inn.metrics.MetricBuilderFactory;
import eu.inn.metrics.TimeWindowMetricBuilderFactory;
import java.util.concurrent.ConcurrentMap;

public class CustomMetricRegistry
extends MetricRegistry {
    private ConcurrentMap<String, Metric> metrics;
    private final MetricBuilder<Timer> timersBuilder;
    private final MetricBuilder<Histogram> histogramsBuilder;
    private final MetricBuilder<Meter> metersBuilder;
    private final MetricBuilder<Counter> countersBuilder;

    CustomMetricRegistry(MetricBuilder<Timer> timersBuilder, MetricBuilder<Histogram> histogramsBuilder, MetricBuilder<Meter> metersBuilder, MetricBuilder<Counter> countersBuilder) {
        this.timersBuilder = timersBuilder;
        this.histogramsBuilder = histogramsBuilder;
        this.metersBuilder = metersBuilder;
        this.countersBuilder = countersBuilder;
    }

    public Timer timer(String name) {
        return this.getOrAdd(name, this.timersBuilder);
    }

    public Histogram histogram(String name) {
        return this.getOrAdd(name, this.histogramsBuilder);
    }

    public Meter meter(String name) {
        return this.getOrAdd(name, this.metersBuilder);
    }

    public Counter counter(String name) {
        return this.getOrAdd(name, this.countersBuilder);
    }

    protected ConcurrentMap<String, Metric> buildMap() {
        this.metrics = super.buildMap();
        return this.metrics;
    }

    protected <T extends Metric> T getOrAdd(String name, MetricBuilder<T> builder) {
        block4: {
            Metric metric = (Metric)this.metrics.get(name);
            if (builder.isInstance(metric)) {
                return (T)metric;
            }
            if (metric == null) {
                try {
                    return (T)this.register(name, (Metric)builder.newMetric());
                }
                catch (IllegalArgumentException e) {
                    Metric added = (Metric)this.metrics.get(name);
                    if (!builder.isInstance(added)) break block4;
                    return (T)added;
                }
            }
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private MetricBuilder<Timer> timersBuilder;
        private MetricBuilder<Histogram> histogramsBuilder;
        private MetricBuilder<Meter> metersBuilder;
        private MetricBuilder<Counter> countersBuilder;

        public Builder() {
            this.fromFactory(new TimeWindowMetricBuilderFactory());
        }

        public Builder timersBuilder(MetricBuilder<Timer> timersBuilder) {
            this.timersBuilder = timersBuilder;
            return this;
        }

        public Builder histogramsBuilder(MetricBuilder<Histogram> histogramsBuilder) {
            this.histogramsBuilder = histogramsBuilder;
            return this;
        }

        public Builder metersBuilder(MetricBuilder<Meter> metersBuilder) {
            this.metersBuilder = metersBuilder;
            return this;
        }

        public Builder countersBuilder(MetricBuilder<Counter> countersBuilder) {
            this.countersBuilder = countersBuilder;
            return this;
        }

        public Builder fromFactory(MetricBuilderFactory factory) {
            this.timersBuilder = factory.timersBuilder();
            this.histogramsBuilder = factory.histogramsBuilder();
            this.metersBuilder = factory.metersBuilder();
            this.countersBuilder = factory.countersBuilder();
            return this;
        }

        public CustomMetricRegistry build() {
            return new CustomMetricRegistry(this.timersBuilder, this.histogramsBuilder, this.metersBuilder, this.countersBuilder);
        }
    }
}

