/*
 * Decompiled with CFR 0.152.
 */
package eu.inn.metrics.sed;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.WeightedSnapshot;
import eu.inn.metrics.common.NamedThreadFactory;
import eu.inn.metrics.common.Sink;
import eu.inn.metrics.common.TimeWindowReservoirBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SlidingExponentialDecayingReservoir
implements Reservoir {
    private final Sink<Collection<WeightedSnapshot.WeightedSample>> sink;
    private volatile ExponentiallyDecayingReservoir currentReservoir = new ExponentiallyDecayingReservoir();
    private static final WeightedSnapshot emptySnapshot = new WeightedSnapshot((Collection)Collections.EMPTY_LIST);
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory());
    private final long flushPeriod;
    private final TimeUnit flushUnit;
    private static Field valuesAccessor;

    public SlidingExponentialDecayingReservoir(long flushPeriod, TimeUnit flushUnit, int sinkSize) {
        this.flushPeriod = flushPeriod;
        this.flushUnit = flushUnit;
        this.sink = new Sink(sinkSize);
        this.scheduleHistogramFlush();
    }

    public int size() {
        int size = 0;
        for (Collection<WeightedSnapshot.WeightedSample> s : this.sink.getAll()) {
            size += s.size();
        }
        return size;
    }

    public void update(long value) {
        this.currentReservoir.update(value);
    }

    public Snapshot getSnapshot() {
        if (this.size() == 0) {
            return emptySnapshot;
        }
        ArrayList<WeightedSnapshot.WeightedSample> weightedSamples = new ArrayList<WeightedSnapshot.WeightedSample>(this.size());
        for (Collection<WeightedSnapshot.WeightedSample> s : this.sink.getAll()) {
            weightedSamples.addAll(s);
        }
        return new WeightedSnapshot(weightedSamples);
    }

    private void scheduleHistogramFlush() {
        executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Collection valuesSnapshot;
                if (SlidingExponentialDecayingReservoir.this.currentReservoir.size() > 0) {
                    try {
                        ExponentiallyDecayingReservoir reservoirSnapshot = SlidingExponentialDecayingReservoir.this.currentReservoir;
                        SlidingExponentialDecayingReservoir.this.currentReservoir = new ExponentiallyDecayingReservoir();
                        valuesSnapshot = ((Map)valuesAccessor.get(reservoirSnapshot)).values();
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    valuesSnapshot = null;
                }
                SlidingExponentialDecayingReservoir.this.sink.add(valuesSnapshot);
            }
        }, this.flushPeriod, this.flushPeriod, this.flushUnit);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        try {
            valuesAccessor = ExponentiallyDecayingReservoir.class.getDeclaredField("values");
            valuesAccessor.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder
    extends TimeWindowReservoirBuilder<SlidingExponentialDecayingReservoir> {
        @Override
        public SlidingExponentialDecayingReservoir build() {
            int sinkSize = (int)Math.ceil((double)this.windowUnit.toNanos(this.window) / (double)this.flushUnit.toNanos(this.flushPeriod));
            return new SlidingExponentialDecayingReservoir(this.flushPeriod, this.flushUnit, sinkSize);
        }
    }
}

