/*
 * Decompiled with CFR 0.152.
 */
package eu.inn.metrics.hdr;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import eu.inn.metrics.common.NamedThreadFactory;
import eu.inn.metrics.common.Sink;
import eu.inn.metrics.common.TimeWindowReservoirBuilder;
import eu.inn.metrics.hdr.HistogramSnapshot;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.LatencyUtils.LatencyStats;

public class HdrLatencyReservoir
implements Reservoir {
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory());
    private static final HistogramSnapshot emptyHistogramSnapshot = new HistogramSnapshot(new Histogram(0));
    private final LatencyStats stats;
    private final long flushPeriod;
    private final TimeUnit flushUnit;
    private final Sink<Histogram> sink;
    private volatile boolean valueAddedSinceSnapshotTaken = false;

    public HdrLatencyReservoir(LatencyStats stats, long flushPeriod, TimeUnit flushUnit, int sinkSize) {
        this.stats = stats;
        this.flushPeriod = flushPeriod;
        this.flushUnit = flushUnit;
        this.sink = new Sink(sinkSize);
        this.scheduleHistogramFlush();
    }

    public int size() {
        int size = 0;
        for (Histogram h : this.sink.getAll()) {
            size = (int)((long)size + h.getTotalCount());
        }
        return size;
    }

    public void update(long value) {
        this.valueAddedSinceSnapshotTaken = true;
        this.stats.recordLatency(value);
    }

    public Snapshot getSnapshot() {
        long highestTrackableValue = 0L;
        long lowestDiscernibleValue = Long.MAX_VALUE;
        int numberOfSignificantValueDigits = 0;
        List<Histogram> histogramList = this.sink.getAll();
        for (Histogram h : histogramList) {
            if (h.getHighestTrackableValue() > highestTrackableValue) {
                highestTrackableValue = h.getHighestTrackableValue();
            }
            if (h.getLowestDiscernibleValue() < lowestDiscernibleValue) {
                lowestDiscernibleValue = h.getLowestDiscernibleValue();
            }
            if (h.getNumberOfSignificantValueDigits() <= numberOfSignificantValueDigits) continue;
            numberOfSignificantValueDigits = h.getNumberOfSignificantValueDigits();
        }
        if (highestTrackableValue == 0L) {
            return emptyHistogramSnapshot;
        }
        Histogram mergedHistogram = new Histogram(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits);
        for (Histogram h : histogramList) {
            mergedHistogram.add((AbstractHistogram)h);
        }
        return new HistogramSnapshot(mergedHistogram);
    }

    private void scheduleHistogramFlush() {
        executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Histogram histogram = null;
                if (HdrLatencyReservoir.this.valueAddedSinceSnapshotTaken) {
                    HdrLatencyReservoir.this.valueAddedSinceSnapshotTaken = false;
                    histogram = HdrLatencyReservoir.this.stats.getIntervalHistogram();
                    if (histogram.getTotalCount() == 0L) {
                        histogram = null;
                    }
                }
                HdrLatencyReservoir.this.sink.add(histogram);
            }
        }, this.flushPeriod, this.flushPeriod, this.flushUnit);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends TimeWindowReservoirBuilder<HdrLatencyReservoir> {
        private LatencyStats stats = new LatencyStats();

        public Builder stats(LatencyStats stats) {
            this.stats = stats;
            return this;
        }

        @Override
        public HdrLatencyReservoir build() {
            int sinkSize = (int)Math.ceil((double)this.windowUnit.toNanos(this.window) / (double)this.flushUnit.toNanos(this.flushPeriod));
            return new HdrLatencyReservoir(this.stats, this.flushPeriod, this.flushUnit, sinkSize);
        }
    }
}

