/*
 * Decompiled with CFR 0.152.
 */
package eu.inn.metrics;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import eu.inn.metrics.HistogramSnapshot;
import eu.inn.metrics.NamedThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.LatencyUtils.LatencyStats;

public class LatencyReservoir
implements Reservoir {
    private final LatencyStats stats;
    private final long flushPeriod;
    private final TimeUnit flushUnit;
    private final int sinkSize;
    private final LinkedBlockingQueue<Histogram> sink;
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory());

    public LatencyReservoir(LatencyStats stats, long flushPeriod, TimeUnit flushUnit, int sinkSize) {
        this.stats = stats;
        this.flushPeriod = flushPeriod;
        this.flushUnit = flushUnit;
        this.sinkSize = sinkSize;
        this.sink = new LinkedBlockingQueue(sinkSize);
        this.scheduleHistogramFlush();
    }

    public int size() {
        Histogram[] histograms = this.sink.toArray(new Histogram[0]);
        int size = 0;
        for (Histogram h : histograms) {
            size = (int)((long)size + h.getTotalCount());
        }
        return size;
    }

    public void update(long value) {
        this.stats.recordLatency(value);
    }

    public Snapshot getSnapshot() {
        Histogram mergedHistogram = this.mergeHistogram();
        return new HistogramSnapshot(mergedHistogram);
    }

    private Histogram mergeHistogram() {
        Histogram[] histograms = this.sink.toArray(new Histogram[0]);
        long highestTrackableValue = 2L;
        long lowestDiscernibleValue = 1L;
        int numberOfSignificantValueDigits = 0;
        for (Histogram h : histograms) {
            if (h.getHighestTrackableValue() > highestTrackableValue) {
                highestTrackableValue = h.getHighestTrackableValue();
            }
            if (h.getLowestDiscernibleValue() > lowestDiscernibleValue) {
                lowestDiscernibleValue = h.getLowestDiscernibleValue();
            }
            if (h.getNumberOfSignificantValueDigits() <= numberOfSignificantValueDigits) continue;
            numberOfSignificantValueDigits = h.getNumberOfSignificantValueDigits();
        }
        Histogram mergedHistogram = new Histogram(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits);
        for (Histogram h : histograms) {
            mergedHistogram.add((AbstractHistogram)h);
        }
        return mergedHistogram;
    }

    private void scheduleHistogramFlush() {
        executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Histogram histogram = LatencyReservoir.this.stats.getIntervalHistogram();
                if (LatencyReservoir.this.sink.size() == LatencyReservoir.this.sinkSize) {
                    LatencyReservoir.this.sink.poll();
                }
                LatencyReservoir.this.sink.add(histogram);
            }
        }, this.flushPeriod, this.flushPeriod, this.flushUnit);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private LatencyStats stats = new LatencyStats();
        private long flushPeriod = 5L;
        private TimeUnit flushUnit = TimeUnit.SECONDS;
        private int sinkSize;
        private long window;
        private TimeUnit windowUnit;
        private final int DEFAULT_SINK_SIZE = 12;

        public Builder stats(LatencyStats stats) {
            this.stats = stats;
            return this;
        }

        public Builder flush(long flushPeriod, TimeUnit flushUnit) {
            Builder.validatePeriods("flushPeriod", flushPeriod, flushUnit);
            this.flushPeriod = flushPeriod;
            this.flushUnit = flushUnit;
            return this;
        }

        public Builder sinkSize(int sinkSize) {
            if (sinkSize < 1) {
                throw new IllegalArgumentException("sinkSize should be positive integer");
            }
            this.sinkSize = sinkSize;
            return this;
        }

        public Builder window(long window, TimeUnit windowUnit) {
            Builder.validatePeriods("window", window, windowUnit);
            this.window = window;
            this.windowUnit = windowUnit;
            return this;
        }

        public LatencyReservoir build() {
            if (this.windowUnit != null && this.sinkSize != 0) {
                throw new IllegalArgumentException("Either window parameters or sinkSize should be set");
            }
            if (this.windowUnit != null) {
                this.sinkSize = (int)Math.ceil((double)this.windowUnit.toNanos(this.window) / (double)this.flushUnit.toNanos(this.flushPeriod));
            }
            if (this.sinkSize == 0) {
                this.sinkSize = 12;
            }
            return new LatencyReservoir(this.stats, this.flushPeriod, this.flushUnit, this.sinkSize);
        }

        private static void validatePeriods(String name, long period, TimeUnit unit) {
            if (period <= 0L) {
                throw new IllegalArgumentException(name + " duration should be positive integer");
            }
            if (unit == null) {
                throw new IllegalArgumentException(name + " unit should be non-null");
            }
        }
    }
}

