/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.raml.webpack.holders;

import com.mulesoft.raml.webpack.holders.AbstractJSWrapper;
import com.mulesoft.raml.webpack.holders.JSError;
import java.util.HashMap;
import javax.script.Bindings;
import javax.script.ScriptEngine;

public class JSResponse
extends AbstractJSWrapper {
    private HashMap<String, Object> handlers = new HashMap();
    public String encoding;
    public HashMap<String, String> headers;
    public String statusCode = "blah";
    private String text;
    private String escapedText;
    private String code;
    public Object content = new Object();

    public JSResponse(ScriptEngine engine, String text, String code, HashMap<String, String> headers) {
        super(engine);
        this.headers = headers;
        this.code = code;
        this.text = text;
        this.escapedText = text.replaceAll("([\\\\'\\r\\n\\t\\f\\n])", "\\\\$1");
    }

    private void onError(JSError error) {
        Bindings bindings = this.getBindings();
        if (this.handlers.get("error") != null) {
            bindings.put("callback", this.handlers.get("error"));
            bindings.put("error", (Object)error);
            this.eval("callback(error);", bindings);
        }
    }

    private void onSuccess() {
        Bindings bindings = this.getBindings();
        if (this.handlers.get("data") != null) {
            bindings.put("owner", (Object)this);
            bindings.put("callback", this.handlers.get("data"));
            bindings.put("text", (Object)this.text);
            this.eval("callback('" + this.escapedText + "');", bindings);
        }
    }

    private void onEnd() {
        Bindings bindings = this.getBindings();
        if (this.handlers.get("end") != null) {
            bindings.put("callback", this.handlers.get("end"));
            bindings.put("jmap", (Object)this.headers);
            String[] array = new String[this.headers.size()];
            int count = 0;
            for (String header : this.headers.keySet()) {
                array[count++] = header;
            }
            bindings.put("keys", (Object)array);
            this.eval("var headers = {}; for(var i in keys) {headers[String(keys[i])] = String(jmap.get(keys[i]))} callback('" + this.code + "', headers, '" + this.escapedText + "');", bindings);
        }
    }

    public void end() {
        try {
            this.onSuccess();
        }
        catch (Throwable t) {
            this.onError(new JSError());
        }
        finally {
            this.onEnd();
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public JSResponse on(Object options, Object callback) {
        this.handlers.put(options.toString(), callback);
        return this;
    }
}

