/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.raml.webpack.holders;

import com.mulesoft.raml.webpack.holders.AbstractJSWrapper;
import com.mulesoft.raml.webpack.holders.JSError;
import com.mulesoft.raml.webpack.holders.JSResponse;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class JSRequest
extends AbstractJSWrapper {
    private HashMap<String, Object> handlers = new HashMap();
    private String host;
    private String port;
    private String path;
    private String method;
    private boolean ssl;
    public Object responseHandler;
    private Map<String, String> headers = new HashMap<String, String>();
    private String body;

    public JSRequest(Object options, Object responseHandler, boolean ssl, ScriptEngine engine) {
        super(engine);
        this.responseHandler = responseHandler;
        this.ssl = ssl;
        Bindings bindings = this.getBindings();
        bindings.put("owner", (Object)this);
        bindings.put("opts", options);
        this.eval("owner.setHost(opts.host);", bindings);
        this.eval("owner.setPort(opts.port);", bindings);
        this.eval("owner.setPath(opts.path);", bindings);
        this.eval("owner.setMethod(opts.method);", bindings);
        this.eval("for(var key in opts.headers) { owner.putHeader(key, opts.headers[key]);};", bindings);
    }

    public JSRequest on(Object options, Object callback) {
        this.handlers.put(options.toString(), callback);
        return this;
    }

    public void putHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void end(Object obj) {
        this.write(obj);
        this.end();
    }

    public void end() {
        String url = (this.ssl ? "https://" : "http://") + this.host + this.path;
        try {
            if (this.method.trim().toLowerCase().equals("get") && this.body != null) {
                this.executeGetRequestWithBody(url);
            } else {
                this.executeRequest(url);
            }
        }
        catch (Throwable t) {
            this.onError(new JSError());
        }
        finally {
            this.onEnd();
            System.out.println("Succesfully performed call: " + this.method.toUpperCase() + " '" + url + "'");
        }
    }

    private void executeGetRequestWithBody(String url) throws IOException, MalformedURLException, UnsupportedEncodingException, ProtocolException, Throwable {
        System.out.println("Performing call: " + this.method.toUpperCase() + " '" + url + "'");
        EntityEnclosingMethod getMethod = new EntityEnclosingMethod(url){

            public String getName() {
                return "GET";
            }
        };
        String contentType = "text/plain";
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            String name = e.getKey();
            String value = e.getValue();
            getMethod.setRequestHeader(name, value);
            if (!name.trim().toLowerCase().equals("content-type")) continue;
            contentType = value;
        }
        getMethod.setRequestEntity((RequestEntity)new StringRequestEntity(this.body, contentType, "UTF-8"));
        HttpClient httpClient = new HttpClient();
        int status = httpClient.executeMethod((HttpMethod)getMethod);
        String responseText = getMethod.getResponseBodyAsString();
        Header[] respHeaders = getMethod.getResponseHeaders();
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        for (Header h : respHeaders) {
            responseHeaders.put(h.getName(), h.getValue());
        }
        getMethod.releaseConnection();
        JSResponse response = new JSResponse(this.engine, responseText, "" + status, responseHeaders);
        this.onSuccess(response);
        response.end();
    }

    private void executeRequest(String url) throws IOException, MalformedURLException, UnsupportedEncodingException, ProtocolException, Throwable {
        System.out.println("Performing call: " + this.method.toUpperCase() + " '" + url + "'");
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        if (this.body != null) {
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Length", "" + this.body.getBytes("UTF-8").length);
        }
        connection.setDoInput(true);
        connection.setRequestMethod(this.method.toUpperCase());
        for (String header : this.headers.keySet()) {
            connection.setRequestProperty(header, this.headers.get(header));
        }
        String responseText = this.getResponseText(connection);
        Map<String, List<String>> map = connection.getHeaderFields();
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            responseHeaders.put(entry.getKey(), entry.getValue().toString());
        }
        JSResponse response = new JSResponse(this.engine, responseText, connection.getResponseCode() + "", responseHeaders);
        this.onSuccess(response);
        response.end();
    }

    private void onError(JSError error) {
        Bindings bindings = this.getBindings();
        if (this.handlers.get("error") != null) {
            bindings.put("callback", this.handlers.get("error"));
            bindings.put("error", (Object)error);
            this.eval("callback(error);", bindings);
        }
    }

    private void onSuccess(JSResponse response) {
        Bindings bindings = this.getBindings();
        if (this.responseHandler != null) {
            bindings.put("callback", this.responseHandler);
            bindings.put("response", (Object)response);
            this.eval("callback(response);", bindings);
        }
    }

    private void onEnd() {
        Bindings bindings = this.getBindings();
        if (this.handlers.get("end") != null) {
            bindings.put("callback", this.handlers.get("end"));
            this.eval("callback();", bindings);
        }
    }

    private static void writeRequestBody(URLConnection connection, String text) throws Throwable {
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        writer.write(text);
        writer.close();
    }

    private String getResponseText(URLConnection connection) throws Throwable {
        if (this.body != null) {
            DataOutputStream dos = new DataOutputStream(connection.getOutputStream());
            dos.writeBytes(this.body.toString());
            dos.flush();
            dos.close();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder("");
        int count = 0;
        String line = reader.readLine();
        while (line != null) {
            lines.add(line);
            line = reader.readLine();
        }
        for (String line2 : lines) {
            stringBuilder.append(line2);
            stringBuilder.append(lines.size() == ++count ? "" : "\n");
        }
        reader.close();
        return stringBuilder.toString();
    }

    public boolean write(Object obj, Object obj1, Object obj2) {
        return this.write(obj);
    }

    public boolean write(Object obj, Object obj1) {
        return this.write(obj);
    }

    public boolean write(Object obj) {
        if (this.body == null) {
            this.body = "";
        }
        this.body = this.body + obj.toString();
        return true;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

