/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.raml.webpack.holders;

import com.mulesoft.raml.webpack.holders.AbstractJSWrapper;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;

public class JSEndpoints
extends AbstractJSWrapper {
    private ExecutionInfoProvider provider;
    public String baseUrl;
    public Set<String> services = new HashSet<String>();

    public JSEndpoints(ScriptEngine engine, ExecutionInfoProvider provider) {
        super(engine);
        this.provider = provider;
    }

    public void exportService(Object service, Object requestGetter, String uri) {
        if (ExecutionMode.REGISTER.equals((Object)this.provider.getExecutionMode())) {
            this.services.add(uri);
            return;
        }
        if (this.provider.isCurrentCall(uri)) {
            Bindings bindings = this.getBindings();
            bindings.put("service", service);
            bindings.put("getter", requestGetter);
            bindings.put("params", (Object)this.provider.getParams());
            bindings.put("body", (Object)this.provider.getRequestBody());
            this.eval("service(getter(null, params, body));", bindings);
        }
    }

    public void doExport() {
    }

    public void setApi(Object api) {
        Bindings bindings = this.getBindings();
        bindings.put("owner", (Object)this);
        bindings.put("api", api);
        this.eval("owner.baseUrl = api.data.baseUri;", bindings);
        this.baseUrl = this.baseUrl.replace("http://", "").replace("https://", "");
        System.out.println("Api created: " + this.baseUrl);
    }

    public static interface ExecutionInfoProvider {
        public ExecutionMode getExecutionMode();

        public String getSrc();

        public String getAuthCfg();

        public Map<String, String> getParams();

        public String getRequestBody();

        public boolean isCurrentCall(String var1);
    }

    public static enum ExecutionMode {
        REGISTER,
        EVAL;

    }
}

