/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../../typings/tsd.d.ts" />
	var RamlWrapper = __webpack_require__(3);
	var parserWrapper = __webpack_require__(1);
	var expander = __webpack_require__(4);
	var Opt = __webpack_require__(5);
	var jsyaml = __webpack_require__(6);
	var hlimpl = __webpack_require__(7);
	var javaParserGen = __webpack_require__(8);
	var json = __webpack_require__(9);
	var javaPathResolver = __webpack_require__(2);
	var path = __webpack_require__(11);
	var apiType = __webpack_require__(10)("RAML10").type("Api");
	function run() {
	    var func = function (apiPath) {
	        return loadApi(apiPath).getOrElse(null);
	    };
	    parserWrapper.setCreateApi(func);
	    var gc = function (sv, rootPackage) {
	        var hlNode = sv.toHighlevel();
	        var def = hlNode.definition();
	        var obj = json.serialize(sv.lowLevel());
	        if (typeof obj != 'object') {
	            obj = {};
	        }
	        return {
	            valueName: sv.valueName(),
	            data: JSON.stringify(obj, null, 2),
	            classes: javaParserGen.generateClasses(def, rootPackage)
	        };
	    };
	    parserWrapper.setGenerateClasses(gc);
	}
	function loadApi(apiPath) {
	    var api = null;
	    var projectRoot = path.dirname(apiPath);
	    var p = new jsyaml.Project(projectRoot, {
	        content: function (path) {
	            return javaPathResolver.content(path);
	        },
	        list: function (path) {
	            return javaPathResolver.list(path);
	        }
	    });
	    var result;
	    p.units().forEach(function (x) {
	        if (path.basename(x.path()) == path.basename(apiPath)) {
	            api = new RamlWrapper.ApiImpl(new hlimpl.ASTNodeImpl(x.ast(), null, apiType, null));
	            api = expander.expandTraitsAndResourceTypes(api);
	        }
	    });
	    console.log("Api parsed " + api.title());
	    return new Opt(api);
	}
	function getErrors(node) {
	    var result = [];
	    node.errors().forEach(function (x) { return result.push({
	        code: x.code,
	        message: x.message,
	        path: x.path,
	        start: x.start,
	        end: x.end,
	        isWarning: x.isWarning
	    }); });
	    return result;
	}
	run();
	//# sourceMappingURL=entryPoint.instrumented.js.map

/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = apiCreatorWrapper;

/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = javaPathResolver;

/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	var __extends = this.__extends || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    __.prototype = b.prototype;
	    d.prototype = new __();
	};
	var hl = __webpack_require__(17);
	var core = __webpack_require__(18);
	var BasicNodeImpl = (function (_super) {
	    __extends(BasicNodeImpl, _super);
	    function BasicNodeImpl(node) {
	        _super.call(this, node);
	    }
	    BasicNodeImpl.prototype.wrapperClassName = function () {
	        return 'BasicNodeImpl';
	    };
	    BasicNodeImpl.prototype.parent = function () {
	        return _super.prototype.parent.call(this);
	    };
	    return BasicNodeImpl;
	})(core.BasicSuperNodeImpl);
	exports.BasicNodeImpl = BasicNodeImpl;
	var RAMLLanguageElementImpl = (function (_super) {
	    __extends(RAMLLanguageElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function RAMLLanguageElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createRAMLLanguageElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    RAMLLanguageElementImpl.prototype.wrapperClassName = function () {
	        return "RAMLLanguageElementImpl";
	    };
	    /**
	     *
	     **/
	    //displayName
	    RAMLLanguageElementImpl.prototype.displayName = function () {
	        return _super.prototype.attribute.call(this, 'displayName', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDisplayName
	    RAMLLanguageElementImpl.prototype.setDisplayName = function (param) {
	        {
	            this.highLevel().attrOrCreate("displayName").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //description
	    RAMLLanguageElementImpl.prototype.description = function () {
	        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //annotations
	    RAMLLanguageElementImpl.prototype.annotations = function () {
	        return _super.prototype.attributes.call(this, 'annotations', function (attr) { return new AnnotationRefImpl(attr); });
	    };
	    return RAMLLanguageElementImpl;
	})(BasicNodeImpl);
	exports.RAMLLanguageElementImpl = RAMLLanguageElementImpl;
	var ValueTypeImpl = (function () {
	    /**
	     *
	     **/
	    //constructor
	    function ValueTypeImpl(attr) {
	        this.attr = attr;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ValueTypeImpl.prototype.wrapperClassName = function () {
	        return "ValueTypeImpl";
	    };
	    /**
	     *
	     **/
	    //value
	    ValueTypeImpl.prototype.value = function () {
	        return this.attr.value();
	    };
	    /**
	     *
	     **/
	    //highLevel
	    ValueTypeImpl.prototype.highLevel = function () {
	        return this.attr;
	    };
	    return ValueTypeImpl;
	})();
	exports.ValueTypeImpl = ValueTypeImpl;
	var NumberTypeImpl = (function (_super) {
	    __extends(NumberTypeImpl, _super);
	    function NumberTypeImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    NumberTypeImpl.prototype.wrapperClassName = function () {
	        return "NumberTypeImpl";
	    };
	    return NumberTypeImpl;
	})(ValueTypeImpl);
	exports.NumberTypeImpl = NumberTypeImpl;
	var BooleanTypeImpl = (function (_super) {
	    __extends(BooleanTypeImpl, _super);
	    function BooleanTypeImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    BooleanTypeImpl.prototype.wrapperClassName = function () {
	        return "BooleanTypeImpl";
	    };
	    return BooleanTypeImpl;
	})(ValueTypeImpl);
	exports.BooleanTypeImpl = BooleanTypeImpl;
	var ReferenceImpl = (function (_super) {
	    __extends(ReferenceImpl, _super);
	    function ReferenceImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ReferenceImpl.prototype.wrapperClassName = function () {
	        return "ReferenceImpl";
	    };
	    /**
	     *
	     **/
	    //value
	    ReferenceImpl.prototype.value = function () {
	        return core.toStructuredValue(this.attr);
	    };
	    return ReferenceImpl;
	})(ValueTypeImpl);
	exports.ReferenceImpl = ReferenceImpl;
	var ResourceTypeRefImpl = (function (_super) {
	    __extends(ResourceTypeRefImpl, _super);
	    function ResourceTypeRefImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ResourceTypeRefImpl.prototype.wrapperClassName = function () {
	        return "ResourceTypeRefImpl";
	    };
	    return ResourceTypeRefImpl;
	})(ReferenceImpl);
	exports.ResourceTypeRefImpl = ResourceTypeRefImpl;
	var TraitRefImpl = (function (_super) {
	    __extends(TraitRefImpl, _super);
	    function TraitRefImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    TraitRefImpl.prototype.wrapperClassName = function () {
	        return "TraitRefImpl";
	    };
	    return TraitRefImpl;
	})(ReferenceImpl);
	exports.TraitRefImpl = TraitRefImpl;
	var SecuritySchemaRefImpl = (function (_super) {
	    __extends(SecuritySchemaRefImpl, _super);
	    function SecuritySchemaRefImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    SecuritySchemaRefImpl.prototype.wrapperClassName = function () {
	        return "SecuritySchemaRefImpl";
	    };
	    return SecuritySchemaRefImpl;
	})(ReferenceImpl);
	exports.SecuritySchemaRefImpl = SecuritySchemaRefImpl;
	var AnnotationRefImpl = (function (_super) {
	    __extends(AnnotationRefImpl, _super);
	    function AnnotationRefImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    AnnotationRefImpl.prototype.wrapperClassName = function () {
	        return "AnnotationRefImpl";
	    };
	    return AnnotationRefImpl;
	})(ReferenceImpl);
	exports.AnnotationRefImpl = AnnotationRefImpl;
	var DataElementRefImpl = (function (_super) {
	    __extends(DataElementRefImpl, _super);
	    function DataElementRefImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    DataElementRefImpl.prototype.wrapperClassName = function () {
	        return "DataElementRefImpl";
	    };
	    return DataElementRefImpl;
	})(ReferenceImpl);
	exports.DataElementRefImpl = DataElementRefImpl;
	var ramlexpressionImpl = (function (_super) {
	    __extends(ramlexpressionImpl, _super);
	    function ramlexpressionImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ramlexpressionImpl.prototype.wrapperClassName = function () {
	        return "ramlexpressionImpl";
	    };
	    return ramlexpressionImpl;
	})(ValueTypeImpl);
	exports.ramlexpressionImpl = ramlexpressionImpl;
	var AnnotationTargetImpl = (function (_super) {
	    __extends(AnnotationTargetImpl, _super);
	    function AnnotationTargetImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    AnnotationTargetImpl.prototype.wrapperClassName = function () {
	        return "AnnotationTargetImpl";
	    };
	    return AnnotationTargetImpl;
	})(ValueTypeImpl);
	exports.AnnotationTargetImpl = AnnotationTargetImpl;
	var pointerImpl = (function (_super) {
	    __extends(pointerImpl, _super);
	    function pointerImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    pointerImpl.prototype.wrapperClassName = function () {
	        return "pointerImpl";
	    };
	    return pointerImpl;
	})(ValueTypeImpl);
	exports.pointerImpl = pointerImpl;
	var StringTypeImpl = (function (_super) {
	    __extends(StringTypeImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function StringTypeImpl(attr) {
	        _super.call(this, attr);
	        this.attr = attr;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    StringTypeImpl.prototype.wrapperClassName = function () {
	        return "StringTypeImpl";
	    };
	    return StringTypeImpl;
	})(ValueTypeImpl);
	exports.StringTypeImpl = StringTypeImpl;
	var UriTemplateImpl = (function (_super) {
	    __extends(UriTemplateImpl, _super);
	    function UriTemplateImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    UriTemplateImpl.prototype.wrapperClassName = function () {
	        return "UriTemplateImpl";
	    };
	    return UriTemplateImpl;
	})(StringTypeImpl);
	exports.UriTemplateImpl = UriTemplateImpl;
	var RelativeUriImpl = (function (_super) {
	    __extends(RelativeUriImpl, _super);
	    function RelativeUriImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    RelativeUriImpl.prototype.wrapperClassName = function () {
	        return "RelativeUriImpl";
	    };
	    return RelativeUriImpl;
	})(UriTemplateImpl);
	exports.RelativeUriImpl = RelativeUriImpl;
	var FullUriTemplateImpl = (function (_super) {
	    __extends(FullUriTemplateImpl, _super);
	    function FullUriTemplateImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    FullUriTemplateImpl.prototype.wrapperClassName = function () {
	        return "FullUriTemplateImpl";
	    };
	    return FullUriTemplateImpl;
	})(UriTemplateImpl);
	exports.FullUriTemplateImpl = FullUriTemplateImpl;
	var StatusCodeImpl = (function (_super) {
	    __extends(StatusCodeImpl, _super);
	    function StatusCodeImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    StatusCodeImpl.prototype.wrapperClassName = function () {
	        return "StatusCodeImpl";
	    };
	    return StatusCodeImpl;
	})(StringTypeImpl);
	exports.StatusCodeImpl = StatusCodeImpl;
	var FixedUriImpl = (function (_super) {
	    __extends(FixedUriImpl, _super);
	    function FixedUriImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    FixedUriImpl.prototype.wrapperClassName = function () {
	        return "FixedUriImpl";
	    };
	    return FixedUriImpl;
	})(StringTypeImpl);
	exports.FixedUriImpl = FixedUriImpl;
	var ContentTypeImpl = (function (_super) {
	    __extends(ContentTypeImpl, _super);
	    function ContentTypeImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ContentTypeImpl.prototype.wrapperClassName = function () {
	        return "ContentTypeImpl";
	    };
	    return ContentTypeImpl;
	})(StringTypeImpl);
	exports.ContentTypeImpl = ContentTypeImpl;
	var ValidityExpressionImpl = (function (_super) {
	    __extends(ValidityExpressionImpl, _super);
	    function ValidityExpressionImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ValidityExpressionImpl.prototype.wrapperClassName = function () {
	        return "ValidityExpressionImpl";
	    };
	    return ValidityExpressionImpl;
	})(StringTypeImpl);
	exports.ValidityExpressionImpl = ValidityExpressionImpl;
	var DateFormatSpecImpl = (function (_super) {
	    __extends(DateFormatSpecImpl, _super);
	    function DateFormatSpecImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    DateFormatSpecImpl.prototype.wrapperClassName = function () {
	        return "DateFormatSpecImpl";
	    };
	    return DateFormatSpecImpl;
	})(StringTypeImpl);
	exports.DateFormatSpecImpl = DateFormatSpecImpl;
	var FunctionalInterfaceImpl = (function (_super) {
	    __extends(FunctionalInterfaceImpl, _super);
	    function FunctionalInterfaceImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    FunctionalInterfaceImpl.prototype.wrapperClassName = function () {
	        return "FunctionalInterfaceImpl";
	    };
	    return FunctionalInterfaceImpl;
	})(StringTypeImpl);
	exports.FunctionalInterfaceImpl = FunctionalInterfaceImpl;
	var SchemaStringImpl = (function (_super) {
	    __extends(SchemaStringImpl, _super);
	    function SchemaStringImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    SchemaStringImpl.prototype.wrapperClassName = function () {
	        return "SchemaStringImpl";
	    };
	    return SchemaStringImpl;
	})(StringTypeImpl);
	exports.SchemaStringImpl = SchemaStringImpl;
	var JSonSchemaStringImpl = (function (_super) {
	    __extends(JSonSchemaStringImpl, _super);
	    function JSonSchemaStringImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    JSonSchemaStringImpl.prototype.wrapperClassName = function () {
	        return "JSonSchemaStringImpl";
	    };
	    return JSonSchemaStringImpl;
	})(SchemaStringImpl);
	exports.JSonSchemaStringImpl = JSonSchemaStringImpl;
	var XMLSchemaStringImpl = (function (_super) {
	    __extends(XMLSchemaStringImpl, _super);
	    function XMLSchemaStringImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    XMLSchemaStringImpl.prototype.wrapperClassName = function () {
	        return "XMLSchemaStringImpl";
	    };
	    return XMLSchemaStringImpl;
	})(SchemaStringImpl);
	exports.XMLSchemaStringImpl = XMLSchemaStringImpl;
	var ExampleStringImpl = (function (_super) {
	    __extends(ExampleStringImpl, _super);
	    function ExampleStringImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ExampleStringImpl.prototype.wrapperClassName = function () {
	        return "ExampleStringImpl";
	    };
	    return ExampleStringImpl;
	})(StringTypeImpl);
	exports.ExampleStringImpl = ExampleStringImpl;
	var ScriptingHookImpl = (function (_super) {
	    __extends(ScriptingHookImpl, _super);
	    function ScriptingHookImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ScriptingHookImpl.prototype.wrapperClassName = function () {
	        return "ScriptingHookImpl";
	    };
	    return ScriptingHookImpl;
	})(StringTypeImpl);
	exports.ScriptingHookImpl = ScriptingHookImpl;
	var SecuritySchemaHookScriptImpl = (function (_super) {
	    __extends(SecuritySchemaHookScriptImpl, _super);
	    function SecuritySchemaHookScriptImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    SecuritySchemaHookScriptImpl.prototype.wrapperClassName = function () {
	        return "SecuritySchemaHookScriptImpl";
	    };
	    return SecuritySchemaHookScriptImpl;
	})(ScriptingHookImpl);
	exports.SecuritySchemaHookScriptImpl = SecuritySchemaHookScriptImpl;
	var RAMLPointerImpl = (function (_super) {
	    __extends(RAMLPointerImpl, _super);
	    function RAMLPointerImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    RAMLPointerImpl.prototype.wrapperClassName = function () {
	        return "RAMLPointerImpl";
	    };
	    return RAMLPointerImpl;
	})(StringTypeImpl);
	exports.RAMLPointerImpl = RAMLPointerImpl;
	var RAMLSelectorImpl = (function (_super) {
	    __extends(RAMLSelectorImpl, _super);
	    function RAMLSelectorImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    RAMLSelectorImpl.prototype.wrapperClassName = function () {
	        return "RAMLSelectorImpl";
	    };
	    return RAMLSelectorImpl;
	})(StringTypeImpl);
	exports.RAMLSelectorImpl = RAMLSelectorImpl;
	var MimeTypeImpl = (function (_super) {
	    __extends(MimeTypeImpl, _super);
	    function MimeTypeImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    MimeTypeImpl.prototype.wrapperClassName = function () {
	        return "MimeTypeImpl";
	    };
	    return MimeTypeImpl;
	})(StringTypeImpl);
	exports.MimeTypeImpl = MimeTypeImpl;
	var MarkdownStringImpl = (function (_super) {
	    __extends(MarkdownStringImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function MarkdownStringImpl(attr) {
	        _super.call(this, attr);
	        this.attr = attr;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    MarkdownStringImpl.prototype.wrapperClassName = function () {
	        return "MarkdownStringImpl";
	    };
	    return MarkdownStringImpl;
	})(StringTypeImpl);
	exports.MarkdownStringImpl = MarkdownStringImpl;
	var DocumentationItemImpl = (function (_super) {
	    __extends(DocumentationItemImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function DocumentationItemImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createDocumentationItem(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    DocumentationItemImpl.prototype.wrapperClassName = function () {
	        return "DocumentationItemImpl";
	    };
	    /**
	     *
	     **/
	    //title
	    DocumentationItemImpl.prototype.title = function () {
	        return _super.prototype.attribute.call(this, 'title', this.toString);
	    };
	    /**
	     *
	     **/
	    //setTitle
	    DocumentationItemImpl.prototype.setTitle = function (param) {
	        {
	            this.highLevel().attrOrCreate("title").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //content
	    DocumentationItemImpl.prototype.content = function () {
	        return _super.prototype.attribute.call(this, 'content', function (attr) { return new MarkdownStringImpl(attr); });
	    };
	    return DocumentationItemImpl;
	})(RAMLLanguageElementImpl);
	exports.DocumentationItemImpl = DocumentationItemImpl;
	var ScriptSpecImpl = (function (_super) {
	    __extends(ScriptSpecImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ScriptSpecImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createScriptSpec(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ScriptSpecImpl.prototype.wrapperClassName = function () {
	        return "ScriptSpecImpl";
	    };
	    /**
	     *
	     **/
	    //language
	    ScriptSpecImpl.prototype.language = function () {
	        return _super.prototype.attribute.call(this, 'language', this.toString);
	    };
	    /**
	     *
	     **/
	    //setLanguage
	    ScriptSpecImpl.prototype.setLanguage = function (param) {
	        {
	            this.highLevel().attrOrCreate("language").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //content
	    ScriptSpecImpl.prototype.content = function () {
	        return _super.prototype.attribute.call(this, 'content', this.toString);
	    };
	    /**
	     *
	     **/
	    //setContent
	    ScriptSpecImpl.prototype.setContent = function (param) {
	        {
	            this.highLevel().attrOrCreate("content").setValue("" + param);
	            return this;
	        }
	    };
	    return ScriptSpecImpl;
	})(RAMLLanguageElementImpl);
	exports.ScriptSpecImpl = ScriptSpecImpl;
	var ApiDescriptionImpl = (function (_super) {
	    __extends(ApiDescriptionImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ApiDescriptionImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createApiDescription(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ApiDescriptionImpl.prototype.wrapperClassName = function () {
	        return "ApiDescriptionImpl";
	    };
	    /**
	     *
	     **/
	    //apiFiles
	    ApiDescriptionImpl.prototype.apiFiles = function () {
	        return _super.prototype.elements.call(this, 'apiFiles');
	    };
	    /**
	     *
	     **/
	    //script
	    ApiDescriptionImpl.prototype.script = function () {
	        return _super.prototype.elements.call(this, 'script');
	    };
	    /**
	     *
	     **/
	    //type
	    ApiDescriptionImpl.prototype["type"] = function () {
	        return _super.prototype.attribute.call(this, 'type', this.toString);
	    };
	    /**
	     *
	     **/
	    //setType
	    ApiDescriptionImpl.prototype.setType = function (param) {
	        {
	            this.highLevel().attrOrCreate("type").setValue("" + param);
	            return this;
	        }
	    };
	    return ApiDescriptionImpl;
	})(RAMLLanguageElementImpl);
	exports.ApiDescriptionImpl = ApiDescriptionImpl;
	var CallbackAPIDescriptionImpl = (function (_super) {
	    __extends(CallbackAPIDescriptionImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function CallbackAPIDescriptionImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createCallbackAPIDescription(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    CallbackAPIDescriptionImpl.prototype.wrapperClassName = function () {
	        return "CallbackAPIDescriptionImpl";
	    };
	    /**
	     *
	     **/
	    //callbackFor
	    CallbackAPIDescriptionImpl.prototype.callbackFor = function () {
	        return _super.prototype.element.call(this, 'callbackFor');
	    };
	    return CallbackAPIDescriptionImpl;
	})(ApiDescriptionImpl);
	exports.CallbackAPIDescriptionImpl = CallbackAPIDescriptionImpl;
	var RAMLProjectImpl = (function (_super) {
	    __extends(RAMLProjectImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function RAMLProjectImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createRAMLProject(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    RAMLProjectImpl.prototype.wrapperClassName = function () {
	        return "RAMLProjectImpl";
	    };
	    /**
	     *
	     **/
	    //relatedProjects
	    RAMLProjectImpl.prototype.relatedProjects = function () {
	        return _super.prototype.elements.call(this, 'relatedProjects');
	    };
	    /**
	     *
	     **/
	    //declaredApis
	    RAMLProjectImpl.prototype.declaredApis = function () {
	        return _super.prototype.elements.call(this, 'declaredApis');
	    };
	    /**
	     *
	     **/
	    //license
	    RAMLProjectImpl.prototype.license = function () {
	        return _super.prototype.attribute.call(this, 'license', this.toString);
	    };
	    /**
	     *
	     **/
	    //setLicense
	    RAMLProjectImpl.prototype.setLicense = function (param) {
	        {
	            this.highLevel().attrOrCreate("license").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //overview
	    RAMLProjectImpl.prototype.overview = function () {
	        return _super.prototype.attribute.call(this, 'overview', this.toString);
	    };
	    /**
	     *
	     **/
	    //setOverview
	    RAMLProjectImpl.prototype.setOverview = function (param) {
	        {
	            this.highLevel().attrOrCreate("overview").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //url
	    RAMLProjectImpl.prototype.url = function () {
	        return _super.prototype.attribute.call(this, 'url', this.toString);
	    };
	    /**
	     *
	     **/
	    //setUrl
	    RAMLProjectImpl.prototype.setUrl = function (param) {
	        {
	            this.highLevel().attrOrCreate("url").setValue("" + param);
	            return this;
	        }
	    };
	    return RAMLProjectImpl;
	})(RAMLLanguageElementImpl);
	exports.RAMLProjectImpl = RAMLProjectImpl;
	var SecuritySchemaTypeImpl = (function (_super) {
	    __extends(SecuritySchemaTypeImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function SecuritySchemaTypeImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createSecuritySchemaType(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    SecuritySchemaTypeImpl.prototype.wrapperClassName = function () {
	        return "SecuritySchemaTypeImpl";
	    };
	    /**
	     *
	     **/
	    //requiredSettings
	    SecuritySchemaTypeImpl.prototype.requiredSettings = function () {
	        return _super.prototype.elements.call(this, 'requiredSettings');
	    };
	    /**
	     *
	     **/
	    //describedBy
	    SecuritySchemaTypeImpl.prototype.describedBy = function () {
	        return _super.prototype.element.call(this, 'describedBy');
	    };
	    return SecuritySchemaTypeImpl;
	})(RAMLLanguageElementImpl);
	exports.SecuritySchemaTypeImpl = SecuritySchemaTypeImpl;
	var DataElementImpl = (function (_super) {
	    __extends(DataElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function DataElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createDataElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    DataElementImpl.prototype.wrapperClassName = function () {
	        return "DataElementImpl";
	    };
	    /**
	     *
	     **/
	    //name
	    DataElementImpl.prototype.name = function () {
	        return _super.prototype.attribute.call(this, 'name', this.toString);
	    };
	    /**
	     *
	     **/
	    //setName
	    DataElementImpl.prototype.setName = function (param) {
	        {
	            this.highLevel().attrOrCreate("name").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //xml
	    DataElementImpl.prototype.xml = function () {
	        return _super.prototype.element.call(this, 'xml');
	    };
	    /**
	     *
	     **/
	    //facets
	    DataElementImpl.prototype.facets = function () {
	        return _super.prototype.elements.call(this, 'facets');
	    };
	    /**
	     *
	     **/
	    //schema
	    DataElementImpl.prototype.schema = function () {
	        return _super.prototype.attribute.call(this, 'schema', this.toString);
	    };
	    /**
	     *
	     **/
	    //setSchema
	    DataElementImpl.prototype.setSchema = function (param) {
	        {
	            this.highLevel().attrOrCreate("schema").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //usage
	    DataElementImpl.prototype.usage = function () {
	        return _super.prototype.attribute.call(this, 'usage', this.toString);
	    };
	    /**
	     *
	     **/
	    //setUsage
	    DataElementImpl.prototype.setUsage = function (param) {
	        {
	            this.highLevel().attrOrCreate("usage").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //type
	    DataElementImpl.prototype["type"] = function () {
	        return _super.prototype.attributes.call(this, 'type', this.toString);
	    };
	    /**
	     *
	     **/
	    //setType
	    DataElementImpl.prototype.setType = function (param) {
	        {
	            this.highLevel().attrOrCreate("type").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //location
	    DataElementImpl.prototype.location = function () {
	        return _super.prototype.attribute.call(this, 'location', function (attr) { return new ModelLocationImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //locationKind
	    DataElementImpl.prototype.locationKind = function () {
	        return _super.prototype.attribute.call(this, 'locationKind', function (attr) { return new LocationKindImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //default
	    DataElementImpl.prototype["default"] = function () {
	        return _super.prototype.attribute.call(this, 'default', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDefault
	    DataElementImpl.prototype.setDefault = function (param) {
	        {
	            this.highLevel().attrOrCreate("default").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //example
	    DataElementImpl.prototype.example = function () {
	        return _super.prototype.attribute.call(this, 'example', this.toString);
	    };
	    /**
	     *
	     **/
	    //setExample
	    DataElementImpl.prototype.setExample = function (param) {
	        {
	            this.highLevel().attrOrCreate("example").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //examples
	    DataElementImpl.prototype.examples = function () {
	        return _super.prototype.elements.call(this, 'examples');
	    };
	    /**
	     *
	     **/
	    //repeat
	    DataElementImpl.prototype.repeat = function () {
	        return _super.prototype.attribute.call(this, 'repeat', this.toBoolean);
	    };
	    /**
	     *
	     **/
	    //setRepeat
	    DataElementImpl.prototype.setRepeat = function (param) {
	        {
	            this.highLevel().attrOrCreate("repeat").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //required
	    DataElementImpl.prototype.required = function () {
	        return _super.prototype.attribute.call(this, 'required', this.toBoolean);
	    };
	    /**
	     *
	     **/
	    //setRequired
	    DataElementImpl.prototype.setRequired = function (param) {
	        {
	            this.highLevel().attrOrCreate("required").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //displayName
	    DataElementImpl.prototype.displayName = function () {
	        return _super.prototype.attribute.call(this, 'displayName', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDisplayName
	    DataElementImpl.prototype.setDisplayName = function (param) {
	        {
	            this.highLevel().attrOrCreate("displayName").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //description
	    DataElementImpl.prototype.description = function () {
	        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //annotations
	    DataElementImpl.prototype.annotations = function () {
	        return _super.prototype.attributes.call(this, 'annotations', function (attr) { return new AnnotationRefImpl(attr); });
	    };
	    return DataElementImpl;
	})(RAMLLanguageElementImpl);
	exports.DataElementImpl = DataElementImpl;
	var XMLInfoImpl = (function (_super) {
	    __extends(XMLInfoImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function XMLInfoImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createXMLInfo(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    XMLInfoImpl.prototype.wrapperClassName = function () {
	        return "XMLInfoImpl";
	    };
	    /**
	     *
	     **/
	    //name
	    XMLInfoImpl.prototype.name = function () {
	        return _super.prototype.attribute.call(this, 'name', this.toString);
	    };
	    /**
	     *
	     **/
	    //setName
	    XMLInfoImpl.prototype.setName = function (param) {
	        {
	            this.highLevel().attrOrCreate("name").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //namespace
	    XMLInfoImpl.prototype.namespace = function () {
	        return _super.prototype.attribute.call(this, 'namespace', this.toString);
	    };
	    /**
	     *
	     **/
	    //setNamespace
	    XMLInfoImpl.prototype.setNamespace = function (param) {
	        {
	            this.highLevel().attrOrCreate("namespace").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //prefix
	    XMLInfoImpl.prototype.prefix = function () {
	        return _super.prototype.attribute.call(this, 'prefix', this.toString);
	    };
	    /**
	     *
	     **/
	    //setPrefix
	    XMLInfoImpl.prototype.setPrefix = function (param) {
	        {
	            this.highLevel().attrOrCreate("prefix").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //attribute
	    XMLInfoImpl.prototype.attribute = function () {
	        return _super.prototype.attribute.call(this, 'attribute', this.toBoolean);
	    };
	    /**
	     *
	     **/
	    //setAttribute
	    XMLInfoImpl.prototype.setAttribute = function (param) {
	        {
	            this.highLevel().attrOrCreate("attribute").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //wrapped
	    XMLInfoImpl.prototype.wrapped = function () {
	        return _super.prototype.attribute.call(this, 'wrapped', this.toBoolean);
	    };
	    /**
	     *
	     **/
	    //setWrapped
	    XMLInfoImpl.prototype.setWrapped = function (param) {
	        {
	            this.highLevel().attrOrCreate("wrapped").setValue("" + param);
	            return this;
	        }
	    };
	    return XMLInfoImpl;
	})(BasicNodeImpl);
	exports.XMLInfoImpl = XMLInfoImpl;
	var ModelLocationImpl = (function () {
	    /**
	     *
	     **/
	    //constructor
	    function ModelLocationImpl(attr) {
	        this.attr = attr;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ModelLocationImpl.prototype.wrapperClassName = function () {
	        return "ModelLocationImpl";
	    };
	    return ModelLocationImpl;
	})();
	exports.ModelLocationImpl = ModelLocationImpl;
	var LocationKindImpl = (function () {
	    /**
	     *
	     **/
	    //constructor
	    function LocationKindImpl(attr) {
	        this.attr = attr;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    LocationKindImpl.prototype.wrapperClassName = function () {
	        return "LocationKindImpl";
	    };
	    return LocationKindImpl;
	})();
	exports.LocationKindImpl = LocationKindImpl;
	var ExampleSpecImpl = (function (_super) {
	    __extends(ExampleSpecImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ExampleSpecImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createExampleSpec(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ExampleSpecImpl.prototype.wrapperClassName = function () {
	        return "ExampleSpecImpl";
	    };
	    /**
	     *
	     **/
	    //content
	    ExampleSpecImpl.prototype.content = function () {
	        return _super.prototype.attribute.call(this, 'content', this.toString);
	    };
	    /**
	     *
	     **/
	    //setContent
	    ExampleSpecImpl.prototype.setContent = function (param) {
	        {
	            this.highLevel().attrOrCreate("content").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //strict
	    ExampleSpecImpl.prototype.strict = function () {
	        return _super.prototype.attribute.call(this, 'strict', this.toBoolean);
	    };
	    /**
	     *
	     **/
	    //setStrict
	    ExampleSpecImpl.prototype.setStrict = function (param) {
	        {
	            this.highLevel().attrOrCreate("strict").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //name
	    ExampleSpecImpl.prototype.name = function () {
	        return _super.prototype.attribute.call(this, 'name', this.toString);
	    };
	    /**
	     *
	     **/
	    //setName
	    ExampleSpecImpl.prototype.setName = function (param) {
	        {
	            this.highLevel().attrOrCreate("name").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //displayName
	    ExampleSpecImpl.prototype.displayName = function () {
	        return _super.prototype.attribute.call(this, 'displayName', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDisplayName
	    ExampleSpecImpl.prototype.setDisplayName = function (param) {
	        {
	            this.highLevel().attrOrCreate("displayName").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //description
	    ExampleSpecImpl.prototype.description = function () {
	        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //annotations
	    ExampleSpecImpl.prototype.annotations = function () {
	        return _super.prototype.attributes.call(this, 'annotations', function (attr) { return new AnnotationRefImpl(attr); });
	    };
	    return ExampleSpecImpl;
	})(RAMLLanguageElementImpl);
	exports.ExampleSpecImpl = ExampleSpecImpl;
	var FileParameterImpl = (function (_super) {
	    __extends(FileParameterImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function FileParameterImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createFileParameter(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    FileParameterImpl.prototype.wrapperClassName = function () {
	        return "FileParameterImpl";
	    };
	    /**
	     *
	     **/
	    //fileTypes
	    FileParameterImpl.prototype.fileTypes = function () {
	        return _super.prototype.attributes.call(this, 'fileTypes', function (attr) { return new ContentTypeImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //minLength
	    FileParameterImpl.prototype.minLength = function () {
	        return _super.prototype.attribute.call(this, 'minLength', this.toNumber);
	    };
	    /**
	     *
	     **/
	    //setMinLength
	    FileParameterImpl.prototype.setMinLength = function (param) {
	        {
	            this.highLevel().attrOrCreate("minLength").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //maxLength
	    FileParameterImpl.prototype.maxLength = function () {
	        return _super.prototype.attribute.call(this, 'maxLength', this.toNumber);
	    };
	    /**
	     *
	     **/
	    //setMaxLength
	    FileParameterImpl.prototype.setMaxLength = function (param) {
	        {
	            this.highLevel().attrOrCreate("maxLength").setValue("" + param);
	            return this;
	        }
	    };
	    return FileParameterImpl;
	})(DataElementImpl);
	exports.FileParameterImpl = FileParameterImpl;
	var ArrayFieldImpl = (function (_super) {
	    __extends(ArrayFieldImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ArrayFieldImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createArrayField(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ArrayFieldImpl.prototype.wrapperClassName = function () {
	        return "ArrayFieldImpl";
	    };
	    /**
	     *
	     **/
	    //uniqueItems
	    ArrayFieldImpl.prototype.uniqueItems = function () {
	        return _super.prototype.attribute.call(this, 'uniqueItems', this.toBoolean);
	    };
	    /**
	     *
	     **/
	    //setUniqueItems
	    ArrayFieldImpl.prototype.setUniqueItems = function (param) {
	        {
	            this.highLevel().attrOrCreate("uniqueItems").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //items
	    ArrayFieldImpl.prototype.items = function () {
	        return _super.prototype.element.call(this, 'items');
	    };
	    /**
	     *
	     **/
	    //minItems
	    ArrayFieldImpl.prototype.minItems = function () {
	        return _super.prototype.attribute.call(this, 'minItems', this.toNumber);
	    };
	    /**
	     *
	     **/
	    //setMinItems
	    ArrayFieldImpl.prototype.setMinItems = function (param) {
	        {
	            this.highLevel().attrOrCreate("minItems").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //maxItems
	    ArrayFieldImpl.prototype.maxItems = function () {
	        return _super.prototype.attribute.call(this, 'maxItems', this.toNumber);
	    };
	    /**
	     *
	     **/
	    //setMaxItems
	    ArrayFieldImpl.prototype.setMaxItems = function (param) {
	        {
	            this.highLevel().attrOrCreate("maxItems").setValue("" + param);
	            return this;
	        }
	    };
	    return ArrayFieldImpl;
	})(DataElementImpl);
	exports.ArrayFieldImpl = ArrayFieldImpl;
	var UnionFieldImpl = (function (_super) {
	    __extends(UnionFieldImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function UnionFieldImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createUnionField(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    UnionFieldImpl.prototype.wrapperClassName = function () {
	        return "UnionFieldImpl";
	    };
	    /**
	     *
	     **/
	    //discriminator
	    UnionFieldImpl.prototype.discriminator = function () {
	        return _super.prototype.attribute.call(this, 'discriminator', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDiscriminator
	    UnionFieldImpl.prototype.setDiscriminator = function (param) {
	        {
	            this.highLevel().attrOrCreate("discriminator").setValue("" + param);
	            return this;
	        }
	    };
	    return UnionFieldImpl;
	})(DataElementImpl);
	exports.UnionFieldImpl = UnionFieldImpl;
	var ObjectFieldImpl = (function (_super) {
	    __extends(ObjectFieldImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ObjectFieldImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createObjectField(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ObjectFieldImpl.prototype.wrapperClassName = function () {
	        return "ObjectFieldImpl";
	    };
	    /**
	     *
	     **/
	    //properties
	    ObjectFieldImpl.prototype.properties = function () {
	        return _super.prototype.elements.call(this, 'properties');
	    };
	    /**
	     *
	     **/
	    //minProperties
	    ObjectFieldImpl.prototype.minProperties = function () {
	        return _super.prototype.attribute.call(this, 'minProperties', this.toNumber);
	    };
	    /**
	     *
	     **/
	    //setMinProperties
	    ObjectFieldImpl.prototype.setMinProperties = function (param) {
	        {
	            this.highLevel().attrOrCreate("minProperties").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //maxProperties
	    ObjectFieldImpl.prototype.maxProperties = function () {
	        return _super.prototype.attribute.call(this, 'maxProperties', this.toNumber);
	    };
	    /**
	     *
	     **/
	    //setMaxProperties
	    ObjectFieldImpl.prototype.setMaxProperties = function (param) {
	        {
	            this.highLevel().attrOrCreate("maxProperties").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //additionalProperties
	    ObjectFieldImpl.prototype.additionalProperties = function () {
	        return _super.prototype.element.call(this, 'additionalProperties');
	    };
	    /**
	     *
	     **/
	    //patternProperties
	    ObjectFieldImpl.prototype.patternProperties = function () {
	        return _super.prototype.elements.call(this, 'patternProperties');
	    };
	    /**
	     *
	     **/
	    //discriminator
	    ObjectFieldImpl.prototype.discriminator = function () {
	        return _super.prototype.attribute.call(this, 'discriminator', function (attr) { return new pointerImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //discriminatorValue
	    ObjectFieldImpl.prototype.discriminatorValue = function () {
	        return _super.prototype.attribute.call(this, 'discriminatorValue', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDiscriminatorValue
	    ObjectFieldImpl.prototype.setDiscriminatorValue = function (param) {
	        {
	            this.highLevel().attrOrCreate("discriminatorValue").setValue("" + param);
	            return this;
	        }
	    };
	    return ObjectFieldImpl;
	})(DataElementImpl);
	exports.ObjectFieldImpl = ObjectFieldImpl;
	var StrElementImpl = (function (_super) {
	    __extends(StrElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function StrElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createStrElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    StrElementImpl.prototype.wrapperClassName = function () {
	        return "StrElementImpl";
	    };
	    /**
	     *
	     **/
	    //pattern
	    StrElementImpl.prototype.pattern = function () {
	        return _super.prototype.attribute.call(this, 'pattern', this.toString);
	    };
	    /**
	     *
	     **/
	    //setPattern
	    StrElementImpl.prototype.setPattern = function (param) {
	        {
	            this.highLevel().attrOrCreate("pattern").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //minLength
	    StrElementImpl.prototype.minLength = function () {
	        return _super.prototype.attribute.call(this, 'minLength', this.toNumber);
	    };
	    /**
	     *
	     **/
	    //setMinLength
	    StrElementImpl.prototype.setMinLength = function (param) {
	        {
	            this.highLevel().attrOrCreate("minLength").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //maxLength
	    StrElementImpl.prototype.maxLength = function () {
	        return _super.prototype.attribute.call(this, 'maxLength', this.toNumber);
	    };
	    /**
	     *
	     **/
	    //setMaxLength
	    StrElementImpl.prototype.setMaxLength = function (param) {
	        {
	            this.highLevel().attrOrCreate("maxLength").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //enum
	    StrElementImpl.prototype.enum = function () {
	        return _super.prototype.attributes.call(this, 'enum', this.toString);
	    };
	    /**
	     *
	     **/
	    //setEnum
	    StrElementImpl.prototype.setEnum = function (param) {
	        {
	            this.highLevel().attrOrCreate("enum").setValue("" + param);
	            return this;
	        }
	    };
	    return StrElementImpl;
	})(DataElementImpl);
	exports.StrElementImpl = StrElementImpl;
	var BooleanElementImpl = (function (_super) {
	    __extends(BooleanElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function BooleanElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createBooleanElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    BooleanElementImpl.prototype.wrapperClassName = function () {
	        return "BooleanElementImpl";
	    };
	    return BooleanElementImpl;
	})(DataElementImpl);
	exports.BooleanElementImpl = BooleanElementImpl;
	var ValueElementImpl = (function (_super) {
	    __extends(ValueElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ValueElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createValueElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ValueElementImpl.prototype.wrapperClassName = function () {
	        return "ValueElementImpl";
	    };
	    return ValueElementImpl;
	})(DataElementImpl);
	exports.ValueElementImpl = ValueElementImpl;
	var NumberElementImpl = (function (_super) {
	    __extends(NumberElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function NumberElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createNumberElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    NumberElementImpl.prototype.wrapperClassName = function () {
	        return "NumberElementImpl";
	    };
	    /**
	     *
	     **/
	    //minimum
	    NumberElementImpl.prototype.minimum = function () {
	        return _super.prototype.attribute.call(this, 'minimum', this.toNumber);
	    };
	    /**
	     *
	     **/
	    //setMinimum
	    NumberElementImpl.prototype.setMinimum = function (param) {
	        {
	            this.highLevel().attrOrCreate("minimum").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //maximum
	    NumberElementImpl.prototype.maximum = function () {
	        return _super.prototype.attribute.call(this, 'maximum', this.toNumber);
	    };
	    /**
	     *
	     **/
	    //setMaximum
	    NumberElementImpl.prototype.setMaximum = function (param) {
	        {
	            this.highLevel().attrOrCreate("maximum").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //enum
	    NumberElementImpl.prototype.enum = function () {
	        return _super.prototype.attributes.call(this, 'enum', this.toString);
	    };
	    /**
	     *
	     **/
	    //setEnum
	    NumberElementImpl.prototype.setEnum = function (param) {
	        {
	            this.highLevel().attrOrCreate("enum").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //format
	    NumberElementImpl.prototype.format = function () {
	        return _super.prototype.attribute.call(this, 'format', this.toString);
	    };
	    /**
	     *
	     **/
	    //setFormat
	    NumberElementImpl.prototype.setFormat = function (param) {
	        {
	            this.highLevel().attrOrCreate("format").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //multipleOf
	    NumberElementImpl.prototype.multipleOf = function () {
	        return _super.prototype.attribute.call(this, 'multipleOf', this.toNumber);
	    };
	    /**
	     *
	     **/
	    //setMultipleOf
	    NumberElementImpl.prototype.setMultipleOf = function (param) {
	        {
	            this.highLevel().attrOrCreate("multipleOf").setValue("" + param);
	            return this;
	        }
	    };
	    return NumberElementImpl;
	})(DataElementImpl);
	exports.NumberElementImpl = NumberElementImpl;
	var IntegerElementImpl = (function (_super) {
	    __extends(IntegerElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function IntegerElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createIntegerElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    IntegerElementImpl.prototype.wrapperClassName = function () {
	        return "IntegerElementImpl";
	    };
	    /**
	     *
	     **/
	    //format
	    IntegerElementImpl.prototype.format = function () {
	        return _super.prototype.attribute.call(this, 'format', this.toString);
	    };
	    /**
	     *
	     **/
	    //setFormat
	    IntegerElementImpl.prototype.setFormat = function (param) {
	        {
	            this.highLevel().attrOrCreate("format").setValue("" + param);
	            return this;
	        }
	    };
	    return IntegerElementImpl;
	})(NumberElementImpl);
	exports.IntegerElementImpl = IntegerElementImpl;
	var RAMLPointerElementImpl = (function (_super) {
	    __extends(RAMLPointerElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function RAMLPointerElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createRAMLPointerElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    RAMLPointerElementImpl.prototype.wrapperClassName = function () {
	        return "RAMLPointerElementImpl";
	    };
	    /**
	     *
	     **/
	    //target
	    RAMLPointerElementImpl.prototype.target = function () {
	        return _super.prototype.attribute.call(this, 'target', function (attr) { return new RAMLSelectorImpl(attr); });
	    };
	    return RAMLPointerElementImpl;
	})(DataElementImpl);
	exports.RAMLPointerElementImpl = RAMLPointerElementImpl;
	var RAMLExpressionImpl = (function (_super) {
	    __extends(RAMLExpressionImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function RAMLExpressionImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createRAMLExpression(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    RAMLExpressionImpl.prototype.wrapperClassName = function () {
	        return "RAMLExpressionImpl";
	    };
	    return RAMLExpressionImpl;
	})(DataElementImpl);
	exports.RAMLExpressionImpl = RAMLExpressionImpl;
	var ScriptHookElementImpl = (function (_super) {
	    __extends(ScriptHookElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ScriptHookElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createScriptHookElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ScriptHookElementImpl.prototype.wrapperClassName = function () {
	        return "ScriptHookElementImpl";
	    };
	    /**
	     *
	     **/
	    //declaredIn
	    ScriptHookElementImpl.prototype.declaredIn = function () {
	        return _super.prototype.attribute.call(this, 'declaredIn', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDeclaredIn
	    ScriptHookElementImpl.prototype.setDeclaredIn = function (param) {
	        {
	            this.highLevel().attrOrCreate("declaredIn").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //interfaceName
	    ScriptHookElementImpl.prototype.interfaceName = function () {
	        return _super.prototype.attribute.call(this, 'interfaceName', this.toString);
	    };
	    /**
	     *
	     **/
	    //setInterfaceName
	    ScriptHookElementImpl.prototype.setInterfaceName = function (param) {
	        {
	            this.highLevel().attrOrCreate("interfaceName").setValue("" + param);
	            return this;
	        }
	    };
	    return ScriptHookElementImpl;
	})(DataElementImpl);
	exports.ScriptHookElementImpl = ScriptHookElementImpl;
	var SchemaElementImpl = (function (_super) {
	    __extends(SchemaElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function SchemaElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createSchemaElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    SchemaElementImpl.prototype.wrapperClassName = function () {
	        return "SchemaElementImpl";
	    };
	    return SchemaElementImpl;
	})(DataElementImpl);
	exports.SchemaElementImpl = SchemaElementImpl;
	var DateElementImpl = (function (_super) {
	    __extends(DateElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function DateElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createDateElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    DateElementImpl.prototype.wrapperClassName = function () {
	        return "DateElementImpl";
	    };
	    /**
	     *
	     **/
	    //dateFormat
	    DateElementImpl.prototype.dateFormat = function () {
	        return _super.prototype.attribute.call(this, 'dateFormat', function (attr) { return new DateFormatSpecImpl(attr); });
	    };
	    return DateElementImpl;
	})(DataElementImpl);
	exports.DateElementImpl = DateElementImpl;
	var HasNormalParametersImpl = (function (_super) {
	    __extends(HasNormalParametersImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function HasNormalParametersImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createHasNormalParameters(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    HasNormalParametersImpl.prototype.wrapperClassName = function () {
	        return "HasNormalParametersImpl";
	    };
	    /**
	     *
	     **/
	    //queryParameters
	    HasNormalParametersImpl.prototype.queryParameters = function () {
	        return _super.prototype.elements.call(this, 'queryParameters');
	    };
	    /**
	     *
	     **/
	    //headers
	    HasNormalParametersImpl.prototype.headers = function () {
	        return _super.prototype.elements.call(this, 'headers');
	    };
	    /**
	     *
	     **/
	    //queryString
	    HasNormalParametersImpl.prototype.queryString = function () {
	        return _super.prototype.element.call(this, 'queryString');
	    };
	    return HasNormalParametersImpl;
	})(RAMLLanguageElementImpl);
	exports.HasNormalParametersImpl = HasNormalParametersImpl;
	var MethodBaseImpl = (function (_super) {
	    __extends(MethodBaseImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function MethodBaseImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createMethodBase(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    MethodBaseImpl.prototype.wrapperClassName = function () {
	        return "MethodBaseImpl";
	    };
	    /**
	     *
	     **/
	    //responses
	    MethodBaseImpl.prototype.responses = function () {
	        return _super.prototype.elements.call(this, 'responses');
	    };
	    /**
	     *
	     **/
	    //body
	    MethodBaseImpl.prototype.body = function () {
	        return _super.prototype.elements.call(this, 'body');
	    };
	    /**
	     *
	     **/
	    //protocols
	    MethodBaseImpl.prototype.protocols = function () {
	        return _super.prototype.attributes.call(this, 'protocols', this.toString);
	    };
	    /**
	     *
	     **/
	    //setProtocols
	    MethodBaseImpl.prototype.setProtocols = function (param) {
	        {
	            this.highLevel().attrOrCreate("protocols").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //is
	    MethodBaseImpl.prototype.is = function () {
	        return _super.prototype.attributes.call(this, 'is', function (attr) { return new TraitRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //securedBy
	    MethodBaseImpl.prototype.securedBy = function () {
	        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemaRefImpl(attr); });
	    };
	    return MethodBaseImpl;
	})(HasNormalParametersImpl);
	exports.MethodBaseImpl = MethodBaseImpl;
	var ResponseImpl = (function (_super) {
	    __extends(ResponseImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ResponseImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createResponse(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ResponseImpl.prototype.wrapperClassName = function () {
	        return "ResponseImpl";
	    };
	    /**
	     *
	     **/
	    //code
	    ResponseImpl.prototype.code = function () {
	        return _super.prototype.attribute.call(this, 'code', function (attr) { return new StatusCodeImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //headers
	    ResponseImpl.prototype.headers = function () {
	        return _super.prototype.elements.call(this, 'headers');
	    };
	    /**
	     *
	     **/
	    //body
	    ResponseImpl.prototype.body = function () {
	        return _super.prototype.elements.call(this, 'body');
	    };
	    /**
	     *
	     **/
	    //displayName
	    ResponseImpl.prototype.displayName = function () {
	        return _super.prototype.attribute.call(this, 'displayName', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDisplayName
	    ResponseImpl.prototype.setDisplayName = function (param) {
	        {
	            this.highLevel().attrOrCreate("displayName").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //description
	    ResponseImpl.prototype.description = function () {
	        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //annotations
	    ResponseImpl.prototype.annotations = function () {
	        return _super.prototype.attributes.call(this, 'annotations', function (attr) { return new AnnotationRefImpl(attr); });
	    };
	    return ResponseImpl;
	})(RAMLLanguageElementImpl);
	exports.ResponseImpl = ResponseImpl;
	var TraitImpl = (function (_super) {
	    __extends(TraitImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function TraitImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createTrait(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    TraitImpl.prototype.wrapperClassName = function () {
	        return "TraitImpl";
	    };
	    /**
	     *
	     **/
	    //name
	    TraitImpl.prototype.name = function () {
	        return _super.prototype.attribute.call(this, 'name', this.toString);
	    };
	    /**
	     *
	     **/
	    //setName
	    TraitImpl.prototype.setName = function (param) {
	        {
	            this.highLevel().attrOrCreate("name").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //usage
	    TraitImpl.prototype.usage = function () {
	        return _super.prototype.attribute.call(this, 'usage', this.toString);
	    };
	    /**
	     *
	     **/
	    //setUsage
	    TraitImpl.prototype.setUsage = function (param) {
	        {
	            this.highLevel().attrOrCreate("usage").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //uses
	    TraitImpl.prototype.uses = function () {
	        return _super.prototype.elements.call(this, 'uses');
	    };
	    return TraitImpl;
	})(MethodBaseImpl);
	exports.TraitImpl = TraitImpl;
	var LibraryImpl = (function (_super) {
	    __extends(LibraryImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function LibraryImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createLibrary(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    LibraryImpl.prototype.wrapperClassName = function () {
	        return "LibraryImpl";
	    };
	    /**
	     *
	     **/
	    //name
	    LibraryImpl.prototype.name = function () {
	        return _super.prototype.attribute.call(this, 'name', this.toString);
	    };
	    /**
	     *
	     **/
	    //setName
	    LibraryImpl.prototype.setName = function (param) {
	        {
	            this.highLevel().attrOrCreate("name").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //schemas
	    LibraryImpl.prototype.schemas = function () {
	        return _super.prototype.elements.call(this, 'schemas');
	    };
	    /**
	     *
	     **/
	    //usage
	    LibraryImpl.prototype.usage = function () {
	        return _super.prototype.attribute.call(this, 'usage', this.toString);
	    };
	    /**
	     *
	     **/
	    //setUsage
	    LibraryImpl.prototype.setUsage = function (param) {
	        {
	            this.highLevel().attrOrCreate("usage").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //annotations
	    LibraryImpl.prototype.annotations = function () {
	        return _super.prototype.attributes.call(this, 'annotations', function (attr) { return new AnnotationRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //types
	    LibraryImpl.prototype.types = function () {
	        return _super.prototype.elements.call(this, 'types');
	    };
	    /**
	     *
	     **/
	    //traits
	    LibraryImpl.prototype.traits = function () {
	        return _super.prototype.elements.call(this, 'traits');
	    };
	    /**
	     *
	     **/
	    //resourceTypes
	    LibraryImpl.prototype.resourceTypes = function () {
	        return _super.prototype.elements.call(this, 'resourceTypes');
	    };
	    /**
	     *
	     **/
	    //annotationTypes
	    LibraryImpl.prototype.annotationTypes = function () {
	        return _super.prototype.elements.call(this, 'annotationTypes');
	    };
	    /**
	     *
	     **/
	    //securitySchemaTypes
	    LibraryImpl.prototype.securitySchemaTypes = function () {
	        return _super.prototype.elements.call(this, 'securitySchemaTypes');
	    };
	    /**
	     *
	     **/
	    //securitySchemes
	    LibraryImpl.prototype.securitySchemes = function () {
	        return _super.prototype.elements.call(this, 'securitySchemes');
	    };
	    /**
	     *
	     **/
	    //uses
	    LibraryImpl.prototype.uses = function () {
	        return _super.prototype.elements.call(this, 'uses');
	    };
	    return LibraryImpl;
	})(BasicNodeImpl);
	exports.LibraryImpl = LibraryImpl;
	var RAMLSimpleElementImpl = (function (_super) {
	    __extends(RAMLSimpleElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function RAMLSimpleElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createRAMLSimpleElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    RAMLSimpleElementImpl.prototype.wrapperClassName = function () {
	        return "RAMLSimpleElementImpl";
	    };
	    return RAMLSimpleElementImpl;
	})(BasicNodeImpl);
	exports.RAMLSimpleElementImpl = RAMLSimpleElementImpl;
	var ImportDeclarationImpl = (function (_super) {
	    __extends(ImportDeclarationImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ImportDeclarationImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createImportDeclaration(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ImportDeclarationImpl.prototype.wrapperClassName = function () {
	        return "ImportDeclarationImpl";
	    };
	    /**
	     *
	     **/
	    //key
	    ImportDeclarationImpl.prototype.key = function () {
	        return _super.prototype.attribute.call(this, 'key', this.toString);
	    };
	    /**
	     *
	     **/
	    //setKey
	    ImportDeclarationImpl.prototype.setKey = function (param) {
	        {
	            this.highLevel().attrOrCreate("key").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //value
	    ImportDeclarationImpl.prototype.value = function () {
	        return _super.prototype.element.call(this, 'value');
	    };
	    return ImportDeclarationImpl;
	})(RAMLSimpleElementImpl);
	exports.ImportDeclarationImpl = ImportDeclarationImpl;
	var GlobalSchemaImpl = (function (_super) {
	    __extends(GlobalSchemaImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function GlobalSchemaImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createGlobalSchema(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    GlobalSchemaImpl.prototype.wrapperClassName = function () {
	        return "GlobalSchemaImpl";
	    };
	    /**
	     *
	     **/
	    //key
	    GlobalSchemaImpl.prototype.key = function () {
	        return _super.prototype.attribute.call(this, 'key', this.toString);
	    };
	    /**
	     *
	     **/
	    //setKey
	    GlobalSchemaImpl.prototype.setKey = function (param) {
	        {
	            this.highLevel().attrOrCreate("key").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //value
	    GlobalSchemaImpl.prototype.value = function () {
	        return _super.prototype.attribute.call(this, 'value', function (attr) { return new SchemaStringImpl(attr); });
	    };
	    return GlobalSchemaImpl;
	})(RAMLSimpleElementImpl);
	exports.GlobalSchemaImpl = GlobalSchemaImpl;
	var ResourceBaseImpl = (function (_super) {
	    __extends(ResourceBaseImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ResourceBaseImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createResourceBase(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ResourceBaseImpl.prototype.wrapperClassName = function () {
	        return "ResourceBaseImpl";
	    };
	    /**
	     *
	     **/
	    //methods
	    ResourceBaseImpl.prototype.methods = function () {
	        return _super.prototype.elements.call(this, 'methods');
	    };
	    /**
	     *
	     **/
	    //is
	    ResourceBaseImpl.prototype.is = function () {
	        return _super.prototype.attributes.call(this, 'is', function (attr) { return new TraitRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //type
	    ResourceBaseImpl.prototype["type"] = function () {
	        return _super.prototype.attribute.call(this, 'type', function (attr) { return new ResourceTypeRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //securedBy
	    ResourceBaseImpl.prototype.securedBy = function () {
	        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemaRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //uriParameters
	    ResourceBaseImpl.prototype.uriParameters = function () {
	        return _super.prototype.elements.call(this, 'uriParameters');
	    };
	    return ResourceBaseImpl;
	})(RAMLLanguageElementImpl);
	exports.ResourceBaseImpl = ResourceBaseImpl;
	var MethodImpl = (function (_super) {
	    __extends(MethodImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function MethodImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createMethod(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    MethodImpl.prototype.wrapperClassName = function () {
	        return "MethodImpl";
	    };
	    /**
	     *
	     **/
	    //signature
	    MethodImpl.prototype.signature = function () {
	        return _super.prototype.attribute.call(this, 'signature', function (attr) { return new SchemaStringImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //method
	    MethodImpl.prototype.method = function () {
	        return _super.prototype.attribute.call(this, 'method', this.toString);
	    };
	    /**
	     *
	     **/
	    //setMethod
	    MethodImpl.prototype.setMethod = function (param) {
	        {
	            this.highLevel().attrOrCreate("method").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //displayName
	    MethodImpl.prototype.displayName = function () {
	        return _super.prototype.attribute.call(this, 'displayName', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDisplayName
	    MethodImpl.prototype.setDisplayName = function (param) {
	        {
	            this.highLevel().attrOrCreate("displayName").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //description
	    MethodImpl.prototype.description = function () {
	        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //queryString
	    MethodImpl.prototype.queryString = function () {
	        return _super.prototype.element.call(this, 'queryString');
	    };
	    /**
	     *
	     **/
	    //queryParameters
	    MethodImpl.prototype.queryParameters = function () {
	        return _super.prototype.elements.call(this, 'queryParameters');
	    };
	    /**
	     *
	     **/
	    //headers
	    MethodImpl.prototype.headers = function () {
	        return _super.prototype.elements.call(this, 'headers');
	    };
	    /**
	     *
	     **/
	    //body
	    MethodImpl.prototype.body = function () {
	        return _super.prototype.elements.call(this, 'body');
	    };
	    /**
	     *
	     **/
	    //is
	    MethodImpl.prototype.is = function () {
	        return _super.prototype.attributes.call(this, 'is', function (attr) { return new TraitRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //annotations
	    MethodImpl.prototype.annotations = function () {
	        return _super.prototype.attributes.call(this, 'annotations', function (attr) { return new AnnotationRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //securedBy
	    MethodImpl.prototype.securedBy = function () {
	        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemaRefImpl(attr); });
	    };
	    return MethodImpl;
	})(MethodBaseImpl);
	exports.MethodImpl = MethodImpl;
	var ResourceImpl = (function (_super) {
	    __extends(ResourceImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ResourceImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createResource(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ResourceImpl.prototype.wrapperClassName = function () {
	        return "ResourceImpl";
	    };
	    /**
	     *
	     **/
	    //signature
	    ResourceImpl.prototype.signature = function () {
	        return _super.prototype.attribute.call(this, 'signature', function (attr) { return new SchemaStringImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //relativeUri
	    ResourceImpl.prototype.relativeUri = function () {
	        return _super.prototype.attribute.call(this, 'relativeUri', function (attr) { return new RelativeUriImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //resources
	    ResourceImpl.prototype.resources = function () {
	        return _super.prototype.elements.call(this, 'resources');
	    };
	    /**
	     *
	     **/
	    //displayName
	    ResourceImpl.prototype.displayName = function () {
	        return _super.prototype.attribute.call(this, 'displayName', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDisplayName
	    ResourceImpl.prototype.setDisplayName = function (param) {
	        {
	            this.highLevel().attrOrCreate("displayName").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //description
	    ResourceImpl.prototype.description = function () {
	        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //annotations
	    ResourceImpl.prototype.annotations = function () {
	        return _super.prototype.attributes.call(this, 'annotations', function (attr) { return new AnnotationRefImpl(attr); });
	    };
	    return ResourceImpl;
	})(ResourceBaseImpl);
	exports.ResourceImpl = ResourceImpl;
	var ResourceTypeImpl = (function (_super) {
	    __extends(ResourceTypeImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ResourceTypeImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createResourceType(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ResourceTypeImpl.prototype.wrapperClassName = function () {
	        return "ResourceTypeImpl";
	    };
	    /**
	     *
	     **/
	    //name
	    ResourceTypeImpl.prototype.name = function () {
	        return _super.prototype.attribute.call(this, 'name', this.toString);
	    };
	    /**
	     *
	     **/
	    //setName
	    ResourceTypeImpl.prototype.setName = function (param) {
	        {
	            this.highLevel().attrOrCreate("name").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //usage
	    ResourceTypeImpl.prototype.usage = function () {
	        return _super.prototype.attribute.call(this, 'usage', this.toString);
	    };
	    /**
	     *
	     **/
	    //setUsage
	    ResourceTypeImpl.prototype.setUsage = function (param) {
	        {
	            this.highLevel().attrOrCreate("usage").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //uses
	    ResourceTypeImpl.prototype.uses = function () {
	        return _super.prototype.elements.call(this, 'uses');
	    };
	    return ResourceTypeImpl;
	})(ResourceBaseImpl);
	exports.ResourceTypeImpl = ResourceTypeImpl;
	var AnnotationTypeImpl = (function (_super) {
	    __extends(AnnotationTypeImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function AnnotationTypeImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createAnnotationType(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    AnnotationTypeImpl.prototype.wrapperClassName = function () {
	        return "AnnotationTypeImpl";
	    };
	    /**
	     *
	     **/
	    //name
	    AnnotationTypeImpl.prototype.name = function () {
	        return _super.prototype.attribute.call(this, 'name', this.toString);
	    };
	    /**
	     *
	     **/
	    //setName
	    AnnotationTypeImpl.prototype.setName = function (param) {
	        {
	            this.highLevel().attrOrCreate("name").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //usage
	    AnnotationTypeImpl.prototype.usage = function () {
	        return _super.prototype.attribute.call(this, 'usage', this.toString);
	    };
	    /**
	     *
	     **/
	    //setUsage
	    AnnotationTypeImpl.prototype.setUsage = function (param) {
	        {
	            this.highLevel().attrOrCreate("usage").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //parameters
	    AnnotationTypeImpl.prototype.parameters = function () {
	        return _super.prototype.elements.call(this, 'parameters');
	    };
	    /**
	     *
	     **/
	    //allowMultiple
	    AnnotationTypeImpl.prototype.allowMultiple = function () {
	        return _super.prototype.attribute.call(this, 'allowMultiple', this.toBoolean);
	    };
	    /**
	     *
	     **/
	    //setAllowMultiple
	    AnnotationTypeImpl.prototype.setAllowMultiple = function (param) {
	        {
	            this.highLevel().attrOrCreate("allowMultiple").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //allowedTargets
	    AnnotationTypeImpl.prototype.allowedTargets = function () {
	        return _super.prototype.attributes.call(this, 'allowedTargets', function (attr) { return new AnnotationTargetImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //displayName
	    AnnotationTypeImpl.prototype.displayName = function () {
	        return _super.prototype.attribute.call(this, 'displayName', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDisplayName
	    AnnotationTypeImpl.prototype.setDisplayName = function (param) {
	        {
	            this.highLevel().attrOrCreate("displayName").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //description
	    AnnotationTypeImpl.prototype.description = function () {
	        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
	    };
	    return AnnotationTypeImpl;
	})(RAMLLanguageElementImpl);
	exports.AnnotationTypeImpl = AnnotationTypeImpl;
	var SecuritySchemaImpl = (function (_super) {
	    __extends(SecuritySchemaImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function SecuritySchemaImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createSecuritySchema(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    SecuritySchemaImpl.prototype.wrapperClassName = function () {
	        return "SecuritySchemaImpl";
	    };
	    /**
	     *
	     **/
	    //name
	    SecuritySchemaImpl.prototype.name = function () {
	        return _super.prototype.attribute.call(this, 'name', this.toString);
	    };
	    /**
	     *
	     **/
	    //setName
	    SecuritySchemaImpl.prototype.setName = function (param) {
	        {
	            this.highLevel().attrOrCreate("name").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //type
	    SecuritySchemaImpl.prototype["type"] = function () {
	        return _super.prototype.attribute.call(this, 'type', this.toString);
	    };
	    /**
	     *
	     **/
	    //setType
	    SecuritySchemaImpl.prototype.setType = function (param) {
	        {
	            this.highLevel().attrOrCreate("type").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //description
	    SecuritySchemaImpl.prototype.description = function () {
	        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //describedBy
	    SecuritySchemaImpl.prototype.describedBy = function () {
	        return _super.prototype.element.call(this, 'describedBy');
	    };
	    /**
	     *
	     **/
	    //settings
	    SecuritySchemaImpl.prototype.settings = function () {
	        return _super.prototype.element.call(this, 'settings');
	    };
	    return SecuritySchemaImpl;
	})(RAMLLanguageElementImpl);
	exports.SecuritySchemaImpl = SecuritySchemaImpl;
	var SecuritySchemaSettingsImpl = (function (_super) {
	    __extends(SecuritySchemaSettingsImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function SecuritySchemaSettingsImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createSecuritySchemaSettings(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    SecuritySchemaSettingsImpl.prototype.wrapperClassName = function () {
	        return "SecuritySchemaSettingsImpl";
	    };
	    return SecuritySchemaSettingsImpl;
	})(BasicNodeImpl);
	exports.SecuritySchemaSettingsImpl = SecuritySchemaSettingsImpl;
	var OAuth1SecuritySchemeSettingsImpl = (function (_super) {
	    __extends(OAuth1SecuritySchemeSettingsImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function OAuth1SecuritySchemeSettingsImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createOAuth1SecuritySchemeSettings(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    OAuth1SecuritySchemeSettingsImpl.prototype.wrapperClassName = function () {
	        return "OAuth1SecuritySchemeSettingsImpl";
	    };
	    /**
	     *
	     **/
	    //requestTokenUri
	    OAuth1SecuritySchemeSettingsImpl.prototype.requestTokenUri = function () {
	        return _super.prototype.attribute.call(this, 'requestTokenUri', function (attr) { return new FixedUriImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //authorizationUri
	    OAuth1SecuritySchemeSettingsImpl.prototype.authorizationUri = function () {
	        return _super.prototype.attribute.call(this, 'authorizationUri', function (attr) { return new FixedUriImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //tokenCredentialsUri
	    OAuth1SecuritySchemeSettingsImpl.prototype.tokenCredentialsUri = function () {
	        return _super.prototype.attribute.call(this, 'tokenCredentialsUri', function (attr) { return new FixedUriImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //signatures
	    OAuth1SecuritySchemeSettingsImpl.prototype.signatures = function () {
	        return _super.prototype.attributes.call(this, 'signatures', this.toString);
	    };
	    /**
	     *
	     **/
	    //setSignatures
	    OAuth1SecuritySchemeSettingsImpl.prototype.setSignatures = function (param) {
	        {
	            this.highLevel().attrOrCreate("signatures").setValue("" + param);
	            return this;
	        }
	    };
	    return OAuth1SecuritySchemeSettingsImpl;
	})(SecuritySchemaSettingsImpl);
	exports.OAuth1SecuritySchemeSettingsImpl = OAuth1SecuritySchemeSettingsImpl;
	var OAuth2SecuritySchemeSettingsImpl = (function (_super) {
	    __extends(OAuth2SecuritySchemeSettingsImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function OAuth2SecuritySchemeSettingsImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createOAuth2SecuritySchemeSettings(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    OAuth2SecuritySchemeSettingsImpl.prototype.wrapperClassName = function () {
	        return "OAuth2SecuritySchemeSettingsImpl";
	    };
	    /**
	     *
	     **/
	    //accessTokenUri
	    OAuth2SecuritySchemeSettingsImpl.prototype.accessTokenUri = function () {
	        return _super.prototype.attribute.call(this, 'accessTokenUri', function (attr) { return new FixedUriImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //authorizationUri
	    OAuth2SecuritySchemeSettingsImpl.prototype.authorizationUri = function () {
	        return _super.prototype.attribute.call(this, 'authorizationUri', function (attr) { return new FixedUriImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //authorizationGrants
	    OAuth2SecuritySchemeSettingsImpl.prototype.authorizationGrants = function () {
	        return _super.prototype.attributes.call(this, 'authorizationGrants', this.toString);
	    };
	    /**
	     *
	     **/
	    //setAuthorizationGrants
	    OAuth2SecuritySchemeSettingsImpl.prototype.setAuthorizationGrants = function (param) {
	        {
	            this.highLevel().attrOrCreate("authorizationGrants").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //scopes
	    OAuth2SecuritySchemeSettingsImpl.prototype.scopes = function () {
	        return _super.prototype.attributes.call(this, 'scopes', this.toString);
	    };
	    /**
	     *
	     **/
	    //setScopes
	    OAuth2SecuritySchemeSettingsImpl.prototype.setScopes = function (param) {
	        {
	            this.highLevel().attrOrCreate("scopes").setValue("" + param);
	            return this;
	        }
	    };
	    return OAuth2SecuritySchemeSettingsImpl;
	})(SecuritySchemaSettingsImpl);
	exports.OAuth2SecuritySchemeSettingsImpl = OAuth2SecuritySchemeSettingsImpl;
	var PassThroughSettingsImpl = (function (_super) {
	    __extends(PassThroughSettingsImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function PassThroughSettingsImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createPassThroughSettings(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    PassThroughSettingsImpl.prototype.wrapperClassName = function () {
	        return "PassThroughSettingsImpl";
	    };
	    /**
	     *
	     **/
	    //queryParameterName
	    PassThroughSettingsImpl.prototype.queryParameterName = function () {
	        return _super.prototype.attribute.call(this, 'queryParameterName', this.toString);
	    };
	    /**
	     *
	     **/
	    //setQueryParameterName
	    PassThroughSettingsImpl.prototype.setQueryParameterName = function (param) {
	        {
	            this.highLevel().attrOrCreate("queryParameterName").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //headerName
	    PassThroughSettingsImpl.prototype.headerName = function () {
	        return _super.prototype.attribute.call(this, 'headerName', this.toString);
	    };
	    /**
	     *
	     **/
	    //setHeaderName
	    PassThroughSettingsImpl.prototype.setHeaderName = function (param) {
	        {
	            this.highLevel().attrOrCreate("headerName").setValue("" + param);
	            return this;
	        }
	    };
	    return PassThroughSettingsImpl;
	})(SecuritySchemaSettingsImpl);
	exports.PassThroughSettingsImpl = PassThroughSettingsImpl;
	var Oath2Impl = (function (_super) {
	    __extends(Oath2Impl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function Oath2Impl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createOath2(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    Oath2Impl.prototype.wrapperClassName = function () {
	        return "Oath2Impl";
	    };
	    /**
	     *
	     **/
	    //settings
	    Oath2Impl.prototype.settings = function () {
	        return _super.prototype.element.call(this, 'settings');
	    };
	    return Oath2Impl;
	})(SecuritySchemaImpl);
	exports.Oath2Impl = Oath2Impl;
	var Oath1Impl = (function (_super) {
	    __extends(Oath1Impl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function Oath1Impl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createOath1(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    Oath1Impl.prototype.wrapperClassName = function () {
	        return "Oath1Impl";
	    };
	    /**
	     *
	     **/
	    //settings
	    Oath1Impl.prototype.settings = function () {
	        return _super.prototype.element.call(this, 'settings');
	    };
	    return Oath1Impl;
	})(SecuritySchemaImpl);
	exports.Oath1Impl = Oath1Impl;
	var PassThroughImpl = (function (_super) {
	    __extends(PassThroughImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function PassThroughImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createPassThrough(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    PassThroughImpl.prototype.wrapperClassName = function () {
	        return "PassThroughImpl";
	    };
	    /**
	     *
	     **/
	    //settings
	    PassThroughImpl.prototype.settings = function () {
	        return _super.prototype.element.call(this, 'settings');
	    };
	    return PassThroughImpl;
	})(SecuritySchemaImpl);
	exports.PassThroughImpl = PassThroughImpl;
	var BasicImpl = (function (_super) {
	    __extends(BasicImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function BasicImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createBasic(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    BasicImpl.prototype.wrapperClassName = function () {
	        return "BasicImpl";
	    };
	    return BasicImpl;
	})(SecuritySchemaImpl);
	exports.BasicImpl = BasicImpl;
	var DigestImpl = (function (_super) {
	    __extends(DigestImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function DigestImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createDigest(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    DigestImpl.prototype.wrapperClassName = function () {
	        return "DigestImpl";
	    };
	    return DigestImpl;
	})(SecuritySchemaImpl);
	exports.DigestImpl = DigestImpl;
	var CustomImpl = (function (_super) {
	    __extends(CustomImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function CustomImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createCustom(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    CustomImpl.prototype.wrapperClassName = function () {
	        return "CustomImpl";
	    };
	    return CustomImpl;
	})(SecuritySchemaImpl);
	exports.CustomImpl = CustomImpl;
	var SecuritySchemaPartImpl = (function (_super) {
	    __extends(SecuritySchemaPartImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function SecuritySchemaPartImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createSecuritySchemaPart(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    SecuritySchemaPartImpl.prototype.wrapperClassName = function () {
	        return "SecuritySchemaPartImpl";
	    };
	    /**
	     *
	     **/
	    //headers
	    SecuritySchemaPartImpl.prototype.headers = function () {
	        return _super.prototype.elements.call(this, 'headers');
	    };
	    /**
	     *
	     **/
	    //queryParameters
	    SecuritySchemaPartImpl.prototype.queryParameters = function () {
	        return _super.prototype.elements.call(this, 'queryParameters');
	    };
	    /**
	     *
	     **/
	    //queryString
	    SecuritySchemaPartImpl.prototype.queryString = function () {
	        return _super.prototype.element.call(this, 'queryString');
	    };
	    /**
	     *
	     **/
	    //responses
	    SecuritySchemaPartImpl.prototype.responses = function () {
	        return _super.prototype.elements.call(this, 'responses');
	    };
	    /**
	     *
	     **/
	    //is
	    SecuritySchemaPartImpl.prototype.is = function () {
	        return _super.prototype.attributes.call(this, 'is', function (attr) { return new TraitRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //securedBy
	    SecuritySchemaPartImpl.prototype.securedBy = function () {
	        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemaRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //displayName
	    SecuritySchemaPartImpl.prototype.displayName = function () {
	        return _super.prototype.attribute.call(this, 'displayName', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDisplayName
	    SecuritySchemaPartImpl.prototype.setDisplayName = function (param) {
	        {
	            this.highLevel().attrOrCreate("displayName").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //description
	    SecuritySchemaPartImpl.prototype.description = function () {
	        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //annotations
	    SecuritySchemaPartImpl.prototype.annotations = function () {
	        return _super.prototype.attributes.call(this, 'annotations', function (attr) { return new AnnotationRefImpl(attr); });
	    };
	    return SecuritySchemaPartImpl;
	})(MethodBaseImpl);
	exports.SecuritySchemaPartImpl = SecuritySchemaPartImpl;
	var OLibraryImpl = (function (_super) {
	    __extends(OLibraryImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function OLibraryImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createOLibrary(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    OLibraryImpl.prototype.wrapperClassName = function () {
	        return "OLibraryImpl";
	    };
	    /**
	     *
	     **/
	    //name
	    OLibraryImpl.prototype.name = function () {
	        return _super.prototype.attribute.call(this, 'name', this.toString);
	    };
	    /**
	     *
	     **/
	    //setName
	    OLibraryImpl.prototype.setName = function (param) {
	        {
	            this.highLevel().attrOrCreate("name").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //schemas
	    OLibraryImpl.prototype.schemas = function () {
	        return _super.prototype.elements.call(this, 'schemas');
	    };
	    /**
	     *
	     **/
	    //types
	    OLibraryImpl.prototype.types = function () {
	        return _super.prototype.elements.call(this, 'types');
	    };
	    /**
	     *
	     **/
	    //traits
	    OLibraryImpl.prototype.traits = function () {
	        return _super.prototype.elements.call(this, 'traits');
	    };
	    /**
	     *
	     **/
	    //resourceTypes
	    OLibraryImpl.prototype.resourceTypes = function () {
	        return _super.prototype.elements.call(this, 'resourceTypes');
	    };
	    /**
	     *
	     **/
	    //annotationTypes
	    OLibraryImpl.prototype.annotationTypes = function () {
	        return _super.prototype.elements.call(this, 'annotationTypes');
	    };
	    /**
	     *
	     **/
	    //securitySchemaTypes
	    OLibraryImpl.prototype.securitySchemaTypes = function () {
	        return _super.prototype.elements.call(this, 'securitySchemaTypes');
	    };
	    /**
	     *
	     **/
	    //securitySchemes
	    OLibraryImpl.prototype.securitySchemes = function () {
	        return _super.prototype.elements.call(this, 'securitySchemes');
	    };
	    /**
	     *
	     **/
	    //uses
	    OLibraryImpl.prototype.uses = function () {
	        return _super.prototype.elements.call(this, 'uses');
	    };
	    return OLibraryImpl;
	})(RAMLLanguageElementImpl);
	exports.OLibraryImpl = OLibraryImpl;
	var ApiImpl = (function (_super) {
	    __extends(ApiImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ApiImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createApi(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ApiImpl.prototype.wrapperClassName = function () {
	        return "ApiImpl";
	    };
	    /**
	     *
	     **/
	    //title
	    ApiImpl.prototype.title = function () {
	        return _super.prototype.attribute.call(this, 'title', this.toString);
	    };
	    /**
	     *
	     **/
	    //setTitle
	    ApiImpl.prototype.setTitle = function (param) {
	        {
	            this.highLevel().attrOrCreate("title").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //version
	    ApiImpl.prototype.version = function () {
	        return _super.prototype.attribute.call(this, 'version', this.toString);
	    };
	    /**
	     *
	     **/
	    //setVersion
	    ApiImpl.prototype.setVersion = function (param) {
	        {
	            this.highLevel().attrOrCreate("version").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //baseUri
	    ApiImpl.prototype.baseUri = function () {
	        return _super.prototype.attribute.call(this, 'baseUri', function (attr) { return new FullUriTemplateImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //baseUriParameters
	    ApiImpl.prototype.baseUriParameters = function () {
	        return _super.prototype.elements.call(this, 'baseUriParameters');
	    };
	    /**
	     *
	     **/
	    //protocols
	    ApiImpl.prototype.protocols = function () {
	        return _super.prototype.attributes.call(this, 'protocols', this.toString);
	    };
	    /**
	     *
	     **/
	    //setProtocols
	    ApiImpl.prototype.setProtocols = function (param) {
	        {
	            this.highLevel().attrOrCreate("protocols").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //mediaType
	    ApiImpl.prototype.mediaType = function () {
	        return _super.prototype.attribute.call(this, 'mediaType', function (attr) { return new MimeTypeImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //securedBy
	    ApiImpl.prototype.securedBy = function () {
	        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemaRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //resources
	    ApiImpl.prototype.resources = function () {
	        return _super.prototype.elements.call(this, 'resources');
	    };
	    /**
	     *
	     **/
	    //documentation
	    ApiImpl.prototype.documentation = function () {
	        return _super.prototype.elements.call(this, 'documentation');
	    };
	    /**
	     *
	     **/
	    //displayName
	    ApiImpl.prototype.displayName = function () {
	        return _super.prototype.attribute.call(this, 'displayName', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDisplayName
	    ApiImpl.prototype.setDisplayName = function (param) {
	        {
	            this.highLevel().attrOrCreate("displayName").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //name
	    ApiImpl.prototype.name = function () {
	        return _super.prototype.attribute.call(this, 'name', this.toString);
	    };
	    /**
	     *
	     **/
	    //setName
	    ApiImpl.prototype.setName = function (param) {
	        {
	            this.highLevel().attrOrCreate("name").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //description
	    ApiImpl.prototype.description = function () {
	        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //annotations
	    ApiImpl.prototype.annotations = function () {
	        return _super.prototype.attributes.call(this, 'annotations', function (attr) { return new AnnotationRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //securitySchemaTypes
	    ApiImpl.prototype.securitySchemaTypes = function () {
	        return _super.prototype.elements.call(this, 'securitySchemaTypes');
	    };
	    return ApiImpl;
	})(OLibraryImpl);
	exports.ApiImpl = ApiImpl;
	var OverlayImpl = (function (_super) {
	    __extends(OverlayImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function OverlayImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createOverlay(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    OverlayImpl.prototype.wrapperClassName = function () {
	        return "OverlayImpl";
	    };
	    /**
	     *
	     **/
	    //usage
	    OverlayImpl.prototype.usage = function () {
	        return _super.prototype.attribute.call(this, 'usage', this.toString);
	    };
	    /**
	     *
	     **/
	    //setUsage
	    OverlayImpl.prototype.setUsage = function (param) {
	        {
	            this.highLevel().attrOrCreate("usage").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //masterRef
	    OverlayImpl.prototype.masterRef = function () {
	        return _super.prototype.attribute.call(this, 'masterRef', this.toString);
	    };
	    /**
	     *
	     **/
	    //setMasterRef
	    OverlayImpl.prototype.setMasterRef = function (param) {
	        {
	            this.highLevel().attrOrCreate("masterRef").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //title
	    OverlayImpl.prototype.title = function () {
	        return _super.prototype.attribute.call(this, 'title', this.toString);
	    };
	    /**
	     *
	     **/
	    //setTitle
	    OverlayImpl.prototype.setTitle = function (param) {
	        {
	            this.highLevel().attrOrCreate("title").setValue("" + param);
	            return this;
	        }
	    };
	    return OverlayImpl;
	})(ApiImpl);
	exports.OverlayImpl = OverlayImpl;
	var ExtensionImpl = (function (_super) {
	    __extends(ExtensionImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ExtensionImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createExtension(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ExtensionImpl.prototype.wrapperClassName = function () {
	        return "ExtensionImpl";
	    };
	    /**
	     *
	     **/
	    //usage
	    ExtensionImpl.prototype.usage = function () {
	        return _super.prototype.attribute.call(this, 'usage', this.toString);
	    };
	    /**
	     *
	     **/
	    //setUsage
	    ExtensionImpl.prototype.setUsage = function (param) {
	        {
	            this.highLevel().attrOrCreate("usage").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //masterRef
	    ExtensionImpl.prototype.masterRef = function () {
	        return _super.prototype.attribute.call(this, 'masterRef', this.toString);
	    };
	    /**
	     *
	     **/
	    //setMasterRef
	    ExtensionImpl.prototype.setMasterRef = function (param) {
	        {
	            this.highLevel().attrOrCreate("masterRef").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //title
	    ExtensionImpl.prototype.title = function () {
	        return _super.prototype.attribute.call(this, 'title', this.toString);
	    };
	    /**
	     *
	     **/
	    //setTitle
	    ExtensionImpl.prototype.setTitle = function (param) {
	        {
	            this.highLevel().attrOrCreate("title").setValue("" + param);
	            return this;
	        }
	    };
	    return ExtensionImpl;
	})(ApiImpl);
	exports.ExtensionImpl = ExtensionImpl;
	function createApi(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Api");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createOLibrary(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("OLibrary");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createRAMLLanguageElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("RAMLLanguageElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createDocumentationItem(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("DocumentationItem");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createScriptSpec(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("ScriptSpec");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createApiDescription(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("ApiDescription");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createCallbackAPIDescription(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("CallbackAPIDescription");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createRAMLProject(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("RAMLProject");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createSecuritySchemaType(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("SecuritySchemaType");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createDataElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("DataElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createXMLInfo(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("XMLInfo");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createExampleSpec(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("ExampleSpec");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createFileParameter(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("FileParameter");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createArrayField(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("ArrayField");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createUnionField(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("UnionField");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createObjectField(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("ObjectField");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createStrElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("StrElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createBooleanElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("BooleanElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createValueElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("ValueElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createNumberElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("NumberElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createIntegerElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("IntegerElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createRAMLPointerElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("RAMLPointerElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createRAMLExpression(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("RAMLExpression");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createScriptHookElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("ScriptHookElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createSchemaElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("SchemaElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createDateElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("DateElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createSecuritySchemaPart(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("SecuritySchemaPart");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createMethodBase(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("MethodBase");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createHasNormalParameters(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("HasNormalParameters");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createResponse(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Response");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createTrait(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Trait");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createLibrary(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Library");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createGlobalSchema(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("GlobalSchema");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createRAMLSimpleElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("RAMLSimpleElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createImportDeclaration(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("ImportDeclaration");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createResourceType(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("ResourceType");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createResourceBase(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("ResourceBase");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createMethod(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Method");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createResource(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Resource");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createAnnotationType(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("AnnotationType");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createSecuritySchema(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("SecuritySchema");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createSecuritySchemaSettings(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("SecuritySchemaSettings");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createOAuth1SecuritySchemeSettings(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("OAuth1SecuritySchemeSettings");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createOAuth2SecuritySchemeSettings(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("OAuth2SecuritySchemeSettings");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createPassThroughSettings(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("PassThroughSettings");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createOath2(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Oath2");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createOath1(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Oath1");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createPassThrough(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("PassThrough");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createBasic(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Basic");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createDigest(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Digest");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createCustom(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Custom");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createOverlay(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Overlay");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createExtension(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Extension");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	//# sourceMappingURL=raml003parser.js.map

/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	var hlimpl = __webpack_require__(7);
	var proxy = __webpack_require__(13);
	var RamlWrapper = __webpack_require__(3);
	var RamlWrapper08 = __webpack_require__(14);
	var wrapperHelper = __webpack_require__(15);
	var pluralize = __webpack_require__(45);
	var sig = __webpack_require__(16);
	var universeProvider = __webpack_require__(10);
	function expandTraitsAndResourceTypes(api) {
	    if (!(api instanceof RamlWrapper.ApiImpl || api instanceof RamlWrapper08.ApiImpl)) {
	        return null;
	    }
	    return new TraitsAndResourceTypesExpander().expandTraitsAndResourceTypes(api);
	}
	exports.expandTraitsAndResourceTypes = expandTraitsAndResourceTypes;
	var TraitsAndResourceTypesExpander = (function () {
	    function TraitsAndResourceTypesExpander() {
	    }
	    TraitsAndResourceTypesExpander.prototype.expandTraitsAndResourceTypes = function (_api) {
	        var _this = this;
	        var isRAML1 = _api instanceof RamlWrapper.ApiImpl;
	        var api = _api;
	        var traits = wrapperHelper.allTraits(api);
	        var resourceTypes = wrapperHelper.allResourceTypes(api);
	        //if ((!traits || traits.length == 0) && (!resourceTypes || resourceTypes.length == 0)) {
	        //    return api;
	        //}
	        var llNode = api.highLevel().lowLevel();
	        this.ramlVersion = _api.highLevel().definition().universe().version();
	        var topComposite = new proxy.LowLevelCompositeNode(llNode, null, null);
	        var apiType = isRAML1 ? universeProvider('RAML10').type('Api') : universeProvider('RAML08').type('Api');
	        var hlNode = new hlimpl.ASTNodeImpl(topComposite, null, apiType, null);
	        var result = isRAML1 ? new RamlWrapper.ApiImpl(hlNode) : new RamlWrapper08.ApiImpl(hlNode);
	        this.traitMap = {};
	        this.resourceTypeMap = {};
	        if (traits) {
	            traits.forEach(function (x) { return _this.traitMap[wrapperHelper.qName(x)] = x; });
	        }
	        if (resourceTypes) {
	            resourceTypes.forEach(function (x) { return _this.resourceTypeMap[wrapperHelper.qName(x)] = x; });
	        }
	        var resources = result.resources();
	        resources.forEach(function (x) { return _this.processResource(x); });
	        return result;
	    };
	    TraitsAndResourceTypesExpander.prototype.processResource = function (resource) {
	        var _this = this;
	        var resourceData = this.collectResourceData(resource);
	        if (resource instanceof RamlWrapper.ResourceImpl) {
	            var mb = resource;
	            var signature = mb.signature();
	            if (signature) {
	                var trait = sig.convertToTrait(sig.parse(mb.highLevel().attr("signature")));
	                var cm = trait.highLevel().lowLevel();
	                var vl = resource.relativeUri().value();
	                var indExof = vl.lastIndexOf(".");
	                if (indExof != -1) {
	                    var composite = new proxy.LowLevelCompositeNode(cm, null, null);
	                    trait.highLevel()._node = composite;
	                    resource.highLevel().lowLevel().setKeyOverride(vl.substr(0, indExof));
	                    var me = new RamlWrapper.MethodImpl(vl.substr(indExof + 1));
	                    var rt = new RamlWrapper.ResourceTypeImpl("$$$signature");
	                    rt.add(me);
	                    trait.highLevel().elements().forEach(function (x) { return me.highLevel().add(x); });
	                    var composite = new proxy.LowLevelCompositeNode(rt.highLevel().lowLevel(), null, null);
	                    rt.highLevel()._node = composite;
	                    var val = {
	                        name: "$$$signature",
	                        node: rt,
	                        transformer: null
	                    };
	                    resourceData = [{
	                        resourceType: val,
	                        traits: [],
	                        methodTraits: {}
	                    }].concat(resourceData);
	                }
	            }
	        }
	        resourceData.filter(function (x) { return x.resourceType != null; }).forEach(function (x) { return resource.highLevel().lowLevel().adopt(x.resourceType.node.highLevel().lowLevel(), x.resourceType.transformer); });
	        var methods = resource.methods();
	        methods.forEach(function (m) {
	            var name = m.method();
	            var map = {};
	            resourceData.forEach(function (x) {
	                var methodTraits = x.methodTraits[name];
	                if (methodTraits) {
	                    methodTraits.forEach(function (x) { return m.highLevel().lowLevel().adopt(x.node.highLevel().lowLevel(), x.transformer); }, true);
	                }
	                var resourceTraits = x.traits;
	                if (resourceTraits) {
	                    resourceTraits.forEach(function (x) { return m.highLevel().lowLevel().adopt(x.node.highLevel().lowLevel(), x.transformer); }, true);
	                }
	            });
	        });
	        var resources = resource.resources();
	        resources.forEach(function (x) { return _this.processResource(x); });
	    };
	    TraitsAndResourceTypesExpander.prototype.collectResourceData = function (obj, arr, transformer) {
	        var _this = this;
	        if (arr === void 0) { arr = []; }
	        var ownTraits = this.extractTraits(obj);
	        var methodTraitsMap = {};
	        var methods = obj.methods();
	        methods.forEach(function (x) {
	            var methodTraits = _this.extractTraits(x);
	            if (methodTraits && methodTraits.length > 0) {
	                methodTraitsMap[x.method()] = methodTraits;
	            }
	        });
	        var rtData;
	        var rt = obj.type();
	        if (rt) {
	            rtData = this.readGenerictData(rt, this.resourceTypeMap, 'resource type', transformer);
	        }
	        arr.push({
	            resourceType: rtData,
	            traits: ownTraits,
	            methodTraits: methodTraitsMap
	        });
	        if (rtData) {
	            this.collectResourceData(rtData.node, arr, rtData.transformer);
	        }
	        return arr;
	    };
	    TraitsAndResourceTypesExpander.prototype.extractTraits = function (obj, _transformer, map) {
	        var _this = this;
	        if (map === void 0) { map = {}; }
	        var arr = [];
	        for (var i = -1; i < arr.length; i++) {
	            var gd = i < 0 ? null : arr[i];
	            var _obj = gd ? gd.node : obj;
	            var transformer = gd ? gd.transformer : _transformer;
	            _obj.is().forEach(function (x) {
	                var traitData = _this.readGenerictData(x, _this.traitMap, 'trait', transformer);
	                if (traitData) {
	                    var name = traitData.name;
	                    if (!map[name]) {
	                        map[name] = true;
	                        arr.push(traitData);
	                    }
	                }
	            });
	        }
	        if (obj instanceof RamlWrapper.MethodImpl) {
	            var mb = obj;
	            var signature = mb.signature();
	            if (signature) {
	                var trait = sig.convertToTrait(sig.parse(mb.highLevel().attr("signature")));
	                var cm = trait.highLevel().lowLevel();
	                var composite = new proxy.LowLevelCompositeNode(cm, null, null);
	                trait.highLevel()._node = composite;
	                var val = {
	                    name: "$$$signature",
	                    node: trait,
	                    transformer: null
	                };
	                map["$$$signature"] = true;
	                arr = [val].concat(arr);
	            }
	        }
	        return arr;
	    };
	    TraitsAndResourceTypesExpander.prototype.readGenerictData = function (obj, globalMap, template, transformer) {
	        var value = obj.value();
	        if (typeof (value) == 'string') {
	            if (transformer) {
	                value = transformer.transform(value);
	            }
	            var node = globalMap[value];
	            if (node) {
	                return {
	                    name: value,
	                    transformer: null,
	                    node: node
	                };
	            }
	        }
	        else if (value instanceof hlimpl.StructuredValue) {
	            var sv = value;
	            var name = sv.valueName();
	            var params = {};
	            var node = globalMap[name];
	            //var t = hlimpl.typeFromNode(node.highLevel());
	            if (node) {
	                if (this.ramlVersion == 'RAML08' && transformer) {
	                    sv.children().forEach(function (x) { return params[x.valueName()] = transformer.transform(x.lowLevel().value()); });
	                }
	                else {
	                    sv.children().forEach(function (x) { return params[x.valueName()] = x.lowLevel().value(); });
	                }
	                return {
	                    name: name,
	                    transformer: new ValueTransformer(params, template),
	                    node: node
	                };
	            }
	        }
	        return null;
	    };
	    return TraitsAndResourceTypesExpander;
	})();
	var ValueTransformer = (function () {
	    function ValueTransformer(params, template) {
	        this.params = params;
	        this.template = template;
	    }
	    ValueTransformer.prototype.error = function () {
	        return this.err;
	    };
	    ValueTransformer.prototype.transform = function (obj) {
	        var undefParams = {};
	        if (typeof (obj) === 'string') {
	            var str = obj;
	            var str1 = '';
	            var prev = 0;
	            for (var i = str.indexOf('<<'); i >= 0; i = str.indexOf('<<', prev)) {
	                str1 += str.substring(prev, i);
	                var i0 = i;
	                i += '<<'.length;
	                prev = str.indexOf('>>', i);
	                var paramOccurence = str.substring(i, prev);
	                prev += '>>'.length;
	                var originalString = str.substring(i0, prev);
	                var val;
	                var paramName;
	                if (paramOccurence.match(/\|\s*!\s*singularize\s*$/)) {
	                    var ind = paramOccurence.lastIndexOf('|');
	                    paramName = paramOccurence.substring(0, ind).trim();
	                    val = this.params[paramName];
	                    if (val) {
	                        val = pluralize.singular(val);
	                    }
	                }
	                else if (paramOccurence.match(/\|\s*!\s*pluralize\s*$/)) {
	                    var ind = paramOccurence.lastIndexOf('|');
	                    paramName = paramOccurence.substring(0, ind).trim();
	                    val = this.params[paramName];
	                    if (val) {
	                        val = pluralize.plural(val);
	                    }
	                }
	                else {
	                    paramName = paramOccurence.trim();
	                    val = this.params[paramName];
	                }
	                if (!val) {
	                    undefParams[paramName] = true;
	                    val = originalString;
	                }
	                str1 += val;
	            }
	            var upArr = Object.keys(undefParams);
	            if (upArr.length > 0) {
	                var errStr = upArr.join(', ').trim();
	                this.err = "Undefined " + this.template + " parameter" + (upArr.length > 1 ? 's' : '') + ": " + errStr;
	            }
	            else {
	                this.err = null;
	            }
	            str1 += str.substring(prev, str.length);
	            return str1;
	        }
	        else {
	            return obj;
	        }
	    };
	    return ValueTransformer;
	})();
	//# sourceMappingURL=expander.js.map

/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../typings/tsd.d.ts" />
	var invariant = __webpack_require__(46);
	var exists = function (v) { return (v != null); };
	var globalEmptyOpt;
	var Opt = (function () {
	    function Opt(_value) {
	        var _this = this;
	        this._value = _value;
	        this._isDefined = false;
	        this._isEmpty = true;
	        this._arr = undefined;
	        this.getOrThrow = function () {
	            invariant(_this._isDefined, 'Opt is empty. Use `Opt#getOrElse` or check `Opt#isDefined`.');
	            return _this._value;
	        };
	        this.value = function () { return _this._value; };
	        this.isDefined = function () { return _this._isDefined; };
	        this.isEmpty = function () { return _this._isEmpty; };
	        this.toArray = function () { return _this._arr || (_this._arr = _this._isDefined ? [_this._value] : []); };
	        this.getOrElse = function (v) { return _this._isDefined ? _this._value : v; };
	        this.getOrElseF = function (v) { return _this._isDefined ? _this._value : v(); };
	        this.map = function (f) { return _this._isEmpty ? Opt.empty() : new Opt(f(_this._value)); };
	        this.flatMap = function (f) { return _this.map(f).getOrElse(Opt.empty()); };
	        this.equals = function (other) {
	            invariant(other instanceof Opt, 'Expected other to be an `Opt`, but got `%s`', typeof other);
	            return (_this._isDefined === other.isDefined()) && (_this._value === other.value());
	        };
	        if (exists(this._value)) {
	            this._isDefined = true;
	            this._isEmpty = false;
	        }
	    }
	    Opt.prototype.forEach = function (fn) {
	        if (this.isDefined()) {
	            fn(this._value);
	        }
	    };
	    /**
	     * You can always create an empty option by hand just by calling new Opt<T>()
	     * but calling this method will return a global instance instead of allocating a new one each time
	     */
	    Opt.empty = function () { return (globalEmptyOpt || (globalEmptyOpt = new Opt())); };
	    return Opt;
	})();
	module.exports = Opt;
	//# sourceMappingURL=Opt.js.map

/***/ },
/* 6 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../../typings/tsd.d.ts" />
	var yaml = __webpack_require__(19);
	var lowlevel = __webpack_require__(25);
	var path = __webpack_require__(11);
	var fs = __webpack_require__(12);
	var parser = __webpack_require__(26);
	var dumper = __webpack_require__(27);
	var Error = __webpack_require__(28);
	var textutil = __webpack_require__(29);
	var rr = __webpack_require__(30);
	var MarkupIndentingBuffer = (function () {
	    function MarkupIndentingBuffer(indent) {
	        this.text = '';
	        this.indent = indent;
	    }
	    MarkupIndentingBuffer.prototype.isLastNL = function () {
	        return this.text.length > 0 && this.text[this.text.length - 1] == '\n';
	    };
	    MarkupIndentingBuffer.prototype.addWithIndent = function (lev, s) {
	        if (this.isLastNL()) {
	            this.text += textutil.indent(lev);
	            this.text += this.indent;
	        }
	        this.text += s;
	    };
	    MarkupIndentingBuffer.prototype.addChar = function (ch) {
	        if (this.isLastNL()) {
	            this.text += this.indent;
	        }
	        this.text += ch;
	    };
	    MarkupIndentingBuffer.prototype.append = function (s) {
	        for (var i = 0; i < s.length; i++) {
	            this.addChar(s[i]);
	        }
	    };
	    return MarkupIndentingBuffer;
	})();
	exports.MarkupIndentingBuffer = MarkupIndentingBuffer;
	var CompilationUnit = (function () {
	    function CompilationUnit(_path, _content, _tl, _project, _apath) {
	        this._path = _path;
	        this._content = _content;
	        this._tl = _tl;
	        this._project = _project;
	        this._apath = _apath;
	    }
	    CompilationUnit.prototype.isStubUnit = function () {
	        return this.stu;
	    };
	    CompilationUnit.prototype.cloneToProject = function (p) {
	        var newUnit = new CompilationUnit(this._path, this._content, this._tl, p, this._apath);
	        return newUnit;
	    };
	    CompilationUnit.prototype.clone = function () {
	        var newUnit = new CompilationUnit(this._path, this._content, this._tl, this.project(), this._apath);
	        return newUnit;
	    };
	    CompilationUnit.prototype.stub = function () {
	        var newUnit = new CompilationUnit(this._path, this._content, this._tl, this.project(), this._apath);
	        newUnit.stu = true;
	        return newUnit;
	    };
	    CompilationUnit.prototype.isDirty = function () {
	        return false;
	    };
	    CompilationUnit.prototype.absolutePath = function () {
	        return this._apath;
	    };
	    CompilationUnit.prototype.isRAMLUnit = function () {
	        var en = path.extname(this._path);
	        return en == '.raml' || en == '.yaml';
	    };
	    CompilationUnit.prototype.contents = function () {
	        return this._content;
	    };
	    CompilationUnit.prototype.resolve = function (p) {
	        var unit = this._project.resolve(this._path, p);
	        return unit;
	    };
	    CompilationUnit.prototype.path = function () {
	        return this._path;
	    };
	    CompilationUnit.prototype.lexerErrors = function () {
	        if (this.errors == null) {
	            this.ast();
	        }
	        return this.errors;
	    };
	    CompilationUnit.prototype.ast = function () {
	        var _this = this;
	        if (this._node) {
	            return this._node;
	        }
	        try {
	            var result = parser.load(this._content, {});
	            this.errors = result.errors;
	            this.errors.forEach(function (x) {
	                if (x.mark) {
	                    x.mark.filePath = _this.absolutePath();
	                }
	            });
	            this._node = new ASTNode(result, this, null, null, null);
	            this._node._errors = this.errors;
	            return this._node;
	        }
	        catch (e) {
	            this.errors = [];
	            this.errors.push(new Error(e.message));
	            //console.log(this._content)
	            //console.log(e)
	            this._node = null;
	            return this._node;
	        }
	    };
	    CompilationUnit.prototype.isTopLevel = function () {
	        return this._tl;
	    };
	    CompilationUnit.prototype.updateContent = function (n) {
	        this._content = n;
	        this.errors = null;
	        this._node = null; //todo incremental update
	    };
	    CompilationUnit.prototype.updateContentSafe = function (n) {
	        this._content = n;
	    };
	    CompilationUnit.prototype.project = function () {
	        return this._project;
	    };
	    return CompilationUnit;
	})();
	exports.CompilationUnit = CompilationUnit;
	var FSResolver = (function () {
	    function FSResolver() {
	    }
	    FSResolver.prototype.content = function (path) {
	        if (!fs.existsSync(path)) {
	            return null;
	        }
	        try {
	            return fs.readFileSync(path).toString();
	        }
	        catch (e) {
	            return null;
	        }
	    };
	    FSResolver.prototype.list = function (path) {
	        return fs.readdirSync(path);
	    };
	    return FSResolver;
	})();
	exports.FSResolver = FSResolver;
	function copyNode(n) {
	    if (n == null) {
	        return null;
	    }
	    switch (n.kind) {
	        case 0 /* SCALAR */:
	            return {
	                errors: [],
	                startPosition: n.startPosition,
	                endPosition: n.endPosition,
	                value: n.value,
	                kind: 0 /* SCALAR */,
	                parent: n.parent
	            };
	        case 1 /* MAPPING */:
	            var map = n;
	            return {
	                errors: [],
	                key: copyNode(map.key),
	                value: copyNode(map.value),
	                startPosition: map.startPosition,
	                endPosition: map.endPosition,
	                kind: 1 /* MAPPING */,
	                parent: map.parent
	            };
	        case 2 /* MAP */:
	            var ymap = n;
	            return {
	                errors: [],
	                startPosition: n.startPosition,
	                endPosition: n.endPosition,
	                mappings: ymap.mappings.map(function (x) { return copyNode(x); }),
	                kind: 2 /* MAP */,
	                parent: ymap.parent
	            };
	    }
	    return n;
	}
	var innerShift = function (offset, yaNode, shift) {
	    if (!yaNode)
	        return;
	    if (yaNode.startPosition >= offset) {
	        yaNode.startPosition += shift;
	    }
	    if (yaNode.endPosition > offset) {
	        yaNode.endPosition += shift;
	    }
	    //this kind is a separate case
	    if (yaNode.kind == 1 /* MAPPING */) {
	        var m = yaNode;
	        innerShift(offset, m.key, shift);
	        innerShift(offset, m.value, shift);
	    }
	};
	function splitOnLines(text) {
	    var lines = text.match(/^.*((\r\n|\n|\r)|$)/gm);
	    return lines;
	}
	//TODO IMPROVE INDENTS
	function stripIndent(text, indent) {
	    var lines = splitOnLines(text);
	    var rs = [];
	    for (var i = 0; i < lines.length; i++) {
	        if (i == 0) {
	            rs.push(lines[0]);
	        }
	        else {
	            rs.push(lines[i].substring(indent.length));
	        }
	    }
	    return rs.join("");
	}
	var leadingIndent = function (node, text) {
	    var leading = "";
	    var pos = node.start() - 1;
	    while (pos > 0) {
	        var ch = text[pos];
	        //if (ch == '\r' || ch == '\n' || ch != ' ') break;
	        //console.log('char: [' + ch + ']');
	        if (ch != ' ' && ch != '-')
	            break;
	        leading = ' ' + leading;
	        pos--;
	    }
	    return leading;
	};
	function indent(line) {
	    var rs = "";
	    for (var i = 0; i < line.length; i++) {
	        var c = line[i];
	        if (c == '\r' || c == '\n') {
	            continue;
	        }
	        if (c == ' ' || c == '\t') {
	            rs += c;
	            continue;
	        }
	        break;
	    }
	    return rs;
	}
	function indentLines(s, indent) {
	    return s.split("\n").map(function (x) {
	        if (x.trim().length == 0) {
	            return x;
	        }
	        return indent + x;
	    }).join("\n");
	}
	function extraIndent(text, indent) {
	    var lines = splitOnLines(text);
	    var rs = [];
	    for (var i = 0; i < lines.length; i++) {
	        if (i == 0) {
	            rs.push(lines[0]);
	        }
	        else {
	            if (lines[i].trim().length > 0) {
	                rs.push(indent + lines[i]);
	            }
	            else {
	                rs.push("");
	            }
	        }
	    }
	    return rs.join("");
	}
	var Project = (function () {
	    /**
	     *
	     * @param rootPath - path to folder where your root api is located
	     * @param resolver
	     * @param _httpResolver
	     */
	    function Project(rootPath, resolver, _httpResolver) {
	        if (resolver === void 0) { resolver = new FSResolver(); }
	        if (_httpResolver === void 0) { _httpResolver = null; }
	        this.rootPath = rootPath;
	        this.resolver = resolver;
	        this._httpResolver = _httpResolver;
	        this.listeners = [];
	        this.tlisteners = [];
	        this.pathToUnit = {};
	    }
	    Project.prototype.cloneWithResolver = function (newResolver, httpResolver) {
	        if (httpResolver === void 0) { httpResolver = null; }
	        var newProject = new Project(this.rootPath, newResolver, httpResolver ? httpResolver : this._httpResolver);
	        for (var unitPath in this.pathToUnit) {
	            newProject.pathToUnit[unitPath] = this.pathToUnit[unitPath].cloneToProject(newProject);
	        }
	        return newProject;
	    };
	    Project.prototype.setCachedUnitContent = function (pth, cnt, tl) {
	        if (tl === void 0) { tl = true; }
	        var relPath = pth;
	        var apath = path.resolve(this.rootPath, pth);
	        var unit = new CompilationUnit(relPath, cnt, tl, this, apath);
	        this.pathToUnit[apath] = unit;
	        return unit;
	    };
	    Project.prototype.resolve = function (unitPath, pathInUnit) {
	        if (!pathInUnit)
	            return null;
	        if (pathInUnit.charAt(0) == '/') {
	            return this.unit(pathInUnit);
	        }
	        if (pathInUnit.indexOf("http://") == 0 || pathInUnit.indexOf("https://") == 0) {
	            return this.unit(pathInUnit, true);
	        }
	        if (unitPath.charAt(0) == '/') {
	            var absPath = path.resolve(path.dirname(unitPath), pathInUnit);
	            return this.unit(absPath, true);
	        }
	        var absPath = path.resolve(path.dirname(path.resolve(this.rootPath, unitPath)), pathInUnit);
	        return this.unit(absPath, true);
	    };
	    Project.prototype.units = function () {
	        var _this = this;
	        var names = this.resolver.list(this.rootPath).filter(function (x) { return path.extname(x) == '.raml'; });
	        return names.map(function (x) { return _this.unit(x); }).filter(function (y) { return y.isTopLevel(); });
	    };
	    Project.prototype.lexerErrors = function () {
	        var results = [];
	        this.units().forEach(function (x) {
	            results = results.concat(x.lexerErrors());
	        });
	        return results;
	    };
	    Project.prototype.deleteUnit = function (p, absolute) {
	        if (absolute === void 0) { absolute = false; }
	        var apath = null;
	        if (p.indexOf("http://") == 0 || p.indexOf("https://") == 0) {
	            apath = p;
	        }
	        else {
	            apath = absolute ? p : path.resolve(this.rootPath, p);
	        }
	        delete this.pathToUnit[apath];
	    };
	    Project.prototype.unit = function (p, absolute) {
	        if (absolute === void 0) { absolute = false; }
	        var cnt = null;
	        var apath = p;
	        if (p.indexOf("http://") == 0 || p.indexOf("https://") == 0) {
	            if (this.pathToUnit[apath]) {
	                return this.pathToUnit[apath];
	            }
	            if (this._httpResolver) {
	                cnt = this._httpResolver.getResource(p);
	            }
	            else {
	                cnt = rr.readFromCacheOrGet(p);
	            }
	        }
	        else {
	            if (p.charAt(0) == '/' && !absolute) {
	                p = p.substr(1); //TODO REVIEW IT
	            }
	            var apath = absolute ? p : path.resolve(this.rootPath, p);
	            if (this.pathToUnit[apath]) {
	                return this.pathToUnit[apath];
	            }
	            cnt = this.resolver.content(apath);
	        }
	        if (cnt == null) {
	            return null;
	        }
	        var tl = (cnt.indexOf("#%RAML") == 0);
	        var relPath = path.relative(this.rootPath, apath);
	        var unit = new CompilationUnit(relPath, cnt, tl, this, apath);
	        this.pathToUnit[apath] = unit;
	        return unit;
	    };
	    Project.prototype.visualizeNewlines = function (s) {
	        var res = '';
	        for (var i = 0; i < s.length; i++) {
	            var ch = s[i];
	            if (ch == '\r')
	                ch = '\\r';
	            if (ch == '\n')
	                ch = '\\n';
	            res += ch;
	        }
	        return res;
	    };
	    Project.prototype.indent = function (node) {
	        //node.show('NODE');
	        var text = node.unit().contents();
	        //console.log('node text: ' + textutil.replaceNewlines(text.substring(node.start(), node.end())));
	        //console.log('node parent: ' + node.parent());
	        //console.log('node unit: ' + node.unit());
	        if (node == node.root()) {
	            //console.log('node is root');
	            return '';
	        }
	        var leading = leadingIndent(node, text);
	        //console.log('leading: [' + leading + '] ' + leading.length);
	        var dmp = splitOnLines(node.dump());
	        if (dmp.length > 1) {
	            if (dmp[1].trim().length > 0) {
	                //console.log('DMP0: [' + dmp[0] + ']');
	                //console.log('DMP1: [' + dmp[1] + ']');
	                var extra = indent(dmp[1]);
	                return leading + extra;
	            }
	        }
	        //console.log('LEADING: [' + this.visualizeNewlines(leading) + '] ');
	        return leading + '  ';
	    };
	    Project.prototype.startIndent = function (node) {
	        var text = node.unit().contents();
	        //console.log('Node text:\n' + this.visualizeNewlines(text.substring(node.start(), node.end())));
	        if (node == node.root())
	            return '';
	        var dmp = splitOnLines(node.dump());
	        if (dmp.length > 0) {
	            console.log('FIRST: ' + dmp[0]);
	            var extra = indent(dmp[0]);
	            return extra + '  ';
	        }
	        //console.log('LEADING: [' + this.visualizeNewlines(leading) + '] ');
	        return '';
	    };
	    Project.prototype.canWriteInOneLine = function (node) {
	        return false;
	    };
	    Project.prototype.isOneLine = function (node) {
	        return node.text().indexOf('\n') < 0;
	    };
	    Project.prototype.recalcPositionsUp = function (target) {
	        var np = target;
	        while (np) {
	            np.recalcEndPositionFromChilds();
	            np = np.parent();
	        }
	    };
	    Project.prototype.add2 = function (target, node, toSeq, ipoint, json) {
	        if (json === void 0) { json = false; }
	        var unit = target.unit();
	        var api = target.root();
	        //console.log('api: ' + api);
	        var point = null;
	        if (ipoint) {
	            if (ipoint instanceof ASTNode) {
	                //console.log('insertion: ast node');
	                point = ipoint;
	            }
	            if (ipoint instanceof InsertionPoint) {
	                //console.log('insertion: ip');
	                point = ipoint.point;
	            }
	        }
	        //console.log('target: ' + target.kindName() + '/' + target.valueKindName() + ' node: ' + node.kindName());
	        //if(point) point.show('POINT:');
	        if (target.isValueInclude()) {
	            //console.log('insert to include ref');
	            var childs = target.children();
	            if (childs.length == 0) {
	                throw "not implemented: insert into empty include ref";
	            }
	            var parent = childs[0].parent();
	            //console.log('parent: ' + parent);
	            //parent.show('INCLUDE PARENT:');
	            this.add2(parent, node, toSeq, point, json);
	            return;
	        }
	        var range = new textutil.TextRange(unit.contents(), node.start(), node.end());
	        var targetRange = new textutil.TextRange(unit.contents(), target.start(), target.end());
	        var unitText = target.unit().contents();
	        if (target.valueKind() == 3 /* SEQ */) {
	            target = createSeq(target.valueAsSeq(), target, target.unit());
	        }
	        var json = this.isJson(target);
	        //console.log('target: ' + target.start() + '..' + target.end());
	        var originalIndent = json ? '' : this.indent(target.isSeq() ? target.parent() : target);
	        //console.log('indent: [' + originalIndent + '] ' + originalIndent.length + '; toseq: ' + toSeq + '; json: ' + json);
	        var xindent = originalIndent;
	        var indentLength = originalIndent.length;
	        var isTargetSeq = target.isSeq() || target.isMapping() && (target.isValueSeq() || target.isValueScalar() || !target.asMapping().value); //target.valueKind() == yaml.Kind.SEQ || target.isSeq();
	        //toSeq = false;
	        //console.log('target: ' + target.kindName() + '/' + yaml.Kind[target.valueKind()] + '; toseq: ' + toSeq);
	        //target.root().show("API:");
	        //target.show("TARGET:");
	        //console.log('oindent: ' + originalIndent.length);
	        toSeq = toSeq; // || isTargetSeq;
	        if (toSeq) {
	            if (json) {
	            }
	            else {
	                if (isTargetSeq) {
	                    xindent += "  ";
	                    indentLength += 2;
	                }
	            }
	        }
	        //console.log('xindent: ' + xindent.length);
	        var buf = new MarkupIndentingBuffer(xindent);
	        //target.show('TARGET:');
	        //node.show('NODE1');
	        node.markupNode(buf, node._actualNode(), 0, json);
	        var text = buf.text;
	        //node.show('NODE2', 0, text);
	        //console.log('TEXT TO ADD0: ' + textutil.replaceNewlines(text));
	        if (toSeq) {
	            //if(target.valueKind() == yaml.Kind.SEQ) {
	            var trimText = textutil.trimEnd(text);
	            var trimLen = text.length - trimText.length;
	            if (trimLen > 0) {
	                //console.log('trim len: ' + trimLen);
	                var textlen = text.length;
	                text = text.substring(0, textlen - trimLen);
	                node.shiftNodes(textlen - trimLen, -trimLen);
	            }
	        }
	        //target.show('TARGET2');
	        //node.show('NODE2', 0, text);
	        //console.log('TEXT TO ADD1: ' + textutil.replaceNewlines(text));
	        //console.log('TEXT TO ADD:\n' + this.visualizeNewlines(text));
	        //console.log('toseq: ' + toSeq);
	        if (toSeq && !json) {
	            if (node.highLevelNode()) {
	            }
	            //console.log('target: ' + target.kindName());
	            if (target.isMapping()) {
	            }
	            if (target.isSeq() || target.isMapping() && (target.isValueSeq() || target.isValueScalar() || !target.asMapping().value)) {
	                //console.log('--- make it seq');
	                text = originalIndent + '- ' + text;
	            }
	            else {
	                //console.log('--- keep it map');
	                text = originalIndent + text;
	            }
	        }
	        else {
	            text = originalIndent + text;
	        }
	        //console.log('TEXT TO ADD2: ' + textutil.replaceNewlines(text));
	        //target.show('TARGET3');
	        var pos = target.end();
	        //console.log('insert to target end: ' + pos+ ' ; point: ' + point);
	        if (point) {
	            //point.show("POINT");
	            if (point != target) {
	                pos = point.end();
	            }
	            else {
	                if (json && toSeq) {
	                }
	                else {
	                    pos = target.keyEnd() + 1;
	                    pos = new textutil.TextRange(unitText, pos, pos).extendAnyUntilNewLines().endpos();
	                }
	            }
	        }
	        else {
	            if (json && toSeq) {
	                var seq = target.asSeq();
	                if (seq) {
	                    if (seq.items.length > 0) {
	                        pos = seq.items[seq.items.length - 1].endPosition;
	                    }
	                    else {
	                        pos = seq.endPosition - 1;
	                    }
	                }
	            }
	            else {
	                if (ipoint && (ipoint instanceof InsertionPoint)) {
	                    //ipoint.show('insertion point provided');
	                    var ip = ipoint;
	                    if (ip.type == 1 /* START */) {
	                        pos = target.keyEnd() + 1;
	                        pos = new textutil.TextRange(unitText, pos, pos).extendAnyUntilNewLines().endpos();
	                    }
	                }
	            }
	        }
	        //console.log('insert poition: ' + pos);
	        var insertionRange = new textutil.TextRange(unitText, 0, pos);
	        pos = insertionRange.extendToNewlines().reduceSpaces().endpos();
	        if (json && target.isSeq()) {
	            var seq = target.asSeq();
	            if (seq.items.length > 0) {
	                text = ', ' + text;
	                indentLength += 2;
	            }
	        }
	        else if (pos > 0 && unitText[pos - 1] != '\n') {
	            text = "\n" + text;
	            indentLength++;
	        }
	        var suffixLen = 0;
	        if (toSeq && !json) {
	            text += '\n';
	            suffixLen++;
	        }
	        //console.log('FINAL TEXT TO ADD: [' + textutil.replaceNewlines(text) + '] at position ' + pos);
	        var newtext = unitText.substring(0, pos) + text + unitText.substring(pos, unitText.length);
	        var cu = unit;
	        cu.updateContentSafe(newtext);
	        this.executeReplace(new textutil.TextRange(unitText, pos, pos), text, cu);
	        //console.log('shift root from position: ' + pos);
	        target.root().shiftNodes(pos, indentLength + (node.end() - node.start()) + suffixLen);
	        //console.log('node len: ' + (node.end()-node.start()));
	        //console.log('text len: ' + text.length);
	        //(<ASTNode>target.root()).shiftNodes(pos, text.length+indentLength);
	        //target.show('TARGET2:');
	        //node.show('NODE TO ADD:');
	        if (point) {
	            var childs = target.children();
	            var index = -1;
	            for (var i = 0; i < childs.length; i++) {
	                var x = childs[i];
	                if (x.start() == point.start() && x.end() == point.end()) {
	                    index = i;
	                    break;
	                }
	            }
	            //console.log('index: ' + index);
	            if (index >= 0) {
	                target.addChild(node, index + 1);
	            }
	            else {
	                target.addChild(node);
	            }
	        }
	        else {
	            target.addChild(node);
	        }
	        node.shiftNodes(0, pos + indentLength);
	        //target.show('TARGET UPDATED:');
	        this.recalcPositionsUp(target);
	        //target.show('TARGET UPDATED POSITIONS:');
	        //api.show('ROOT UPDATED POSITIONS:');
	        node.setUnit(target.unit());
	        node.visit(function (n) {
	            var node = n;
	            node.setUnit(target.unit());
	            return true;
	        });
	    };
	    Project.prototype.isJsonMap = function (node) {
	        if (!node.isMap())
	            return false;
	        var text = node.text().trim();
	        return text.length >= 2 && text[0] == '{' && text[text.length - 1] == '}';
	    };
	    Project.prototype.isJsonSeq = function (node) {
	        if (!node.isSeq())
	            return false;
	        var text = node.text().trim();
	        return text.length >= 2 && text[0] == '[' && text[text.length - 1] == ']';
	    };
	    Project.prototype.isJson = function (node) {
	        return this.isJsonMap(node) || this.isJsonSeq(node);
	    };
	    Project.prototype.remove = function (unit, target, node) {
	        var parent = node.parent();
	        node._oldText = node.dump();
	        //node.showParents('PARENTS:');
	        //console.log('REMOVE NODE: ' + node.kindName() + ' from ' + target.kindName());
	        //console.log('INITIAL SELECTION: [' + textutil.replaceNewlines(range.text()) + ']');
	        //console.log('  text: \n' + unitText.substring(startpos,endpos));
	        if (this.isOneLine(node) && node.isMapping() && node.parent().isMap()) {
	            var mapnode = node.parent();
	            if (mapnode.asMap().mappings.length == 1 && mapnode.parent() != null) {
	                //console.log('REMOVE MAP INSTEAD!');
	                this.remove(unit, mapnode.parent(), mapnode);
	                return;
	            }
	        }
	        if (this.isOneLine(node) && node.isScalar() && node.parent().isSeq()) {
	            var seqnode = node.parent();
	            var seqn = seqnode.asSeq();
	            //console.log('SEQ: ' + seqn.items.length);
	            if (seqn.items.length == 1) {
	                //console.log('REMOVE SEQ INSTEAD!');
	                this.remove(unit, seqnode.parent(), seqnode);
	                return;
	            }
	        }
	        if (target.isMapping() && node.isSeq()) {
	            //console.log('remove seq from mapping');
	            var map = target.parent();
	            //console.log('REMOVE MAPPING INSTEAD!');
	            this.remove(unit, map, target);
	            return;
	        }
	        //target.show('TARGET:');
	        //node.show('NODE:');
	        var range = new textutil.TextRange(unit.contents(), node.start(), node.end());
	        var targetRange = new textutil.TextRange(unit.contents(), target.start(), target.end());
	        var parentRange = new textutil.TextRange(unit.contents(), parent.start(), parent.end());
	        var originalStartPos = range.startpos();
	        //console.log('REMOVE TEXT: ' +  this.visualizeNewlines(range.text()));
	        if (target.isSeq()) {
	            // extend range to start of line
	            //console.log('RANGE SEQ 0: ' + textutil.replaceNewlines(range.text()));
	            var seq = (node.isSeq() ? node : node.parentOfKind(3 /* SEQ */));
	            //console.log('seq: ' + seq.text() + ' json: ' + this.isJson(seq));
	            if (seq && this.isJson(seq)) {
	                range = range.extendSpaces().extendCharIfAny(',').extendSpaces();
	            }
	            else {
	                range = range.extendToStartOfLine().extendAnyUntilNewLines().extendToNewlines(); //
	            }
	        }
	        if (target.isMap()) {
	            // extend range to end of line
	            //console.log('RANGE MAP 0: [' +  this.visualizeNewlines(range.text()) + ']');
	            range = range.trimEnd().extendAnyUntilNewLines().extendToNewlines();
	            //console.log('RANGE MAP 1: [' +  this.visualizeNewlines(range.text()) + ']');
	            range = range.extendToStartOfLine().extendUntilNewlinesBack();
	        }
	        if (target.kind() == 1 /* MAPPING */) {
	            //console.log('RANGE MAPPING 0: ' +  this.visualizeNewlines(range.text()));
	            //console.log('NODE TEXT: ' + node.text());
	            if (this.isJson(node) && this.isOneLine(node)) {
	            }
	            else {
	                // extend range to end of line
	                //console.log('RANGE MAP 0: ' +  this.visualizeNewlines(range.text()));
	                range = range.extendSpacesUntilNewLines();
	                range = range.extendToNewlines();
	                //console.log('RANGE MAP 2: ' +  this.visualizeNewlines(range.text()));
	                range = range.extendToStartOfLine().extendUntilNewlinesBack();
	            }
	        }
	        if (node.isSeq()) {
	            //console.log('cleanup seq');
	            range = range.reduceSpaces();
	        }
	        //console.log('NODE:\n-----------\n' + range.unitText() + '\n-------------');
	        //console.log('TARGET: ' + target.kindName());
	        //target.show('TARGET');
	        //console.log('FINAL REMOVE TEXT: [' +  this.visualizeNewlines(range.text()) + ']');
	        //console.log('NEW TEXT:\n-----------\n' + range.remove() + '\n-------------');
	        var cu = unit;
	        cu.updateContentSafe(range.remove());
	        this.executeReplace(range, "", cu);
	        //node.parent().show('Before remove');
	        node.parent().removeChild(node);
	        var shift = -range.len();
	        //console.log('shift: ' + shift);
	        target.root().shiftNodes(originalStartPos, shift);
	        this.recalcPositionsUp(target);
	        //this.executeTextChange(new lowlevel.TextChangeCommand(range.startpos(), range.len(), "", unit))
	        //target.show('TARGET AFTER REMOVE:');
	        //target.root().show('API AFTER REMOVE:');
	    };
	    Project.prototype.changeKey = function (unit, attr, newval) {
	        //console.log('set key: ' + newval);
	        var range = new textutil.TextRange(attr.unit().contents(), attr.keyStart(), attr.keyEnd());
	        if (attr.kind() == 1 /* MAPPING */) {
	            var sc = attr._actualNode().key;
	            sc.value = newval;
	            sc.endPosition = sc.startPosition + newval.length;
	        }
	        var cu = unit;
	        this.executeReplace(range, newval, cu);
	        //console.log('new text: ' + this.visualizeNewlines(newtext));
	        var shift = newval.length - range.len();
	        //console.log('shift: ' + shift);
	        attr.root().shiftNodes(range.startpos(), shift, attr);
	        this.recalcPositionsUp(attr);
	    };
	    Project.prototype.executeReplace = function (r, txt, unit) {
	        var command = new lowlevel.TextChangeCommand(r.startpos(), r.endpos() - r.startpos(), txt, unit);
	        unit.project();
	        try {
	            this.tlisteners.forEach(function (x) { return x(command); });
	        }
	        catch (e) {
	            return false;
	        }
	        var newtext = r.replace(txt);
	        unit.updateContentSafe(newtext);
	        return true;
	    };
	    Project.prototype.changeValue = function (unit, attr, newval) {
	        //console.log('set value: ' + newval);mark
	        //console.log('ATTR ' + yaml.Kind[attr.kind()] + '; VALUE: ' + val + ' => ' + newval);
	        //attr.root().show('NODE:');
	        //console.log('TEXT:\n' + attr.unit().contents());
	        var range = new textutil.TextRange(attr.unit().contents(), attr.start(), attr.end());
	        //console.log('Range0: ' + range.startpos() + '..' + range.endpos() + ': [' + this.visualizeNewlines(range.text()) + ']');
	        //console.log('ATTR: ' + attr.kindName());
	        //attr.root().show('BEFORE');
	        var newNodeText;
	        var prefix = 0;
	        var delta = 0;
	        var replacer = null;
	        var mapping = null;
	        //console.log('attr: ' + attr.kindName());
	        if (attr.kind() == 0 /* SCALAR */) {
	            if (typeof newval == 'string') {
	                attr.asScalar().value = newval;
	                //range = range.withStart(attr.valueStart()).withEnd(attr.valueEnd());
	                //console.log('Range1: ' + this.visualizeNewlines(range.text()));
	                //console.log('Range0: ' + range.startpos() + '..' + range.endpos());
	                newNodeText = newval;
	            }
	            else {
	                throw "not implemented";
	            }
	        }
	        else if (attr.kind() == 1 /* MAPPING */) {
	            //attr.show('ATTR:');
	            mapping = attr.asMapping();
	            //console.log('mapping val: ' + attr.valueKindName());
	            if (attr.isValueInclude()) {
	                var inc = attr.valueAsInclude();
	                var includePath = inc.value;
	                //console.log("attr.setValue: path: " + includePath);
	                var resolved = attr.unit().resolve(includePath);
	                if (resolved == null) {
	                    console.log("attr.setValue: couldn't resolve: " + includePath);
	                    return; // "can not resolve "+includePath
	                }
	                //console.log("attr.setValue: resolved: " + includePath);
	                if (resolved.isRAMLUnit()) {
	                    //TODO DIFFERENT DATA TYPES, inner references
	                    return;
	                }
	                resolved.updateContent(newval);
	                return;
	            }
	            //console.log('Range0: ' + range.startpos() + '..' + range.endpos() + ': [' + this.visualizeNewlines(range.text()) + ']');
	            if (mapping.value)
	                range = range.withStart(attr.valueStart()).withEnd(attr.valueEnd());
	            else
	                range = range.withStart(attr.keyEnd() + 1).withEnd(attr.keyEnd() + 1);
	            //console.log('Range1: ' + range.startpos() + '..' + range.endpos());
	            range = range.reduceNewlinesEnd();
	            //console.log('Range2: ' + range.startpos() + '..' + range.endpos() + ': [' + this.visualizeNewlines(range.text()) + ']');
	            if (newval == null) {
	                newNodeText = '';
	                mapping.value = null;
	            }
	            else if (typeof newval == 'string' || newval == null) {
	                var newstr = newval;
	                var ind = this.indent(attr);
	                //console.log('indent: ' + ind.length);
	                if (newstr && textutil.isMultiLine(newstr)) {
	                    newstr = '' + textutil.makeMutiLine(newstr, ind.length / 2);
	                }
	                newNodeText = newstr;
	                //var valueNode = null;
	                if (!mapping.value) {
	                    console.log('no value');
	                    mapping.value = yaml.newScalar(newstr);
	                    mapping.value.startPosition = attr.keyEnd() + 1;
	                    mapping.value.endPosition = mapping.value.startPosition + newstr.length;
	                    mapping.endPosition = mapping.value.endPosition;
	                    if (unit.contents().length > attr.keyEnd() + 1) {
	                        var vlPos = attr.keyEnd() + 1;
	                        if (unit.contents()[vlPos - 1] == ':') {
	                            newNodeText = " " + newNodeText;
	                            mapping.value.startPosition++;
	                            mapping.value.endPosition++;
	                            mapping.endPosition++;
	                            delta++;
	                        }
	                    }
	                }
	                else if (mapping.value.kind == 3 /* SEQ */) {
	                    console.log('seq value');
	                    var v = mapping.value.items[0];
	                    throw "assign value!!!";
	                }
	                else if (mapping.value.kind == 0 /* SCALAR */) {
	                    //console.log('scalar value');
	                    var sc = mapping.value;
	                    var oldtext = sc.value;
	                    //console.log('oldval: ' + sc.value);
	                    //console.log('newstr: ' + newstr + ' ' + newstr.length);
	                    sc.value = newstr;
	                    //console.log('value1: ' + mapping.value.startPosition + '..' + mapping.value.endPosition);
	                    mapping.value.endPosition = mapping.value.startPosition + newstr.length;
	                    //console.log('value2: ' + mapping.value.startPosition + '..' + mapping.value.endPosition);
	                    mapping.endPosition = mapping.value.endPosition;
	                    //console.log('mvalue: ' + mapping.startPosition + '..' + mapping.endPosition);
	                    //console.log('newval: ' + sc.value);
	                    delta += newstr.length - oldtext.length;
	                }
	            }
	            else {
	                var n = newval;
	                if (n.isMapping()) {
	                    newval = createMap([n.asMapping()]);
	                    n = newval;
	                }
	                else if (n.isMap()) {
	                }
	                else {
	                    throw "only MAP/MAPPING nodes allowed as values";
	                }
	                //n.show('NODE1');
	                var buf = new MarkupIndentingBuffer('');
	                n.markupNode(buf, n._actualNode(), 0, true);
	                //n.show('NODE2');
	                newNodeText = '' + buf.text + '';
	                //indent++;
	                //n.shiftNodes(0, 1);
	                //console.log('node text: [[[' + newNodeText + ']]]');
	                //n.show("NN1:", 0, newNodeText);
	                //range = mapping.value? range.withStart(attr.valueStart()).withEnd(attr.valueEnd()) : range.withStart(attr.keyEnd()+1).withEnd(attr.keyEnd()+1 + newNodeText);
	                n.shiftNodes(0, range.startpos() + delta);
	                //n.show("NN2:");
	                replacer = n;
	            }
	        }
	        else {
	            console.log('Unsupported change value case: ' + attr.kindName());
	        }
	        //console.log('RangeX: ' + range.startpos() + '..' + range.endpos() + ': [' + this.visualizeNewlines(range.text()) + ']');
	        //console.log('new node text: ' + newNodeText);
	        var cu = unit;
	        //console.log('Range1: ' + range.startpos() + '..' + range.endpos());
	        //console.log('replace: ' + range.len());
	        //console.log('Range: ' + range.startpos() + '..' + range.endpos());
	        //console.log('OldText: ' + this.visualizeNewlines(cu.contents()));
	        this.executeReplace(range, newNodeText, cu);
	        //var newtext = range.replace(newNodeText);
	        //console.log('NewText: ' + this.visualizeNewlines(newtext));
	        //cu.updateContentSafe(newtext);
	        var shift = newNodeText.length - range.len();
	        //var shift = delta;
	        //attr.root().show('BEFORE SHIFT');
	        //console.log('shift: ' + shift + '; from: ' + (range.endpos() + prefix) + '; delta: ' + delta + '; prefix: ' + prefix);
	        attr.root().shiftNodes(range.endpos() + prefix, shift, attr);
	        //(<ASTNode>attr.root()).shiftNodes(range.endpos()+indent, shift);
	        //attr.show('ATTR2:');
	        if (replacer) {
	            mapping.value = replacer._actualNode();
	        }
	        this.recalcPositionsUp(attr);
	    };
	    Project.prototype.initWithRoot = function (root, newroot) {
	        var shift = root.end();
	        newroot.markup(false);
	        newroot._actualNode().startPosition = shift;
	        newroot._actualNode().endPosition = shift;
	        newroot.setUnit(root.unit());
	    };
	    Project.prototype.execute = function (cmd) {
	        var _this = this;
	        //console.log('Commands: ' + cmd.commands.length);
	        cmd.commands.forEach(function (x) {
	            switch (x.kind) {
	                case 4 /* CHANGE_VALUE */:
	                    var attr = x.target;
	                    var curval = attr.value();
	                    if (!curval) {
	                        curval = "";
	                    }
	                    var newval = x.value;
	                    //console.log('set value: ' + (typeof curval) + ' ==> ' + (typeof newval));
	                    if (typeof curval == 'string' && typeof newval == 'string') {
	                        //console.log('set value: str => str');
	                        if (curval != newval) {
	                            _this.changeValue(attr.unit(), attr, newval);
	                        }
	                    }
	                    else if (typeof curval == 'string' && typeof newval != 'string') {
	                        //console.log('set value: str => obj');
	                        // change structure
	                        //this.changeValue(attr.unit(), attr, null);
	                        _this.changeValue(attr.unit(), attr, newval);
	                    }
	                    else if (typeof curval != 'string' && typeof newval == 'string') {
	                        var newstr = x.value;
	                        if (curval.kind() == 1 /* MAPPING */) {
	                            if (textutil.isMultiLine(newstr)) {
	                                //console.log('multiline');
	                                attr.children().forEach(function (n) {
	                                    _this.remove(attr.unit(), attr, n);
	                                });
	                                _this.changeValue(attr.unit(), attr, newstr);
	                            }
	                            else {
	                                //console.log('singleline');
	                                _this.changeKey(attr.unit(), curval, newstr);
	                            }
	                        }
	                        else {
	                            throw 'unsupported case: attribute value conversion: ' + (typeof curval) + ' ==> ' + (typeof newval) + ' not supported';
	                        }
	                    }
	                    else if (typeof curval != 'string' && typeof newval != 'string') {
	                        var newvalnode = newval;
	                        //(<ASTNode>curval).show("OLD:");
	                        //newvalnode.show("NEW:");
	                        if (newvalnode.isMapping()) {
	                            newval = createMap([newvalnode.asMapping()]);
	                        }
	                        //console.log('obj obj: ' + (curval == newval));
	                        if (curval == newval)
	                            break;
	                        // change structure
	                        //console.log('set value: obj => obj');
	                        var node = newval;
	                        var map = node.asMap();
	                        //console.log('attr: ' + attr.kindName() + " " + attr.dump());
	                        attr.children().forEach(function (n) {
	                            _this.remove(attr.unit(), attr, n);
	                        });
	                        node.children().forEach(function (m) {
	                            //this.add2(attr, <ASTNode>m, false, null, true);
	                        });
	                        _this.changeValue(attr.unit(), attr, newval);
	                    }
	                    else {
	                        throw "shouldn't be this case: attribute value conversion " + (typeof curval) + ' ==> ' + (typeof newval) + ' not supported';
	                    }
	                    return;
	                case 3 /* CHANGE_KEY */:
	                    var attr = x.target;
	                    _this.changeKey(attr.unit(), attr, x.value);
	                    return;
	                case 0 /* ADD_CHILD */:
	                    var attr = x.target;
	                    var newValueNode = x.value;
	                    _this.add2(attr, newValueNode, x.toSeq, x.insertionPoint);
	                    return;
	                case 1 /* REMOVE_CHILD */:
	                    var target = x.target;
	                    var node = x.value;
	                    _this.remove(target.unit(), target, node);
	                    return;
	                case 5 /* INIT_RAML_FILE */:
	                    var root = x.target;
	                    var newroot = x.value;
	                    _this.initWithRoot(root, newroot);
	                    return;
	                default:
	                    console.log('UNSUPPORTED COMMAND: ' + lowlevel.CommandKind[x.kind]);
	                    return;
	            }
	        });
	    };
	    Project.prototype.replaceYamlNode = function (target, newNodeContent, offset, shift, unit) {
	        //console.log('New content:\n' + newNodeContent);
	        //target.show('OLD TARGET');
	        var newYamlNode = parser.load(newNodeContent, {});
	        //console.log('new yaml: ' + yaml.Kind[newYamlNode.kind]);
	        this.updatePositions(target.start(), newYamlNode);
	        //console.log('Shift: ' + shift);
	        //(<ASTNode>unit.ast()).shiftNodes(offset, shift);
	        target.root().shiftNodes(offset, shift);
	        var targetParent = target.parent();
	        var targetYamlNode = target._actualNode();
	        var parent = targetYamlNode.parent;
	        newYamlNode.parent = parent;
	        if (targetParent && targetParent.kind() == 2 /* MAP */) {
	            //console.log('MAP!!!');
	            var targetParentMapNode = targetParent._actualNode();
	            targetParentMapNode.mappings = targetParentMapNode.mappings.map(function (x) {
	                if (x != targetYamlNode) {
	                    return x;
	                }
	                return newYamlNode;
	            });
	        }
	        target.updateFrom(newYamlNode);
	        //target.show('MEW TARGET');
	        this.recalcPositionsUp(target);
	    };
	    Project.prototype.executeTextChange2 = function (textCommand) {
	        var cu = textCommand.unit;
	        var unitText = cu.contents();
	        var target = textCommand.target;
	        if (target) {
	            var cnt = unitText.substring(target.start(), target.end());
	            var original = unitText;
	            unitText = unitText.substr(0, textCommand.offset) + textCommand.text + unitText.substr(textCommand.offset + textCommand.replacementLength);
	            var newNodeContent = cnt.substr(0, textCommand.offset - target.start()) + textCommand.text + cnt.substr(textCommand.offset - target.start() + textCommand.replacementLength);
	            cu.updateContentSafe(unitText);
	            if (textCommand.offset > target.start()) {
	                try {
	                    var shift = textCommand.text.length - textCommand.replacementLength;
	                    var offset = textCommand.offset;
	                    target.unit().project().replaceYamlNode(target, newNodeContent, offset, shift, textCommand.unit);
	                }
	                catch (e) {
	                    console.log('New node contents (causes error below): \n' + newNodeContent);
	                    console.log('Reparse error: ' + e.stack);
	                }
	            }
	        }
	        else {
	            unitText = unitText.substr(0, textCommand.offset) + textCommand.text + unitText.substr(textCommand.offset + textCommand.replacementLength);
	        }
	        cu.updateContent(unitText);
	        this.listeners.forEach(function (x) {
	            x(null);
	        });
	        this.tlisteners.forEach(function (x) {
	            x(textCommand);
	        });
	    };
	    Project.prototype.executeTextChange = function (textCommand) {
	        var l0 = new Date().getTime();
	        try {
	            var oc = textCommand.unit.contents();
	            //console.log('Offset: ' + textCommand.offset + '; end: ' + (textCommand.offset + textCommand.replacementLength) + '; len: ' + textCommand.replacementLength);
	            var target = textCommand.target;
	            if (target == null) {
	                target = this.findNode(textCommand.unit.ast(), textCommand.offset, textCommand.offset + textCommand.replacementLength);
	            }
	            var cu = textCommand.unit;
	            if (target) {
	                var cnt = oc.substring(target.start(), target.end());
	                //console.log('Content: ' + cnt);
	                var original = oc;
	                oc = oc.substr(0, textCommand.offset) + textCommand.text + oc.substr(textCommand.offset + textCommand.replacementLength);
	                var newNodeContent = cnt.substr(0, textCommand.offset - target.start()) + textCommand.text + cnt.substr(textCommand.offset - target.start() + textCommand.replacementLength);
	                cu.updateContentSafe(oc);
	                //console.log('UPDATED TEXT: ' + oc);
	                var hasNewLines = breaksTheLine(original, textCommand);
	                if (textCommand.offset > target.start()) {
	                    try {
	                        var newYamlNode = parser.load(newNodeContent, {});
	                        this.updatePositions(target.start(), newYamlNode);
	                        //console.log("Positions updated")
	                        //lets shift all after it
	                        var shift = textCommand.text.length - textCommand.replacementLength;
	                        //console.log('shift: ' + shift);
	                        //console.log('offset: ' + textCommand.offset);
	                        textCommand.unit.ast().shiftNodes(textCommand.offset, shift);
	                        //console.log('Unit AST: ' + textCommand.unit.ast())
	                        if (newYamlNode != null && newYamlNode.kind == 2 /* MAP */) {
	                            var actualResult = newYamlNode.mappings[0];
	                            var targetYamlNode = target._actualNode();
	                            var parent = targetYamlNode.parent;
	                            var cmd = new lowlevel.ASTDelta();
	                            var unit = textCommand.unit;
	                            cmd.commands = [
	                                new lowlevel.ASTChangeCommand(4 /* CHANGE_VALUE */, new ASTNode(copyNode(targetYamlNode), unit, null, null, null), new ASTNode(actualResult, unit, null, null, null), 0)
	                            ];
	                            if (parent && parent.kind == 2 /* MAP */) {
	                                var map = parent;
	                                map.mappings = map.mappings.map(function (x) {
	                                    if (x != targetYamlNode) {
	                                        return x;
	                                    }
	                                    return actualResult;
	                                });
	                            }
	                            actualResult.parent = parent;
	                            //updating low level ast from yaml
	                            this.recalcPositionsUp(target);
	                            target.updateFrom(actualResult);
	                            //console.log("Incremental without listeners: "+(new Date().getTime()-l0));
	                            //console.log("Notify listeners1: " + this.listeners.length + ":" + this.tlisteners.length);
	                            this.listeners.forEach(function (x) {
	                                x(cmd);
	                            });
	                            this.tlisteners.forEach(function (x) {
	                                x(textCommand);
	                            });
	                            //console.log("Incremental update processed");
	                            return;
	                        }
	                    }
	                    catch (e) {
	                        console.log('New node contents (causes error below): \n' + newNodeContent);
	                        console.log('Reparse error: ' + e.stack);
	                    }
	                }
	            }
	            else {
	                oc = oc.substr(0, textCommand.offset) + textCommand.text + oc.substr(textCommand.offset + textCommand.replacementLength);
	            }
	            var t2 = new Date().getTime();
	            //console.log("Full without listeners:"+(t2-l0));
	            //!find node in scope
	            cu.updateContent(oc);
	            //console.log("Notify listeners2: " + this.listeners.length + ":" + this.tlisteners.length);
	            this.listeners.forEach(function (x) {
	                x(null);
	            });
	            this.tlisteners.forEach(function (x) {
	                x(textCommand);
	            });
	        }
	        finally {
	            var t2 = new Date().getTime();
	        }
	    };
	    Project.prototype.updatePositions = function (offset, n) {
	        var _this = this;
	        if (n == null) {
	            return;
	        }
	        if (n.startPosition == -1) {
	            n.startPosition = offset;
	        }
	        else {
	            n.startPosition = offset + n.startPosition;
	        }
	        n.endPosition = offset + n.endPosition;
	        switch (n.kind) {
	            case 2 /* MAP */:
	                var m = n;
	                m.mappings.forEach(function (x) { return _this.updatePositions(offset, x); });
	                break;
	            case 1 /* MAPPING */:
	                var ma = n;
	                this.updatePositions(offset, ma.key);
	                this.updatePositions(offset, ma.value);
	                break;
	            case 0 /* SCALAR */:
	                break;
	            case 3 /* SEQ */:
	                var s = n;
	                s.items.forEach(function (x) { return _this.updatePositions(offset, x); });
	                break;
	        }
	    };
	    Project.prototype.findNode = function (n, offset, end) {
	        var _this = this;
	        if (n == null) {
	            return null;
	        }
	        var node = n;
	        if (n.start() <= offset && n.end() >= end) {
	            var res = n;
	            node.directChildren().forEach(function (x) {
	                var m = _this.findNode(x, offset, end);
	                if (m) {
	                    res = m;
	                }
	            });
	            return res;
	        }
	        return null;
	    };
	    //shiftNodes(n:lowlevel.ILowLevelASTNode, offset:number, shift:number):lowlevel.ILowLevelASTNode{
	    //    var node:ASTNode=<ASTNode>n;
	    //    if (node==null){
	    //        return null;
	    //    }
	    //    node.directChildren().forEach(x=> {
	    //        var m = this.shiftNodes(x, offset, shift);
	    //    })
	    //    var yaNode=(<ASTNode>n)._actualNode();
	    //    if(yaNode) innerShift(offset, yaNode, shift);
	    //    return null;
	    //}
	    Project.prototype.addTextChangeListener = function (listener) {
	        this.tlisteners.push(listener);
	    };
	    Project.prototype.removeTextChangeListener = function (listener) {
	        this.tlisteners = this.tlisteners.filter(function (x) { return x != listener; });
	    };
	    Project.prototype.addListener = function (listener) {
	        this.listeners.push(listener);
	    };
	    Project.prototype.removeListener = function (listener) {
	        this.listeners = this.listeners.filter(function (x) { return x != listener; });
	    };
	    return Project;
	})();
	exports.Project = Project;
	function breaksTheLine(oc, textCommand) {
	    var oldText = oc.substr(textCommand.offset, textCommand.replacementLength);
	    if (oldText.indexOf('\n') != -1) {
	        return true;
	    }
	    if (textCommand.text.indexOf('\n') != -1) {
	        return true;
	    }
	}
	var ASTNode = (function () {
	    function ASTNode(_node, _unit, _parent, _anchor, _include, cacheChildren) {
	        if (cacheChildren === void 0) { cacheChildren = false; }
	        this._node = _node;
	        this._unit = _unit;
	        this._parent = _parent;
	        this._anchor = _anchor;
	        this._include = _include;
	        this.cacheChildren = cacheChildren;
	        this._errors = [];
	        if (_node == null) {
	            console.log("null");
	        }
	    }
	    ASTNode.prototype.yamlNode = function () {
	        return this._node;
	    };
	    ASTNode.prototype.setHighLevelParseResult = function (highLevelParseResult) {
	        this._highLevelParseResult = highLevelParseResult;
	    };
	    ASTNode.prototype.highLevelParseResult = function () {
	        return this._highLevelParseResult;
	    };
	    ASTNode.prototype.setHighLevelNode = function (highLevel) {
	        this._highLevelNode = highLevel;
	    };
	    ASTNode.prototype.highLevelNode = function () {
	        return this._highLevelNode;
	    };
	    ASTNode.prototype.start = function () {
	        return this._node.startPosition;
	    };
	    ASTNode.prototype.errors = function () {
	        return this._errors;
	    };
	    ASTNode.prototype.parent = function () {
	        return this._parent;
	    };
	    ASTNode.prototype.recalcEndPositionFromChilds = function () {
	        var childs = this.children();
	        //if(this.children().length == 0) return;
	        var max = 0;
	        var first = this.children()[0];
	        var last = this.children()[this.children().length - 1];
	        //this.children().forEach(n=> {
	        //    var node: ASTNode = <ASTNode>n;
	        //    if(node._node.endPosition > max) max = node._node.endPosition;
	        //});
	        if (this.isMapping()) {
	            var mapping = this.asMapping();
	            //console.log('reposition: mapping');
	            if (mapping.value) {
	                if (mapping.value.kind == 2 /* MAP */) {
	                    var map = mapping.value;
	                    if (map.startPosition < 0 && first) {
	                        map.startPosition = first.start();
	                    }
	                    if (last)
	                        this._node.endPosition = last._node.endPosition;
	                    //console.log('embedded map: ' + map.startPosition + ".." + map.endPosition);
	                    this._node.endPosition = Math.max(this._node.endPosition, mapping.value.endPosition);
	                }
	                else if (mapping.value.kind == 3 /* SEQ */) {
	                    var seq = mapping.value;
	                    if (seq.startPosition < 0) {
	                        //console.log('*** missed start position');
	                        if (seq.items.length > 0) {
	                            var pos = seq.items[0].startPosition;
	                            var range = new textutil.TextRange(this.unit().contents(), pos, pos);
	                            range = range.extendSpacesBack().extendCharIfAnyBack('-');
	                            seq.startPosition = range.startpos();
	                        }
	                        else {
	                        }
	                    }
	                    //console.log('mapping1     : ' + mapping.startPosition + ".." + mapping.endPosition);
	                    //console.log('embedded seq1: ' + seq.startPosition + ".." + seq.endPosition);
	                    if (seq.items.length > 0) {
	                        var ilast = seq.items[seq.items.length - 1];
	                        this._node.endPosition = Math.max(this._node.endPosition, seq.endPosition, ilast.endPosition);
	                        seq.endPosition = Math.max(this._node.endPosition, seq.endPosition, ilast.endPosition);
	                    }
	                }
	                else if (mapping.value.kind == 0 /* SCALAR */) {
	                }
	                else {
	                    if (last)
	                        this._node.endPosition = last._node.endPosition;
	                }
	            }
	        }
	        else {
	            if (last)
	                this._node.endPosition = last._node.endPosition;
	        }
	        //this._node.endPosition = max;;
	    };
	    ASTNode.prototype.isValueLocal = function () {
	        if (this._node.kind == 1 /* MAPPING */) {
	            var knd = this._node.value.kind;
	            return knd != 5 /* INCLUDE_REF */ && knd != 4 /* ANCHOR_REF */;
	        }
	        return true;
	    };
	    ASTNode.prototype.keyStart = function () {
	        if (this._node.kind == 1 /* MAPPING */) {
	            return this._node.key.startPosition;
	        }
	        return -1;
	    };
	    ASTNode.prototype.keyEnd = function () {
	        if (this._node.kind == 1 /* MAPPING */) {
	            return this._node.key.endPosition;
	        }
	        return -1;
	    };
	    ASTNode.prototype.valueStart = function () {
	        if (this._node.kind == 1 /* MAPPING */) {
	            var mapping = this.asMapping();
	            if (mapping.value)
	                return mapping.value.startPosition;
	            else
	                return mapping.endPosition;
	        }
	        return -1;
	    };
	    ASTNode.prototype.valueEnd = function () {
	        if (this._node.kind == 1 /* MAPPING */) {
	            var mn = this.asMapping();
	            return mn.value.endPosition;
	        }
	        return -1;
	    };
	    ASTNode.prototype.end = function () {
	        return this._node.endPosition;
	    };
	    ASTNode.prototype.dump = function () {
	        if (this._oldText) {
	            return this._oldText;
	        }
	        if (this._unit && this._node.startPosition > 0 && this._node.endPosition > 0) {
	            var originalText = this._unit.contents().substring(this._node.startPosition, this._node.endPosition);
	            originalText = stripIndent(originalText, leadingIndent(this, this._unit.contents()));
	            //console.log("L:");
	            //console.log(originalText);
	            return originalText;
	        }
	        return dumper.dump(this.dumpToObject(), {});
	    };
	    ASTNode.prototype.dumpToObject = function (full) {
	        if (full === void 0) { full = false; }
	        return this.dumpNode(this._node, full);
	    };
	    ASTNode.prototype.dumpNode = function (n, full) {
	        var _this = this;
	        if (full === void 0) { full = false; }
	        if (!n) {
	            return null;
	        }
	        if (n.kind == 3 /* SEQ */) {
	            var seq = n;
	            var arr = [];
	            seq.items.forEach(function (x) { return arr.push(_this.dumpNode(x)); });
	            return arr;
	        }
	        if (n.kind == 1 /* MAPPING */) {
	            var c = n;
	            var v = {};
	            var val = c.value;
	            var mm = this.dumpNode(val, full);
	            v["" + this.dumpNode(c.key, full)] = mm;
	            return v;
	        }
	        if (n.kind == 0 /* SCALAR */) {
	            var s = n;
	            return s.value;
	        }
	        if (n.kind == 2 /* MAP */) {
	            var map = n;
	            var res = {};
	            if (map.mappings.length == 1) {
	                if (map.mappings[0].key.value == 'value') {
	                    return this.dumpNode(map.mappings[0].value, full);
	                }
	            }
	            if (map.mappings) {
	                map.mappings.forEach(function (x) {
	                    var ms = _this.dumpNode(x.value, full);
	                    if (ms == null) {
	                        ms = "!$$$novalue";
	                    }
	                    if ((ms + "").length > 0 || full) {
	                        res[_this.dumpNode(x.key, full) + ""] = ms;
	                    }
	                });
	            }
	            return res;
	        }
	    };
	    ASTNode.prototype._actualNode = function () {
	        return this._node;
	    };
	    ASTNode.prototype.execute = function (cmd) {
	        if (this.unit()) {
	            this.unit().project().execute(cmd);
	        }
	        else {
	            cmd.commands.forEach(function (x) {
	                switch (x.kind) {
	                    case 4 /* CHANGE_VALUE */:
	                        var attr = x.target;
	                        var newValue = x.value;
	                        var va = attr._actualNode();
	                        var as = attr.start();
	                        if (va.kind == 1 /* MAPPING */) {
	                            va.value = yaml.newScalar("" + newValue);
	                        }
	                        //this.executeTextChange(new lowlevel.TextChangeCommand(as,attr.value().length,<string>newValue,attr.unit()))
	                        return;
	                    case 3 /* CHANGE_KEY */:
	                        var attr = x.target;
	                        var newValue = x.value;
	                        var va = attr._actualNode();
	                        if (va.kind == 1 /* MAPPING */) {
	                            var sc = va.key;
	                            sc.value = newValue;
	                        }
	                        return;
	                }
	            });
	        }
	    };
	    ASTNode.prototype.updateFrom = function (n) {
	        this._node = n;
	    };
	    ASTNode.prototype.value = function () {
	        if (!this._node) {
	            return "";
	        }
	        if (this._node.kind == 0 /* SCALAR */) {
	            //TODO WHAT IS IT IS INCLUDE ACTUALLY
	            return this._node['value'];
	        }
	        if (this._node.kind == 4 /* ANCHOR_REF */) {
	            var ref = this._node;
	            return new ASTNode(ref.value, this._unit, this, null, null).value();
	        }
	        if (this._node.kind == 1 /* MAPPING */) {
	            var map = this._node;
	            if (map.value == null) {
	                return null;
	            }
	            return new ASTNode(map.value, this._unit, this, null, null).value();
	        }
	        if (this._node.kind == 5 /* INCLUDE_REF */) {
	            //here we should resolve include
	            var includePath = this._node['value'];
	            var resolved = this._unit.resolve(includePath);
	            if (resolved == null) {
	                return "can not resolve " + includePath;
	            }
	            if (resolved.isRAMLUnit()) {
	                //TODO DIFFERENT DATA TYPES, inner references
	                return null;
	            }
	            var text = resolved.contents();
	            if (textutil.isMultiLineValue(text)) {
	                text = textutil.fromMutiLine(text);
	            }
	            return text;
	        }
	        if (this._node.kind == 2 /* MAP */) {
	            var amap = this._node;
	            if (amap.mappings.length == 1) {
	                //handle map with one member case differently
	                return new ASTNode(amap.mappings[0], this._unit, this, null, null);
	            }
	        }
	        if (this._node.kind == 3 /* SEQ */) {
	            var aseq = this._node;
	            if (aseq.items.length == 1 && true) {
	                //handle seq with one member case differently
	                return new ASTNode(aseq.items[0], this._unit, this, null, null).value();
	            }
	        }
	        //this are only kinds which has values
	        return null;
	    };
	    ASTNode.prototype.printDetails = function (indent) {
	        var result = "";
	        if (!indent)
	            indent = "";
	        var typeName = this.kindName();
	        if (this.kind() == 0 /* SCALAR */) {
	            result += indent + "[" + typeName + "]" + " " + this.value() + "\n";
	        }
	        else if (this.kind() == 1 /* MAPPING */ && this._node.value && this._node.value.kind == 0 /* SCALAR */) {
	            result += indent + "[" + typeName + "]" + " " + this.key() + " = " + this.value() + "\n";
	        }
	        else if (this.kind() == 1 /* MAPPING */) {
	            result += indent + "[" + typeName + "]" + " " + this.key() + " = :\n";
	            this.children().forEach(function (child) {
	                result += child.printDetails(indent + "\t");
	            });
	        }
	        else {
	            result += indent + "[" + typeName + "]" + " :\n";
	            this.children().forEach(function (child) {
	                result += child.printDetails(indent + "\t");
	            });
	        }
	        return result;
	    };
	    ASTNode.prototype.visit = function (v) {
	        this.children().forEach(function (x) {
	            if (v(x)) {
	                x.visit(v);
	            }
	        });
	    };
	    ASTNode.prototype.key = function () {
	        if (!this._node) {
	            return "";
	        }
	        if (this._node.kind == 1 /* MAPPING */) {
	            var map = this._node;
	            if (map.key.kind == 3 /* SEQ */) {
	                var items = map.key;
	                var mn = "[";
	                items.items.forEach(function (x) { return mn += x.value; });
	                return mn + "]";
	            }
	            return map.key.value;
	        }
	        //other kinds do not have keys
	        return null;
	    };
	    ASTNode.prototype.addChild = function (n, pos) {
	        if (pos === void 0) { pos = -1; }
	        //this.show('ADD TARGET:');
	        var node = n;
	        //console.log('add-child: ' + this.kindName() + ' .add ' + node.kindName());
	        node._parent = this;
	        this._oldText = null;
	        if (this.isMap()) {
	            //console.log('pos: ' + pos);
	            var map = this.asMap();
	            if (map.mappings == null || map.mappings == undefined) {
	                map.mappings = [];
	            }
	            if (pos >= 0) {
	                map.mappings.splice(pos, 0, node.asMapping());
	            }
	            else {
	                map.mappings.push(node.asMapping());
	            }
	        }
	        else if (this.isMapping()) {
	            var mapping = this.asMapping();
	            var val = mapping.value;
	            //console.log('mapping value: ' + val);
	            if (!mapping.value && node.isMap()) {
	                mapping.value = node._actualNode();
	                return;
	            }
	            if (mapping.value && mapping.value.kind == 0 /* SCALAR */) {
	                // cleanup old value
	                mapping.value = null;
	                val = null;
	            }
	            if (!val) {
	                if (node.isScalar() || node.highLevelNode() && node.highLevelNode().property().isEmbedMap()) {
	                    val = yaml.newSeq();
	                }
	                else {
	                    val = yaml.newMap();
	                }
	                mapping.value = val;
	            }
	            if (val.kind == 2 /* MAP */) {
	                var map = val;
	                if (map.mappings == null || map.mappings == undefined) {
	                    map.mappings = [];
	                }
	                if (node.isScalar()) {
	                }
	                if (pos >= 0) {
	                    map.mappings.splice(pos, 0, node.asMapping());
	                }
	                else {
	                    map.mappings.push(node.asMapping());
	                }
	            }
	            else if (val.kind == 3 /* SEQ */) {
	                var seq = val;
	                if (pos >= 0) {
	                    seq.items.splice(pos, 0, node._actualNode());
	                }
	                else {
	                    seq.items.push(node._actualNode());
	                }
	            }
	            else {
	                throw "Insert into mapping with " + yaml.Kind[mapping.value.kind] + " value not supported";
	            }
	        }
	        else if (this.isSeq()) {
	            var seq = this.asSeq();
	            if (pos >= 0) {
	                seq.items.splice(pos, 0, node._actualNode());
	            }
	            else {
	                seq.items.push(node._actualNode());
	            }
	        }
	        else {
	            throw "Insert into " + this.kindName() + " not supported";
	        }
	    };
	    ASTNode.prototype.removeChild = function (n) {
	        this._oldText = null;
	        var node = n;
	        var ynode;
	        var index;
	        //console.log('*** REMOVE FROM: ' + this.kindName());
	        if (this.kind() == 3 /* SEQ */) {
	            //console.log('remove from seq');
	            var seq = this.asSeq();
	            //val = <yaml.YamlMap>((<yaml.YAMLMapping>this._node).value);
	            ynode = node._node;
	            index = seq.items.indexOf(ynode);
	            if (index > -1)
	                seq.items.splice(index, 1);
	        }
	        else if (this.kind() == 2 /* MAP */) {
	            //val = <yaml.YamlMap>((<yaml.YAMLMapping>this._node).value);
	            var map = this.asMap();
	            //console.log('remove from map: ' + map.mappings.length);
	            ynode = node.asMapping();
	            index = map.mappings.indexOf(ynode);
	            //console.log('  index: ' + index);
	            if (index > -1)
	                map.mappings.splice(index, 1);
	        }
	        else if (this.kind() == 1 /* MAPPING */) {
	            //console.log('*** REMOVE FROM MAPPING');
	            //val = <yaml.YamlMap>((<yaml.YAMLMapping>this._node).value);
	            //console.log('remove from mapping with map as value');
	            var mapping = this.asMapping();
	            //this.show("REMOVE TARGET: ***");
	            //node.show("REMOVE NODE: ***");
	            if (node._actualNode() == mapping.value) {
	                // remove right from mapping
	                //console.log('*** remove map from mapping!');
	                mapping.value = null;
	            }
	            else {
	                var map = (mapping.value);
	                ynode = node.asMapping();
	                if (map && map.mappings) {
	                    index = map.mappings.indexOf(ynode);
	                    if (index > -1)
	                        map.mappings.splice(index, 1);
	                }
	            }
	        }
	        else {
	            throw "Delete from " + yaml.Kind[this.kind()] + " unsupported";
	        }
	    };
	    ASTNode.prototype.includeErrors = function () {
	        if (this._node.kind == 1 /* MAPPING */) {
	            var mapping = this._node;
	            if (mapping.value == null) {
	                return [];
	            }
	            return new ASTNode(mapping.value, this._unit, this, this._anchor, this._include).includeErrors();
	        }
	        var rs = [];
	        if (this._node.kind == 5 /* INCLUDE_REF */) {
	            var mapping = this._node;
	            if (mapping.value == null) {
	                return [];
	            }
	            var includePath = this.includePath();
	            var resolved = this._unit.resolve(includePath);
	            if (resolved == null) {
	                rs.push("Can not resolve " + includePath);
	                return rs;
	            }
	            if (resolved.isRAMLUnit()) {
	                var ast = resolved.ast();
	                if (ast) {
	                    return [];
	                }
	                else {
	                    rs.push("" + includePath + " can not be parsed");
	                }
	            }
	        }
	        return rs;
	    };
	    ASTNode.prototype.children = function (inc, anc, inOneMemberMap) {
	        var _this = this;
	        if (inc === void 0) { inc = null; }
	        if (anc === void 0) { anc = null; }
	        if (inOneMemberMap === void 0) { inOneMemberMap = true; }
	        if (this._node == null) {
	            return []; //TODO FIXME
	        }
	        if (this.cacheChildren && this._children) {
	            return this._children;
	        }
	        var result;
	        var kind = this._node.kind;
	        if (kind == 0 /* SCALAR */) {
	            result = [];
	        }
	        else if (kind == 2 /* MAP */) {
	            var map = this._node;
	            if (map.mappings.length == 1 && !inOneMemberMap) {
	                //handle map with one member case differently
	                // q:
	                //  []
	                //   - a
	                //   - b
	                // ->
	                // q:
	                //  a
	                //  b
	                result = new ASTNode(map.mappings[0].value, this._unit, this, inc, anc, this.cacheChildren).children(null, null, true);
	            }
	            else {
	                result = map.mappings.map(function (x) { return new ASTNode(x, _this._unit, _this, anc ? anc : _this._anchor, inc ? inc : _this._include, _this.cacheChildren); });
	            }
	        }
	        else if (kind == 1 /* MAPPING */) {
	            var mapping = this._node;
	            if (mapping.value == null) {
	                result = [];
	            }
	            else {
	                result = new ASTNode(mapping.value, this._unit, this, anc ? anc : this._anchor, inc ? inc : this._include, this.cacheChildren).children();
	            }
	        }
	        else if (kind == 3 /* SEQ */) {
	            var seq = this._node;
	            result = seq.items.filter(function (x) { return x != null; }).map(function (x) { return new ASTNode(x, _this._unit, _this, anc ? anc : _this._anchor, inc ? inc : _this._include, _this.cacheChildren); });
	        }
	        else if (kind == 5 /* INCLUDE_REF */) {
	            if (this._unit) {
	                var includePath = this.includePath();
	                var resolved = this._unit.resolve(includePath);
	                if (resolved == null) {
	                    result = [];
	                }
	                else if (resolved.isRAMLUnit()) {
	                    var ast = resolved.ast();
	                    if (ast) {
	                        if (this.cacheChildren) {
	                            ast = toChildCahcingNode(ast);
	                        }
	                        result = resolved.ast().children(this, null);
	                    }
	                }
	            }
	            if (!result) {
	                result = [];
	            }
	        }
	        else if (kind == 4 /* ANCHOR_REF */) {
	            var ref = this._node;
	            result = new ASTNode(ref.value, this._unit, this, null, null, this.cacheChildren).children();
	        }
	        else {
	            throw new Error("Should never happen; kind : " + yaml.Kind[this._node.kind]);
	        }
	        if (this.cacheChildren) {
	            this._children = result;
	        }
	        return result;
	    };
	    ASTNode.prototype.directChildren = function (inc, anc, inOneMemberMap) {
	        var _this = this;
	        if (inc === void 0) { inc = null; }
	        if (anc === void 0) { anc = null; }
	        if (inOneMemberMap === void 0) { inOneMemberMap = true; }
	        if (this._node) {
	            switch (this._node.kind) {
	                case 0 /* SCALAR */:
	                    return [];
	                case 2 /* MAP */:
	                    {
	                        var map = this._node;
	                        if (map.mappings.length == 1 && !inOneMemberMap) {
	                            //handle map with one member case differently
	                            return new ASTNode(map.mappings[0].value, this._unit, this, inc, anc).directChildren(null, null, true);
	                        }
	                        return map.mappings.map(function (x) { return new ASTNode(x, _this._unit, _this, anc ? anc : _this._anchor, inc ? inc : _this._include); });
	                    }
	                case 1 /* MAPPING */:
	                    {
	                        var mapping = this._node;
	                        if (mapping.value == null) {
	                            return [];
	                        }
	                        return new ASTNode(mapping.value, this._unit, this, anc ? anc : this._anchor, inc ? inc : this._include).directChildren();
	                    }
	                case 3 /* SEQ */:
	                    {
	                        var seq = this._node;
	                        return seq.items.filter(function (x) { return x != null; }).map(function (x) { return new ASTNode(x, _this._unit, _this, anc ? anc : _this._anchor, inc ? inc : _this._include); });
	                    }
	                case 5 /* INCLUDE_REF */:
	                    {
	                        return [];
	                    }
	                case 4 /* ANCHOR_REF */:
	                    {
	                        return [];
	                    }
	            }
	            throw new Error("Should never happen; kind : " + yaml.Kind[this._node.kind]);
	        }
	        return [];
	    };
	    ASTNode.prototype.anchorId = function () {
	        return this._node.anchorId;
	    };
	    ASTNode.prototype.unit = function () {
	        return this._unit;
	        //if(this._unit) return this._unit;
	        //if(!this.parent()) return null;
	        //return this.parent().unit();
	    };
	    ASTNode.prototype.setUnit = function (unit) {
	        this._unit = unit;
	    };
	    ASTNode.prototype.includePath = function () {
	        if (this._node.kind == 5 /* INCLUDE_REF */) {
	            var includePath = this._node['value'];
	            return includePath;
	        }
	        else if (this._node.kind == 1 /* MAPPING */) {
	            var mapping = this._node;
	            if (mapping.value == null)
	                return null;
	            return new ASTNode(mapping.value, this._unit, this, null, null).includePath();
	        }
	        return null;
	    };
	    ASTNode.prototype.anchoredFrom = function () {
	        return this._anchor;
	    };
	    ASTNode.prototype.includedFrom = function () {
	        return this._include;
	    };
	    ASTNode.prototype.kind = function () {
	        return this._actualNode().kind;
	    };
	    ASTNode.prototype.valueKind = function () {
	        if (this._node.kind != 1 /* MAPPING */) {
	            return null;
	        }
	        var map = this._node;
	        if (!map.value) {
	            return null;
	        }
	        return map.value.kind;
	    };
	    ASTNode.prototype.valueKindName = function () {
	        var kind = this.valueKind();
	        return kind != undefined ? yaml.Kind[kind] : null;
	    };
	    ASTNode.prototype.kindName = function () {
	        return yaml.Kind[this.kind()];
	    };
	    ASTNode.prototype.indent = function (lev, str) {
	        if (str === void 0) { str = ''; }
	        var leading = '';
	        for (var i = 0; i < lev; i++)
	            leading += '  ';
	        return leading + str;
	    };
	    ASTNode.prototype.replaceNewlines = function (s, rep) {
	        if (rep === void 0) { rep = null; }
	        var res = '';
	        for (var i = 0; i < s.length; i++) {
	            var ch = s[i];
	            if (ch == '\r')
	                ch = rep == null ? '\\r' : rep;
	            if (ch == '\n')
	                ch = rep == null ? '\\n' : rep;
	            res += ch;
	        }
	        return res;
	    };
	    ASTNode.prototype.shortText = function (unittext, maxlen) {
	        if (maxlen === void 0) { maxlen = 50; }
	        var elen = this.end() - this.start();
	        var len = elen;
	        //var len = Math.min(elen,50);
	        var unit = this.unit();
	        if (!unittext && unit) {
	            unittext = unit.contents();
	        }
	        var text;
	        if (!unittext) {
	            text = '[no-unit]';
	        }
	        else {
	            var s = unittext;
	            text = s ? s.substring(this.start(), this.end()) : '[no-text]';
	        }
	        text = "[" + this.start() + ".." + this.end() + "] " + elen + " // " + text + ' //';
	        if (len < elen)
	            text += '...';
	        text = this.replaceNewlines(text);
	        return text;
	    };
	    ASTNode.prototype.nodeShortText = function (node, unittext, maxlen) {
	        if (maxlen === void 0) { maxlen = 50; }
	        var elen = node.endPosition - node.startPosition;
	        var len = elen;
	        //var len = Math.min(elen,50);
	        var unit = this.unit();
	        if (!unittext && unit) {
	            unittext = unit.contents();
	        }
	        var text;
	        if (!unittext) {
	            text = '[no-unit]';
	        }
	        else {
	            var s = unittext;
	            text = s ? s.substring(node.startPosition, node.endPosition) : '[no-text]';
	        }
	        text = "[" + node.startPosition + ".." + node.endPosition + "] " + elen + " // " + text + ' //';
	        if (len < elen)
	            text += '...';
	        text = this.replaceNewlines(text);
	        return text;
	    };
	    ASTNode.prototype.show = function (message, lev, text) {
	        if (message === void 0) { message = null; }
	        if (lev === void 0) { lev = 0; }
	        if (text === void 0) { text = null; }
	        if (message && lev == 0) {
	            console.log(message);
	        }
	        var children = this.children();
	        var desc = this.kindName();
	        var val = this._actualNode().value;
	        if (this.kind() == 1 /* MAPPING */) {
	            desc += '[' + this._actualNode().key.value + ']';
	        }
	        if (val) {
	            desc += "/" + yaml.Kind[val.kind];
	        }
	        else
	            desc += "";
	        if (children.length == 0) {
	            //desc += "/" + this.value();
	            console.log(this.indent(lev) + desc + " // " + this.shortText(text));
	            if (this.isMapping() && this.asMapping().value) {
	                console.log(this.indent(lev + 1) + '// ' + this.valueKindName() + ': ' + this.nodeShortText(this.asMapping().value, text));
	            }
	        }
	        else {
	            console.log(this.indent(lev) + desc + " { // " + this.shortText(text));
	            if (this.isMapping() && this.asMapping().value) {
	                console.log(this.indent(lev + 1) + '// ' + this.valueKindName() + ': ' + this.nodeShortText(this.asMapping().value, text));
	            }
	            children.forEach(function (node) {
	                var n = node;
	                n.show(null, lev + 1, text);
	            });
	            console.log(this.indent(lev) + '}');
	        }
	    };
	    ASTNode.prototype.showParents = function (message, lev) {
	        if (lev === void 0) { lev = 0; }
	        if (message && lev == 0) {
	            console.log(message);
	        }
	        var depth = 0;
	        if (this.parent()) {
	            var n = this.parent();
	            depth = n.showParents(null, lev + 1);
	        }
	        var desc = this.kindName();
	        var val = this._actualNode().value;
	        if (val)
	            desc += "/" + yaml.Kind[val.kind];
	        else
	            desc += "/null";
	        console.log(this.indent(depth) + desc + " // " + this.shortText(null));
	        return depth + 1;
	    };
	    ASTNode.prototype.inlined = function (kind) {
	        return kind == 0 /* SCALAR */ || kind == 5 /* INCLUDE_REF */;
	    };
	    ASTNode.prototype.markupNode = function (xbuf, node, lev, json) {
	        if (json === void 0) { json = false; }
	        var start = xbuf.text.length;
	        switch (node.kind) {
	            case 2 /* MAP */:
	                if (json)
	                    xbuf.append('{');
	                var mappings = node.mappings;
	                for (var i = 0; i < mappings.length; i++) {
	                    if (json && i > 0)
	                        xbuf.append(', ');
	                    this.markupNode(xbuf, mappings[i], lev, json);
	                }
	                if (json)
	                    xbuf.append('}');
	                break;
	            case 3 /* SEQ */:
	                var items = node.items;
	                for (var i = 0; i < items.length; i++) {
	                    xbuf.append(this.indent(lev, '- '));
	                    //this.markupNode(xindent, pos+xbuf.text.length-(lev+1)*2, items[i], lev+1, xbuf);
	                    this.markupNode(xbuf, items[i], lev + 1, json);
	                }
	                break;
	            case 1 /* MAPPING */:
	                var mapping = node;
	                var val = mapping.value;
	                //console.log('mapping: ' + mapping.key.value + ' ' + val.kind);
	                if (json) {
	                    xbuf.append(mapping.key.value);
	                    xbuf.append(': ');
	                    if (val.kind == 0 /* SCALAR */) {
	                        var sc = val;
	                        xbuf.append(sc.value);
	                    }
	                    else if (val.kind == 2 /* MAP */) {
	                        //var mp = <yaml.YamlMap>val;
	                        this.markupNode(xbuf, mapping.value, lev + 1, json);
	                    }
	                    else {
	                        throw "markup not implemented: " + yaml.Kind[val.kind];
	                    }
	                    break;
	                }
	                xbuf.addWithIndent(lev, mapping.key.value + ':');
	                if (!val) {
	                    xbuf.append('\n');
	                    break;
	                }
	                if (val.kind == 0 /* SCALAR */) {
	                    var sc = val;
	                }
	                //xbuf.append(this.indent(lev, mapping.key.value + ':'));
	                if (mapping.value) {
	                    xbuf.append(this.inlined(mapping.value.kind) ? ' ' : '\n');
	                    this.markupNode(xbuf, mapping.value, lev + 1, json);
	                }
	                else {
	                    xbuf.append('\n');
	                }
	                break;
	            case 0 /* SCALAR */:
	                var sc = node;
	                if (textutil.isMultiLine(sc.value)) {
	                    xbuf.append('|\n');
	                    var lines = splitOnLines(sc.value);
	                    for (var i = 0; i < lines.length; i++) {
	                        xbuf.append(this.indent(lev, lines[i]));
	                    }
	                    xbuf.append('\n');
	                }
	                else {
	                    xbuf.append(sc.value + '\n');
	                }
	                break;
	            case 5 /* INCLUDE_REF */:
	                var ref = node;
	                xbuf.append('!include ' + ref.value + '\n');
	                break;
	            default:
	                throw 'Unknown node kind: ' + yaml.Kind[node.kind];
	                break;
	        }
	        while (start < xbuf.text.length && xbuf.text[start] == ' ')
	            start++;
	        node.startPosition = start;
	        node.endPosition = xbuf.text.length;
	    };
	    ASTNode.prototype.markup = function (json) {
	        if (json === void 0) { json = false; }
	        var buf = new MarkupIndentingBuffer('');
	        this.markupNode(buf, this._actualNode(), 0, json);
	        return buf.text;
	    };
	    ASTNode.prototype.root = function () {
	        var node = this;
	        while (node.parent()) {
	            var p = node.parent();
	            //if(p.isValueInclude()) break; // stop on include
	            node = p;
	        }
	        return node;
	    };
	    ASTNode.prototype.parentOfKind = function (kind) {
	        var p = this.parent();
	        while (p) {
	            if (p.kind() == kind)
	                return p;
	            p = p.parent();
	        }
	        return null;
	    };
	    ASTNode.prototype.find = function (name) {
	        var found = null;
	        //console.log('Looking for: ' + name);
	        this.directChildren().forEach(function (y) {
	            if (y.key() && y.key() == name) {
	                if (!found)
	                    found = y;
	            }
	        });
	        return found;
	    };
	    ASTNode.prototype.shiftNodes = function (offset, shift, exclude) {
	        this.directChildren().forEach(function (x) {
	            if (exclude && exclude.start() == x.start() && exclude.end() == x.end()) {
	            }
	            else {
	                var m = x.shiftNodes(offset, shift, exclude);
	            }
	        });
	        if (exclude && exclude.start() == this.start() && exclude.end() == this.end()) {
	        }
	        else {
	            var yaNode = this._actualNode();
	            if (yaNode)
	                innerShift(offset, yaNode, shift);
	        }
	        return null;
	    };
	    ASTNode.prototype.isMap = function () {
	        return this.kind() == 2 /* MAP */;
	    };
	    ASTNode.prototype.isMapping = function () {
	        return this.kind() == 1 /* MAPPING */;
	    };
	    ASTNode.prototype.isSeq = function () {
	        return this.kind() == 3 /* SEQ */;
	    };
	    ASTNode.prototype.isScalar = function () {
	        return this.kind() == 0 /* SCALAR */;
	    };
	    ASTNode.prototype.asMap = function () {
	        if (!this.isMap())
	            throw "map expected instead of " + this.kindName();
	        return (this._actualNode());
	    };
	    ASTNode.prototype.asMapping = function () {
	        if (!this.isMapping())
	            throw "maping expected instead of " + this.kindName();
	        return (this._actualNode());
	    };
	    ASTNode.prototype.asSeq = function () {
	        if (!this.isSeq())
	            throw "seq expected instead of " + this.kindName();
	        return (this._actualNode());
	    };
	    ASTNode.prototype.asScalar = function () {
	        if (!this.isScalar())
	            throw "scalar expected instead of " + this.kindName();
	        return (this._actualNode());
	    };
	    ASTNode.prototype.isValueSeq = function () {
	        return this.valueKind() == 3 /* SEQ */;
	    };
	    ASTNode.prototype.isValueMap = function () {
	        return this.valueKind() == 2 /* MAP */;
	    };
	    ASTNode.prototype.isValueInclude = function () {
	        return this.valueKind() == 5 /* INCLUDE_REF */;
	    };
	    ASTNode.prototype.isValueScalar = function () {
	        return this.valueKind() == 0 /* SCALAR */;
	    };
	    ASTNode.prototype.valueAsSeq = function () {
	        if (!this.isMapping())
	            throw "mapping expected instead of " + this.kindName();
	        if (this.valueKind() != 3 /* SEQ */)
	            throw "mappng/seq expected instead of mapping/" + this.kindName();
	        return (this.asMapping().value);
	    };
	    ASTNode.prototype.valueAsMap = function () {
	        if (!this.isMapping())
	            throw "mapping expected instead of " + this.kindName();
	        if (this.valueKind() != 2 /* MAP */)
	            throw "mappng/map expected instead of mapping/" + this.kindName();
	        return (this.asMapping().value);
	    };
	    ASTNode.prototype.valueAsScalar = function () {
	        if (!this.isMapping())
	            throw "mapping expected instead of " + this.kindName();
	        if (this.valueKind() != 0 /* SCALAR */)
	            throw "mappng/scalar expected instead of mapping/" + this.kindName();
	        return (this.asMapping().value);
	    };
	    ASTNode.prototype.valueAsInclude = function () {
	        if (!this.isMapping())
	            throw "mapping expected instead of " + this.kindName();
	        if (this.valueKind() != 5 /* INCLUDE_REF */)
	            throw "mappng/include expected instead of mapping/" + this.kindName();
	        return (this.asMapping().value);
	    };
	    ASTNode.prototype.text = function (unitText) {
	        if (unitText === void 0) { unitText = null; }
	        if (!unitText) {
	            if (!this.unit())
	                return '[no-text]';
	            unitText = this.unit().contents();
	        }
	        return unitText.substring(this.start(), this.end());
	    };
	    ASTNode.prototype.copy = function () {
	        var yn = copyNode(this._actualNode());
	        return new ASTNode(yn, this._unit, this._parent, this._anchor, this._include);
	    };
	    ASTNode.prototype.nodeDefinition = function () {
	        return getDefinitionForLowLevelNode(this);
	    };
	    return ASTNode;
	})();
	exports.ASTNode = ASTNode;
	(function (InsertionPointType) {
	    InsertionPointType[InsertionPointType["NONE"] = 0] = "NONE";
	    InsertionPointType[InsertionPointType["START"] = 1] = "START";
	    InsertionPointType[InsertionPointType["END"] = 2] = "END";
	    InsertionPointType[InsertionPointType["POINT"] = 3] = "POINT";
	})(exports.InsertionPointType || (exports.InsertionPointType = {}));
	var InsertionPointType = exports.InsertionPointType;
	var InsertionPoint = (function () {
	    function InsertionPoint(type, point) {
	        if (point === void 0) { point = null; }
	        this.type = type;
	        this.point = point;
	    }
	    InsertionPoint.after = function (point) {
	        return new InsertionPoint(3 /* POINT */, point);
	    };
	    InsertionPoint.atStart = function () {
	        return new InsertionPoint(1 /* START */);
	    };
	    InsertionPoint.atEnd = function () {
	        return new InsertionPoint(2 /* END */);
	    };
	    InsertionPoint.node = function () {
	        return new InsertionPoint(0 /* NONE */);
	    };
	    InsertionPoint.prototype.show = function (msg) {
	        if (msg) {
	            console.log(msg);
	            console.log('  insertion point type: ' + InsertionPointType[this.type]);
	        }
	        else {
	            console.log('insertion point type: ' + InsertionPointType[this.type]);
	        }
	        if (this.type == 3 /* POINT */ && this.point) {
	            this.point.show();
	        }
	    };
	    return InsertionPoint;
	})();
	exports.InsertionPoint = InsertionPoint;
	function createNode(key) {
	    //console.log('create node: ' + key);
	    var node = yaml.newMapping(yaml.newScalar(key), yaml.newMap());
	    return new ASTNode(node, null, null, null, null);
	}
	exports.createNode = createNode;
	function createMap(mappings) {
	    //console.log('create node: ' + key);
	    var node = yaml.newMap(mappings);
	    return new ASTNode(node, null, null, null, null);
	}
	exports.createMap = createMap;
	function createScalar(value) {
	    var node = yaml.newScalar(value);
	    return new ASTNode(node, null, null, null, null);
	}
	exports.createScalar = createScalar;
	function createSeq(sn, parent, unit) {
	    return new ASTNode(sn, unit, parent, null, null);
	}
	exports.createSeq = createSeq;
	/*
	export function createMappingWithMap(key:string, map: yaml.YAMLNode){
	    //console.log('create node: ' + key);
	    var node:yaml.YAMLNode=yaml.newMapping(yaml.newScalar(key),map);
	    return new ASTNode(node,null,null,null,null);
	}

	export function createMap(){
	    //console.log('create node: ' + key);
	    var node:yaml.YAMLNode=yaml.newMap();
	    return new ASTNode(node,null,null,null,null);
	}
	*/
	function createSeqNode(key) {
	    var node = yaml.newMapping(yaml.newScalar(key), yaml.newItems());
	    return new ASTNode(node, null, null, null, null);
	}
	exports.createSeqNode = createSeqNode;
	function createMapNode(key) {
	    var node = yaml.newMapping(yaml.newScalar(key), yaml.newMap());
	    return new ASTNode(node, null, null, null, null);
	}
	exports.createMapNode = createMapNode;
	function createMapping(key, v) {
	    //console.log('create mapping: ' + key);
	    var node = yaml.newMapping(yaml.newScalar(key), yaml.newScalar(v));
	    return new ASTNode(node, null, null, null, null);
	}
	exports.createMapping = createMapping;
	function toChildCahcingNode(node) {
	    if (!(node instanceof ASTNode)) {
	        return null;
	    }
	    var astNode = node;
	    var result = new ASTNode(astNode.yamlNode(), astNode.unit(), null, null, null, true);
	    result._errors = astNode._errors;
	    return result;
	}
	exports.toChildCahcingNode = toChildCahcingNode;
	function getDefinitionForLowLevelNode(node) {
	    var hl = node.highLevelNode();
	    if (hl) {
	        return hl.definition();
	    }
	    var parent = node.parent();
	    if (!parent) {
	        return null;
	    }
	    var key = node.key();
	    if (!key) {
	        return null;
	    }
	    var parentDef = parent.nodeDefinition();
	    if (!parentDef) {
	        return null;
	    }
	    if (!parentDef.property) {
	        return null;
	    }
	    var prop = parentDef.property(key);
	    if (!prop) {
	        return null;
	    }
	    return prop.range();
	}
	exports.getDefinitionForLowLevelNode = getDefinitionForLowLevelNode;
	//# sourceMappingURL=jsyaml2lowLevel.js.map

/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../typings/tsd.d.ts" />
	var __extends = this.__extends || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    __.prototype = b.prototype;
	    d.prototype = new __();
	};
	var jsyaml = __webpack_require__(6);
	var defs = __webpack_require__(21);
	var hl = __webpack_require__(17);
	var ll = __webpack_require__(25);
	var _ = __webpack_require__(47);
	var yaml = __webpack_require__(19);
	var proxy = __webpack_require__(13);
	var typeExpression = __webpack_require__(31);
	var def = __webpack_require__(21);
	var builder = __webpack_require__(32);
	var linter = __webpack_require__(33);
	var typeBuilder = __webpack_require__(34);
	var search = __webpack_require__(35);
	var textutil = __webpack_require__(29);
	var ModelFactory = __webpack_require__(36);
	var ovlval = __webpack_require__(37);
	function qName(x, context) {
	    var dr = search.declRoot(context);
	    var nm = x.name();
	    var o = nm;
	    var ind = nm.indexOf("<"); //TODO SCOPE IT
	    if (ind != -1) {
	        nm = nm.substring(0, ind);
	    }
	    while (true) {
	        var np = x.parent();
	        if (!np || np == dr) {
	            break;
	        }
	        else {
	            if (np.definition().name() == "Library" && np.parent()) {
	                nm = np.name() + "." + nm;
	            }
	            x = np;
	        }
	    }
	    return nm;
	}
	exports.qName = qName;
	function insideResourceTypeOrTrait(h) {
	    var declRoot = h;
	    while (true) {
	        if (declRoot.definition().isInlinedTemplates()) {
	            return true;
	        }
	        var np = declRoot.parent();
	        if (!np) {
	            break;
	        }
	        else {
	            declRoot = np;
	        }
	    }
	    return false;
	}
	var loophole = __webpack_require__(48);
	function evalInSandbox(code, thisArg, args) {
	    return new loophole.Function(code).call(thisArg, args);
	}
	exports.evalInSandbox = evalInSandbox;
	var BasicASTNode = (function () {
	    function BasicASTNode(_node, _parent) {
	        this._node = _node;
	        this._parent = _parent;
	        this._implicit = false;
	        this.values = {};
	        if (_node) {
	            _node.setHighLevelParseResult(this);
	        }
	    }
	    BasicASTNode.prototype.getKind = function () {
	        return 0 /* BASIC */;
	    };
	    BasicASTNode.prototype.hashkey = function () {
	        if (!this._hashkey)
	            this._hashkey = this.parent() ? this.parent().hashkey() + "/" + this.name() : this.name();
	        return this._hashkey;
	    };
	    BasicASTNode.prototype.root = function () {
	        if (this.parent()) {
	            return this.parent().root();
	        }
	        return this;
	    };
	    BasicASTNode.prototype.checkContextValue = function (name, value, thisObj) {
	        var vl = this.computedValue(name);
	        if (vl && vl.indexOf(value) != -1) {
	            return true; //FIXME
	        }
	        if (!vl) {
	            try {
	                var res = evalInSandbox("return " + name, thisObj, []);
	                if (res != undefined) {
	                    return "" + res == value;
	                }
	            }
	            catch (e) {
	            }
	        }
	        return value == vl || value == 'false';
	    };
	    BasicASTNode.prototype.printDetails = function (indent) {
	        return (indent ? indent : "") + "Unkown\n";
	    };
	    BasicASTNode.prototype.errors = function () {
	        var errors = [];
	        var q = {
	            accept: function (c) {
	                errors.push(c);
	            },
	            begin: function () {
	            },
	            end: function () {
	            }
	        };
	        this.validate(q);
	        return errors;
	    };
	    BasicASTNode.prototype.toRuntimeModel = function () {
	        var _this = this;
	        var thisObj = {};
	        //FIXME it should be be done in much cooler way
	        //Spec for runtime is also needed
	        this.children().forEach(function (x) {
	            if (x instanceof ASTPropImpl) {
	                var pr = x;
	                var val = pr.value();
	                if (val) {
	                    var type = pr.property().range();
	                    val = _this.fillValue(type, val);
	                    thisObj[x.name()] = val;
	                }
	            }
	        });
	        return thisObj;
	    };
	    BasicASTNode.prototype.fillValue = function (type, val) {
	        type.methods().forEach(function (m) {
	            if (typeof val == 'string') {
	                var newVal = {};
	                newVal['value'] = new loophole.Function("return this._value");
	                newVal._value = val;
	                val = newVal;
	            }
	            var nm = m.name;
	            var body = m.text;
	            var actualText = body.substring(body.indexOf('{') + 1, body.lastIndexOf('}'));
	            var func = new loophole.Function(actualText);
	            val[nm] = func;
	        });
	        val['$$'] = this;
	        return val;
	    };
	    BasicASTNode.prototype.markCh = function () {
	        var n = this.lowLevel();
	        n = n._node ? n._node : n;
	        if (n['markCh']) {
	            return true;
	        }
	        n['markCh'] = 1;
	    };
	    BasicASTNode.prototype.unmarkCh = function () {
	        var n = this.lowLevel();
	        n = n._node ? n._node : n;
	        delete n['markCh'];
	    };
	    BasicASTNode.prototype.validate = function (v) {
	        var _this = this;
	        if (this.lowLevel() && this._parent == null) {
	            this.lowLevel().errors().forEach(function (x) {
	                var em = {
	                    code: 1 /* YAML_ERROR */,
	                    message: x.message,
	                    node: null,
	                    start: x.mark.position,
	                    end: x.mark.position + 1,
	                    isWarning: false,
	                    path: _this.lowLevel().unit() == _this.root().lowLevel().unit() ? null : _this.lowLevel().unit().path(),
	                    unit: _this.lowLevel().unit()
	                };
	                v.accept(em);
	            });
	        }
	        this.validateIncludes(v);
	        if (this.isUnknown()) {
	            if (this.needSequence) {
	                v.accept(createIssue(2 /* UNKNOWN_NODE */, "node: " + this.name() + " should be wrapped in sequence", this));
	            }
	            if (this.unresolvedRef) {
	                v.accept(createIssue(2 /* UNKNOWN_NODE */, "reference : " + this.lowLevel().value() + " can not be resolved", this));
	            }
	            if (this.knownProperty && this.lowLevel().value()) {
	                v.accept(createIssue(2 /* UNKNOWN_NODE */, "property " + this.name() + " can not have scalar value", this));
	            }
	            else {
	                v.accept(createIssue(2 /* UNKNOWN_NODE */, "Unknown node:" + this.name(), this));
	            }
	        }
	        if (this.markCh() && !this.allowRecursive()) {
	            v.accept(createIssue(2 /* UNKNOWN_NODE */, "Recursive definition:" + this.name(), this));
	            return;
	        }
	        try {
	            this.directChildren().forEach(function (x) { return x.validate(v); });
	        }
	        finally {
	            this.unmarkCh();
	        }
	    };
	    BasicASTNode.prototype.allowRecursive = function () {
	        return false;
	    };
	    BasicASTNode.prototype.validateIncludes = function (v) {
	        var _this = this;
	        if (this.lowLevel()) {
	            this.lowLevel().includeErrors().forEach(function (x) {
	                var em = createIssue(6 /* UNABLE_TO_RESOLVE_INCLUDE_FILE */, x, _this);
	                v.accept(em);
	            });
	        }
	    };
	    BasicASTNode.prototype.setComputed = function (name, v) {
	        this.values[name] = v;
	    };
	    BasicASTNode.prototype.computedValue = function (name) {
	        var vl = this.values[name];
	        if (!vl && this.parent()) {
	            return this.parent().computedValue(name);
	        }
	        return vl;
	    };
	    BasicASTNode.prototype.lowLevel = function () {
	        return this._node;
	    };
	    BasicASTNode.prototype.expansionSpec = function () {
	        return null;
	    };
	    BasicASTNode.prototype.name = function () {
	        var c = this.lowLevel().key();
	        if (!c) {
	            return "";
	        }
	        return c;
	    };
	    BasicASTNode.prototype.parent = function () {
	        return this._parent;
	    };
	    BasicASTNode.prototype.setParent = function (parent) {
	        this._parent = parent;
	    };
	    BasicASTNode.prototype.isElement = function () {
	        return false;
	    };
	    BasicASTNode.prototype.directChildren = function () {
	        return this.children();
	    };
	    BasicASTNode.prototype.children = function () {
	        return [];
	    };
	    BasicASTNode.prototype.isAttached = function () {
	        return this.parent() != null;
	    };
	    BasicASTNode.prototype.isImplicit = function () {
	        return this._implicit;
	    };
	    BasicASTNode.prototype.isAttr = function () {
	        return false;
	    };
	    BasicASTNode.prototype.isUnknown = function () {
	        return true;
	    };
	    BasicASTNode.prototype.id = function () {
	        var _this = this;
	        if (this._parent) {
	            var parentId = this.parent().id();
	            parentId += "." + this.name();
	            var sameName = this.parent().directChildren().filter(function (x) { return x.name() == _this.name(); });
	            if (sameName.length > 1) {
	                var ind = sameName.indexOf(this);
	                parentId += "[" + ind + "]";
	            }
	            return parentId;
	        }
	        return "";
	    };
	    BasicASTNode.prototype.localId = function () {
	        return this.name();
	    };
	    BasicASTNode.prototype.property = function () {
	        return null;
	    };
	    return BasicASTNode;
	})();
	exports.BasicASTNode = BasicASTNode;
	function createIssue(c, message, node, w) {
	    if (w === void 0) { w = false; }
	    return linter.createIssue(c, message, node, w);
	}
	exports.createIssue = createIssue;
	var StructuredValue = (function () {
	    function StructuredValue(node, _parent, _pr, kv) {
	        if (kv === void 0) { kv = null; }
	        this.node = node;
	        this._parent = _parent;
	        this.kv = kv;
	        this._pr = _pr;
	    }
	    StructuredValue.prototype.valueName = function () {
	        var res = null;
	        if (this.kv) {
	            res = this.kv;
	        }
	        res = this.node.key();
	        if (this._pr && this._pr.isAnnotation()) {
	            if (res && res.charAt(0) == '(') {
	                res = res.substring(1, res.length - 1);
	            }
	        }
	        return res;
	    };
	    StructuredValue.prototype.children = function () {
	        return this.node.children().map(function (x) { return new StructuredValue(x, null, null); });
	    };
	    StructuredValue.prototype.lowLevel = function () {
	        return this.node;
	    };
	    StructuredValue.prototype.toHighlevel = function (parent) {
	        if (!parent && this._parent)
	            parent = this._parent;
	        var vn = this.valueName();
	        var cands = this._pr.referenceTargets(parent).filter(function (x) { return qName(x, parent) == vn; });
	        if (cands && cands[0]) {
	            var tp = typeBuilder.typeFromNode(cands[0]);
	            var node = new ASTNodeImpl(this.node, parent, tp, this._pr);
	            if (this._pr) {
	                this._pr.childRestrictions().forEach(function (y) {
	                    node.setComputed(y.name, y.value);
	                });
	            }
	            return node;
	        }
	        return null;
	    };
	    return StructuredValue;
	})();
	exports.StructuredValue = StructuredValue;
	function genStructuredValue(type, name, mappings, parent) {
	    var map = yaml.newMap(mappings.map(function (mapping) { return yaml.newMapping(yaml.newScalar(mapping.key), yaml.newScalar(mapping.value)); }));
	    var node = new jsyaml.ASTNode(map, (parent ? parent.lowLevel().unit() : null), parent ? parent.lowLevel() : null, null, null);
	    return new StructuredValue(node, parent, parent ? parent.definition().property(type) : null, name);
	}
	exports.genStructuredValue = genStructuredValue;
	function checkPropertyQuard(n, v) {
	    var pr = n.property();
	    if (pr) {
	        pr.getContextRequirements().forEach(function (x) {
	            if (!n.checkContextValue(x.name, x.value, n.parent().toRuntimeModel())) {
	                v.accept(createIssue(8 /* MISSED_CONTEXT_REQUIREMENT */, x.name + " should be " + x.value + " to use property " + pr.name(), n));
	            }
	        });
	    }
	    return pr;
	}
	;
	var ASTPropImpl = (function (_super) {
	    __extends(ASTPropImpl, _super);
	    function ASTPropImpl(node, parent, _def, _prop, fromKey) {
	        if (fromKey === void 0) { fromKey = false; }
	        _super.call(this, node, parent);
	        this._def = _def;
	        this._prop = _prop;
	        this.fromKey = fromKey;
	    }
	    ASTPropImpl.prototype.definition = function () {
	        return this._def;
	    };
	    ASTPropImpl.prototype.getKind = function () {
	        return 2 /* ATTRIBUTE */;
	    };
	    ASTPropImpl.prototype.owningWrapper = function () {
	        return {
	            node: this.parent().wrapperNode(),
	            property: this.name()
	        };
	    };
	    ASTPropImpl.prototype.patchType = function (t) {
	        this._def = t;
	    };
	    ASTPropImpl.prototype.findReferenceDeclaration = function () {
	        var _this = this;
	        var targets = this.property().referenceTargets(this.parent());
	        var vl = this.value();
	        if (vl instanceof StructuredValue) {
	            var st = vl;
	            var nm = st.valueName();
	        }
	        else {
	            var nm = "" + vl;
	        }
	        var t = _.find(targets, function (x) { return qName(x, _this.parent()) == nm; });
	        return t;
	    };
	    ASTPropImpl.prototype.findReferencedValue = function () {
	        var c = this.findReferenceDeclaration();
	        if (c) {
	            var vl = c.attr("value");
	            if (c.definition().name() == "GlobalSchema") {
	                if (vl) {
	                    var actualValue = vl.value();
	                    if (actualValue) {
	                        var rf = this._def.isValid(this.parent(), actualValue, vl.property());
	                        return rf;
	                    }
	                }
	                return null;
	            }
	        }
	        return c;
	    };
	    /**
	     * TODO Split this method into the cases depending from property kind
	     * @param v
	     */
	    ASTPropImpl.prototype.validate = function (v) {
	        var pr = checkPropertyQuard(this, v);
	        var vl = this.value();
	        if (!this.property().range().hasStructure()) {
	            if (vl instanceof StructuredValue && !this.property().isSelfNode()) {
	                //TODO THIS SHOULD BE MOVED TO TYPESYSTEM FOR STS AT SOME MOMENT
	                if (this.property().name() == "schema" || this.property().name() == 'type') {
	                    if (this.property().domain().name() == "BodyLike") {
	                        var structValue = vl;
	                        var node = new ASTNodeImpl(this.lowLevel(), this.parent(), this.parent().definition().universe().getType("ObjectField"), this.property());
	                        node.validate(v);
	                        return;
	                    }
	                }
	                v.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, "Scalar is expected here", this));
	            }
	        }
	        if (this.parent().allowsQuestion() && this.property().isKey()) {
	            if (vl != null && vl.length > 0 && vl.charAt(vl.length - 1) == '?') {
	                vl = vl.substr(0, vl.length - 1);
	            }
	        }
	        if (typeof vl == 'string' && vl.indexOf("<<") != -1) {
	            if (vl.indexOf(">>") > vl.indexOf("<<")) {
	                if (insideResourceTypeOrTrait(this.parent())) {
	                    return;
	                }
	            }
	        }
	        this.validateIncludes(v);
	        if (this.property().range().name() == "MimeType" || (this.property().name() == "name" && this.parent().property().name() == "body")) {
	            new linter.MediaTypeValidator().validate(this, v);
	            return;
	        }
	        if (this.property().isKey()) {
	            if (vl.indexOf(" ") != -1) {
	                v.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, "Keys should not have spaces '" + this.value() + "'", this));
	            }
	        }
	        if (this.name() == "signature" && (this.property().domain().name() == "Resource" || this.property().domain().name() == "Method" || this.property().domain().name() == "MethodBase")) {
	            if (this.property().domain() instanceof defs.NodeClass) {
	                new linter.SignatureValidator().validate(this, v);
	                return;
	            }
	        }
	        //TODO TEMP ADDITION
	        if (this.property().name() == "example" || this.property().name() == "content") {
	            var pn = this.parent().definition().name();
	            new linter.ExampleValidator().validate(this, v);
	        }
	        if (this.property().name() == "name") {
	            //TODO MOVE TO DEF SYSTEM
	            if (this.parent().property() && this.parent().property().name() == 'uriParameters') {
	                new linter.UrlParameterNameValidator().validate(this, v);
	                return;
	            }
	            if (this.parent().property() && this.parent().property().name() == 'baseUriParameters') {
	                new linter.UrlParameterNameValidator().validate(this, v);
	                return;
	            }
	        }
	        if (this.property().range().name() == "RelativeUri") {
	            new linter.UriValidator().validate(this, v);
	            return;
	        }
	        if (this.property().range().name() == "FullUriTemplate") {
	            new linter.UriValidator().validate(this, v);
	            return;
	        }
	        if ("pattern" == this.name() && "StringType" == this.definition().name() && this.parent().definition().isAssignableFrom("StrElement")) {
	            try {
	                new RegExp(this.value());
	            }
	            catch (Error) {
	                v.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, "Illegal pattern " + this.value(), this));
	            }
	        }
	        if ("name" == this.name() && "StringType" == this.definition().name() && (typeof this.value() == "string") && this.value().indexOf("[") == 0 && this.value().lastIndexOf("]") == this.value().length - 1) {
	            if (this.parent() instanceof ASTNodeImpl && "properties" == this.parent().property().name()) {
	                if (this.parent().parent() instanceof ASTNodeImpl && "ObjectField" == this.parent().parent().definition().name()) {
	                    try {
	                        var cleanedValue = this.value().substr(1, this.value().length - 2);
	                        new RegExp(cleanedValue);
	                    }
	                    catch (Error) {
	                        v.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, "Illegal pattern " + cleanedValue, this));
	                    }
	                }
	            }
	        }
	        if (this.property().range().name() == "SchemaString" && this.property().range() instanceof def.ValueType && this.property().range().universe().version() == "RAML10") {
	            var pn = this.parent().definition().name();
	            new linter.SchemaOrTypeValidator().validate(this, v);
	            return;
	        }
	        if (this.property() instanceof def.Property) {
	            if (pr.isTypeExpr()) {
	                new linter.SchemaOrTypeValidator().validate(this, v);
	                return;
	            }
	        }
	        if (pr.isReference() || pr.isDescriminator()) {
	            new linter.DescriminatorOrReferenceValidator().validate(this, v);
	        }
	        else {
	            new linter.NormalValidator().validate(this, v);
	        }
	    };
	    ASTPropImpl.prototype.toRuntime = function () {
	        var vl = this.value();
	        var valueObj = this.fillValue(this.property().range(), vl);
	        if (valueObj['parse']) {
	            try {
	                return valueObj.parse();
	            }
	            catch (e) {
	                return e;
	            }
	        }
	        return valueObj;
	    };
	    ASTPropImpl.prototype.isElement = function () {
	        return false;
	    };
	    ASTPropImpl.prototype.property = function () {
	        return this._prop;
	    };
	    ASTPropImpl.prototype.convertMultivalueToString = function (value) {
	        //|\n  xxx\n  yyy\n  zzz
	        var gap = 0;
	        var pos = 2;
	        while (value[pos] == ' ') {
	            gap++;
	            pos++;
	        }
	        //console.log('gap: ' + gap);
	        var lines = textutil.splitOnLines(value);
	        lines = lines.map(function (line) {
	            //console.log('line: ' + line);
	            return line.substring(gap, line.length);
	        });
	        return lines.join('');
	    };
	    ASTPropImpl.prototype.value = function () {
	        if (this._computed) {
	            return this.computedValue(this.property().name());
	        }
	        if (this.fromKey) {
	            return this._node.key();
	        }
	        if (this.property().isAnnotation() && this._node.key() && this._node.key() != 'annotations') {
	            return new StructuredValue(this._node, this.parent(), this._prop);
	        }
	        var actualValue = this._node.value(); //TODO FIXME
	        if (this.property().isSelfNode()) {
	            if (!actualValue || actualValue instanceof jsyaml.ASTNode) {
	                actualValue = this._node;
	                if (actualValue.children().length == 0) {
	                    actualValue = null;
	                }
	            }
	        }
	        if (actualValue instanceof jsyaml.ASTNode || actualValue instanceof proxy.LowLevelProxyNode) {
	            return new StructuredValue(actualValue, this.parent(), this._prop);
	        }
	        if (textutil.isMultiLineValue(actualValue)) {
	            var res = this.convertMultivalueToString(actualValue);
	            //console.log('converted: [' + textutil.replaceNewlines(res) + ']');
	            return res;
	        }
	        return actualValue;
	    };
	    ASTPropImpl.prototype.name = function () {
	        return this._prop.name();
	    };
	    ASTPropImpl.prototype.printDetails = function (indent) {
	        var className = this.definition().name();
	        var definitionClassName = this.property().range().name();
	        return (indent ? indent : "") + (this.name() + " : " + className + "[" + definitionClassName + "]" + "  =  " + this.value()) + "\n";
	    };
	    ASTPropImpl.prototype.isAttr = function () {
	        return true;
	    };
	    ASTPropImpl.prototype.isUnknown = function () {
	        return false;
	    };
	    ASTPropImpl.prototype.setValue = function (value) {
	        if (value == this.value())
	            return;
	        var c = new ll.CompositeCommand();
	        if (typeof value === 'string') {
	            var val = value;
	            //FIXME actually isFromParentKey should be enough in future does not changing it now for safety reasons
	            if (this._prop.isFromParentKey() || this._prop.isAnnotation()) {
	                if (this._prop.isAnnotation()) {
	                    val = '(' + val + ')';
	                }
	                c.commands.push(ll.setKey(this._node, val));
	            }
	            else {
	                if ((!val || val.length == 0) && !this.isEmbedded()) {
	                    c.commands.push(ll.removeNode(this._node.parent(), this._node));
	                    this.parent().clearChildrenCache();
	                }
	                else {
	                    if (!val)
	                        val = '';
	                    c.commands.push(ll.setAttr(this._node, val));
	                }
	            }
	        }
	        else {
	            if (this._prop.isFromParentKey()) {
	                throw "couldn't set structured value to a key: " + this._prop.name();
	            }
	            var sval = value;
	            c.commands.push(ll.setAttrStructured(this._node, sval));
	        }
	        this._node.execute(c);
	    };
	    ASTPropImpl.prototype.setKey = function (value) {
	        if (value == this.name())
	            return;
	        var c = new ll.CompositeCommand();
	        c.commands.push(ll.setKey(this._node, value));
	        this._node.execute(c);
	    };
	    ASTPropImpl.prototype.children = function () {
	        return [];
	    };
	    ASTPropImpl.prototype.addStringValue = function (value) {
	        var sc = jsyaml.createScalar(value);
	        var target = this.lowLevel();
	        //console.log('add to target: ' + target.kindName());
	        if (target.isScalar()) {
	            target = target.parent();
	        }
	        else if (target.isMapping()) {
	        }
	        //var llparent = this.lowLevel().parent();
	        //console.log('parent: ' + llparent.kind());
	        //var attr = new ASTPropImpl(sc, this.parent(), this.property().range(), this.property());
	        //this.parent().add(attr);
	        var command = new ll.CompositeCommand();
	        command.commands.push(ll.insertNode(target, sc, null, true));
	        this.lowLevel().execute(command);
	        this.parent().clearChildrenCache();
	    };
	    ASTPropImpl.prototype.addStructuredValue = function (sv) {
	        //var sc = jsyaml.createScalar(value);
	        var target = this.lowLevel();
	        //console.log('add to target: ' + target.kindName());
	        if (target.isScalar()) {
	            target = target.parent();
	        }
	        else if (target.isMapping()) {
	            var ln = this.lowLevel();
	        }
	        //var llparent = this.lowLevel().parent();
	        //console.log('parent: ' + llparent.kind());
	        //var attr = new ASTPropImpl(sc, this.parent(), this.property().range(), this.property());
	        //this.parent().add(attr);
	        var command = new ll.CompositeCommand();
	        command.commands.push(ll.insertNode(target, sv.lowLevel(), null, true));
	        this.lowLevel().execute(command);
	        this.parent().clearChildrenCache();
	    };
	    ASTPropImpl.prototype.addValue = function (value) {
	        if (!this.property().isMultiValue())
	            throw "setValue(string) only apply to multi-values properties";
	        if (typeof value == 'string') {
	            this.addStringValue(value);
	        }
	        else {
	            this.addStructuredValue(value);
	        }
	    };
	    ASTPropImpl.prototype.isEmbedded = function () {
	        var keyname = this.lowLevel().asMapping().key.value;
	        //console.log('propery: ' + this.property().name());
	        //console.log('mapping: ' + keyname);
	        return this.property().canBeValue() && keyname != this.property().name();
	    };
	    ASTPropImpl.prototype.remove = function () {
	        //if(!this.property().isMultiValue()) throw "setValue(string) only apply to multi-values properties";
	        //var sc = jsyaml.createScalar(value);
	        var llparent = this.lowLevel().parent();
	        //llparent.show('parent:');
	        //this.lowLevel().show('attribute:');
	        //console.log('parent: ' + llparent.kind());
	        //var attr = new ASTPropImpl(sc, this.parent(), this.property().range(), this.property());
	        //this.parent().add(attr);
	        if (!this.property().isMultiValue() && this.isEmbedded()) {
	            // it's embedded value, need to clean scalar instead
	            //console.log('embedded!');
	            this.setValue('');
	        }
	        else {
	            var command = new ll.CompositeCommand();
	            command.commands.push(ll.removeNode(llparent, this.lowLevel()));
	            this.lowLevel().execute(command);
	            this.parent().clearChildrenCache();
	        }
	    };
	    ASTPropImpl.prototype.setValues = function (values) {
	        var _this = this;
	        if (!this.property().isMultiValue())
	            throw "setValue(string[]) only apply to multi-values properties";
	        var node = this.parent();
	        if (this.isEmpty()) {
	        }
	        else {
	            var llnode = node.lowLevel();
	            var attrs = node.attributes(this.name());
	            attrs.forEach(function (attr) { return attr.remove(); });
	        }
	        values.forEach(function (val) { return node.attrOrCreate(_this.name()).addValue(val); });
	        /*
	         if(attrs.length == 1) {
	         var anode = <jsyaml.ASTNode>attrs[0].lowLevel();
	         //console.log('attribute : ' + anode.kindName());
	         //anode.show("ATTR:");
	         if(anode.isMapping()) {
	         // that's crazy but it means zero length array indeed )
	         // nothing to remove so...
	         } else {
	         attrs.forEach(attr => attr.remove());
	         }
	         } else {
	         attrs.forEach(attr => attr.remove());
	         }
	         */
	    };
	    ASTPropImpl.prototype.isEmpty = function () {
	        if (!this.property().isMultiValue())
	            throw "isEmpty() only apply to multi-values attributes";
	        //console.log('remove: ' + this.name());
	        var node = this.parent();
	        var llnode = node.lowLevel();
	        //node.lowLevel().show('Parent:');
	        var attrs = node.attributes(this.name());
	        //console.log('attributes: ' + attrs.length);
	        if (attrs.length == 0) {
	            return true;
	        }
	        else if (attrs.length == 1) {
	            var anode = attrs[0].lowLevel();
	            //console.log('attribute : ' + anode.kindName());
	            //anode.show("ATTR:");
	            if (anode.isMapping()) {
	                // that's crazy but it means zero length array indeed )
	                return true;
	            }
	            else {
	                return false;
	            }
	        }
	        else {
	            return false;
	        }
	    };
	    return ASTPropImpl;
	})(BasicASTNode);
	exports.ASTPropImpl = ASTPropImpl;
	var nodeBuilder = new builder.BasicNodeBuilder();
	var ASTNodeImpl = (function (_super) {
	    __extends(ASTNodeImpl, _super);
	    function ASTNodeImpl(node, parent, _def, _prop) {
	        _super.call(this, node, parent);
	        this._def = _def;
	        this._prop = _prop;
	        this._expanded = false;
	        this._allowQuestion = false;
	        this._subTypesCache = null;
	        this._auxChecked = false;
	        if (node) {
	            node.setHighLevelNode(this);
	        }
	    }
	    ASTNodeImpl.prototype.getKind = function () {
	        return 1 /* NODE */;
	    };
	    ASTNodeImpl.prototype.wrapperNode = function () {
	        if (!this._wrapperNode) {
	            this._wrapperNode = ModelFactory.buildWrapperNode(this);
	        }
	        return this._wrapperNode;
	    };
	    ASTNodeImpl.prototype.propertiesAllowedToUse = function () {
	        var _this = this;
	        return this.definition().allProperties().filter(function (x) { return _this.isAllowedToUse(x); });
	    };
	    ASTNodeImpl.prototype.isAllowedToUse = function (p) {
	        var _this = this;
	        var ok = true;
	        if (p.isSystem()) {
	            return false;
	        }
	        p.getContextRequirements().forEach(function (y) {
	            if (y.name.indexOf('(') != -1) {
	                //TODO HANDLE IT LATER
	                return true;
	            }
	            var vl = _this.computedValue(y.name);
	            if (vl) {
	                ok = ok && (vl == y.value);
	            }
	            else {
	                if (y.value) {
	                    ok = false;
	                }
	            }
	        });
	        return ok;
	    };
	    ASTNodeImpl.prototype.allowRecursive = function () {
	        if (this.definition().isUserDefined()) {
	            return true;
	        }
	        return false;
	    };
	    ASTNodeImpl.prototype.setWrapperNode = function (node) {
	        this._wrapperNode = node;
	    };
	    ASTNodeImpl.prototype.setAssociatedType = function (d) {
	        this._associatedDef = d;
	    };
	    ASTNodeImpl.prototype.associatedType = function () {
	        return this._associatedDef;
	    };
	    ASTNodeImpl.prototype.findById = function (id) {
	        var _this = this;
	        var v = this._knownIds;
	        if (!v) {
	            this._knownIds = {};
	            var all = search.allChildren(this);
	            all.forEach(function (x) { return _this._knownIds[x.id()] = x; });
	        }
	        return this._knownIds[id];
	    };
	    ASTNodeImpl.prototype.isAuxilary = function () {
	        var _this = this;
	        if (this._isAux) {
	            return true;
	        }
	        if (this._auxChecked) {
	            return false;
	        }
	        this._auxChecked = true;
	        var mr = _.find(this.lowLevel().children(), function (x) { return x.key() == "masterRef"; });
	        if (mr && mr.value()) {
	            this._isAux = true;
	            var val = mr.value();
	            var unit = this.lowLevel().unit().project().resolve(this.lowLevel().unit().path(), val);
	            var api = hl.fromUnit(unit);
	            if (api) {
	                var v = search.allChildren(api);
	                this._knownIds = {};
	                v.forEach(function (x) { return _this._knownIds[x.id()] = x; });
	            }
	            return true;
	        }
	        return false;
	    };
	    ASTNodeImpl.prototype.insideOfDeclaration = function () {
	        if (this.definition().isDeclaration()) {
	            return true;
	        }
	        if (this.parent()) {
	            return this.parent().insideOfDeclaration();
	        }
	    };
	    ASTNodeImpl.prototype.isAllowedId = function () {
	        var r = this.root();
	        if (this.id() == "") {
	            return true;
	        }
	        if (r.definition().name() == "Extension") {
	            return true;
	        }
	        if (r.isAuxilary()) {
	            if (this.property().name() == "annotationTypes" && this.definition().name() == "AnnotationType") {
	                return true;
	            }
	            if (this.property().name() == "types" && this.definition().isAssignableFrom("DataElement")) {
	                return true;
	            }
	            if (this.insideOfDeclaration()) {
	                var vl = this.computedValue("decls");
	                if (vl == "true") {
	                    return true;
	                }
	            }
	            if (r._knownIds) {
	                var m = r._knownIds[this.id()] != null;
	                if (!m) {
	                    if (this.parent() && this.parent().parent()) {
	                        if (this.parent().isAllowedId()) {
	                            return true;
	                        }
	                    }
	                }
	                return m;
	            }
	            if (this.parent() && this.parent().parent()) {
	                if (this.parent().isAllowedId()) {
	                    return true;
	                }
	            }
	            return false;
	        }
	        return true;
	    };
	    ASTNodeImpl.prototype.printDetails = function (indent) {
	        var result = "";
	        if (!indent)
	            indent = "";
	        var classname = this.definition().name();
	        var definitionClasName = this.property() ? this.property().range().name() : "";
	        var parentPropertyName = this.property() ? this.property().name() : "";
	        result += indent + parentPropertyName + " : " + classname + "[" + definitionClasName + "]" + "\n";
	        this.children().forEach(function (child) {
	            result += child.printDetails(indent + "\t");
	        });
	        return result;
	    };
	    ASTNodeImpl.prototype.getExtractedChildren = function () {
	        var r = this.root();
	        if (r.isAuxilary()) {
	            if (r._knownIds) {
	                var i = r._knownIds[this.id()];
	                if (i) {
	                    return i.children();
	                }
	            }
	            return [];
	        }
	        return [];
	    };
	    ASTNodeImpl.prototype.allowsQuestion = function () {
	        return this._allowQuestion || this.definition().getAllowQuestion();
	    };
	    ASTNodeImpl.prototype.findReferences = function () {
	        var rs = [];
	        search.refFinder(this.root(), this, rs);
	        //filtering out equal results
	        var filteredReferences = [];
	        rs.forEach(function (ref) {
	            if (!_.find(filteredReferences, function (existing) { return existing == ref; })) {
	                filteredReferences.push(ref);
	            }
	        });
	        return filteredReferences;
	    };
	    ASTNodeImpl.prototype.name = function () {
	        var ka = _.find(this.directChildren(), function (x) { return x.property() && x.property().isKey(); });
	        if (ka && ka instanceof ASTPropImpl) {
	            var c = ka.value();
	            if (c) {
	                var io = c.indexOf(':');
	                if (io != -1) {
	                    return c.substring(0, io);
	                }
	            }
	            return c;
	        }
	        return _super.prototype.name.call(this);
	    };
	    ASTNodeImpl.prototype.findElementAtOffset = function (n) {
	        return this._findNode(this, n, n);
	    };
	    ASTNodeImpl.prototype.isElement = function () {
	        return true;
	    };
	    ASTNodeImpl.prototype.universe = function () {
	        if (this._universe) {
	            return this._universe;
	        }
	        return this.definition().universe();
	    };
	    ASTNodeImpl.prototype.setUniverse = function (u) {
	        this._universe = u;
	    };
	    ASTNodeImpl.prototype.validate = function (v) {
	        var _this = this;
	        if (!this.definition()) {
	            return; //FIXME
	        }
	        if (!this.parent()) {
	            var u = this.universe();
	            var tv = u.getTypedVersion();
	            if (tv) {
	                if (tv.indexOf("#%") == 0) {
	                    if (tv != "#%RAML 0.8" && tv != "#%RAML 1.0") {
	                        var i = createIssue(9 /* NODE_HAS_VALUE */, "Unknown version of RAML expected to see one of '#%RAML 0.8' or '#%RAML 1.0'", this);
	                        v.accept(i);
	                    }
	                    var tl = u.getTopLevel();
	                    if (tl) {
	                        if (tl != this.definition().name()) {
	                            var i = createIssue(9 /* NODE_HAS_VALUE */, "Unknown top level type:" + tl, this);
	                            v.accept(i);
	                        }
	                    }
	                }
	            }
	            if (this.definition().name() == "Api" && !this.definition().isUserDefined()) {
	                if (this.definition().universe().version() != "RAML08") {
	                    var owl = new ovlval.OverloadingValidator();
	                    owl.validateApi(this.wrapperNode(), v);
	                }
	            }
	            var r = this.lowLevel().unit();
	            this.lowLevel().visit(function (x) {
	                if (x.unit() != r) {
	                    return false;
	                }
	                if (x.value() && x._node && x._node.value) {
	                    if (x._node.value.doubleQuoted) {
	                        var ind = (x.value() + "").indexOf(":");
	                        var nl = (x.value() + "").indexOf("\n");
	                        if (ind != -1 && nl != -1 && (!x.includePath() || x.includePath().length == 0)) {
	                            var i = createIssue(9 /* NODE_HAS_VALUE */, "Suspicious double quoted multiline scalar, it is likely that you forgot closing \" " + x.value(), _this, true);
	                            i.start = x._node.value.startPosition;
	                            i.end = x._node.value.endPosition;
	                            if (i.start == i.end) {
	                                i.end++;
	                            }
	                            v.accept(i);
	                        }
	                    }
	                }
	                return true;
	            });
	            linter.lintNode(this, v);
	        }
	        if (!this.isAllowedId()) {
	            if ((!this.property()) || this.property().name() != "annotations") {
	                if (this.definition().name() != "GlobalSchema") {
	                    var i = createIssue(10 /* ONLY_OVERRIDE_ALLOWED */, "This node does not override any node from master api:" + this.id(), this);
	                    v.accept(i);
	                }
	            }
	        }
	        var nc = this.definition();
	        if (!this.definition().getAllowAny()) {
	            _super.prototype.validate.call(this, v);
	        }
	        else {
	            this.validateIncludes(v);
	        }
	        ;
	        if (nc instanceof def.NodeClass) {
	            var anc = nc;
	            if (nc.isAssignableFrom("DataElement")) {
	                //var tpes=anc.allSuperTypes();
	                var props = this.elementsOfKind("properties");
	                if (props.length > 0) {
	                    var types = this.attributes("type");
	                    types.forEach(function (t) {
	                        var tp = typeExpression.getType(_this, t.value(), {});
	                        if (tp instanceof def.NodeClass) {
	                            var xnc = tp;
	                            var rps = xnc.allRuntimeProperties();
	                            rps.forEach(function (rp) {
	                                var override = _.find(props, function (x) { return x.name() == rp.name(); });
	                                if (override) {
	                                    var node = _this;
	                                    var i = createIssue(10 /* ONLY_OVERRIDE_ALLOWED */, "overriding property " + override.name() + " inhertied from " + t.value(), override);
	                                    v.accept(i);
	                                }
	                            });
	                        }
	                    });
	                }
	                var faceted = this.elementsOfKind("facets");
	                if (faceted.length > 0) {
	                    var types = this.attributes("type");
	                    types.forEach(function (t) {
	                        var tp = typeExpression.getType(_this, t.value(), {});
	                        if (tp instanceof def.NodeClass) {
	                            var xnc = tp;
	                            var rps = xnc.allProperties();
	                            rps.forEach(function (rp) {
	                                var override = _.find(faceted, function (x) { return x.name() == rp.name(); });
	                                if (override) {
	                                    var node = _this;
	                                    var i = createIssue(10 /* ONLY_OVERRIDE_ALLOWED */, "overriding facet " + override.name() + " inhertied from " + t.value(), override);
	                                    v.accept(i);
	                                }
	                            });
	                        }
	                    });
	                }
	            }
	            if (anc.isRuntime()) {
	                var facets = anc.getFixedFacets();
	                for (var fk in facets) {
	                    var facet = anc.getRepresentationOf().facet(fk);
	                    if (facet) {
	                        var fv = facet.getFacetValidator();
	                        if (fv) {
	                            var obj = this.lowLevel().dumpToObject();
	                            obj = obj[this.lowLevel().key()];
	                            try {
	                                var message = fv(obj, facets[fk]);
	                                if (typeof message == 'string') {
	                                    var i = createIssue(7 /* INVALID_VALUE_SCHEMA */, "" + message, this);
	                                    v.accept(i);
	                                }
	                            }
	                            catch (e) {
	                                var i = createIssue(7 /* INVALID_VALUE_SCHEMA */, e.message, this);
	                                v.accept(i);
	                            }
	                        }
	                    }
	                }
	            }
	        }
	        checkPropertyQuard(this, v);
	        if (typeof this.value() == 'string' && !this.definition().allowValue()) {
	            if (this.parent()) {
	                var i = createIssue(9 /* NODE_HAS_VALUE */, "node " + this.name() + " can not be a scalar", this);
	                v.accept(i);
	            }
	        }
	        this.definition().requiredProperties().forEach(function (x) {
	            var r = x.range();
	            if (r instanceof def.Array) {
	                var ar = r;
	                r = ar.component;
	            }
	            if (r.isValueType()) {
	                var nm = _this.attr(x.name());
	                if (!nm) {
	                    var i = createIssue(3 /* MISSING_REQUIRED_PROPERTY */, "Missing required property " + x.name(), _this);
	                    v.accept(i);
	                }
	            }
	            else {
	                var el = _this.elementsOfKind(x.name());
	                if (!el || el.length == 0) {
	                    var i = createIssue(3 /* MISSING_REQUIRED_PROPERTY */, "Missing required property " + x.name(), _this);
	                    v.accept(i);
	                }
	            }
	        });
	        this.definition().getContextRequirements().forEach(function (x) {
	            if (!_this.checkContextValue(x.name, x.value, _this.toRuntimeModel())) {
	                v.accept(createIssue(8 /* MISSED_CONTEXT_REQUIREMENT */, x.name + " should be " + x.value + " to use type " + _this.definition().name(), _this));
	            }
	        });
	        if (this.definition().universe().version() == "RAML08") {
	            var m = {};
	            var els = this.directChildren().filter(function (x) { return x.isElement(); });
	            els.forEach(function (x) {
	                if (x["_computed"]) {
	                    return;
	                }
	                if (!x.name()) {
	                    return; //handling nodes with no key (documentation)
	                }
	                var rm = x.lowLevel().parent() ? x.lowLevel().parent().end() : "";
	                var k = x.name() + rm;
	                if (m[k]) {
	                    var i = createIssue(5 /* KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT */, x.name() + " already exists in this context", x);
	                    v.accept(i);
	                }
	                else {
	                    m[k] = 1;
	                }
	            });
	        }
	        else {
	            var m = {};
	            var els = this.directChildren().filter(function (x) { return x.isElement(); });
	            els.forEach(function (x) {
	                if (x["_computed"]) {
	                    return;
	                }
	                if (!x.name()) {
	                    return; //handling nodes with no key (documentation)
	                }
	                if (allowOwerride[x.property().name()]) {
	                    return;
	                }
	                var k = x.name() + x.property().name();
	                if (m[k]) {
	                    var i = createIssue(5 /* KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT */, x.name() + " already exists in this context", x);
	                    v.accept(i);
	                }
	                else {
	                    m[k] = 1;
	                }
	            });
	        }
	        var allLowlevel = this.lowLevel().children();
	        var mm = _.groupBy(allLowlevel, function (x) { return x.key(); });
	        var pr = this.directChildren().filter(function (x) { return x.isAttr(); });
	        var gr = _.groupBy(pr, function (x) { return x.name(); });
	        var all = this.directChildren();
	        var allG = _.groupBy(all, function (x) { return x.name(); });
	        var computedAnnotationsMultiplValues = false;
	        Object.keys(mm).forEach(function (x) {
	            if (x.charAt(0) == '(') {
	                if (mm[x].length > 1) {
	                    if (!computedAnnotationsMultiplValues) {
	                        computedAnnotationsMultiplValues = true;
	                        pr.forEach(function (z) {
	                            if (z.property().isAnnotation()) {
	                                var annotationRange = z.property().range();
	                                var attr = z;
	                                var refsTo = attr.findReferenceDeclaration();
	                                if (refsTo != null) {
	                                    var refNode = refsTo;
	                                    var multiple = refNode.attr("allowMultiple");
	                                    if (multiple) {
	                                        var mv = multiple.value();
	                                        if (mv == 'true') {
	                                            delete mm[attr.lowLevel().key()];
	                                        }
	                                    }
	                                }
	                            }
	                        });
	                    }
	                }
	            }
	        });
	        Object.keys(mm).forEach(function (x) {
	            if (x) {
	                if (mm[x].length > 1 && !allG[x]) {
	                    var i = createIssue(4 /* PROPERTY_EXPECT_TO_HAVE_SINGLE_VALUE */, x + " should have a single value", _this);
	                    i.start = mm[x][0].keyStart();
	                    i.end = mm[x][0].keyEnd();
	                    v.accept(i);
	                }
	            }
	        });
	        Object.keys(gr).forEach(function (x) {
	            if (gr[x].length > 1 && !gr[x][0].property().isMultiValue()) {
	                gr[x].forEach(function (y) {
	                    var i = createIssue(4 /* PROPERTY_EXPECT_TO_HAVE_SINGLE_VALUE */, y.property().name() + " should have a single value", y);
	                    v.accept(i);
	                });
	            }
	        });
	        if (this._def && this.property() && this.property().name() == "types") {
	            if (buildIns[this.name()]) {
	                var i = createIssue(7 /* INVALID_VALUE_SCHEMA */, "You can not redeclare build in types", this);
	                v.accept(i);
	            }
	            var at = this.attributes("type");
	            if (at) {
	                var fn = false;
	                at.forEach(function (x) {
	                    if (x.value() == _this.name()) {
	                        var i = createIssue(7 /* INVALID_VALUE_SCHEMA */, "Recurrent type definition", _this.attr("type") ? _this.attr("type") : _this);
	                        v.accept(i);
	                        fn = true;
	                        return;
	                    }
	                });
	                if (fn) {
	                    return;
	                }
	            }
	            try {
	                this.traverseDec(this._def, v, 0);
	            }
	            catch (e) {
	            }
	            if (!this._associatedDef) {
	                if (_.find(this.definition().allSuperTypes(), function (x) { return x.name() == "DataElement"; })) {
	                    this._associatedDef = typeBuilder.typeFromNode(this);
	                }
	            }
	            if (this._associatedDef) {
	                var st = this._associatedDef.superTypes();
	                var nameMap = {};
	                st.forEach(function (x) {
	                    nameMap[x.name()] = x;
	                });
	                var newSt = [];
	                for (var nm in nameMap) {
	                    newSt.push(nameMap[nm]);
	                }
	                st = newSt;
	                if (st.length > 1) {
	                    if (_.find(st, function (x) { return _this.isPrimitive(x); })) {
	                        if (_.find(st, function (x) { return _this.isObject(x); })) {
	                            var i = createIssue(7 /* INVALID_VALUE_SCHEMA */, "You can not inherit both from types of different kind", this.attr("type") ? this.attr("type") : this);
	                            v.accept(i);
	                            return;
	                        }
	                    }
	                    if (_.find(st, function (x) { return _this.isArray(x); })) {
	                        if (_.find(st, function (x) { return !_this.isArray(x); })) {
	                            var i = createIssue(7 /* INVALID_VALUE_SCHEMA */, "You can not inherit both from types of different kind", this.attr("type") ? this.attr("type") : this);
	                            v.accept(i);
	                            return;
	                        }
	                    }
	                    if (_.filter(st, function (x) { return _this.isPrimitive(x); }).length > 1) {
	                        var i = createIssue(7 /* INVALID_VALUE_SCHEMA */, "You can not inherit from two primitive types", this.attr("type") ? this.attr("type") : this);
	                        v.accept(i);
	                        return;
	                    }
	                }
	            }
	        }
	    };
	    ASTNodeImpl.prototype.isPrimitive = function (q) {
	        return !this.isArray(q) && !this.isObject(q) && !this.isUnion(q) && q.name() != "DataElement";
	    };
	    ASTNodeImpl.prototype.isObject = function (q) {
	        return q.name() == "ObjectField" || _.find(q.allSuperTypes(), function (x) { return x.name() == 'ObjectField'; }) != null;
	    };
	    ASTNodeImpl.prototype.isArray = function (q) {
	        return _.find(q.allSuperTypes(), function (x) { return x instanceof defs.Array; }) != null;
	    };
	    ASTNodeImpl.prototype.isUnion = function (q) {
	        return _.find(q.allSuperTypes(), function (x) { return x instanceof defs.Union; }) != null;
	    };
	    /**
	     * !!!You cannot inherit from types of different kind at the same moment ( kinds are: union types, array types, object types, scalar types )
	     * !!!You cannot inherit from types extending union types ( ex: you cannot extend from Pet if Pet = Dog | Cat )
	     * You cannot inherit from multiple primitive types
	     * !!! You cannot inherit from a type that extends Array type
	     * Facets are always inherited
	     * You can fix a previously defined facet to a value if the facet is defined on a superclass
	     * Properties are only allowed on object types
	     * You cannot create cyclic dependencies when inheriting
	     * @param d
	     * @param v
	     * @param level
	     * @param visited
	     */
	    ASTNodeImpl.prototype.traverseDec = function (d, v, level, visited) {
	        var _this = this;
	        if (visited === void 0) { visited = {}; }
	        if (d == null) {
	            return;
	        }
	        if (d instanceof def.Array && level > 0) {
	            var i = createIssue(7 /* INVALID_VALUE_SCHEMA */, "Extending from types extending array types is not allowed", this.attr("type") ? this.attr("type") : this);
	            v.accept(i);
	            return;
	        }
	        if (d instanceof def.Union && level > 0) {
	            var i = createIssue(7 /* INVALID_VALUE_SCHEMA */, "Extending from types extending union types is not allowed", this.attr("type") ? this.attr("type") : this);
	            v.accept(i);
	            return;
	        }
	        if (visited[d.name()]) {
	            var i = createIssue(7 /* INVALID_VALUE_SCHEMA */, "Recurrent type definition", this.attr("type") ? this.attr("type") : this);
	            v.accept(i);
	            throw new Error();
	        }
	        visited[d.name()] = this.definition();
	        try {
	            if (d.name() == this.name() && level > 0) {
	                var i = createIssue(7 /* INVALID_VALUE_SCHEMA */, "Recurrent type definition", this.attr("type") ? this.attr("type") : this);
	                v.accept(i);
	                throw new Error();
	            }
	            if (d instanceof defs.Array) {
	                this.traverseDec(d.component, v, level + 1, visited);
	                return;
	            }
	            if (d instanceof defs.Union) {
	                var lleft = level + 1;
	                var lright = level + 1;
	                var union = d;
	                if (d.left instanceof defs.Union) {
	                    var ul = d.left;
	                    if (union.getDeclaringNode() == ul.getDeclaringNode()) {
	                        lleft = level;
	                    }
	                }
	                if (d.right instanceof defs.Union) {
	                    var ul = d.right;
	                    if (union.getDeclaringNode() == ul.getDeclaringNode()) {
	                        lright = level;
	                    }
	                }
	                if (lleft == level + 1) {
	                    this.traverseDec(d.left, v, lleft, visited);
	                }
	                if (lright == level + 1) {
	                    this.traverseDec(d.right, v, lright, visited);
	                }
	                return;
	            }
	            var mn = d.allSuperTypes();
	            mn.forEach(function (yy) {
	                if (yy instanceof defs.AbstractType) {
	                    var node = yy.getDeclaringNode();
	                    if (node || yy instanceof defs.Array || yy instanceof defs.Union) {
	                        _this.traverseDec(yy, v, level + 1, visited);
	                    }
	                }
	            });
	        }
	        finally {
	            delete visited[d.name()];
	        }
	    };
	    ASTNodeImpl.prototype._findNode = function (n, offset, end) {
	        var _this = this;
	        if (n == null) {
	            return null;
	        }
	        if (n.lowLevel()) {
	            //var node:ASTNode=<ASTNode>n;
	            if (n.lowLevel().start() <= offset && n.lowLevel().end() >= end) {
	                var res = n;
	                //TODO INCLUDES
	                n.elements().forEach(function (x) {
	                    if (x.lowLevel().unit() != n.lowLevel().unit()) {
	                        return;
	                    }
	                    var m = _this._findNode(x, offset, end);
	                    if (m) {
	                        res = m;
	                    }
	                });
	                return res;
	            }
	        }
	        return null;
	    };
	    ASTNodeImpl.prototype.isStub = function () {
	        return (!this.lowLevel().unit()) || this.lowLevel().unit().isStubUnit();
	    };
	    ASTNodeImpl.prototype.findInsertionPointLowLevel = function (llnode, property, attr) {
	        //console.log('LL find insertion: node is attr: ' + attr);
	        //always insert attributes at start
	        var llchilds = this.lowLevel().children();
	        var insertionPoint = null;
	        var embed = property && property.isEmbedMap();
	        if (embed && _.find(this.lowLevel().children(), function (x) { return x.key() == property.name(); })) {
	            embed = false;
	        }
	        if (attr || embed) {
	            //var index = this.findLastAttribute();
	            var last = this.findLastAttribute();
	            //console.log('last: ' + last);
	            //for (var i = 0; i < llchilds.length; i++) {
	            //    var ll = <jsyaml.ASTNode>llchilds[i];
	            //    ll.show('child:');
	            //    if(ll.isMapping())
	            //if (!ch[i].isAttr()){
	            //    break;
	            //} else{
	            //    insertionPoint=ch[i].lowLevel();
	            //}
	            //}
	            if (!last) {
	                //insertionPoint = new jsyaml.InsertionPoint(jsyaml.InsertionPointType.START);
	                insertionPoint = jsyaml.InsertionPoint.atStart();
	            }
	            else {
	                insertionPoint = last;
	            }
	        }
	        return insertionPoint;
	    };
	    ASTNodeImpl.prototype.findInsertionPoint = function (node) {
	        //console.log('node: ' + node.property().name());
	        //console.log('HL: find isertion: node is attr: ' + node.isAttr());
	        //console.log('node1: ' + node.lowLevel().text());
	        //always insert attributes at start
	        if (!this.isStub()) {
	            this.clearChildrenCache();
	        }
	        var ch = this.children();
	        var toRet = null;
	        var embed = node.property() && node.property().isEmbedMap();
	        if (embed && _.find(this.lowLevel().children(), function (x) { return x.key() == node.property().name(); })) {
	            embed = false;
	        }
	        //console.log('node2: ' + node.lowLevel().text());
	        if (node.isAttr() || embed) {
	            for (var i = 0; i < ch.length; i++) {
	                if (!ch[i].isAttr()) {
	                    break;
	                }
	                else {
	                    toRet = ch[i].lowLevel();
	                }
	            }
	            if (toRet == null) {
	                toRet = this.lowLevel();
	            }
	        }
	        //console.log('HL insertion: ' + toRet);
	        return toRet;
	    };
	    ASTNodeImpl.prototype.add = function (node) {
	        if (!this.isStub() && this.isEmptyRamlFile()) {
	            this.initRamlFile();
	        }
	        var llnode = node.lowLevel();
	        if (!this._children) {
	            this._children = [];
	        }
	        if (!node.property()) {
	            //now we should find correct property;
	            var an = node;
	            var allProps = this.definition().allProperties();
	            var cp = null;
	            allProps.forEach(function (x) {
	                var r = x.range();
	                if (r == an.definition()) {
	                    cp = x;
	                }
	                var isOk = _.find(an.definition().allSuperTypes(), function (x) { return x == r; });
	                if (isOk) {
	                    cp = x;
	                }
	            });
	            if (!cp) {
	                throw new Error("Unable to find correct child");
	            }
	            else {
	                an._prop = cp;
	            }
	        }
	        var insertionPoint = this.findInsertionPoint(node);
	        //console.log('high level op: ' + this.property() + '.add ' + node.property().name());
	        if (insertionPoint) {
	        }
	        //var newLowLevel:ll.ILowLevelASTNode=null;
	        var command = new ll.CompositeCommand();
	        //now we need to understand to which low level node it should go
	        //command.commands.push(ll.insertNode(this.lowLevel(), node.lowLevel()))
	        var insertionTarget = null;
	        if (node.property().isMerged() || node.property().range().isValueType()) {
	            //console.log('CASE 1');
	            //newLowLevel = node.lowLevel();
	            command.commands.push(ll.insertNode(this.lowLevel(), node.lowLevel(), insertionPoint));
	            insertionTarget = this.lowLevel();
	        }
	        else {
	            //console.log('CASE 2');
	            var name = node.property().name();
	            var target = this.lowLevel();
	            //target.show('TARGET:');
	            //llnode.show('NODE:');
	            var found = this.lowLevel().find(name);
	            insertionTarget = found;
	            if (!found) {
	                //console.log('node not found');
	                var nn = null;
	                //var nn: jsyaml.ASTNode = jsyaml.createSeqNode(name);
	                //var mapping = <yaml.YAMLMapping>nn._actualNode();
	                //var seq: yaml.YAMLSequence = <yaml.YAMLSequence>mapping.value;
	                //if(!seq.items) seq.items = [];
	                //seq.items.push((<jsyaml.ASTNode>node.lowLevel())._actualNode());
	                if (node.property().isEmbedMap()) {
	                    var v10 = this.definition().universe().version() == 'RAML10';
	                    if (llnode.isValueMap() && v10)
	                        nn = jsyaml.createMapNode(name);
	                    else
	                        nn = jsyaml.createSeqNode(name);
	                    //console.log('NN: ' + yaml.Kind[nn._actualNode().kind]);
	                    nn.addChild(node.lowLevel());
	                }
	                else {
	                    nn = jsyaml.createNode(name);
	                    nn.addChild(node.lowLevel());
	                }
	                //nn.show('WRAPPED NODE:');
	                //target.show('INSERT WRAPPED NODE TO:');
	                command.commands.push(ll.insertNode(target, nn, insertionPoint));
	                insertionTarget = target;
	            }
	            else {
	                //console.log('node found');
	                //found.show('INSERT2: ');
	                if (node.property().isEmbedMap()) {
	                    //newLowLevel=node.lowLevel();
	                    command.commands.push(ll.insertNode(found, node.lowLevel(), insertionPoint, true));
	                }
	                else {
	                    //newLowLevel=node.lowLevel();
	                    command.commands.push(ll.insertNode(found, node.lowLevel(), insertionPoint, false));
	                }
	            }
	        }
	        if (this.isStub()) {
	            var insertionIndex = this.findLastAttributeIndex();
	            if (insertionIndex < 0) {
	                this._children.push(node);
	            }
	            else {
	                //TODO behavior should be smarter we are ignoring insertion points now
	                this._children.splice(insertionIndex, 0, node);
	            }
	            command.commands.forEach(function (x) { return insertionTarget.addChild(x.value); });
	            return;
	        }
	        this.lowLevel().execute(command);
	        this._children.push(node);
	        //now we need to add new child to our children;
	        node.setParent(this);
	    };
	    ASTNodeImpl.prototype.remove = function (node) {
	        if (this.isStub()) {
	            if (node instanceof ASTNodeImpl) {
	                var cm = node;
	                if (cm.isInEdit) {
	                    return;
	                }
	            }
	            if (!this._children) {
	                return;
	            }
	            this._children = this._children.filter(function (x) { return x != node; });
	            return;
	        }
	        var command = new ll.CompositeCommand();
	        if (node instanceof ASTNodeImpl) {
	            var aNode = node;
	            if (!aNode.property().isMerged()) {
	                if (this.elementsOfKind(aNode.property().name()).length == 1) {
	                    command.commands.push(ll.removeNode(this.lowLevel(), aNode.lowLevel().parent().parent()));
	                }
	                else {
	                    command.commands.push(ll.removeNode(this.lowLevel(), aNode.lowLevel()));
	                }
	            }
	            else {
	                command.commands.push(ll.removeNode(this.lowLevel(), aNode.lowLevel()));
	            }
	        }
	        else {
	            command.commands.push(ll.removeNode(this.lowLevel(), node.lowLevel()));
	        }
	        this.lowLevel().execute(command);
	        //update high level
	        this._children = this._children.filter(function (x) { return x != node; });
	    };
	    ASTNodeImpl.prototype.dump = function (flavor) {
	        return this._node.dump();
	    };
	    ASTNodeImpl.prototype.patchType = function (d) {
	        this._def = d;
	        var ass = this._associatedDef;
	        this._associatedDef = null;
	        this._children = null;
	    };
	    ASTNodeImpl.prototype.children = function () {
	        if (this._children) {
	            var extra = this.getExtractedChildren();
	            var res = this._children.concat(extra);
	            return res;
	        }
	        if (this._node) {
	            this._children = nodeBuilder.process(this, this._node.children());
	            this._children = this._children.filter(function (x) { return x != null; });
	            //FIXME
	            var extra = this.getExtractedChildren();
	            var res = this._children.concat(extra);
	            return res;
	        }
	        return [];
	    };
	    ASTNodeImpl.prototype.directChildren = function () {
	        if (this._children) {
	            return this._children;
	        }
	        if (this._node) {
	            this._children = nodeBuilder.process(this, this._node.children());
	            return this._children;
	        }
	        return [];
	    };
	    ASTNodeImpl.prototype.resetChildren = function () {
	        this._children = null;
	    };
	    //createAttr(n:string,v:string){
	    //    var mapping=jsyaml.createMapping(n,v);
	    //    this._node.addChild(mapping);
	    //    this._children=null;
	    //}
	    ASTNodeImpl.prototype.findLastAttributeIndex = function () {
	        var last = -1;
	        var childs = this.lowLevel().children();
	        for (var i = 0; i < childs.length; i++) {
	            var node = childs[i];
	            if (!node.isMapping())
	                continue;
	            var name = node.asMapping().key.value;
	            var property = this.definition().property(name);
	            if (!property)
	                continue;
	            //console.log(property.name() + ': isval: ' + property.isValue() + '; multi: ' + property.isMultiValue() + '; range val: ' + property.range().isValueType());
	            //if((property.isValue() || /*property.isMultiValue()) ||*/ property.range().isValueType()) {
	            if (property.isValue() || property.range().isValueType()) {
	                last = i;
	            }
	        }
	        //console.log('last attr index1: ' + last);
	        return last;
	    };
	    ASTNodeImpl.prototype.findLastAttribute = function () {
	        var childs = this.lowLevel().children();
	        var index = this.findLastAttributeIndex();
	        //console.log('last attr index2: ' + index);
	        return (index < 0) ? null : childs[index];
	    };
	    ASTNodeImpl.prototype.isEmptyRamlFile = function () {
	        var llroot = this.lowLevel().root();
	        return llroot.isScalar();
	    };
	    ASTNodeImpl.prototype.initRamlFile = function () {
	        var llroot = this.lowLevel().root();
	        var command = new ll.CompositeCommand();
	        var newroot = jsyaml.createMap([]);
	        command.commands.push(ll.initRamlFile(this.lowLevel(), newroot));
	        this.lowLevel().execute(command);
	        var root = this.root();
	        //console.log('root: ' + root);
	        root._node = newroot;
	        root.clearChildrenCache();
	        //root.lowLevel().show('NEW ROOT:');
	    };
	    ASTNodeImpl.prototype.createAttr = function (n, v) {
	        var mapping = jsyaml.createMapping(n, v);
	        //console.log('create attribute: ' + n);
	        if (this.isStub()) {
	            //console.log('create-attr: stub case');
	            var insertionIndex = this.findLastAttributeIndex();
	            //console.log('stub insertion index: ' + insertionIndex);
	            this._node.addChild(mapping, insertionIndex + 1);
	        }
	        else {
	            //console.log('root: ' + llroot.kindName());
	            if (this.isEmptyRamlFile()) {
	                this.initRamlFile();
	            }
	            //console.log('create-attr: real node case');
	            //this._node.addChild(mapping);
	            //this.clearChildrenCache();
	            var command = new ll.CompositeCommand();
	            var insertionPoint = this.findInsertionPointLowLevel(mapping, this.definition().property(n), true);
	            //command.commands.push(ll.insertNode(this.lowLevel(), mapping, null));
	            //var toseq = this.property().isMultiValue();
	            command.commands.push(ll.insertNode(this.lowLevel(), mapping, insertionPoint));
	            this.lowLevel().execute(command);
	        }
	        this.clearChildrenCache();
	    };
	    ASTNodeImpl.prototype.isAttr = function () {
	        return false;
	    };
	    ASTNodeImpl.prototype.isUnknown = function () {
	        return false;
	    };
	    ASTNodeImpl.prototype.value = function () {
	        return this._node.value();
	    };
	    ASTNodeImpl.prototype.valuesOf = function (propName) {
	        var pr = this._def.property(propName);
	        if (pr != null) {
	            return this.elements().filter(function (x) { return x.property() == pr; });
	        }
	        return [];
	    };
	    ASTNodeImpl.prototype.attr = function (n) {
	        return _.find(this.attrs(), function (y) { return y.name() == n; });
	    };
	    ASTNodeImpl.prototype.attrOrCreate = function (name) {
	        var a = this.attr(name);
	        if (!a)
	            this.createAttr(name, '');
	        return this.attr(name);
	    };
	    ASTNodeImpl.prototype.attrValue = function (n) {
	        var a = this.attr(n);
	        return a ? a.value() : null;
	    };
	    ASTNodeImpl.prototype.attributes = function (n) {
	        return _.filter(this.attrs(), function (y) { return y.name() == n; });
	    };
	    ASTNodeImpl.prototype.attrs = function () {
	        return this.children().filter(function (x) { return x.isAttr(); });
	    };
	    /*
	    allAttrs():hl.IAttribute[]{
	        var attrs = <hl.IAttribute[]>this.children().filter(x=>x.isAttr());
	        var attributes = [];
	        //console.log('Attributes(' + this.definition().name() + '): ');
	        (<NodeClass>this.definition()).allProperties().forEach(x=>{
	            if(x.range().isValueType()&&!x.isSystem()){
	                var a = _.find(attrs,y=>y.name()==x.name());
	                //var a = this.attr(x.name());
	                if (a){
	                    //console.log('  real   : ' + x.name() + ' = ' + a.value());
	                    attributes.push(a);
	                } else {
	                    a = new VirtualAttribute(this, this.definition(), x, false);
	                    //console.log('  virtual: ' + x.name());
	                    attributes.push(a);
	                }
	            }
	        })
	        return attributes;
	    }
	    */
	    ASTNodeImpl.prototype.elements = function () {
	        return this.children().filter(function (x) { return !x.isAttr() && !x.isUnknown(); });
	    };
	    ASTNodeImpl.prototype.element = function (n) {
	        var r = this.elementsOfKind(n);
	        if (r.length > 0) {
	            return r[0];
	        }
	        return null;
	    };
	    ASTNodeImpl.prototype.elementsOfKind = function (n) {
	        var r = this.elements().filter(function (x) { return x.property().name() == n; });
	        return r;
	    };
	    ASTNodeImpl.prototype.definition = function () {
	        return this._def;
	    };
	    ASTNodeImpl.prototype.property = function () {
	        return this._prop;
	    };
	    ASTNodeImpl.prototype.isExpanded = function () {
	        return this._expanded;
	    };
	    ASTNodeImpl.prototype.copy = function () {
	        return new ASTNodeImpl(this.lowLevel().copy(), this.parent(), this.definition(), this.property());
	    };
	    ASTNodeImpl.prototype.clearChildrenCache = function () {
	        this._children = null;
	    };
	    return ASTNodeImpl;
	})(BasicASTNode);
	exports.ASTNodeImpl = ASTNodeImpl;
	function typeFromNode(node) {
	    return typeBuilder.typeFromNode(node);
	}
	exports.typeFromNode = typeFromNode;
	function createStub0(parent, property, key) {
	    var p = parent.definition().property(property);
	    if (!p)
	        return null;
	    var nc = p.range();
	    var node = nc.createStubNode(p, key);
	    return node;
	}
	exports.createStub0 = createStub0;
	function createStub(parent, property, key) {
	    var p = parent.definition().property(property);
	    if (!p)
	        return null;
	    var nc = p.range();
	    var node = nc.createStubNode(p, key);
	    node.isInEdit = true;
	    var su = parent.lowLevel().unit().stub();
	    node.lowLevel()._unit = su;
	    node._parent = parent.copy();
	    node._parent.lowLevel()._unit = su;
	    return node;
	}
	exports.createStub = createStub;
	function createResourceStub(parent, key) {
	    return createStub(parent, "resources", key);
	}
	exports.createResourceStub = createResourceStub;
	function createMethodStub(parent, key) {
	    return createStub(parent, 'methods', key);
	}
	exports.createMethodStub = createMethodStub;
	function createResponseStub(parent, key) {
	    return createStub(parent, 'responses', key);
	}
	exports.createResponseStub = createResponseStub;
	function createBodyStub(parent, key) {
	    return createStub(parent, 'body', key);
	}
	exports.createBodyStub = createBodyStub;
	function createUriParameterStub(parent, key) {
	    return createStub(parent, 'uriParameters', key);
	}
	exports.createUriParameterStub = createUriParameterStub;
	function createQueryParameterStub(parent, key) {
	    return createStub(parent, 'queryParameters', key);
	}
	exports.createQueryParameterStub = createQueryParameterStub;
	function createObjectFieldStub(parent, name) {
	    var type = parent.definition().universe().getType('ObjectField');
	    //var property = def.prop('types', 'xxx', <def.NodeClass>parent.definition(), type);
	    var property = parent.definition().property('types');
	    property = property.withRange(type);
	    console.log('property: ' + property.name());
	    var nc = property.range();
	    return nc.createStubNode(property, name);
	}
	exports.createObjectFieldStub = createObjectFieldStub;
	var allowOwerride = { resources: 1, queryParameters: 1, headers: 1, body: 1, methods: 1, responses: 1 };
	var buildIns = {
	    string: 1,
	    date: 1,
	    boolean: 1,
	    number: 1,
	    integer: 1,
	    object: 1,
	    array: 1,
	    union: 1,
	    file: 1,
	    value: 1,
	    any: 1,
	    scalar: 1
	};
	//# sourceMappingURL=highLevelImpl.js.map

/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../../typings/tsd.d.ts" />
	var def = __webpack_require__(21);
	var td = __webpack_require__(22);
	var tsutil = __webpack_require__(23);
	var path = __webpack_require__(11);
	var mkdirp = __webpack_require__(40);
	var fs = __webpack_require__(12);
	var wrappedParserGen = __webpack_require__(24);
	var ParserGenerator = (function () {
	    function ParserGenerator(cfg, universe) {
	        this.cfg = cfg;
	        this.universe = universe;
	        this.mod = new td.TSAPIModule();
	        this.processed = {};
	        this.typeMap = {
	            'StringType': 'string',
	            'NumberType': 'number',
	            'BooleanType': 'boolean'
	        };
	    }
	    ParserGenerator.prototype.processEnum = function (u) {
	        var _this = this;
	        var typeName = u.name();
	        u.superTypes().forEach(function (x) { return _this.processType(x); });
	        var dcl = new td.TSEnumDecl(this.mod, typeName);
	        dcl.enumConstants = u.values;
	        var typePath = path.basename(u['_path']);
	        typePath = typePath.substring(0, typePath.lastIndexOf('.'));
	        dcl.meta['$$pkg'] = typePath;
	        u.subTypes().forEach(function (x) { return _this.processType(x); });
	    };
	    ParserGenerator.prototype.processType = function (u) {
	        var _this = this;
	        var typeName = u.name();
	        if (this.processed[typeName]) {
	            return;
	        }
	        this.processed[typeName] = u;
	        if (u instanceof def.EnumType) {
	            this.processEnum(u);
	            return;
	        }
	        u.superTypes().forEach(function (x) { return _this.processType(x); });
	        var idcl = new td.TSInterface(this.mod, typeName);
	        var dcl = new td.TSClassDecl(this.mod, typeName + "Impl");
	        var typePath = path.basename(u['_path']);
	        typePath = typePath.substring(0, typePath.lastIndexOf('.'));
	        idcl.meta['$$pkg'] = typePath;
	        dcl.meta['$$pkg'] = typePath;
	        dcl.implements.push(new td.TSSimpleTypeReference(td.Universe, idcl.name));
	        if (typeName == 'ValueType') {
	            idcl.meta['$$isValueType'] = true;
	            dcl.meta['$$isValueType'] = true;
	            var iMethod = new td.TSAPIElementDeclaration(idcl, 'value');
	            iMethod.isFunc = true;
	            iMethod.rangeType = new td.TSSimpleTypeReference(method, 'string');
	            var method = new td.TSAPIElementDeclaration(dcl, 'value');
	            method.rangeType = new td.TSSimpleTypeReference(method, 'string');
	            method.isFunc = true;
	            method._body = 'return super.attributeValue();';
	            method.meta['property'] = 'value';
	        }
	        if (typeName == 'Reference') {
	            idcl.meta['$$isValueType'] = true;
	            dcl.meta['$$isValueType'] = true;
	            var iMethod = new td.TSAPIElementDeclaration(idcl, 'value');
	            iMethod.isFunc = true;
	            iMethod.rangeType = new td.TSSimpleTypeReference(method, customTypeSuperclass);
	            var method = new td.TSAPIElementDeclaration(dcl, 'value');
	            method.rangeType = new td.TSSimpleTypeReference(method, customTypeSuperclass);
	            method.isFunc = true;
	            method._body = 'return super.customClassValue();';
	            dcl.meta['$$noSuper'] = true;
	            idcl.meta['$$noSuper'] = true;
	            method.meta['property'] = 'value';
	        }
	        else {
	            var map = {};
	            u.superTypes().filter(function (x) {
	                if (map[x.name()]) {
	                    return false;
	                }
	                map[x.name()] = true;
	                return true;
	            }).forEach(function (x) {
	                idcl.extends.push(new td.TSSimpleTypeReference(td.Universe, x.name()));
	                dcl.extends.push(new td.TSSimpleTypeReference(td.Universe, x.name() + "Impl"));
	            });
	            map = {};
	            u.properties().filter(function (x) {
	                if (map[x.name()]) {
	                    return false;
	                }
	                map[x.name()] = true;
	                return true;
	            }).forEach(function (x) {
	                _this.createMethodDecl(idcl, x);
	                var z = _this.createMethodDecl(dcl, x);
	                z._body = _this.generateBody(x, z);
	            });
	            if (dcl.extends.length == 0 && !u.isValueType()) {
	            }
	        }
	        u.subTypes().forEach(function (x) { return _this.processType(x); });
	        //if(this.cfg.raml08compatible){
	        //    this.handleRaml08Comapatibility(u,idcl,dcl);
	        //}
	    };
	    ParserGenerator.prototype.handleRaml08Comapatibility = function (u, idcl, dcl) {
	        if (u.name() == 'ObjectField') {
	            var deType = this.universe.getType('DataElement');
	            var prop = def.prop('formParameters', 'return form parameters', deType, deType).withMultiValue(true);
	            this.createMethodDecl(idcl, prop);
	            var z = this.createMethodDecl(dcl, prop);
	            z._body = this.generateBody(prop, z, 'properties');
	        }
	    };
	    ParserGenerator.prototype.generateBody = function (x, method, propName) {
	        var isEnum = this.processed[x.range().name()] instanceof def.EnumType;
	        var resolvedType = resolveArray(method.rangeType, !isEnum);
	        if (!propName) {
	            propName = x.name();
	        }
	        if (x.isValueProperty()) {
	            if (x.isMultiValue()) {
	                return "return super.getAttributes(\"" + propName + "\", " + resolvedType + ".class);";
	            }
	            else {
	                return "return super.getAttribute(\"" + propName + "\", " + resolvedType + ".class);";
	            }
	        }
	        else {
	            if (x.isMultiValue()) {
	                return "return super.getElements(\"" + propName + "\", " + resolvedType + ".class);";
	            }
	            else {
	                return "return super.getElement(\"" + propName + "\", " + resolvedType + ".class);";
	            }
	        }
	    };
	    ParserGenerator.prototype.createMethodDecl = function (dcl, x) {
	        var method = new td.TSAPIElementDeclaration(dcl, x.name());
	        method.meta['property'] = x.name();
	        method.isFunc = true;
	        var tname = "string";
	        if (x.isPrimitive()) {
	            tname = this.typeMap[x.range().name()];
	        }
	        else {
	            tname = x.range().name();
	            this.processType(x.range());
	        }
	        var iOpt = this.mod.getInterface(tname);
	        var ref = iOpt.isDefined() ? iOpt.getOrThrow().toReference() : new td.TSSimpleTypeReference(td.Universe, tname);
	        if (x.isMultiValue()) {
	            var aRef = new td.TSArrayReference();
	            aRef.componentType = ref;
	            method.rangeType = aRef;
	        }
	        else {
	            method.rangeType = ref;
	        }
	        return method;
	    };
	    return ParserGenerator;
	})();
	function def2Parser(u, cfg, universe) {
	    var generator = new ParserGenerator(cfg, universe);
	    generator.processType(u);
	    new Serializer(generator.mod, cfg).serializeAll();
	}
	exports.def2Parser = def2Parser;
	var ImplementationGenerator = (function () {
	    function ImplementationGenerator() {
	    }
	    ImplementationGenerator.prototype.generateASTAccessor = function (p) {
	        this.generatedCode.push("var val=this.ast.getValue(" + p.name() + "}");
	        this.generatedCode.push("return new " + p.range().name() + "Impl(val)");
	    };
	    return ImplementationGenerator;
	})();
	var Serializer = (function () {
	    function Serializer(module, cfg) {
	        this.module = module;
	        this.cfg = cfg;
	        this.pkgMap = {};
	    }
	    Serializer.prototype.serializeAll = function () {
	        var _this = this;
	        this.module.children().forEach(function (x) { return _this.pkgMap[x.name] = _this.cfg.rootPackage + ((x instanceof td.TSClassDecl) ? '.impl.' : '.model.') + x.meta['$$pkg']; });
	        this.serializeModelFactory();
	        this.module.children().forEach(function (x) { return _this.serializeElement(x); });
	    };
	    Serializer.prototype.serializeElement = function (model) {
	        if (model instanceof td.TSEnumDecl) {
	            this.serializeEnum(model);
	        }
	        else if (model instanceof td.TSClassDecl) {
	            this.serializeImplementation(model);
	        }
	        else if (model instanceof td.TSInterface) {
	            this.serializeInterface(model);
	        }
	    };
	    Serializer.prototype.serializeEnum = function (model) {
	        var currentPackage = this.pkgMap[model.name];
	        var content = "package " + currentPackage + ";\n\npublic enum " + model.name + " {\n\n" + model.enumConstants.map(function (x) { return '    ' + x; }).join(',\n') + "\n\n}";
	        this.write(content, model.name + '.java', currentPackage);
	    };
	    Serializer.prototype.serializeInterface = function (model) {
	        var _this = this;
	        var currentPackage = this.pkgMap[model.name];
	        var isValueNode = model.meta['$$isValueType'];
	        var extendsString = this.refsArrayToString(model.extends, "extends", isValueNode ? 'extends IJavaAttributeNode' : 'extends IJavaElementNode');
	        var childMethods = model.children().filter(function (x) { return x instanceof td.TSAPIElementDeclaration; });
	        var methods = childMethods.map(function (x) { return _this.interfaceMethodString(x); });
	        var hasArrays = model.children().filter(function (x) { return x.rangeType && x.rangeType.array(); }).length > 0;
	        var imports = hasArrays ? { 'import java.util.List;': true } : {};
	        if (childMethods.length > 0) {
	            imports['import javax.xml.bind.annotation.XmlElement;'] = true;
	        }
	        if (model.extends.length == 0) {
	            imports[("import " + this.cfg.rootPackage + ".core." + (isValueNode ? 'IJavaAttributeNode' : "IJavaElementNode") + ";")] = true;
	        }
	        model.extends.filter(function (x) { return _this.pkgMap[resolveArray(x)] != currentPackage; }).forEach(function (x) { return _this.appendImport(x, imports); });
	        model.children().filter(function (x) { return !_this.hasPrimitiveReturnType(x) && _this.pkgMap[resolveArray(x.rangeType)] != currentPackage; }).forEach(function (x) { return _this.appendImport(x.rangeType, imports); });
	        var content = "package " + currentPackage + ";\n\n" + (Object.keys(imports).length > 0 ? Object.keys(imports).join('\n') + '\n\n\n' : '') + "\npublic interface " + model.name + " " + extendsString + " {\n\n" + methods.join('\n\n\n') + "\n\n}";
	        this.write(content, model.name + '.java', currentPackage);
	    };
	    Serializer.prototype.refsArrayToString = function (arr, keyWord, defVal) {
	        if (defVal === void 0) { defVal = ''; }
	        return (arr && arr.length > 0) ? keyWord + arr.map(function (x) { return x.serializeToString(); }).map(function (x) { return ' ' + x; }).join(',') : defVal;
	    };
	    Serializer.prototype.interfaceMethodString = function (method) {
	        var returnType = getReturnTypeString(method.rangeType);
	        var methodName = escape(method.name);
	        return "    @XmlElement(name=\"" + method.meta['property'] + "\")\n    " + returnType + " " + methodName + "();";
	    };
	    Serializer.prototype.serializeImplementation = function (model) {
	        var _this = this;
	        var currentPackage = this.pkgMap[model.name];
	        var isValueNode = model.meta['$$isValueType'];
	        var extendsString = this.refsArrayToString(model.extends, "extends", isValueNode ? 'extends JavaAttributeNode' : 'extends JavaElementNode');
	        var implementsString = this.refsArrayToString(model.implements, "implements");
	        var methods = model.children().filter(function (x) { return x instanceof td.TSAPIElementDeclaration; }).map(function (x) { return _this.implementationMethodString(x); });
	        var hasArrays = model.children().filter(function (x) { return x.rangeType && x.rangeType.array(); }).length > 0;
	        var imports = hasArrays ? { 'import java.util.List;': true } : {};
	        imports['import javax.xml.bind.annotation.XmlElement;'] = true;
	        imports[("import " + this.cfg.rootPackage + ".core.JavaNodeFactory;")] = true;
	        if (model.extends.length == 0) {
	            imports[("import " + this.cfg.rootPackage + ".core." + (isValueNode ? 'JavaAttributeNode' : "JavaElementNode") + ";")] = true;
	        }
	        else {
	            model.extends.filter(function (x) { return _this.pkgMap[resolveArray(x)] != currentPackage; }).forEach(function (x) { return _this.appendImport(x, imports); });
	        }
	        model.implements.forEach(function (x) { return _this.appendImport(x, imports); });
	        model.children().filter(function (x) { return !_this.hasPrimitiveReturnType(x) && _this.pkgMap[resolveArray(x.rangeType)] != currentPackage; }).forEach(function (x) { return _this.appendImport(x.rangeType, imports, true); });
	        var content = "package " + currentPackage + ";\n\n" + (Object.keys(imports).length > 0 ? Object.keys(imports).join('\n') + '\n\n\n' : '') + "\npublic class " + model.name + " " + extendsString + " " + implementsString + " {\n\n    public " + model.name + "(Object jsNode, JavaNodeFactory factory){\n        super(jsNode,factory);\n    }\n\n    protected " + model.name + "(){\n        super();\n    }\n\n\n" + methods.join('\n\n\n') + "\n}";
	        this.write(content, model.name + '.java', currentPackage);
	    };
	    Serializer.prototype.appendImport = function (x, imports, addImpl) {
	        if (addImpl === void 0) { addImpl = false; }
	        var n = resolveArray(x);
	        imports[this.importString(n)] = true;
	        var isEnum = checkEnum(x);
	        if (!isEnum && addImpl && n != customTypeSuperclass) {
	            imports[this.importString(n + 'Impl', true)] = true;
	        }
	    };
	    Serializer.prototype.importString = function (n, isImpl) {
	        if (isImpl === void 0) { isImpl = false; }
	        var subPackage = (n == customTypeSuperclass) ? 'core' : (isImpl ? 'impl' : 'model');
	        var pkg = this.pkgMap[n] ? this.pkgMap[n] : "" + this.cfg.rootPackage + "." + subPackage;
	        var importStr = "import " + pkg + "." + n + ";";
	        return importStr;
	    };
	    Serializer.prototype.implementationMethodString = function (method) {
	        var returnType = getReturnTypeString(method.rangeType);
	        var methodName = escape(method.name);
	        return "    @XmlElement(name=\"" + method.meta['property'] + "\")\n    public " + returnType + " " + methodName + "(){\n        " + method._body + "\n    }";
	    };
	    Serializer.prototype.write = function (content, name, pkg) {
	        var dstPath = path.resolve(path.resolve(this.cfg.sourceFolderAbsolutePath, this.packagePath(pkg)), name);
	        mkdirp.sync(path.dirname(dstPath));
	        fs.writeFileSync(dstPath, content);
	    };
	    Serializer.prototype.packagePath = function (pkg) {
	        return pkg.replace(/\./g, '/');
	    };
	    Serializer.prototype.hasPrimitiveReturnType = function (method) {
	        var isArray = method.rangeType.array();
	        var rangeType = isArray ? method.rangeType.componentType : method.rangeType;
	        var returnType = rangeType.serializeToString();
	        return tsutil.tsToJavaTypeMap[returnType] != null;
	    };
	    Serializer.prototype.serializeModelFactory = function () {
	        var _this = this;
	        var currentPackage = this.cfg.rootPackage + '.registry';
	        var className = 'ModelRegistry';
	        var content = "package " + currentPackage + ";\n\nimport java.util.HashMap;\n\npublic class " + className + " {\n\n    protected static " + className + " instance;\n\n    public static " + className + " getInstance(){\n        if(instance==null){\n            instance = new " + className + "();\n        }\n        return instance;\n    }\n\n\n    protected " + className + "(){\n        this.init();\n    }\n\n    public String rootPackage(){\n        return \"" + this.cfg.rootPackage + "\";\n    }\n\n    protected HashMap<String,String> packageMap;\n\n    @SuppressWarnings(\"unchecked\")\n\tpublic <S> Class<? extends S> getModelClass(String simpleName, Class<S> clazz){\n        String pkg = this.packageMap.get(simpleName);\n        if(pkg==null){\n            return null;\n        }\n        String qualifiedName = pkg + \".\" + simpleName;\n        try {\n            Class<?> result = this.getClass().getClassLoader().loadClass(qualifiedName);\n            if(result!=null && clazz.isAssignableFrom(result)){\n            \treturn (Class<? extends S>) result;\n            }\n        }\n        catch(Exception e){}\n\n        return null;\n    }\n\n    protected void init(){\n\n        this.packageMap = new HashMap<String,String>();\n\n" + Object.keys(this.pkgMap).map(function (x) { return ("        this.packageMap.put( \"" + x + "\", \"" + _this.pkgMap[x] + "\" );"); }).join('\n\n') + "\n    }\n\n}";
	        this.write(content, className + '.java', currentPackage);
	    };
	    return Serializer;
	})();
	function getReturnTypeString(rangeType) {
	    var returnType = resolveArray(rangeType);
	    return rangeType.array() ? "List<" + returnType + ">" : returnType;
	}
	function resolveArray(rangeType, toImpl) {
	    if (toImpl === void 0) { toImpl = false; }
	    var isArray = rangeType.array();
	    rangeType = isArray ? rangeType.componentType : rangeType;
	    var returnType = rangeType.serializeToString();
	    var converted = tsutil.tsToJavaTypeMap[returnType];
	    if (converted) {
	        return converted;
	    }
	    return toImpl ? returnType + 'Impl' : returnType;
	}
	function checkEnum(rangeType) {
	    var isArray = rangeType.array();
	    rangeType = isArray ? rangeType.componentType : rangeType;
	    var isEnum = rangeType instanceof td.TSDeclaredInterfaceReference && rangeType.getOriginal() instanceof td.TSEnumDecl;
	    return isEnum;
	}
	var UserClass = (function () {
	    function UserClass(simpleName, qualifiedName) {
	        this.simpleName = simpleName;
	        this.qualifiedName = qualifiedName;
	    }
	    return UserClass;
	})();
	exports.UserClass = UserClass;
	var UserClassCollection = (function () {
	    function UserClassCollection() {
	        this.classes = {};
	    }
	    UserClassCollection.prototype.getClasses = function () {
	        var _this = this;
	        return Object.keys(this.classes).map(function (x) { return _this.classes[x]; });
	    };
	    UserClassCollection.prototype.hasClass = function (qName) {
	        return this.classes[qName] != null;
	    };
	    UserClassCollection.prototype.addClass = function (cl) {
	        this.classes[cl.qualifiedName] = cl;
	    };
	    UserClassCollection.prototype.getClass = function (qName) {
	        return this.classes[qName];
	    };
	    return UserClassCollection;
	})();
	exports.UserClassCollection = UserClassCollection;
	var customTypeSuperclass = 'CustomType';
	var UserClassGenerator = (function () {
	    function UserClassGenerator(rootPackage) {
	        this.generatedSubPackage = '.generated.model';
	        this.classCollection = new UserClassCollection();
	        this.rootPackage = rootPackage;
	    }
	    UserClassGenerator.prototype.generateUserClass = function (typeDef) {
	        var _this = this;
	        var className = escape(typeDef.name());
	        var qName = this.rootPackage + this.generatedSubPackage + '.' + className;
	        if (this.classCollection.hasClass(qName)) {
	            return qName;
	        }
	        var uc = new UserClass(className, qName);
	        this.classCollection.addClass(uc);
	        var imports = {
	            'import javax.xml.bind.annotation.XmlElement;': true,
	            'import org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue;': true
	        };
	        imports[("import " + this.rootPackage + ".core." + customTypeSuperclass + ";")] = true;
	        var fields = [];
	        var hasArray = false;
	        typeDef.properties().forEach(function (p) {
	            var pName = p.name();
	            var fieldName = escape(pName);
	            var range = p.range();
	            var arrDim = 0;
	            while (range instanceof def.Array) {
	                hasArray = true;
	                range = range.component;
	                arrDim++;
	            }
	            var fieldType;
	            if (range.isValueType()) {
	                if (wrappedParserGen.checkIfReference(range)) {
	                    var fTypeQName = _this.generateUserClass(range);
	                    fieldType = _this.classCollection.getClass(fTypeQName).simpleName;
	                    if (fTypeQName != qName) {
	                        imports[("import " + fTypeQName + ";")] = true;
	                    }
	                }
	                else {
	                    var ft = range.name().toLowerCase();
	                    if (ft.indexOf('boolean') >= 0) {
	                        fieldType = 'Boolean';
	                    }
	                    else if (ft.indexOf('number') >= 0) {
	                        fieldType = 'Double';
	                    }
	                    else {
	                        fieldType = 'String';
	                    }
	                }
	            }
	            else {
	                var fTypeQName = _this.generateUserClass(range);
	                fieldType = _this.classCollection.getClass(fTypeQName).simpleName;
	                if (fTypeQName != qName) {
	                    imports[("import " + fTypeQName + ";")] = true;
	                }
	            }
	            while (arrDim > 0) {
	                fieldType = "List<" + fieldType + ">";
	                arrDim--;
	            }
	            fields.push("    @XmlElement(name=\"" + pName + "\")\n    public " + fieldType + " " + fieldName + ";");
	        });
	        if (hasArray) {
	            imports['import java.util.List;'] = true;
	        }
	        uc.content = "package " + (this.rootPackage + this.generatedSubPackage) + ";\n\n" + Object.keys(imports).join('\n') + "\n\n@XmlDiscriminatorValue(\"" + className + "\")\npublic class " + className + " extends " + customTypeSuperclass + "{\n\n" + fields.join('\n\n\n') + "\n\n}\n";
	        return qName;
	    };
	    return UserClassGenerator;
	})();
	function generateClasses(def, rootPackage) {
	    var generator = new UserClassGenerator(rootPackage);
	    generator.generateUserClass(def);
	    return generator.classCollection.getClasses();
	}
	exports.generateClasses = generateClasses;
	function escape(str) {
	    return tsutil.escapeToJavaIdentifier(str);
	}
	exports.escape = escape;
	//# sourceMappingURL=javaParserGen.js.map

/***/ },
/* 9 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../../typings/tsd.d.ts" />
	var yaml = __webpack_require__(19);
	var util = __webpack_require__(20);
	var llImpl = __webpack_require__(6);
	var CompilationUnit = (function () {
	    function CompilationUnit(_absolutePath, _path, _content, _project, _isTopoLevel) {
	        this._absolutePath = _absolutePath;
	        this._path = _path;
	        this._content = _content;
	        this._project = _project;
	        this._isTopoLevel = _isTopoLevel;
	        this._node = new AstNode(this, JSON.parse(this._content));
	    }
	    CompilationUnit.prototype.absolutePath = function () {
	        return this._absolutePath;
	    };
	    CompilationUnit.prototype.clone = function () {
	        return null;
	    };
	    CompilationUnit.prototype.contents = function () {
	        return this._content;
	    };
	    CompilationUnit.prototype.lexerErrors = function () {
	        return [];
	    };
	    CompilationUnit.prototype.path = function () {
	        return this._content;
	    };
	    CompilationUnit.prototype.isTopLevel = function () {
	        return this._isTopoLevel;
	    };
	    CompilationUnit.prototype.ast = function () {
	        return this._node;
	    };
	    CompilationUnit.prototype.isDirty = function () {
	        return true;
	    };
	    CompilationUnit.prototype.isRAMLUnit = function () {
	        return true;
	    };
	    CompilationUnit.prototype.project = function () {
	        return this._project;
	    };
	    CompilationUnit.prototype.updateContent = function (newContent) {
	    };
	    CompilationUnit.prototype.ramlVersion = function () {
	        throw 'not implemented';
	    };
	    CompilationUnit.prototype.resolve = function (p) {
	        return null;
	    }; // TODO FIXME 
	    return CompilationUnit;
	})();
	exports.CompilationUnit = CompilationUnit;
	//export interface IProject{
	//    units():ICompilationUnit[];//returns units with apis in this folder
	//
	//    execute(cmd:CompositeCommand)
	//
	//    executeTextChange(textCommand:TextChangeCommand);//this may result in broken nodes?
	//
	//    addListener(listener:IASTListener);
	//
	//    removeListener(listener:IASTListener)
	//
	//    addTextChangeListener(listener:ITextChangeCommandListener);
	//    removeTextChangeListener(listener:ITextChangeCommandListener);
	//}
	//export interface IASTListener{
	//    (delta:ASTDelta)
	//}
	//
	//export interface ITextChangeCommandListener{
	//    (delta:TextChangeCommand)
	//}
	//export class ASTDelta{
	//    commands:ASTChangeCommand[]
	//}
	//export interface ASTVisitor{
	//    (node:ILowLevelASTNode):boolean
	//}
	var AstNode = (function () {
	    function AstNode(_unit, _object, _parent, _key) {
	        var _this = this;
	        this._unit = _unit;
	        this._object = _object;
	        this._parent = _parent;
	        this._key = _key;
	        if (this._object instanceof Object) {
	            Object.keys(this._object).forEach(function (x) {
	                var u = unescapeKey(x);
	                if (u != x) {
	                    var val = _this._object[x];
	                    delete _this._object[x];
	                    _this._object[u] = val;
	                }
	            });
	        }
	    }
	    AstNode.prototype.start = function () {
	        return -1;
	    };
	    AstNode.prototype.end = function () {
	        return -1;
	    };
	    AstNode.prototype.value = function () {
	        return this._object;
	    };
	    AstNode.prototype.includeErrors = function () {
	        return [];
	    };
	    AstNode.prototype.includePath = function () {
	        return null;
	    };
	    AstNode.prototype.key = function () {
	        return this._key;
	    };
	    AstNode.prototype.children = function () {
	        var _this = this;
	        if (!this._object) {
	            return [];
	        }
	        if (Array.isArray(this._object)) {
	            return this._object.map(function (x) { return new AstNode(_this._unit, x, _this); });
	        }
	        else if (this._object instanceof Object) {
	            return Object.keys(this._object).map(function (x) { return new AstNode(_this._unit, _this._object[x], _this, x); });
	        }
	        else {
	            return [];
	        }
	    };
	    AstNode.prototype.parent = function () {
	        return this._parent;
	    };
	    AstNode.prototype.unit = function () {
	        return this._unit;
	    };
	    AstNode.prototype.anchorId = function () {
	        return null;
	    };
	    AstNode.prototype.errors = function () {
	        return [];
	    };
	    AstNode.prototype.anchoredFrom = function () {
	        return this;
	    };
	    AstNode.prototype.includedFrom = function () {
	        return this;
	    };
	    AstNode.prototype.visit = function (v) {
	        if (v(this)) {
	            this.children().forEach(function (x) { return x.visit(v); });
	        }
	    };
	    AstNode.prototype.dumpToObject = function () {
	        return this._object;
	    };
	    AstNode.prototype.addChild = function (n) {
	    };
	    AstNode.prototype.execute = function (cmd) {
	    };
	    AstNode.prototype.dump = function () {
	        return JSON.stringify(this._object);
	    };
	    AstNode.prototype.keyStart = function () {
	        return -1;
	    };
	    AstNode.prototype.keyEnd = function () {
	        return -1;
	    };
	    AstNode.prototype.valueStart = function () {
	        return -1;
	    };
	    AstNode.prototype.valueEnd = function () {
	        return -1;
	    };
	    AstNode.prototype.isValueLocal = function () {
	        return true;
	    };
	    AstNode.prototype.kind = function () {
	        if (Array.isArray(this._object)) {
	            return 3 /* SEQ */;
	        }
	        else if (this._object instanceof Object) {
	            return 2 /* MAP */;
	        }
	        else {
	            return 0 /* SCALAR */;
	        }
	    };
	    AstNode.prototype.valueKind = function () {
	        return null;
	    };
	    AstNode.prototype.show = function (msg) {
	    };
	    AstNode.prototype.setHighLevelParseResult = function (highLevelParseResult) {
	        this._highLevelParseResult = highLevelParseResult;
	    };
	    AstNode.prototype.highLevelParseResult = function () {
	        return this._highLevelParseResult;
	    };
	    AstNode.prototype.setHighLevelNode = function (highLevel) {
	        this._highLevelNode = highLevel;
	    };
	    AstNode.prototype.highLevelNode = function () {
	        return this._highLevelNode;
	    };
	    AstNode.prototype.text = function (unitText) {
	        throw "not implemented";
	    };
	    AstNode.prototype.copy = function () {
	        throw "not implemented";
	    };
	    AstNode.prototype.markup = function (json) {
	        throw "not implemented";
	    };
	    AstNode.prototype.nodeDefinition = function () {
	        return llImpl.getDefinitionForLowLevelNode(this);
	    };
	    return AstNode;
	})();
	exports.AstNode = AstNode;
	function serialize(node) {
	    if (node.children().length == 0) {
	        if (node.value()) {
	            return node.value();
	        }
	        return '';
	    }
	    if (!node.children()[0].key()) {
	        var arr = [];
	        node.children().forEach(function (x) {
	            arr.push(serialize(x));
	        });
	        return arr;
	    }
	    else {
	        var obj = {};
	        node.children().forEach(function (x) {
	            obj[escapeKey(x.key())] = serialize(x);
	        });
	        return obj;
	    }
	}
	exports.serialize = serialize;
	function escapeKey(key) {
	    if (!key) {
	        return key;
	    }
	    if (key.replace(/\d/g, '').trim().length == 0) {
	        return '__$EscapedKey$__' + key;
	    }
	    return key;
	}
	function unescapeKey(key) {
	    if (!key) {
	        return key;
	    }
	    if (util.stringStartsWith(key, '__$EscapedKey$__')) {
	        return key.substring('__$EscapedKey$__'.length);
	    }
	    return key;
	}
	//# sourceMappingURL=json2lowLevel.js.map

/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global, __dirname) {var fs = __webpack_require__(12);
	var path = __webpack_require__(11);
	var tsstruct = __webpack_require__(38);
	var ts2def = __webpack_require__(39);
	var universes = {};
	var locations = {
	    "RAML10": "./spec-1.0/api.ts",
	    "RAML08": "./spec-0.8/api.ts",
	    "Swagger2": "./spec-swagger-2.0/swagger.ts"
	};
	var jsonDefinitions = {
	    "RAML10": __webpack_require__(49),
	    "RAML08": __webpack_require__(50),
	    "Swagger2": __webpack_require__(51)
	};
	var getUniverse = (function () {
	    var x = function (key) {
	        if (universes[key]) {
	            return universes[key];
	        }
	        var src = getDecl(key);
	        var universe = ts2def.toDefSystem(src);
	        if (universe) {
	            universe.setUniverseVersion(key);
	            universes[key] = universe;
	        }
	        var mediaTypeParser = __webpack_require__(41);
	        global.mediaTypeParser = mediaTypeParser;
	        return universe;
	    };
	    x.availableUniverses = function () {
	        return Object.keys(locations);
	    };
	    x.clean = function () {
	        Object.keys(jsonDefinitions).forEach(function (x) {
	            jsonDefinitions[x] = null;
	            universes[x] = null;
	            fs.writeFileSync(path.resolve(__dirname, "./artifacts/" + x + ".json"), 'null');
	        });
	    };
	    return x;
	})();
	function getDecl(key) {
	    if (jsonDefinitions[key]) {
	        return toModule(jsonDefinitions[key]);
	    }
	    var tsPath = path.resolve(__dirname, locations[key]);
	    var decls = fs.readFileSync(tsPath).toString();
	    var src = tsstruct.parseStruct(decls, {}, tsPath);
	    var arr = toModulesCollection(src);
	    var jsonPath = path.resolve(path.resolve(path.dirname(tsPath), '../artifacts'), key + '.json');
	    fs.writeFileSync(jsonPath, JSON.stringify(arr, null, 2));
	    src = toModule(arr);
	    return src;
	}
	function toModulesCollection(mod, map, arr) {
	    if (map === void 0) { map = {}; }
	    if (arr === void 0) { arr = []; }
	    var name = mod['name'];
	    if (map[name]) {
	        return;
	    }
	    map[name] = mod;
	    arr.push(mod);
	    var imports = mod['imports'];
	    Object.keys(imports).forEach(function (x) {
	        var submod = imports[x];
	        var n = submod['name'];
	        imports[x] = n;
	        toModulesCollection(submod, map, arr);
	    });
	    return arr;
	}
	function toModule(arr) {
	    var main = arr[0];
	    var map = {};
	    arr.forEach(function (x) { return map[x['name']] = x; });
	    arr.forEach(function (x) {
	        var imports = x['imports'];
	        Object.keys(imports).forEach(function (y) {
	            var name = imports[y];
	            imports[y] = map[name];
	        });
	    });
	    return main;
	}
	module.exports = getUniverse;
	//# sourceMappingURL=universeProvider.js.map
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }()), ".."))

/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	// resolves . and .. elements in a path array with directory names there
	// must be no slashes, empty elements, or device names (c:\) in the array
	// (so also no leading and trailing slashes - it does not distinguish
	// relative and absolute paths)
	function normalizeArray(parts, allowAboveRoot) {
	  // if the path tries to go above the root, `up` ends up > 0
	  var up = 0;
	  for (var i = parts.length - 1; i >= 0; i--) {
	    var last = parts[i];
	    if (last === '.') {
	      parts.splice(i, 1);
	    } else if (last === '..') {
	      parts.splice(i, 1);
	      up++;
	    } else if (up) {
	      parts.splice(i, 1);
	      up--;
	    }
	  }

	  // if the path is allowed to go above the root, restore leading ..s
	  if (allowAboveRoot) {
	    for (; up--; up) {
	      parts.unshift('..');
	    }
	  }

	  return parts;
	}

	// Split a filename into [root, dir, basename, ext], unix version
	// 'root' is just a slash, or nothing.
	var splitPathRe =
	    /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
	var splitPath = function(filename) {
	  return splitPathRe.exec(filename).slice(1);
	};

	// path.resolve([from ...], to)
	// posix version
	exports.resolve = function() {
	  var resolvedPath = '',
	      resolvedAbsolute = false;

	  for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
	    var path = (i >= 0) ? arguments[i] : process.cwd();

	    // Skip empty and invalid entries
	    if (typeof path !== 'string') {
	      throw new TypeError('Arguments to path.resolve must be strings');
	    } else if (!path) {
	      continue;
	    }

	    resolvedPath = path + '/' + resolvedPath;
	    resolvedAbsolute = path.charAt(0) === '/';
	  }

	  // At this point the path should be resolved to a full absolute path, but
	  // handle relative paths to be safe (might happen when process.cwd() fails)

	  // Normalize the path
	  resolvedPath = normalizeArray(filter(resolvedPath.split('/'), function(p) {
	    return !!p;
	  }), !resolvedAbsolute).join('/');

	  return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
	};

	// path.normalize(path)
	// posix version
	exports.normalize = function(path) {
	  var isAbsolute = exports.isAbsolute(path),
	      trailingSlash = substr(path, -1) === '/';

	  // Normalize the path
	  path = normalizeArray(filter(path.split('/'), function(p) {
	    return !!p;
	  }), !isAbsolute).join('/');

	  if (!path && !isAbsolute) {
	    path = '.';
	  }
	  if (path && trailingSlash) {
	    path += '/';
	  }

	  return (isAbsolute ? '/' : '') + path;
	};

	// posix version
	exports.isAbsolute = function(path) {
	  return path.charAt(0) === '/';
	};

	// posix version
	exports.join = function() {
	  var paths = Array.prototype.slice.call(arguments, 0);
	  return exports.normalize(filter(paths, function(p, index) {
	    if (typeof p !== 'string') {
	      throw new TypeError('Arguments to path.join must be strings');
	    }
	    return p;
	  }).join('/'));
	};


	// path.relative(from, to)
	// posix version
	exports.relative = function(from, to) {
	  from = exports.resolve(from).substr(1);
	  to = exports.resolve(to).substr(1);

	  function trim(arr) {
	    var start = 0;
	    for (; start < arr.length; start++) {
	      if (arr[start] !== '') break;
	    }

	    var end = arr.length - 1;
	    for (; end >= 0; end--) {
	      if (arr[end] !== '') break;
	    }

	    if (start > end) return [];
	    return arr.slice(start, end - start + 1);
	  }

	  var fromParts = trim(from.split('/'));
	  var toParts = trim(to.split('/'));

	  var length = Math.min(fromParts.length, toParts.length);
	  var samePartsLength = length;
	  for (var i = 0; i < length; i++) {
	    if (fromParts[i] !== toParts[i]) {
	      samePartsLength = i;
	      break;
	    }
	  }

	  var outputParts = [];
	  for (var i = samePartsLength; i < fromParts.length; i++) {
	    outputParts.push('..');
	  }

	  outputParts = outputParts.concat(toParts.slice(samePartsLength));

	  return outputParts.join('/');
	};

	exports.sep = '/';
	exports.delimiter = ':';

	exports.dirname = function(path) {
	  var result = splitPath(path),
	      root = result[0],
	      dir = result[1];

	  if (!root && !dir) {
	    // No dirname whatsoever
	    return '.';
	  }

	  if (dir) {
	    // It has a dirname, strip trailing slash
	    dir = dir.substr(0, dir.length - 1);
	  }

	  return root + dir;
	};


	exports.basename = function(path, ext) {
	  var f = splitPath(path)[2];
	  // TODO: make this comparison case-insensitive on windows?
	  if (ext && f.substr(-1 * ext.length) === ext) {
	    f = f.substr(0, f.length - ext.length);
	  }
	  return f;
	};


	exports.extname = function(path) {
	  return splitPath(path)[3];
	};

	function filter (xs, f) {
	    if (xs.filter) return xs.filter(f);
	    var res = [];
	    for (var i = 0; i < xs.length; i++) {
	        if (f(xs[i], i, xs)) res.push(xs[i]);
	    }
	    return res;
	}

	// String.prototype.substr - negative index don't work in IE8
	var substr = 'ab'.substr(-1) === 'b'
	    ? function (str, start, len) { return str.substr(start, len) }
	    : function (str, start, len) {
	        if (start < 0) start = str.length + start;
	        return str.substr(start, len);
	    }
	;

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(72)))

/***/ },
/* 12 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = fs;

/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	var __extends = this.__extends || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    __.prototype = b.prototype;
	    d.prototype = new __();
	};
	var yaml = __webpack_require__(19);
	var json = __webpack_require__(9);
	var stringify = __webpack_require__(73);
	var impl = __webpack_require__(6);
	var util = __webpack_require__(20);
	var LowLevelProxyNode = (function () {
	    function LowLevelProxyNode(_parent, _transformer) {
	        this._parent = _parent;
	        this._transformer = _transformer;
	    }
	    LowLevelProxyNode.prototype.transformer = function () {
	        return this._transformer;
	    };
	    LowLevelProxyNode.prototype.original = function () {
	        return this._original;
	    };
	    LowLevelProxyNode.prototype.start = function () {
	        return this._original.start();
	    };
	    LowLevelProxyNode.prototype.end = function () {
	        return this._original.end();
	    };
	    LowLevelProxyNode.prototype.value = function () {
	        throw 'The method must be overridden';
	    };
	    LowLevelProxyNode.prototype.includeErrors = function () {
	        return this._original.includeErrors();
	    };
	    LowLevelProxyNode.prototype.includePath = function () {
	        return this._original.includePath();
	    };
	    LowLevelProxyNode.prototype.setKeyOverride = function (_key) {
	        this._keyOverride = _key;
	    };
	    LowLevelProxyNode.prototype.key = function () {
	        if (this._keyOverride) {
	            return this._keyOverride;
	        }
	        return this._original.key();
	    };
	    LowLevelProxyNode.prototype.children = function () {
	        throw 'The method must be overridden';
	    };
	    LowLevelProxyNode.prototype.parent = function () {
	        return this._parent;
	    };
	    LowLevelProxyNode.prototype.unit = function () {
	        return this._original.unit();
	    };
	    LowLevelProxyNode.prototype.anchorId = function () {
	        return this._original.anchorId();
	    };
	    LowLevelProxyNode.prototype.errors = function () {
	        return this._original.errors();
	    };
	    LowLevelProxyNode.prototype.anchoredFrom = function () {
	        return this._original.anchoredFrom();
	    };
	    LowLevelProxyNode.prototype.includedFrom = function () {
	        return this._original.includedFrom();
	    };
	    LowLevelProxyNode.prototype.visit = function (v) {
	        if (v(this)) {
	            this.children().forEach(function (x) { return x.visit(v); });
	        }
	    };
	    //TODO
	    LowLevelProxyNode.prototype.addChild = function (n) {
	    };
	    //TODO
	    LowLevelProxyNode.prototype.execute = function (cmd) {
	    };
	    //TODO
	    LowLevelProxyNode.prototype.dump = function () {
	        return null;
	    };
	    //TODO
	    LowLevelProxyNode.prototype.dumpToObject = function () {
	        return json.serialize(this);
	    };
	    LowLevelProxyNode.prototype.keyStart = function () {
	        return this._original.keyStart();
	    };
	    LowLevelProxyNode.prototype.keyEnd = function () {
	        return this._original.keyEnd();
	    };
	    LowLevelProxyNode.prototype.valueStart = function () {
	        return this._original.valueStart();
	    };
	    LowLevelProxyNode.prototype.valueEnd = function () {
	        return this._original.valueEnd();
	    };
	    LowLevelProxyNode.prototype.isValueLocal = function () {
	        return this._original.isValueLocal();
	    };
	    LowLevelProxyNode.prototype.kind = function () {
	        return this._original.kind();
	    };
	    LowLevelProxyNode.prototype.valueKind = function () {
	        return this._original.valueKind();
	    };
	    LowLevelProxyNode.prototype.show = function (msg) {
	        this._original.show(msg);
	    };
	    LowLevelProxyNode.prototype.setHighLevelParseResult = function (highLevelParseResult) {
	        this._highLevelParseResult = highLevelParseResult;
	    };
	    LowLevelProxyNode.prototype.highLevelParseResult = function () {
	        return this._highLevelParseResult;
	    };
	    LowLevelProxyNode.prototype.setHighLevelNode = function (highLevel) {
	        this._highLevelNode = highLevel;
	    };
	    LowLevelProxyNode.prototype.highLevelNode = function () {
	        return this._highLevelNode;
	    };
	    LowLevelProxyNode.prototype.text = function (unitText) {
	        throw "not implemented";
	    };
	    LowLevelProxyNode.prototype.copy = function () {
	        throw "not implemented";
	    };
	    LowLevelProxyNode.prototype.markup = function (json) {
	        throw "not implemented";
	    };
	    LowLevelProxyNode.prototype.nodeDefinition = function () {
	        return impl.getDefinitionForLowLevelNode(this);
	    };
	    return LowLevelProxyNode;
	})();
	exports.LowLevelProxyNode = LowLevelProxyNode;
	var LowLevelCompositeNode = (function (_super) {
	    __extends(LowLevelCompositeNode, _super);
	    function LowLevelCompositeNode(node, parent, transformer, fromMainTree) {
	        if (fromMainTree === void 0) { fromMainTree = true; }
	        _super.call(this, parent, transformer);
	        this.fromMainTree = fromMainTree;
	        this._adoptedNodes = [];
	        var originalParent = this.parent() ? this.parent().original() : null;
	        this._original = new LowLevelValueTransformingNode(node, originalParent, transformer);
	        this._adoptedNodes.push(this.original());
	    }
	    LowLevelCompositeNode.prototype.adoptedNodes = function () {
	        return this._adoptedNodes;
	    };
	    LowLevelCompositeNode.prototype.original = function () {
	        return this._original;
	    };
	    LowLevelCompositeNode.prototype.parent = function () {
	        return this._parent;
	    };
	    LowLevelCompositeNode.prototype.adopt = function (node, transformer) {
	        if (!transformer) {
	            transformer = this._transformer;
	        }
	        var originalParent = this.parent() ? this.parent().original() : null;
	        var tNode = new LowLevelValueTransformingNode(node, originalParent, transformer);
	        this._adoptedNodes.push(tNode);
	        if (this._children) {
	            this._children.forEach(function (x) { return x._parent = null; });
	        }
	        this._children = null;
	        if (this.highLevelNode()) {
	            this.highLevelNode().resetChildren();
	        }
	    };
	    LowLevelCompositeNode.prototype.value = function () {
	        var valuableNodes = this._adoptedNodes.filter(function (x) { return x.value(); });
	        if (valuableNodes.length > 0) {
	            return valuableNodes[0].value();
	        }
	        return this._original.value();
	    };
	    LowLevelCompositeNode.prototype.children = function () {
	        var _this = this;
	        if (this._children) {
	            return this._children;
	        }
	        var result = [];
	        var canBeMap = false;
	        var canBeSeq = false;
	        this._adoptedNodes.forEach(function (x) {
	            if (x.children() && x.children().length > 0) {
	                canBeSeq = true;
	                if (x.children()[0].key()) {
	                    canBeMap = true;
	                }
	            }
	        });
	        if (canBeMap) {
	            result = this.collectChildrenWithKeys();
	        }
	        else if (canBeSeq) {
	            result = this.collectChildrenWithKeys();
	            var map = {};
	            this._adoptedNodes.forEach(function (x, i) { return x.children().filter(function (y) { return !y.key(); }).forEach(function (y) {
	                var key = _this.buildKey(y);
	                if (map[key]) {
	                    return;
	                }
	                map[key] = true;
	                var transformer = x.transformer() ? x.transformer() : _this.transformer();
	                var ch = (y instanceof LowLevelValueTransformingNode) ? y.original() : y;
	                result.push(new LowLevelCompositeNode(ch, _this, transformer, i == 0));
	            }); });
	        }
	        else {
	            result = [];
	        }
	        this._children = result;
	        return result;
	    };
	    LowLevelCompositeNode.prototype.buildKey = function (y) {
	        var obj = json.serialize(y);
	        var def = this.nodeDefinition();
	        if (def && (def.name() == 'TraitRef' || def.name() == 'ResourceTypeRef')) {
	            if (typeof obj == 'object') {
	                var keys = Object.keys(obj);
	                if (keys.length > 0) {
	                    obj = keys[0];
	                }
	            }
	        }
	        return stringify(obj);
	    };
	    LowLevelCompositeNode.prototype.collectChildrenWithKeys = function () {
	        var _this = this;
	        var result = [];
	        var m = {};
	        this._adoptedNodes.forEach(function (x, i) {
	            x.original().children().forEach(function (y) {
	                var key = y.key();
	                if (!key) {
	                    return;
	                }
	                if (util.stringEndsWith(key, '?')) {
	                    key = key.substring(0, key.length - 1);
	                }
	                var arr = m[key];
	                if (!arr) {
	                    arr = [];
	                    m[key] = arr;
	                }
	                arr.push({ node: y, transformer: x.transformer(), fromOriginalTree: _this.fromMainTree && i == 0 });
	            });
	        });
	        Object.keys(m).forEach(function (key) {
	            var arr = m[key];
	            var allOptional = true;
	            var hasChildFromOriginalTree = false;
	            arr.forEach(function (x) {
	                allOptional = allOptional && util.stringEndsWith(x.node.key(), '?');
	                hasChildFromOriginalTree = hasChildFromOriginalTree || x.fromOriginalTree;
	            });
	            if (hasChildFromOriginalTree || !allOptional) {
	                var originalTransformer = arr[0].transformer ? arr[0].transformer : _this.transformer();
	                var originalChild = new LowLevelCompositeNode(arr[0].node, _this, originalTransformer, hasChildFromOriginalTree);
	                for (var i = 1; i < arr.length; i++) {
	                    originalChild.adopt(arr[i].node, arr[i].transformer);
	                }
	                result.push(originalChild);
	            }
	        });
	        return result;
	    };
	    LowLevelCompositeNode.prototype.valueKind = function () {
	        if (this._original.kind() != 1 /* MAPPING */) {
	            return null;
	        }
	        for (var i = 0; i < this._adoptedNodes.length; i++) {
	            var node = this._adoptedNodes[i];
	            if (node.value()) {
	                return node.valueKind();
	            }
	        }
	        return null;
	    };
	    LowLevelCompositeNode.prototype.includePath = function () {
	        for (var i = 0; i < this._adoptedNodes.length; i++) {
	            var node = this._adoptedNodes[i];
	            if (node.value()) {
	                return node.includePath();
	            }
	        }
	        return null;
	    };
	    LowLevelCompositeNode.prototype.key = function () {
	        var keys = this._adoptedNodes.map(function (x) { return x.key(); }).filter(function (x) { return x != null && !util.stringEndsWith(x, '?'); });
	        if (keys.length > 0) {
	            return keys[0];
	        }
	        return _super.prototype.key.call(this);
	    };
	    return LowLevelCompositeNode;
	})(LowLevelProxyNode);
	exports.LowLevelCompositeNode = LowLevelCompositeNode;
	var LowLevelValueTransformingNode = (function (_super) {
	    __extends(LowLevelValueTransformingNode, _super);
	    function LowLevelValueTransformingNode(node, parent, transformer) {
	        _super.call(this, parent, transformer);
	        this._original = node;
	    }
	    LowLevelValueTransformingNode.prototype.value = function () {
	        var val = this.original().value();
	        var t = this.transformer();
	        if (t) {
	            val = t.transform(val);
	            if (t.error()) {
	                var msg = t.error();
	                console.log(t.error());
	            }
	        }
	        return val;
	    };
	    LowLevelValueTransformingNode.prototype.children = function () {
	        var _this = this;
	        return this.original().children().map(function (x) { return new LowLevelValueTransformingNode(x, _this, _this._transformer); });
	    };
	    LowLevelValueTransformingNode.prototype.parent = function () {
	        return this._parent;
	    };
	    return LowLevelValueTransformingNode;
	})(LowLevelProxyNode);
	exports.LowLevelValueTransformingNode = LowLevelValueTransformingNode;
	//# sourceMappingURL=LowLevelASTProxy.js.map

/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

	var __extends = this.__extends || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    __.prototype = b.prototype;
	    d.prototype = new __();
	};
	var hl = __webpack_require__(17);
	var core = __webpack_require__(18);
	var BasicNodeImpl = (function (_super) {
	    __extends(BasicNodeImpl, _super);
	    function BasicNodeImpl(node) {
	        _super.call(this, node);
	    }
	    BasicNodeImpl.prototype.wrapperClassName = function () {
	        return 'BasicNodeImpl';
	    };
	    BasicNodeImpl.prototype.parent = function () {
	        return _super.prototype.parent.call(this);
	    };
	    return BasicNodeImpl;
	})(core.BasicSuperNodeImpl);
	exports.BasicNodeImpl = BasicNodeImpl;
	var RAMLLanguageElementImpl = (function (_super) {
	    __extends(RAMLLanguageElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function RAMLLanguageElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createRAMLLanguageElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    RAMLLanguageElementImpl.prototype.wrapperClassName = function () {
	        return "RAMLLanguageElementImpl";
	    };
	    /**
	     *
	     **/
	    //description
	    RAMLLanguageElementImpl.prototype.description = function () {
	        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
	    };
	    return RAMLLanguageElementImpl;
	})(BasicNodeImpl);
	exports.RAMLLanguageElementImpl = RAMLLanguageElementImpl;
	var ValueTypeImpl = (function () {
	    /**
	     *
	     **/
	    //constructor
	    function ValueTypeImpl(attr) {
	        this.attr = attr;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ValueTypeImpl.prototype.wrapperClassName = function () {
	        return "ValueTypeImpl";
	    };
	    /**
	     *
	     **/
	    //value
	    ValueTypeImpl.prototype.value = function () {
	        return this.attr.value();
	    };
	    /**
	     *
	     **/
	    //highLevel
	    ValueTypeImpl.prototype.highLevel = function () {
	        return this.attr;
	    };
	    return ValueTypeImpl;
	})();
	exports.ValueTypeImpl = ValueTypeImpl;
	var NumberTypeImpl = (function (_super) {
	    __extends(NumberTypeImpl, _super);
	    function NumberTypeImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    NumberTypeImpl.prototype.wrapperClassName = function () {
	        return "NumberTypeImpl";
	    };
	    return NumberTypeImpl;
	})(ValueTypeImpl);
	exports.NumberTypeImpl = NumberTypeImpl;
	var BooleanTypeImpl = (function (_super) {
	    __extends(BooleanTypeImpl, _super);
	    function BooleanTypeImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    BooleanTypeImpl.prototype.wrapperClassName = function () {
	        return "BooleanTypeImpl";
	    };
	    return BooleanTypeImpl;
	})(ValueTypeImpl);
	exports.BooleanTypeImpl = BooleanTypeImpl;
	var ReferenceImpl = (function (_super) {
	    __extends(ReferenceImpl, _super);
	    function ReferenceImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ReferenceImpl.prototype.wrapperClassName = function () {
	        return "ReferenceImpl";
	    };
	    /**
	     *
	     **/
	    //value
	    ReferenceImpl.prototype.value = function () {
	        return core.toStructuredValue(this.attr);
	    };
	    return ReferenceImpl;
	})(ValueTypeImpl);
	exports.ReferenceImpl = ReferenceImpl;
	var ResourceTypeRefImpl = (function (_super) {
	    __extends(ResourceTypeRefImpl, _super);
	    function ResourceTypeRefImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ResourceTypeRefImpl.prototype.wrapperClassName = function () {
	        return "ResourceTypeRefImpl";
	    };
	    return ResourceTypeRefImpl;
	})(ReferenceImpl);
	exports.ResourceTypeRefImpl = ResourceTypeRefImpl;
	var TraitRefImpl = (function (_super) {
	    __extends(TraitRefImpl, _super);
	    function TraitRefImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    TraitRefImpl.prototype.wrapperClassName = function () {
	        return "TraitRefImpl";
	    };
	    return TraitRefImpl;
	})(ReferenceImpl);
	exports.TraitRefImpl = TraitRefImpl;
	var SecuritySchemaRefImpl = (function (_super) {
	    __extends(SecuritySchemaRefImpl, _super);
	    function SecuritySchemaRefImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    SecuritySchemaRefImpl.prototype.wrapperClassName = function () {
	        return "SecuritySchemaRefImpl";
	    };
	    return SecuritySchemaRefImpl;
	})(ReferenceImpl);
	exports.SecuritySchemaRefImpl = SecuritySchemaRefImpl;
	var StringTypeImpl = (function (_super) {
	    __extends(StringTypeImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function StringTypeImpl(attr) {
	        _super.call(this, attr);
	        this.attr = attr;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    StringTypeImpl.prototype.wrapperClassName = function () {
	        return "StringTypeImpl";
	    };
	    return StringTypeImpl;
	})(ValueTypeImpl);
	exports.StringTypeImpl = StringTypeImpl;
	var UriTemplateImpl = (function (_super) {
	    __extends(UriTemplateImpl, _super);
	    function UriTemplateImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    UriTemplateImpl.prototype.wrapperClassName = function () {
	        return "UriTemplateImpl";
	    };
	    return UriTemplateImpl;
	})(StringTypeImpl);
	exports.UriTemplateImpl = UriTemplateImpl;
	var RelativeUriImpl = (function (_super) {
	    __extends(RelativeUriImpl, _super);
	    function RelativeUriImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    RelativeUriImpl.prototype.wrapperClassName = function () {
	        return "RelativeUriImpl";
	    };
	    return RelativeUriImpl;
	})(UriTemplateImpl);
	exports.RelativeUriImpl = RelativeUriImpl;
	var FullUriTemplateImpl = (function (_super) {
	    __extends(FullUriTemplateImpl, _super);
	    function FullUriTemplateImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    FullUriTemplateImpl.prototype.wrapperClassName = function () {
	        return "FullUriTemplateImpl";
	    };
	    return FullUriTemplateImpl;
	})(UriTemplateImpl);
	exports.FullUriTemplateImpl = FullUriTemplateImpl;
	var FixedUriImpl = (function (_super) {
	    __extends(FixedUriImpl, _super);
	    function FixedUriImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    FixedUriImpl.prototype.wrapperClassName = function () {
	        return "FixedUriImpl";
	    };
	    return FixedUriImpl;
	})(StringTypeImpl);
	exports.FixedUriImpl = FixedUriImpl;
	var SchemaStringImpl = (function (_super) {
	    __extends(SchemaStringImpl, _super);
	    function SchemaStringImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    SchemaStringImpl.prototype.wrapperClassName = function () {
	        return "SchemaStringImpl";
	    };
	    return SchemaStringImpl;
	})(StringTypeImpl);
	exports.SchemaStringImpl = SchemaStringImpl;
	var JSonSchemaStringImpl = (function (_super) {
	    __extends(JSonSchemaStringImpl, _super);
	    function JSonSchemaStringImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    JSonSchemaStringImpl.prototype.wrapperClassName = function () {
	        return "JSonSchemaStringImpl";
	    };
	    return JSonSchemaStringImpl;
	})(SchemaStringImpl);
	exports.JSonSchemaStringImpl = JSonSchemaStringImpl;
	var XMLSchemaStringImpl = (function (_super) {
	    __extends(XMLSchemaStringImpl, _super);
	    function XMLSchemaStringImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    XMLSchemaStringImpl.prototype.wrapperClassName = function () {
	        return "XMLSchemaStringImpl";
	    };
	    return XMLSchemaStringImpl;
	})(SchemaStringImpl);
	exports.XMLSchemaStringImpl = XMLSchemaStringImpl;
	var ExampleStringImpl = (function (_super) {
	    __extends(ExampleStringImpl, _super);
	    function ExampleStringImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ExampleStringImpl.prototype.wrapperClassName = function () {
	        return "ExampleStringImpl";
	    };
	    return ExampleStringImpl;
	})(StringTypeImpl);
	exports.ExampleStringImpl = ExampleStringImpl;
	var JSONExampleImpl = (function (_super) {
	    __extends(JSONExampleImpl, _super);
	    function JSONExampleImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    JSONExampleImpl.prototype.wrapperClassName = function () {
	        return "JSONExampleImpl";
	    };
	    return JSONExampleImpl;
	})(ExampleStringImpl);
	exports.JSONExampleImpl = JSONExampleImpl;
	var XMLExampleImpl = (function (_super) {
	    __extends(XMLExampleImpl, _super);
	    function XMLExampleImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    XMLExampleImpl.prototype.wrapperClassName = function () {
	        return "XMLExampleImpl";
	    };
	    return XMLExampleImpl;
	})(ExampleStringImpl);
	exports.XMLExampleImpl = XMLExampleImpl;
	var StatusCodeImpl = (function (_super) {
	    __extends(StatusCodeImpl, _super);
	    function StatusCodeImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    StatusCodeImpl.prototype.wrapperClassName = function () {
	        return "StatusCodeImpl";
	    };
	    return StatusCodeImpl;
	})(StringTypeImpl);
	exports.StatusCodeImpl = StatusCodeImpl;
	var MimeTypeImpl = (function (_super) {
	    __extends(MimeTypeImpl, _super);
	    function MimeTypeImpl() {
	        _super.apply(this, arguments);
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    MimeTypeImpl.prototype.wrapperClassName = function () {
	        return "MimeTypeImpl";
	    };
	    return MimeTypeImpl;
	})(StringTypeImpl);
	exports.MimeTypeImpl = MimeTypeImpl;
	var MarkdownStringImpl = (function (_super) {
	    __extends(MarkdownStringImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function MarkdownStringImpl(attr) {
	        _super.call(this, attr);
	        this.attr = attr;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    MarkdownStringImpl.prototype.wrapperClassName = function () {
	        return "MarkdownStringImpl";
	    };
	    return MarkdownStringImpl;
	})(StringTypeImpl);
	exports.MarkdownStringImpl = MarkdownStringImpl;
	var SecuritySchemaImpl = (function (_super) {
	    __extends(SecuritySchemaImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function SecuritySchemaImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createSecuritySchema(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    SecuritySchemaImpl.prototype.wrapperClassName = function () {
	        return "SecuritySchemaImpl";
	    };
	    /**
	     *
	     **/
	    //name
	    SecuritySchemaImpl.prototype.name = function () {
	        return _super.prototype.attribute.call(this, 'name', this.toString);
	    };
	    /**
	     *
	     **/
	    //setName
	    SecuritySchemaImpl.prototype.setName = function (param) {
	        {
	            this.highLevel().attrOrCreate("name").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //type
	    SecuritySchemaImpl.prototype["type"] = function () {
	        return _super.prototype.attribute.call(this, 'type', this.toString);
	    };
	    /**
	     *
	     **/
	    //setType
	    SecuritySchemaImpl.prototype.setType = function (param) {
	        {
	            this.highLevel().attrOrCreate("type").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //description
	    SecuritySchemaImpl.prototype.description = function () {
	        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //describedBy
	    SecuritySchemaImpl.prototype.describedBy = function () {
	        return _super.prototype.element.call(this, 'describedBy');
	    };
	    /**
	     *
	     **/
	    //settings
	    SecuritySchemaImpl.prototype.settings = function () {
	        return _super.prototype.element.call(this, 'settings');
	    };
	    return SecuritySchemaImpl;
	})(RAMLLanguageElementImpl);
	exports.SecuritySchemaImpl = SecuritySchemaImpl;
	var RAMLSimpleElementImpl = (function (_super) {
	    __extends(RAMLSimpleElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function RAMLSimpleElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createRAMLSimpleElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    RAMLSimpleElementImpl.prototype.wrapperClassName = function () {
	        return "RAMLSimpleElementImpl";
	    };
	    return RAMLSimpleElementImpl;
	})(BasicNodeImpl);
	exports.RAMLSimpleElementImpl = RAMLSimpleElementImpl;
	var GlobalSchemaImpl = (function (_super) {
	    __extends(GlobalSchemaImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function GlobalSchemaImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createGlobalSchema(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    GlobalSchemaImpl.prototype.wrapperClassName = function () {
	        return "GlobalSchemaImpl";
	    };
	    /**
	     *
	     **/
	    //key
	    GlobalSchemaImpl.prototype.key = function () {
	        return _super.prototype.attribute.call(this, 'key', this.toString);
	    };
	    /**
	     *
	     **/
	    //setKey
	    GlobalSchemaImpl.prototype.setKey = function (param) {
	        {
	            this.highLevel().attrOrCreate("key").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //value
	    GlobalSchemaImpl.prototype.value = function () {
	        return _super.prototype.attribute.call(this, 'value', function (attr) { return new SchemaStringImpl(attr); });
	    };
	    return GlobalSchemaImpl;
	})(RAMLSimpleElementImpl);
	exports.GlobalSchemaImpl = GlobalSchemaImpl;
	var DocumentationItemImpl = (function (_super) {
	    __extends(DocumentationItemImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function DocumentationItemImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createDocumentationItem(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    DocumentationItemImpl.prototype.wrapperClassName = function () {
	        return "DocumentationItemImpl";
	    };
	    /**
	     *
	     **/
	    //title
	    DocumentationItemImpl.prototype.title = function () {
	        return _super.prototype.attribute.call(this, 'title', this.toString);
	    };
	    /**
	     *
	     **/
	    //setTitle
	    DocumentationItemImpl.prototype.setTitle = function (param) {
	        {
	            this.highLevel().attrOrCreate("title").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //content
	    DocumentationItemImpl.prototype.content = function () {
	        return _super.prototype.attribute.call(this, 'content', function (attr) { return new MarkdownStringImpl(attr); });
	    };
	    return DocumentationItemImpl;
	})(RAMLSimpleElementImpl);
	exports.DocumentationItemImpl = DocumentationItemImpl;
	var SecuritySchemaSettingsImpl = (function (_super) {
	    __extends(SecuritySchemaSettingsImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function SecuritySchemaSettingsImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createSecuritySchemaSettings(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    SecuritySchemaSettingsImpl.prototype.wrapperClassName = function () {
	        return "SecuritySchemaSettingsImpl";
	    };
	    return SecuritySchemaSettingsImpl;
	})(RAMLSimpleElementImpl);
	exports.SecuritySchemaSettingsImpl = SecuritySchemaSettingsImpl;
	var OAuth1SecuritySchemeSettingsImpl = (function (_super) {
	    __extends(OAuth1SecuritySchemeSettingsImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function OAuth1SecuritySchemeSettingsImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createOAuth1SecuritySchemeSettings(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    OAuth1SecuritySchemeSettingsImpl.prototype.wrapperClassName = function () {
	        return "OAuth1SecuritySchemeSettingsImpl";
	    };
	    /**
	     *
	     **/
	    //requestTokenUri
	    OAuth1SecuritySchemeSettingsImpl.prototype.requestTokenUri = function () {
	        return _super.prototype.attribute.call(this, 'requestTokenUri', function (attr) { return new FixedUriImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //authorizationUri
	    OAuth1SecuritySchemeSettingsImpl.prototype.authorizationUri = function () {
	        return _super.prototype.attribute.call(this, 'authorizationUri', function (attr) { return new FixedUriImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //tokenCredentialsUri
	    OAuth1SecuritySchemeSettingsImpl.prototype.tokenCredentialsUri = function () {
	        return _super.prototype.attribute.call(this, 'tokenCredentialsUri', function (attr) { return new FixedUriImpl(attr); });
	    };
	    return OAuth1SecuritySchemeSettingsImpl;
	})(SecuritySchemaSettingsImpl);
	exports.OAuth1SecuritySchemeSettingsImpl = OAuth1SecuritySchemeSettingsImpl;
	var OAuth2SecuritySchemeSettingsImpl = (function (_super) {
	    __extends(OAuth2SecuritySchemeSettingsImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function OAuth2SecuritySchemeSettingsImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createOAuth2SecuritySchemeSettings(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    OAuth2SecuritySchemeSettingsImpl.prototype.wrapperClassName = function () {
	        return "OAuth2SecuritySchemeSettingsImpl";
	    };
	    /**
	     *
	     **/
	    //accessTokenUri
	    OAuth2SecuritySchemeSettingsImpl.prototype.accessTokenUri = function () {
	        return _super.prototype.attribute.call(this, 'accessTokenUri', function (attr) { return new FixedUriImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //authorizationUri
	    OAuth2SecuritySchemeSettingsImpl.prototype.authorizationUri = function () {
	        return _super.prototype.attribute.call(this, 'authorizationUri', function (attr) { return new FixedUriImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //authorizationGrants
	    OAuth2SecuritySchemeSettingsImpl.prototype.authorizationGrants = function () {
	        return _super.prototype.attributes.call(this, 'authorizationGrants', this.toString);
	    };
	    /**
	     *
	     **/
	    //setAuthorizationGrants
	    OAuth2SecuritySchemeSettingsImpl.prototype.setAuthorizationGrants = function (param) {
	        {
	            this.highLevel().attrOrCreate("authorizationGrants").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //scopes
	    OAuth2SecuritySchemeSettingsImpl.prototype.scopes = function () {
	        return _super.prototype.attributes.call(this, 'scopes', this.toString);
	    };
	    /**
	     *
	     **/
	    //setScopes
	    OAuth2SecuritySchemeSettingsImpl.prototype.setScopes = function (param) {
	        {
	            this.highLevel().attrOrCreate("scopes").setValue("" + param);
	            return this;
	        }
	    };
	    return OAuth2SecuritySchemeSettingsImpl;
	})(SecuritySchemaSettingsImpl);
	exports.OAuth2SecuritySchemeSettingsImpl = OAuth2SecuritySchemeSettingsImpl;
	var SecuritySchemaPartImpl = (function (_super) {
	    __extends(SecuritySchemaPartImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function SecuritySchemaPartImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createSecuritySchemaPart(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    SecuritySchemaPartImpl.prototype.wrapperClassName = function () {
	        return "SecuritySchemaPartImpl";
	    };
	    return SecuritySchemaPartImpl;
	})(RAMLSimpleElementImpl);
	exports.SecuritySchemaPartImpl = SecuritySchemaPartImpl;
	var ResourceTypeImpl = (function (_super) {
	    __extends(ResourceTypeImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ResourceTypeImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createResourceType(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ResourceTypeImpl.prototype.wrapperClassName = function () {
	        return "ResourceTypeImpl";
	    };
	    /**
	     *
	     **/
	    //name
	    ResourceTypeImpl.prototype.name = function () {
	        return _super.prototype.attribute.call(this, 'name', this.toString);
	    };
	    /**
	     *
	     **/
	    //setName
	    ResourceTypeImpl.prototype.setName = function (param) {
	        {
	            this.highLevel().attrOrCreate("name").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //usage
	    ResourceTypeImpl.prototype.usage = function () {
	        return _super.prototype.attribute.call(this, 'usage', this.toString);
	    };
	    /**
	     *
	     **/
	    //setUsage
	    ResourceTypeImpl.prototype.setUsage = function (param) {
	        {
	            this.highLevel().attrOrCreate("usage").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //methods
	    ResourceTypeImpl.prototype.methods = function () {
	        return _super.prototype.elements.call(this, 'methods');
	    };
	    /**
	     *
	     **/
	    //is
	    ResourceTypeImpl.prototype.is = function () {
	        return _super.prototype.attributes.call(this, 'is', function (attr) { return new TraitRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //type
	    ResourceTypeImpl.prototype["type"] = function () {
	        return _super.prototype.attribute.call(this, 'type', function (attr) { return new ResourceTypeRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //securedBy
	    ResourceTypeImpl.prototype.securedBy = function () {
	        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemaRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //uriParameters
	    ResourceTypeImpl.prototype.uriParameters = function () {
	        return _super.prototype.elements.call(this, 'uriParameters');
	    };
	    return ResourceTypeImpl;
	})(RAMLLanguageElementImpl);
	exports.ResourceTypeImpl = ResourceTypeImpl;
	var HasNormalParametersImpl = (function (_super) {
	    __extends(HasNormalParametersImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function HasNormalParametersImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createHasNormalParameters(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    HasNormalParametersImpl.prototype.wrapperClassName = function () {
	        return "HasNormalParametersImpl";
	    };
	    /**
	     *
	     **/
	    //queryParameters
	    HasNormalParametersImpl.prototype.queryParameters = function () {
	        return _super.prototype.elements.call(this, 'queryParameters');
	    };
	    /**
	     *
	     **/
	    //displayName
	    HasNormalParametersImpl.prototype.displayName = function () {
	        return _super.prototype.attribute.call(this, 'displayName', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDisplayName
	    HasNormalParametersImpl.prototype.setDisplayName = function (param) {
	        {
	            this.highLevel().attrOrCreate("displayName").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //headers
	    HasNormalParametersImpl.prototype.headers = function () {
	        return _super.prototype.elements.call(this, 'headers');
	    };
	    return HasNormalParametersImpl;
	})(RAMLLanguageElementImpl);
	exports.HasNormalParametersImpl = HasNormalParametersImpl;
	var ParameterImpl = (function (_super) {
	    __extends(ParameterImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ParameterImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createParameter(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ParameterImpl.prototype.wrapperClassName = function () {
	        return "ParameterImpl";
	    };
	    /**
	     *
	     **/
	    //name
	    ParameterImpl.prototype.name = function () {
	        return _super.prototype.attribute.call(this, 'name', this.toString);
	    };
	    /**
	     *
	     **/
	    //setName
	    ParameterImpl.prototype.setName = function (param) {
	        {
	            this.highLevel().attrOrCreate("name").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //displayName
	    ParameterImpl.prototype.displayName = function () {
	        return _super.prototype.attribute.call(this, 'displayName', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDisplayName
	    ParameterImpl.prototype.setDisplayName = function (param) {
	        {
	            this.highLevel().attrOrCreate("displayName").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //type
	    ParameterImpl.prototype["type"] = function () {
	        return _super.prototype.attribute.call(this, 'type', this.toString);
	    };
	    /**
	     *
	     **/
	    //setType
	    ParameterImpl.prototype.setType = function (param) {
	        {
	            this.highLevel().attrOrCreate("type").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //location
	    ParameterImpl.prototype.location = function () {
	        return _super.prototype.attribute.call(this, 'location', function (attr) { return new ParameterLocationImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //required
	    ParameterImpl.prototype.required = function () {
	        return _super.prototype.attribute.call(this, 'required', this.toBoolean);
	    };
	    /**
	     *
	     **/
	    //setRequired
	    ParameterImpl.prototype.setRequired = function (param) {
	        {
	            this.highLevel().attrOrCreate("required").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //default
	    ParameterImpl.prototype["default"] = function () {
	        return _super.prototype.attribute.call(this, 'default', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDefault
	    ParameterImpl.prototype.setDefault = function (param) {
	        {
	            this.highLevel().attrOrCreate("default").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //example
	    ParameterImpl.prototype.example = function () {
	        return _super.prototype.attribute.call(this, 'example', this.toString);
	    };
	    /**
	     *
	     **/
	    //setExample
	    ParameterImpl.prototype.setExample = function (param) {
	        {
	            this.highLevel().attrOrCreate("example").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //repeat
	    ParameterImpl.prototype.repeat = function () {
	        return _super.prototype.attribute.call(this, 'repeat', this.toBoolean);
	    };
	    /**
	     *
	     **/
	    //setRepeat
	    ParameterImpl.prototype.setRepeat = function (param) {
	        {
	            this.highLevel().attrOrCreate("repeat").setValue("" + param);
	            return this;
	        }
	    };
	    return ParameterImpl;
	})(RAMLLanguageElementImpl);
	exports.ParameterImpl = ParameterImpl;
	var ParameterLocationImpl = (function () {
	    /**
	     *
	     **/
	    //constructor
	    function ParameterLocationImpl(attr) {
	        this.attr = attr;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ParameterLocationImpl.prototype.wrapperClassName = function () {
	        return "ParameterLocationImpl";
	    };
	    return ParameterLocationImpl;
	})();
	exports.ParameterLocationImpl = ParameterLocationImpl;
	var StrElementImpl = (function (_super) {
	    __extends(StrElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function StrElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createStrElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    StrElementImpl.prototype.wrapperClassName = function () {
	        return "StrElementImpl";
	    };
	    /**
	     *
	     **/
	    //pattern
	    StrElementImpl.prototype.pattern = function () {
	        return _super.prototype.attribute.call(this, 'pattern', this.toString);
	    };
	    /**
	     *
	     **/
	    //setPattern
	    StrElementImpl.prototype.setPattern = function (param) {
	        {
	            this.highLevel().attrOrCreate("pattern").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //enum
	    StrElementImpl.prototype.enum = function () {
	        return _super.prototype.attributes.call(this, 'enum', this.toString);
	    };
	    /**
	     *
	     **/
	    //setEnum
	    StrElementImpl.prototype.setEnum = function (param) {
	        {
	            this.highLevel().attrOrCreate("enum").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //minLength
	    StrElementImpl.prototype.minLength = function () {
	        return _super.prototype.attribute.call(this, 'minLength', this.toNumber);
	    };
	    /**
	     *
	     **/
	    //setMinLength
	    StrElementImpl.prototype.setMinLength = function (param) {
	        {
	            this.highLevel().attrOrCreate("minLength").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //maxLength
	    StrElementImpl.prototype.maxLength = function () {
	        return _super.prototype.attribute.call(this, 'maxLength', this.toNumber);
	    };
	    /**
	     *
	     **/
	    //setMaxLength
	    StrElementImpl.prototype.setMaxLength = function (param) {
	        {
	            this.highLevel().attrOrCreate("maxLength").setValue("" + param);
	            return this;
	        }
	    };
	    return StrElementImpl;
	})(ParameterImpl);
	exports.StrElementImpl = StrElementImpl;
	var BooleanElementImpl = (function (_super) {
	    __extends(BooleanElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function BooleanElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createBooleanElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    BooleanElementImpl.prototype.wrapperClassName = function () {
	        return "BooleanElementImpl";
	    };
	    return BooleanElementImpl;
	})(ParameterImpl);
	exports.BooleanElementImpl = BooleanElementImpl;
	var NumberElementImpl = (function (_super) {
	    __extends(NumberElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function NumberElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createNumberElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    NumberElementImpl.prototype.wrapperClassName = function () {
	        return "NumberElementImpl";
	    };
	    /**
	     *
	     **/
	    //minimum
	    NumberElementImpl.prototype.minimum = function () {
	        return _super.prototype.attribute.call(this, 'minimum', this.toNumber);
	    };
	    /**
	     *
	     **/
	    //setMinimum
	    NumberElementImpl.prototype.setMinimum = function (param) {
	        {
	            this.highLevel().attrOrCreate("minimum").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //maximum
	    NumberElementImpl.prototype.maximum = function () {
	        return _super.prototype.attribute.call(this, 'maximum', this.toNumber);
	    };
	    /**
	     *
	     **/
	    //setMaximum
	    NumberElementImpl.prototype.setMaximum = function (param) {
	        {
	            this.highLevel().attrOrCreate("maximum").setValue("" + param);
	            return this;
	        }
	    };
	    return NumberElementImpl;
	})(ParameterImpl);
	exports.NumberElementImpl = NumberElementImpl;
	var IntegerElementImpl = (function (_super) {
	    __extends(IntegerElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function IntegerElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createIntegerElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    IntegerElementImpl.prototype.wrapperClassName = function () {
	        return "IntegerElementImpl";
	    };
	    return IntegerElementImpl;
	})(NumberElementImpl);
	exports.IntegerElementImpl = IntegerElementImpl;
	var DateElementImpl = (function (_super) {
	    __extends(DateElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function DateElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createDateElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    DateElementImpl.prototype.wrapperClassName = function () {
	        return "DateElementImpl";
	    };
	    return DateElementImpl;
	})(ParameterImpl);
	exports.DateElementImpl = DateElementImpl;
	var FileElementImpl = (function (_super) {
	    __extends(FileElementImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function FileElementImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createFileElement(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    FileElementImpl.prototype.wrapperClassName = function () {
	        return "FileElementImpl";
	    };
	    return FileElementImpl;
	})(ParameterImpl);
	exports.FileElementImpl = FileElementImpl;
	var MethodBaseImpl = (function (_super) {
	    __extends(MethodBaseImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function MethodBaseImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createMethodBase(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    MethodBaseImpl.prototype.wrapperClassName = function () {
	        return "MethodBaseImpl";
	    };
	    /**
	     *
	     **/
	    //responses
	    MethodBaseImpl.prototype.responses = function () {
	        return _super.prototype.elements.call(this, 'responses');
	    };
	    /**
	     *
	     **/
	    //body
	    MethodBaseImpl.prototype.body = function () {
	        return _super.prototype.elements.call(this, 'body');
	    };
	    /**
	     *
	     **/
	    //is
	    MethodBaseImpl.prototype.is = function () {
	        return _super.prototype.attributes.call(this, 'is', function (attr) { return new TraitRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //securedBy
	    MethodBaseImpl.prototype.securedBy = function () {
	        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemaRefImpl(attr); });
	    };
	    return MethodBaseImpl;
	})(HasNormalParametersImpl);
	exports.MethodBaseImpl = MethodBaseImpl;
	var ResponseImpl = (function (_super) {
	    __extends(ResponseImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ResponseImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createResponse(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ResponseImpl.prototype.wrapperClassName = function () {
	        return "ResponseImpl";
	    };
	    /**
	     *
	     **/
	    //code
	    ResponseImpl.prototype.code = function () {
	        return _super.prototype.attribute.call(this, 'code', function (attr) { return new StatusCodeImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //headers
	    ResponseImpl.prototype.headers = function () {
	        return _super.prototype.elements.call(this, 'headers');
	    };
	    /**
	     *
	     **/
	    //body
	    ResponseImpl.prototype.body = function () {
	        return _super.prototype.elements.call(this, 'body');
	    };
	    return ResponseImpl;
	})(RAMLLanguageElementImpl);
	exports.ResponseImpl = ResponseImpl;
	var BodyLikeImpl = (function (_super) {
	    __extends(BodyLikeImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function BodyLikeImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createBodyLike(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    BodyLikeImpl.prototype.wrapperClassName = function () {
	        return "BodyLikeImpl";
	    };
	    /**
	     *
	     **/
	    //name
	    BodyLikeImpl.prototype.name = function () {
	        return _super.prototype.attribute.call(this, 'name', this.toString);
	    };
	    /**
	     *
	     **/
	    //setName
	    BodyLikeImpl.prototype.setName = function (param) {
	        {
	            this.highLevel().attrOrCreate("name").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //schema
	    BodyLikeImpl.prototype.schema = function () {
	        return _super.prototype.attribute.call(this, 'schema', function (attr) { return new SchemaStringImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //example
	    BodyLikeImpl.prototype.example = function () {
	        return _super.prototype.attribute.call(this, 'example', function (attr) { return new ExampleStringImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //formParameters
	    BodyLikeImpl.prototype.formParameters = function () {
	        return _super.prototype.elements.call(this, 'formParameters');
	    };
	    return BodyLikeImpl;
	})(RAMLLanguageElementImpl);
	exports.BodyLikeImpl = BodyLikeImpl;
	var XMLBodyImpl = (function (_super) {
	    __extends(XMLBodyImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function XMLBodyImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createXMLBody(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    XMLBodyImpl.prototype.wrapperClassName = function () {
	        return "XMLBodyImpl";
	    };
	    /**
	     *
	     **/
	    //schema
	    XMLBodyImpl.prototype.schema = function () {
	        return _super.prototype.attribute.call(this, 'schema', function (attr) { return new XMLSchemaStringImpl(attr); });
	    };
	    return XMLBodyImpl;
	})(BodyLikeImpl);
	exports.XMLBodyImpl = XMLBodyImpl;
	var JSONBodyImpl = (function (_super) {
	    __extends(JSONBodyImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function JSONBodyImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createJSONBody(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    JSONBodyImpl.prototype.wrapperClassName = function () {
	        return "JSONBodyImpl";
	    };
	    /**
	     *
	     **/
	    //schema
	    JSONBodyImpl.prototype.schema = function () {
	        return _super.prototype.attribute.call(this, 'schema', function (attr) { return new JSonSchemaStringImpl(attr); });
	    };
	    return JSONBodyImpl;
	})(BodyLikeImpl);
	exports.JSONBodyImpl = JSONBodyImpl;
	var TraitImpl = (function (_super) {
	    __extends(TraitImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function TraitImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createTrait(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    TraitImpl.prototype.wrapperClassName = function () {
	        return "TraitImpl";
	    };
	    /**
	     *
	     **/
	    //name
	    TraitImpl.prototype.name = function () {
	        return _super.prototype.attribute.call(this, 'name', this.toString);
	    };
	    /**
	     *
	     **/
	    //setName
	    TraitImpl.prototype.setName = function (param) {
	        {
	            this.highLevel().attrOrCreate("name").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //usage
	    TraitImpl.prototype.usage = function () {
	        return _super.prototype.attribute.call(this, 'usage', this.toString);
	    };
	    /**
	     *
	     **/
	    //setUsage
	    TraitImpl.prototype.setUsage = function (param) {
	        {
	            this.highLevel().attrOrCreate("usage").setValue("" + param);
	            return this;
	        }
	    };
	    return TraitImpl;
	})(MethodBaseImpl);
	exports.TraitImpl = TraitImpl;
	var MethodImpl = (function (_super) {
	    __extends(MethodImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function MethodImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createMethod(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    MethodImpl.prototype.wrapperClassName = function () {
	        return "MethodImpl";
	    };
	    /**
	     *
	     **/
	    //method
	    MethodImpl.prototype.method = function () {
	        return _super.prototype.attribute.call(this, 'method', this.toString);
	    };
	    /**
	     *
	     **/
	    //setMethod
	    MethodImpl.prototype.setMethod = function (param) {
	        {
	            this.highLevel().attrOrCreate("method").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //protocols
	    MethodImpl.prototype.protocols = function () {
	        return _super.prototype.attributes.call(this, 'protocols', this.toString);
	    };
	    /**
	     *
	     **/
	    //setProtocols
	    MethodImpl.prototype.setProtocols = function (param) {
	        {
	            this.highLevel().attrOrCreate("protocols").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //securedBy
	    MethodImpl.prototype.securedBy = function () {
	        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemaRefImpl(attr); });
	    };
	    return MethodImpl;
	})(MethodBaseImpl);
	exports.MethodImpl = MethodImpl;
	var ResourceImpl = (function (_super) {
	    __extends(ResourceImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ResourceImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createResource(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ResourceImpl.prototype.wrapperClassName = function () {
	        return "ResourceImpl";
	    };
	    /**
	     *
	     **/
	    //relativeUri
	    ResourceImpl.prototype.relativeUri = function () {
	        return _super.prototype.attribute.call(this, 'relativeUri', function (attr) { return new RelativeUriImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //type
	    ResourceImpl.prototype["type"] = function () {
	        return _super.prototype.attribute.call(this, 'type', function (attr) { return new ResourceTypeRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //is
	    ResourceImpl.prototype.is = function () {
	        return _super.prototype.attributes.call(this, 'is', function (attr) { return new TraitRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //securedBy
	    ResourceImpl.prototype.securedBy = function () {
	        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemaRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //uriParameters
	    ResourceImpl.prototype.uriParameters = function () {
	        return _super.prototype.elements.call(this, 'uriParameters');
	    };
	    /**
	     *
	     **/
	    //methods
	    ResourceImpl.prototype.methods = function () {
	        return _super.prototype.elements.call(this, 'methods');
	    };
	    /**
	     *
	     **/
	    //resources
	    ResourceImpl.prototype.resources = function () {
	        return _super.prototype.elements.call(this, 'resources');
	    };
	    /**
	     *
	     **/
	    //displayName
	    ResourceImpl.prototype.displayName = function () {
	        return _super.prototype.attribute.call(this, 'displayName', this.toString);
	    };
	    /**
	     *
	     **/
	    //setDisplayName
	    ResourceImpl.prototype.setDisplayName = function (param) {
	        {
	            this.highLevel().attrOrCreate("displayName").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //baseUriParameters
	    ResourceImpl.prototype.baseUriParameters = function () {
	        return _super.prototype.elements.call(this, 'baseUriParameters');
	    };
	    return ResourceImpl;
	})(RAMLLanguageElementImpl);
	exports.ResourceImpl = ResourceImpl;
	var ApiImpl = (function (_super) {
	    __extends(ApiImpl, _super);
	    /**
	     *
	     **/
	    //constructor
	    function ApiImpl(nodeOrKey) {
	        _super.call(this, (typeof nodeOrKey == "string") ? createApi(nodeOrKey) : nodeOrKey);
	        this.nodeOrKey = nodeOrKey;
	    }
	    /**
	     *
	     **/
	    //wrapperClassName
	    ApiImpl.prototype.wrapperClassName = function () {
	        return "ApiImpl";
	    };
	    /**
	     *
	     **/
	    //title
	    ApiImpl.prototype.title = function () {
	        return _super.prototype.attribute.call(this, 'title', this.toString);
	    };
	    /**
	     *
	     **/
	    //setTitle
	    ApiImpl.prototype.setTitle = function (param) {
	        {
	            this.highLevel().attrOrCreate("title").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //version
	    ApiImpl.prototype.version = function () {
	        return _super.prototype.attribute.call(this, 'version', this.toString);
	    };
	    /**
	     *
	     **/
	    //setVersion
	    ApiImpl.prototype.setVersion = function (param) {
	        {
	            this.highLevel().attrOrCreate("version").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //baseUri
	    ApiImpl.prototype.baseUri = function () {
	        return _super.prototype.attribute.call(this, 'baseUri', function (attr) { return new FullUriTemplateImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //baseUriParameters
	    ApiImpl.prototype.baseUriParameters = function () {
	        return _super.prototype.elements.call(this, 'baseUriParameters');
	    };
	    /**
	     *
	     **/
	    //uriParameters
	    ApiImpl.prototype.uriParameters = function () {
	        return _super.prototype.elements.call(this, 'uriParameters');
	    };
	    /**
	     *
	     **/
	    //protocols
	    ApiImpl.prototype.protocols = function () {
	        return _super.prototype.attributes.call(this, 'protocols', this.toString);
	    };
	    /**
	     *
	     **/
	    //setProtocols
	    ApiImpl.prototype.setProtocols = function (param) {
	        {
	            this.highLevel().attrOrCreate("protocols").setValue("" + param);
	            return this;
	        }
	    };
	    /**
	     *
	     **/
	    //mediaType
	    ApiImpl.prototype.mediaType = function () {
	        return _super.prototype.attribute.call(this, 'mediaType', function (attr) { return new MimeTypeImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //schemas
	    ApiImpl.prototype.schemas = function () {
	        return _super.prototype.elements.call(this, 'schemas');
	    };
	    /**
	     *
	     **/
	    //traits
	    ApiImpl.prototype.traits = function () {
	        return _super.prototype.elements.call(this, 'traits');
	    };
	    /**
	     *
	     **/
	    //securedBy
	    ApiImpl.prototype.securedBy = function () {
	        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemaRefImpl(attr); });
	    };
	    /**
	     *
	     **/
	    //securitySchemes
	    ApiImpl.prototype.securitySchemes = function () {
	        return _super.prototype.elements.call(this, 'securitySchemes');
	    };
	    /**
	     *
	     **/
	    //resourceTypes
	    ApiImpl.prototype.resourceTypes = function () {
	        return _super.prototype.elements.call(this, 'resourceTypes');
	    };
	    /**
	     *
	     **/
	    //resources
	    ApiImpl.prototype.resources = function () {
	        return _super.prototype.elements.call(this, 'resources');
	    };
	    /**
	     *
	     **/
	    //documentation
	    ApiImpl.prototype.documentation = function () {
	        return _super.prototype.elements.call(this, 'documentation');
	    };
	    return ApiImpl;
	})(RAMLLanguageElementImpl);
	exports.ApiImpl = ApiImpl;
	function createApi(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Api");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createRAMLLanguageElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("RAMLLanguageElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createSecuritySchema(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("SecuritySchema");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createSecuritySchemaPart(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("SecuritySchemaPart");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createRAMLSimpleElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("RAMLSimpleElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createGlobalSchema(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("GlobalSchema");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createDocumentationItem(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("DocumentationItem");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createSecuritySchemaSettings(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("SecuritySchemaSettings");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createOAuth1SecuritySchemeSettings(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("OAuth1SecuritySchemeSettings");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createOAuth2SecuritySchemeSettings(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("OAuth2SecuritySchemeSettings");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createResourceType(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("ResourceType");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createMethod(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Method");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createMethodBase(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("MethodBase");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createHasNormalParameters(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("HasNormalParameters");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createParameter(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Parameter");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createStrElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("StrElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createBooleanElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("BooleanElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createNumberElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("NumberElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createIntegerElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("IntegerElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createDateElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("DateElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createFileElement(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("FileElement");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createResponse(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Response");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createBodyLike(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("BodyLike");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createXMLBody(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("XMLBody");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createJSONBody(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("JSONBody");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createTrait(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Trait");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	function createResource(key) {
	    var universe = hl.universeProvider("RAML10");
	    var nc = universe.getType("Resource");
	    var node = nc.createStubNode(null, key);
	    return node;
	}
	//# sourceMappingURL=raml08parser.js.map

/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

	var ramlPathMatch = __webpack_require__(53);
	var hl = __webpack_require__(17);
	var hlimpl = __webpack_require__(7);
	var Opt = __webpack_require__(5);
	var util = __webpack_require__(20);
	var typeexpression = __webpack_require__(34);
	var search = __webpack_require__(35);
	var ll = __webpack_require__(6);
	var path = __webpack_require__(11);
	function resolveType(p) {
	    var tpe = typeexpression.typeFromNode(p.highLevel());
	    return tpe.toRuntime();
	}
	exports.resolveType = resolveType;
	function load(pth) {
	    var m = new ll.Project(path.dirname(pth));
	    var unit = m.unit(path.basename(pth));
	    if (unit) {
	        if (unit.isRAMLUnit()) {
	            return hl.fromUnit(unit).wrapperNode();
	        }
	    }
	    return null;
	}
	exports.load = load;
	function completeRelativeUri(res) {
	    var uri = '';
	    var parent = res;
	    do {
	        res = parent; //(parent instanceof RamlWrapper.ResourceImpl) ? <RamlWrapper.Resource>parent : null;
	        uri = res.relativeUri().value() + uri;
	        parent = res.parent();
	    } while (parent['relativeUri']);
	    return uri;
	}
	exports.completeRelativeUri = completeRelativeUri;
	function absoluteUri(res) {
	    var uri = '';
	    var parent = res;
	    do {
	        res = parent; //(parent instanceof RamlWrapper.ResourceImpl) ? <RamlWrapper.Resource>parent : null;
	        uri = res.relativeUri().value() + uri;
	        parent = res.parent();
	    } while (parent['relativeUri']);
	    uri = uri.replace(/\/\//g, '/');
	    var buri = parent.baseUri();
	    var base = buri ? buri.value() : "";
	    base = base ? base : '';
	    if (util.stringEndsWith(base, '/')) {
	        uri = uri.substring(1);
	    }
	    uri = base + uri;
	    return uri;
	}
	exports.absoluteUri = absoluteUri;
	function qName(c) {
	    return hlimpl.qName(c.highLevel(), c.highLevel().root());
	}
	exports.qName = qName;
	function allTraits(a) {
	    return search.globalDeclarations(a.highLevel()).filter(function (x) { return x.definition().name() == "Trait"; }).map(function (x) { return x.wrapperNode(); });
	}
	exports.allTraits = allTraits;
	function allResourceTypes(a) {
	    return search.globalDeclarations(a.highLevel()).filter(function (x) { return x.definition().name() == "ResourceType"; }).map(function (x) { return x.wrapperNode(); });
	}
	exports.allResourceTypes = allResourceTypes;
	function relativeUriSegments(res) {
	    var result = [];
	    var parent = res;
	    do {
	        res = parent; //(parent instanceof RamlWrapper.ResourceImpl) ? <RamlWrapper.Resource>parent : null;
	        result.push(res.relativeUri().value());
	        parent = res.parent();
	    } while (parent['relativeUri']);
	    return result.reverse();
	}
	exports.relativeUriSegments = relativeUriSegments;
	function parentResource(method) {
	    return method.parent();
	}
	exports.parentResource = parentResource;
	function parent(resource) {
	    var parent = resource.parent();
	    if (isApi(parent)) {
	        return Opt.empty();
	    }
	    return new Opt(parent);
	}
	exports.parent = parent;
	function getChildResource(container, relPath) {
	    if (container == null) {
	        return Opt.empty();
	    }
	    var resources = container.resources();
	    if (!resources) {
	        return Opt.empty();
	    }
	    resources = resources.filter(function (x) { return x.relativeUri().value() == relPath; });
	    if (resources.length == 0) {
	        return Opt.empty();
	    }
	    return new Opt(resources[0]);
	}
	exports.getChildResource = getChildResource;
	function getResource(container, path) {
	    if (!container) {
	        return null;
	    }
	    var opt = Opt.empty();
	    for (var i = 0; i < path.length; i++) {
	        opt = getChildResource(container, path[i]);
	        if (!opt.isDefined()) {
	            return opt;
	        }
	        container = opt.getOrThrow();
	    }
	    return opt;
	}
	exports.getResource = getResource;
	function getChildMethod(resource, method) {
	    if (!resource) {
	        return null;
	    }
	    return resource.methods().filter(function (x) { return x.method() == method; });
	}
	exports.getChildMethod = getChildMethod;
	function getMethod(container, path, method) {
	    var resource = getResource(container, path);
	    return getChildMethod(resource.getOrElse(null), method);
	}
	exports.getMethod = getMethod;
	function isApi(obj) {
	    return (obj['title'] && obj['version'] && obj['baseUri']);
	}
	;
	function ownerApi(method) {
	    var obj = method;
	    while (!isApi(obj)) {
	        obj = obj.parent();
	    }
	    return obj;
	}
	exports.ownerApi = ownerApi;
	function methodId(method) {
	    return completeRelativeUri(parentResource(method)) + ' ' + method.method().toLowerCase();
	}
	exports.methodId = methodId;
	function isOkRange(response) {
	    return parseInt(response.code().value()) < 400;
	}
	exports.isOkRange = isOkRange;
	function allResources(api) {
	    var resources = [];
	    var visitor = function (res) {
	        resources.push(res);
	        res.resources().forEach(function (x) { return visitor(x); });
	    };
	    api.resources().forEach(function (x) { return visitor(x); });
	    return resources;
	}
	exports.allResources = allResources;
	function matchUri(apiRootRelativeUri, resource) {
	    var allParameters = {};
	    var opt = new Opt(resource);
	    while (opt.isDefined()) {
	        var res = opt.getOrThrow();
	        uriParameters(res).forEach(function (x) { return allParameters[x.name()] = new ParamWrapper(x); });
	        opt = parent(res);
	    }
	    var result = ramlPathMatch(completeRelativeUri(resource), allParameters, {})(apiRootRelativeUri);
	    if (result) {
	        return new Opt(Object.keys(result.params).map(function (x) { return new ParamValue(x, result['params'][x]); }));
	    }
	    return Opt.empty();
	}
	exports.matchUri = matchUri;
	var schemaContentChars = ['{', '<'];
	function schema(body, api) {
	    var schemaNode = body.schema();
	    if (!schemaNode) {
	        return Opt.empty();
	    }
	    var schemaString = schemaNode;
	    var isContent = false;
	    schemaContentChars.forEach(function (x) {
	        try {
	            isContent = isContent || schemaString.indexOf(x) >= 0;
	        }
	        catch (e) {
	        }
	    });
	    var schDef;
	    if (isContent) {
	        schDef = new SchemaDef(schemaString);
	    }
	    else {
	        var globalSchemes = api.schemas().filter(function (x) { return x.key() == schemaString; });
	        if (globalSchemes.length > 0) {
	            schDef = new SchemaDef(globalSchemes[0].value().value(), globalSchemes[0].key());
	        }
	        else {
	            return Opt.empty();
	        }
	    }
	    return new Opt(schDef);
	}
	exports.schema = schema;
	function uriParameters(resource) {
	    var uri = resource.relativeUri().value();
	    var params = resource.uriParameters();
	    return extractParams(params, uri, resource);
	}
	exports.uriParameters = uriParameters;
	function baseUriParameters(api) {
	    var uri = api.baseUri() ? api.baseUri().value() : '';
	    var params = api.baseUriParameters();
	    return extractParams(params, uri, api);
	}
	exports.baseUriParameters = baseUriParameters;
	function absoluteUriParameters(res) {
	    var params = [];
	    var parent = res;
	    do {
	        res = parent;
	        var uri = res.relativeUri().value();
	        var uriParams = res.uriParameters();
	        params = extractParams(uriParams, uri, res).concat(params);
	        parent = res.parent();
	    } while (parent['relativeUri']);
	    var api = parent;
	    var baseUri = api.baseUri().value();
	    var baseUriParams = api.baseUriParameters();
	    params = extractParams(baseUriParams, baseUri, api).concat(params);
	    return params;
	}
	exports.absoluteUriParameters = absoluteUriParameters;
	function extractParams(params, uri, resource) {
	    if (!uri) {
	        return [];
	    }
	    var describedParams = {};
	    params.forEach(function (x) { return describedParams[x.name()] = x; });
	    var allParams = [];
	    var prev = 0;
	    for (var i = uri.indexOf('{'); i >= 0; i = uri.indexOf('{', prev)) {
	        prev = uri.indexOf('}', ++i);
	        var paramName = uri.substring(i, prev);
	        if (describedParams[paramName]) {
	            allParams.push(describedParams[paramName]);
	        }
	        else {
	            allParams.push(new HelperUriParam(paramName, resource));
	        }
	    }
	    return allParams;
	}
	;
	var HelperUriParam = (function () {
	    function HelperUriParam(_name, _parent) {
	        this._name = _name;
	        this._parent = _parent;
	    }
	    HelperUriParam.prototype.wrapperClassName = function () {
	        return "HelperUriParam";
	    };
	    HelperUriParam.prototype.name = function () {
	        return this._name;
	    };
	    HelperUriParam.prototype["type"] = function () {
	        return ["string"];
	    };
	    HelperUriParam.prototype.location = function () {
	        return { wrapperClassName: function () { return "HelperModelLocation"; } };
	    };
	    HelperUriParam.prototype.locationKind = function () {
	        return { wrapperClassName: function () { return "HelperLocationKind"; } };
	    };
	    HelperUriParam.prototype["default"] = function () {
	        return null;
	    };
	    HelperUriParam.prototype.xml = function () {
	        return null;
	    };
	    HelperUriParam.prototype.sendDefaultByClient = function () {
	        return false;
	    };
	    HelperUriParam.prototype.example = function () {
	        return '';
	    };
	    HelperUriParam.prototype.schema = function () {
	        return null;
	    };
	    HelperUriParam.prototype.formParameters = function () {
	        return [];
	    };
	    HelperUriParam.prototype.examples = function () {
	        return [];
	    };
	    HelperUriParam.prototype.repeat = function () {
	        return false;
	    };
	    HelperUriParam.prototype.enum = function () {
	        return [];
	    };
	    HelperUriParam.prototype.collectionFormat = function () {
	        return 'multi';
	    };
	    HelperUriParam.prototype.required = function () {
	        return true;
	    };
	    HelperUriParam.prototype.readOnly = function () {
	        return false;
	    };
	    HelperUriParam.prototype.facets = function () {
	        return [];
	    };
	    HelperUriParam.prototype.scope = function () {
	        return [];
	    };
	    //xml(  ):RamlWrapper.XMLInfo{ return null; }
	    HelperUriParam.prototype.validWhen = function () {
	        return null;
	    };
	    HelperUriParam.prototype.requiredWhen = function () {
	        return null;
	    };
	    HelperUriParam.prototype.displayName = function () {
	        return this._name;
	    };
	    HelperUriParam.prototype.description = function () {
	        return null;
	    };
	    HelperUriParam.prototype.annotations = function () {
	        return [];
	    };
	    HelperUriParam.prototype.usage = function () {
	        return null;
	    };
	    HelperUriParam.prototype.parent = function () {
	        return this._parent;
	    };
	    HelperUriParam.prototype.highLevel = function () {
	        return null;
	    };
	    HelperUriParam.prototype.errors = function () {
	        return [];
	    };
	    return HelperUriParam;
	})();
	exports.HelperUriParam = HelperUriParam;
	var SchemaDef = (function () {
	    function SchemaDef(_content, _name) {
	        this._content = _content;
	        this._name = _name;
	    }
	    SchemaDef.prototype.name = function () {
	        return this._name;
	    };
	    SchemaDef.prototype.content = function () {
	        return this._content;
	    };
	    return SchemaDef;
	})();
	exports.SchemaDef = SchemaDef;
	var ParamValue = (function () {
	    function ParamValue(key, value) {
	        this.key = key;
	        this.value = value;
	    }
	    return ParamValue;
	})();
	exports.ParamValue = ParamValue;
	var ParamWrapper = (function () {
	    function ParamWrapper(_param) {
	        this._param = _param;
	        this.description = _param.description() ? _param.description().value() : this.description;
	        this.displayName = _param.displayName();
	        //        this.enum = _param.enum();
	        this.type = _param.type().length > 0 ? _param.type()[0] : "string";
	        this.example = _param.example();
	        this.repeat = _param.repeat();
	        this.required = _param.required();
	        this.default = _param.default();
	    }
	    return ParamWrapper;
	})();
	//# sourceMappingURL=wrapperHelper.js.map

/***/ },
/* 16 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../typings/tsd.d.ts" />
	var hl = __webpack_require__(17);
	var hlImpl = __webpack_require__(7);
	var typeExpr = __webpack_require__(31);
	var ramlSignatureParser = __webpack_require__(52);
	var wrapper = __webpack_require__(3);
	function validate(s, node, cb) {
	    var result = ramlSignatureParser.parse(s);
	    if (result.args) {
	        result.args.forEach(function (x) {
	            var ind = x.name.indexOf(".");
	            if (ind == -1) {
	                if (x.name != "body") {
	                    cb.accept(hlImpl.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Only body parameter may be not qualified", node, false));
	                }
	            }
	            else {
	                var qualifier = x.name.substring(0, ind);
	                if (qualifier != "uri" && qualifier != 'header' && qualifier != 'query') {
	                    cb.accept(hlImpl.createIssue(7 /* INVALID_VALUE_SCHEMA */, "qualifer should be one of 'query', 'header' or 'uri'", node, false));
	                }
	            }
	            typeExpr.validateNode(x.type, node, cb);
	        });
	    }
	    if (result.returnType) {
	        typeExpr.validateNode(result.returnType, node, cb);
	    }
	}
	exports.validate = validate;
	function convertToTrait(s, defaultCode) {
	    if (defaultCode === void 0) { defaultCode = "200"; }
	    var trait = new wrapper.TraitImpl("tr");
	    s.args.forEach(function (x) {
	        convertArgument(trait, x);
	    });
	    if (s.returnType) {
	        if (s.returnType.type == "responses") {
	            var rsc = s.returnType;
	            rsc.codes.forEach(function (x) {
	                var rs = new wrapper.ResponseImpl(x.code);
	                var da = new wrapper.DataElementImpl("application/json");
	                da.setType(typeExpr.nodeToString(x.expr));
	                rs.add(da);
	                trait.add(rs);
	            });
	        }
	        else {
	            var rs = new wrapper.ResponseImpl(defaultCode);
	            var da = new wrapper.DataElementImpl("application/json");
	            da.setType(typeExpr.nodeToString(s.returnType));
	            rs.add(da);
	            trait.add(rs);
	        }
	    }
	    return trait;
	}
	exports.convertToTrait = convertToTrait;
	function convertArgument(tr, arg) {
	    //hlimpl.createMethodStub()
	    var dot = arg.name.indexOf(".");
	    var type = null;
	    var aName = arg.name;
	    if (dot != -1) {
	        type = arg.name.substr(0, dot);
	        aName = arg.name.substr(dot + 1);
	    }
	    var c = new wrapper.DataElementImpl(aName);
	    if (aName == "body") {
	        c = new wrapper.DataElementImpl("application/json");
	    }
	    c.setType(typeExpr.nodeToString(arg.type));
	    if (type == "query") {
	        tr.addToProp(c, "queryParameters");
	    }
	    else if (type == "header") {
	        tr.addToProp(c, "headers");
	    }
	    else if (type == "uri") {
	        tr.addToProp(c, "uriParameters");
	    }
	    else if (type == "body") {
	        tr.addToProp(c, "body");
	    }
	    else {
	        if (aName == "body") {
	            tr.addToProp(c, "body");
	        }
	    }
	    return c;
	}
	function parse(node) {
	    try {
	        if (typeof node.value() == "string") {
	            var result = ramlSignatureParser.parse(node.value());
	            return result;
	        }
	    }
	    catch (e) {
	        return null;
	    }
	}
	exports.parse = parse;
	//# sourceMappingURL=ramlSignature.js.map

/***/ },
/* 17 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../typings/tsd.d.ts" />
	var ds = __webpack_require__(21);
	(function (NodeKind) {
	    NodeKind[NodeKind["BASIC"] = 0] = "BASIC";
	    NodeKind[NodeKind["NODE"] = 1] = "NODE";
	    NodeKind[NodeKind["ATTRIBUTE"] = 2] = "ATTRIBUTE";
	})(exports.NodeKind || (exports.NodeKind = {}));
	var NodeKind = exports.NodeKind;
	(function (IssueCode) {
	    IssueCode[IssueCode["UNRESOLVED_REFERENCE"] = 0] = "UNRESOLVED_REFERENCE";
	    IssueCode[IssueCode["YAML_ERROR"] = 1] = "YAML_ERROR";
	    IssueCode[IssueCode["UNKNOWN_NODE"] = 2] = "UNKNOWN_NODE";
	    IssueCode[IssueCode["MISSING_REQUIRED_PROPERTY"] = 3] = "MISSING_REQUIRED_PROPERTY";
	    IssueCode[IssueCode["PROPERTY_EXPECT_TO_HAVE_SINGLE_VALUE"] = 4] = "PROPERTY_EXPECT_TO_HAVE_SINGLE_VALUE";
	    //TODO IMPLEMENT
	    IssueCode[IssueCode["KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT"] = 5] = "KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT";
	    IssueCode[IssueCode["UNABLE_TO_RESOLVE_INCLUDE_FILE"] = 6] = "UNABLE_TO_RESOLVE_INCLUDE_FILE";
	    IssueCode[IssueCode["INVALID_VALUE_SCHEMA"] = 7] = "INVALID_VALUE_SCHEMA";
	    IssueCode[IssueCode["MISSED_CONTEXT_REQUIREMENT"] = 8] = "MISSED_CONTEXT_REQUIREMENT";
	    IssueCode[IssueCode["NODE_HAS_VALUE"] = 9] = "NODE_HAS_VALUE";
	    IssueCode[IssueCode["ONLY_OVERRIDE_ALLOWED"] = 10] = "ONLY_OVERRIDE_ALLOWED";
	})(exports.IssueCode || (exports.IssueCode = {}));
	var IssueCode = exports.IssueCode;
	;
	var Problem = (function () {
	    function Problem() {
	        this.code = 0;
	    }
	    Problem.prototype.isOk = function () {
	        return this.code == 0;
	    };
	    return Problem;
	})();
	exports.Problem = Problem;
	function ast2Object(node) {
	    var result = {};
	    node.attrs().forEach(function (x) {
	        result[x.property().name()] = x.value();
	    });
	    node.elements().forEach(function (x) {
	        var m = result[x.property().name()];
	        if (Array.isArray(m)) {
	            m.push(ast2Object(x));
	        }
	        result[x.property().name()] = x.property().isMultiValue() ? [ast2Object(x)] : ast2Object(x);
	    });
	    return result;
	}
	exports.ast2Object = ast2Object;
	exports.universeProvider = __webpack_require__(10);
	var hlImpl = __webpack_require__(7);
	exports.getDefinitionSystemType = function (contents, ast) {
	    var spec = "";
	    var ptype = "Api";
	    var num = 0;
	    var pt = 0;
	    for (var n = 0; n < contents.length; n++) {
	        var c = contents.charAt(n);
	        if (c == '\r' || c == '\n') {
	            if (spec) {
	                ptype = contents.substring(pt, n).trim();
	            }
	            else {
	                spec = contents.substring(0, n).trim();
	            }
	            break;
	        }
	        if (c == ' ') {
	            num++;
	            if (!spec && num == 2) {
	                spec = contents.substring(0, n);
	                pt = n;
	            }
	        }
	    }
	    var localUniverse = spec == "#%RAML 1.0" ? new ds.Universe("RAML10", exports.universeProvider("RAML10"), "RAML10") : new ds.Universe("RAML08", exports.universeProvider("RAML08"));
	    if (ast) {
	        if (ast.children().filter(function (x) { return x.key() == "swagger"; }).length > 0) {
	            localUniverse = new ds.Universe("Swagger", exports.universeProvider("Swagger2"), "Swagger");
	            ptype = "SwaggerObject";
	        }
	    }
	    if (ptype == 'API') {
	        ptype = "Api";
	    }
	    if (ptype == 'NamedExample') {
	        ptype = "ExampleSpec";
	    }
	    if (ptype == 'DataType') {
	        ptype = "DataElement";
	    }
	    if (ptype == 'SecurityScheme') {
	        ptype = "SecuritySchema";
	    }
	    localUniverse.setTopLevel(ptype);
	    localUniverse.setTypedVersion(spec);
	    // localUniverse.setDescription(spec);
	    return { ptype: ptype, localUniverse: localUniverse };
	};
	function fromUnit(l) {
	    if (l == null)
	        return null;
	    var contents = l.contents();
	    var ast = l.ast();
	    var __ret = exports.getDefinitionSystemType(contents, ast);
	    var ptype = __ret.ptype;
	    var localUniverse = __ret.localUniverse;
	    var apiType = localUniverse.type(ptype);
	    if (!apiType)
	        apiType = localUniverse.type("Api");
	    var api = new hlImpl.ASTNodeImpl(ast, null, apiType, null);
	    api.setUniverse(localUniverse);
	    return api;
	}
	exports.fromUnit = fromUnit;
	function globalId(h) {
	    if (h.parent()) {
	        return globalId(h.parent()) + "/" + h.localId();
	    }
	}
	exports.globalId = globalId;
	function nodeAtPosition(h, position) {
	    var ch = h.children();
	    var len = ch.length;
	    var res = null;
	    for (var num = 0; num < len; num++) {
	        var cn = ch[num];
	        if (cn.lowLevel().start() > position) {
	            break;
	        }
	        if (cn.lowLevel().end() < position) {
	            continue;
	        }
	        var nm = nodeAtPosition(cn, position);
	        if (nm != null) {
	            return nm;
	        }
	        return cn;
	    }
	}
	exports.nodeAtPosition = nodeAtPosition;
	/**
	 * Shortcut for checking node type
	 * @param node
	 */
	function kindBasic(node) {
	    return node.getKind() == 0 /* BASIC */;
	}
	exports.kindBasic = kindBasic;
	/**
	 * Shortcut for checking node type
	 * @param node
	 */
	function kindAttribute(node) {
	    return node.getKind() == 2 /* ATTRIBUTE */;
	}
	exports.kindAttribute = kindAttribute;
	/**
	 * Shortcut for checking node type
	 * @param node
	 */
	function kindNode(node) {
	    return node.getKind() == 1 /* NODE */;
	}
	exports.kindNode = kindNode;
	function isResourceNode(node) {
	    return kindNode(node) && node.definition && node.definition().name() == "Resource";
	}
	exports.isResourceNode = isResourceNode;
	function isResourceWithSignature(node) {
	    if (!isResourceNode(node)) {
	        return false;
	    }
	    var hNode = node;
	    var uriAttribute = hNode.attr("relativeUri");
	    if (uriAttribute && uriAttribute.value() && typeof uriAttribute.value() == "string" && uriAttribute.value().indexOf(".") >= 0) {
	        var signature = hNode.attrValue("signature");
	        if (!signature)
	            return false;
	        if (typeof signature == "string" && signature.length == 0)
	            return false;
	        return true;
	    }
	    return false;
	}
	exports.isResourceWithSignature = isResourceWithSignature;
	function isRAML10(node) {
	    var text = node.lowLevel().unit().contents();
	    return text.indexOf("#%RAML 1.0") >= 0;
	}
	exports.isRAML10 = isRAML10;
	function isRAML08(node) {
	    var text = node.lowLevel().unit().contents();
	    return text.indexOf("#%RAML 0.8") >= 0;
	}
	exports.isRAML08 = isRAML08;
	/**
	 * Shortcut for checking node type and getting it as attribute
	 * Returns null for non-attributes
	 * @param node
	 */
	function asAttribute(node) {
	    if (!node.getKind) {
	        return null;
	    }
	    if (node.getKind() != 2 /* ATTRIBUTE */) {
	        return null;
	    }
	    return node;
	}
	exports.asAttribute = asAttribute;
	/**
	 * Shortcut for checking node type
	 * @param node
	 */
	function asNode(node) {
	    if (!node.getKind) {
	        return null;
	    }
	    if (node.getKind() != 1 /* NODE */) {
	        return null;
	    }
	    return node;
	}
	exports.asNode = asNode;
	/**
	 * Checks if specified node is library
	 * @param node
	 * @returns {IHighLevelNode|boolean}
	 */
	function isLibrary(node) {
	    return asNode(node) && asNode(node).definition().name() == "Library";
	}
	exports.isLibrary = isLibrary;
	/**
	 * Check is specified node is library and returns library name. Returns null otherwise.
	 * @param node
	 * @returns {any}
	 */
	function getLibraryName(node) {
	    if (!isLibrary(node)) {
	        return null;
	    }
	    return asNode(node).attrValue("name");
	}
	exports.getLibraryName = getLibraryName;
	//# sourceMappingURL=highLevelAST.js.map

/***/ },
/* 18 */
/***/ function(module, exports, __webpack_require__) {

	var hlImpl = __webpack_require__(7);
	var jsyaml = __webpack_require__(6);
	var BasicSuperNodeImpl = (function () {
	    function BasicSuperNodeImpl(_node) {
	        this._node = _node;
	        _node.setWrapperNode(this);
	    }
	    BasicSuperNodeImpl.prototype.wrapperClassName = function () {
	        return 'BasicSuperNodeImpl';
	    };
	    BasicSuperNodeImpl.prototype.parent = function () {
	        var parent = this._node.parent();
	        return parent ? parent.wrapperNode() : null;
	    };
	    BasicSuperNodeImpl.prototype.highLevel = function () {
	        return this._node;
	    };
	    BasicSuperNodeImpl.prototype.attributes = function (name, constr) {
	        var attrs = this._node.attributes(name);
	        if (!attrs) {
	            return null;
	        }
	        if (constr) {
	            return attrs.map(function (x) { return constr(x); });
	        }
	        else {
	            return attrs.map(function (x) { return x.value(); });
	        }
	    };
	    BasicSuperNodeImpl.prototype.attribute = function (name, constr) {
	        var attr = this._node.attr(name);
	        if (!attr) {
	            return null;
	        }
	        if (constr) {
	            return constr(attr);
	        }
	        else {
	            return attr.value();
	        }
	    };
	    BasicSuperNodeImpl.prototype.elements = function (name) {
	        var elements = this._node.elementsOfKind(name);
	        if (!elements) {
	            return null;
	        }
	        return elements.map(function (x) { return x.wrapperNode(); });
	    };
	    BasicSuperNodeImpl.prototype.element = function (name) {
	        var element = this._node.element(name);
	        if (!element) {
	            return null;
	        }
	        return element.wrapperNode();
	    };
	    BasicSuperNodeImpl.prototype.add = function (node) {
	        this.highLevel().add(node.highLevel());
	    };
	    BasicSuperNodeImpl.prototype.addToProp = function (node, prop) {
	        var hl = node.highLevel();
	        var pr = this.highLevel().definition().property(prop);
	        hl._prop = pr;
	        this.highLevel().add(hl);
	    };
	    BasicSuperNodeImpl.prototype.remove = function (node) {
	        this.highLevel().remove(node.highLevel());
	    };
	    BasicSuperNodeImpl.prototype.dump = function () {
	        return this.highLevel().dump("yaml");
	    };
	    BasicSuperNodeImpl.prototype.toString = function (attr) {
	        var obj = attr.value();
	        return obj != null ? obj.toString() : obj;
	    };
	    BasicSuperNodeImpl.prototype.toBoolean = function (attr) {
	        var obj = attr.value();
	        return obj != null ? obj.toString() == 'true' : obj;
	    };
	    BasicSuperNodeImpl.prototype.toNumber = function (attr) {
	        var obj = attr.value();
	        if (!obj) {
	            return obj;
	        }
	        try {
	            var nValue = parseFloat(obj.toString());
	            return nValue;
	        }
	        catch (e) {
	        }
	        return Number.MAX_VALUE;
	    };
	    BasicSuperNodeImpl.prototype.errors = function () {
	        var result = [].concat(this._node.errors());
	        this._node.attrs().forEach(function (x) { return result = result.concat(x.errors()); });
	        return result;
	    };
	    return BasicSuperNodeImpl;
	})();
	exports.BasicSuperNodeImpl = BasicSuperNodeImpl;
	function toStructuredValue(node) {
	    var value = node.value();
	    if (typeof value === 'string') {
	        var mockNode = jsyaml.createNode(value.toString());
	        mockNode._actualNode().startPosition = node.lowLevel().valueStart();
	        mockNode._actualNode().endPosition = node.lowLevel().valueEnd();
	        var stv = new hlImpl.StructuredValue(mockNode, node.parent(), node.property());
	        return stv;
	    }
	    else {
	        return value;
	    }
	}
	exports.toStructuredValue = toStructuredValue;
	//# sourceMappingURL=parserCore.js.map

/***/ },
/* 19 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../../typings/tsd.d.ts" />
	(function (Kind) {
	    Kind[Kind["SCALAR"] = 0] = "SCALAR";
	    Kind[Kind["MAPPING"] = 1] = "MAPPING";
	    Kind[Kind["MAP"] = 2] = "MAP";
	    Kind[Kind["SEQ"] = 3] = "SEQ";
	    Kind[Kind["ANCHOR_REF"] = 4] = "ANCHOR_REF";
	    Kind[Kind["INCLUDE_REF"] = 5] = "INCLUDE_REF";
	})(exports.Kind || (exports.Kind = {}));
	var Kind = exports.Kind;
	function newMapping(key, value) {
	    var end = (value ? value.endPosition : key.endPosition + 1); //FIXME.workaround, end should be defied by position of ':'
	    //console.log('key: ' + key.value + ' ' + key.startPosition + '..' + key.endPosition + ' ' + value + ' end: ' + end);
	    var node = {
	        key: key,
	        value: value,
	        startPosition: key.startPosition,
	        endPosition: end,
	        kind: 1 /* MAPPING */,
	        parent: null,
	        errors: []
	    };
	    return node;
	}
	exports.newMapping = newMapping;
	function newAnchorRef(key, start, end, value) {
	    return {
	        errors: [],
	        referencesAnchor: key,
	        value: value,
	        startPosition: start,
	        endPosition: end,
	        kind: 4 /* ANCHOR_REF */,
	        parent: null
	    };
	}
	exports.newAnchorRef = newAnchorRef;
	function newScalar(v) {
	    if (v === void 0) { v = ""; }
	    return {
	        errors: [],
	        startPosition: -1,
	        endPosition: -1,
	        value: v,
	        kind: 0 /* SCALAR */,
	        parent: null,
	        doubleQuoted: false
	    };
	}
	exports.newScalar = newScalar;
	function newItems() {
	    return {
	        errors: [],
	        startPosition: -1,
	        endPosition: -1,
	        items: [],
	        kind: 3 /* SEQ */,
	        parent: null
	    };
	}
	exports.newItems = newItems;
	function newSeq() {
	    return newItems();
	}
	exports.newSeq = newSeq;
	function newMap(mappings) {
	    return {
	        errors: [],
	        startPosition: -1,
	        endPosition: -1,
	        mappings: mappings ? mappings : [],
	        kind: 2 /* MAP */,
	        parent: null
	    };
	}
	exports.newMap = newMap;
	//# sourceMappingURL=yamlAST.js.map

/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../typings/tsd.d.ts" />
	var _ = __webpack_require__(47);
	var Opt = __webpack_require__(5);
	exports.defined = function (x) { return (x !== null) && (x !== undefined); };
	/**
	 * Arrays of Objects are common in RAML08.
	 * @param x
	 * @returns {{}}
	 */
	function flattenArrayOfObjects(x) {
	    var res = {};
	    x.forEach(function (v) { return Object.keys(v).forEach(function (k) { return res[k] = v[k]; }); });
	    return res;
	}
	exports.flattenArrayOfObjects = flattenArrayOfObjects;
	function find(xs, f) {
	    return new Opt(_.find(xs || [], f));
	}
	exports.find = find;
	exports.isInstance = function (v, C) { return (v instanceof C) ? [v] : []; };
	exports.ifInstanceOf = function (v, C, f) { return (v instanceof C) ? f(v) : null; };
	function toTuples(map) {
	    return Object.keys(map).map(function (k) { return [k, map[k]]; });
	}
	exports.toTuples = toTuples;
	function fromTuples(tuples) {
	    var obj = {};
	    tuples.forEach(function (x) { return obj[x[0]] = x[1]; });
	    return obj;
	}
	exports.fromTuples = fromTuples;
	exports.collectInstancesOf = function (xs, C) { return tap([], function (res) { return xs.forEach(function (v) { return exports.ifInstanceOf(v, C, function (x) { return res.push(x); }); }); }); };
	exports.collectInstancesOfInMap = function (map, C) {
	    return Object.keys(map).map(function (k) { return [k, map[k]]; }).filter(function (x) { return x[1] instanceof C; }).map(function (x) { return x; });
	};
	exports.asArray = function (v) { return exports.defined(v) ? ((v instanceof Array) ? v : [v]) : []; };
	exports.shallowCopy = function (obj) { return tap({}, function (copy) { return Object.keys(obj).forEach(function (k) { return copy[k] = obj[k]; }); }); };
	exports.flatMap = function (xs, f) { return exports.flatten(xs.map(f)); };
	exports.flatten = function (xss) { return Array.prototype.concat.apply([], xss); };
	exports.takeWhile = function (xs, f) { return tap([], function (res) {
	    for (var i = 0; i < xs.length; i++) {
	        if (!f(xs[i]))
	            break;
	        res.push(xs[i]);
	    }
	}); };
	function tap(v, f) {
	    f(v);
	    return v;
	}
	exports.tap = tap;
	function kv(obj, iter) {
	    if (typeof obj === 'object')
	        Object.keys(obj).forEach(function (k) { return iter(k, obj[k]); });
	}
	exports.kv = kv;
	function indexed(objects, key, delKey) {
	    if (delKey === void 0) { delKey = false; }
	    var obj = {};
	    objects.forEach(function (original) {
	        var copy = exports.shallowCopy(original);
	        if (delKey)
	            delete copy[key];
	        obj[original[key]] = copy;
	    });
	    return obj;
	}
	exports.indexed = indexed;
	function stringEndsWith(str, search) {
	    var dif = str.length - search.length;
	    return dif >= 0 && str.lastIndexOf(search) === dif;
	}
	exports.stringEndsWith = stringEndsWith;
	function stringStartsWith(str, search) {
	    return str.length - search.length >= 0 && str.substring(0, search.length) === search;
	}
	exports.stringStartsWith = stringStartsWith;
	function lazypropkeyfilter(k) {
	    return k[k.length - 1] == "_"; // ends with underscore
	}
	exports.lazypropkeyfilter = lazypropkeyfilter;
	function lazyprop(obj, key, func) {
	    var result, ready = false;
	    obj[key] = function () {
	        if (!ready) {
	            ready = true;
	            result = func.apply(obj);
	        }
	        return result;
	    };
	}
	function lazyprops(obj, keyfilter) {
	    if (keyfilter === void 0) { keyfilter = lazypropkeyfilter; }
	    for (var k in obj) {
	        if (keyfilter(k)) {
	            exports.ifInstanceOf(obj[k], Function, function (vf) { return (vf.length === 0) ? lazyprop(obj, k, vf) : null; });
	        }
	    }
	}
	exports.lazyprops = lazyprops;
	function iff(v, f) {
	    if (v !== undefined)
	        f(v);
	}
	exports.iff = iff;
	function isRAMLUrl(str) {
	    if (typeof str !== 'string' || str == '')
	        return false;
	    return stringEndsWith(str, ".raml");
	}
	exports.isRAMLUrl = isRAMLUrl;
	function getAllRequiredExternalModulesFromCode(code) {
	    var match;
	    var mods = [];
	    // both quoting styles
	    var r1 = new RegExp("require\\('([^']+)'\\)", "gi");
	    while (match = r1.exec(code)) {
	        mods.push(match[1]);
	    }
	    var r2 = new RegExp('require\\("([^"]+)"\\)', "gi");
	    while (match = r2.exec(code)) {
	        mods.push(match[1]);
	    }
	    mods = _.unique(mods).filter(function (x) { return x != ""; });
	    mods.sort();
	    return mods;
	}
	exports.getAllRequiredExternalModulesFromCode = getAllRequiredExternalModulesFromCode;
	exports.serial = (function () {
	    var i = 0;
	    return function () { return i++; };
	})();
	function isEssential(arg) {
	    return typeof arg !== 'undefined' && arg != null;
	}
	exports.isEssential = isEssential;
	function firstToUpper(q) {
	    if (q.length == 0) {
	        return q;
	    }
	    return q.charAt(0).toUpperCase() + q.substr(1);
	}
	exports.firstToUpper = firstToUpper;
	function updateObject(source, target, addNewFields) {
	    if (addNewFields === void 0) { addNewFields = false; }
	    var keySet = Object.keys(target);
	    if (addNewFields) {
	        var map = {};
	        keySet.forEach(function (x) { return map[x] = true; });
	        Object.keys(source).forEach(function (x) { return map[x] = true; });
	        keySet = Object.keys(map);
	    }
	    keySet.forEach(function (x) {
	        var value = source[x];
	        if (value instanceof Object) {
	            if (!target[x]) {
	                target[x] = {};
	            }
	            updateObject(value, target[x], true);
	        }
	        else if (value != undefined) {
	            target[x] = source[x];
	        }
	    });
	}
	exports.updateObject = updateObject;
	;
	/**
	 * In 'str' replace all occurences of 'map' keys to their values.
	 */
	function replaceMap(str, map) {
	    Object.keys(map).forEach(function (x) { return str = replace(str, x, map[x]); });
	    return str;
	}
	exports.replaceMap = replaceMap;
	/**
	 * Replace all occurences of 'x' in 'str' to 'r' without thinking if 'x' can be passed without
	 * escaping as argument to RegExp constructor
	 */
	function replace(str, x, r) {
	    var result = '';
	    var prev = 0;
	    for (var i = str.indexOf(x); i < str.length && i >= 0; i = str.indexOf(x, prev)) {
	        result += str.substring(prev, i);
	        result += r;
	        prev = i + x.length;
	    }
	    result += str.substring(prev, str.length);
	    return result;
	}
	exports.replace = replace;
	//# sourceMappingURL=index.js.map

/***/ },
/* 21 */
/***/ function(module, exports, __webpack_require__) {

	var __extends = this.__extends || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    __.prototype = b.prototype;
	    d.prototype = new __();
	};
	var _ = __webpack_require__(47);
	var hlimpl = __webpack_require__(7);
	var jsyaml = __webpack_require__(6);
	var su = __webpack_require__(54);
	var selector = __webpack_require__(55);
	var typeBuilder = __webpack_require__(34);
	var ramlexp = __webpack_require__(56);
	var defs = __webpack_require__(21);
	var search = __webpack_require__(35);
	var Annotation = (function () {
	    function Annotation(_name) {
	        this._name = _name;
	    }
	    Annotation.prototype.name = function () {
	        return this._name;
	    };
	    return Annotation;
	})();
	exports.Annotation = Annotation;
	var Described = (function () {
	    function Described(_name, _description) {
	        if (_description === void 0) { _description = ""; }
	        this._name = _name;
	        this._description = _description;
	        this._issues = [];
	        this._toClarify = [];
	        this._itCovers = [];
	        this._tags = [];
	    }
	    Described.prototype.name = function () {
	        return this._name;
	    };
	    Described.prototype.description = function () {
	        return this._description;
	    };
	    Described.prototype.withIssue = function (description) {
	        this._issues.push(description);
	        return this;
	    };
	    Described.prototype.withTag = function (description) {
	        this._tags.push(description);
	        return this;
	    };
	    Described.prototype.withClarify = function (description) {
	        this._toClarify.push(description);
	        return this;
	    };
	    Described.prototype.getCoveredStuff = function () {
	        return this._itCovers;
	    };
	    Described.prototype.withThisFeatureCovers = function (description) {
	        this._itCovers.push(description);
	        return this;
	    };
	    Described.prototype.withVersion = function (verstion) {
	        this._version = verstion;
	    };
	    Described.prototype.version = function () {
	        return this._version;
	    };
	    Described.prototype.issues = function () {
	        return this._issues;
	    };
	    Described.prototype.toClarify = function () {
	        return this._toClarify;
	    };
	    Described.prototype.tags = function () {
	        return this._tags;
	    };
	    Described.prototype.withDescription = function (d) {
	        this._description = d;
	        return this;
	    };
	    return Described;
	})();
	exports.Described = Described;
	var ValueRequirement = (function () {
	    function ValueRequirement(name, value) {
	        this.name = name;
	        this.value = value;
	    }
	    return ValueRequirement;
	})();
	exports.ValueRequirement = ValueRequirement;
	var AbstractType = (function (_super) {
	    __extends(AbstractType, _super);
	    function AbstractType(_name, _universe, _path) {
	        _super.call(this, _name);
	        this._universe = _universe;
	        this._path = _path;
	        this._superTypes = [];
	        this._subTypes = [];
	        this._annotations = [];
	        this._requirements = [];
	        this._aliases = [];
	        this._defining = [];
	        this.fixedFacets = {};
	        this._methods = [];
	    }
	    AbstractType.prototype.isRuntime = function () {
	        return false;
	    };
	    AbstractType.prototype.union = function () {
	        return null;
	    };
	    AbstractType.prototype.isUserDefined = function () {
	        return false;
	    };
	    AbstractType.prototype.isArray = function () {
	        return false;
	    };
	    AbstractType.prototype.isUnion = function () {
	        return false;
	    };
	    AbstractType.prototype.fixFacet = function (name, v) {
	        this.fixedFacets[name] = v;
	    };
	    AbstractType.prototype.getFixedFacets = function () {
	        if (this._af) {
	            return this._af;
	        }
	        var sp = this.allSuperTypes();
	        var mm = {};
	        for (var q in this.fixedFacets) {
	            mm[q] = this.fixedFacets[q];
	        }
	        sp.forEach(function (x) {
	            if (x instanceof NodeClass) {
	                x.contributeFacets(mm);
	                var ff = x.fixedFacets;
	                for (var q in ff) {
	                    mm[q] = ff[q];
	                }
	            }
	        });
	        this.contributeFacets(mm);
	        this._af = mm;
	        return mm;
	    };
	    AbstractType.prototype.contributeFacets = function (x) {
	    };
	    AbstractType.prototype.setDeclaringNode = function (n) {
	        this._node = n;
	    };
	    AbstractType.prototype.getDeclaringNode = function () {
	        return this._node;
	    };
	    AbstractType.prototype.toRuntime = function () {
	        return this;
	    };
	    AbstractType.prototype.setConsumesRefs = function (b) {
	        this._consumesRef = b;
	    };
	    AbstractType.prototype.definingPropertyIsEnough = function (v) {
	        this._defining.push(v);
	    };
	    AbstractType.prototype.getDefining = function () {
	        return this._defining;
	    };
	    AbstractType.prototype.getConsumesRefs = function () {
	        return this._consumesRef;
	    };
	    AbstractType.prototype.addAlias = function (al) {
	        this._aliases.push(al);
	    };
	    AbstractType.prototype.getAliases = function () {
	        return this._aliases;
	    };
	    AbstractType.prototype.isValid = function (h, v, p) {
	        return true;
	    };
	    AbstractType.prototype.getPath = function () {
	        return this._path;
	    };
	    AbstractType.prototype.withFunctionalDescriminator = function (code) {
	        this._fDesc = code;
	    };
	    AbstractType.prototype.addMethod = function (name, text) {
	        this._methods.push({ name: name, text: text });
	    };
	    AbstractType.prototype.methods = function () {
	        return this._methods;
	    };
	    AbstractType.prototype.setNameAtRuntime = function (name) {
	        this._nameAtRuntime = name;
	    };
	    AbstractType.prototype.getNameAtRuntime = function () {
	        return this._nameAtRuntime;
	    };
	    AbstractType.prototype.getFunctionalDescriminator = function () {
	        return this._fDesc;
	    };
	    AbstractType.prototype.getRuntimeExtenders = function () {
	        return [];
	    };
	    AbstractType.prototype.universe = function () {
	        return this._universe;
	    };
	    AbstractType.prototype.superTypes = function () {
	        return [].concat(this._superTypes);
	    };
	    AbstractType.prototype.isAssignableFrom = function (typeName) {
	        if (this.name() == typeName) {
	            if (this.isUserDefined()) {
	                return false;
	            }
	            return true;
	        }
	        var currentSuperTypes = this.allSuperTypes();
	        for (var i = 0; i < currentSuperTypes.length; i++) {
	            if (currentSuperTypes[i].name() == typeName) {
	                return true;
	            }
	        }
	        return false;
	    };
	    AbstractType.prototype.subTypes = function () {
	        return [].concat(this._subTypes);
	    };
	    AbstractType.prototype.allSubTypes = function () {
	        var rs = [];
	        this.subTypes().forEach(function (x) {
	            rs.push(x);
	            rs = rs.concat(x.allSubTypes());
	        });
	        return _.unique(rs);
	    };
	    AbstractType.prototype.allSuperTypes = function () {
	        var rs = [];
	        this.allSuperTypesRecurrent(this, {}, rs);
	        return _.unique(rs);
	    };
	    AbstractType.prototype.allSuperTypesRecurrent = function (t, m, result) {
	        var _this = this;
	        t.superTypes().forEach(function (x) {
	            result.push(x);
	            if (!m[x.name()]) {
	                m[x.name()] = x;
	                _this.allSuperTypesRecurrent(x, m, result);
	            }
	        });
	    };
	    AbstractType.prototype.addRequirement = function (name, value) {
	        this._requirements.push(new ValueRequirement(name, value));
	    };
	    //FIXME simplify it
	    AbstractType.prototype.valueRequirements = function () {
	        return this._requirements;
	    };
	    AbstractType.prototype.annotations = function () {
	        return this._annotations;
	    };
	    return AbstractType;
	})(Described);
	exports.AbstractType = AbstractType;
	var ValueType = (function (_super) {
	    __extends(ValueType, _super);
	    function ValueType(name, _universe, path, description, _restriction) {
	        if (description === void 0) { description = ""; }
	        if (_restriction === void 0) { _restriction = null; }
	        _super.call(this, name, _universe, path);
	        this._restriction = _restriction;
	        this._declaredBy = [];
	    }
	    ValueType.prototype.hasStructure = function () {
	        if (this.name() == "structure") {
	            return true;
	        }
	        return false;
	    };
	    ValueType.prototype.isValid = function (h, v, p) {
	        try {
	            if (this.name() == "AnnotationRef") {
	                var targets = p.referenceTargets(h);
	                var actualAnnotation = _.find(targets, function (x) { return hlimpl.qName(x, h) == v; });
	                if (actualAnnotation != null) {
	                    var attrs = actualAnnotation.attributes("allowedTargets");
	                    if (attrs) {
	                        var aVals = attrs.map(function (x) { return x.value(); });
	                        if (aVals.length > 0) {
	                            var found = false;
	                            //no we should actually check that we are applying annotation properly
	                            var tps = h.definition().allSuperTypes();
	                            tps = tps.concat([h.definition()]);
	                            var tpNames = tps.map(function (x) { return x.name(); });
	                            aVals.forEach(function (x) {
	                                //FIXME this is deeply wrong code
	                                if (x == "API") {
	                                    x = "Api";
	                                }
	                                if (x == "NamedExample") {
	                                    x = "ExampleSpec";
	                                }
	                                if (x == "SecurityScheme") {
	                                    x = "SecuritySchema";
	                                }
	                                if (x == "SecuritySchemeSettings") {
	                                    x = "SecuritySchemaSettings";
	                                }
	                                if (_.find(tpNames, function (y) { return y == x; })) {
	                                    found = true;
	                                }
	                                else {
	                                    if (x == "Parameter") {
	                                        if (h.computedValue("location")) {
	                                            found = true;
	                                        }
	                                    }
	                                    if (x == "Field") {
	                                        if (h.computedValue("field")) {
	                                            found = true;
	                                        }
	                                    }
	                                }
	                            });
	                            if (!found) {
	                                return new Error("annotation " + v + " can not be placed at this location, allowed targets are:" + aVals);
	                            }
	                        }
	                    }
	                }
	                return tm;
	            }
	            if (this.name() == "SchemaString") {
	                var tm = su.createSchema(v);
	                if (tm instanceof Error) {
	                    tm.canBeRef = true;
	                }
	                return tm;
	            }
	            if (this.name() == "StatusCode") {
	                if (v.length != 3) {
	                    return new Error("Status code should be 3 digits number with optional 'x' as wildcards");
	                }
	                for (var i = 0; i < v.length; i++) {
	                    var c = v[i];
	                    if (!_.find(['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'x', 'X'], function (x) { return x == c; })) {
	                        return new Error("Status code should be 3 digits number with optional 'x' as wildcards");
	                    }
	                }
	            }
	            if (this.name() == "JSonSchemaString") {
	                var jsshema = su.getJSONSchema(v);
	                if (jsshema instanceof Error) {
	                    jsshema.canBeRef = true;
	                }
	                return jsshema;
	            }
	            if (this.name() == "XMLSchemaString") {
	                var xmlschema = su.getXMLSchema(v);
	                if (xmlschema instanceof Error) {
	                    xmlschema.canBeRef = true;
	                }
	                return xmlschema;
	            }
	            if (this.name() == "BooleanType") {
	                if (!(v == 'true' || v == 'false')) {
	                    return new Error("'true' or 'false' is expected here");
	                }
	            }
	            if (this.name() == "NumberType") {
	                var q = parseFloat(v);
	                if (isNaN(q)) {
	                    return new Error("number is expected here");
	                }
	            }
	            if (this.name() == 'ramlexpression') {
	                try {
	                    if (p.name() == 'condition') {
	                        if (h.computedValue("response")) {
	                            h = h.parent().parent().parent();
	                        }
	                        else {
	                            h = h.parent().parent();
	                        }
	                    }
	                    if (p.name() == 'validWhen' || p.name() == 'requiredWhen') {
	                        h = h.parent();
	                    }
	                    ramlexp.validate(v, h);
	                }
	                catch (e) {
	                    return e;
	                }
	            }
	            if (this.name() == "pointer") {
	                var pointer = search.resolveRamlPointer(h, v);
	                if (!pointer) {
	                    return new Error("Unable to resolve raml pointer:" + v);
	                }
	                else {
	                    var dp = p;
	                    var sl = dp.getSelector(h);
	                    if (sl) {
	                        var pp = h;
	                        if (pp.definition().isAnnotation()) {
	                            pp = pp.parent();
	                        }
	                        var options = sl.apply(pp);
	                        if (!_.find(options, function (x) { return x == pointer; })) {
	                            return new Error("Pointer does not fits to scope " + v);
	                        }
	                    }
	                }
	            }
	            if (this.name() == "RAMLSelector") {
	                try {
	                    var sl = selector.parse(h, v);
	                    return sl;
	                }
	                catch (e) {
	                    return new Error("Unable to parse RAML selector :" + e.message);
	                }
	            }
	            return true;
	        }
	        catch (e) {
	            e.canBeRef = true; //FIXME
	            return e;
	        }
	    };
	    ValueType.prototype.isValueType = function () {
	        return true;
	    };
	    ValueType.prototype.isUnionType = function () {
	        return false;
	    };
	    ValueType.prototype.properties = function () {
	        return [];
	    };
	    ValueType.prototype.allProperties = function () {
	        return [];
	    };
	    ValueType.prototype.globallyDeclaredBy = function () {
	        return this._declaredBy;
	    };
	    ValueType.prototype.setGloballyDeclaredBy = function (c) {
	        this._declaredBy.push(c);
	    };
	    ValueType.prototype.getValueRestriction = function () {
	        return this._restriction;
	    };
	    ValueType.prototype.match = function (r) {
	        return false;
	    };
	    return ValueType;
	})(AbstractType);
	exports.ValueType = ValueType;
	var EnumType = (function (_super) {
	    __extends(EnumType, _super);
	    function EnumType() {
	        _super.apply(this, arguments);
	        this.values = [];
	    }
	    return EnumType;
	})(ValueType);
	exports.EnumType = EnumType;
	var ReferenceType = (function (_super) {
	    __extends(ReferenceType, _super);
	    function ReferenceType(name, path, referenceTo, _universe) {
	        _super.call(this, name, _universe, path);
	        this.referenceTo = referenceTo;
	    }
	    ReferenceType.prototype.getReferencedType = function () {
	        return this.universe().getType(this.referenceTo);
	    };
	    ReferenceType.prototype.hasStructure = function () {
	        var rt = this.getReferencedType();
	        if (rt) {
	            return rt.isInlinedTemplates() || (rt.findMembersDeterminer() != null) || rt.name() == "SecuritySchema"; //FIXME
	        }
	        else {
	            return false;
	        }
	    };
	    return ReferenceType;
	})(ValueType);
	exports.ReferenceType = ReferenceType;
	var ScriptingHookType = (function (_super) {
	    __extends(ScriptingHookType, _super);
	    function ScriptingHookType(name, path, refTo, _universe) {
	        _super.call(this, name, _universe, path);
	        this.refTo = refTo;
	    }
	    ScriptingHookType.prototype.getReferencedType = function () {
	        return this.universe().getType(this.refTo);
	    };
	    return ScriptingHookType;
	})(ValueType);
	exports.ScriptingHookType = ScriptingHookType;
	var NodeClass = (function (_super) {
	    __extends(NodeClass, _super);
	    function NodeClass(_name, universe, path, _description) {
	        if (_description === void 0) { _description = ""; }
	        _super.call(this, _name, universe, path);
	        this._properties = [];
	        this._declaresType = null;
	        this._runtimeExtenders = [];
	        this._inlinedTemplates = false;
	        this._contextReq = [];
	        this._allowQuestion = false;
	        this._canInherit = [];
	    }
	    NodeClass.prototype.isRuntime = function () {
	        return this._isRuntime;
	    };
	    NodeClass.prototype.isUserDefined = function () {
	        return false;
	    };
	    NodeClass.prototype.getRepresentationOf = function () {
	        return this._representationOf;
	    };
	    NodeClass.prototype.toRuntime = function () {
	        var c = new NodeClass(this.name(), this.universe(), "");
	        c._isRuntime = true;
	        c._representationOf = this;
	        //c._properties=this.allRuntimeProperties();
	        return c;
	    };
	    NodeClass.prototype.allFacets = function (ps) {
	        if (ps === void 0) { ps = {}; }
	        if (this._allFacets) {
	            return this._allFacets;
	        }
	        if (ps[this.name()]) {
	            return [];
	        }
	        ps[this.name()] = this;
	        var n = {};
	        if (this.superTypes().length > 0) {
	            this.superTypes().forEach(function (x) {
	                if (x instanceof NodeClass) {
	                    x.allFacets(ps).forEach(function (y) { return n[y.name()] = y; });
	                }
	            });
	        }
	        this._properties.forEach(function (x) { return n[x.name()] = x; });
	        this._allFacets = Object.keys(n).map(function (x) { return n[x]; });
	        //this.contributeToFacets(this._allFacets);
	        return this._allFacets;
	    };
	    NodeClass.prototype.facet = function (name) {
	        return _.find(this.allFacets(), function (x) { return x.name() == name; });
	    };
	    NodeClass.prototype.isDeclaration = function () {
	        if (this._inlinedTemplates) {
	            return true;
	        }
	        if (this._convertsToGlobal) {
	            return true;
	        }
	        if (this._declaresType) {
	            return true;
	        }
	        if (this.name() == "Library") {
	            return true;
	        }
	        return false;
	    };
	    NodeClass.prototype.isAnnotation = function () {
	        if (this._annotationChecked) {
	            return this._isAnnotation;
	        }
	        this._annotationChecked = true;
	        this._isAnnotation = (_.find(this.allSuperTypes(), function (x) { return x.name() == "Annotation"; }) != null);
	        return this._isAnnotation;
	    };
	    NodeClass.prototype.allowValue = function () {
	        if (this._allowValueSet) {
	            return this._allowValue;
	        }
	        if (_.find(this.allProperties(), function (x) { return x.isValue() || x.canBeValue(); })) {
	            this._allowValue = true;
	            this._allowValueSet = true;
	            return true;
	        }
	        this._allowValueSet = true;
	        return false;
	    };
	    NodeClass.prototype.printDetails = function () {
	        var result = "";
	        result += this.name() + "\n";
	        this.properties().forEach(function (property) {
	            result += "  " + property.name() + ":" + property.range() + "\n";
	        });
	        return result;
	    };
	    NodeClass.prototype.withCanInherit = function (clazz) {
	        this._canInherit.push(clazz);
	    };
	    NodeClass.prototype.getCanInherit = function () {
	        return this._canInherit;
	    };
	    NodeClass.prototype.getReferenceIs = function () {
	        return this._referenceIs;
	    };
	    NodeClass.prototype.withReferenceIs = function (fname) {
	        this._referenceIs = fname;
	    };
	    NodeClass.prototype.withAllowQuestion = function () {
	        this._allowQuestion = true;
	    };
	    NodeClass.prototype.requiredProperties = function () {
	        return this.allProperties().filter(function (x) { return x.isRequired(); });
	    };
	    NodeClass.prototype.getAllowQuestion = function () {
	        return this._allowQuestion;
	    };
	    NodeClass.prototype.withAllowAny = function () {
	        this._allowAny = true;
	    };
	    NodeClass.prototype.getAllowAny = function () {
	        return this._allowAny;
	    };
	    NodeClass.prototype.withActuallyExports = function (pname) {
	        this._actuallyExports = pname;
	    };
	    NodeClass.prototype.withConvertsToGlobal = function (pname) {
	        this._convertsToGlobal = pname;
	    };
	    NodeClass.prototype.getConvertsToGlobal = function () {
	        return this._convertsToGlobal;
	    };
	    NodeClass.prototype.getActuallyExports = function () {
	        return this._actuallyExports;
	    };
	    NodeClass.prototype.withContextRequirement = function (name, value) {
	        this._contextReq.push({ name: name, value: value });
	    };
	    NodeClass.prototype.getContextRequirements = function () {
	        return this._contextReq;
	    };
	    NodeClass.prototype.isGlobalDeclaration = function () {
	        if (this._actuallyExports) {
	            return true;
	        }
	        if (this._inlinedTemplates) {
	            return true;
	        }
	        if (this._declaresType) {
	            return true;
	        }
	        return false;
	    };
	    NodeClass.prototype.findMembersDeterminer = function () {
	        return _.find(this.allProperties(), function (x) { return x.isThisPropertyDeclaresTypeFields(); });
	    };
	    NodeClass.prototype.isTypeSystemMember = function () {
	        return this._declaresType != null;
	    };
	    NodeClass.prototype.hasStructure = function () {
	        return true;
	    };
	    NodeClass.prototype.getExtendedType = function () {
	        return this.universe().type(this._declaresType);
	    };
	    NodeClass.prototype.setInlinedTemplates = function (b) {
	        this._inlinedTemplates = b;
	        return this;
	    };
	    NodeClass.prototype.isInlinedTemplates = function () {
	        return this._inlinedTemplates;
	    };
	    NodeClass.prototype.setExtendedTypeName = function (name) {
	        this._declaresType = name;
	        var tp = this.universe().type(name);
	        if (tp instanceof NodeClass) {
	            var nc = tp;
	            nc._runtimeExtenders.push(this);
	        }
	    };
	    //private vReqInitied=false;
	    NodeClass.prototype.getRuntimeExtenders = function () {
	        return this._runtimeExtenders;
	    };
	    NodeClass.prototype.createStubNode = function (p, key) {
	        if (key === void 0) { key = null; }
	        var lowLevel = jsyaml.createNode(key ? key : "key");
	        var nm = new hlimpl.ASTNodeImpl(lowLevel, null, this, p);
	        this.allProperties().forEach(function (x) {
	            if (x.range().isValueType() && !x.isSystem()) {
	                var a = nm.attr(x.name());
	                if (!a) {
	                }
	            }
	        });
	        nm.children();
	        return nm;
	    };
	    NodeClass.prototype.createProperty = function (parent, key) {
	        if (key === void 0) { key = null; }
	        var lowLevel = jsyaml.createNode(key ? key : "key");
	        var p = new Property('zzz');
	        return p;
	    };
	    NodeClass.prototype.descriminatorValue = function () {
	        if (this.valueRequirements().length == 0) {
	            return this.name();
	        }
	        return this.valueRequirements()[0].value;
	    };
	    NodeClass.prototype.match = function (r, alreadyFound) {
	        var _this = this;
	        //this.vReqInitied=true;
	        if (r.isAttr() || r.isUnknown()) {
	            return false;
	        }
	        var el = r;
	        //if (this.name()=="ObjectField"){
	        //   var tp= el.attr("type");
	        //    if (tp&&tp.value()) {
	        //        //FIXME
	        //        if (!_.find(["string","boolean","file","number","integer","date","pointer","script"], x=>x==tp.value())) {
	        //            return true;
	        //        }
	        //    }
	        //}
	        var hasSuperType = _.find(this.superTypes(), function (x) {
	            var dp = _.find(x.allProperties(), function (x) { return x.isDescriminating(); });
	            if (dp) {
	                var a = el.attr(dp.name());
	                if (a) {
	                    if (a.value() == _this.name()) {
	                        return true;
	                    }
	                }
	            }
	            return false;
	        });
	        if (hasSuperType) {
	            return true;
	        }
	        if (this.valueRequirements().length == 0) {
	            return false;
	        }
	        var matches = true;
	        //descriminating constraint
	        this.valueRequirements().forEach(function (x) {
	            var a = el.attr(x.name);
	            if (a) {
	                if (a.value() == x.value) {
	                }
	                else {
	                    if (_this.getConsumesRefs()) {
	                        var vl = a.value();
	                        var allSubs = [];
	                        _this.superTypes().forEach(function (x) { return x.allSubTypes().forEach(function (y) {
	                            allSubs.push(y);
	                        }); });
	                        var allSubNames = [];
	                        _.unique(allSubs).forEach(function (x) {
	                            allSubNames.push(x.name());
	                            x.valueRequirements().forEach(function (y) {
	                                allSubNames.push(y.value);
	                            });
	                            x.getAliases().forEach(function (y) { return allSubNames.push(y); });
	                        });
	                        if (_.find(allSubNames, function (x) { return x == vl; })) {
	                            matches = false;
	                        }
	                    }
	                    else {
	                        matches = false;
	                    }
	                }
	            }
	            else {
	                var m = _this.getDefining();
	                var ms = false;
	                m.forEach(function (x) {
	                    el.lowLevel().children().forEach(function (y) {
	                        if (y.key() == x) {
	                            ms = true;
	                        }
	                        if (y.key() == "$ref") {
	                            if (el.definition().universe().version() == "Swagger") {
	                                var resolved = search.resolveReference(y, y.value());
	                                if (resolved) {
	                                    if (_.find(resolved.children(), function (z) { return z.key() == x; })) {
	                                        ms = true;
	                                    }
	                                }
	                            }
	                        }
	                    });
	                });
	                if (ms) {
	                    matches = true;
	                    return;
	                }
	                if (!alreadyFound) {
	                    var pr = _this.property(x.name);
	                    if (pr && pr.defaultValue() == x.value) {
	                    }
	                    else {
	                        matches = false;
	                    }
	                }
	            }
	        });
	        return matches;
	    };
	    NodeClass.prototype.allProperties = function (ps) {
	        if (ps === void 0) { ps = {}; }
	        if (this._props) {
	            return this._props;
	        }
	        if (ps[this.name()]) {
	            return [];
	        }
	        ps[this.name()] = this;
	        var n = {};
	        if (this.superTypes().length > 0) {
	            this.superTypes().forEach(function (x) {
	                if (x instanceof NodeClass) {
	                    x.allProperties(ps).forEach(function (y) { return n[y.name()] = y; });
	                }
	                else {
	                    x.allProperties().forEach(function (y) { return n[y.name()] = y; });
	                }
	            });
	        }
	        for (var x in this.getFixedFacets()) {
	            delete n[x];
	        }
	        this._properties.forEach(function (x) { return n[x.name()] = x; });
	        this._props = Object.keys(n).map(function (x) { return n[x]; });
	        return this._props;
	    };
	    NodeClass.prototype.isValueType = function () {
	        return false;
	    };
	    NodeClass.prototype.isAbstract = function () {
	        return this._isAbstract;
	    };
	    NodeClass.prototype.isUnionType = function () {
	        return false;
	    };
	    NodeClass.prototype.property = function (propName) {
	        return _.find(this.allProperties(), function (x) { return x.name() == propName; });
	    };
	    NodeClass.prototype.properties = function () {
	        return [].concat(this._properties);
	    };
	    NodeClass.prototype.getKeyProp = function () {
	        return _.find(this.allProperties(), function (x) { return x.isKey(); });
	    };
	    NodeClass.prototype.registerProperty = function (p) {
	        if (p.domain() != this) {
	            throw new Error("Should be already owned by this");
	        }
	        if (this._properties.indexOf(p) != -1) {
	            throw new Error("Already included");
	        }
	        this._properties.push(p);
	    };
	    NodeClass.prototype.allRuntimeProperties = function (ps) {
	        if (ps === void 0) { ps = {}; }
	        return [];
	    };
	    return NodeClass;
	})(AbstractType);
	exports.NodeClass = NodeClass;
	var UserDefinedClass = (function (_super) {
	    __extends(UserDefinedClass, _super);
	    function UserDefinedClass(name, universe, hl, path, description) {
	        _super.call(this, name, universe, path, description);
	        this.uc = false;
	        this.setDeclaringNode(hl);
	    }
	    UserDefinedClass.prototype.addRuntimeProperty = function (p) {
	        this._runtimeProperties.push(p);
	    };
	    UserDefinedClass.prototype.isArray = function () {
	        return _.find(this.allSuperTypes(), function (x) { return x.isArray(); }) != null;
	    };
	    UserDefinedClass.prototype.isUnion = function () {
	        return _.find(this.allSuperTypes(), function (x) {
	            var mm = x;
	            if (mm.uc) {
	                return false;
	            }
	            mm.uc = true;
	            try {
	                return x.isUnion();
	            }
	            finally {
	                mm.uc = false;
	            }
	        }) != null;
	    };
	    UserDefinedClass.prototype.isUserDefined = function () {
	        return true;
	    };
	    UserDefinedClass.prototype.contributeFacets = function (x) {
	        this.findFacets(this.getDeclaringNode(), x);
	    };
	    UserDefinedClass.prototype.findFacets = function (node, x) {
	        if (node) {
	            var chd = node.lowLevel().children();
	            var mi = _.find(chd, function (x) { return x.key() == "minProperties"; });
	            if (mi) {
	                x[mi.key()] = mi;
	            }
	            var mi = _.find(chd, function (x) { return x.key() == "maxProperties"; });
	            if (mi) {
	                x[mi.key()] = mi;
	            }
	        }
	    };
	    UserDefinedClass.prototype.initRuntime = function () {
	        var _this = this;
	        this._runtimeProperties = [];
	        var node = this.getDeclaringNode();
	        if (node) {
	            var el = node.elementsOfKind("properties");
	            el.forEach(function (x) {
	                var prop = typeBuilder.elementToProp(x, true);
	                _this.addRuntimeProperty(prop);
	            });
	        }
	    };
	    UserDefinedClass.prototype.isValueType = function () {
	        if (this.isRuntime()) {
	            return this._value;
	        }
	        if (this.isAssignableFrom("ObjectField")) {
	            return false;
	        }
	        return true;
	    };
	    UserDefinedClass.prototype.componentType = function () {
	        var x = this.allSuperTypes();
	        var res = null;
	        x.forEach(function (y) {
	            if (y instanceof Array) {
	                res = y.component;
	            }
	        });
	        return res;
	    };
	    UserDefinedClass.prototype.union = function () {
	        var x = this.allSuperTypes();
	        var res = null;
	        x.forEach(function (y) {
	            if (y instanceof Union) {
	                res = y;
	            }
	        });
	        return res;
	    };
	    UserDefinedClass.prototype.toRuntime = function () {
	        var c = new UserDefinedClass(this.name(), this.universe(), null, this.getPath(), "");
	        c._isRuntime = true;
	        c._representationOf = this;
	        c._properties = this.allRuntimeProperties();
	        c.setDeclaringNode(this.getDeclaringNode());
	        if (this.isAssignableFrom("ObjectField")) {
	            c._value = false;
	            if (c._properties.length == 0) {
	                c.withAllowAny();
	            }
	        }
	        else {
	            c._value = true;
	        }
	        if (this.isUnion()) {
	            var ut = new Union(this.name(), this.universe(), this.getPath(), "");
	            ut._representationOf = this;
	            ut.setDeclaringNode(this.getDeclaringNode());
	            var cm = this.union();
	            if (cm) {
	                if (cm.left) {
	                    ut.left = cm.left.toRuntime();
	                }
	                if (cm.right) {
	                    ut.right = cm.right.toRuntime();
	                }
	                return ut;
	            }
	            ut._isRuntime = true;
	            //at.component=this.component.toRuntime();
	            return ut;
	        }
	        if (this.isArray()) {
	            var at = new defs.Array(this.name(), this.universe(), this.getPath(), "");
	            at._representationOf = this;
	            at.setDeclaringNode(this.getDeclaringNode());
	            var cm = this.componentType();
	            if (cm) {
	                at.component = cm.toRuntime();
	            }
	            //at.component=this.component.toRuntime();
	            return at;
	        }
	        return c;
	    };
	    UserDefinedClass.prototype.allRuntimeProperties = function (ps) {
	        if (ps === void 0) { ps = {}; }
	        if (!this._runtimeProperties) {
	            this.initRuntime();
	            this._rprops = null;
	        }
	        if (this._rprops) {
	            return this._rprops;
	        }
	        if (ps[this.name()]) {
	            return [];
	        }
	        ps[this.name()] = this;
	        var n = {};
	        if (this.superTypes().length > 0) {
	            this.superTypes().forEach(function (x) {
	                if (x instanceof NodeClass) {
	                    x.allRuntimeProperties(ps).forEach(function (y) { return n[y.name()] = y; });
	                }
	            });
	        }
	        this._runtimeProperties.forEach(function (x) { return n[x.name()] = x; });
	        this._rprops = Object.keys(n).map(function (x) { return n[x]; });
	        return this._rprops;
	    };
	    UserDefinedClass.prototype.getRuntimeProperties = function () {
	        if (!this._runtimeProperties) {
	            this.initRuntime();
	        }
	        return this._runtimeProperties;
	    };
	    return UserDefinedClass;
	})(NodeClass);
	exports.UserDefinedClass = UserDefinedClass;
	var AnnotationType = (function (_super) {
	    __extends(AnnotationType, _super);
	    function AnnotationType() {
	        _super.apply(this, arguments);
	    }
	    AnnotationType.prototype.allProperties = function (ps) {
	        if (ps === void 0) { ps = {}; }
	        var result = _super.prototype.allProperties.call(this, ps);
	        if (result.length <= 1) {
	            //we have only key property defined
	            var up = new UserDefinedProp("value");
	            up.withDomain(this);
	            up._node = this.getDeclaringNode();
	            up.withCanBeValue();
	            up.withRequired(false);
	            up.withRange(this.universe().getType("StringType"));
	            var rr = [].concat(result);
	            rr.push(up);
	            return rr;
	        }
	        return result;
	    };
	    return AnnotationType;
	})(UserDefinedClass);
	exports.AnnotationType = AnnotationType;
	var Universe = (function (_super) {
	    __extends(Universe, _super);
	    function Universe(name, _parent, v) {
	        if (name === void 0) { name = ""; }
	        if (_parent === void 0) { _parent = null; }
	        if (v === void 0) { v = "RAML08"; }
	        _super.call(this, name);
	        this._parent = _parent;
	        this._classes = [];
	        this._uversion = "RAML08";
	        this.aMap = {};
	        this._uversion = v;
	    }
	    Universe.prototype.setTopLevel = function (t) {
	        this._topLevel = t;
	    };
	    Universe.prototype.getTopLevel = function () {
	        return this._topLevel;
	    };
	    Universe.prototype.setTypedVersion = function (tv) {
	        this._typedVersion = tv;
	    };
	    Universe.prototype.getTypedVersion = function () {
	        return this._typedVersion;
	    };
	    Universe.prototype.version = function () {
	        return this._uversion;
	    };
	    Universe.prototype.setUniverseVersion = function (version) {
	        this._uversion = version;
	    };
	    Universe.prototype.types = function () {
	        var result = [].concat(this._classes);
	        if (this._parent != null) {
	            result = result.concat(this._parent.types());
	        }
	        return result;
	    };
	    Universe.prototype.type = function (name) {
	        if (this.aMap[name]) {
	            return this.aMap[name];
	        }
	        var tp = _.find(this._classes, function (x) { return x.name() == name; });
	        if (tp == null) {
	            if (this._parent) {
	                var tp = this._parent.type(name);
	                if (tp instanceof AbstractType) {
	                    var at = tp;
	                    at._universe = this; //FIXME
	                }
	            }
	        }
	        return tp;
	    };
	    Universe.prototype.getType = function (name) {
	        return this.type(name);
	    };
	    Universe.prototype.register = function (t) {
	        this._classes.push(t);
	        if (t instanceof NodeClass) {
	            this._classes.forEach(function (x) {
	                if (x instanceof NodeClass) {
	                    var nc = x;
	                    if (nc.getExtendedType() == t) {
	                        t.getRuntimeExtenders().push(x);
	                    }
	                }
	            });
	        }
	        return this;
	    };
	    Universe.prototype.registerAlias = function (a, t) {
	        this.aMap[a] = t;
	    };
	    Universe.prototype.unregister = function (t) {
	        this._classes = this._classes.filter(function (x) { return x != t; });
	        var st = t.superTypes();
	        st.forEach(function (x) {
	            var a = x;
	            a._superTypes = a._superTypes.filter(function (x) { return x != t; });
	        });
	        st = t.subTypes();
	        st.forEach(function (x) {
	            var a = x;
	            a._subTypes = a._subTypes.filter(function (x) { return x != t; });
	        });
	        return this;
	    };
	    Universe.prototype.registerSuperClass = function (t0, t1) {
	        var a0 = t0;
	        var a1 = t1;
	        a0._superTypes.push(t1);
	        a1._subTypes.push(t0);
	    };
	    return Universe;
	})(Described);
	exports.Universe = Universe;
	var ValueRestriction = (function () {
	    function ValueRestriction() {
	    }
	    ValueRestriction.prototype.test = function (n, p, value) {
	        throw new Error("Should be overriden in subclasses");
	    };
	    return ValueRestriction;
	})();
	exports.ValueRestriction = ValueRestriction;
	/**
	 * references element in upper hierarchy
	 */
	var ReferenceTo = (function (_super) {
	    __extends(ReferenceTo, _super);
	    function ReferenceTo(_requiredClass) {
	        _super.call(this);
	        this._requiredClass = _requiredClass;
	    }
	    ReferenceTo.prototype.requiredClass = function () {
	        return this._requiredClass;
	    };
	    return ReferenceTo;
	})(ValueRestriction);
	exports.ReferenceTo = ReferenceTo;
	/**
	 * should be fixed set
	 */
	var FixedSetRestriction = (function (_super) {
	    __extends(FixedSetRestriction, _super);
	    function FixedSetRestriction(_allowedValues) {
	        _super.call(this);
	        this._allowedValues = _allowedValues;
	    }
	    FixedSetRestriction.prototype.values = function () {
	        return this._allowedValues;
	    };
	    return FixedSetRestriction;
	})(ValueRestriction);
	exports.FixedSetRestriction = FixedSetRestriction;
	/**
	 * should be reg exp
	 */
	var RegExpRestriction = (function (_super) {
	    __extends(RegExpRestriction, _super);
	    function RegExpRestriction(_regExp) {
	        _super.call(this);
	        this._regExp = _regExp;
	    }
	    RegExpRestriction.prototype.regeExp = function () {
	        return this._regExp;
	    };
	    return RegExpRestriction;
	})(ValueRestriction);
	exports.RegExpRestriction = RegExpRestriction;
	var UnionType = (function () {
	    function UnionType(_base) {
	        this._base = _base;
	    }
	    UnionType.prototype.isUserDefined = function () {
	        return false;
	    };
	    UnionType.prototype.isRuntime = function () {
	        return false;
	    };
	    UnionType.prototype.isArray = function () {
	        return false;
	    };
	    UnionType.prototype.isUnion = function () {
	        return true;
	    };
	    UnionType.prototype.union = function () {
	        return null;
	    };
	    UnionType.prototype.getRuntimeExtenders = function () {
	        return [];
	    };
	    UnionType.prototype.methods = function () {
	        return [];
	    };
	    UnionType.prototype.superTypes = function () {
	        return [];
	    };
	    UnionType.prototype.allSuperTypes = function () {
	        return [];
	    };
	    UnionType.prototype.isAssignableFrom = function (typeName) {
	        return false;
	    };
	    UnionType.prototype.subTypes = function () {
	        return [];
	    };
	    UnionType.prototype.name = function () {
	        return this._base.map(function (x) { return x.name(); }).join(",");
	    };
	    UnionType.prototype.hasStructure = function () {
	        return false;
	    };
	    UnionType.prototype.description = function () {
	        return "";
	    };
	    UnionType.prototype.isValid = function () {
	        return true;
	    };
	    UnionType.prototype.universe = function () {
	        return this._base[0].universe();
	    };
	    UnionType.prototype.match = function (r) {
	        return false;
	    };
	    UnionType.prototype.allSubTypes = function () {
	        throw new Error("Union types should not be used in this context");
	    };
	    UnionType.prototype.annotations = function () {
	        throw new Error("Union types should not be used in this context");
	    };
	    UnionType.prototype.allProperties = function () {
	        throw new Error("Union types should be never used in this context");
	    };
	    UnionType.prototype.getAlternatives = function () {
	        return [].concat(this._base);
	    };
	    UnionType.prototype.valueRequirements = function () {
	        throw new Error("Union types should be never used in this context");
	    };
	    UnionType.prototype.toRuntime = function () {
	        throw new Error("Not implemented");
	    };
	    UnionType.prototype.properties = function () {
	        var res = [];
	        this._base.forEach(function (x) { return res.concat(x.properties()); });
	        return res;
	    };
	    UnionType.prototype.isValueType = function () {
	        if (this._base.filter(function (x) { return (x.isValueType() == true); }).length == this._base.length) {
	            return true;
	        }
	        if (this._base.filter(function (x) { return (x.isValueType() == false); }).length == this._base.length) {
	            return false;
	        }
	        return null;
	    };
	    UnionType.prototype.isUnionType = function () {
	        return true;
	    };
	    return UnionType;
	})();
	exports.UnionType = UnionType;
	var PropertyTrait = (function () {
	    function PropertyTrait() {
	    }
	    return PropertyTrait;
	})();
	exports.PropertyTrait = PropertyTrait;
	var DefinesImplicitKey = (function (_super) {
	    __extends(DefinesImplicitKey, _super);
	    function DefinesImplicitKey(_where, _childKeyDefined) {
	        _super.call(this);
	        this._where = _where;
	        this._childKeyDefined = _childKeyDefined;
	    }
	    DefinesImplicitKey.prototype.where = function () {
	        return this._where;
	    };
	    DefinesImplicitKey.prototype.definesKeyOf = function () {
	        return this._childKeyDefined;
	    };
	    return DefinesImplicitKey;
	})(PropertyTrait);
	exports.DefinesImplicitKey = DefinesImplicitKey;
	var ExpansionTrait = (function (_super) {
	    __extends(ExpansionTrait, _super);
	    function ExpansionTrait() {
	        _super.call(this);
	    }
	    return ExpansionTrait;
	})(PropertyTrait);
	exports.ExpansionTrait = ExpansionTrait;
	function prop(name, desc, domain, range) {
	    var prop = new Property(name, desc);
	    return prop.withDomain(domain).withRange(range);
	}
	exports.prop = prop;
	var ChildValueConstraint = (function () {
	    function ChildValueConstraint(name, value) {
	        this.name = name;
	        this.value = value;
	    }
	    return ChildValueConstraint;
	})();
	exports.ChildValueConstraint = ChildValueConstraint;
	var Property = (function (_super) {
	    __extends(Property, _super);
	    function Property() {
	        _super.apply(this, arguments);
	        this._keyShouldStartFrom = null;
	        this._isMultiValue = false;
	        this._isFromParentValue = false;
	        this._isFromParentKey = false;
	        this._isRequired = false;
	        this._key = false;
	        this._traits = [];
	        this._describes = null;
	        this._descriminates = false;
	        this._selfNode = false;
	        this._contextReq = [];
	        this._vrestr = [];
	        this.determinesChildValues = [];
	    }
	    Property.prototype.withNoDirectParse = function () {
	        this._noDirectParse = true;
	    };
	    Property.prototype.isNoDirectParse = function () {
	        return this._noDirectParse;
	    };
	    Property.prototype.setDocTableName = function (val) {
	        this._docTableName = val;
	    };
	    Property.prototype.docTableName = function () {
	        return this._docTableName;
	    };
	    Property.prototype.setHidden = function (val) {
	        this._isHidden = val;
	    };
	    Property.prototype.isHidden = function () {
	        return this._isHidden;
	    };
	    Property.prototype.setMarkdownDescription = function (val) {
	        this._markdownDescription = val;
	    };
	    Property.prototype.markdownDescription = function () {
	        return this._markdownDescription;
	    };
	    Property.prototype.setValueDescription = function (val) {
	        this._valueDescription = val;
	    };
	    Property.prototype.valueDescription = function () {
	        return this._valueDescription;
	    };
	    Property.prototype.isExampleProperty = function () {
	        return this.domain() && (!this.domain().isUserDefined()) && (this.name() == "example" || this.name() == "content");
	    };
	    Property.prototype.getFacetValidator = function () {
	        return this.facetValidator;
	    };
	    Property.prototype.setFacetValidator = function (f) {
	        this.facetValidator = f;
	    };
	    Property.prototype.withSelfNode = function () {
	        this._selfNode = true;
	    };
	    Property.prototype.isSelfNode = function () {
	        return this._selfNode;
	    };
	    Property.prototype.getSelector = function (h) {
	        var sl = this._selector;
	        if (sl instanceof selector.Selector) {
	            return sl;
	        }
	        if (!h) {
	            return null;
	        }
	        if (this._selector) {
	            return selector.parse(h, this._selector);
	        }
	        return null;
	    };
	    Property.prototype.setSelector = function (s) {
	        this._selector = s;
	        return this;
	    };
	    Property.prototype.valueDocProvider = function () {
	        return this._vprovider;
	    };
	    Property.prototype.setValueDocProvider = function (v) {
	        this._vprovider = v;
	        return this;
	    };
	    Property.prototype.suggester = function () {
	        return this._suggester;
	    };
	    Property.prototype.setValueSuggester = function (s) {
	        this._suggester = s;
	    };
	    Property.prototype.enumOptions = function () {
	        if (this._enumOptions && typeof this._enumOptions == 'string') {
	            return [this._enumOptions + ""];
	        }
	        return this._enumOptions;
	    };
	    Property.prototype.getOftenKeys = function () {
	        return this._oftenKeys;
	    };
	    Property.prototype.withOftenKeys = function (keys) {
	        this._oftenKeys = keys;
	        return this;
	    };
	    Property.prototype.withCanBeValue = function () {
	        this._canBeValue = true;
	        return this;
	    };
	    Property.prototype.withInherited = function (w) {
	        this._isInherited = w;
	    };
	    Property.prototype.isInherited = function () {
	        return this._isInherited;
	    };
	    Property.prototype.isAllowNull = function () {
	        return this._isAllowNull;
	    };
	    Property.prototype.withAllowNull = function () {
	        this._isAllowNull = true;
	    };
	    Property.prototype.isDescriminator = function () {
	        return this._descriminates;
	    };
	    Property.prototype.getCanBeDuplicator = function () {
	        return this._canBeDuplicator;
	    };
	    Property.prototype.isValue = function () {
	        return this._isFromParentValue;
	    };
	    Property.prototype.canBeValue = function () {
	        return this._canBeValue;
	    };
	    Property.prototype.setCanBeDuplicator = function () {
	        this._canBeDuplicator = true;
	        return true;
	    };
	    Property.prototype.inheritedContextValue = function () {
	        return this._inheritsValueFromContext;
	    };
	    Property.prototype.withInheritedContextValue = function (v) {
	        this._inheritsValueFromContext = v;
	        return this;
	    };
	    Property.prototype.withPropertyGrammarType = function (pt) {
	        this._propertyGrammarType = pt;
	    };
	    Property.prototype.getPropertyGrammarType = function () {
	        return this._propertyGrammarType;
	    };
	    Property.prototype.withContextRequirement = function (name, value) {
	        this._contextReq.push({ name: name, value: value });
	    };
	    Property.prototype.getContextRequirements = function () {
	        return this._contextReq;
	    };
	    Property.prototype.withDescriminating = function (b) {
	        this._descriminates = b;
	        return this;
	    };
	    Property.prototype.isDescriminating = function () {
	        return this._descriminates;
	    };
	    Property.prototype.withDescribes = function (a) {
	        this._describes = a;
	        return this;
	    };
	    Property.prototype.withValueRewstrinction = function (exp, message) {
	        this._vrestr.push({ exp: exp, message: message });
	        return this;
	    };
	    Property.prototype.getValueRestrictionExpressions = function () {
	        return this._vrestr;
	    };
	    Property.prototype.describesAnnotation = function () {
	        return this._describes != null;
	    };
	    Property.prototype.describedAnnotation = function () {
	        return this._describes;
	    };
	    Property.prototype.createAttr = function (val) {
	        var lowLevel = jsyaml.createMapping(this.name(), val);
	        var nm = new hlimpl.ASTPropImpl(lowLevel, null, this.range(), this);
	        return nm;
	    };
	    Property.prototype.isReference = function () {
	        return this.range() instanceof ReferenceType;
	    };
	    Property.prototype.referencesTo = function () {
	        return this.range().getReferencedType();
	    };
	    Property.prototype.newInstanceName = function () {
	        if (this._newInstanceName) {
	            return this._newInstanceName;
	        }
	        return this.range().name();
	    };
	    Property.prototype.withThisPropertyDeclaresFields = function (b) {
	        if (b === void 0) { b = true; }
	        this._declaresFields = b;
	        return this;
	    };
	    Property.prototype.isThisPropertyDeclaresTypeFields = function () {
	        return this._declaresFields;
	    };
	    Property.prototype.withNewInstanceName = function (name) {
	        this._newInstanceName = name;
	        return this;
	    };
	    Property.prototype.addChildValueConstraint = function (c) {
	        this.determinesChildValues.push(c);
	    };
	    Property.prototype.setDefaultVal = function (s) {
	        this._defaultVal = s;
	        return this;
	    };
	    Property.prototype.defaultValue = function () {
	        return this._defaultVal;
	    };
	    Property.prototype.getChildValueConstraints = function () {
	        return this.determinesChildValues;
	    };
	    Property.prototype.childRestrictions = function () {
	        return this.determinesChildValues;
	    };
	    Property.prototype.isSystem = function () {
	        return this._isSystem;
	    };
	    Property.prototype.withSystem = function (s) {
	        this._isSystem = s;
	        return this;
	    };
	    Property.prototype.isEmbedMap = function () {
	        return this._isEmbedMap;
	    };
	    Property.prototype.withEmbedMap = function () {
	        this._isEmbedMap = true;
	        return this;
	    };
	    Property.prototype.id = function () {
	        if (this._id) {
	            return this._id;
	        }
	        if (!this._groupName) {
	            return null;
	        }
	        if (this.domain().getDeclaringNode()) {
	            return null;
	        }
	        this._id = this._groupName + this.domain().name();
	        return this._id;
	    };
	    Property.prototype.isValidValue = function (vl, c) {
	        var node = search.declRoot(c);
	        if (!node._cach) {
	            node._cach = {};
	        }
	        var id = this.id();
	        if (id) {
	            var cached = node._cach[id];
	            if (cached) {
	                return cached[vl] != null;
	            }
	        }
	        var vls = this.enumValues(c);
	        var mm = {};
	        vls.forEach(function (x) { return mm[x] = 1; });
	        if (this._groupName) {
	            node._cach[id] = mm;
	        }
	        return mm[vl] != null;
	    };
	    Property.prototype.enumValues = function (c) {
	        if (c) {
	            var rs = [];
	            //TODO FIXME it is very very weird idea but I need to get it working right now
	            if (this.isTypeExpr()) {
	                var definitionNodes = search.globalDeclarations(c).filter(function (node) {
	                    if (node.definition().name() == "GlobalSchema") {
	                        return true;
	                    }
	                    var st = node.definition().allSuperTypes();
	                    if (_.find(st, function (x) { return x.name() == "DataElement"; })) {
	                        return true;
	                    }
	                    return node.definition().name() == "DataElement" && node.property().name() == 'models';
	                    //return true;
	                });
	                rs = definitionNodes.map(function (x) { return hlimpl.qName(x, c); });
	                var de = c.definition().universe().getType("DataElement");
	                if (de) {
	                    var subTypes = de.allSubTypes();
	                    rs = rs.concat(subTypes.map(function (x) { return x.descriminatorValue(); }));
	                }
	                return rs;
	            }
	            else {
	                if (this.range().name() == "SchemaString") {
	                    if (this.range().universe().version() == "RAML10") {
	                        if (this.range() instanceof defs.ValueType) {
	                            var definitionNodes = search.globalDeclarations(c).filter(function (node) {
	                                if (node.definition().name() == "GlobalSchema") {
	                                    return true;
	                                }
	                                var st = node.definition().allSuperTypes();
	                                if (_.find(st, function (x) { return x.name() == "DataElement"; })) {
	                                    return true;
	                                }
	                                return node.definition().name() == "DataElement" && node.property().name() == 'models';
	                                //return true;
	                            });
	                            rs = definitionNodes.map(function (x) { return hlimpl.qName(x, c); });
	                        }
	                    }
	                }
	            }
	            if (this.isDescriminating()) {
	                var subTypes = search.subTypesWithLocals(this.domain(), c);
	                rs = rs.concat(subTypes.map(function (x) { return x.descriminatorValue(); }));
	            }
	            else if (this.isReference()) {
	                rs = search.nodesDeclaringType(this.referencesTo(), c).map(function (x) { return hlimpl.qName(x, c); });
	            }
	            else if (this.range().isValueType() && this.range() instanceof ValueType) {
	                var vt = this.range();
	                if (vt.globallyDeclaredBy().length > 0) {
	                    var definitionNodes = search.globalDeclarations(c).filter(function (z) { return _.find(vt.globallyDeclaredBy(), function (x) { return x == z.definition(); }) != null; });
	                    rs = rs.concat(definitionNodes.map(function (x) { return hlimpl.qName(x, c); }));
	                }
	            }
	            if (this.isAllowNull()) {
	                rs.push("null");
	            }
	            if (this._enumOptions) {
	                rs = rs.concat(this._enumOptions);
	            }
	            return rs;
	        }
	        if (this._enumOptions && typeof this._enumOptions == 'string') {
	            return [this._enumOptions + ""];
	        }
	        return this._enumOptions;
	    };
	    Property.prototype.isTypeExpr = function () {
	        if (this.teDef && false) {
	            return this.texpr;
	        }
	        if (this.domain()) {
	            this.texpr = ((this.name() == "type" || this.name() == "schema") && this.domain().name() == "DataElement") || (this.name() == "schema" && this.domain().name() == "BodyLike") || (this.name() == "type" && this.domain().name() == "BodyLike") || (this.name() == "signature" && this.domain().name() == "Resource") || (this.name() == "signature" && this.domain().name() == "MethodBase");
	        }
	        if (!this.texpr) {
	            if (this.range().name() == "SchemaString") {
	                if (this.range().universe().version() == "RAML10") {
	                    if (this.range() instanceof defs.ValueType) {
	                        this.texpr = true;
	                    }
	                }
	            }
	        }
	        this.teDef = true;
	        return this.texpr;
	    };
	    Property.prototype.priority = function () {
	        if (this.isKey())
	            return 128;
	        else if (this.isReference())
	            return 64;
	        else if (this.isTypeExpr())
	            return 32;
	        else if (this.name() == 'example')
	            return 0;
	        else
	            return -1024;
	    };
	    Property.prototype.referenceTargets = function (c) {
	        if (this.isTypeExpr()) {
	            var definitionNodes = search.globalDeclarations(c).filter(function (node) {
	                if (node.definition().name() == "GlobalSchema") {
	                    return true;
	                }
	                var st = node.definition().allSuperTypes();
	                if (_.find(st, function (x) { return x.name() == "DataElement"; })) {
	                    return true;
	                }
	                return node.definition().name() == "DataElement" && node.property().name() == 'models';
	                //return true;
	            });
	            return definitionNodes;
	        }
	        if (this.isDescriminating()) {
	            var subTypes = search.nodesDeclaringType(this.range(), c);
	            return subTypes;
	        }
	        if (this.isReference()) {
	            var rt = this.referencesTo();
	            var subTypes = search.nodesDeclaringType(rt, c);
	            return subTypes;
	        }
	        if (this.range().isValueType()) {
	            var vt = this.range();
	            if (vt.globallyDeclaredBy().length > 0) {
	                var definitionNodes = search.globalDeclarations(c).filter(function (z) { return _.find(vt.globallyDeclaredBy(), function (x) { return x == z.definition(); }) != null; });
	                return definitionNodes;
	            }
	        }
	        return [];
	    };
	    Property.prototype.getEnumOptions = function () {
	        if (this._enumOptions && typeof this._enumOptions == 'string') {
	            return [this._enumOptions + ""];
	        }
	        return this._enumOptions;
	    };
	    Property.prototype.withEnumOptions = function (op) {
	        this._enumOptions = op;
	        return this;
	    };
	    Property.prototype.withDomain = function (d) {
	        this._ownerClass = d;
	        d.registerProperty(this);
	        return this;
	    };
	    Property.prototype.withRange = function (t) {
	        this._nodeRange = t;
	        return this;
	    };
	    Property.prototype.getTraits = function () {
	        return this._traits;
	    };
	    Property.prototype.keyPrefix = function () {
	        return this._keyShouldStartFrom;
	    };
	    Property.prototype.isAnnotation = function () {
	        return this._groupName == 'annotations' && this.domain() && !this.domain().isUserDefined();
	    };
	    Property.prototype.matchKey = function (k) {
	        if (k == null) {
	            return false;
	        }
	        if (this._groupName != null) {
	            if (this.isAnnotation()) {
	                if (k.charAt(0) == '(' && k.charAt(k.length - 1) == ')') {
	                    return true;
	                }
	                return false;
	            }
	            return this._groupName == k;
	        }
	        else {
	            if (this._keyShouldStartFrom != null) {
	                if (k.indexOf(this._keyShouldStartFrom) == 0) {
	                    return true;
	                }
	            }
	            if (this._enumOptions) {
	                if (this._enumOptions.indexOf(k) != -1) {
	                    return true;
	                }
	            }
	            if (this.getKeyRegexp()) {
	                try {
	                    if (new RegExp(this.getKeyRegexp()).test(k)) {
	                        return true;
	                    }
	                }
	                catch (Error) {
	                }
	            }
	            return false;
	        }
	    };
	    Property.prototype.withMultiValue = function (v) {
	        if (v === void 0) { v = true; }
	        this._isMultiValue = v;
	        return this;
	    };
	    Property.prototype.withFromParentValue = function (v) {
	        if (v === void 0) { v = true; }
	        this._isFromParentValue = v;
	        return this;
	    };
	    Property.prototype.withFromParentKey = function (v) {
	        if (v === void 0) { v = true; }
	        this._isFromParentKey = v;
	        return this;
	    };
	    Property.prototype.isFromParentKey = function () {
	        return this._isFromParentKey;
	    };
	    Property.prototype.isFromParentValue = function () {
	        return this._isFromParentValue;
	    };
	    Property.prototype.withGroupName = function (gname) {
	        this._groupName = gname;
	        return this;
	    };
	    Property.prototype.withRequired = function (req) {
	        this._isRequired = req;
	        return this;
	    };
	    Property.prototype.unmerge = function () {
	        this._groupName = this.name();
	        return this;
	    };
	    Property.prototype.merge = function () {
	        this._groupName = null;
	        return this;
	    };
	    Property.prototype.withKey = function (isKey) {
	        this._key = isKey;
	        return this;
	    };
	    /**
	     * TODO THIS STUFF SHOULD BE MORE ABSTRACT (LATER...)
	     * @param keyShouldStartFrom
	     * @returns {Property}
	     */
	    Property.prototype.withKeyRestriction = function (keyShouldStartFrom) {
	        this._keyShouldStartFrom = keyShouldStartFrom;
	        return this;
	    };
	    Property.prototype.withKeyRegexp = function (regexp) {
	        this._keyRegexp = regexp;
	    };
	    Property.prototype.getKeyRegexp = function () {
	        return this._keyRegexp;
	    };
	    Property.prototype.domain = function () {
	        return this._ownerClass;
	    };
	    Property.prototype.range = function () {
	        return this._nodeRange;
	    };
	    Property.prototype.isKey = function () {
	        return this._key;
	    };
	    Property.prototype.isValueProperty = function () {
	        return this._nodeRange.isValueType();
	    };
	    Property.prototype.isRequired = function () {
	        return this._isRequired;
	    };
	    Property.prototype.isMultiValue = function () {
	        if (this.range() && this.range() instanceof Array) {
	            return true;
	        }
	        return this._isMultiValue;
	    };
	    Property.prototype.isMerged = function () {
	        return this._groupName == null;
	    };
	    Property.prototype.isPrimitive = function () {
	        var name = this._nodeRange.name();
	        return name == 'StringType' || name == 'NumberType' || name == 'BooleanType';
	    };
	    Property.prototype.groupName = function () {
	        return this._groupName;
	    };
	    return Property;
	})(Described);
	exports.Property = Property;
	var Array = (function (_super) {
	    __extends(Array, _super);
	    function Array() {
	        _super.apply(this, arguments);
	    }
	    Array.prototype.isArray = function () {
	        return true;
	    };
	    Array.prototype.isUserDefined = function () {
	        return true;
	    };
	    Array.prototype.componentType = function () {
	        return this.component;
	    };
	    Array.prototype.findFacets = function (node, x) {
	        if (node) {
	            var chd = node.lowLevel().children();
	            var mi = _.find(chd, function (x) { return x.key() == "minItems"; });
	            if (mi) {
	                x[mi.key()] = mi;
	            }
	            var mi = _.find(chd, function (x) { return x.key() == "maxItems"; });
	            if (mi) {
	                x[mi.key()] = mi;
	            }
	            var mi = _.find(chd, function (x) { return x.key() == "uniqueItems"; });
	            if (mi) {
	                x[mi.key()] = mi;
	            }
	        }
	    };
	    Array.prototype.isValid = function (h, v, p) {
	        if (this.component) {
	            return this.component.isValid(h, v, p);
	        }
	        return true;
	    };
	    Array.prototype.toRuntime = function () {
	        var rs = new Array(this.name(), this.universe(), "");
	        rs._af = {};
	        var fs = this.getFixedFacets();
	        for (var i in fs) {
	            rs._af[i] = fs[i];
	        }
	        rs._representationOf = this;
	        rs.component = this.component ? this.component.toRuntime() : this.component;
	        rs.dimensions = this.dimensions;
	        return rs;
	    };
	    return Array;
	})(NodeClass);
	exports.Array = Array;
	var ExternalType = (function (_super) {
	    __extends(ExternalType, _super);
	    function ExternalType() {
	        _super.apply(this, arguments);
	    }
	    ExternalType.prototype.isUserDefined = function () {
	        return true;
	    };
	    return ExternalType;
	})(NodeClass);
	exports.ExternalType = ExternalType;
	var Union = (function (_super) {
	    __extends(Union, _super);
	    function Union() {
	        _super.apply(this, arguments);
	    }
	    Union.prototype.leftType = function () {
	        return this.left;
	    };
	    Union.prototype.rightType = function () {
	        return this.right;
	    };
	    Union.prototype.isUserDefined = function () {
	        return true;
	    };
	    Union.prototype.toRuntime = function () {
	        return this;
	    };
	    Union.prototype.union = function () {
	        return this;
	    };
	    Union.prototype.isUnion = function () {
	        return true;
	    };
	    Union.prototype.isArray = function () {
	        if (this.left && this.right) {
	            return this.left.isArray() || this.right.isArray();
	        }
	        if (this.left) {
	            return this.left.isArray();
	        }
	        if (this.right) {
	            return this.right.isArray();
	        }
	    };
	    return Union;
	})(NodeClass);
	exports.Union = Union;
	var UserDefinedProp = (function (_super) {
	    __extends(UserDefinedProp, _super);
	    function UserDefinedProp() {
	        _super.apply(this, arguments);
	    }
	    UserDefinedProp.prototype.node = function () {
	        return this._node;
	    };
	    return UserDefinedProp;
	})(Property);
	exports.UserDefinedProp = UserDefinedProp;
	//# sourceMappingURL=definitionSystem.js.map

/***/ },
/* 22 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../typings/tsd.d.ts" />
	var __extends = this.__extends || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    __.prototype = b.prototype;
	    d.prototype = new __();
	};
	var tsutil = __webpack_require__(23);
	var _ = __webpack_require__(47);
	var assert = __webpack_require__(74);
	var Opt = __webpack_require__(5);
	exports.MODEL_CLASS_MODEL_ELEMENT = '$resource-model-element';
	exports.MODEL_CLASS_TYPE_DECLARATION = '$type-declaration';
	exports.MODEL_CLASS_INTERFACE = '$interface-declaration';
	exports.MODEL_CLASS_CLASS_DECLARATION = '$class-declaration';
	exports.MODEL_CLASS_ANNOTATION_DECLARATION = '$annotation-declaration';
	exports.MODEL_CLASS_ENUM_DECLARATION = '$enum-declaration';
	exports.MODEL_CLASS_TYPE_ASSERTION = '$type-assertion';
	exports.MODEL_CLASS_API_MODULE = '$api-module';
	exports.MODEL_CLASS_UNIVERSE = '$universe';
	exports.MODEL_CLASS_MEMBER = '$member';
	exports.MODEL_CLASS_UNION_TYPE_REFERENCE = '$union-type-reference';
	exports.MODEL_CLASS_SIMPLE_TYPE_REFERENCE = '$simple-type-reference';
	exports.MODEL_CLASS_FUNCTION_REFERENCE = '$function-reference';
	exports.MODEL_CLASS_ARRAY_REFERENCE = '$array-reference';
	exports.MODEL_CLASS_DECLARED_INTERFACE_REFERENCE = '$declared-interface-reference';
	exports.MODEL_CLASS_ANY_TYPE_REFERENCE = '$any-type-reference';
	exports.MODEL_CLASS_STRUCTURAL_TYPE_REFERENCE = '$structural-type-reference';
	exports.MODEL_CLASS_PARAM = '$param';
	exports.MODEL_CLASS_STRING_VALUE = '$string-value';
	exports.MODEL_CLASS_ARRAY_VALUE = '$array-value';
	exports.MODEL_CLASS_API_ELEMENT_DECLARATION = '$api-element-declaration';
	exports.MODEL_CLASS_CONSTRUCTOR = '$constructor';
	//TODO HIDE Fields from unmanagable modification
	//TODO Refine type decl type ref hieararchy a bit more
	//TODO add classes, generics, metadata
	var TSModelElement = (function () {
	    function TSModelElement(parent, config) {
	        if (parent === void 0) { parent = exports.Universe; }
	        this.meta = {};
	        this._annotations = [];
	        this._parent = parent;
	        this._config = config ? config : parent._config;
	        this._children = [];
	        assert(parent, "Should never be null");
	        this._parent.addChild(this);
	    }
	    TSModelElement.prototype.annotations = function () {
	        return this._annotations;
	    };
	    TSModelElement.prototype.patchParent = function (parent) {
	        this._parent = parent; //FIXME
	    };
	    TSModelElement.prototype.isEmpty = function () {
	        return this._children.length == 0;
	    };
	    TSModelElement.prototype.parent = function () {
	        return this._parent;
	    };
	    TSModelElement.prototype.children = function () {
	        return this._children;
	    };
	    TSModelElement.prototype.root = function () {
	        if (this._parent == exports.Universe) {
	            return this;
	        }
	        return this._parent.root();
	    };
	    TSModelElement.prototype.removeChild = function (child) {
	        if (child._parent == this) {
	            this._children = this._children.filter(function (x) { return x != child; });
	        }
	        child._parent = exports.Universe;
	    };
	    TSModelElement.prototype.addChild = function (child) {
	        if (child._parent) {
	            child._parent.removeChild(child);
	        }
	        child._parent = this;
	        this._children.push(child);
	    };
	    TSModelElement.prototype.serializeToString = function () {
	        throw new Error("You should override serialize to string always");
	    };
	    TSModelElement.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_MODEL_ELEMENT;
	    };
	    return TSModelElement;
	})();
	exports.TSModelElement = TSModelElement;
	//TODO It should become an interface
	var TSTypeDeclaration = (function (_super) {
	    __extends(TSTypeDeclaration, _super);
	    function TSTypeDeclaration(parent) {
	        var _this = this;
	        if (parent === void 0) { parent = null; }
	        _super.call(this, parent);
	        this.canBeOmmited = function () { return _this.locked ? false : _this.children().every(function (x) { return x.optional; }); };
	        this.locked = false;
	        this.extras = [""];
	    }
	    TSTypeDeclaration.prototype.addCode = function (code) {
	        this.extras.push(code);
	    };
	    TSTypeDeclaration.prototype.toReference = function () {
	        throw new Error("Implement in subclasses");
	    };
	    TSTypeDeclaration.prototype.hash = function () {
	        return this.serializeToString();
	    };
	    TSTypeDeclaration.prototype.isFunctor = function () {
	        return this.children().some(function (x) { return x.isAnonymousFunction(); });
	    };
	    TSTypeDeclaration.prototype.getFunctor = function () {
	        return _.find(this.children(), function (x) { return x.isAnonymousFunction(); });
	    };
	    TSTypeDeclaration.prototype.visit = function (v) {
	        if (v.startTypeDeclaration(this)) {
	            this.children().forEach(function (x, i, arr) {
	                x.visit(v);
	                if (i != arr.length - 1)
	                    v.betweenElements();
	            });
	            v.endTypeDeclaration(this);
	        }
	    };
	    TSTypeDeclaration.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_TYPE_DECLARATION;
	    };
	    return TSTypeDeclaration;
	})(TSModelElement);
	exports.TSTypeDeclaration = TSTypeDeclaration;
	var TSInterface = (function (_super) {
	    __extends(TSInterface, _super);
	    function TSInterface(p, name) {
	        _super.call(this, p);
	        this.extends = [];
	        this.implements = [];
	        this.name = name;
	    }
	    TSInterface.prototype.hash = function () {
	        return this.children().filter(function (x) { return !x.isPrivate; }).map(function (x) { return "\n" + x.serializeToString() + "\n"; }).join('');
	    };
	    TSInterface.prototype.toReference = function () {
	        return new TSDeclaredInterfaceReference(exports.Universe, this.name, this);
	    };
	    TSInterface.prototype.decl = function () {
	        return "interface";
	    };
	    TSInterface.prototype.serializeToString = function () {
	        var body = this.hash();
	        return "export " + this.decl() + " " + this.name.concat(this.extendsString() + this.implementsString()) + "{" + this.extras.join("\n") + body + "}\n";
	    };
	    TSInterface.prototype.extendsString = function () {
	        if (this.extends.length > 0) {
	            return " extends " + this.extends.map(function (x) { return x.serializeToString(); }).join(",");
	        }
	        return "";
	    };
	    TSInterface.prototype.implementsString = function () {
	        if (this.implements.length > 0) {
	            return " implements " + this.implements.map(function (x) { return x.serializeToString(); }).join(",");
	        }
	        return "";
	    };
	    TSInterface.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_INTERFACE;
	    };
	    return TSInterface;
	})(TSTypeDeclaration);
	exports.TSInterface = TSInterface;
	//TODO INCORRECT INHERITANCE CHAIN
	var TSClassDecl = (function (_super) {
	    __extends(TSClassDecl, _super);
	    function TSClassDecl() {
	        _super.apply(this, arguments);
	    }
	    TSClassDecl.prototype.decl = function () {
	        return "class";
	    };
	    TSClassDecl.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_CLASS_DECLARATION;
	    };
	    return TSClassDecl;
	})(TSInterface);
	exports.TSClassDecl = TSClassDecl;
	var TSAnnotationDecl = (function (_super) {
	    __extends(TSAnnotationDecl, _super);
	    function TSAnnotationDecl() {
	        _super.apply(this, arguments);
	    }
	    TSAnnotationDecl.prototype.decl = function () {
	        return "annotation";
	    };
	    TSAnnotationDecl.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_ANNOTATION_DECLARATION;
	    };
	    TSAnnotationDecl.prototype.toReference = function () {
	        return new TSDeclaredAnnotationReference(exports.Universe, this.name, this);
	    };
	    return TSAnnotationDecl;
	})(TSInterface);
	exports.TSAnnotationDecl = TSAnnotationDecl;
	var TSEnumDecl = (function (_super) {
	    __extends(TSEnumDecl, _super);
	    function TSEnumDecl() {
	        _super.apply(this, arguments);
	    }
	    TSEnumDecl.prototype.decl = function () {
	        return "enum";
	    };
	    TSEnumDecl.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_ENUM_DECLARATION;
	    };
	    return TSEnumDecl;
	})(TSInterface);
	exports.TSEnumDecl = TSEnumDecl;
	var TSTypeAssertion = (function (_super) {
	    __extends(TSTypeAssertion, _super);
	    function TSTypeAssertion(p, _name, _ref) {
	        _super.call(this, p);
	        this._name = _name;
	        this._ref = _ref;
	    }
	    TSTypeAssertion.prototype.toReference = function () {
	        return new TSSimpleTypeReference(exports.Universe, this._name);
	    };
	    TSTypeAssertion.prototype.serializeToString = function () {
	        return "export type " + this._name + "=" + this._ref.serializeToString() + "\n";
	    };
	    TSTypeAssertion.prototype.ref = function () {
	        return this._ref;
	    };
	    TSTypeAssertion.prototype.name = function () {
	        return this._name;
	    };
	    TSTypeAssertion.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_TYPE_ASSERTION;
	    };
	    return TSTypeAssertion;
	})(TSTypeDeclaration);
	exports.TSTypeAssertion = TSTypeAssertion;
	var TSUniverse = (function (_super) {
	    __extends(TSUniverse, _super);
	    function TSUniverse() {
	        _super.call(this, this);
	    }
	    TSUniverse.prototype.addChild = function (child) {
	    };
	    TSUniverse.prototype.setConfig = function (cfg) {
	        this._config = cfg;
	    };
	    TSUniverse.prototype.getConfig = function () {
	        return this._config;
	    };
	    TSUniverse.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_UNIVERSE;
	    };
	    return TSUniverse;
	})(TSModelElement);
	exports.TSUniverse = TSUniverse;
	exports.Universe = new TSUniverse();
	var TSAPIModule = (function (_super) {
	    __extends(TSAPIModule, _super);
	    function TSAPIModule() {
	        _super.apply(this, arguments);
	    }
	    TSAPIModule.prototype.getInterface = function (nm) {
	        return new Opt(_.find(this.children(), function (x) { return x.name == nm; }));
	    };
	    TSAPIModule.prototype.serializeToString = function () {
	        var typeMap = {};
	        this.children().forEach(function (x) { return typeMap[x.name] = x; });
	        var covered = {};
	        var sorted = [];
	        var append = function (t) {
	            if (covered[t.name]) {
	                return;
	            }
	            covered[t.name] = true;
	            var refs = t.extends;
	            refs.forEach(function (ref) {
	                if (ref instanceof TSSimpleTypeReference) {
	                    var name = ref.name;
	                    var st = typeMap[name];
	                    if (st) {
	                        append(st);
	                    }
	                }
	            });
	            sorted.push(t);
	        };
	        this.children().forEach(function (x) { return append(x); });
	        return sorted.map(function (x) { return x.serializeToString(); }).join("\n");
	    };
	    TSAPIModule.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_API_MODULE;
	    };
	    return TSAPIModule;
	})(TSModelElement);
	exports.TSAPIModule = TSAPIModule;
	var TSMember = (function (_super) {
	    __extends(TSMember, _super);
	    function TSMember() {
	        _super.apply(this, arguments);
	    }
	    TSMember.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_MEMBER;
	    };
	    return TSMember;
	})(TSModelElement);
	exports.TSMember = TSMember;
	var TSUnionTypeReference = (function (_super) {
	    __extends(TSUnionTypeReference, _super);
	    function TSUnionTypeReference() {
	        _super.apply(this, arguments);
	        this.array = function () { return false; };
	    }
	    TSUnionTypeReference.prototype.getFunctor = function () {
	        return null;
	    };
	    //TODO FIXIT FIX IT WITH MIX IN
	    TSUnionTypeReference.prototype.union = function (q) {
	        var map = {};
	        this.children().filter(function (x) { return x instanceof TSSimpleTypeReference; }).forEach(function (x) { return map[x.name] = true; });
	        var gotNew = false;
	        var flat = flattenUnionType(q);
	        flat.forEach(function (x) {
	            if (x instanceof TSSimpleTypeReference) {
	                gotNew = gotNew || !map[q.name];
	            }
	            else {
	                gotNew = true;
	            }
	        });
	        if (!gotNew) {
	            return this;
	        }
	        var r = new TSUnionTypeReference();
	        this.children().forEach(function (x) { return r.addChild(x); });
	        flat.forEach(function (x) { return r.addChild(x); });
	        return r;
	    };
	    TSUnionTypeReference.prototype.isFunctor = function () {
	        return false;
	    };
	    TSUnionTypeReference.prototype.canBeOmmited = function () {
	        return false;
	    };
	    TSUnionTypeReference.prototype.serializeToString = function () {
	        return this.children().map(function (x) { return x.serializeToString(); }).join(" | ");
	    };
	    TSUnionTypeReference.prototype.removeChild = function (child) {
	    };
	    TSUnionTypeReference.prototype.addChild = function (child) {
	        this.children().push(child);
	    };
	    TSUnionTypeReference.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_UNION_TYPE_REFERENCE;
	    };
	    return TSUnionTypeReference;
	})(TSModelElement);
	exports.TSUnionTypeReference = TSUnionTypeReference;
	var TSSimpleTypeReference = (function (_super) {
	    __extends(TSSimpleTypeReference, _super);
	    function TSSimpleTypeReference(p, tn) {
	        var _this = this;
	        _super.call(this, p);
	        this.array = function () { return false; };
	        this.genericStr = function () { return _this.typeParameters && _this.typeParameters.length > 0 ? '<' + _this.typeParameters.map(function (p) { return p.serializeToString(); }).join(',') + '>' : ''; };
	        this.name = tn;
	    }
	    TSSimpleTypeReference.prototype.isEmpty = function () {
	        return false;
	    };
	    TSSimpleTypeReference.prototype.getFunctor = function () {
	        return null;
	    };
	    TSSimpleTypeReference.prototype.canBeOmmited = function () {
	        return false;
	    };
	    TSSimpleTypeReference.prototype.isFunctor = function () {
	        return false;
	    };
	    TSSimpleTypeReference.prototype.union = function (q) {
	        var _this = this;
	        var flat = flattenUnionType(q);
	        var gotThis = false;
	        flat.filter(function (x) { return x instanceof TSSimpleTypeReference; }).map(function (x) { return x; }).forEach(function (x) { return gotThis = gotThis || (x.name == _this.name); });
	        if (gotThis) {
	            return q;
	        }
	        var r = new TSUnionTypeReference();
	        r.addChild(this);
	        flat.forEach(function (x) { return r.addChild(x); });
	        return r;
	    };
	    TSSimpleTypeReference.prototype.serializeToString = function () {
	        return this.name + this.genericStr();
	    };
	    TSSimpleTypeReference.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_SIMPLE_TYPE_REFERENCE;
	    };
	    return TSSimpleTypeReference;
	})(TSModelElement);
	exports.TSSimpleTypeReference = TSSimpleTypeReference;
	var TSFunctionReference = (function (_super) {
	    __extends(TSFunctionReference, _super);
	    function TSFunctionReference(p) {
	        var _this = this;
	        _super.call(this, p);
	        this.rangeType = new AnyType();
	        this.parameters = [];
	        this.array = function () { return false; };
	        this.paramStr = function (appendDefault) {
	            if (appendDefault === void 0) { appendDefault = false; }
	            return '(' + _this.parameters.filter(function (x) { return !x.isEmpty(); }).map(function (p) { return p.serializeToString(appendDefault); }).join(', ') + ')';
	        };
	    }
	    TSFunctionReference.prototype.isEmpty = function () {
	        return false;
	    };
	    TSFunctionReference.prototype.getFunctor = function () {
	        return null;
	    };
	    TSFunctionReference.prototype.canBeOmmited = function () {
	        return false;
	    };
	    TSFunctionReference.prototype.isFunctor = function () {
	        return true;
	    };
	    TSFunctionReference.prototype.union = function (q) {
	        var r = new TSUnionTypeReference();
	        r.addChild(this);
	        r.addChild(q);
	        return r;
	    };
	    TSFunctionReference.prototype.serializeToString = function () {
	        return this.paramStr() + '=>' + this.rangeType.serializeToString();
	    };
	    TSFunctionReference.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_FUNCTION_REFERENCE;
	    };
	    return TSFunctionReference;
	})(TSModelElement);
	exports.TSFunctionReference = TSFunctionReference;
	var TSArrayReference = (function (_super) {
	    __extends(TSArrayReference, _super);
	    function TSArrayReference(componentType) {
	        if (componentType === void 0) { componentType = new AnyType(); }
	        _super.call(this, exports.Universe);
	        this.array = function () { return true; };
	        this.componentType = componentType;
	    }
	    TSArrayReference.prototype.isEmpty = function () {
	        return this.componentType ? true : false;
	    };
	    TSArrayReference.prototype.getFunctor = function () {
	        return this.componentType.getFunctor();
	    };
	    TSArrayReference.prototype.canBeOmmited = function () {
	        return false;
	    };
	    TSArrayReference.prototype.isFunctor = function () {
	        return this.componentType.isFunctor();
	    };
	    TSArrayReference.prototype.union = function (q) {
	        var r = new TSUnionTypeReference();
	        r.addChild(this);
	        r.addChild(q);
	        return r;
	    };
	    TSArrayReference.prototype.serializeToString = function () {
	        return this.componentType.serializeToString() + '[]';
	    };
	    TSArrayReference.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_ARRAY_REFERENCE;
	    };
	    return TSArrayReference;
	})(TSModelElement);
	exports.TSArrayReference = TSArrayReference;
	var TSDeclaredInterfaceReference = (function (_super) {
	    __extends(TSDeclaredInterfaceReference, _super);
	    function TSDeclaredInterfaceReference(p, tn, _data) {
	        _super.call(this, p, tn);
	        this._data = _data;
	    }
	    TSDeclaredInterfaceReference.prototype.isEmpty = function () {
	        return false;
	    };
	    TSDeclaredInterfaceReference.prototype.getFunctor = function () {
	        return null;
	    };
	    TSDeclaredInterfaceReference.prototype.canBeOmmited = function () {
	        return false;
	    };
	    TSDeclaredInterfaceReference.prototype.getOriginal = function () {
	        return this._data;
	    };
	    TSDeclaredInterfaceReference.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_DECLARED_INTERFACE_REFERENCE;
	    };
	    return TSDeclaredInterfaceReference;
	})(TSSimpleTypeReference);
	exports.TSDeclaredInterfaceReference = TSDeclaredInterfaceReference;
	var TSAnnotationReference = (function (_super) {
	    __extends(TSAnnotationReference, _super);
	    function TSAnnotationReference(p, tn, values) {
	        if (values === void 0) { values = {}; }
	        _super.call(this, p, tn);
	        this.values = values;
	    }
	    TSAnnotationReference.prototype.value = function (key) {
	        if (key === void 0) { key = 'value'; }
	        return this.values[key];
	    };
	    return TSAnnotationReference;
	})(TSSimpleTypeReference);
	exports.TSAnnotationReference = TSAnnotationReference;
	var TSDeclaredAnnotationReference = (function (_super) {
	    __extends(TSDeclaredAnnotationReference, _super);
	    function TSDeclaredAnnotationReference() {
	        _super.apply(this, arguments);
	        this.values = {};
	    }
	    TSDeclaredAnnotationReference.prototype.value = function (key) {
	        if (key === void 0) { key = 'value'; }
	        return this.values[key];
	    };
	    return TSDeclaredAnnotationReference;
	})(TSDeclaredInterfaceReference);
	exports.TSDeclaredAnnotationReference = TSDeclaredAnnotationReference;
	var AnyType = (function (_super) {
	    __extends(AnyType, _super);
	    function AnyType(nm) {
	        if (nm === void 0) { nm = "any"; }
	        _super.call(this, exports.Universe, nm);
	    }
	    AnyType.prototype.union = function (q) {
	        return q;
	    };
	    AnyType.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_ANY_TYPE_REFERENCE;
	    };
	    return AnyType;
	})(TSSimpleTypeReference);
	exports.AnyType = AnyType;
	var TSStructuralTypeReference = (function (_super) {
	    __extends(TSStructuralTypeReference, _super);
	    function TSStructuralTypeReference(parent) {
	        var _this = this;
	        if (parent === void 0) { parent = exports.Universe; }
	        _super.call(this, parent);
	        this.array = function () { return false; };
	        this.canBeOmmited = function () { return _this.locked ? false : _this.children().every(function (x) { return x.optional; }); };
	    }
	    TSStructuralTypeReference.prototype.visitReturnType = function (v) {
	        //v.visitStructuralReturn(this);
	        this.visit(v);
	    };
	    TSStructuralTypeReference.prototype.toReference = function () {
	        return this;
	    };
	    TSStructuralTypeReference.prototype.union = function (q) {
	        var r = new TSUnionTypeReference();
	        r.addChild(this);
	        r.addChild(q);
	        return r;
	    };
	    TSStructuralTypeReference.prototype.serializeToString = function () {
	        var body = this.children().map(function (x) { return ("\n" + x.serializeToString() + "\n"); }).join('');
	        return "{" + body + "}";
	    };
	    TSStructuralTypeReference.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_STRUCTURAL_TYPE_REFERENCE;
	    };
	    return TSStructuralTypeReference;
	})(TSTypeDeclaration);
	exports.TSStructuralTypeReference = TSStructuralTypeReference;
	(function (ParamLocation) {
	    ParamLocation[ParamLocation["URI"] = 0] = "URI";
	    ParamLocation[ParamLocation["BODY"] = 1] = "BODY";
	    ParamLocation[ParamLocation["OPTIONS"] = 2] = "OPTIONS";
	    ParamLocation[ParamLocation["OTHER"] = 3] = "OTHER";
	})(exports.ParamLocation || (exports.ParamLocation = {}));
	var ParamLocation = exports.ParamLocation;
	var Param = (function (_super) {
	    __extends(Param, _super);
	    function Param(p, nm, location, tp, defaultValue) {
	        if (tp === void 0) { tp = new TSSimpleTypeReference(exports.Universe, "string"); }
	        _super.call(this, p);
	        this.name = nm;
	        this.ptype = tp;
	        this.location = location;
	        this.defaultValue = defaultValue;
	    }
	    Param.prototype.isEmpty = function () {
	        return this.ptype.isEmpty();
	    };
	    Param.prototype.serializeToString = function (appendDefault) {
	        if (appendDefault === void 0) { appendDefault = false; }
	        //return this.name + (this.optional ? "?" : "") + ":" + this.ptype.serializeToString() + (this.ptype.canBeOmmited() ? "?" : "");
	        return this.name + (this.optional || (this.defaultValue && !appendDefault) ? "?" : "") + (":" + this.ptype.serializeToString() + (this.ptype.canBeOmmited() ? "?" : "")) + (appendDefault && this.defaultValue ? '=' + JSON.stringify(this.defaultValue) : '');
	    };
	    Param.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_PARAM;
	    };
	    return Param;
	})(TSModelElement);
	exports.Param = Param;
	var StringValue = (function (_super) {
	    __extends(StringValue, _super);
	    function StringValue(_value) {
	        _super.call(this);
	        this._value = _value;
	    }
	    StringValue.prototype.value = function () {
	        return this._value;
	    };
	    StringValue.prototype.serializeToString = function () {
	        return "\"" + this._value + "\"";
	    };
	    StringValue.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_STRING_VALUE;
	    };
	    return StringValue;
	})(TSMember);
	exports.StringValue = StringValue;
	var ArrayValue = (function (_super) {
	    __extends(ArrayValue, _super);
	    function ArrayValue(_values) {
	        _super.call(this);
	        this._values = _values;
	    }
	    ArrayValue.prototype.value = function () {
	        return this.serializeToString();
	    };
	    ArrayValue.prototype.serializeToString = function () {
	        return "[ " + this._values.map(function (x) { return x.value(); }).join(', ') + " ]";
	    };
	    ArrayValue.prototype.values = function () {
	        return this._values;
	    };
	    ArrayValue.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_ARRAY_VALUE;
	    };
	    return ArrayValue;
	})(TSMember);
	exports.ArrayValue = ArrayValue;
	var TSAPIElementDeclaration = (function (_super) {
	    __extends(TSAPIElementDeclaration, _super);
	    function TSAPIElementDeclaration(p, name) {
	        var _this = this;
	        _super.call(this, p);
	        this.rangeType = new AnyType();
	        this.value = null;
	        this.paramStr = function (appendDefault) {
	            if (appendDefault === void 0) { appendDefault = false; }
	            return '( ' + _this.parameters.filter(function (x) { return !x.isEmpty(); }).map(function (p) { return _this.serializeParam(p, appendDefault); }).join(',') + ' )';
	        };
	        this.serializeParam = function (p, appendDefault) { return p.serializeToString(appendDefault); };
	        this.isFunction = function () { return _this.parameters.length != 0 || _this.isFunc; };
	        this.isAnonymousFunction = function () { return _this.isFunction() && _this.name === ''; };
	        this.returnStr = function () { return _this.rangeType ? ':' + _this.rangeType.serializeToString() : ''; };
	        this.name = name;
	        this.parameters = [];
	        this.rangeType = null;
	        this.optional = false;
	    }
	    TSAPIElementDeclaration.prototype.visit = function (v) {
	        if (v.startVisitElement(this)) {
	            if (this.rangeType) {
	                if (this.rangeType instanceof TSStructuralTypeReference && !this.isInterfaceMethodWithBody()) {
	                    this.rangeType.visitReturnType(v);
	                }
	            }
	            v.endVisitElement(this);
	        }
	    };
	    TSAPIElementDeclaration.prototype.commentCode = function () {
	        return "\n        /**\n         *\n         **/\n         //" + this.name + "\n         ";
	    };
	    TSAPIElementDeclaration.prototype.serializeToString = function () {
	        var x = (this.isPrivate ? 'private ' : '') + this.escapeDot(this.name) + (this.optional ? "?" : "") + (this.isFunction() ? this.paramStr() : "") + this.returnStr();
	        if (this.value) {
	            x += '=' + this.value.value();
	        }
	        return this.commentCode() + x + (this.isFunction() && this.isInterfaceMethodWithBody() ? '' : this.body());
	    };
	    TSAPIElementDeclaration.prototype.body = function () {
	        if (this._body == null)
	            return "";
	        return "{" + this._body + "}";
	    };
	    TSAPIElementDeclaration.prototype.escapeDot = function (name) {
	        return tsutil.escapeTypescriptPropertyName(name);
	    };
	    TSAPIElementDeclaration.prototype.isInterfaceMethodWithBody = function () {
	        return false;
	    };
	    TSAPIElementDeclaration.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_API_ELEMENT_DECLARATION;
	    };
	    return TSAPIElementDeclaration;
	})(TSMember);
	exports.TSAPIElementDeclaration = TSAPIElementDeclaration;
	var TSConstructor = (function (_super) {
	    __extends(TSConstructor, _super);
	    function TSConstructor(p) {
	        _super.call(this, p, 'constructor');
	        this.serializeParam = function (p, appendDefault) { return 'protected ' + p.serializeToString(appendDefault); };
	    }
	    TSConstructor.prototype.modelClass = function () {
	        return exports.MODEL_CLASS_CONSTRUCTOR;
	    };
	    return TSConstructor;
	})(TSAPIElementDeclaration);
	exports.TSConstructor = TSConstructor;
	function flattenUnionType(ref) {
	    var _this = this;
	    if (!(ref instanceof TSUnionTypeReference)) {
	        return [ref];
	    }
	    var map = {};
	    var arr = [];
	    ref.children().forEach(function (x) { return _this.flattenUnionType(x).forEach(function (y) {
	        if (y instanceof TSSimpleTypeReference) {
	            var st = y;
	            var name = st.name;
	            map[name] = st;
	        }
	        else {
	            arr.push(y);
	        }
	    }); });
	    return arr.concat(_.sortBy(Object.keys(map).map(function (x) { return map[x]; }), 'name'));
	}
	//# sourceMappingURL=TSDeclModel.js.map

/***/ },
/* 23 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../typings/tsd.d.ts" />
	var ts = __webpack_require__(42);
	// https://github.com/Microsoft/TypeScript/wiki/Using-the-Compiler-API
	function escapeTypescriptPropertyName(str) {
	    return isValidTypescriptIdentifier(str) ? str : JSON.stringify(str);
	}
	exports.escapeTypescriptPropertyName = escapeTypescriptPropertyName;
	// TODO: these are made up lists. check the grammar
	var tsKeywords = 'type class interface break case catch continue debugger default delete do else finally for function if in instanceof new return switch this throw try typeof var void while with'.split(' ');
	var digitCodesL = "0".charCodeAt(0);
	var digitCodesR = "9".charCodeAt(0);
	var lowerCaseCodesL = "a".charCodeAt(0);
	var lowerCaseCodesR = "z".charCodeAt(0);
	var upperCaseCodesL = "A".charCodeAt(0);
	var upperCaseCodesR = "Z".charCodeAt(0);
	var digitChars = {}; //:boolean[] = []
	var validChars = {}; //:boolean[] = []
	for (var i = digitCodesL, end = digitCodesR; i <= end; i++) {
	    digitChars[String.fromCharCode(i)] = true;
	    validChars[String.fromCharCode(i)] = true;
	}
	for (var i = lowerCaseCodesL, end = lowerCaseCodesR; i <= end; i++) {
	    validChars[String.fromCharCode(i)] = true;
	}
	for (var i = upperCaseCodesL, end = upperCaseCodesR; i <= end; i++) {
	    validChars[String.fromCharCode(i)] = true;
	}
	"_ $".split(" ").forEach(function (x) { return validChars[x] = true; });
	function isValidTypescriptIdentifier(str) {
	    str = str.trim();
	    if (str.length == 0) {
	        return false;
	    }
	    if (tsKeywords.indexOf(str) >= 0) {
	        return false;
	    }
	    if (digitChars[str.charAt(0)]) {
	        return false;
	    }
	    for (var i = 0; i < str.length; i++) {
	        if (!validChars[str.charAt(i)]) {
	            return false;
	        }
	    }
	    return true;
	}
	exports.isValidTypescriptIdentifier = isValidTypescriptIdentifier;
	function escapeToIdentifier(str) {
	    str = str.trim();
	    var result = '';
	    if (str.length > 0 && digitChars[str.charAt(0)]) {
	        result += '_';
	    }
	    for (var i = 0; i < str.length; i++) {
	        var ch = str.charAt(i);
	        if (validChars[ch]) {
	            result += ch;
	        }
	        else {
	            result += '_';
	        }
	    }
	    return result;
	}
	exports.escapeToIdentifier = escapeToIdentifier;
	// Note: this uses ts.formatting which is part of the typescript 1.4 package but is not currently
	//       exposed in the public typescript.d.ts. The typings should be exposed in the next release.
	function format(text) {
	    var options = getDefaultOptions();
	    // Parse the source text
	    var sourceFile = ts.createSourceFile("file.ts", text, 2 /* Latest */, "0");
	    fixupParentReferences(sourceFile);
	    // Get the formatting edits on the input sources
	    var edits = ts.formatting.formatDocument(sourceFile, getRuleProvider(options), options);
	    // Apply the edits on the input code
	    return applyEdits(text, edits);
	    function getRuleProvider(options) {
	        // Share this between multiple formatters using the same options.
	        // This represents the bulk of the space the formatter uses.
	        var ruleProvider = new ts.formatting.RulesProvider();
	        ruleProvider.ensureUpToDate(options);
	        return ruleProvider;
	    }
	    function applyEdits(text, edits) {
	        // Apply edits in reverse on the existing text
	        var result = text;
	        for (var i = edits.length - 1; i >= 0; i--) {
	            var change = edits[i];
	            var head = result.slice(0, change.span.start());
	            var tail = result.slice(change.span.start() + change.span.length());
	            result = head + change.newText + tail;
	        }
	        return result;
	    }
	    function getDefaultOptions() {
	        return {
	            IndentSize: 4,
	            TabSize: 4,
	            NewLineCharacter: '\n',
	            ConvertTabsToSpaces: true,
	            InsertSpaceAfterCommaDelimiter: true,
	            InsertSpaceAfterSemicolonInForStatements: true,
	            InsertSpaceBeforeAndAfterBinaryOperators: true,
	            InsertSpaceAfterKeywordsInControlFlowStatements: true,
	            InsertSpaceAfterFunctionKeywordForAnonymousFunctions: false,
	            InsertSpaceAfterOpeningAndBeforeClosingNonemptyParenthesis: false,
	            PlaceOpenBraceOnNewLineForFunctions: false,
	            PlaceOpenBraceOnNewLineForControlBlocks: false
	        };
	    }
	    function fixupParentReferences(sourceFile) {
	        var parent = sourceFile;
	        function walk(n) {
	            n.parent = parent;
	            var saveParent = parent;
	            parent = n;
	            ts.forEachChild(n, walk);
	            parent = saveParent;
	        }
	        ts.forEachChild(sourceFile, walk);
	    }
	}
	exports.format = format;
	var typeMap = {
	    'string': 'string',
	    'integer': 'number',
	    'number': 'number',
	    'boolean': 'boolean',
	    'file': 'string',
	    'date': 'string',
	    'NumberType': 'number'
	};
	function ramlType2TSType(ramlType) {
	    var tsType = typeMap[ramlType];
	    if (!tsType) {
	        tsType = 'any';
	    }
	    return tsType;
	}
	exports.ramlType2TSType = ramlType2TSType;
	function escapeToJavaIdentifier(str) {
	    str = escapeToIdentifier(str);
	    return exports.javaReservedWords[str] ? str + '_' : str;
	}
	exports.escapeToJavaIdentifier = escapeToJavaIdentifier;
	exports.tsToJavaTypeMap = {
	    'number': 'Double',
	    'string': 'String',
	    'boolean': 'Boolean',
	    'any': 'Object'
	};
	exports.javaReservedWords = {
	    "abstract": true,
	    "continue": true,
	    "for": true,
	    "new": true,
	    "switch": true,
	    "assert": true,
	    "default": true,
	    "goto": true,
	    "package": true,
	    "synchronized": true,
	    "boolean": true,
	    "do": true,
	    "if": true,
	    "private": true,
	    "this": true,
	    "break": true,
	    "double": true,
	    "implements": true,
	    "protected": true,
	    "throw": true,
	    "byte": true,
	    "else": true,
	    "import": true,
	    "public": true,
	    "throws": true,
	    "case": true,
	    "enum": true,
	    "instanceof": true,
	    "return": true,
	    "transient": true,
	    "catch": true,
	    "extends": true,
	    "int": true,
	    "short": true,
	    "try": true,
	    "char": true,
	    "final": true,
	    "interface": true,
	    "static": true,
	    "void": true,
	    "class": true,
	    "finally": true,
	    "long": true,
	    "strictfp": true,
	    "volatile": true,
	    "const": true,
	    "float": true,
	    "native": true,
	    "super": true,
	    "while": true
	};
	//# sourceMappingURL=tsutil.js.map

/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

	var def = __webpack_require__(21);
	var td = __webpack_require__(22);
	var util = __webpack_require__(20);
	var parserCoreModuleVar = 'core';
	var ParserGenerator = (function () {
	    function ParserGenerator() {
	        this.mod = new td.TSAPIModule();
	        this.processed = {};
	        this.typeMap = {
	            'StringType': 'string',
	            'NumberType': 'number',
	            'BooleanType': 'boolean'
	        };
	    }
	    ParserGenerator.prototype.processType = function (u, generateConstructor) {
	        var _this = this;
	        var typeName = u.name();
	        if (this.processed[typeName]) {
	            return;
	        }
	        this.processed[typeName] = u;
	        u.superTypes().forEach(function (x) { return _this.processType(x, generateConstructor); });
	        var idcl = new td.TSInterface(this.mod, typeName);
	        var dcl = new td.TSClassDecl(this.mod, typeName + "Impl");
	        if (generateConstructor) {
	            var _constructor = new td.TSConstructor(dcl);
	            _constructor.parameters = [
	                new td.Param(_constructor, 'attr', 3 /* OTHER */, new td.TSSimpleTypeReference(td.Universe, 'hl.IAttribute'))
	            ];
	            if (u.isValueType()) {
	                if (typeName == 'ValueType' || u.superTypes().length == 0) {
	                    _constructor._body = '';
	                }
	                else {
	                    _constructor._body = 'super(attr);';
	                }
	            }
	            else {
	                _constructor._body = 'super()';
	            }
	        }
	        else {
	            if (u instanceof def.NodeClass) {
	                var _constructor = new td.TSConstructor(dcl);
	                _constructor.parameters = [
	                    new td.Param(_constructor, 'nodeOrKey', 3 /* OTHER */, new td.TSSimpleTypeReference(td.Universe, 'hl.IHighLevelNode|string'))
	                ];
	                _constructor._body = "super((typeof  nodeOrKey==\"string\")?create" + u.name() + "(<string>nodeOrKey):<hl.IHighLevelNode>nodeOrKey)";
	            }
	        }
	        this.addImplementationMethod(dcl, 'wrapperClassName', 'string', "return \"" + typeName + "Impl\";");
	        if (typeName == 'ValueType') {
	            this.addInterfaceMethod(idcl, 'value', 'string');
	            this.addImplementationMethod(dcl, 'value', 'string', 'return this.attr.value();');
	            this.addInterfaceMethod(idcl, 'highLevel', 'hl.IAttribute');
	            this.addImplementationMethod(dcl, 'highLevel', 'hl.IAttribute', 'return this.attr;');
	        }
	        else if (typeName == 'Reference') {
	            this.addImplementationMethod(dcl, 'value', 'string', 'return <any>core.toStructuredValue(this.attr);');
	        }
	        dcl.implements.push(new td.TSSimpleTypeReference(td.Universe, idcl.name));
	        u.superTypes().forEach(function (x) {
	            idcl.extends.push(new td.TSSimpleTypeReference(td.Universe, x.name()));
	            dcl.extends.push(new td.TSSimpleTypeReference(td.Universe, x.name() + "Impl"));
	        });
	        u.properties().forEach(function (x) {
	            _this.createMethodDecl(idcl, x);
	            var z = _this.createMethodDecl(dcl, x);
	            z._body = _this.generateBody(x);
	            if (x.isPrimitive()) {
	                _this.createSetterMethodDecl(dcl, x);
	            }
	        });
	        if (dcl.extends.length == 0) {
	            if (u.isValueType()) {
	                idcl.extends.push(new td.TSSimpleTypeReference(td.Universe, "core.AbstractWrapperNode"));
	            }
	            else {
	                idcl.extends.push(new td.TSSimpleTypeReference(td.Universe, "BasicNode"));
	                dcl.extends.push(new td.TSSimpleTypeReference(td.Universe, "BasicNodeImpl"));
	            }
	        }
	        u.subTypes().forEach(function (x) { return _this.processType(x); });
	    };
	    ParserGenerator.prototype.addInterfaceMethod = function (idcl, methodName, returnTypeName) {
	        var method = new td.TSAPIElementDeclaration(idcl, methodName);
	        method.isFunc = true;
	        method.rangeType = new td.TSSimpleTypeReference(method, returnTypeName);
	        return method;
	    };
	    ParserGenerator.prototype.addImplementationMethod = function (dcl, methodName, returnTypeName, body) {
	        var method = this.addInterfaceMethod(dcl, methodName, returnTypeName);
	        method._body = body;
	        return method;
	    };
	    ParserGenerator.prototype.generateBody = function (x) {
	        var rangeType = x.range().name();
	        if (x.isValueProperty()) {
	            var args = [("'" + x.name() + "'")];
	            if (x.isPrimitive()) {
	                rangeType = this.typeMap[rangeType];
	                args.push("this.to" + util.firstToUpper(rangeType));
	            }
	            else {
	                args.push("(attr:hl.IAttribute)=>new " + rangeType + "Impl(attr)");
	            }
	            if (x.isMultiValue()) {
	                return "\n             return <" + rangeType + "[]>super.attributes(" + args.join(', ') + ");\n         ";
	            }
	            else {
	                return "\n             return <" + rangeType + ">super.attribute(" + args.join(', ') + ");\n         ";
	            }
	        }
	        else {
	            if (x.isMultiValue()) {
	                return "\n             return <" + rangeType + "[]>super.elements('" + x.name() + "');\n         ";
	            }
	            else {
	                return "\n             return <" + rangeType + ">super.element('" + x.name() + "');\n         ";
	            }
	        }
	        //if (x.isValueProperty()){
	        //
	        //    var varInit:any;
	        //    if(x.isPrimitive()){
	        //        varInit = function(varStr:string,typeName:string){
	        //            return varStr + '.value()';
	        //        }
	        //    }
	        //    else{
	        //        varInit = function(varStr:string,typeName:string){
	        //            return 'new ' + typeName + 'Impl(' + varStr + ')';
	        //        }
	        //    }
	        //    if(x.isMultiValue()) {
	        //        return `var attrs = this._node.attributes('${x.name()}');
	        //        if (attrs) {
	        //            return attrs.map(x=>${varInit('x', x.range().name())});
	        //        }
	        //        return [];`;
	        //    }
	        //    else{
	        //        return `var attr = this._node.attr('${x.name()}');
	        //        if (attr) {
	        //            var v = ${varInit('attr', x.range().name())};
	        //            return v;
	        //        }
	        //        else {
	        //            return null;
	        //        }`;
	        //    }
	        //}
	        //else{
	        //    if (x.isMultiValue()){
	        //        return `
	        //        var elements = this._node.elementsOfKind('${x.name()}');
	        //        if(elements) {
	        //            return elements.map(x=><${x.range().name()}>x.wrapperNode());
	        //        }
	        //        else {
	        //            return null;
	        //        }
	        //    `;
	        //    }
	        //    else{
	        //        return `
	        //        var v = this._node.element('${x.name()}');
	        //        if(!v){
	        //            return null;
	        //        }
	        //        return <${x.range().name()}>v.wrapperNode();
	        //    `;
	        //    }
	        //}
	    };
	    ParserGenerator.prototype.createSetterMethodDecl = function (dcl, x) {
	        var method = new td.TSAPIElementDeclaration(dcl, "set" + x.name()[0].toUpperCase() + x.name().substr(1));
	        method.isFunc = true;
	        var tname = "string";
	        if (x.isPrimitive()) {
	            tname = this.typeMap[x.range().name()];
	        }
	        else {
	            tname = x.range().name();
	            this.processType(x.range(), x.isValueProperty());
	        }
	        var ref = new td.TSSimpleTypeReference(td.Universe, tname);
	        method.parameters = [
	            new td.Param(method, 'param', 3 /* OTHER */, ref)
	        ];
	        method._body = "\n        {\n        this.highLevel().attrOrCreate(\"" + x.name() + "\").setValue(\"\"+param);\n        return this;\n        }\n        ";
	        return method;
	    };
	    ParserGenerator.prototype.createMethodDecl = function (dcl, x) {
	        var method = new td.TSAPIElementDeclaration(dcl, x.name());
	        method.isFunc = true;
	        var tname = "string";
	        if (x.isPrimitive()) {
	            tname = this.typeMap[x.range().name()];
	        }
	        else {
	            tname = x.range().name();
	            this.processType(x.range(), x.isValueProperty());
	        }
	        var ref = new td.TSSimpleTypeReference(td.Universe, tname);
	        if (x.isMultiValue()) {
	            var aRef = new td.TSArrayReference();
	            aRef.componentType = ref;
	            method.rangeType = aRef;
	        }
	        else {
	            method.rangeType = ref;
	        }
	        return method;
	    };
	    ParserGenerator.prototype.serializeToString = function () {
	        return "import hl=require(\"../highLevelAST\");\nimport hlImpl=require(\"../highLevelImpl\");\nimport jsyaml=require(\"../jsyaml/jsyaml2lowLevel\");\nimport def=require(\"../definitionSystem\");\nimport core=require(\"../parserCore\");\n\n\nexport interface BasicNode extends core.BasicSuperNode{\n\n    parent():BasicNode\n\n    highLevel():hl.IHighLevelNode\n}\n\nexport class BasicNodeImpl extends core.BasicSuperNodeImpl implements BasicNode{\n\n    constructor(node:hl.IHighLevelNode){\n        super(node);\n    }\n\n    wrapperClassName():string{\n        return 'BasicNodeImpl';\n    }\n\n    parent():BasicNode{\n        return <BasicNode>super.parent();\n    }\n}\n\n        " + this.mod.serializeToString() + this.createFunctions();
	    };
	    ParserGenerator.prototype.createFunctions = function () {
	        var res = "";
	        for (var p in this.processed) {
	            var q = this.processed[p];
	            if (q instanceof def.NodeClass) {
	                res += "\nfunction create" + p + "(key:string){\n    var universe=hl.universeProvider(\"RAML10\");\n    var nc=<def.NodeClass>universe.getType(\"" + p + "\");\n    var node=nc.createStubNode(null,key);\n    return node;\n}\n";
	            }
	            ;
	        }
	        return res;
	    };
	    ParserGenerator.prototype.nodeFactory = function (highLevelASTLocation, parserLocation) {
	        return "import RamlWrapper = require(\"" + parserLocation + "\");\nimport hl = require(\"" + highLevelASTLocation + "\")\n\nexport function buildWrapperNode(node:hl.IHighLevelNode){\n\n    var nodeClassName = node.definition().name();\n\n    var wrapperConstructor = classMap[nodeClassName];\n\n    if(!wrapperConstructor){\n        var m=node.definition().allSuperTypes();\n        var wr=null;\n        for (var i=0;i<m.length;i++){\n            var nm=m[i].name();\n            wrapperConstructor = classMap[nm];\n            if (nm==\"DataElement\"){\n                wr=nm;\n                //This is only case of nested hierarchy\n                continue;\n            }\n            if (nm==\"RAMLLanguageElement\"){\n                //depth first\n                continue;\n            }\n            if (wrapperConstructor){\n                break;\n            }\n        }\n        if (!wrapperConstructor){\n            wr=nm;\n        }\n    }\n    if (!wrapperConstructor){\n        wrapperConstructor = classMap[\"RAMLLanguageElement\"]\n\n    }\n    return wrapperConstructor(node);\n}\n\nvar classMap = {\n\n" + Object.keys(this.processed).sort().map(function (x) { return ("    \"" + x + "\": (x)=>{return new RamlWrapper." + x + "Impl(x)}"); }).join(',\n\n') + "\n\n};\n";
	    };
	    return ParserGenerator;
	})();
	function def2Parser(u) {
	    var mod = new ParserGenerator();
	    mod.processType(u);
	    return mod;
	}
	exports.def2Parser = def2Parser;
	var ImplementationGenerator = (function () {
	    function ImplementationGenerator() {
	    }
	    ImplementationGenerator.prototype.generateASTAccessor = function (p) {
	        this.generatedCode.push("var val=this.ast.getValue(" + p.name() + "}");
	        this.generatedCode.push("return new " + p.range().name() + "Impl(val)");
	    };
	    return ImplementationGenerator;
	})();
	function checkIfReference(u) {
	    if (u.name() == 'Reference') {
	        return true;
	    }
	    var superTypes = u.superTypes();
	    for (var i = 0; i < superTypes.length; i++) {
	        var st = superTypes[i];
	        if (checkIfReference(st)) {
	            return true;
	        }
	    }
	    return false;
	}
	exports.checkIfReference = checkIfReference;
	/**
	 * Created by kor on 11/05/15.
	 */
	//# sourceMappingURL=wrappedParserGen.js.map

/***/ },
/* 25 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../typings/tsd.d.ts" />
	var ASTDelta = (function () {
	    function ASTDelta() {
	    }
	    return ASTDelta;
	})();
	exports.ASTDelta = ASTDelta;
	(function (CommandKind) {
	    CommandKind[CommandKind["ADD_CHILD"] = 0] = "ADD_CHILD";
	    CommandKind[CommandKind["REMOVE_CHILD"] = 1] = "REMOVE_CHILD";
	    CommandKind[CommandKind["MOVE_CHILD"] = 2] = "MOVE_CHILD";
	    CommandKind[CommandKind["CHANGE_KEY"] = 3] = "CHANGE_KEY";
	    CommandKind[CommandKind["CHANGE_VALUE"] = 4] = "CHANGE_VALUE";
	    CommandKind[CommandKind["INIT_RAML_FILE"] = 5] = "INIT_RAML_FILE";
	})(exports.CommandKind || (exports.CommandKind = {}));
	var CommandKind = exports.CommandKind;
	var TextChangeCommand = (function () {
	    function TextChangeCommand(offset, replacementLength, text, unit, target) {
	        if (target === void 0) { target = null; }
	        this.offset = offset;
	        this.replacementLength = replacementLength;
	        this.text = text;
	        this.unit = unit;
	        this.target = target;
	    }
	    return TextChangeCommand;
	})();
	exports.TextChangeCommand = TextChangeCommand;
	var CompositeCommand = (function () {
	    function CompositeCommand() {
	        this.commands = [];
	    }
	    return CompositeCommand;
	})();
	exports.CompositeCommand = CompositeCommand;
	var ASTChangeCommand = (function () {
	    function ASTChangeCommand(kind, target, value, position) {
	        this.toSeq = false;
	        this.kind = kind;
	        this.target = target;
	        this.value = value;
	        this.position = position;
	    }
	    return ASTChangeCommand;
	})();
	exports.ASTChangeCommand = ASTChangeCommand;
	function setAttr(t, value) {
	    return new ASTChangeCommand(4 /* CHANGE_VALUE */, t, value, -1);
	}
	exports.setAttr = setAttr;
	function setAttrStructured(t, value) {
	    return new ASTChangeCommand(4 /* CHANGE_VALUE */, t, value.lowLevel(), -1);
	}
	exports.setAttrStructured = setAttrStructured;
	function setKey(t, value) {
	    return new ASTChangeCommand(3 /* CHANGE_KEY */, t, value, -1);
	}
	exports.setKey = setKey;
	function removeNode(t, child) {
	    return new ASTChangeCommand(1 /* REMOVE_CHILD */, t, child, -1);
	}
	exports.removeNode = removeNode;
	function insertNode(t, child, insertAfter, toSeq) {
	    if (insertAfter === void 0) { insertAfter = null; }
	    if (toSeq === void 0) { toSeq = false; }
	    var s = new ASTChangeCommand(0 /* ADD_CHILD */, t, child, -1);
	    s.insertionPoint = insertAfter;
	    s.toSeq = toSeq;
	    return s;
	}
	exports.insertNode = insertNode;
	function initRamlFile(root, newroot) {
	    return new ASTChangeCommand(5 /* INIT_RAML_FILE */, root, newroot, -1);
	}
	exports.initRamlFile = initRamlFile;
	//# sourceMappingURL=lowLevelAST.js.map

/***/ },
/* 26 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../../typings/tsd.d.ts" />
	'use strict';
	var loader = __webpack_require__(60);
	var dumper = __webpack_require__(27);
	function deprecated(name) {
	    return function () {
	        throw new Error('Function ' + name + ' is deprecated and cannot be used.');
	    };
	}
	exports.Type = __webpack_require__(61);
	exports.Schema = __webpack_require__(62);
	exports.FAILSAFE_SCHEMA = __webpack_require__(63);
	exports.JSON_SCHEMA = __webpack_require__(64);
	exports.CORE_SCHEMA = __webpack_require__(65);
	exports.DEFAULT_SAFE_SCHEMA = __webpack_require__(59);
	exports.DEFAULT_FULL_SCHEMA = __webpack_require__(58);
	exports.load = loader.load;
	exports.loadAll = loader.loadAll;
	exports.safeLoad = loader.safeLoad;
	exports.safeLoadAll = loader.safeLoadAll;
	exports.dump = dumper.dump;
	exports.safeDump = dumper.safeDump;
	exports.YAMLException = __webpack_require__(28);
	// Deprecared schema names from JS-YAML 2.0.x
	exports.MINIMAL_SCHEMA = __webpack_require__(63);
	exports.SAFE_SCHEMA = __webpack_require__(59);
	exports.DEFAULT_SCHEMA = __webpack_require__(58);
	// Deprecated functions from JS-YAML 1.x.x
	exports.scan = deprecated('scan');
	exports.parse = deprecated('parse');
	exports.compose = deprecated('compose');
	exports.addConstructor = deprecated('addConstructor');
	//# sourceMappingURL=js-yaml.js.map

/***/ },
/* 27 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../../../typings/tsd.d.ts" />
	'use strict';
	/*eslint-disable no-use-before-define*/
	var common = __webpack_require__(57);
	var YAMLException = __webpack_require__(28);
	var DEFAULT_FULL_SCHEMA = __webpack_require__(58);
	var DEFAULT_SAFE_SCHEMA = __webpack_require__(59);
	var _toString = Object.prototype.toString;
	var _hasOwnProperty = Object.prototype.hasOwnProperty;
	var CHAR_TAB = 0x09; /* Tab */
	var CHAR_LINE_FEED = 0x0A; /* LF */
	var CHAR_CARRIAGE_RETURN = 0x0D; /* CR */
	var CHAR_SPACE = 0x20; /* Space */
	var CHAR_EXCLAMATION = 0x21; /* ! */
	var CHAR_DOUBLE_QUOTE = 0x22; /* " */
	var CHAR_SHARP = 0x23; /* # */
	var CHAR_PERCENT = 0x25; /* % */
	var CHAR_AMPERSAND = 0x26; /* & */
	var CHAR_SINGLE_QUOTE = 0x27; /* ' */
	var CHAR_ASTERISK = 0x2A; /* * */
	var CHAR_COMMA = 0x2C; /* , */
	var CHAR_MINUS = 0x2D; /* - */
	var CHAR_COLON = 0x3A; /* : */
	var CHAR_GREATER_THAN = 0x3E; /* > */
	var CHAR_QUESTION = 0x3F; /* ? */
	var CHAR_COMMERCIAL_AT = 0x40; /* @ */
	var CHAR_LEFT_SQUARE_BRACKET = 0x5B; /* [ */
	var CHAR_RIGHT_SQUARE_BRACKET = 0x5D; /* ] */
	var CHAR_GRAVE_ACCENT = 0x60; /* ` */
	var CHAR_LEFT_CURLY_BRACKET = 0x7B; /* { */
	var CHAR_VERTICAL_LINE = 0x7C; /* | */
	var CHAR_RIGHT_CURLY_BRACKET = 0x7D; /* } */
	var ESCAPE_SEQUENCES = {};
	ESCAPE_SEQUENCES[0x00] = '\\0';
	ESCAPE_SEQUENCES[0x07] = '\\a';
	ESCAPE_SEQUENCES[0x08] = '\\b';
	ESCAPE_SEQUENCES[0x09] = '\\t';
	ESCAPE_SEQUENCES[0x0A] = '\\n';
	ESCAPE_SEQUENCES[0x0B] = '\\v';
	ESCAPE_SEQUENCES[0x0C] = '\\f';
	ESCAPE_SEQUENCES[0x0D] = '\\r';
	ESCAPE_SEQUENCES[0x1B] = '\\e';
	ESCAPE_SEQUENCES[0x22] = '\\"';
	ESCAPE_SEQUENCES[0x5C] = '\\\\';
	ESCAPE_SEQUENCES[0x85] = '\\N';
	ESCAPE_SEQUENCES[0xA0] = '\\_';
	ESCAPE_SEQUENCES[0x2028] = '\\L';
	ESCAPE_SEQUENCES[0x2029] = '\\P';
	var DEPRECATED_BOOLEANS_SYNTAX = [
	    'y',
	    'Y',
	    'yes',
	    'Yes',
	    'YES',
	    'on',
	    'On',
	    'ON',
	    'n',
	    'N',
	    'no',
	    'No',
	    'NO',
	    'off',
	    'Off',
	    'OFF'
	];
	function compileStyleMap(schema, map) {
	    var result, keys, index, length, tag, style, type;
	    if (null === map) {
	        return {};
	    }
	    result = {};
	    keys = Object.keys(map);
	    for (index = 0, length = keys.length; index < length; index += 1) {
	        tag = keys[index];
	        style = String(map[tag]);
	        if ('!!' === tag.slice(0, 2)) {
	            tag = 'tag:yaml.org,2002:' + tag.slice(2);
	        }
	        type = schema.compiledTypeMap[tag];
	        if (type && _hasOwnProperty.call(type.styleAliases, style)) {
	            style = type.styleAliases[style];
	        }
	        result[tag] = style;
	    }
	    return result;
	}
	function encodeHex(character) {
	    var string, handle, length;
	    string = character.toString(16).toUpperCase();
	    if (character <= 0xFF) {
	        handle = 'x';
	        length = 2;
	    }
	    else if (character <= 0xFFFF) {
	        handle = 'u';
	        length = 4;
	    }
	    else if (character <= 0xFFFFFFFF) {
	        handle = 'U';
	        length = 8;
	    }
	    else {
	        throw new YAMLException('code point within a string may not be greater than 0xFFFFFFFF');
	    }
	    return '\\' + handle + common.repeat('0', length - string.length) + string;
	}
	function State(options) {
	    this.schema = options['schema'] || DEFAULT_FULL_SCHEMA;
	    this.indent = Math.max(1, (options['indent'] || 2));
	    this.skipInvalid = options['skipInvalid'] || false;
	    this.flowLevel = (common.isNothing(options['flowLevel']) ? -1 : options['flowLevel']);
	    this.styleMap = compileStyleMap(this.schema, options['styles'] || null);
	    this.implicitTypes = this.schema.compiledImplicit;
	    this.explicitTypes = this.schema.compiledExplicit;
	    this.tag = null;
	    this.result = '';
	    this.duplicates = [];
	    this.usedDuplicates = null;
	}
	function indentString(string, spaces) {
	    var ind = common.repeat(' ', spaces), position = 0, next = -1, result = '', line, length = string.length;
	    while (position < length) {
	        next = string.indexOf('\n', position);
	        if (next === -1) {
	            line = string.slice(position);
	            position = length;
	        }
	        else {
	            line = string.slice(position, next + 1);
	            position = next + 1;
	        }
	        if (line.length && line !== '\n') {
	            result += ind;
	        }
	        result += line;
	    }
	    return result;
	}
	function generateNextLine(state, level) {
	    return '\n' + common.repeat(' ', state.indent * level);
	}
	function testImplicitResolving(state, str) {
	    var index, length, type;
	    for (index = 0, length = state.implicitTypes.length; index < length; index += 1) {
	        type = state.implicitTypes[index];
	        if (type.resolve(str)) {
	            return true;
	        }
	    }
	    return false;
	}
	function StringBuilder(source) {
	    this.source = source;
	    this.result = '';
	    this.checkpoint = 0;
	}
	StringBuilder.prototype.takeUpTo = function (position) {
	    var er;
	    if (position < this.checkpoint) {
	        er = new Error('position should be > checkpoint');
	        er.position = position;
	        er.checkpoint = this.checkpoint;
	        throw er;
	    }
	    this.result += this.source.slice(this.checkpoint, position);
	    this.checkpoint = position;
	    return this;
	};
	StringBuilder.prototype.escapeChar = function () {
	    var character, esc;
	    character = this.source.charCodeAt(this.checkpoint);
	    esc = ESCAPE_SEQUENCES[character] || encodeHex(character);
	    this.result += esc;
	    this.checkpoint += 1;
	    return this;
	};
	StringBuilder.prototype.finish = function () {
	    if (this.source.length > this.checkpoint) {
	        this.takeUpTo(this.source.length);
	    }
	};
	function writeScalar(state, object, level) {
	    var simple, first, spaceWrap, folded, literal, single, double, sawLineFeed, linePosition, longestLine, indent, max, character, position, escapeSeq, hexEsc, previous, lineLength, modifier, trailingLineBreaks, result;
	    if (0 === object.length) {
	        state.dump = "''";
	        return;
	    }
	    if (object.indexOf("!include") == 0) {
	        state.dump = "" + object; //FIXME
	        return;
	    }
	    if (object.indexOf("!$$$novalue") == 0) {
	        state.dump = ""; //FIXME
	        return;
	    }
	    if (-1 !== DEPRECATED_BOOLEANS_SYNTAX.indexOf(object)) {
	        state.dump = "'" + object + "'";
	        return;
	    }
	    simple = true;
	    first = object.length ? object.charCodeAt(0) : 0;
	    spaceWrap = (CHAR_SPACE === first || CHAR_SPACE === object.charCodeAt(object.length - 1));
	    // Simplified check for restricted first characters
	    // http://www.yaml.org/spec/1.2/spec.html#ns-plain-first%28c%29
	    if (CHAR_MINUS === first || CHAR_QUESTION === first || CHAR_COMMERCIAL_AT === first || CHAR_GRAVE_ACCENT === first) {
	        simple = false;
	    }
	    // can only use > and | if not wrapped in spaces.
	    if (spaceWrap) {
	        simple = false;
	        folded = false;
	        literal = false;
	    }
	    else {
	        folded = true;
	        literal = true;
	    }
	    single = true;
	    double = new StringBuilder(object);
	    sawLineFeed = false;
	    linePosition = 0;
	    longestLine = 0;
	    indent = state.indent * level;
	    max = 80;
	    if (indent < 40) {
	        max -= indent;
	    }
	    else {
	        max = 40;
	    }
	    for (position = 0; position < object.length; position++) {
	        character = object.charCodeAt(position);
	        if (simple) {
	            // Characters that can never appear in the simple scalar
	            if (!simpleChar(character)) {
	                simple = false;
	            }
	            else {
	                continue;
	            }
	        }
	        if (single && character === CHAR_SINGLE_QUOTE) {
	            single = false;
	        }
	        escapeSeq = ESCAPE_SEQUENCES[character];
	        hexEsc = needsHexEscape(character);
	        if (!escapeSeq && !hexEsc) {
	            continue;
	        }
	        if (character !== CHAR_LINE_FEED && character !== CHAR_DOUBLE_QUOTE && character !== CHAR_SINGLE_QUOTE) {
	            folded = false;
	            literal = false;
	        }
	        else if (character === CHAR_LINE_FEED) {
	            sawLineFeed = true;
	            single = false;
	            if (position > 0) {
	                previous = object.charCodeAt(position - 1);
	                if (previous === CHAR_SPACE) {
	                    literal = false;
	                    folded = false;
	                }
	            }
	            if (folded) {
	                lineLength = position - linePosition;
	                linePosition = position;
	                if (lineLength > longestLine) {
	                    longestLine = lineLength;
	                }
	            }
	        }
	        if (character !== CHAR_DOUBLE_QUOTE) {
	            single = false;
	        }
	        double.takeUpTo(position);
	        double.escapeChar();
	    }
	    if (simple && testImplicitResolving(state, object)) {
	        simple = false;
	    }
	    modifier = '';
	    if (folded || literal) {
	        trailingLineBreaks = 0;
	        if (object.charCodeAt(object.length - 1) === CHAR_LINE_FEED) {
	            trailingLineBreaks += 1;
	            if (object.charCodeAt(object.length - 2) === CHAR_LINE_FEED) {
	                trailingLineBreaks += 1;
	            }
	        }
	        if (trailingLineBreaks === 0) {
	            modifier = '-';
	        }
	        else if (trailingLineBreaks === 2) {
	            modifier = '+';
	        }
	    }
	    if (literal && longestLine < max) {
	        folded = false;
	    }
	    // If it's literally one line, then don't bother with the literal.
	    // We may still want to do a fold, though, if it's a super long line.
	    if (!sawLineFeed) {
	        literal = false;
	    }
	    if (simple) {
	        state.dump = object;
	    }
	    else if (single) {
	        state.dump = '\'' + object + '\'';
	    }
	    else if (folded) {
	        result = fold(object, max);
	        state.dump = '>' + modifier + '\n' + indentString(result, indent);
	    }
	    else if (literal) {
	        if (!modifier) {
	            object = object.replace(/\n$/, '');
	        }
	        state.dump = '|' + modifier + '\n' + indentString(object, indent);
	    }
	    else if (double) {
	        double.finish();
	        state.dump = '"' + double.result + '"';
	    }
	    else {
	        throw new Error('Failed to dump scalar value');
	    }
	    return;
	}
	// The `trailing` var is a regexp match of any trailing `\n` characters.
	//
	// There are three cases we care about:
	//
	// 1. One trailing `\n` on the string.  Just use `|` or `>`.
	//    This is the assumed default. (trailing = null)
	// 2. No trailing `\n` on the string.  Use `|-` or `>-` to "chomp" the end.
	// 3. More than one trailing `\n` on the string.  Use `|+` or `>+`.
	//
	// In the case of `>+`, these line breaks are *not* doubled (like the line
	// breaks within the string), so it's important to only end with the exact
	// same number as we started.
	function fold(object, max) {
	    var result = '', position = 0, length = object.length, trailing = /\n+$/.exec(object), newLine;
	    if (trailing) {
	        length = trailing.index + 1;
	    }
	    while (position < length) {
	        newLine = object.indexOf('\n', position);
	        if (newLine > length || newLine === -1) {
	            if (result) {
	                result += '\n\n';
	            }
	            result += foldLine(object.slice(position, length), max);
	            position = length;
	        }
	        else {
	            if (result) {
	                result += '\n\n';
	            }
	            result += foldLine(object.slice(position, newLine), max);
	            position = newLine + 1;
	        }
	    }
	    if (trailing && trailing[0] !== '\n') {
	        result += trailing[0];
	    }
	    return result;
	}
	function foldLine(line, max) {
	    if (line === '') {
	        return line;
	    }
	    var foldRe = /[^\s] [^\s]/g, result = '', prevMatch = 0, foldStart = 0, match = foldRe.exec(line), index, foldEnd, folded;
	    while (match) {
	        index = match.index;
	        // when we cross the max len, if the previous match would've
	        // been ok, use that one, and carry on.  If there was no previous
	        // match on this fold section, then just have a long line.
	        if (index - foldStart > max) {
	            if (prevMatch !== foldStart) {
	                foldEnd = prevMatch;
	            }
	            else {
	                foldEnd = index;
	            }
	            if (result) {
	                result += '\n';
	            }
	            folded = line.slice(foldStart, foldEnd);
	            result += folded;
	            foldStart = foldEnd + 1;
	        }
	        prevMatch = index + 1;
	        match = foldRe.exec(line);
	    }
	    if (result) {
	        result += '\n';
	    }
	    // if we end up with one last word at the end, then the last bit might
	    // be slightly bigger than we wanted, because we exited out of the loop.
	    if (foldStart !== prevMatch && line.length - foldStart > max) {
	        result += line.slice(foldStart, prevMatch) + '\n' + line.slice(prevMatch + 1);
	    }
	    else {
	        result += line.slice(foldStart);
	    }
	    return result;
	}
	// Returns true if character can be found in a simple scalar
	function simpleChar(character) {
	    return CHAR_TAB !== character && CHAR_LINE_FEED !== character && CHAR_CARRIAGE_RETURN !== character && CHAR_COMMA !== character && CHAR_LEFT_SQUARE_BRACKET !== character && CHAR_RIGHT_SQUARE_BRACKET !== character && CHAR_LEFT_CURLY_BRACKET !== character && CHAR_RIGHT_CURLY_BRACKET !== character && CHAR_SHARP !== character && CHAR_AMPERSAND !== character && CHAR_ASTERISK !== character && CHAR_EXCLAMATION !== character && CHAR_VERTICAL_LINE !== character && CHAR_GREATER_THAN !== character && CHAR_SINGLE_QUOTE !== character && CHAR_DOUBLE_QUOTE !== character && CHAR_PERCENT !== character && CHAR_COLON !== character && !ESCAPE_SEQUENCES[character] && !needsHexEscape(character);
	}
	// Returns true if the character code needs to be escaped.
	function needsHexEscape(character) {
	    return !((0x00020 <= character && character <= 0x00007E) || (0x00085 === character) || (0x000A0 <= character && character <= 0x00D7FF) || (0x0E000 <= character && character <= 0x00FFFD) || (0x10000 <= character && character <= 0x10FFFF));
	}
	function writeFlowSequence(state, level, object) {
	    var _result = '', _tag = state.tag, index, length;
	    for (index = 0, length = object.length; index < length; index += 1) {
	        // Write only valid elements.
	        if (writeNode(state, level, object[index], false, false)) {
	            if (0 !== index) {
	                _result += ', ';
	            }
	            _result += state.dump;
	        }
	    }
	    state.tag = _tag;
	    state.dump = '[' + _result + ']';
	}
	function writeBlockSequence(state, level, object, compact) {
	    var _result = '', _tag = state.tag, index, length;
	    for (index = 0, length = object.length; index < length; index += 1) {
	        // Write only valid elements.
	        if (writeNode(state, level + 1, object[index], true, true)) {
	            if (!compact || 0 !== index) {
	                _result += generateNextLine(state, level);
	            }
	            _result += '- ' + state.dump;
	        }
	    }
	    state.tag = _tag;
	    state.dump = _result || '[]'; // Empty sequence if no valid values.
	}
	function writeFlowMapping(state, level, object) {
	    var _result = '', _tag = state.tag, objectKeyList = Object.keys(object), index, length, objectKey, objectValue, pairBuffer;
	    for (index = 0, length = objectKeyList.length; index < length; index += 1) {
	        pairBuffer = '';
	        if (0 !== index) {
	            pairBuffer += ', ';
	        }
	        objectKey = objectKeyList[index];
	        objectValue = object[objectKey];
	        if (!writeNode(state, level, objectKey, false, false)) {
	            continue;
	        }
	        if (state.dump.length > 1024) {
	            pairBuffer += '? ';
	        }
	        pairBuffer += state.dump + ': ';
	        if (!writeNode(state, level, objectValue, false, false)) {
	            continue;
	        }
	        pairBuffer += state.dump;
	        // Both key and value are valid.
	        _result += pairBuffer;
	    }
	    state.tag = _tag;
	    state.dump = '{' + _result + '}';
	}
	function writeBlockMapping(state, level, object, compact) {
	    var _result = '', _tag = state.tag, objectKeyList = Object.keys(object), index, length, objectKey, objectValue, explicitPair, pairBuffer;
	    for (index = 0, length = objectKeyList.length; index < length; index += 1) {
	        pairBuffer = '';
	        if (!compact || 0 !== index) {
	            pairBuffer += generateNextLine(state, level);
	        }
	        objectKey = objectKeyList[index];
	        objectValue = object[objectKey];
	        if (!writeNode(state, level + 1, objectKey, true, true)) {
	            continue;
	        }
	        explicitPair = (null !== state.tag && '?' !== state.tag) || (state.dump && state.dump.length > 1024);
	        if (explicitPair) {
	            if (state.dump && CHAR_LINE_FEED === state.dump.charCodeAt(0)) {
	                pairBuffer += '?';
	            }
	            else {
	                pairBuffer += '? ';
	            }
	        }
	        pairBuffer += state.dump;
	        if (explicitPair) {
	            pairBuffer += generateNextLine(state, level);
	        }
	        if (!writeNode(state, level + 1, objectValue, true, explicitPair)) {
	            continue;
	        }
	        if (state.dump && CHAR_LINE_FEED === state.dump.charCodeAt(0)) {
	            pairBuffer += ':';
	        }
	        else {
	            pairBuffer += ': ';
	        }
	        pairBuffer += state.dump;
	        // Both key and value are valid.
	        _result += pairBuffer;
	    }
	    state.tag = _tag;
	    state.dump = _result || '{}'; // Empty mapping if no valid pairs.
	}
	function detectType(state, object, explicit) {
	    var _result, typeList, index, length, type, style;
	    typeList = explicit ? state.explicitTypes : state.implicitTypes;
	    for (index = 0, length = typeList.length; index < length; index += 1) {
	        type = typeList[index];
	        if ((type.instanceOf || type.predicate) && (!type.instanceOf || (('object' === typeof object) && (object instanceof type.instanceOf))) && (!type.predicate || type.predicate(object))) {
	            state.tag = explicit ? type.tag : '?';
	            if (type.represent) {
	                style = state.styleMap[type.tag] || type.defaultStyle;
	                if ('[object Function]' === _toString.call(type.represent)) {
	                    _result = type.represent(object, style);
	                }
	                else if (_hasOwnProperty.call(type.represent, style)) {
	                    _result = type.represent[style](object, style);
	                }
	                else {
	                    throw new YAMLException('!<' + type.tag + '> tag resolver accepts not "' + style + '" style');
	                }
	                state.dump = _result;
	            }
	            return true;
	        }
	    }
	    return false;
	}
	// Serializes `object` and writes it to global `result`.
	// Returns true on success, or false on invalid object.
	//
	function writeNode(state, level, object, block, compact) {
	    state.tag = null;
	    state.dump = object;
	    if (!detectType(state, object, false)) {
	        detectType(state, object, true);
	    }
	    var type = _toString.call(state.dump);
	    if (block) {
	        block = (0 > state.flowLevel || state.flowLevel > level);
	    }
	    if ((null !== state.tag && '?' !== state.tag) || (2 !== state.indent && level > 0)) {
	        compact = false;
	    }
	    var objectOrArray = '[object Object]' === type || '[object Array]' === type, duplicateIndex, duplicate;
	    if (objectOrArray) {
	        duplicateIndex = state.duplicates.indexOf(object);
	        duplicate = duplicateIndex !== -1;
	    }
	    if (duplicate && state.usedDuplicates[duplicateIndex]) {
	        state.dump = '*ref_' + duplicateIndex;
	    }
	    else {
	        if (objectOrArray && duplicate && !state.usedDuplicates[duplicateIndex]) {
	            state.usedDuplicates[duplicateIndex] = true;
	        }
	        if ('[object Object]' === type) {
	            if (block && (0 !== Object.keys(state.dump).length)) {
	                writeBlockMapping(state, level, state.dump, compact);
	                if (duplicate) {
	                    state.dump = '&ref_' + duplicateIndex + (0 === level ? '\n' : '') + state.dump;
	                }
	            }
	            else {
	                writeFlowMapping(state, level, state.dump);
	                if (duplicate) {
	                    state.dump = '&ref_' + duplicateIndex + ' ' + state.dump;
	                }
	            }
	        }
	        else if ('[object Array]' === type) {
	            if (block && (0 !== state.dump.length)) {
	                writeBlockSequence(state, level, state.dump, compact);
	                if (duplicate) {
	                    state.dump = '&ref_' + duplicateIndex + (0 === level ? '\n' : '') + state.dump;
	                }
	            }
	            else {
	                writeFlowSequence(state, level, state.dump);
	                if (duplicate) {
	                    state.dump = '&ref_' + duplicateIndex + ' ' + state.dump;
	                }
	            }
	        }
	        else if ('[object String]' === type) {
	            if ('?' !== state.tag) {
	                writeScalar(state, state.dump, level);
	            }
	        }
	        else {
	            if (state.skipInvalid) {
	                return false;
	            }
	            throw new YAMLException('unacceptable kind of an object to dump ' + type);
	        }
	        if (null !== state.tag && '?' !== state.tag) {
	            state.dump = '!<' + state.tag + '> ' + state.dump;
	        }
	    }
	    return true;
	}
	function getDuplicateReferences(object, state) {
	    var objects = [], duplicatesIndexes = [], index, length;
	    inspectNode(object, objects, duplicatesIndexes);
	    for (index = 0, length = duplicatesIndexes.length; index < length; index += 1) {
	        state.duplicates.push(objects[duplicatesIndexes[index]]);
	    }
	    state.usedDuplicates = new Array(length);
	}
	function inspectNode(object, objects, duplicatesIndexes) {
	    var type = _toString.call(object), objectKeyList, index, length;
	    if (null !== object && 'object' === typeof object) {
	        index = objects.indexOf(object);
	        if (-1 !== index) {
	            if (-1 === duplicatesIndexes.indexOf(index)) {
	                duplicatesIndexes.push(index);
	            }
	        }
	        else {
	            objects.push(object);
	            if (Array.isArray(object)) {
	                for (index = 0, length = object.length; index < length; index += 1) {
	                    inspectNode(object[index], objects, duplicatesIndexes);
	                }
	            }
	            else {
	                objectKeyList = Object.keys(object);
	                for (index = 0, length = objectKeyList.length; index < length; index += 1) {
	                    inspectNode(object[objectKeyList[index]], objects, duplicatesIndexes);
	                }
	            }
	        }
	    }
	}
	function dump(input, options) {
	    options = options || {};
	    var state = new State(options);
	    getDuplicateReferences(input, state);
	    if (writeNode(state, 0, input, true, true)) {
	        return state.dump + '\n';
	    }
	    return '';
	}
	exports.dump = dump;
	function safeDump(input, options) {
	    return dump(input, common.extend({ schema: DEFAULT_SAFE_SCHEMA }, options));
	}
	exports.safeDump = safeDump;
	//# sourceMappingURL=dumper.js.map

/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	var YAMLException = (function () {
	    function YAMLException(reason, mark) {
	        if (mark === void 0) { mark = null; }
	        this.name = 'YAMLException';
	        this.reason = reason;
	        this.mark = mark;
	        this.message = this.toString(false);
	    }
	    YAMLException.prototype.toString = function (compact) {
	        if (compact === void 0) { compact = false; }
	        var result;
	        result = 'JS-YAML: ' + (this.reason || '(unknown reason)');
	        if (!compact && this.mark) {
	            result += ' ' + this.mark.toString();
	        }
	        return result;
	    };
	    return YAMLException;
	})();
	module.exports = YAMLException;
	//# sourceMappingURL=exception.js.map

/***/ },
/* 29 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../typings/tsd.d.ts" />
	function isMultiLine(s) {
	    return s && s.indexOf('\n') >= 0;
	}
	exports.isMultiLine = isMultiLine;
	function isMultiLineValue(s) {
	    return isMultiLine(s) && s.length > 2 && s[0] == '|' && (s[1] == '\n' || s[1] == '\r' || s[2] == '\n');
	}
	exports.isMultiLineValue = isMultiLineValue;
	function makeMutiLine(s, lev) {
	    var xbuf = '';
	    if (isMultiLine(s)) {
	        xbuf += '|\n';
	        var lines = splitOnLines(s);
	        for (var i = 0; i < lines.length; i++) {
	            xbuf += indent(lev, lines[i]);
	        }
	    }
	    else {
	        xbuf += s;
	    }
	    return xbuf;
	}
	exports.makeMutiLine = makeMutiLine;
	function fromMutiLine(s) {
	    if (!isMultiLineValue(s))
	        return s;
	    var res = null;
	    var lines = splitOnLines(s);
	    for (var i = 1; i < lines.length; i++) {
	        var line = lines[i];
	        var str = line.substring(2);
	        if (!res)
	            res = str;
	        else
	            res += str;
	    }
	    return res;
	}
	exports.fromMutiLine = fromMutiLine;
	function trimStart(s) {
	    if (!s)
	        return s;
	    var pos = 0;
	    while (pos < s.length) {
	        var ch = s[pos];
	        if (ch != '\r' && ch != '\n' && ch != ' ' && ch != '\t')
	            break;
	        pos++;
	    }
	    return s.substring(pos, s.length);
	}
	exports.trimStart = trimStart;
	function indent(lev, str) {
	    if (str === void 0) { str = ''; }
	    var leading = '';
	    for (var i = 0; i < lev; i++)
	        leading += '  ';
	    return leading + str;
	}
	exports.indent = indent;
	function print(lev, str) {
	    if (str === void 0) { str = ''; }
	    console.log(indent(lev, str));
	}
	exports.print = print;
	function replaceNewlines(s, rep) {
	    if (rep === void 0) { rep = null; }
	    var res = '';
	    for (var i = 0; i < s.length; i++) {
	        var ch = s[i];
	        if (ch == '\r')
	            ch = rep == null ? '\\r' : rep;
	        if (ch == '\n')
	            ch = rep == null ? '\\n' : rep;
	        res += ch;
	    }
	    return res;
	}
	exports.replaceNewlines = replaceNewlines;
	function trimEnd(s) {
	    var pos = s.length;
	    while (pos > 0) {
	        var ch = s[pos - 1];
	        if (ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n')
	            break;
	        pos--;
	    }
	    return s.substring(0, pos);
	}
	exports.trimEnd = trimEnd;
	function splitOnLines(text) {
	    var lines = text.match(/^.*((\r\n|\n|\r)|$)/gm);
	    return lines;
	}
	exports.splitOnLines = splitOnLines;
	function startsWith(s, suffix) {
	    if (!s || !suffix || s.length < suffix.length)
	        return false;
	    for (var i = 0; i < suffix.length; i++) {
	        if (s[i] != suffix[i])
	            return false;
	    }
	    return true;
	}
	exports.startsWith = startsWith;
	function endsWith(s, suffix) {
	    if (!s || !suffix || s.length < suffix.length)
	        return false;
	    for (var i = 0; i < suffix.length; i++) {
	        if (s[s.length - 1 - i] != suffix[suffix.length - 1 - i])
	            return false;
	    }
	    return true;
	}
	exports.endsWith = endsWith;
	var TextRange = (function () {
	    function TextRange(contents, start, end) {
	        this.contents = contents;
	        this.start = start;
	        this.end = end;
	    }
	    TextRange.prototype.text = function () {
	        return this.contents.substring(this.start, this.end);
	    };
	    TextRange.prototype.startpos = function () {
	        return this.start;
	    };
	    TextRange.prototype.endpos = function () {
	        return this.end;
	    };
	    TextRange.prototype.len = function () {
	        return this.end - this.start;
	    };
	    TextRange.prototype.unitText = function () {
	        return this.contents;
	    };
	    TextRange.prototype.withStart = function (start) {
	        return new TextRange(this.contents, start, this.end);
	    };
	    TextRange.prototype.withEnd = function (end) {
	        return new TextRange(this.contents, this.start, end);
	    };
	    TextRange.prototype.sub = function (start, end) {
	        return this.contents.substring(start, end);
	    };
	    TextRange.prototype.trimStart = function () {
	        var pos = this.start;
	        while (pos < this.contents.length - 1) {
	            var ch = this.contents[pos];
	            if (ch != ' ' && ch != '\t')
	                break;
	            pos++;
	        }
	        return new TextRange(this.contents, pos, this.end);
	    };
	    TextRange.prototype.trimEnd = function () {
	        var pos = this.end;
	        while (pos > 0) {
	            var ch = this.contents[pos - 1];
	            if (ch != ' ' && ch != '\t')
	                break;
	            pos--;
	        }
	        return new TextRange(this.contents, this.start, pos);
	    };
	    TextRange.prototype.extendToStartOfLine = function () {
	        var pos = this.start;
	        while (pos > 0) {
	            var prevchar = this.contents[pos - 1];
	            if (prevchar == '\r' || prevchar == '\n')
	                break;
	            pos--;
	        }
	        return new TextRange(this.contents, pos, this.end);
	    };
	    TextRange.prototype.extendAnyUntilNewLines = function () {
	        var pos = this.end;
	        if (pos > 0) {
	            var last = this.contents[pos - 1];
	            if (last == '\n')
	                return this;
	        }
	        while (pos < this.contents.length - 1) {
	            var nextchar = this.contents[pos];
	            if (nextchar == '\r' || nextchar == '\n')
	                break;
	            pos++;
	        }
	        return new TextRange(this.contents, this.start, pos);
	    };
	    TextRange.prototype.extendSpacesUntilNewLines = function () {
	        var pos = this.end;
	        if (pos > 0) {
	            var last = this.contents[pos - 1];
	            if (last == '\n')
	                return this;
	        }
	        while (pos < this.contents.length - 1) {
	            var nextchar = this.contents[pos];
	            if (nextchar != ' ' || nextchar == '\r' || nextchar == '\n')
	                break;
	            pos++;
	        }
	        return new TextRange(this.contents, this.start, pos);
	    };
	    TextRange.prototype.extendSpaces = function () {
	        var pos = this.end;
	        while (pos < this.contents.length - 1) {
	            var nextchar = this.contents[pos];
	            if (nextchar != ' ')
	                break;
	            pos++;
	        }
	        return new TextRange(this.contents, this.start, pos);
	    };
	    TextRange.prototype.extendSpacesBack = function () {
	        var pos = this.start;
	        while (pos > 0) {
	            var nextchar = this.contents[pos - 1];
	            if (nextchar != ' ')
	                break;
	            pos--;
	        }
	        return new TextRange(this.contents, pos, this.end);
	    };
	    TextRange.prototype.extendCharIfAny = function (ch) {
	        var pos = this.end;
	        if (pos < this.contents.length - 1 && this.contents[pos] == ch) {
	            pos++;
	        }
	        return new TextRange(this.contents, this.start, pos);
	    };
	    TextRange.prototype.extendCharIfAnyBack = function (ch) {
	        var pos = this.start;
	        if (pos > 0 && this.contents[pos - 1] == ch) {
	            pos--;
	        }
	        return new TextRange(this.contents, pos, this.end);
	    };
	    TextRange.prototype.extendToNewlines = function () {
	        var pos = this.end;
	        if (pos > 0) {
	            var last = this.contents[pos - 1];
	            if (last == '\n')
	                return this;
	        }
	        while (pos < this.contents.length - 1) {
	            var nextchar = this.contents[pos];
	            if (nextchar != '\r' && nextchar != '\n')
	                break;
	            pos++;
	        }
	        return new TextRange(this.contents, this.start, pos);
	    };
	    TextRange.prototype.extendUntilNewlinesBack = function () {
	        var pos = this.start;
	        while (pos > 0) {
	            var nextchar = this.contents[pos - 1];
	            if (nextchar == '\r' || nextchar == '\n')
	                break;
	            pos--;
	        }
	        return new TextRange(this.contents, pos, this.end);
	    };
	    TextRange.prototype.reduceNewlinesEnd = function () {
	        var pos = this.end;
	        while (pos > this.start) {
	            var last = this.contents[pos - 1];
	            if (last != '\r' && last != '\n')
	                break;
	            pos--;
	        }
	        return new TextRange(this.contents, this.start, pos);
	    };
	    TextRange.prototype.reduceSpaces = function () {
	        var pos = this.end;
	        while (pos > this.start) {
	            var last = this.contents[pos - 1];
	            if (last != ' ')
	                break;
	            pos--;
	        }
	        return new TextRange(this.contents, this.start, pos);
	    };
	    TextRange.prototype.replace = function (text) {
	        return this.sub(0, this.start) + text + this.sub(this.end, this.unitText().length);
	    };
	    TextRange.prototype.remove = function () {
	        return this.sub(0, this.start) + this.sub(this.end, this.unitText().length);
	    };
	    return TextRange;
	})();
	exports.TextRange = TextRange;
	//# sourceMappingURL=textutil.js.map

/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer) {/// <reference path="../../../typings/tsd.d.ts" />
	var spawnSync = __webpack_require__(43).spawnSync || __webpack_require__(44);
	var HttpResponse = __webpack_require__(75);
	__webpack_require__(76);
	__webpack_require__(80);
	var lru = __webpack_require__(79);
	var globalCache = lru(50);
	//Function('', fs.readFileSync(require.resolve('./lib/worker.js'), 'utf8'));
	function doRequest(method, url, options) {
	    var req = JSON.stringify({
	        method: method,
	        url: url,
	        options: options
	    });
	    var res = spawnSync('/usr/local/bin/node', [/*require.resolve*/(66)], { input: req });
	    if (!res) {
	        return null;
	    }
	    if (res.status !== 0) {
	        throw new Error(res.stderr.toString());
	    }
	    if (res.error) {
	        if (typeof res.error === 'string')
	            res.error = new Error(res.error);
	        throw res.error;
	    }
	    var response = JSON.parse(res.stdout);
	    if (response.success) {
	        return new HttpResponse(response.response.statusCode, response.response.headers, response.response.body);
	    }
	    else {
	        throw new Error(response.error.message || response.error || response);
	    }
	}
	function readFromCacheOrGet(url) {
	    var res = globalCache.get(url);
	    if (res) {
	        if (res == readFromCacheOrGet) {
	            return null;
	        }
	        return res;
	    }
	    try {
	        var res = doRequest("GET", url, { timeout: 3000, socketTimeout: 5000, retry: true });
	        res = new Buffer(res.body.data).toString();
	        globalCache.set(url, res);
	        return res;
	    }
	    catch (e) {
	        globalCache.set(url, readFromCacheOrGet);
	        return null;
	    }
	}
	exports.readFromCacheOrGet = readFromCacheOrGet;
	//# sourceMappingURL=resourceRegistry.js.map
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(77).Buffer))

/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../typings/tsd.d.ts" />
	var defs = __webpack_require__(21);
	var hl = __webpack_require__(17);
	var _ = __webpack_require__(47);
	var typeExpression = __webpack_require__(67);
	var search = __webpack_require__(35);
	var linter = __webpack_require__(33);
	var schema = __webpack_require__(54);
	function validate(str, node, cb) {
	    var x = str.trim();
	    if (x.length > 0) {
	        try {
	            if (x.charAt(0) == "{") {
	                schema.getJSONSchema(str);
	                //this is json schema
	                return;
	            }
	            if (x.charAt(0) == "<") {
	                schema.getXMLSchema(str);
	                //this is xsd schema
	                return;
	            }
	        }
	        catch (e) {
	            cb.accept(linter.createIssue(7 /* INVALID_VALUE_SCHEMA */, e.message, node));
	        }
	    }
	    var result = typeExpression.parse(str);
	    validateNode(result, node, cb);
	}
	exports.validate = validate;
	function getType(node, expression, defined, toRuntime) {
	    if (toRuntime === void 0) { toRuntime = false; }
	    if (!expression) {
	        return node.definition().universe().getType("StrElement");
	    }
	    if (toRuntime) {
	        if (buildInsRuntime[expression]) {
	            var sm = node.definition().universe().getType(buildInsRuntime[expression]);
	            return sm;
	        }
	    }
	    if (buildIns[expression]) {
	        var qm = node.definition().universe().getType(buildIns[expression]);
	        return qm;
	    }
	    try {
	        var vl = expression;
	        vl = vl.trim();
	        if (vl.charAt(0) == '{') {
	            return null;
	        }
	        if (vl.charAt(0) == '<') {
	            return null;
	        }
	        var result = typeExpression.parse(expression);
	    }
	    catch (e) {
	        return null;
	    }
	    return deriveType(node, result, toRuntime, defined);
	}
	exports.getType = getType;
	/**
	 * Only use it for example validaation at this point, lets think about it after release.
	 * @param node
	 * @param expression
	 * @param defined
	 * @param toRuntime
	 * @returns {any}
	 */
	function getType2(node, expression, defined, toRuntime) {
	    if (toRuntime === void 0) { toRuntime = false; }
	    if (!expression) {
	        return node.definition().universe().getType("StrElement");
	    }
	    if (toRuntime) {
	        if (buildInsRuntime[expression]) {
	            var sm = node.definition().universe().getType(buildInsRuntime[expression]);
	            if (sm) {
	                var ret = new defs.UserDefinedClass(node.name(), node.definition().universe(), node, "", "");
	                ret._superTypes.push(sm);
	                return ret;
	            }
	        }
	    }
	    if (buildIns[expression]) {
	        var qm = node.definition().universe().getType(buildIns[expression]);
	        if (qm) {
	            var ret = new defs.UserDefinedClass(node.name(), node.definition().universe(), node, "", "");
	            ret._superTypes.push(qm);
	            return ret;
	        }
	    }
	    try {
	        var vl = expression;
	        vl = vl.trim();
	        if (vl.charAt(0) == '{') {
	            return null;
	        }
	        if (vl.charAt(0) == '<') {
	            return null;
	        }
	        var result = typeExpression.parse(expression);
	    }
	    catch (e) {
	        return null;
	    }
	    return deriveType(node, result, toRuntime, defined);
	}
	exports.getType2 = getType2;
	var buildIns = {
	    string: "StrElement",
	    number: "NumberElement",
	    integer: "IntegerElement",
	    date: "DateElement",
	    object: "ObjectField",
	    boolean: "BooleanElement",
	    value: "ValueElement",
	    file: "FileParameter"
	};
	var buildInsRuntime = {
	    string: "string",
	    number: "number",
	    integer: "integer",
	    date: "date",
	    object: "ObjectField",
	    boolean: "boolean",
	    value: "string",
	    file: "file"
	};
	var counter = 0;
	function deriveType(node, r, toRuntime, defining) {
	    if (toRuntime === void 0) { toRuntime = false; }
	    if (defining === void 0) { defining = {}; }
	    if (r.type == "union") {
	        var u = r;
	        var left = deriveType(node, u.first, toRuntime, defining);
	        var right = deriveType(node, u.rest, toRuntime, defining);
	        var ut = node.definition().universe().getType("UnionField");
	        var union = new defs.Union("Union" + (counter++), node.definition().universe(), "");
	        union._superTypes.push(ut);
	        union.left = left;
	        union.right = right;
	        return union;
	    }
	    if (r.type == 'responses') {
	        var res = r;
	        var result = null;
	        res.codes.forEach(function (t) {
	            var tp = deriveType(node, t.expr, toRuntime, defining);
	            if (tp) {
	                if (!result) {
	                    result = tp;
	                }
	                else {
	                    var union = new defs.Union("Union" + (counter++), node.definition().universe(), "");
	                    union.left = result;
	                    union.right = tp;
	                    result = tp;
	                }
	            }
	        });
	        return result;
	    }
	    if (r.type == 'parens') {
	        var ex = r;
	        return deriveType(node, ex.expr, toRuntime, defining);
	    }
	    if (r.type == 'name') {
	        var l = r;
	        var val = l.value;
	        var ind = val.lastIndexOf("[]");
	        if (ind != -1 && ind == val.length - 2) {
	            val = val.substr(0, val.length - 2); //FIXME Should be in PEG
	        }
	        if (l.arr > 0) {
	            var types = search.subTypesWithLocals(node.definition().universe().getType("DataElement"), node);
	            var tp = _.find(types, function (x) {
	                var c = x.name() == val;
	                if (!c) {
	                    if (x instanceof defs.AbstractType) {
	                        var at = x;
	                        at.getAliases().forEach(function (y) {
	                            if (y == val) {
	                                c = true;
	                            }
	                        });
	                    }
	                }
	                return c;
	            });
	            if (!tp) {
	                //TOD make it simpler
	                if (toRuntime || true) {
	                    //it is always runtime model when we are here
	                    if (buildInsRuntime[val]) {
	                        tp = node.definition().universe().getType(buildInsRuntime[val]);
	                    }
	                }
	                else if (buildIns[val]) {
	                    tp = node.definition().universe().getType(buildIns[val]);
	                }
	            }
	            if (!tp) {
	                tp = new defs.ValueType("String", node.definition().universe(), "");
	            }
	            var at = node.definition().universe().getType("ArrayField");
	            var arr = new defs.Array(tp.name() + "[]", node.definition().universe(), "");
	            arr._superTypes.push(at);
	            arr.component = tp;
	            arr.dimensions = l.arr;
	            return arr;
	        }
	        if (toRuntime) {
	            if (buildInsRuntime[val]) {
	                return node.definition().universe().getType(buildInsRuntime[val]);
	            }
	        }
	        if (buildIns[val]) {
	            return node.definition().universe().getType(buildIns[val]);
	        }
	        var de = node.definition().universe().getType("DataElement");
	        if (!de) {
	            de = node.definition().universe().getType("GlobalSchema");
	        }
	        //if (defining[val]){
	        //    return defining[val];
	        //}
	        var qm = search.subTypesWithName(val, node, defining);
	        if (qm) {
	            return qm;
	        }
	        //return null;
	        de = node.definition().universe().getType("GlobalSchema");
	        return search.schemasWithName(val, node, defining);
	    }
	    return null;
	}
	exports.deriveType = deriveType;
	function nodeToString(r) {
	    if (r.type == "union") {
	        var u = r;
	        return nodeToString(u.first) + "|" + nodeToString(u.rest);
	    }
	    if (r.type == "responses") {
	        var res = r;
	        var rs = "{";
	        for (var i = 0; i < res.codes.length; i++) {
	            rs += res.codes[i].code;
	            rs += ":";
	            rs += nodeToString(res.codes[i].expr);
	            if (i != res.codes.length - 1) {
	                rs += ",";
	            }
	        }
	        rs += '}';
	        return rs;
	    }
	    if (r.type == 'parens') {
	        var ex = r;
	        var pr = "(" + nodeToString(ex.expr) + ")";
	        if (ex.arr) {
	            pr += "[]";
	        }
	        return pr;
	    }
	    if (r.type == 'name') {
	        var l = r;
	        var val = l.value;
	        var pr = val;
	        if (l.arr) {
	            pr += "[]";
	        }
	        return pr;
	    }
	}
	exports.nodeToString = nodeToString;
	function validateNode(r, node, cb) {
	    if (r.type == "union") {
	        var u = r;
	        validateNode(u.first, node, cb);
	        validateNode(u.rest, node, cb);
	    }
	    if (r.type == "responses") {
	        var res = r;
	        res.codes.forEach(function (x) {
	            var v = x.code;
	            for (var i = 0; i < v.length; i++) {
	                var c = v[i];
	                if (!_.find(['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'x', 'X'], function (x) { return x == c; })) {
	                    cb.accept(linter.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Status code should be 3 digits number with optional 'x' as wildcards", node));
	                    return;
	                }
	            }
	            validateNode(x.expr, node, cb);
	        });
	    }
	    if (r.type == 'parens') {
	        var ex = r;
	        validateNode(ex.expr, node, cb);
	    }
	    if (r.type == 'name') {
	        var l = r;
	        var val = l.value;
	        if (val.lastIndexOf("[]") != -1) {
	            val = val.substr(0, val.length - 2); //FIXME Should be in PEG
	        }
	        var pr = node.property();
	        if (pr.isValidValue(val, node.parent())) {
	            return;
	        }
	        var values = pr.enumValues(node.parent());
	        values = values.map(function (x) {
	            var tp = x.indexOf("<");
	            if (tp != -1) {
	                return x.substring(0, tp);
	            }
	            return x;
	        });
	        if (l.params) {
	            l.params.forEach(function (x) {
	                validateNode(x, node, cb);
	            });
	        }
	        values.push("number");
	        values.push("integer");
	        values.push("file");
	        values.push("boolean");
	        values.push("any");
	        values.push("date");
	        values.push("void");
	        values.push("string");
	        values.push("value");
	        if (!_.find(values, function (x) { return x == val; })) {
	            cb.accept(linter.createIssue(0 /* UNRESOLVED_REFERENCE */, "Unresolved reference:" + val, node));
	            return true;
	        }
	    }
	}
	exports.validateNode = validateNode;
	//# sourceMappingURL=typeExpressions.js.map

/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../../typings/tsd.d.ts" />
	var defs = __webpack_require__(21);
	var _ = __webpack_require__(47);
	var yaml = __webpack_require__(19);
	var typeExpression = __webpack_require__(31);
	var def = __webpack_require__(21);
	var hlimpl = __webpack_require__(7);
	var search = __webpack_require__(35);
	var KeyMatcher = (function () {
	    function KeyMatcher(_props) {
	        this._props = _props;
	        this.parentValue = _.find(_props, function (x) { return x.isFromParentValue(); });
	        this.parentKey = _.find(_props, function (x) { return x.isFromParentKey(); });
	        this.canBeValue = _.find(_props, function (x) { return x.canBeValue(); });
	    }
	    KeyMatcher.prototype.match = function (key) {
	        var _this = this;
	        var _res = null;
	        var lastPref = "";
	        this._props.forEach(function (p) {
	            if (p.isSystem()) {
	                return;
	            }
	            if (p != _this.parentValue && p != _this.parentKey && p.matchKey(key)) {
	                if (p.keyPrefix() != null) {
	                    if (p.keyPrefix().length >= lastPref.length) {
	                        lastPref = p.keyPrefix();
	                        _res = p;
	                    }
	                }
	                else {
	                    _res = p;
	                    lastPref = p.name();
	                }
	            }
	        });
	        return _res;
	    };
	    return KeyMatcher;
	})();
	var deep = 0;
	function getAllOptions(c) {
	    if (deep > 20) {
	        return [];
	    }
	    deep++;
	    try {
	        var result = [];
	        var tp = c.leftType();
	        if (tp) {
	            result.push(tp);
	        }
	        var r = c.rightType();
	        if (r) {
	            if (r.isUnion()) {
	                var options = getAllOptions(r.union());
	                result = result.concat(options);
	            }
	            else {
	                result.push(r);
	            }
	        }
	        return result;
	    }
	    finally {
	        deep--;
	    }
	}
	var ad = 0;
	var BasicNodeBuilder = (function () {
	    function BasicNodeBuilder() {
	    }
	    BasicNodeBuilder.prototype.process = function (node, childrenToAdopt) {
	        var _this = this;
	        var nn = node.lowLevel();
	        var cha = nn._node ? nn._node : nn;
	        try {
	            if (cha['currentChildren']) {
	                return cha['currentChildren'];
	            }
	            if (!node.definition()) {
	                return;
	            }
	            if (node.definition().isUnion()) {
	                if (node.definition().isRuntime()) {
	                    var optins = getAllOptions(node.definition().union());
	                    var actualResult = null;
	                    var bestResult = null;
	                    var bestType = null;
	                    var bestCount = 1000;
	                    var llnode = node;
	                    optins.forEach(function (x) {
	                        if (!actualResult) {
	                            //TODO ADD UNION + Descriminator
	                            if (x instanceof def.NodeClass && !x.isUnionType()) {
	                                var tp = llnode.patchType(x);
	                                if (ad == 0) {
	                                    ad++;
	                                    try {
	                                        var result = _this.process(node, childrenToAdopt);
	                                        var uc = 0;
	                                        for (var i = 0; i < result.length; i++) {
	                                            if (result[i].isUnknown()) {
	                                                uc++;
	                                            }
	                                        }
	                                        if (uc == 0) {
	                                            actualResult = result;
	                                        }
	                                        if (bestCount > uc) {
	                                            bestCount = uc;
	                                            bestResult = result;
	                                            bestType = x;
	                                        }
	                                    }
	                                    finally {
	                                        ad--;
	                                    }
	                                }
	                            }
	                        }
	                    });
	                    if (actualResult) {
	                        return actualResult;
	                    }
	                    if (bestResult) {
	                        llnode.patchType(bestType);
	                    }
	                }
	            }
	            var km = new KeyMatcher(node.definition().allProperties());
	            var aNode = node;
	            var allowsQuestion = aNode._allowQuestion || node.definition().getAllowQuestion();
	            var res = [];
	            //cha['currentChildren']=res;
	            if (km.parentKey) {
	                if (node.lowLevel().key()) {
	                    res.push(new hlimpl.ASTPropImpl(node.lowLevel(), node, km.parentKey.range(), km.parentKey, true));
	                }
	            }
	            if (node.lowLevel().value()) {
	                if (km.parentValue) {
	                    res.push(new hlimpl.ASTPropImpl(node.lowLevel(), node, km.parentValue.range(), km.parentValue));
	                }
	                else if (km.canBeValue) {
	                    var s = node.lowLevel().value();
	                    if (typeof s == 'string' && s.trim().length > 0) {
	                        if (km.canBeValue.name() == "signature") {
	                            if (s.trim().charAt(0) == '(') {
	                                //TODO BETTER DECITION current one prevents completion from working correctly
	                                //in few other cases
	                                res.push(new hlimpl.ASTPropImpl(node.lowLevel(), node, km.canBeValue.range(), km.canBeValue));
	                            }
	                        }
	                        else {
	                            res.push(new hlimpl.ASTPropImpl(node.lowLevel(), node, km.canBeValue.range(), km.canBeValue));
	                        }
	                    }
	                }
	            }
	            else {
	                if (km.canBeValue && km.canBeValue.range() instanceof def.NodeClass) {
	                    var ch = new hlimpl.ASTNodeImpl(node.lowLevel(), aNode, km.canBeValue.range(), km.canBeValue);
	                    return [ch];
	                }
	            }
	            aNode._children = res;
	            if (!aNode.definition().isUserDefined()) {
	                if (aNode.definition().name() == "Api" || aNode.definition().name() == "uses") {
	                    var uses = childrenToAdopt.filter(function (x) { return x.key() == "uses"; });
	                    res = this.processChildren(uses, aNode, res, allowsQuestion, km);
	                    var types = childrenToAdopt.filter(function (x) { return x.key() == "types"; });
	                    res = this.processChildren(types, aNode, res, allowsQuestion, km);
	                    var other = childrenToAdopt.filter(function (x) { return (x.key() != "types" && x.key() != "uses"); });
	                    res = this.processChildren(other, aNode, res, allowsQuestion, km);
	                }
	                else {
	                    res = this.processChildren(childrenToAdopt, aNode, res, allowsQuestion, km);
	                }
	            }
	            else {
	                res = this.processChildren(childrenToAdopt, aNode, res, allowsQuestion, km);
	            }
	            aNode._children = res;
	            return res;
	        }
	        finally {
	            if (ch) {
	                delete cha['currentChildren'];
	            }
	        }
	    };
	    BasicNodeBuilder.prototype.processChildren = function (childrenToAdopt, aNode, res, allowsQuestion, km) {
	        var _this = this;
	        childrenToAdopt.forEach(function (x) {
	            var key = x.key();
	            if (key == '$ref' && aNode.universe().version() == "Swagger") {
	                var resolved = search.resolveReference(x, x.value());
	                if (!resolved) {
	                    var bnode = new hlimpl.BasicASTNode(x, aNode);
	                    bnode.unresolvedRef = "ref";
	                    res.push(bnode);
	                }
	                else {
	                    var mm = _this.process(aNode, resolved.children());
	                    mm.forEach(function (x) {
	                        if (x.property() && x.property().isKey()) {
	                            return;
	                        }
	                        res.push(x);
	                    });
	                }
	            }
	            if (allowsQuestion) {
	                if (key != null && key.charAt(key.length - 1) == '?') {
	                    key = key.substr(0, key.length - 1);
	                }
	            }
	            var p = km.match(key);
	            if (p != null) {
	                var range = p.range();
	                if (p.isAnnotation() && key != "annotations") {
	                    var pi = new hlimpl.ASTPropImpl(x, aNode, range, p);
	                    res.push(pi);
	                    return;
	                }
	                var um = false;
	                var multyValue = p.isMultiValue();
	                if (range instanceof def.Array) {
	                    var at = range;
	                    multyValue = true;
	                    range = at.component;
	                    um = true;
	                }
	                else if (range.isArray()) {
	                    multyValue = true;
	                    um = true;
	                }
	                //TODO DESCRIMINATORS
	                if (range.isValueType()) {
	                    var ch = x.children();
	                    var seq = (x.valueKind() == 3 /* SEQ */);
	                    if ((seq && ch.length > 0 || ch.length > 1) && multyValue) {
	                        ch.forEach(function (y) {
	                            var pi = new hlimpl.ASTPropImpl(y, aNode, range, p);
	                            res.push(pi);
	                        });
	                    }
	                    else {
	                        if (p.isInherited()) {
	                            aNode.setComputed(p.name(), x.value());
	                        }
	                        res.push(new hlimpl.ASTPropImpl(x, aNode, range, p));
	                    }
	                    //}
	                    return;
	                }
	                else {
	                    var rs = [];
	                    //now we need determine actual type
	                    aNode._children = res;
	                    if (!p.isMerged()) {
	                        if (multyValue) {
	                            if (p.isEmbedMap()) {
	                                var chld = x.children();
	                                if (chld.length == 0) {
	                                    if (x.value()) {
	                                        var bnode = new hlimpl.BasicASTNode(x, aNode);
	                                        bnode.knownProperty = p;
	                                        res.push(bnode);
	                                    }
	                                }
	                                chld.forEach(function (y) {
	                                    //TODO TRACK GROUP KEY
	                                    var cld = y.children();
	                                    if (!y.key() && cld.length == 1) {
	                                        var node = new hlimpl.ASTNodeImpl(cld[0], aNode, range, p);
	                                        node._allowQuestion = allowsQuestion;
	                                        rs.push(node);
	                                    }
	                                    else {
	                                        if (aNode.universe().version() == "RAML10") {
	                                            var node = new hlimpl.ASTNodeImpl(y, aNode, range, p);
	                                            node._allowQuestion = allowsQuestion;
	                                            rs.push(node);
	                                        }
	                                        else {
	                                            var bnode = new hlimpl.BasicASTNode(y, aNode);
	                                            res.push(bnode);
	                                            if (y.key()) {
	                                                bnode.needSequence = true;
	                                            }
	                                        }
	                                    }
	                                });
	                            }
	                            else {
	                                var filter = {};
	                                var inherited = [];
	                                if (range instanceof defs.NodeClass) {
	                                    var nc = range;
	                                    if (nc.getCanInherit().length > 0) {
	                                        nc.getCanInherit().forEach(function (v) {
	                                            var vl = aNode.computedValue(v);
	                                            if (vl && p.name() == "body") {
	                                                if (!_.find(x.children(), function (x) { return x.key() == vl; })) {
	                                                    //we can create inherited node;
	                                                    var node = new hlimpl.ASTNodeImpl(x, aNode, range, p);
	                                                    if (aNode.parent().definition().name() == "MethodBase") {
	                                                        node.setComputed("form", "true"); //FIXME
	                                                    }
	                                                    var t = descriminate(p, aNode, node);
	                                                    if (t) {
	                                                        node.patchType(t);
	                                                    }
	                                                    var ch = node.children();
	                                                    //this are false unknowns actual unknowns will be reported by parent node
	                                                    node._children = ch.filter(function (x) { return !x.isUnknown(); });
	                                                    node._allowQuestion = allowsQuestion;
	                                                    inherited.push(node);
	                                                    node.children().forEach(function (x) {
	                                                        if (x.property().isKey()) {
	                                                            var atr = x;
	                                                            atr._computed = true;
	                                                            return;
	                                                        }
	                                                        if (x.isElement()) {
	                                                            if (!x.property().isMerged()) {
	                                                                filter[x.property().name()] = true;
	                                                            }
	                                                        }
	                                                        if (x.property().isAnnotation()) {
	                                                            var atr = x;
	                                                            var vl = atr.value();
	                                                            var strVal = "";
	                                                            if (vl instanceof hlimpl.StructuredValue) {
	                                                                strVal = vl.valueName();
	                                                            }
	                                                            else {
	                                                                strVal = "" + vl;
	                                                            }
	                                                            filter["(" + strVal + ")"] = true;
	                                                        }
	                                                        else {
	                                                            filter[x.name()] = true;
	                                                        }
	                                                    });
	                                                    node._computed = true;
	                                                }
	                                            }
	                                        });
	                                    }
	                                }
	                                var parsed = [];
	                                x.children().forEach(function (y) {
	                                    if (filter[y.key()]) {
	                                        return;
	                                    }
	                                    var node = new hlimpl.ASTNodeImpl(y, aNode, range, p);
	                                    if (p.name() == "body" && p.domain().name() == "MethodBase") {
	                                        node.setComputed("form", "true"); //FIXME
	                                    }
	                                    node._allowQuestion = allowsQuestion;
	                                    parsed.push(node);
	                                });
	                                if (parsed.length > 0) {
	                                    parsed.forEach(function (x) { return rs.push(x); });
	                                }
	                                else {
	                                    inherited.forEach(function (x) { return rs.push(x); });
	                                }
	                            }
	                        }
	                        else {
	                            //var y=x.children()[0];
	                            rs.push(new hlimpl.ASTNodeImpl(x, aNode, range, p));
	                        }
	                    }
	                    else {
	                        var node = new hlimpl.ASTNodeImpl(x, aNode, range, p);
	                        node._allowQuestion = allowsQuestion;
	                        rs.push(node);
	                    }
	                    aNode._children = aNode._children.concat(rs);
	                    res = res.concat(rs);
	                    rs.forEach(function (x) {
	                        var rt = descriminate(p, aNode, x);
	                        if (rt && rt != x.definition()) {
	                            x.patchType(rt);
	                        }
	                        x._associatedDef = null;
	                        p.childRestrictions().forEach(function (y) {
	                            x.setComputed(y.name, y.value);
	                        });
	                        var def = x.definition();
	                    });
	                }
	            }
	            else {
	                res.push(new hlimpl.BasicASTNode(x, aNode));
	            }
	        });
	        return res;
	    };
	    return BasicNodeBuilder;
	})();
	exports.BasicNodeBuilder = BasicNodeBuilder;
	function desc1(p, parent, x) {
	    var tp = x.attr("type");
	    var value = "";
	    if (tp) {
	        var mn = {};
	        var c = new def.NodeClass(x.name(), parent.definition().universe(), "");
	        c.setDeclaringNode(x);
	        c._superTypes.push(parent.definition().universe().getType("DataElement"));
	        mn[tp.value()] = c;
	        var newType = typeExpression.getType(parent, tp.value(), mn);
	        if (newType instanceof def.Array) {
	            newType.setDeclaringNode(x);
	        }
	        return newType;
	    }
	    else {
	        if (p.name() == "body" || _.find(x.lowLevel().children(), function (x) { return x.key() == "properties"; })) {
	            return parent.definition().universe().getType("ObjectField");
	        }
	        return parent.definition().universe().getType("StrElement");
	    }
	    return null;
	}
	function doDescrimination(node) {
	    return descriminate(node.property(), node.parent(), node);
	}
	exports.doDescrimination = doDescrimination;
	function descriminate(p, parent, x) {
	    var n = x.lowLevel();
	    if (!p) {
	        return null;
	    }
	    if (p.name() == "uses" && p.range().name() == "Library") {
	    }
	    if (n._node && n._node['descriminate']) {
	        return null;
	    }
	    if (n._node) {
	        n._node['descriminate'] = 1;
	    }
	    try {
	        if (p.range().name() == "DataElement") {
	            var res = desc1(p, parent, x);
	            //FIXME (think about it later)
	            if (res != null && ((p.name() == "body" || p.name() == "headers") || p.name() == "queryParameters")) {
	                var ares = new defs.UserDefinedClass(x.lowLevel().key(), res.universe(), x, x.lowLevel().unit() ? x.lowLevel().unit().path() : "", "");
	                ares._superTypes.push(res);
	                return ares;
	            }
	            if (res) {
	                return res;
	            }
	        }
	        //generic case;
	        var rt = null;
	        var types = search.findAllSubTypes(p, parent);
	        if (types.length > 0) {
	            types.forEach(function (y) {
	                if (!rt) {
	                    if (y.match(x, rt)) {
	                        rt = y;
	                    }
	                }
	            });
	        }
	        return rt;
	    }
	    finally {
	        if (n._node) {
	            delete n._node['descriminate'];
	        }
	    }
	}
	;
	//# sourceMappingURL=builder.js.map

/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../../typings/tsd.d.ts" />
	var jsyaml = __webpack_require__(6);
	var defs = __webpack_require__(21);
	var hl = __webpack_require__(17);
	var _ = __webpack_require__(47);
	var typeExpression = __webpack_require__(31);
	var def = __webpack_require__(21);
	var ramlSignature = __webpack_require__(16);
	var hlimpl = __webpack_require__(7);
	var su = __webpack_require__(54);
	var path = __webpack_require__(11);
	var fs = __webpack_require__(12);
	var mediaTypeParser = __webpack_require__(41);
	var xmlutil = __webpack_require__(70);
	var LinterSettings = (function () {
	    function LinterSettings() {
	        this.validateNotStrictExamples = true;
	    }
	    return LinterSettings;
	})();
	var settings = new LinterSettings();
	var loophole = __webpack_require__(48);
	function evalInSandbox(code, thisArg, args) {
	    return new loophole.Function(code).call(thisArg, args);
	}
	exports.evalInSandbox = evalInSandbox;
	var lintWithFile = function (customLinter, acceptor, astNode) {
	    if (fs.existsSync(customLinter)) {
	        try {
	            var content = fs.readFileSync(customLinter).toString();
	            var factr = new LinterExtensionsImpl(acceptor);
	            evalInSandbox(content, factr, null);
	            factr.visit(astNode);
	        }
	        catch (e) {
	            console.log("Error in custom linter");
	            console.log(e);
	        }
	    }
	};
	function lintNode(astNode, acceptor) {
	    var ps = astNode.lowLevel().unit().absolutePath();
	    var dr = path.dirname(ps);
	    var customLinter = path.resolve(dr, "raml-lint.js");
	    lintWithFile(customLinter, acceptor, astNode);
	    var dir = path.resolve(dr, ".raml");
	    if (fs.existsSync(dir)) {
	        var st = fs.statSync(dir);
	        if (st.isDirectory()) {
	            var files = fs.readdirSync(dir);
	            files.forEach(function (x) {
	                if (x.indexOf("-lint.js") != -1) {
	                    lintWithFile(path.resolve(dir, x), acceptor, astNode);
	                }
	                //console.log(x);
	            });
	        }
	    }
	}
	exports.lintNode = lintNode;
	;
	var LinterExtensionsImpl = (function () {
	    function LinterExtensionsImpl(acceptor) {
	        this.acceptor = acceptor;
	        this.nodes = {};
	    }
	    LinterExtensionsImpl.prototype.error = function (w, message) {
	        this.acceptor.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, message, w.highLevel()));
	    };
	    LinterExtensionsImpl.prototype.errorOnProperty = function (w, property, message) {
	        var pr = w.highLevel().attr(property);
	        this.acceptor.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, message, pr));
	    };
	    LinterExtensionsImpl.prototype.warningOnProperty = function (w, property, message) {
	        var pr = w.highLevel().attr(property);
	        this.acceptor.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, message, pr, true));
	    };
	    LinterExtensionsImpl.prototype.warning = function (w, message) {
	        this.acceptor.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, message, w.highLevel(), true));
	    };
	    LinterExtensionsImpl.prototype.registerRule = function (nodeType, rule) {
	        var q = this.nodes[nodeType];
	        if (!q) {
	            q = [];
	            this.nodes[nodeType] = q;
	        }
	        q.push(rule);
	    };
	    LinterExtensionsImpl.prototype.visit = function (h) {
	        var _this = this;
	        var nd = h.definition();
	        this.process(nd, h);
	        nd.allSuperTypes().forEach(function (x) { return _this.process(x, h); });
	        h.elements().forEach(function (y) { return _this.visit(y); });
	    };
	    LinterExtensionsImpl.prototype.process = function (d, h) {
	        var _this = this;
	        if (d instanceof def.NodeClass) {
	            if (!d.getDeclaringNode()) {
	                var rules = this.nodes[d.name()];
	                if (rules) {
	                    rules.forEach(function (x) { return x(h.wrapperNode(), _this); });
	                }
	            }
	        }
	    };
	    return LinterExtensionsImpl;
	})();
	exports.LinterExtensionsImpl = LinterExtensionsImpl;
	var StackNode = (function () {
	    function StackNode() {
	    }
	    StackNode.prototype.toString = function () {
	        if (this.prev) {
	            return this.value + "." + this.prev.toString();
	        }
	        return this.value;
	    };
	    StackNode.prototype.last = function () {
	        if (this.prev) {
	            return this.prev.last();
	        }
	        return this;
	    };
	    return StackNode;
	})();
	var TypeValidator = (function () {
	    function TypeValidator(node) {
	        this.node = node;
	    }
	    TypeValidator.prototype.validate = function (obj, t, cb, strict) {
	        if (t instanceof def.Array) {
	            this.validateArray(obj, t, cb, strict);
	        }
	        else if (t instanceof def.Union) {
	            this.validateUnion(obj, t, cb, strict);
	        }
	        else if (t instanceof def.NodeClass) {
	            this.validateClass(obj, t, cb, strict);
	        }
	        else if (t instanceof def.ValueType) {
	            this.validateValue(obj, t, cb, strict);
	        }
	        else {
	            throw new Error("Not supported case");
	        }
	    };
	    TypeValidator.prototype.createIssue = function (c, message, node, w) {
	        if (w === void 0) { w = false; }
	        var result = hlimpl.createIssue(c, message, node, w);
	        if (this.stack) {
	            var ll = this.findNode(this.stack.last(), this.node.lowLevel());
	            if (ll && ll != node.lowLevel()) {
	                if (ll.unit() == node.root().lowLevel().unit()) {
	                    if (ll.keyStart() > 0 && ll.keyEnd() > 0) {
	                        result.start = ll.keyStart();
	                        result.end = ll.keyEnd();
	                    }
	                }
	            }
	        }
	        return result;
	    };
	    TypeValidator.prototype.findNode = function (c, q) {
	        var key = "" + c.value;
	        if (typeof c.value == 'number') {
	            var m = q.children();
	            if (m[c.value]) {
	                var node = m[c.value];
	                if (c.next) {
	                    return this.findNode(c.next, node);
	                }
	            }
	            return q;
	        }
	        var node = _.find(q.children(), function (x) { return x.key() == key; });
	        if (node) {
	            if (c.next) {
	                return this.findNode(c.next, node);
	            }
	            return node;
	        }
	        else {
	            return q;
	        }
	    };
	    TypeValidator.prototype.validateClass = function (obj, t, cb, strict) {
	        var _this = this;
	        var supers = t.allSuperTypes();
	        supers.push(t);
	        this.validateFacets(t.isRuntime() ? t : t.toRuntime(), obj, cb, strict);
	        supers.forEach(function (s) {
	            if (s.name() == "StrElement") {
	                if (typeof obj != 'string' && typeof obj != 'number' && typeof obj != 'boolean') {
	                    cb.accept(_this.createIssue(7 /* INVALID_VALUE_SCHEMA */, "String is expected", _this.node, !strict));
	                }
	            }
	            if (s.name() == "NumberElement") {
	                if (typeof obj != 'number') {
	                    cb.accept(_this.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Number is expected", _this.node, !strict));
	                }
	            }
	            if (s.name() == "BooleanElement") {
	                var isOk = obj == true || obj == false;
	                if (!isOk) {
	                    cb.accept(_this.createIssue(7 /* INVALID_VALUE_SCHEMA */, "boolean is expected", _this.node, !strict));
	                }
	            }
	            if (s instanceof def.Array) {
	                _this.validate(obj, s, cb, strict);
	            }
	            if (s instanceof def.Union) {
	                _this.validate(obj, s, cb, strict);
	            }
	        });
	        var props = t.isRuntime() ? t.allProperties() : t.toRuntime().allProperties();
	        if (!obj) {
	            obj = {};
	        }
	        var handled = {};
	        props.forEach(function (p) {
	            if (!p.isMerged()) {
	                var value = obj[p.name()];
	                handled[p.name()] = 1;
	                if (!value) {
	                    if (p.isRequired()) {
	                        cb.accept(_this.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Required property:" + p.name() + " is missed", _this.node, !strict));
	                    }
	                }
	                else {
	                    _this.validatePropValue(value, p, cb, strict, p.name());
	                }
	            }
	        });
	        props.forEach(function (p) {
	            if (p.isMerged()) {
	                if (p.getKeyRegexp() != null) {
	                    Object.keys(obj).forEach(function (x) {
	                        if (!handled[x]) {
	                            try {
	                                var re = new RegExp(p.getKeyRegexp());
	                                if (re.test(x)) {
	                                    var n = _this.node;
	                                    _this.validatePropValue(obj[x], p, cb, strict, x);
	                                    handled[x] = 1;
	                                }
	                            }
	                            catch (e) {
	                            }
	                        }
	                    });
	                }
	            }
	        });
	        props.forEach(function (p) {
	            if (p.isMerged()) {
	                if (p.keyPrefix() != null) {
	                    Object.keys(obj).forEach(function (x) {
	                        if (!handled[x]) {
	                            _this.validatePropValue(obj[x], p, cb, strict, x);
	                            handled[x] = 1;
	                        }
	                    });
	                }
	            }
	        });
	        if (typeof obj == 'object' && props.length > 0) {
	            Object.keys(obj).forEach(function (x) {
	                if (!handled[x]) {
	                    try {
	                        _this.pushStack(x);
	                        cb.accept(_this.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Unknown property:" + x, _this.node, !strict));
	                    }
	                    finally {
	                        if (_this.stack) {
	                            _this.stack = _this.stack.prev;
	                        }
	                    }
	                }
	            });
	        }
	    };
	    TypeValidator.prototype.validateFacets = function (t, obj, cb, strict) {
	        var rof = t.getRepresentationOf();
	        var fixedFacets = t.getFixedFacets();
	        if (rof) {
	            t = rof;
	            if (t instanceof def.UserDefinedClass) {
	                fixedFacets = t.getFixedFacets();
	            }
	        }
	        for (var facetKey in fixedFacets) {
	            var facet = t.facet(facetKey);
	            if (facet) {
	                var facetValue = fixedFacets[facetKey];
	                var facetValidator = facet.getFacetValidator();
	                if (facetValidator) {
	                    try {
	                        var result = facetValidator(obj, facetValue);
	                        if (typeof result == "string") {
	                            cb.accept(this.createIssue(7 /* INVALID_VALUE_SCHEMA */, "" + result, this.node, !strict));
	                        }
	                    }
	                    catch (e) {
	                        cb.accept(this.createIssue(7 /* INVALID_VALUE_SCHEMA */, e.message, this.node, !strict));
	                    }
	                }
	            }
	        }
	    };
	    TypeValidator.prototype.validatePropValue = function (value, p, cb, strict, key) {
	        this.pushStack(key);
	        try {
	            this.validate(value, p.range(), cb, strict);
	            var enumValues = p.enumValues(null);
	            if (enumValues) {
	                if (typeof enumValues == 'string') {
	                    if (enumValues != value) {
	                        cb.accept(this.createIssue(7 /* INVALID_VALUE_SCHEMA */, "" + p.name() + " should be one of " + enumValues, this.node, !strict));
	                    }
	                }
	                else if (enumValues.length > 0) {
	                    if (!_.find(enumValues, function (x) { return x == value; })) {
	                        cb.accept(this.createIssue(7 /* INVALID_VALUE_SCHEMA */, "" + p.name() + " should be one of " + enumValues, this.node, !strict));
	                    }
	                }
	            }
	        }
	        finally {
	            if (this.stack) {
	                this.stack = this.stack.prev;
	            }
	        }
	    };
	    TypeValidator.prototype.pushStack = function (key) {
	        if (!this.stack) {
	            this.stack = new StackNode();
	            this.stack.value = key;
	        }
	        else {
	            var pn = new StackNode();
	            pn.prev = this.stack;
	            this.stack.next = pn;
	            this.stack = pn;
	            this.stack.value = key;
	        }
	    };
	    TypeValidator.prototype.validateArray = function (obj, t, cb, strict) {
	        var _this = this;
	        if (!(obj instanceof Array)) {
	            obj = [obj];
	        }
	        if (obj instanceof Array) {
	            var arr = obj;
	            this.validateFacets(t, obj, cb, strict);
	            var num = 0;
	            arr.forEach(function (x) {
	                try {
	                    _this.pushStack(num++);
	                    _this.validate(x, t.component, cb, strict);
	                }
	                finally {
	                    if (_this.stack) {
	                        _this.stack = _this.stack.prev;
	                    }
	                }
	            });
	        }
	    };
	    TypeValidator.prototype.validateUnion = function (obj, t, cb, strict) {
	        //FIXME
	    };
	    TypeValidator.prototype.validateValue = function (obj, t, cb, strict) {
	        //FIXME
	        if (t.name() == "NumberType") {
	            if (typeof obj != 'number') {
	                var qqq = parseFloat(obj);
	                if (!qqq) {
	                    if (isNaN(qqq)) {
	                        cb.accept(this.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Number is expected", this.node, !strict));
	                    }
	                }
	            }
	        }
	        if (t.name() == "BooleanType") {
	            if (typeof obj != 'boolean') {
	                if (obj != 'true' && obj != 'false') {
	                    cb.accept(this.createIssue(7 /* INVALID_VALUE_SCHEMA */, "boolean is expected", this.node, !strict));
	                }
	            }
	        }
	    };
	    return TypeValidator;
	})();
	exports.TypeValidator = TypeValidator;
	var NormalValidator = (function () {
	    function NormalValidator() {
	    }
	    NormalValidator.prototype.validate = function (node, cb) {
	        var vl = node.value();
	        if (node.parent().allowsQuestion() && node.property().isKey()) {
	            if (vl != null && vl.length > 0 && vl.charAt(vl.length - 1) == '?') {
	                vl = vl.substr(0, vl.length - 1);
	            }
	        }
	        var pr = node.property();
	        var range = pr.range();
	        if (range instanceof def.NodeClass) {
	            var nc = range;
	            var rof = nc.getRepresentationOf();
	            if (rof) {
	                nc = rof;
	            }
	            var ff = nc.getFixedFacets();
	            for (var fc in ff) {
	                var facet = nc.facet(fc);
	                if (facet) {
	                    var val = facet.getFacetValidator();
	                    if (val) {
	                        try {
	                            var qq = vl;
	                            if (pr.range().isArray()) {
	                                try {
	                                    qq = node.parent().lowLevel().dumpToObject()[node.parent().name()][pr.name()];
	                                }
	                                catch (e) {
	                                }
	                            }
	                            var res = val(qq, ff[fc]);
	                            if (typeof res == 'string') {
	                                cb.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, "" + res, node));
	                            }
	                        }
	                        catch (e) {
	                            cb.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, e.message, node));
	                        }
	                    }
	                }
	            }
	        }
	        var v = cb;
	        var validation = pr.range().isValid(node.parent(), vl, pr);
	        if (validation instanceof Error) {
	            if (!validation.canBeRef) {
	                v.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, validation.message, node));
	                validation = null;
	                return;
	            }
	        }
	        if (!validation || validation instanceof Error) {
	            if (pr.name() != 'value') {
	                if (!checkReference(pr, node, vl, v)) {
	                    if (pr.name() == 'schema' || pr.name() == 'type') {
	                        if (vl && vl.trim() && (pr.domain().name() == 'BodyLike' || pr.domain().name() == "DataElement")) {
	                            var testSchema = vl.trim().charAt(0); //FIXME
	                            if (testSchema != '{' && testSchema != '<') {
	                                return;
	                            }
	                        }
	                    }
	                    var decl = node.findReferencedValue();
	                    if (decl instanceof Error) {
	                        v.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, decl.message, node));
	                    }
	                    if (!decl) {
	                        if (vl) {
	                            if (pr.name() == 'schema') {
	                                var z = vl.trim();
	                                if (z.charAt(0) != '{' && z.charAt(0) != '<') {
	                                    if (vl.indexOf('|') != -1 || vl.indexOf('[]') != -1 || vl.indexOf("(") != -1) {
	                                        return;
	                                    }
	                                }
	                            }
	                        }
	                        if (validation instanceof Error && vl) {
	                            v.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, validation.message, node));
	                            validation = null;
	                            return;
	                        }
	                        v.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, "Empty value is not allowed here", node));
	                    }
	                }
	            }
	            else {
	                var vl = node.value();
	                var message = "Invalid value schema:" + vl;
	                if (validation instanceof Error) {
	                    message = validation.message;
	                }
	                v.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, message, node));
	            }
	        }
	        var values = pr.enumOptions();
	        if (values) {
	            if (typeof values == 'string') {
	                if (values != vl) {
	                    if (vl && (vl.indexOf("x-") == 0) && pr.name() == "type") {
	                    }
	                    else {
	                        v.accept(createIssue(0 /* UNRESOLVED_REFERENCE */, "Invalid value:" + vl + " allowed values are:" + values, node));
	                    }
	                }
	            }
	            else if (values.length > 0) {
	                if (!_.find(values, function (x) { return x == vl; })) {
	                    if (vl && (vl.indexOf("x-") == 0) && pr.name() == "type") {
	                    }
	                    else {
	                        v.accept(createIssue(0 /* UNRESOLVED_REFERENCE */, "Invalid value:" + vl + " allowed values are:" + values.join(","), node));
	                    }
	                }
	            }
	        }
	    };
	    return NormalValidator;
	})();
	exports.NormalValidator = NormalValidator;
	var UriValidator = (function () {
	    function UriValidator() {
	    }
	    UriValidator.prototype.validate = function (node, cb) {
	        try {
	            new UrlParameterNameValidator().parseUrl(node.value());
	        }
	        catch (e) {
	            cb.accept(hlimpl.createIssue(7 /* INVALID_VALUE_SCHEMA */, e.message, node, false));
	        }
	    };
	    return UriValidator;
	})();
	exports.UriValidator = UriValidator;
	var MediaTypeValidator = (function () {
	    function MediaTypeValidator() {
	    }
	    MediaTypeValidator.prototype.validate = function (node, cb) {
	        try {
	            var v = node.value();
	            if (!v) {
	                return;
	            }
	            if (v == "*/*") {
	                return;
	            }
	            if (v.indexOf("/*") == v.length - 2) {
	                v = v.substring(0, v.length - 2) + "/xxx";
	            }
	            if (v == "body") {
	                if (node.parent().parent()) {
	                    if (node.parent().parent().definition().name() == "Response" || node.parent().parent().definition().isAssignableFrom("MethodBase")) {
	                        v = node.parent().computedValue("mediaType");
	                    }
	                }
	            }
	            var res = mediaTypeParser.parse(v);
	            var types = {
	                application: 1,
	                audio: 1,
	                example: 1,
	                image: 1,
	                message: 1,
	                model: 1,
	                multipart: 1,
	                text: 1,
	                video: 1
	            };
	            if (!types[res.type]) {
	                cb.accept(hlimpl.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Unknown media type 'type'", node));
	            }
	        }
	        catch (e) {
	            cb.accept(hlimpl.createIssue(7 /* INVALID_VALUE_SCHEMA */, "" + e.message, node));
	        }
	        if (node.value() && node.value() == ("multipart/form-data") || node.value() == ("application/x-www-form-urlencoded")) {
	            if (node.parent() && node.parent().parent() && node.parent().parent().property()) {
	                if (node.parent().parent().property().name() == 'responses') {
	                    cb.accept(hlimpl.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Form related media types can not be used in responses", node));
	                }
	            }
	        }
	        return;
	    };
	    return MediaTypeValidator;
	})();
	exports.MediaTypeValidator = MediaTypeValidator;
	var SignatureValidator = (function () {
	    function SignatureValidator() {
	    }
	    SignatureValidator.prototype.validate = function (node, cb) {
	        var vl = node.value();
	        var q = vl ? vl.trim() : "";
	        if (q.length > 0) {
	            try {
	                ramlSignature.validate(vl, node, cb);
	            }
	            catch (e) {
	                cb.accept(hlimpl.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Error during signature parse:" + e.message, node));
	            }
	            return;
	        }
	        return;
	    };
	    return SignatureValidator;
	})();
	exports.SignatureValidator = SignatureValidator;
	var UrlParameterNameValidator = (function () {
	    function UrlParameterNameValidator() {
	    }
	    UrlParameterNameValidator.prototype.checkBaseUri = function (node, c, vl, v) {
	        var bu = c.root().attr("baseUri");
	        if (bu) {
	            var tnv = bu.value();
	            try {
	                var pNames = this.parseUrl(tnv);
	                if (!_.find(pNames, function (x) { return x == vl; })) {
	                    v.accept(hlimpl.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Unused url parameter", node));
	                }
	            }
	            catch (e) {
	            }
	        }
	        else {
	            v.accept(hlimpl.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Unused url parameter", node));
	        }
	    };
	    UrlParameterNameValidator.prototype.parseUrl = function (value) {
	        var result = [];
	        var temp = "";
	        var inPar = false;
	        var count = 0;
	        for (var a = 0; a < value.length; a++) {
	            var c = value[a];
	            if (c == '{') {
	                count++;
	                inPar = true;
	                continue;
	            }
	            if (c == '}') {
	                count--;
	                inPar = false;
	                result.push(temp);
	                temp = "";
	                continue;
	            }
	            if (inPar) {
	                temp += c;
	            }
	        }
	        if (count > 0) {
	            throw new Error("Unmatched '{'");
	        }
	        if (count < 0) {
	            throw new Error("Unmatched '}'");
	        }
	        return result;
	    };
	    UrlParameterNameValidator.prototype.validate = function (node, cb) {
	        var vl = node.value();
	        if (node.parent().property().name() == 'baseUriParameters') {
	            var c = node.parent().parent();
	            this.checkBaseUri(node, c, vl, cb);
	            return;
	        }
	        var c = node.parent().parent();
	        var tn = c.name();
	        if (c.definition().name() == 'Api') {
	            this.checkBaseUri(node, c, vl, cb);
	        }
	        try {
	            var pNames = this.parseUrl(tn);
	            if (!_.find(pNames, function (x) { return x == vl; })) {
	                cb.accept(hlimpl.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Unused url parameter '" + vl + "'", node));
	            }
	        }
	        catch (e) {
	        }
	    };
	    return UrlParameterNameValidator;
	})();
	exports.UrlParameterNameValidator = UrlParameterNameValidator;
	function checkReference(pr, astNode, vl, cb) {
	    if (!vl) {
	        return;
	    }
	    if (vl == 'null') {
	        if (pr.isAllowNull()) {
	            return;
	        }
	    }
	    try {
	        if (typeof vl == 'string') {
	            if (pr.domain().name() == 'DataElement') {
	                if (pr.name() == "type" || pr.name() == 'items') {
	                    typeExpression.validate(vl, astNode, cb);
	                    return false;
	                }
	            }
	            if (pr.range().name() == "SchemaString") {
	                if (pr.range().universe().version() == "RAML10") {
	                    if (pr.range() instanceof defs.ValueType) {
	                        typeExpression.validate(vl, astNode, cb);
	                        return false;
	                    }
	                }
	            }
	            if (pr.name() == "schema" || pr.name() == 'type') {
	                if (pr.domain().name() == 'BodyLike' || pr.domain().name() == "DataElement") {
	                    var q = vl.trim();
	                    if (q.length > 0 && q.charAt(0) != '{' && q.charAt(0) != '<') {
	                        typeExpression.validate(vl, astNode, cb);
	                        return false;
	                    }
	                    return;
	                }
	            }
	        }
	    }
	    catch (e) {
	        cb.accept(createIssue(0 /* UNRESOLVED_REFERENCE */, "Syntax error:" + e.message, astNode));
	    }
	    var valid = pr.isValidValue(vl, astNode.parent());
	    if (!valid) {
	        if (typeof vl == 'string') {
	            if ((vl.indexOf("x-") == 0) && pr.name() == "type") {
	                return true;
	            }
	        }
	        cb.accept(createIssue(0 /* UNRESOLVED_REFERENCE */, "Unresolved reference:" + vl, astNode));
	        return true;
	    }
	    return false;
	}
	exports.checkReference = checkReference;
	;
	var SchemaOrTypeValidator = (function () {
	    function SchemaOrTypeValidator() {
	    }
	    SchemaOrTypeValidator.prototype.validate = function (node, cb) {
	        var vl = node.value();
	        if (vl instanceof hlimpl.StructuredValue) {
	            //already validated in scalar
	            //cb.accept(createIssue(hl.IssueCode.UNRESOLVED_REFERENCE,"Type expression is expected here",node));
	            return;
	        }
	        if (!vl) {
	            vl = "";
	        }
	        try {
	            typeExpression.validate(vl, node, cb);
	        }
	        catch (e) {
	            cb.accept(createIssue(0 /* UNRESOLVED_REFERENCE */, "Syntax error:" + e.message, node));
	        }
	    };
	    return SchemaOrTypeValidator;
	})();
	exports.SchemaOrTypeValidator = SchemaOrTypeValidator;
	var DescriminatorOrReferenceValidator = (function () {
	    function DescriminatorOrReferenceValidator() {
	    }
	    DescriminatorOrReferenceValidator.prototype.validate = function (node, cb) {
	        var vl = node.value();
	        var valueKey = vl;
	        var pr = node.property();
	        if (typeof vl == 'string') {
	            checkReference(pr, node, vl, cb);
	            if (pr.range() instanceof defs.ReferenceType) {
	                var t = pr.range();
	                if (true) {
	                    var mockNode = jsyaml.createNode("" + vl);
	                    mockNode._actualNode().startPosition = node.lowLevel().valueStart();
	                    mockNode._actualNode().endPosition = node.lowLevel().valueEnd();
	                    var stv = new hlimpl.StructuredValue(mockNode, node.parent(), node.property());
	                    var hn = stv.toHighlevel();
	                    if (hn) {
	                        hn.validate(cb);
	                    }
	                }
	            }
	        }
	        else {
	            var st = vl;
	            if (st) {
	                valueKey = st.valueName();
	                var vn = st.valueName();
	                if (!checkReference(pr, node, vn, cb)) {
	                    var hnode = st.toHighlevel();
	                    if (hnode)
	                        hnode.validate(cb);
	                }
	            }
	            else {
	                valueKey = null;
	            }
	        }
	        if (valueKey) {
	            var validation = pr.range().isValid(node.parent(), valueKey, pr);
	            if (validation instanceof Error) {
	                cb.accept(createIssue(7 /* INVALID_VALUE_SCHEMA */, validation.message, node));
	                validation = null;
	            }
	        }
	    };
	    return DescriminatorOrReferenceValidator;
	})();
	exports.DescriminatorOrReferenceValidator = DescriminatorOrReferenceValidator;
	/**
	 * validates examples
	 */
	var ExampleValidator = (function () {
	    function ExampleValidator() {
	    }
	    ExampleValidator.prototype.validate = function (node, cb) {
	        //check if we expect to do strict validation
	        var strictValidation = this.isStrict(node);
	        if (!strictValidation) {
	            if (!settings.validateNotStrictExamples) {
	                return;
	            }
	        }
	        var pObj = this.parseObject(node, cb, strictValidation);
	        if (!pObj) {
	            return;
	        }
	        var schema = this.aquireSchema(node);
	        if (schema) {
	            schema.validate(pObj, cb, strictValidation);
	        }
	    };
	    ExampleValidator.prototype.aquireSchema = function (node) {
	        var sp = node.parent().definition().isAssignableFrom("DataElement");
	        if (node.name() == "example") {
	            if (node.parent().property().name() == "types") {
	                sp = false;
	            }
	            if (node.parent().parent()) {
	                if (node.parent().parent().definition().name() == "Method") {
	                    if (node.parent().property().name() == "queryParameters") {
	                    }
	                    else {
	                        sp = true;
	                    }
	                }
	                if (node.parent().parent().definition().name() == "Response") {
	                    sp = true;
	                }
	            }
	        }
	        if (node.parent().definition().name() == "BodyLike" || sp) {
	            //FIXME MULTIPLE INHERITANCE
	            var sa = node.parent().attr("schema");
	            if (!sa) {
	                sa = node.parent().attr("type");
	            }
	            if (sa) {
	                var val = sa.value();
	                if (val instanceof hlimpl.StructuredValue) {
	                    return null;
	                }
	                var strVal = ("" + val).trim();
	                var so = null;
	                if (strVal.charAt(0) == "{") {
	                    try {
	                        so = su.getJSONSchema(strVal);
	                    }
	                    catch (e) {
	                        return null;
	                    }
	                }
	                if (strVal.charAt(0) == "<") {
	                    try {
	                        so = su.getXMLSchema(strVal);
	                    }
	                    catch (e) {
	                        return null;
	                    }
	                }
	                if (so) {
	                    return {
	                        validate: function (pObje, cb, strict) {
	                            try {
	                                so.validateObject(pObje);
	                            }
	                            catch (e) {
	                                cb.accept(hlimpl.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Example does not conforms to schema:" + e.message, node, !strict));
	                                return;
	                            }
	                            //validate using classical schema;
	                        }
	                    };
	                }
	                else {
	                    //lets try to get schema from type
	                    if (strVal.length > 0) {
	                        var tp = typeExpression.getType2(node.parent(), strVal, {});
	                        if (tp) {
	                            return {
	                                validate: function (pObje, cb, strict) {
	                                    new TypeValidator(node).validate(pObje, tp, cb, strict);
	                                    //validate using typeExpression;
	                                }
	                            };
	                        }
	                    }
	                }
	            }
	        }
	        return this.getSchemaFromModel(node);
	    };
	    ExampleValidator.prototype.getSchemaFromModel = function (node) {
	        var p = node.parent();
	        if (node.property().name() == "content") {
	            p = p.parent();
	        }
	        var tp = hlimpl.typeFromNode(p);
	        if (tp) {
	            return {
	                validate: function (pObje, cb, strict) {
	                    new TypeValidator(node).validate(pObje, tp, cb, strict);
	                    //validate using typeExpression;
	                }
	            };
	        }
	        return null;
	    };
	    ExampleValidator.prototype.toObject = function (h, v, cb) {
	        var res = v.lowLevel().dumpToObject(true);
	        this.testDublication(h, v.lowLevel(), cb);
	        if (res["example"]) {
	            return res["example"];
	        }
	        if (res["content"]) {
	            return res["content"];
	        }
	    };
	    ExampleValidator.prototype.testDublication = function (h, v, cb) {
	        var _this = this;
	        var map = {};
	        v.children().forEach(function (x) {
	            if (x.key()) {
	                if (map[x.key()]) {
	                    cb.accept(createIssue(5 /* KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT */, "Keys should be unique", new hlimpl.BasicASTNode(x, h.parent())));
	                }
	                map[x.key()] = x;
	            }
	            _this.testDublication(h, x, cb);
	        });
	    };
	    ExampleValidator.prototype.parseObject = function (node, cb, strictValidation) {
	        var pObj = null;
	        var vl = node.value();
	        var mediaType = getMediaType(node);
	        if (vl instanceof hlimpl.StructuredValue) {
	            //validate in context of type/schema
	            pObj = this.toObject(node, vl, cb);
	        }
	        else {
	            if (mediaType) {
	                if (isJson(mediaType)) {
	                    try {
	                        pObj = JSON.parse(vl);
	                    }
	                    catch (e) {
	                        cb.accept(hlimpl.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Can not parse JSON:" + e.message, node, !strictValidation));
	                        return;
	                    }
	                }
	                if (isXML(mediaType)) {
	                    try {
	                        pObj = xmlutil(vl);
	                    }
	                    catch (e) {
	                        cb.accept(hlimpl.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Can not parse XML:" + e.message, node, !strictValidation));
	                        return;
	                    }
	                }
	            }
	            else {
	                try {
	                    pObj = JSON.parse(vl);
	                }
	                catch (e) {
	                    if (vl.trim().indexOf("<") == 0) {
	                        try {
	                            pObj = xmlutil(vl);
	                        }
	                        catch (e) {
	                            cb.accept(hlimpl.createIssue(7 /* INVALID_VALUE_SCHEMA */, "Can not parse XML:" + e.message, node, !strictValidation));
	                            return;
	                        }
	                    }
	                    else {
	                        //cb.accept(hlimpl.createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA, "Can not parse JSON:" + e.message, node, !strictValidation));
	                        return vl;
	                    }
	                }
	            }
	        }
	        return pObj;
	    };
	    ExampleValidator.prototype.isStrict = function (node) {
	        var strictValidation = false;
	        var strict = node.parent().attr("strict");
	        if (strict) {
	            if (strict.value() == 'true') {
	                strictValidation = true;
	            }
	        }
	        return strictValidation;
	    };
	    return ExampleValidator;
	})();
	exports.ExampleValidator = ExampleValidator;
	function isJson(s) {
	    return s.indexOf("json") != -1;
	}
	function isXML(s) {
	    return s.indexOf("xml") != -1;
	}
	function getMediaType(node) {
	    var vl = getMediaType2(node);
	    if (vl == 'body') {
	        var rootMedia = node.root().attr("mediaType");
	        if (rootMedia) {
	            return rootMedia.value();
	        }
	        return null;
	    }
	    return vl;
	}
	function getMediaType2(node) {
	    if (node.parent()) {
	        if (node.parent().definition().isAssignableFrom("BodyLike") && !node.parent().definition().isUserDefined()) {
	            return node.parent().name();
	        }
	        if (node.parent().parent()) {
	            if (node.parent().parent().definition().isAssignableFrom("Response") && !node.parent().parent().definition().isUserDefined()) {
	                if (node.parent().property().name() == "headers") {
	                    return null;
	                }
	                return node.parent().name();
	            }
	            if (node.parent().parent().definition().isAssignableFrom("Method") && !node.parent().parent().definition().isUserDefined()) {
	                if (node.parent().property().name() == "queryParameters" || node.parent().property().name() == "headers") {
	                    return null;
	                }
	                return node.parent().name();
	            }
	        }
	    }
	    return null;
	}
	var localError = function (node, c, w, message, p, prop) {
	    var st = node.lowLevel().start();
	    var et = node.lowLevel().end();
	    if (node.lowLevel().key() && node.lowLevel().keyStart()) {
	        var ks = node.lowLevel().keyStart();
	        if (ks > 0) {
	            st = ks;
	        }
	        var ke = node.lowLevel().keyEnd();
	        if (ke > 0) {
	            et = ke;
	        }
	    }
	    if (et < st) {
	        et = st + 1; //FIXME
	    }
	    if (prop && !prop.isMerged() && node.parent() == null) {
	        var nm = _.find(node.lowLevel().children(), function (x) { return x.key() == prop.name(); });
	        if (nm) {
	            var ks = nm.keyStart();
	            var ke = nm.keyEnd();
	            if (ks > 0 && ke > ks) {
	                st = ks;
	                et = ke;
	            }
	        }
	    }
	    return {
	        code: c,
	        isWarning: w,
	        message: message,
	        node: node,
	        start: st,
	        end: et,
	        path: p ? (node.lowLevel().unit() ? node.lowLevel().unit().path() : "") : null,
	        extras: [],
	        unit: node ? node.lowLevel().unit() : null
	    };
	};
	function createIssue(c, message, node, w) {
	    if (w === void 0) { w = false; }
	    //console.log(node.name()+node.lowLevel().start()+":"+node.id());
	    var original = null;
	    var pr = null;
	    if (node) {
	        pr = node.property();
	        if (node.lowLevel().unit() != node.root().lowLevel().unit()) {
	            original = localError(node, c, w, message, true, pr);
	            var v = node.lowLevel().unit();
	            if (v) {
	                message = message + " " + v.path();
	            }
	            while (node.lowLevel().unit() != node.root().lowLevel().unit()) {
	                pr = node.property();
	                node = node.parent();
	            }
	        }
	    }
	    if (original) {
	        if (node.property() && node.property().name() == "uses" && node.parent() != null) {
	            pr = node.property(); //FIXME there should be other cases
	            node = node.parent();
	        }
	    }
	    var error = localError(node, c, w, message, false, pr);
	    if (original) {
	        error.extras.push(original);
	    }
	    //console.log(error.start+":"+error.end)
	    return error;
	}
	exports.createIssue = createIssue;
	//# sourceMappingURL=linter.js.map

/***/ },
/* 34 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../../typings/tsd.d.ts" />
	var defs = __webpack_require__(21);
	var ts2Def = __webpack_require__(39);
	var _ = __webpack_require__(47);
	var selector = __webpack_require__(55);
	var typeExpression = __webpack_require__(31);
	var hlimpl = __webpack_require__(7);
	var linter = __webpack_require__(33);
	function templateFields(node, d) {
	    var u = node.root().definition().universe();
	    node.children().forEach(function (x) { return templateFields(x, d); });
	    if (node instanceof hlimpl.ASTPropImpl) {
	        var prop = node;
	        //TODO RECURSIVE PARAMETERS
	        var v = prop.value();
	        if (typeof v == 'string') {
	            var strV = v;
	            handleValue(strV, d, prop, false, u);
	        }
	        else {
	            node.lowLevel().visit(function (x) {
	                if (x.value()) {
	                    var strV = x.value() + "";
	                    handleValue(strV, d, prop, true, u);
	                }
	                return true;
	            });
	        }
	    }
	    else if (node instanceof hlimpl.BasicASTNode) {
	        var v = node.lowLevel().value();
	        if (typeof v == 'string') {
	            var strV = v;
	            handleValue(strV, d, null, false, u);
	        }
	        else {
	            node.lowLevel().visit(function (x) {
	                if (x.value()) {
	                    var strV = x.value() + "";
	                    handleValue(strV, d, null, true, u);
	                }
	                return true;
	            });
	        }
	    }
	}
	var handleValue = function (strV, d, prop, allwaysString, u) {
	    var ps = 0;
	    while (true) {
	        var pos = strV.indexOf("<<", ps);
	        if (pos != -1) {
	            var end = strV.indexOf(">>", pos);
	            var isFull = pos == 0 && end == strV.length - 2;
	            var parameterUsage = strV.substring(pos + 2, end);
	            ps = pos + 2;
	            var directiveIndex = parameterUsage.indexOf("|");
	            if (directiveIndex != -1) {
	                parameterUsage = parameterUsage.substring(0, directiveIndex);
	            }
	            parameterUsage = parameterUsage.trim();
	            if (parameterUsage == "resourcePathName" || parameterUsage == "methodName" || parameterUsage == "resourcePath") {
	                continue;
	            }
	            var q = d[parameterUsage];
	            var r = (prop) ? prop.property().range() : null;
	            if (prop) {
	                if (prop.property().name() == "type" || prop.property().name() == "schema") {
	                    if (prop.property().domain().name() == "DataElement") {
	                        r = u.getType("SchemaString");
	                    }
	                }
	            }
	            if (!isFull || allwaysString) {
	                r = u.getType("StringType");
	            }
	            //FIX ME NOT WHOLE TEMPLATES
	            if (q) {
	                q.push({
	                    tp: r,
	                    attr: prop
	                });
	            }
	            else {
	                d[parameterUsage] = [{
	                    tp: r,
	                    attr: prop
	                }];
	            }
	        }
	        else
	            break;
	    }
	};
	function typeFromNode(node) {
	    if (!node) {
	        return null;
	    }
	    if (node.associatedType()) {
	        return node.associatedType();
	    }
	    if (node.property() && node.property().name() == "annotationTypes") {
	        var result = new defs.AnnotationType(node.name(), node.definition().universe(), node, node.lowLevel().unit().path(), "");
	    }
	    else {
	        var result = new defs.UserDefinedClass(node.name(), node.definition().universe(), node, node.lowLevel().unit().path(), "");
	    }
	    node.setAssociatedType(result);
	    //result.setDeclaringNode(node);
	    var def = node.definition();
	    if (def.isInlinedTemplates()) {
	        var usages = {};
	        templateFields(node, usages);
	        Object.keys(usages).forEach(function (x) {
	            var prop = new defs.UserDefinedProp(x);
	            //prop._node=node;
	            prop.withDomain(result);
	            var tp = _.unique(usages[x]).map(function (x) { return x.tp; }).filter(function (x) { return x && x.name() != "StringType"; });
	            prop.withRange(tp.length == 1 ? tp[0] : node.definition().universe().getType("StringType"));
	            prop.withRequired(true);
	            if (usages[x].length > 0) {
	                prop._node = usages[x][0].attr;
	            }
	            prop.unmerge();
	        });
	        var keyProp = new defs.UserDefinedProp("key");
	        //prop._node=node;
	        keyProp.withDomain(result);
	        keyProp.withKey(true);
	        keyProp._node = node;
	        keyProp.withFromParentKey(true);
	        keyProp.withRange(node.definition().universe().getType("StringType"));
	    }
	    else if (def.getReferenceIs()) {
	        if (def.universe().version() == "RAML08") {
	            result.withAllowAny();
	        }
	        var p = def.property(def.getReferenceIs());
	        if (p) {
	            p.range().properties().forEach(function (x) {
	                var prop = new defs.Property(x.name());
	                prop.unmerge();
	                prop.withDomain(result);
	                prop.withRange(x.range());
	                prop.withMultiValue(x.isMultiValue());
	            });
	        }
	    }
	    else {
	        var rp = def.findMembersDeterminer();
	        if (rp) {
	            var elements = node.elementsOfKind(rp.name());
	            elements.forEach(function (x) {
	                var prop = elementToProp(x);
	                prop.withDomain(result);
	            });
	        }
	        //here we should found correct inheritance chain
	        var types = node.attributes("type");
	        var schema = node.attributes("schema");
	        types = types.concat(schema);
	        if (node.definition().name() == "GlobalSchema") {
	            var vl = node.attributes("value");
	            types = types.concat(vl);
	        }
	        var tp = types.length != 0;
	        types.forEach(function (tp) {
	            var vl = tp.value();
	            if (typeof vl == 'string' && vl) {
	                vl = vl.trim();
	                if (vl.charAt(0) == '{') {
	                    var et = new defs.ExternalType(node.name(), node.definition().universe(), node.lowLevel().unit().path(), "");
	                    et.schemaString = vl;
	                    et.node = node;
	                    var de = node.definition().universe().getType("ObjectField");
	                    if (de) {
	                        result._superTypes.push(de);
	                    }
	                    result._superTypes.push(et);
	                }
	                if (vl.charAt(0) == '<') {
	                    var et = new defs.ExternalType(node.name(), node.definition().universe(), node.lowLevel().unit().path(), "");
	                    et.schemaString = vl;
	                    et.node = node;
	                    var de = node.definition().universe().getType("ObjectField");
	                    if (de) {
	                        result._superTypes.push(de);
	                    }
	                    result._superTypes.push(et);
	                }
	            }
	            var types = {};
	            types[result.name()] = result;
	            var at = null;
	            if (vl != result.name()) {
	                at = typeExpression.getType(node.parent(), vl, types);
	            }
	            else {
	            }
	            if (at) {
	                result._superTypes.push(at);
	            }
	        });
	        result.addRequirement("type", node.name());
	        if (def.getExtendedType()) {
	            result._superTypes.push(def.getExtendedType());
	        }
	        {
	            //Adding runtime properties for object types TODO it should be done in more elegant way
	            var prop = _.find(node.lowLevel().children(), function (x) { return x.key() == "properties"; });
	            if (prop) {
	                var de = node.definition().universe().getType("ObjectField");
	                if (de) {
	                    result._superTypes.push(de);
	                }
	            }
	            else {
	                if (node.property() && node.property().name() == "body") {
	                    var de = node.definition().universe().getType("ObjectField");
	                    if (de) {
	                        result._superTypes.push(de);
	                    }
	                }
	                else if (!tp) {
	                    var de = node.definition().universe().getType("StrElement");
	                    if (de && node.definition().name() != "BodyLike" && node.definition().name() != "AnnotationType") {
	                        result._superTypes.push(de);
	                    }
	                }
	                if (result._superTypes.length == 0) {
	                    var de = node.definition().universe().getType("DataElement");
	                    if (de) {
	                        result._superTypes.push(de);
	                    }
	                }
	            }
	            var pn = node.definition().universe().getType("ObjectField");
	            if (pn) {
	                node.lowLevel().children().forEach(function (x) {
	                    if (x.key() == "facets") {
	                        return;
	                    }
	                    if (x.key() == "annotations") {
	                        return;
	                    }
	                    if (x.key() == "parameters") {
	                        return;
	                    }
	                    if (!pn.property(x.key())) {
	                        result.fixFacet(x.key(), x);
	                    }
	                });
	            }
	        }
	    }
	    return result;
	}
	exports.typeFromNode = typeFromNode;
	function parsePropertyName(name) {
	    var v = { name: "", regexp: null };
	    if (name.length > 2) {
	        name = name.substr(1, name.length - 2);
	        var pos = name.lastIndexOf("#");
	        if (pos != -1) {
	            v.name = name.substr(pos + 1);
	            v.regexp = name.substr(0, pos);
	        }
	        else {
	            v.regexp = name;
	        }
	    }
	    return v;
	}
	exports.parsePropertyName = parsePropertyName;
	function libraryLocation(definition) {
	    var node = definition.getDeclaringNode();
	    var result = null;
	    if (node != null) {
	        var library = node.parent();
	        if (library) {
	            var libraryAnnotations = library.attributes("annotations");
	            libraryAnnotations.forEach(function (x) {
	                var value = x.value();
	                if (value instanceof hlimpl.StructuredValue) {
	                    if (value.lowLevel().key() == "(LibraryLocation)") {
	                        var hlv = value.toHighlevel(library);
	                        if (hlv) {
	                            result = valueOf(hlv);
	                        }
	                    }
	                }
	            });
	        }
	    }
	    return result;
	}
	exports.libraryLocation = libraryLocation;
	function valueOf(hl) {
	    if (hl) {
	        var vl = hl.attr("value");
	        if (vl) {
	            return vl.value();
	        }
	    }
	    return null;
	}
	exports.valueOf = valueOf;
	var scriptToValidator = {};
	var loophole = __webpack_require__(48);
	function evalInSandbox(code, thisArg, args) {
	    return new loophole.Function(code).call(thisArg, args);
	}
	var ValidatorHolder = (function () {
	    function ValidatorHolder() {
	    }
	    ValidatorHolder.prototype.register = function (mm) {
	        this._result = mm;
	    };
	    return ValidatorHolder;
	})();
	function aquireValidator(value) {
	    if (value) {
	        var nm = scriptToValidator[value];
	        if (nm) {
	            if (nm == aquireValidator) {
	                return null;
	            }
	            return nm;
	        }
	        try {
	            var holder = new ValidatorHolder();
	            evalInSandbox(value, holder, []);
	            if (holder._result) {
	                scriptToValidator[value] = holder._result;
	                return holder._result;
	            }
	            else {
	                scriptToValidator[value] = aquireValidator;
	            }
	        }
	        catch (e) {
	            scriptToValidator[value] = aquireValidator;
	        }
	    }
	    return null;
	}
	exports.aquireValidator = aquireValidator;
	function elementToProp(e, toRuntime) {
	    if (toRuntime === void 0) { toRuntime = false; }
	    var nm = e.name();
	    var optional = false;
	    if (nm.length > 0 && nm.charAt(nm.length - 1) == '?') {
	        nm = nm.substr(0, nm.length - 1);
	        optional = true;
	    }
	    var result = new defs.UserDefinedProp(nm);
	    result._node = e;
	    try {
	        var example = e.attr("example");
	        if (example) {
	            var obj = new linter.ExampleValidator().parseObject(example, {
	                begin: function () {
	                },
	                end: function () {
	                },
	                accept: function (f) {
	                }
	            }, false);
	            result.setDefaultVal(obj);
	        }
	        else {
	            var exampleElements = e.elementsOfKind("examples");
	            exampleElements.forEach(function (x) {
	                var cnt = x.attr("content");
	                if (cnt) {
	                    var obj = new linter.ExampleValidator().parseObject(cnt, {
	                        begin: function () {
	                        },
	                        end: function () {
	                        },
	                        accept: function (f) {
	                        }
	                    }, false);
	                    result.setDefaultVal(obj);
	                }
	            });
	        }
	    }
	    catch (e) {
	        console.log(e); //TODO remove me
	    }
	    var annotations = e.attributes("annotations");
	    annotations.forEach(function (annotation) {
	        var value = annotation.value();
	        if (value instanceof hlimpl.StructuredValue) {
	            var highLevel = value.toHighlevel(e);
	            if (highLevel) {
	                var definition = highLevel.definition();
	                if (definition.name() == "FacetInstanceValidator") {
	                    var node = definition.getDeclaringNode();
	                    var ll = libraryLocation(definition);
	                    if (ll == "http://raml.org/library/common.raml") {
	                        var value = valueOf(highLevel);
	                        var facetValidator = aquireValidator(value);
	                        if (facetValidator) {
	                            result.setFacetValidator(facetValidator);
	                        }
	                    }
	                }
	            }
	        }
	    });
	    if (nm.length > 0) {
	        if (nm[0] == '[') {
	            optional = true;
	            var info = parsePropertyName(nm);
	            if (info.regexp) {
	                result.withKeyRegexp(info.regexp);
	            }
	            else {
	                result.withKeyRestriction("");
	            }
	            if (info.name) {
	                result.withDescription(info.name);
	            }
	            result.withMultiValue();
	        }
	        else {
	            result.unmerge();
	        }
	    }
	    var props = e.definition().properties();
	    var tp = e.attr("type");
	    if (tp) {
	        var typeName = tp.value();
	        if (typeName == "any") {
	            result.withMultiValue(true);
	            var rm = new defs.NodeClass("ObjectField", e.definition().universe(), "", "");
	            rm.withAllowAny();
	            result.withRange(rm);
	        }
	        else {
	            var tpv = typeExpression.getType(e, typeName, {}, true);
	            if (tpv) {
	                tpv = tpv.toRuntime();
	                if (tpv instanceof defs.Array) {
	                    var at = tpv;
	                    //FIXME
	                    at._af = {};
	                    //var fs=tpv.getFixedFacets();
	                    //for (var i in fs){
	                    //    at._af[i]=fs[i];
	                    //}
	                    at.findFacets(e, at._af);
	                }
	            }
	            result.withRange(tpv);
	        }
	        //FIXME
	        if (typeName == "pointer") {
	            var scope = e.attr("target");
	            if (scope) {
	                try {
	                    var sm = selector.parse(e, "" + scope.value());
	                    result.setSelector(sm);
	                }
	                catch (e) {
	                }
	            }
	        }
	    }
	    //FIXME Literals
	    if (nm == "value" && e.parent() && e.parent().definition().isAssignableFrom("AnnotationType")) {
	        result.withCanBeValue();
	    }
	    e.definition().allProperties().forEach(function (p) {
	        if (p.name() != "type") {
	            if (p.describesAnnotation()) {
	                var annotationName = p.describedAnnotation();
	                var args = [];
	                var vl = e.attributes(p.name()).map(function (a) { return a.value(); });
	                if (vl.length == 1) {
	                    args.push(vl[0]);
	                }
	                else {
	                    args.push(vl);
	                }
	                //TODO ANNOTATIONS WITH MULTIPLE ARGUMENTS
	                var an = {
	                    name: annotationName,
	                    arguments: args
	                };
	                ts2Def.recordAnnotation(result, an);
	            }
	        }
	    });
	    if (optional) {
	        result.withRequired(false);
	    }
	    var vn = _.find(e.lowLevel().children(), function (x) { return x.key() == "properties"; });
	    if (vn) {
	        var of = e.definition().universe().getType("ObjectField");
	        var node = new hlimpl.ASTNodeImpl(e.lowLevel(), e.parent(), of, result);
	        var nc = new defs.UserDefinedClass("", of.universe(), node, e.lowLevel().unit().path(), "");
	        nc._superTypes.push(of);
	        result.withRange(nc.toRuntime());
	    }
	    if (result.range() == null) {
	        result.withRange(new defs.ValueType("String", e.definition().universe(), ""));
	    }
	    if (result.range().name() == "ObjectField" && result.range() instanceof defs.NodeClass) {
	        var rm = new defs.NodeClass("ObjectField", result.range().universe(), "", "");
	        rm.withAllowAny();
	        result.withRange(rm);
	    }
	    return result;
	}
	exports.elementToProp = elementToProp;
	//# sourceMappingURL=typeBuilder.js.map

/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../../typings/tsd.d.ts" />
	var defs = __webpack_require__(21);
	var hl = __webpack_require__(17);
	var _ = __webpack_require__(47);
	var typeExpression = __webpack_require__(31);
	var ramlSignature = __webpack_require__(16);
	var hlimpl = __webpack_require__(7);
	var typeBuilder = __webpack_require__(34);
	//FIXME CORRECTLY STRUCTURE IT
	function resolveRamlPointer(point, path) {
	    var components = path.split(".");
	    var currentNode = point;
	    if (currentNode.definition().isAnnotation()) {
	        currentNode = currentNode.parent();
	    }
	    components.forEach(function (x) {
	        if (currentNode == null) {
	            return;
	        }
	        if (x == '$parent') {
	            currentNode = currentNode.parent();
	            return;
	        }
	        if (x == '$root') {
	            currentNode = currentNode.root();
	            return;
	        }
	        if (x == '$top') {
	            currentNode = exports.declRoot(currentNode);
	            return;
	        }
	        var newEl = _.find(currentNode.elements(), function (y) { return y.name() == x; });
	        currentNode = newEl;
	    });
	    return currentNode;
	}
	exports.resolveRamlPointer = resolveRamlPointer;
	exports.declRoot = function (h) {
	    var declRoot = h;
	    while (true) {
	        if (declRoot.definition().name() == "Library" && (!declRoot.definition().isUserDefined())) {
	            break;
	        }
	        var np = declRoot.parent();
	        if (!np) {
	            break;
	        }
	        declRoot = np;
	    }
	    return declRoot;
	};
	function globalDeclarations(h) {
	    var decl = exports.declRoot(h);
	    return findDeclarations(decl);
	}
	exports.globalDeclarations = globalDeclarations;
	function mark(h, rs) {
	    var n = h.lowLevel();
	    n = n._node ? n._node : n;
	    if (n['mark']) {
	        return rs;
	    }
	    n['mark'] = rs;
	    return null;
	}
	function unmark(h) {
	    var n = h.lowLevel();
	    n = n._node ? n._node : n;
	    delete n['mark'];
	}
	function findDeclarations(h) {
	    var rs = [];
	    var q = mark(h, rs);
	    if (q) {
	    }
	    try {
	        h.elements().forEach(function (x) {
	            if (x.definition().name() == "Library") {
	                rs = rs.concat(findDeclarations(x));
	            }
	            rs.push(x);
	        });
	        return rs;
	    }
	    finally {
	        unmark(h);
	    }
	}
	exports.findDeclarations = findDeclarations;
	function getIndent2(offset, text) {
	    var spaces = "";
	    for (var i = offset - 1; i >= 0; i--) {
	        var c = text.charAt(i);
	        if (c == ' ' || c == '\t') {
	            if (spaces) {
	                spaces += c;
	            }
	            else {
	                spaces = c;
	            }
	        }
	        else if (c == '\r' || c == '\n') {
	            return spaces;
	        }
	    }
	}
	function deepFindNode(n, offset, end, goToOtherUnits) {
	    if (goToOtherUnits === void 0) { goToOtherUnits = true; }
	    if (n == null) {
	        return null;
	    }
	    if (n.lowLevel()) {
	        //var node:ASTNode=<ASTNode>n;
	        if (n.lowLevel().start() <= offset && n.lowLevel().end() >= end) {
	            if (n instanceof hlimpl.ASTNodeImpl) {
	                var hn = n;
	                var all = goToOtherUnits ? hn.children() : hn.directChildren();
	                for (var i = 0; i < all.length; i++) {
	                    if (!goToOtherUnits && all[i].lowLevel().unit() != n.lowLevel().unit()) {
	                        continue;
	                    }
	                    var node = deepFindNode(all[i], offset, end, goToOtherUnits);
	                    if (node) {
	                        return node;
	                    }
	                }
	                return n;
	            }
	            if (n instanceof hlimpl.ASTPropImpl) {
	                var attr = n;
	                if (!attr.property().isKey()) {
	                    var vl = attr.value();
	                    if (vl instanceof hlimpl.StructuredValue) {
	                        var st = vl;
	                        var hl = st.toHighlevel();
	                        if (hl) {
	                            if (!goToOtherUnits && hl.lowLevel().unit() != n.lowLevel().unit()) {
	                                return null;
	                            }
	                        }
	                        var node = deepFindNode(hl, offset, end, goToOtherUnits);
	                        if (node) {
	                            return node;
	                        }
	                    }
	                    return attr;
	                }
	                return null;
	            }
	            return n;
	        }
	    }
	    return null;
	}
	function getValueAt(text, offset) {
	    var sp = -1;
	    for (var i = offset - 1; i >= 0; i--) {
	        var c = text.charAt(i);
	        if (c == '\r' || c == '\n' || c == ' ' || c == '\t' || c == '"' || c == '\'' || c == ':') {
	            sp = i + 1;
	            break;
	        }
	    }
	    var ep = -1;
	    for (var i = offset; i < text.length; i++) {
	        var c = text.charAt(i);
	        if (c == '\r' || c == '\n' || c == ' ' || c == '\t' || c == '"' || c == '\'' || c == ':') {
	            ep = i;
	            break;
	        }
	    }
	    if (sp != -1 && ep != -1) {
	        return text.substring(sp, ep);
	    }
	    return "";
	}
	function extractName(cleaned, offset) {
	    var txt = "";
	    for (var i = offset; i >= 0; i--) {
	        var c = cleaned[i];
	        if (c == ' ' || c == '\r' || c == '\n' || c == '|' || c == '[' || c == ']' || c == ':' || c == '(' || c == ')') {
	            break;
	        }
	        txt = c + txt;
	    }
	    for (var i = offset + 1; i < cleaned.length; i++) {
	        var c = cleaned[i];
	        if (c == ' ' || c == '\r' || c == '\n' || c == '|' || c == '[' || c == ']' || c == ':' || c == '(' || c == ')') {
	            break;
	        }
	        txt = txt + c;
	    }
	    return txt;
	}
	exports.extractName = extractName;
	var searchInTheValue = function (offset, content, attr, hlnode, p) {
	    if (p === void 0) { p = attr.property(); }
	    var targets = p.referenceTargets(hlnode);
	    var txt = extractName(content, offset);
	    var t = _.find(targets, function (x) { return hlimpl.qName(x, hlnode) == txt; });
	    if (t) {
	        //TODO EXTRACT COMMON OPEN NODE FUNC
	        return t;
	    }
	    if (attr.property() instanceof defs.UserDefinedProp) {
	        var up = attr.property();
	        return up._node;
	    }
	    return null;
	};
	function findUsages(unit, offset) {
	    var decl = findDeclaration(unit, offset);
	    if (decl) {
	        if (decl instanceof hlimpl.ASTNodeImpl) {
	            var hnode = decl;
	            return { node: hnode, results: hnode.findReferences() };
	        }
	        if (decl instanceof hlimpl.ASTPropImpl) {
	        }
	    }
	    var node = deepFindNode(hl.fromUnit(unit), offset, offset, false);
	    if (node instanceof hlimpl.ASTNodeImpl) {
	        return { node: node, results: node.findReferences() };
	    }
	    if (node instanceof hlimpl.ASTPropImpl) {
	        var prop = node;
	        if (prop.property().canBeValue()) {
	            return { node: prop.parent(), results: prop.parent().findReferences() };
	        }
	    }
	    return { node: null, results: [] };
	}
	exports.findUsages = findUsages;
	function findDeclaration(unit, offset) {
	    var node = deepFindNode(hl.fromUnit(unit), offset, offset, false);
	    var kind = determineCompletionKind(unit.contents(), offset);
	    if (kind == 0 /* VALUE_COMPLETION */) {
	        var hlnode = node;
	        if (node instanceof hlimpl.ASTPropImpl) {
	            var attr = node;
	            if (attr) {
	                if (attr.value()) {
	                    if (attr.value() instanceof hlimpl.StructuredValue) {
	                        var sval = attr.value();
	                        var hlvalue = sval.toHighlevel();
	                        if (hlvalue) {
	                            var newAttr = _.find(hlvalue.attrs(), function (x) { return x.lowLevel().start() < offset && x.lowLevel().end() >= offset; });
	                            if (newAttr) {
	                                return searchInTheValue(offset, unit.contents(), newAttr, hlvalue, attr.property());
	                            }
	                        }
	                    }
	                    else {
	                        return searchInTheValue(offset, unit.contents(), attr, hlnode);
	                    }
	                }
	            }
	        }
	    }
	    if (kind == 1 /* KEY_COMPLETION */ || kind == 6 /* SEQUENCE_KEY_COPLETION */) {
	        var hlnode = node;
	        var pp = node.property();
	        if (pp instanceof defs.UserDefinedProp) {
	            var up = pp;
	            return up.node();
	        }
	        if (node instanceof hlimpl.ASTNodeImpl) {
	            if (hlnode.definition() instanceof defs.UserDefinedClass) {
	                var uc = hlnode.definition();
	                if (uc.isAssignableFrom("DataElement")) {
	                    return node;
	                }
	                return uc.getDeclaringNode();
	            }
	        }
	        if (node instanceof hlimpl.ASTPropImpl) {
	            var pr = node;
	            if (isExampleNodeContent(pr)) {
	                var contentType = findExampleContentType(pr);
	                if (contentType) {
	                    var documentationRoot = parseDocumentationContent(pr, contentType.toRuntime());
	                    if (documentationRoot) {
	                        var node = deepFindNode(documentationRoot, offset, offset);
	                        var pp = node.property();
	                        if (pp instanceof defs.UserDefinedProp) {
	                            var up = pp;
	                            return up.node();
	                        }
	                        if (node instanceof hlimpl.ASTNodeImpl) {
	                            if (hlnode.definition() instanceof defs.UserDefinedClass) {
	                                var uc = hlnode.definition();
	                                return uc.getDeclaringNode();
	                            }
	                        }
	                    }
	                }
	            }
	        }
	    }
	    if (kind == 2 /* PATH_COMPLETION */) {
	        var inclpath = getValueAt(unit.contents(), offset);
	        if (inclpath) {
	            var ap = unit.resolve(inclpath);
	            return ap;
	        }
	    }
	}
	exports.findDeclaration = findDeclaration;
	function findExampleContentType(node) {
	    var p = node.parent();
	    if (node.property().name() == "content") {
	        p = p.parent();
	    }
	    return hlimpl.typeFromNode(p);
	}
	exports.findExampleContentType = findExampleContentType;
	function parseDocumentationContent(attribute, type) {
	    if (!(attribute.value() instanceof hlimpl.StructuredValue)) {
	        return null;
	    }
	    return new hlimpl.ASTNodeImpl(attribute.value().lowLevel(), attribute.parent(), type, attribute.property());
	}
	exports.parseDocumentationContent = parseDocumentationContent;
	function isExampleNodeContent(node) {
	    if (!(node instanceof hlimpl.ASTPropImpl)) {
	        return false;
	    }
	    var property = node;
	    if ("content" == property.name() && "StringType" == property.definition().name()) {
	        if (property.parent() instanceof hlimpl.ASTNodeImpl && ("examples" == property.parent().property().name() || "example" == property.parent().property().name())) {
	            if (property.parent().parent() instanceof hlimpl.ASTNodeImpl && property.parent().parent().definition().isAssignableFrom("ObjectField")) {
	                return true;
	            }
	        }
	    }
	    else if ("example" == property.name() && "StringType" == property.definition().name()) {
	        if (property.parent() instanceof hlimpl.ASTNodeImpl && property.parent().definition().isAssignableFrom("ObjectField")) {
	            return true;
	        }
	    }
	    return false;
	}
	exports.isExampleNodeContent = isExampleNodeContent;
	function determineCompletionKind(text, offset) {
	    var hasIn = false;
	    var hasSeq = false;
	    var canBeInComment = false;
	    var canBeAnnotation = false;
	    for (var i = offset - 1; i >= 0; i--) {
	        var c = text.charAt(i);
	        if (c == '(') {
	            canBeAnnotation = true;
	        }
	        else if (canBeAnnotation) {
	            if (c == '\r' || c == '\n') {
	                var hasClosing = false;
	                for (var j = offset - 1; j < text.length; j++) {
	                    var ch = text[j];
	                    if (ch == ')') {
	                        hasClosing = true;
	                    }
	                    if (ch == '\r' || ch == "\n") {
	                        break;
	                    }
	                    if (ch == ':') {
	                        canBeAnnotation = false;
	                        break;
	                    }
	                }
	                if (canBeAnnotation && hasClosing) {
	                    return 5 /* ANNOTATION_COMPLETION */;
	                }
	                else {
	                    break;
	                }
	            }
	            if (c == ' ' || c == '\t') {
	                continue;
	            }
	            else {
	                break;
	            }
	        }
	        else {
	            if (c == '\r' || c == '\n') {
	                break;
	            }
	            if (c == ':') {
	                break;
	            }
	        }
	    }
	    for (var i = offset - 1; i >= 0; i--) {
	        var c = text.charAt(i);
	        if (c == '#') {
	            if (i == 0) {
	                return 4 /* VERSION_COMPLETION */;
	            }
	            return 7 /* INCOMMENT */;
	        }
	        if (c == ':') {
	            if (hasIn) {
	                return 3 /* DIRECTIVE_COMPLETION */;
	            }
	            return 0 /* VALUE_COMPLETION */;
	        }
	        if (c == '\r' || c == '\n') {
	            //check for multiline literal
	            var insideOfMultiline = false;
	            var ind = getIndent2(offset, text);
	            for (var a = i; a > 0; a--) {
	                c = text.charAt(a);
	                //TODO this can be further improved
	                if (c == ':') {
	                    if (insideOfMultiline) {
	                        var ll = getIndent2(a, text);
	                        if (ll.length < ind.length) {
	                            return 0 /* VALUE_COMPLETION */;
	                        }
	                    }
	                    break;
	                }
	                if (c == '|') {
	                    insideOfMultiline = true;
	                    continue;
	                }
	                if (c == '\r' || c == '\n') {
	                    insideOfMultiline = false;
	                }
	                if (c != ' ' && c != '\t') {
	                    insideOfMultiline = false;
	                }
	            }
	            if (hasSeq) {
	                return 6 /* SEQUENCE_KEY_COPLETION */;
	            }
	            return 1 /* KEY_COMPLETION */;
	        }
	        if (c == '-') {
	            hasSeq = true;
	        }
	        if (c == '!') {
	            if (text.indexOf("!include", i) == i) {
	                return 2 /* PATH_COMPLETION */;
	            }
	            if (text.indexOf("!i", i) == i) {
	                hasIn = true;
	            }
	        }
	    }
	}
	exports.determineCompletionKind = determineCompletionKind;
	(function (LocationKind) {
	    LocationKind[LocationKind["VALUE_COMPLETION"] = 0] = "VALUE_COMPLETION";
	    LocationKind[LocationKind["KEY_COMPLETION"] = 1] = "KEY_COMPLETION";
	    LocationKind[LocationKind["PATH_COMPLETION"] = 2] = "PATH_COMPLETION";
	    LocationKind[LocationKind["DIRECTIVE_COMPLETION"] = 3] = "DIRECTIVE_COMPLETION";
	    LocationKind[LocationKind["VERSION_COMPLETION"] = 4] = "VERSION_COMPLETION";
	    LocationKind[LocationKind["ANNOTATION_COMPLETION"] = 5] = "ANNOTATION_COMPLETION";
	    LocationKind[LocationKind["SEQUENCE_KEY_COPLETION"] = 6] = "SEQUENCE_KEY_COPLETION";
	    LocationKind[LocationKind["INCOMMENT"] = 7] = "INCOMMENT";
	})(exports.LocationKind || (exports.LocationKind = {}));
	var LocationKind = exports.LocationKind;
	function resolveReference(point, path) {
	    if (!path) {
	        return null;
	    }
	    var sp = path.split("/");
	    var result = point;
	    for (var i = 0; i < sp.length; i++) {
	        if (sp[i] == '#') {
	            result = point.unit().ast();
	            continue;
	        }
	        result = _.find(result.children(), function (x) { return x.key() == sp[i]; });
	        if (!result) {
	            return null;
	        }
	    }
	    return result;
	}
	exports.resolveReference = resolveReference;
	/**
	 * return all sub types of given type visible from parent node
	 * @param range
	 * @param parentNode
	 * @returns ITypeDefinition[]
	 */
	exports.subTypesWithLocals = function (range, parentNode) {
	    if (range == null) {
	        return [];
	    }
	    var name = range.name();
	    parentNode = exports.declRoot(parentNode);
	    var actual = parentNode;
	    if (actual._subTypesCache) {
	        var cached = actual._subTypesCache[name];
	        if (cached) {
	            return cached;
	        }
	    }
	    else {
	        actual._subTypesCache = {};
	    }
	    var result = range.allSubTypes();
	    if (range.getRuntimeExtenders().length > 0 && parentNode) {
	        var decls = globalDeclarations(parentNode);
	        var extenders = range.getRuntimeExtenders();
	        var root = parentNode.root();
	        extenders.forEach(function (x) {
	            var definitionNodes = decls.filter(function (z) {
	                var def = z.definition().allSuperTypes();
	                def.push(z.definition());
	                var rr = (z.definition() == x) || (_.find(def, function (d) { return d == x; }) != null) || (_.find(def, function (d) { return d == range; }) != null);
	                return rr;
	            });
	            result = result.concat(definitionNodes.map(function (x) { return typeBuilder.typeFromNode(x); }));
	        });
	    }
	    result = _.unique(result);
	    actual._subTypesCache[name] = result;
	    return result;
	};
	exports.subTypesWithName = function (tname, parentNode, backup) {
	    parentNode = exports.declRoot(parentNode);
	    var decls = globalDeclarations(parentNode);
	    var declNode = _.find(decls, function (x) { return hlimpl.qName(x, parentNode) == tname && x.property() && (x.property().name() == 'types'); });
	    var result = typeBuilder.typeFromNode(declNode);
	    return result;
	};
	exports.schemasWithName = function (tname, parentNode, backup) {
	    parentNode = exports.declRoot(parentNode);
	    var decls = globalDeclarations(parentNode);
	    var declNode = _.find(decls, function (x) { return hlimpl.qName(x, parentNode) == tname && x.property() && (x.property().name() == 'schemas'); });
	    var result = typeBuilder.typeFromNode(declNode);
	    return result;
	};
	exports.nodesDeclaringType = function (range, n) {
	    var result = [];
	    if (range.getRuntimeExtenders().length > 0 && n) {
	        var extenders = range.getRuntimeExtenders();
	        var root = n;
	        extenders.forEach(function (x) {
	            var definitionNodes = globalDeclarations(root).filter(function (z) { return z.definition() == x; });
	            result = result.concat(definitionNodes);
	        });
	    }
	    var isElementType = !range.isValueType();
	    if (isElementType && range.isInlinedTemplates() && n) {
	        var root = n;
	        //TODO I did not like it it might be written much better
	        var definitionNodes = globalDeclarations(root).filter(function (z) { return z.definition() == range; });
	        result = result.concat(definitionNodes);
	    }
	    else {
	        var root = n;
	        var q = {};
	        range.allSubTypes().forEach(function (x) { return q[x.name()] = true; });
	        q[range.name()] = true;
	        var definitionNodes = globalDeclarations(root).filter(function (z) { return q[z.definition().name()]; });
	        result = result.concat(definitionNodes);
	    }
	    return result;
	};
	function findAllSubTypes(p, n) {
	    var range = p.range();
	    return exports.subTypesWithLocals(range, n);
	}
	exports.findAllSubTypes = findAllSubTypes;
	;
	function possibleNodes(p, c) {
	    if (c) {
	        if (p.isDescriminating()) {
	            var range = p.range();
	            if (range.getRuntimeExtenders().length > 0 && c) {
	                var extenders = range.getRuntimeExtenders();
	                var result = [];
	                extenders.forEach(function (x) {
	                    var definitionNodes = globalDeclarations(c).filter(function (z) { return z.definition() == x; });
	                    result = result.concat(definitionNodes);
	                });
	                return result;
	            }
	            return [];
	        }
	        if (p.isReference()) {
	            return exports.nodesDeclaringType(p.referencesTo(), c);
	        }
	        if (p.range().isValueType()) {
	            var vt = p.range();
	            if (vt.globallyDeclaredBy && vt.globallyDeclaredBy().length > 0) {
	                var definitionNodes = globalDeclarations(c).filter(function (z) { return _.find(vt.globallyDeclaredBy(), function (x) { return x == z.definition(); }) != null; });
	                return definitionNodes;
	            }
	        }
	    }
	    return this._enumOptions;
	}
	function allChildren(node) {
	    var res = [];
	    gather(node, res);
	    return res;
	}
	exports.allChildren = allChildren;
	function gather(node, result) {
	    node.children().forEach(function (x) {
	        result.push(x);
	        gather(x, result);
	    });
	}
	var testUsage = function (ck, x, node, result) {
	    if (ck instanceof defs.UserDefinedClass) {
	        var ud = ck;
	        if (ud.getDeclaringNode() == node) {
	            result.push(x);
	        }
	    }
	    if (ck instanceof defs.Array) {
	        var cmp = ck;
	        testUsage(cmp.component, x, node, result);
	    }
	    if (ck instanceof defs.Union) {
	        var uni = ck;
	        testUsage(uni.left, x, node, result);
	        testUsage(uni.right, x, node, result);
	    }
	};
	function refFinder(root, node, result) {
	    root.elements().forEach(function (x) {
	        refFinder(x, node, result);
	        //console.log(x.name())
	        var ck = x.definition();
	        //testUsage(ck, x, node, result);
	    });
	    root.attrs().forEach(function (a) {
	        var pr = a.property();
	        var vl = a.value();
	        //if (pr.isTypeExpr()){
	        //    typeExpression.
	        //}
	        if (pr instanceof defs.UserDefinedProp) {
	            var up = pr.node();
	            if (up == node) {
	                result.push(a);
	            }
	            else if (up.lowLevel().start() == node.lowLevel().start()) {
	                if (up.lowLevel().unit() == node.lowLevel().unit()) {
	                    result.push(a);
	                }
	            }
	        }
	        if (isExampleNodeContent(a)) {
	            var contentType = findExampleContentType(a);
	            if (contentType) {
	                var documentationRoot = parseDocumentationContent(a, contentType.toRuntime());
	                if (documentationRoot) {
	                    refFinder(documentationRoot, node, result);
	                }
	            }
	        }
	        else if (pr.isTypeExpr() && typeof vl == "string") {
	            if (pr.name() == "signature") {
	                var sig = ramlSignature.parse(a);
	                if (sig) {
	                    if (sig.args) {
	                        sig.args.forEach(function (x) {
	                            var tp = typeExpression.deriveType(root, x.type);
	                            if (tp) {
	                                testUsage(tp, a, node, result);
	                            }
	                        });
	                    }
	                    if (sig.returnType) {
	                        var tp = typeExpression.deriveType(root, sig.returnType);
	                        if (tp) {
	                            testUsage(tp, a, node, result);
	                        }
	                    }
	                }
	            }
	            else {
	                var tpa = typeExpression.getType(root, "" + vl, {});
	                testUsage(tpa, a, node, result);
	                var libraryName = hl.getLibraryName(node);
	                if (libraryName && vl.indexOf(libraryName) != -1) {
	                    var referencingLibrary = getLibraryDefiningNode(a);
	                    if (referencingLibrary && referencingLibrary.lowLevel().start() == node.lowLevel().start()) {
	                        result.push(a);
	                    }
	                }
	            }
	        }
	        if (pr.isReference() || pr.isDescriminator()) {
	            if (typeof vl == 'string') {
	                var pn = possibleNodes(pr, root);
	                if (_.find(pn, function (x) { return x.name() == vl && x == node; })) {
	                    result.push(a);
	                }
	                var libraryName = hl.getLibraryName(node);
	                if (libraryName && vl.indexOf(libraryName) != -1) {
	                    var referencingLibrary = getLibraryDefiningNode(a);
	                    if (referencingLibrary && referencingLibrary.lowLevel().start() == node.lowLevel().start()) {
	                        result.push(a);
	                    }
	                }
	            }
	            else {
	                var st = vl;
	                if (st) {
	                    var vn = st.valueName();
	                    var pn = possibleNodes(pr, root);
	                    if (_.find(pn, function (x) { return x.name() == vn && x == node; })) {
	                        result.push(a);
	                    }
	                    var hnode = st.toHighlevel();
	                    if (hnode) {
	                        refFinder(hnode, node, result);
	                    }
	                    var libraryName = hl.getLibraryName(node);
	                    if (libraryName && vn.indexOf(libraryName) != -1) {
	                        var referencingLibrary = getLibraryDefiningNode(vl);
	                        if (referencingLibrary && referencingLibrary.lowLevel().start() == node.lowLevel().start()) {
	                            result.push(a);
	                        }
	                    }
	                }
	            }
	        }
	        else {
	            var pn = possibleNodes(pr, root);
	            if (_.find(pn, function (x) { return x.name() == vl && x == node; })) {
	                result.push(a);
	            }
	        }
	    });
	}
	exports.refFinder = refFinder;
	/**
	 * Returns library node that definition of the current node is located in, or null
	 * if current node is not defined in a library.
	 */
	function getLibraryDefiningNode(nodeToCheck) {
	    if (!nodeToCheck.lowLevel) {
	        return null;
	    }
	    var lowLevelNode = nodeToCheck.lowLevel();
	    if (!lowLevelNode) {
	        return null;
	    }
	    if (lowLevelNode.key()) {
	        var offset = Math.floor((lowLevelNode.keyEnd() + lowLevelNode.keyStart()) / 2);
	        var result = getLibraryDefiningNodeByOffset(lowLevelNode.unit(), offset);
	        if (result)
	            return result;
	    }
	    if (lowLevelNode.value()) {
	        var offset = Math.floor((lowLevelNode.valueEnd() + lowLevelNode.valueStart()) / 2);
	        var result = getLibraryDefiningNodeByOffset(lowLevelNode.unit(), offset);
	        if (result)
	            return result;
	    }
	    return null;
	}
	function getLibraryDefiningNodeByOffset(unit, offset) {
	    var declaration = findDeclaration(unit, offset);
	    if (declaration && hl.asNode(declaration)) {
	        var declarationNode = hl.asNode(declaration);
	        var parent = declarationNode;
	        while (parent) {
	            if (parent.definition().name() == "Library") {
	                return parent;
	            }
	            parent = parent.parent();
	        }
	    }
	    return null;
	}
	//# sourceMappingURL=search.js.map

/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

	var factory10 = __webpack_require__(68);
	var factory08 = __webpack_require__(69);
	function buildWrapperNode(node) {
	    var ramlVersion = node.definition().universe().version();
	    if (ramlVersion == 'RAML10') {
	        return factory10.buildWrapperNode(node);
	    }
	    else if (ramlVersion == 'RAML08') {
	        return factory08.buildWrapperNode(node);
	    }
	    return null;
	}
	exports.buildWrapperNode = buildWrapperNode;
	//# sourceMappingURL=modelFactory.js.map

/***/ },
/* 37 */
/***/ function(module, exports, __webpack_require__) {

	/// <reference path="../../../typings/tsd.d.ts" />
	var hl = __webpack_require__(17);
	var _ = __webpack_require__(47);
	var linter = __webpack_require__(33);
	var wrapperHelper = __webpack_require__(15);
	function escapeUri(u) {
	    var ss = "";
	    var level = 0;
	    for (var i = 0; i < u.length; i++) {
	        var c = u.charAt(i);
	        if (level == 0) {
	            ss = ss + c;
	        }
	        if (c == '{') {
	            level++;
	        }
	        if (c == '}') {
	            level--;
	        }
	    }
	    return ss;
	}
	var OverloadingValidator = (function () {
	    function OverloadingValidator() {
	        this.holder = {};
	        this.conflicting = {};
	    }
	    OverloadingValidator.prototype.validateApi = function (q, v) {
	        var _this = this;
	        q.resources().forEach(function (x) {
	            _this.acceptResource(x);
	            x.resources().forEach(function (y) { return _this.acceptResource(y); });
	        });
	        for (var c in this.conflicting) {
	            var ms = this.conflicting[c];
	            //now we should layout parameters by items
	            var overmapQuery = {};
	            var overmapHeaders = {};
	            var pushed = [];
	            ms.forEach(function (m) {
	                m.queryParameters().forEach(function (q) {
	                    var key = q.name();
	                    if (!q.required()) {
	                        return;
	                    }
	                    var set = overmapQuery[key];
	                    if (!set) {
	                        set = [];
	                        overmapQuery[key] = set;
	                    }
	                    set.push(m);
	                    pushed.push(m);
	                });
	                m.headers().forEach(function (q) {
	                    var key = q.name();
	                    if (!q.required()) {
	                        return;
	                    }
	                    var set = overmapHeaders[key];
	                    if (!set) {
	                        set = [];
	                        overmapHeaders[key] = set;
	                    }
	                    set.push(m);
	                    pushed.push(m);
	                });
	            });
	            var notPushed = ms.filter(function (x) { return !_.find(pushed, function (y) { return y == x; }); });
	            if (notPushed.length > 0) {
	                notPushed.forEach(function (m) {
	                    v.accept(linter.createIssue(5 /* KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT */, "method overloading is ambiguous", m.highLevel(), true));
	                });
	            }
	            for (var key in overmapQuery) {
	                var cm = overmapQuery[key];
	                if (cm.length > 1) {
	                    var over = {};
	                    var pushed2 = [];
	                    cm.forEach(function (m) {
	                        var pr = _.find(m.queryParameters(), function (x) { return x.name() == key; });
	                        if (pr['enum']) {
	                            var ev = pr['enum']();
	                            if (ev && ev.length > 0) {
	                                ev.forEach(function (value) {
	                                    var t = over[value];
	                                    if (!t) {
	                                        t = [];
	                                        over[value] = t;
	                                    }
	                                    t.push(m);
	                                    pushed2.push(m);
	                                });
	                            }
	                        }
	                    });
	                    var notPushed2 = cm.filter(function (x) { return !_.find(pushed2, function (y) { return y == x; }); });
	                    if (notPushed2.length > 0) {
	                        notPushed2.forEach(function (m) {
	                            v.accept(linter.createIssue(5 /* KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT */, "method overloading is ambiguous no domain restrictions", m.highLevel(), true));
	                        });
	                    }
	                    for (var k in over) {
	                        var rs = over[k];
	                        if (rs.length > 1) {
	                            rs.forEach(function (m) { return v.accept(linter.createIssue(5 /* KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT */, "method overloading is ambiguous ( enum value " + k + ")", m.highLevel(), true)); });
	                        }
	                    }
	                }
	            }
	        }
	    };
	    OverloadingValidator.prototype.acceptResource = function (x) {
	        var _this = this;
	        x.methods().forEach(function (m) {
	            _this.acceptMethod(x, m);
	        });
	    };
	    OverloadingValidator.prototype.acceptMethod = function (x, m) {
	        var uri = escapeUri(wrapperHelper.absoluteUri(x)) + m.method();
	        var pos = this.holder[uri];
	        if (!pos) {
	            pos = [];
	            this.holder[uri] = pos;
	        }
	        pos.push(m);
	        if (pos.length > 1) {
	            this.conflicting[uri] = pos;
	        }
	        //wrapperHelper.absoluteUri(m.parent().)
	    };
	    return OverloadingValidator;
	})();
	exports.OverloadingValidator = OverloadingValidator;
	//# sourceMappingURL=overloadingValidator.js.map

/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Created by kor on 08/05/15.
	 */
	/// <reference path="../../typings/tsd.d.ts" />
	var ts = __webpack_require__(42);
	var tsm = __webpack_require__(71);
	var pth = __webpack_require__(11);
	var fs = __webpack_require__(12);
	function parse(content) {
	    return ts.createSourceFile("sample.ts", content, 0 /* ES3 */, "1.4.1", true);
	}
	var fld = tsm.Matching.field();
	var clazzMatcher = tsm.Matching.classDeclaration();
	var EnumDeclaration = (function () {
	    function EnumDeclaration() {
	    }
	    return EnumDeclaration;
	})();
	exports.EnumDeclaration = EnumDeclaration;
	(function (TypeKind) {
	    TypeKind[TypeKind["BASIC"] = 0] = "BASIC";
	    TypeKind[TypeKind["ARRAY"] = 1] = "ARRAY";
	    TypeKind[TypeKind["UNION"] = 2] = "UNION";
	})(exports.TypeKind || (exports.TypeKind = {}));
	var TypeKind = exports.TypeKind;
	function classDecl(name, isInteface) {
	    return {
	        name: name,
	        methods: [],
	        typeParameters: [],
	        typeParameterConstraint: [],
	        implements: [],
	        fields: [],
	        isInterface: isInteface,
	        annotations: [],
	        extends: [],
	        moduleName: null,
	        annotationOverridings: {}
	    };
	}
	exports.classDecl = classDecl;
	function parseStruct(content, modules, mpth) {
	    var mod = parse(content);
	    var module = { classes: [], aliases: [], enumDeclarations: [], imports: {}, name: mpth };
	    modules[mpth] = module;
	    var currentModule = null;
	    tsm.Matching.visit(mod, function (x) {
	        if (x.kind == 189 /* ModuleDeclaration */) {
	            var cmod = x;
	            currentModule = cmod.name.text;
	        }
	        if (x.kind == 191 /* ImportDeclaration */) {
	            var imp = x;
	            var namespace = imp.name.text;
	            if (namespace == "RamlWrapper") {
	                return;
	            }
	            if (imp.moduleReference.kind != 193 /* ExternalModuleReference */) {
	                throw new Error("Only external module references are supported now");
	            }
	            var path = imp.moduleReference;
	            if (path.expression.kind != 7 /* StringLiteral */) {
	                throw new Error("Only string literals are supported in module references ");
	            }
	            var literal = path.expression;
	            var importPath = literal.text;
	            var absPath = pth.resolve(pth.dirname(mpth) + "/", importPath) + ".ts";
	            if (!fs.existsSync(absPath)) {
	                throw new Error("Path " + importPath + " resolve to " + absPath + "do not exists");
	            }
	            if (!modules[absPath]) {
	                var cnt = fs.readFileSync(absPath).toString();
	                var mod = parseStruct(cnt, modules, absPath);
	            }
	            module.imports[namespace] = modules[absPath];
	        }
	        if (x.kind == 187 /* TypeAliasDeclaration */) {
	            var u = x;
	            var aliasName = u.name.text;
	            var type = buildType(u.type, mpth);
	            module.aliases.push({ name: aliasName, type: type });
	        }
	        if (x.kind == 188 /* EnumDeclaration */) {
	            var e = x;
	            var members = [];
	            e.members.forEach(function (y) {
	                members.push(y['name']['text']);
	            });
	            module.enumDeclarations.push({ name: e.name.text, members: members });
	        }
	        var isInterface = x.kind == 186 /* InterfaceDeclaration */;
	        var isClass = x.kind == 185 /* ClassDeclaration */;
	        if (!isInterface && !isClass) {
	            return;
	        }
	        var c = x;
	        if (c) {
	            var fields = {};
	            var clazz = classDecl(c.name.text, isInterface);
	            clazz.moduleName = currentModule;
	            module.classes.push(clazz);
	            c.members.forEach(function (x) {
	                if (x.kind == 125 /* Method */) {
	                    var md = x;
	                    var aliasName = md.name.text;
	                    var text = content.substring(md.pos, md.end);
	                    clazz.methods.push({ name: aliasName, start: md.pos, end: md.end, text: text });
	                }
	                var field = fld.doMatch(x);
	                if (field) {
	                    var f = buildField(field, mpth);
	                    if (f.name == '$') {
	                        clazz.annotations = f.annotations;
	                    }
	                    else if (f.name.charAt(0) != '$' || f.name == '$ref') {
	                        fields[f.name] = f;
	                        clazz.fields.push(f);
	                    }
	                    else {
	                        var targetField = f.name.substr(1);
	                        var of = fields[targetField];
	                        if (!of) {
	                            if (f.name != '$$') {
	                                //console.log('Overriding annotations for field:'+targetField);
	                                var overridings = clazz.annotationOverridings[targetField];
	                                if (!overridings) {
	                                    overridings = [];
	                                }
	                                clazz.annotationOverridings[targetField] = overridings.concat(f.annotations);
	                            }
	                        }
	                        else {
	                            of.annotations = f.annotations;
	                        }
	                    }
	                }
	            });
	            if (c.typeParameters) {
	                c.typeParameters.forEach(function (x) {
	                    clazz.typeParameters.push(x.name['text']);
	                    if (x.constraint == null) {
	                        clazz.typeParameterConstraint.push(null);
	                    }
	                    else {
	                        clazz.typeParameterConstraint.push(x.constraint['typeName']['text']);
	                    }
	                });
	            }
	            if (c.heritageClauses) {
	                c.heritageClauses.forEach(function (x) {
	                    x.types.forEach(function (y) {
	                        if (x.token == 77 /* ExtendsKeyword */) {
	                            clazz.extends.push(buildType(y, mpth));
	                        }
	                        else if (x.token == 100 /* ImplementsKeyword */) {
	                            clazz.implements.push(buildType(y, mpth));
	                        }
	                        else {
	                            throw new Error("Unknown token class heritage");
	                        }
	                    });
	                });
	            }
	            return tsm.Matching.SKIP;
	        }
	    });
	    return module;
	}
	exports.parseStruct = parseStruct;
	function buildField(f, path) {
	    return {
	        name: f.name['text'],
	        type: buildType(f.type, path),
	        annotations: f.name['text'].charAt(0) == '$' ? buildInitializer(f.initializer) : [],
	        valueConstraint: f.name['text'].charAt(0) != '$' ? buildConstraint(f.initializer) : null,
	        optional: f.questionToken != null
	    };
	}
	function buildConstraint(e) {
	    if (e == null) {
	        return null;
	    }
	    if (e.kind == 145 /* CallExpression */) {
	        return {
	            isCallConstraint: true,
	            value: buildAnnotation(e)
	        };
	    }
	    else {
	        return {
	            isCallConstraint: false,
	            value: parseArg(e)
	        };
	    }
	}
	function buildInitializer(i) {
	    if (i == null) {
	        return [];
	    }
	    if (i.kind == 141 /* ArrayLiteralExpression */) {
	        var arr = i;
	        var annotations = [];
	        arr.elements.forEach(function (x) {
	            annotations.push(buildAnnotation(x));
	        });
	        return annotations;
	    }
	    else {
	        throw new Error("Only Array Literals supported now");
	    }
	}
	function buildAnnotation(e) {
	    if (e.kind == 145 /* CallExpression */) {
	        var call = e;
	        var name = parseName(call.expression);
	        var a = {
	            name: name,
	            arguments: []
	        };
	        call.arguments.forEach(function (x) {
	            a.arguments.push(parseArg(x));
	        });
	        return a;
	    }
	    else {
	        throw new Error("Only call expressions may be annotations");
	    }
	}
	function parseArg(n) {
	    if (n.kind == 7 /* StringLiteral */) {
	        var l = n;
	        return l.text;
	    }
	    if (n.kind == 9 /* NoSubstitutionTemplateLiteral */) {
	        var ls = n;
	        return ls.text;
	    }
	    if (n.kind == 141 /* ArrayLiteralExpression */) {
	        var arr = n;
	        var annotations = [];
	        arr.elements.forEach(function (x) {
	            annotations.push(parseArg(x));
	        });
	        return annotations;
	    }
	    if (n.kind == 93 /* TrueKeyword */) {
	        return true;
	    }
	    if (n.kind == 143 /* PropertyAccessExpression */) {
	        var pa = n;
	        return parseArg(pa.expression) + "." + parseArg(pa.name);
	    }
	    if (n.kind == 63 /* Identifier */) {
	        var ident = n;
	        return ident.text;
	    }
	    if (n.kind == 78 /* FalseKeyword */) {
	        return false;
	    }
	    if (n.kind == 6 /* NumericLiteral */) {
	        var nl = n;
	        return nl.text;
	    }
	    if (n.kind == 157 /* BinaryExpression */) {
	        var bin = n;
	        if (bin.operator = 32 /* PlusToken */) {
	            return parseArg(bin.left) + parseArg(bin.right);
	        }
	    }
	    throw new Error("Unknown value in annotation");
	}
	function parseName(n) {
	    if (n.kind == 63 /* Identifier */) {
	        return n['text'];
	    }
	    if (n.kind == 143 /* PropertyAccessExpression */) {
	        var m = n;
	        return parseName(m.expression) + "." + parseName(m.name);
	    }
	    throw new Error("Only simple identifiers are supported now");
	}
	function basicType(n, path) {
	    var namespaceIndex = n.indexOf(".");
	    var namespace = namespaceIndex != -1 ? n.substring(0, namespaceIndex) : "";
	    var basicName = namespaceIndex != -1 ? n.substring(namespaceIndex + 1) : n;
	    return { typeName: n, nameSpace: namespace, basicName: basicName, typeKind: 0 /* BASIC */, typeArguments: [], modulePath: path };
	}
	function arrayType(b) {
	    return { base: b, typeKind: 1 /* ARRAY */ };
	}
	function unionType(b) {
	    return { options: b, typeKind: 2 /* UNION */ };
	}
	function buildType(t, path) {
	    if (t == null) {
	        return null;
	    }
	    if (t.kind == 118 /* StringKeyword */) {
	        return basicType("string", null);
	    }
	    if (t.kind == 116 /* NumberKeyword */) {
	        return basicType("number", null);
	    }
	    if (t.kind == 110 /* BooleanKeyword */) {
	        return basicType("boolean", null);
	    }
	    if (t.kind == 109 /* AnyKeyword */) {
	        return basicType("any", null);
	    }
	    if (t.kind == 132 /* TypeReference */) {
	        var tr = t;
	        var res = basicType(parseQualified(tr.typeName), path);
	        if (tr.typeArguments) {
	            tr.typeArguments.forEach(function (x) {
	                res.typeArguments.push(buildType(x, path));
	            });
	        }
	        return res;
	    }
	    if (t.kind == 137 /* ArrayType */) {
	        var q = t;
	        return arrayType(buildType(q.elementType, path));
	    }
	    if (t.kind == 139 /* UnionType */) {
	        var ut = t;
	        return unionType(ut.types.map(function (x) { return buildType(x, path); }));
	    }
	    throw new Error("Case not supported" + t.kind);
	}
	function parseQualified(n) {
	    if (n.kind == 63 /* Identifier */) {
	        return n['text'];
	    }
	    else {
	        var q = n;
	        return parseQualified(q.left) + "." + parseQualified(q.right);
	    }
	}
	//# sourceMappingURL=tsStructureParser.js.map

/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

	var __extends = this.__extends || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    __.prototype = b.prototype;
	    d.prototype = new __();
	};
	/// <reference path="../../typings/tsd.d.ts" />
	var tsStruct = __webpack_require__(38);
	var def = __webpack_require__(21);
	var _ = __webpack_require__(47);
	var khttp = __webpack_require__(81);
	var FieldWrapper = (function () {
	    function FieldWrapper(_field, _clazz) {
	        this._field = _field;
	        this._clazz = _clazz;
	    }
	    FieldWrapper.prototype.name = function () {
	        return this._field.name;
	    };
	    FieldWrapper.prototype.range = function () {
	        return this._clazz.getModule().typeFor(this._field.type, this._clazz);
	    };
	    FieldWrapper.prototype.isMultiValue = function () {
	        return this._field.type.typeKind == 1 /* ARRAY */;
	    };
	    FieldWrapper.prototype.isKey = function () {
	        return _.find(this._field.annotations, function (x) { return x.name == "MetaModel.key"; }) != null;
	    };
	    FieldWrapper.prototype.isSimpleValue = function () {
	        return _.find(this._field.annotations, function (x) { return x.name == "MetaModel.value"; }) != null;
	    };
	    FieldWrapper.prototype.annotations = function () {
	        return this._field.annotations;
	    };
	    return FieldWrapper;
	})();
	var FieldConstraint = (function () {
	    function FieldConstraint(_field, _clazz) {
	        this._field = _field;
	        this._clazz = _clazz;
	    }
	    FieldConstraint.prototype.name = function () {
	        return this._field.name;
	    };
	    FieldConstraint.prototype.value = function () {
	        return this._field.valueConstraint;
	    };
	    return FieldConstraint;
	})();
	var ClassWrapper = (function () {
	    function ClassWrapper(_clazz, mw) {
	        this._clazz = _clazz;
	        this.mw = mw;
	    }
	    ClassWrapper.prototype.typeMeta = function () {
	        return this._clazz.annotations;
	    };
	    ClassWrapper.prototype.path = function () {
	        return this.mw.path();
	    };
	    ClassWrapper.prototype.getModule = function () {
	        return this.mw;
	    };
	    ClassWrapper.prototype.typeArgs = function () {
	        return this._clazz.typeParameters;
	    };
	    ClassWrapper.prototype.typConstraints = function () {
	        var _this = this;
	        return this._clazz.typeParameterConstraint.map(function (x) {
	            if (x) {
	                return _this.mw.classForName(x);
	            }
	            return null;
	        });
	    };
	    ClassWrapper.prototype.methods = function () {
	        return this._clazz.methods;
	    };
	    ClassWrapper.prototype.name = function () {
	        return this._clazz.name;
	    };
	    ClassWrapper.prototype.members = function () {
	        var _this = this;
	        return this._clazz.fields.filter(function (x) { return x.valueConstraint == null; }).map(function (x) { return new FieldWrapper(x, _this); });
	    };
	    ClassWrapper.prototype.constraints = function () {
	        var _this = this;
	        return this._clazz.fields.filter(function (x) { return x.valueConstraint != null; }).map(function (x) { return new FieldConstraint(x, _this); });
	    };
	    ClassWrapper.prototype.isSubTypeOf = function (of) {
	        if (this == of) {
	            return true;
	        }
	        var _res = false;
	        this.getAllSuperTypes().forEach(function (x) {
	            if (!_res) {
	                _res = _res || x.isSubTypeOf(of);
	            }
	        });
	        return _res;
	    };
	    ClassWrapper.prototype.getExtendsClauses = function () {
	        return this._clazz.extends;
	    };
	    ClassWrapper.prototype.getSuperTypes = function () {
	        var _this = this;
	        var result = [];
	        this._clazz.extends.forEach(function (x) {
	            var tp = _this.mw.classForName(x.typeName);
	            if (tp) {
	                result.push(tp);
	            }
	        });
	        return result;
	    };
	    ClassWrapper.prototype.getAllSuperTypes = function () {
	        var _this = this;
	        var result = [];
	        this._clazz.extends.forEach(function (x) {
	            var tp = _this.mw.classForName(x.typeName);
	            if (tp) {
	                var mm = tp.getAllSuperTypes();
	                result.push(tp);
	                result.concat(mm);
	            }
	        });
	        return _.unique(result);
	    };
	    ClassWrapper.prototype.annotationOverridings = function () {
	        return this._clazz.annotationOverridings;
	    };
	    return ClassWrapper;
	})();
	var AbstractSimpleWrapper = (function () {
	    function AbstractSimpleWrapper() {
	    }
	    AbstractSimpleWrapper.prototype.members = function () {
	        return []; //this._clazz.members.map(x=>new FieldWrapper(x,this))
	    };
	    AbstractSimpleWrapper.prototype.methods = function () {
	        return [];
	    };
	    AbstractSimpleWrapper.prototype.isSubTypeOf = function (of) {
	        return false;
	    };
	    AbstractSimpleWrapper.prototype.getSuperTypes = function () {
	        return [];
	    };
	    AbstractSimpleWrapper.prototype.getAllSuperTypes = function () {
	        return [];
	    };
	    AbstractSimpleWrapper.prototype.name = function () {
	        return null;
	    };
	    AbstractSimpleWrapper.prototype.constraints = function () {
	        return [];
	    };
	    AbstractSimpleWrapper.prototype.typeMeta = function () {
	        return [];
	    };
	    AbstractSimpleWrapper.prototype.getModule = function () {
	        throw new Error("Not implemented");
	    };
	    AbstractSimpleWrapper.prototype.annotationOverridings = function () {
	        return {};
	    };
	    return AbstractSimpleWrapper;
	})();
	var EnumWrapper = (function (_super) {
	    __extends(EnumWrapper, _super);
	    function EnumWrapper(_clazz, mw) {
	        _super.call(this);
	        this._clazz = _clazz;
	        this.mw = mw;
	    }
	    EnumWrapper.prototype.getModule = function () {
	        return this.mw;
	    };
	    EnumWrapper.prototype.values = function () {
	        return this._clazz.members;
	    };
	    EnumWrapper.prototype.name = function () {
	        return this._clazz.name;
	    };
	    return EnumWrapper;
	})(AbstractSimpleWrapper);
	var UnionWrapper = (function (_super) {
	    __extends(UnionWrapper, _super);
	    function UnionWrapper(_clazz, mw) {
	        _super.call(this);
	        this._clazz = _clazz;
	        this.mw = mw;
	    }
	    UnionWrapper.prototype.elements = function () {
	        return this._clazz;
	    };
	    UnionWrapper.prototype.name = function () {
	        return this._clazz.map(function (x) { return x.name(); }).join("|");
	    };
	    return UnionWrapper;
	})(AbstractSimpleWrapper);
	var ModuleWrapper = (function () {
	    function ModuleWrapper(_univers) {
	        var _this = this;
	        this._univers = _univers;
	        this.name2Class = {};
	        this.namespaceToMod = {};
	        this._classes = [];
	        _univers.classes.forEach(function (x) {
	            var c = new ClassWrapper(x, _this);
	            _this._classes.push(c);
	            _this.name2Class[x.name] = c;
	            if (x.moduleName) {
	                //FIXME
	                _this.name2Class[x.moduleName + "." + x.name] = c;
	            }
	        });
	        _univers.enumDeclarations.forEach(function (x) {
	            var c = new EnumWrapper(x, _this);
	            _this._classes.push(c);
	            _this.name2Class[x.name] = c;
	        });
	    }
	    ModuleWrapper.prototype.typeFor = function (t, ow) {
	        var _this = this;
	        switch (t.typeKind) {
	            case 0 /* BASIC */:
	                var bt = t;
	                var typeName = bt.typeName;
	                if (typeName == "string") {
	                    typeName = "StringType";
	                }
	                if (typeName == "number") {
	                    typeName = "NumberType";
	                }
	                if (typeName == "boolean") {
	                    typeName = "BooleanType";
	                }
	                var ti = _.indexOf(ow.typeArgs(), typeName);
	                if (ti != -1) {
	                    var cnst = ow.typConstraints()[ti];
	                    if (!cnst) {
	                        return this.classForName("ValueType");
	                    }
	                    return cnst;
	                }
	                return this.classForName(typeName);
	            case 2 /* UNION */:
	                var ut = t;
	                return new UnionWrapper(ut.options.map(function (x) { return _this.typeFor(x, ow); }), this);
	            case 1 /* ARRAY */:
	                var at = t;
	                return this.typeFor(at.base, ow);
	        }
	        return null;
	    };
	    ModuleWrapper.prototype.path = function () {
	        return this._univers.name;
	    };
	    ModuleWrapper.prototype.classForName = function (name, stack) {
	        var _this = this;
	        if (stack === void 0) { stack = {}; }
	        if (!name) {
	            return null;
	        }
	        var result = this.name2Class[name];
	        if (!result && !stack[this.path()]) {
	            stack[this.path()] = this;
	            var nmsp = name.indexOf(".");
	            if (nmsp != -1) {
	                var actualMod = this.namespaceToMod[name.substring(0, nmsp)];
	                if (!actualMod) {
	                    throw new Error();
	                }
	                return actualMod.classForName(name.substring(nmsp + 1), stack);
	            }
	            Object.keys(this.namespaceToMod).forEach(function (x) {
	                if (x != "MetaModel") {
	                    var nm = _this.namespaceToMod[x].classForName(name, stack);
	                    if (nm) {
	                        result = nm;
	                    }
	                }
	            });
	        }
	        return result;
	    };
	    ModuleWrapper.prototype.classes = function () {
	        return this._classes;
	    };
	    return ModuleWrapper;
	})();
	var wrapperToType = function (range, u) {
	    if (range) {
	        var rangeType;
	        if (range instanceof UnionWrapper) {
	            var uw = range;
	            rangeType = new def.UnionType(uw.elements().map(function (x) { return wrapperToType(x, u); }));
	        }
	        else {
	            rangeType = u.type(range.name());
	        }
	        return rangeType;
	    }
	    else {
	        return;
	    }
	};
	var registerClasses = function (m, u) {
	    var valueType = m.classForName("ValueType");
	    m.classes().forEach(function (x) {
	        if (x instanceof EnumWrapper) {
	            var et = new def.EnumType(x.name(), u, x.getModule().path());
	            et.values = x.values();
	            u.register(et);
	            return;
	        }
	        if (x.isSubTypeOf(valueType)) {
	            var st = x.getAllSuperTypes();
	            st.push(x);
	            var refTo = null;
	            var scriptingHook = null;
	            st.forEach(function (t) {
	                var cs = t.getExtendsClauses();
	                cs.forEach(function (z) {
	                    if (z.typeKind == 0 /* BASIC */) {
	                        var bas = z;
	                        if (bas.basicName == 'Reference') {
	                            var of = bas.typeArguments[0];
	                            refTo = of.typeName;
	                        }
	                        if (bas.basicName == 'ScriptingHook') {
	                            var of = bas.typeArguments[0];
	                            scriptingHook = of.basicName;
	                        }
	                    }
	                });
	            });
	            if (refTo) {
	                //console.log("New reference type" + x.name())
	                var ref = new def.ReferenceType(x.name(), x.getModule().path(), refTo, u);
	                u.register(ref);
	            }
	            if (scriptingHook) {
	                //console.log("New scripting hook " + x.name())
	                var sc = new def.ScriptingHookType(x.name(), x.getModule().path(), scriptingHook, u);
	                u.register(sc);
	            }
	            var vt = new def.ValueType(x.name(), u, x.getModule().path());
	            u.register(vt);
	        }
	        else {
	            var gt = new def.NodeClass(x.name(), u, x.getModule().path());
	            u.register(gt);
	        }
	    });
	};
	var registerHierarchy = function (m, u) {
	    m.classes().forEach(function (x) {
	        x.getSuperTypes().forEach(function (y) {
	            var tp0 = u.type(x.name());
	            var tp1 = u.type(y.name());
	            if (!tp0 || !tp1) {
	                var tp0 = u.type(x.name());
	                var tp1 = u.type(y.name());
	                throw new Error();
	            }
	            u.registerSuperClass(tp0, tp1);
	        });
	    });
	};
	var registerEverything = function (m, u) {
	    m.classes().forEach(function (x) {
	        var tp = u.type(x.name());
	        x.typeMeta().forEach(function (a) {
	            if (a.name == 'MetaModel.declaresSubTypeOf') {
	                var rangeType = wrapperToType(x, u);
	                rangeType.setExtendedTypeName(a.arguments[0]);
	            }
	            if (a.name == 'MetaModel.nameAtRuntime') {
	                var rangeType = wrapperToType(x, u);
	                rangeType.setNameAtRuntime(a.arguments[0]);
	            }
	            if (a.name == 'MetaModel.description') {
	                var rangeType = wrapperToType(x, u);
	                rangeType.withDescription(a.arguments[0]);
	            }
	            if (a.name == 'MetaModel.inlinedTemplates') {
	                var rangeType = wrapperToType(x, u);
	                rangeType.setInlinedTemplates(true);
	            }
	            if (a.name == 'MetaModel.requireValue') {
	                var rangeType = wrapperToType(x, u);
	                rangeType.withContextRequirement("" + a.arguments[0], "" + a.arguments[1]);
	            }
	            if (a.name == 'MetaModel.referenceIs') {
	                var rangeType = wrapperToType(x, u);
	                rangeType.withReferenceIs("" + a.arguments[0]);
	            }
	            //MetaModel.referenceIs
	            if (a.name == 'MetaModel.actuallyExports') {
	                var rangeType = wrapperToType(x, u);
	                rangeType.withActuallyExports("" + a.arguments[0]);
	            }
	            if (a.name == 'MetaModel.convertsToGlobalOfType') {
	                var rangeType = wrapperToType(x, u);
	                rangeType.withConvertsToGlobal("" + a.arguments[0]);
	            }
	            if (a.name == 'MetaModel.allowAny') {
	                var rangeType = wrapperToType(x, u);
	                rangeType.withAllowAny();
	            }
	            if (a.name == 'MetaModel.allowQuestion') {
	                var rangeType = wrapperToType(x, u);
	                rangeType.withAllowQuestion();
	            }
	            if (a.name == 'MetaModel.functionalDescriminator') {
	                var r1 = wrapperToType(x, u);
	                r1.withFunctionalDescriminator("" + a.arguments[0]);
	            }
	            if (a.name == 'MetaModel.alias') {
	                var at = wrapperToType(x, u);
	                at.addAlias("" + a.arguments[0]);
	            }
	            if (a.name == 'MetaModel.consumesRefs') {
	                var at = wrapperToType(x, u);
	                at.setConsumesRefs(true);
	            }
	            if (a.name == 'MetaModel.canInherit') {
	                var nc = wrapperToType(x, u);
	                nc.withCanInherit("" + a.arguments[0]);
	            }
	            if (a.name == 'MetaModel.definingPropertyIsEnough') {
	                var nc = wrapperToType(x, u);
	                nc.definingPropertyIsEnough("" + a.arguments[0]);
	            }
	        });
	        x.members().forEach(function (x) {
	            var range = x.range();
	            var rangeType = wrapperToType(range, u);
	            if (rangeType == null) {
	                console.log(range + ":" + x.name());
	            }
	            createProp(x, tp, rangeType);
	        });
	        Object.keys(x.annotationOverridings()).forEach(function (fName) {
	            var arr = [].concat(x.annotationOverridings()[fName]);
	            var map = {};
	            arr.forEach(function (ann) { return map[ann.name] = true; });
	            var targetField;
	            var stArr = x.getSuperTypes();
	            var stMap = {};
	            for (var i = 0; i < stArr.length; i++) {
	                var st = stArr[i];
	                if (stMap[st.name()]) {
	                    continue;
	                }
	                stMap[st.name()] = true;
	                st.getSuperTypes().forEach(function (sst) { return stArr.push(sst); });
	                var arr1 = st.annotationOverridings()[fName];
	                if (arr1) {
	                    arr1.filter(function (ann) { return !map[ann.name]; }).forEach(function (ann) {
	                        map[ann.name] = true;
	                        arr.push(ann);
	                    });
	                }
	                else {
	                    var stFields = st.members();
	                    for (var j = 0; j < stFields.length; j++) {
	                        var stField = stFields[j];
	                        if (stField.name() == fName) {
	                            targetField = stField;
	                            break;
	                        }
	                    }
	                }
	                if (targetField) {
	                    var arr2 = targetField.annotations();
	                    arr2.filter(function (ann) { return !map[ann.name]; }).forEach(function (ann) {
	                        map[ann.name] = true;
	                        arr.push(ann);
	                    });
	                    break;
	                }
	            }
	            if (!targetField) {
	                return;
	            }
	            var range = targetField.range();
	            var rangeType = wrapperToType(range, u);
	            if (rangeType == null) {
	                console.log(range + ":" + x.name());
	            }
	            createProp(targetField, tp, rangeType, arr);
	        });
	        x.methods().forEach(function (x) {
	            var at = tp;
	            at.addMethod(x.name, x.text);
	            //console.log(x.name);
	            //createMember(x, <def.AbstractType>tp, rangeType)
	        });
	        x.constraints().forEach(function (x) {
	            if (x.value().isCallConstraint) {
	                throw new Error();
	            }
	            var mm = x.value();
	            tp.addRequirement(x.name(), "" + mm.value);
	        });
	    });
	    u.types().forEach(function (x) {
	        if (x instanceof def.AbstractType) {
	            var at = x;
	            at.getAliases().forEach(function (y) { return u.registerAlias(y, at); });
	        }
	    });
	};
	var processModule = function (ts, u, used, declared) {
	    if (ts.name.indexOf("metamodel.ts") != -1) {
	        return; //FIXME
	    }
	    if (declared[ts.name]) {
	        return declared[ts.name];
	    }
	    var m = new ModuleWrapper(ts);
	    used[ts.name] = m;
	    declared[ts.name] = m;
	    Object.keys(ts.imports).forEach(function (x) {
	        var pMod = ts.imports[x];
	        if (used[pMod.name]) {
	            m.namespaceToMod[x] = used[pMod.name];
	            return;
	        }
	        var vMod = processModule(pMod, u, used, declared);
	        m.namespaceToMod[x] = vMod;
	    });
	    used[ts.name] = null;
	    return m;
	};
	function toDefSystem(ts) {
	    var u = new def.Universe("");
	    var c = {};
	    processModule(ts, u, {}, c);
	    Object.keys(c).forEach(function (x) {
	        registerClasses(c[x], u);
	    });
	    Object.keys(c).forEach(function (x) {
	        registerHierarchy(c[x], u);
	    });
	    Object.keys(c).forEach(function (x) {
	        registerEverything(c[x], u);
	    });
	    u.types().forEach(function (x) {
	        if (x instanceof def.NodeClass) {
	            var cl = x;
	            cl.properties().forEach(function (y) {
	                var t = y.range();
	                if (!t.isValueType()) {
	                    t.properties().forEach(function (p0) {
	                        if (p0.isKey()) {
	                            var kp = p0.keyPrefix();
	                            if (kp) {
	                                y.withKeyRestriction(kp);
	                                y.merge();
	                            }
	                            var eo = p0.getEnumOptions();
	                            if (eo) {
	                                y.withEnumOptions(eo);
	                                y.merge();
	                            }
	                        }
	                    });
	                }
	            });
	            if (cl.isGlobalDeclaration()) {
	                if (cl.getActuallyExports() && cl.getActuallyExports() != "$self") {
	                    var tp = cl.property(cl.getActuallyExports()).range();
	                    if (tp.isValueType()) {
	                        var vt = tp;
	                        vt.setGloballyDeclaredBy(cl);
	                    }
	                }
	                if (cl.getConvertsToGlobal()) {
	                    var tp = u.getType(cl.getConvertsToGlobal());
	                    if (tp.isValueType()) {
	                        var vt = tp;
	                        vt.setGloballyDeclaredBy(cl);
	                    }
	                }
	            }
	        }
	    });
	    return u;
	}
	exports.toDefSystem = toDefSystem;
	var annotationHandlers = {
	    key: function (a, f) {
	        f.withFromParentKey();
	        f.withKey(true);
	    },
	    value: function (a, f) {
	        f.withFromParentValue();
	    },
	    canBeValue: function (a, f) {
	        f.withCanBeValue();
	    },
	    unmerged: function (a, f) {
	        f.unmerge();
	    },
	    startFrom: function (a, f) {
	        f.withKeyRestriction(a.arguments[0]);
	        f.merge();
	    },
	    oneOf: function (a, f) {
	        f.withEnumOptions(a.arguments[0]);
	        //f.withKeyRestriction(<string>a.arguments[0])
	    },
	    oftenKeys: function (a, f) {
	        f.withOftenKeys(a.arguments[0]);
	        //f.withKeyRestriction(<string>a.arguments[0])
	    },
	    embeddedInMaps: function (a, f) {
	        f.withEmbedMap();
	        //f.withKeyRestriction(<string>a.arguments[0])
	    },
	    system: function (a, f) {
	        f.withSystem(true);
	    },
	    required: function (a, f) {
	        if (a.arguments[0] != 'false') {
	            f.withRequired(true);
	        }
	    },
	    noDirectParse: function (a, f) {
	        if (a.arguments[0] != 'false') {
	            f.withNoDirectParse();
	        }
	    },
	    setsContextValue: function (a, f) {
	        f.addChildValueConstraint(new def.ChildValueConstraint("" + a.arguments[0], "" + a.arguments[1]));
	        //f.withKeyRestriction(<string>a.arguments[0])
	    },
	    defaultValue: function (a, f) {
	        f.setDefaultVal("" + a.arguments[0]);
	    },
	    facetId: function (a, f) {
	        if (a.arguments[0] == "minItems") {
	            f.setFacetValidator(function (x, f) {
	                if (x instanceof Array) {
	                    var length = Number.parseInt("" + f.value());
	                    if (length > x.length) {
	                        return "array should contain at least " + f.value() + " items";
	                    }
	                }
	                return null;
	            });
	        }
	        if (a.arguments[0] == "maxItems") {
	            f.setFacetValidator(function (x, f) {
	                if (x instanceof Array) {
	                    var length = Number.parseInt("" + f.value());
	                    if (length < x.length) {
	                        return "array should contain not more then " + f.value() + " items";
	                    }
	                }
	                return null;
	            });
	        }
	        if (a.arguments[0] == "minProperties") {
	            f.setFacetValidator(function (x, f) {
	                if (x instanceof Object) {
	                    var length = Number.parseInt("" + f.value());
	                    if (length > Object.keys(x).length) {
	                        return "object should contain at least " + f.value() + " properties";
	                    }
	                }
	                return null;
	            });
	        }
	        if (a.arguments[0] == "maxProperties") {
	            f.setFacetValidator(function (x, f) {
	                if (x instanceof Object) {
	                    var length = Number.parseInt("" + f.value());
	                    if (length < Object.keys(x).length) {
	                        return "object should contain not more then " + f.value() + " properties";
	                    }
	                }
	                return null;
	            });
	        }
	        if (a.arguments[0] == "uniqueItems") {
	            f.setFacetValidator(function (x, f) {
	                if (x instanceof Array) {
	                    var length = _.unique(x).length;
	                    if (length < x.length) {
	                        return "array should contain only unique items";
	                    }
	                }
	                return null;
	            });
	        }
	        if (a.arguments[0] == "minLength") {
	            f.setFacetValidator(function (x, f) {
	                if (typeof x == 'number' || typeof x == 'boolean') {
	                    x = "" + x;
	                }
	                if (typeof x == 'string') {
	                    var length = Number.parseInt("" + f.value());
	                    if (length > x.length) {
	                        return "string length should be at least " + length;
	                    }
	                }
	                return null;
	            });
	        }
	        if (a.arguments[0] == "maxLength") {
	            f.setFacetValidator(function (x, f) {
	                if (typeof x == 'number' || typeof x == 'boolean') {
	                    x = "" + x;
	                }
	                if (typeof x == 'string') {
	                    var length = Number.parseInt("" + f.value());
	                    if (length < x.length) {
	                        return "string length should be not more then " + length;
	                    }
	                }
	                return null;
	            });
	        }
	        if (a.arguments[0] == "minimum") {
	            f.setFacetValidator(function (x, f) {
	                if (typeof x == 'string') {
	                    x = parseFloat(x);
	                }
	                if (typeof x == 'number') {
	                    var length = parseFloat(f.value());
	                    if (length > x) {
	                        return "value should be not less then " + length;
	                    }
	                }
	                return null;
	            });
	        }
	        if (a.arguments[0] == "maximum") {
	            f.setFacetValidator(function (x, f) {
	                if (typeof x == 'string') {
	                    x = parseFloat(x);
	                }
	                if (typeof x == 'number') {
	                    var length = parseFloat(f.value());
	                    if (length < x) {
	                        return "value should be not more then " + length;
	                    }
	                }
	                return null;
	            });
	        }
	        if (a.arguments[0] == "pattern") {
	            f.setFacetValidator(function (x, f) {
	                if (typeof x == 'number' || typeof x == 'boolean') {
	                    x = "" + x;
	                }
	                if (typeof x == 'string') {
	                    var regExp = new RegExp(f.value());
	                    if (!regExp.test(x)) {
	                        return "string should match to " + f.value();
	                    }
	                }
	                return null;
	            });
	        }
	    },
	    extraMetaKey: function (a, f) {
	        if (a.arguments[0] == "statusCodes") {
	            f.withOftenKeys(khttp.statusCodes.map(function (x) { return x.code; }));
	            f.setValueDocProvider(function (name) {
	                var s = _.find(khttp.statusCodes, function (x) { return x.code == name; });
	                if (s) {
	                    return (name + ":" + s.description);
	                }
	                return null;
	            });
	        }
	        if (a.arguments[0] == "annotationTargets") {
	            var targets = [];
	            targets.push("Parameter");
	            targets.push("Field");
	            targets.push("GlobalSchema");
	            targets = targets.concat(["API", "DocumentationItem", "Resource", "Method", "Response", "RequestBody", "ResponseBody", "DataElement", "NamedExample", "ResourceType", "Trait", "SecurityScheme", "SecuritySchemeSettings", "AnnotationType", "Library", "Overlay", "Extension"]);
	            f.withEnumOptions(targets);
	        }
	        if (a.arguments[0] == "headers") {
	            f.setValueSuggester(function (x) {
	                console.log(x);
	                var c = x.property().getChildValueConstraints();
	                if (_.find(c, function (x) {
	                    return x.name == "location" && x.value == "Params.ParameterLocation.HEADERS";
	                })) {
	                    return khttp.headers.map(function (x) { return x.header; });
	                }
	                if (x.property()) {
	                    if (x.property().name() == "headers") {
	                        return khttp.headers.map(function (x) { return x.header; });
	                    }
	                }
	                return null;
	            });
	            f.setValueDocProvider(function (name) {
	                var s = _.find(khttp.headers, function (x) { return x.header == name; });
	                if (s) {
	                    return (name + ":" + s.description);
	                }
	                return null;
	            });
	        }
	        if (a.arguments[0] == "methods") {
	            f.setValueDocProvider(function (name) {
	                var s = _.find(khttp.methods, function (x) { return x.method == name.toUpperCase(); });
	                if (s) {
	                    return (name + ":" + s.description);
	                }
	                return null;
	            });
	        }
	    },
	    requireValue: function (a, f) {
	        f.withContextRequirement("" + a.arguments[0], "" + a.arguments[1]);
	        //f.withKeyRestriction(<string>a.arguments[0])
	    },
	    allowMultiple: function (a, f) {
	        f.withMultiValue(true);
	        //f.withKeyRestriction(<string>a.arguments[0])
	    },
	    selector: function (a, f) {
	        f.setSelector("" + a.arguments[0]);
	        //f.withKeyRestriction(<string>a.arguments[0])
	    },
	    constraint: function (a, f) {
	        //f.withKeyRestriction(<string>a.arguments[0])
	    },
	    newInstanceName: function (a, f) {
	        f.withNewInstanceName("" + a.arguments[0]);
	        //f.withKeyRestriction(<string>a.arguments[0])
	    },
	    declaringFields: function (a, f) {
	        f.withThisPropertyDeclaresFields();
	        //f.withKeyRestriction(<string>a.arguments[0])
	    },
	    describesAnnotation: function (a, f) {
	        //f.withReferenceParameters();
	        f.withDescribes(a.arguments[0]);
	    },
	    allowNull: function (a, f) {
	        f.withAllowNull();
	    },
	    descriminatingProperty: function (a, f) {
	        //f.withReferenceParameters();
	        f.withDescriminating(true);
	    },
	    description: function (a, f) {
	        f.withDescription("" + a.arguments[0]);
	        //f.withReferenceParameters();
	        //f.withDescriminating(true)
	    },
	    issue: function (a, f) {
	        //f.withReferenceParameters();
	        //f.withDescriminating(true)
	        f.withIssue("" + a.arguments[0]);
	    },
	    inherited: function (a, f) {
	        f.withInherited(true);
	    },
	    version: function (a, f) {
	        f.withVersion("" + a.arguments[0]);
	    },
	    needsClarification: function (a, f) {
	        //f.withReferenceParameters();
	        //f.withDescriminating(true)
	        f.withClarify("" + a.arguments[0]);
	    },
	    thisFeatureCovers: function (a, f) {
	        //f.withReferenceParameters();
	        //f.withDescriminating(true)
	        f.withThisFeatureCovers("" + a.arguments[0]);
	    },
	    selfNode: function (a, f) {
	        f.withSelfNode();
	    },
	    valueRestriction: function (a, f) {
	        f.withValueRewstrinction("" + a.arguments[0], "" + a.arguments[1]);
	    },
	    grammarTokenKind: function (a, f) {
	        f.withPropertyGrammarType("" + a.arguments[0]);
	    },
	    canInherit: function (a, f) {
	        f.withInheritedContextValue("" + a.arguments[0]);
	    },
	    canBeDuplicator: function (a, f) {
	        f.setCanBeDuplicator();
	    },
	    hide: function (a, f) {
	        if (a.arguments.length == 0) {
	            f.setHidden(true);
	        }
	        else {
	            f.setHidden(a.arguments[0]);
	        }
	    },
	    documentationTableLabel: function (a, f) {
	        f.setDocTableName("" + a.arguments[0]);
	    },
	    markdownDescription: function (a, f) {
	        f.setMarkdownDescription("" + a.arguments[0]);
	    },
	    valueDescription: function (a, f) {
	        f.setValueDescription(a.arguments[0] != null ? ("" + a.arguments[0]) : null);
	    }
	};
	function recordAnnotation(p, a) {
	    annotationHandlers[a.name](a, p);
	}
	exports.recordAnnotation = recordAnnotation;
	var processAnnotations = function (x, p, annotations) {
	    if (!annotations) {
	        annotations = x.annotations();
	    }
	    annotations.forEach(function (x) {
	        var nm = x.name.substring(x.name.lastIndexOf(".") + 1);
	        if (!annotationHandlers[nm]) {
	            console.log("Can not find handler for:");
	        }
	        annotationHandlers[nm](x, p);
	    });
	};
	function createProp(x, clazz, t, annotations) {
	    var p = def.prop(x.name(), "", clazz, t);
	    if (x.isMultiValue()) {
	        p.withMultiValue(true);
	    }
	    p.unmerge();
	    if (!t.isValueType()) {
	        t.properties().forEach(function (p0) {
	            if (p0.isKey()) {
	                var kp = p0.keyPrefix();
	                if (kp) {
	                    p.withKeyRestriction(kp);
	                    p.merge();
	                }
	                var eo = p0.getEnumOptions();
	                if (eo) {
	                    p.withEnumOptions(eo);
	                    p.merge();
	                }
	            }
	        });
	    }
	    processAnnotations(x, p, annotations);
	}
	//# sourceMappingURL=tsStrut2Def.js.map

/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {var path = __webpack_require__(11);
	var fs = __webpack_require__(12);

	module.exports = mkdirP.mkdirp = mkdirP.mkdirP = mkdirP;

	function mkdirP (p, opts, f, made) {
	    if (typeof opts === 'function') {
	        f = opts;
	        opts = {};
	    }
	    else if (!opts || typeof opts !== 'object') {
	        opts = { mode: opts };
	    }
	    
	    var mode = opts.mode;
	    var xfs = opts.fs || fs;
	    
	    if (mode === undefined) {
	        mode = 0777 & (~process.umask());
	    }
	    if (!made) made = null;
	    
	    var cb = f || function () {};
	    p = path.resolve(p);
	    
	    xfs.mkdir(p, mode, function (er) {
	        if (!er) {
	            made = made || p;
	            return cb(null, made);
	        }
	        switch (er.code) {
	            case 'ENOENT':
	                mkdirP(path.dirname(p), opts, function (er, made) {
	                    if (er) cb(er, made);
	                    else mkdirP(p, opts, cb, made);
	                });
	                break;

	            // In the case of any other error, just see if there's a dir
	            // there already.  If so, then hooray!  If not, then something
	            // is borked.
	            default:
	                xfs.stat(p, function (er2, stat) {
	                    // if the stat fails, then that's super weird.
	                    // let the original error be the failure reason.
	                    if (er2 || !stat.isDirectory()) cb(er, made)
	                    else cb(null, made);
	                });
	                break;
	        }
	    });
	}

	mkdirP.sync = function sync (p, opts, made) {
	    if (!opts || typeof opts !== 'object') {
	        opts = { mode: opts };
	    }
	    
	    var mode = opts.mode;
	    var xfs = opts.fs || fs;
	    
	    if (mode === undefined) {
	        mode = 0777 & (~process.umask());
	    }
	    if (!made) made = null;

	    p = path.resolve(p);

	    try {
	        xfs.mkdirSync(p, mode);
	        made = made || p;
	    }
	    catch (err0) {
	        switch (err0.code) {
	            case 'ENOENT' :
	                made = sync(path.dirname(p), opts, made);
	                sync(p, opts, made);
	                break;

	            // In the case of any other error, just see if there's a dir
	            // there already.  If so, then hooray!  If not, then something
	            // is borked.
	            default:
	                var stat;
	                try {
	                    stat = xfs.statSync(p);
	                }
	                catch (err1) {
	                    throw err0;
	                }
	                if (!stat.isDirectory()) throw err0;
	                break;
	        }
	    }

	    return made;
	};

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(72)))

/***/ },
/* 41 */
/***/ function(module, exports, __webpack_require__) {

	/*!
	 * media-typer
	 * Copyright(c) 2014 Douglas Christopher Wilson
	 * MIT Licensed
	 */

	/**
	 * RegExp to match *( ";" parameter ) in RFC 2616 sec 3.7
	 *
	 * parameter     = token "=" ( token | quoted-string )
	 * token         = 1*<any CHAR except CTLs or separators>
	 * separators    = "(" | ")" | "<" | ">" | "@"
	 *               | "," | ";" | ":" | "\" | <">
	 *               | "/" | "[" | "]" | "?" | "="
	 *               | "{" | "}" | SP | HT
	 * quoted-string = ( <"> *(qdtext | quoted-pair ) <"> )
	 * qdtext        = <any TEXT except <">>
	 * quoted-pair   = "\" CHAR
	 * CHAR          = <any US-ASCII character (octets 0 - 127)>
	 * TEXT          = <any OCTET except CTLs, but including LWS>
	 * LWS           = [CRLF] 1*( SP | HT )
	 * CRLF          = CR LF
	 * CR            = <US-ASCII CR, carriage return (13)>
	 * LF            = <US-ASCII LF, linefeed (10)>
	 * SP            = <US-ASCII SP, space (32)>
	 * SHT           = <US-ASCII HT, horizontal-tab (9)>
	 * CTL           = <any US-ASCII control character (octets 0 - 31) and DEL (127)>
	 * OCTET         = <any 8-bit sequence of data>
	 */
	var paramRegExp = /; *([!#$%&'\*\+\-\.0-9A-Z\^_`a-z\|~]+) *= *("(?:[ !\u0023-\u005b\u005d-\u007e\u0080-\u00ff]|\\[\u0020-\u007e])*"|[!#$%&'\*\+\-\.0-9A-Z\^_`a-z\|~]+) */g;
	var textRegExp = /^[\u0020-\u007e\u0080-\u00ff]+$/
	var tokenRegExp = /^[!#$%&'\*\+\-\.0-9A-Z\^_`a-z\|~]+$/

	/**
	 * RegExp to match quoted-pair in RFC 2616
	 *
	 * quoted-pair = "\" CHAR
	 * CHAR        = <any US-ASCII character (octets 0 - 127)>
	 */
	var qescRegExp = /\\([\u0000-\u007f])/g;

	/**
	 * RegExp to match chars that must be quoted-pair in RFC 2616
	 */
	var quoteRegExp = /([\\"])/g;

	/**
	 * RegExp to match type in RFC 6838
	 *
	 * type-name = restricted-name
	 * subtype-name = restricted-name
	 * restricted-name = restricted-name-first *126restricted-name-chars
	 * restricted-name-first  = ALPHA / DIGIT
	 * restricted-name-chars  = ALPHA / DIGIT / "!" / "#" /
	 *                          "$" / "&" / "-" / "^" / "_"
	 * restricted-name-chars =/ "." ; Characters before first dot always
	 *                              ; specify a facet name
	 * restricted-name-chars =/ "+" ; Characters after last plus always
	 *                              ; specify a structured syntax suffix
	 * ALPHA =  %x41-5A / %x61-7A   ; A-Z / a-z
	 * DIGIT =  %x30-39             ; 0-9
	 */
	var subtypeNameRegExp = /^[A-Za-z0-9][A-Za-z0-9!#$&^_.-]{0,126}$/
	var typeNameRegExp = /^[A-Za-z0-9][A-Za-z0-9!#$&^_-]{0,126}$/
	var typeRegExp = /^ *([A-Za-z0-9][A-Za-z0-9!#$&^_-]{0,126})\/([A-Za-z0-9][A-Za-z0-9!#$&^_.+-]{0,126}) *$/;

	/**
	 * Module exports.
	 */

	exports.format = format
	exports.parse = parse

	/**
	 * Format object to media type.
	 *
	 * @param {object} obj
	 * @return {string}
	 * @api public
	 */

	function format(obj) {
	  if (!obj || typeof obj !== 'object') {
	    throw new TypeError('argument obj is required')
	  }

	  var parameters = obj.parameters
	  var subtype = obj.subtype
	  var suffix = obj.suffix
	  var type = obj.type

	  if (!type || !typeNameRegExp.test(type)) {
	    throw new TypeError('invalid type')
	  }

	  if (!subtype || !subtypeNameRegExp.test(subtype)) {
	    throw new TypeError('invalid subtype')
	  }

	  // format as type/subtype
	  var string = type + '/' + subtype

	  // append +suffix
	  if (suffix) {
	    if (!typeNameRegExp.test(suffix)) {
	      throw new TypeError('invalid suffix')
	    }

	    string += '+' + suffix
	  }

	  // append parameters
	  if (parameters && typeof parameters === 'object') {
	    var param
	    var params = Object.keys(parameters).sort()

	    for (var i = 0; i < params.length; i++) {
	      param = params[i]

	      if (!tokenRegExp.test(param)) {
	        throw new TypeError('invalid parameter name')
	      }

	      string += '; ' + param + '=' + qstring(parameters[param])
	    }
	  }

	  return string
	}

	/**
	 * Parse media type to object.
	 *
	 * @param {string|object} string
	 * @return {Object}
	 * @api public
	 */

	function parse(string) {
	  if (!string) {
	    throw new TypeError('argument string is required')
	  }

	  // support req/res-like objects as argument
	  if (typeof string === 'object') {
	    string = getcontenttype(string)
	  }

	  if (typeof string !== 'string') {
	    throw new TypeError('argument string is required to be a string')
	  }

	  var index = string.indexOf(';')
	  var type = index !== -1
	    ? string.substr(0, index)
	    : string

	  var key
	  var match
	  var obj = splitType(type)
	  var params = {}
	  var value

	  paramRegExp.lastIndex = index

	  while (match = paramRegExp.exec(string)) {
	    if (match.index !== index) {
	      throw new TypeError('invalid parameter format')
	    }

	    index += match[0].length
	    key = match[1].toLowerCase()
	    value = match[2]

	    if (value[0] === '"') {
	      // remove quotes and escapes
	      value = value
	        .substr(1, value.length - 2)
	        .replace(qescRegExp, '$1')
	    }

	    params[key] = value
	  }

	  if (index !== -1 && index !== string.length) {
	    throw new TypeError('invalid parameter format')
	  }

	  obj.parameters = params

	  return obj
	}

	/**
	 * Get content-type from req/res objects.
	 *
	 * @param {object}
	 * @return {Object}
	 * @api private
	 */

	function getcontenttype(obj) {
	  if (typeof obj.getHeader === 'function') {
	    // res-like
	    return obj.getHeader('content-type')
	  }

	  if (typeof obj.headers === 'object') {
	    // req-like
	    return obj.headers && obj.headers['content-type']
	  }
	}

	/**
	 * Quote a string if necessary.
	 *
	 * @param {string} val
	 * @return {string}
	 * @api private
	 */

	function qstring(val) {
	  var str = String(val)

	  // no need to quote tokens
	  if (tokenRegExp.test(str)) {
	    return str
	  }

	  if (str.length > 0 && !textRegExp.test(str)) {
	    throw new TypeError('invalid parameter value')
	  }

	  return '"' + str.replace(quoteRegExp, '\\$1') + '"'
	}

	/**
	 * Simply "type/subtype+siffx" into parts.
	 *
	 * @param {string} string
	 * @return {Object}
	 * @api private
	 */

	function splitType(string) {
	  var match = typeRegExp.exec(string.toLowerCase())

	  if (!match) {
	    throw new TypeError('invalid media type')
	  }

	  var type = match[1]
	  var subtype = match[2]
	  var suffix

	  // suffix after last +
	  var index = subtype.lastIndexOf('+')
	  if (index !== -1) {
	    suffix = subtype.substr(index + 1)
	    subtype = subtype.substr(0, index)
	  }

	  var obj = {
	    type: type,
	    subtype: subtype,
	    suffix: suffix
	  }

	  return obj
	}


/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = typescript;

/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = child_process;

/***/ },
/* 44 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = _spawn_sync;

/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

	/* global define */

	(function (root, pluralize) {
	  /* istanbul ignore else */
	  if (true) {
	    // Node.
	    module.exports = pluralize();
	  } else if (typeof define === 'function' && define.amd) {
	    // AMD, registers as an anonymous module.
	    define(function () {
	      return pluralize();
	    });
	  } else {
	    // Browser global.
	    root.pluralize = pluralize();
	  }
	})(this, function () {
	  // Rule storage - pluralize and singularize need to be run sequentially,
	  // while other rules can be optimized using an object for instant lookups.
	  var pluralRules = [];
	  var singularRules = [];
	  var uncountables = {};
	  var irregularPlurals = {};
	  var irregularSingles = {};

	  /**
	   * Title case a string.
	   *
	   * @param  {string} str
	   * @return {string}
	   */
	  function toTitleCase (str) {
	    return str.charAt(0).toUpperCase() + str.substr(1).toLowerCase();
	  }

	  /**
	   * Sanitize a pluralization rule to a usable regular expression.
	   *
	   * @param  {(RegExp|string)} rule
	   * @return {RegExp}
	   */
	  function sanitizeRule (rule) {
	    if (typeof rule === 'string') {
	      return new RegExp('^' + rule + '$', 'i');
	    }

	    return rule;
	  }

	  /**
	   * Pass in a word token to produce a function that can replicate the case on
	   * another word.
	   *
	   * @param  {string}   word
	   * @param  {string}   token
	   * @return {Function}
	   */
	  function restoreCase (word, token) {
	    // Upper cased words. E.g. "HELLO".
	    if (word === word.toUpperCase()) {
	      return token.toUpperCase();
	    }

	    // Title cased words. E.g. "Title".
	    if (word[0] === word[0].toUpperCase()) {
	      return toTitleCase(token);
	    }

	    // Lower cased words. E.g. "test".
	    return token.toLowerCase();
	  }

	  /**
	   * Interpolate a regexp string.
	   *
	   * @param  {string} str
	   * @param  {Array}  args
	   * @return {string}
	   */
	  function interpolate (str, args) {
	    return str.replace(/\$(\d{1,2})/g, function (match, index) {
	      return args[index] || '';
	    });
	  }

	  /**
	   * Sanitize a word by passing in the word and sanitization rules.
	   *
	   * @param  {String}   token
	   * @param  {String}   word
	   * @param  {Array}    collection
	   * @return {String}
	   */
	  function sanitizeWord (token, word, collection) {
	    // Empty string or doesn't need fixing.
	    if (!token.length || uncountables.hasOwnProperty(token)) {
	      return word;
	    }

	    var len = collection.length;

	    // Iterate over the sanitization rules and use the first one to match.
	    while (len--) {
	      var rule = collection[len];

	      // If the rule passes, return the replacement.
	      if (rule[0].test(word)) {
	        return word.replace(rule[0], function (match, index, word) {
	          var result = interpolate(rule[1], arguments);

	          if (match === '') {
	            return restoreCase(word[index - 1], result);
	          }

	          return restoreCase(match, result);
	        });
	      }
	    }

	    return word;
	  }

	  /**
	   * Replace a word with the updated word.
	   *
	   * @param  {Object}   replaceMap
	   * @param  {Object}   keepMap
	   * @param  {Array}    rules
	   * @return {Function}
	   */
	  function replaceWord (replaceMap, keepMap, rules) {
	    return function (word) {
	      // Get the correct token and case restoration functions.
	      var token = word.toLowerCase();

	      // Check against the keep object map.
	      if (keepMap.hasOwnProperty(token)) {
	        return restoreCase(word, token);
	      }

	      // Check against the replacement map for a direct word replacement.
	      if (replaceMap.hasOwnProperty(token)) {
	        return restoreCase(word, replaceMap[token]);
	      }

	      // Run all the rules against the word.
	      return sanitizeWord(token, word, rules);
	    };
	  }

	  /**
	   * Pluralize or singularize a word based on the passed in count.
	   *
	   * @param  {String}  word
	   * @param  {Number}  count
	   * @param  {Boolean} inclusive
	   * @return {String}
	   */
	  function pluralize (word, count, inclusive) {
	    var pluralized = count === 1
	      ? pluralize.singular(word) : pluralize.plural(word);

	    return (inclusive ? count + ' ' : '') + pluralized;
	  }

	  /**
	   * Pluralize a word.
	   *
	   * @type {Function}
	   */
	  pluralize.plural = replaceWord(
	    irregularSingles, irregularPlurals, pluralRules
	  );

	  /**
	   * Singularize a word.
	   *
	   * @type {Function}
	   */
	  pluralize.singular = replaceWord(
	    irregularPlurals, irregularSingles, singularRules
	  );

	  /**
	   * Add a pluralization rule to the collection.
	   *
	   * @param {(string|RegExp)} rule
	   * @param {string}          replacement
	   */
	  pluralize.addPluralRule = function (rule, replacement) {
	    pluralRules.push([sanitizeRule(rule), replacement]);
	  };

	  /**
	   * Add a singularization rule to the collection.
	   *
	   * @param {(string|RegExp)} rule
	   * @param {string}          replacement
	   */
	  pluralize.addSingularRule = function (rule, replacement) {
	    singularRules.push([sanitizeRule(rule), replacement]);
	  };

	  /**
	   * Add an uncountable word rule.
	   *
	   * @param {(string|RegExp)} word
	   */
	  pluralize.addUncountableRule = function (word) {
	    if (typeof word === 'string') {
	      uncountables[word.toLowerCase()] = true;
	      return;
	    }

	    // Set singular and plural references for the word.
	    pluralize.addPluralRule(word, '$0');
	    pluralize.addSingularRule(word, '$0');
	  };

	  /**
	   * Add an irregular word definition.
	   *
	   * @param {String} single
	   * @param {String} plural
	   */
	  pluralize.addIrregularRule = function (single, plural) {
	    plural = plural.toLowerCase();
	    single = single.toLowerCase();

	    irregularSingles[single] = plural;
	    irregularPlurals[plural] = single;
	  };

	  /**
	   * Irregular rules.
	   */
	  [
	    // Pronouns.
	    ['I', 'we'],
	    ['me', 'us'],
	    ['he', 'they'],
	    ['she', 'they'],
	    ['them', 'them'],
	    ['myself', 'ourselves'],
	    ['yourself', 'yourselves'],
	    ['itself', 'themselves'],
	    ['herself', 'themselves'],
	    ['himself', 'themselves'],
	    ['themself', 'themselves'],
	    ['is', 'are'],
	    ['this', 'these'],
	    ['that', 'those'],
	    // Words ending in with a consonant and `o`.
	    ['echo', 'echoes'],
	    ['dingo', 'dingoes'],
	    ['volcano', 'volcanoes'],
	    ['tornado', 'tornadoes'],
	    ['torpedo', 'torpedoes'],
	    // Ends with `us`.
	    ['genus', 'genera'],
	    ['viscus', 'viscera'],
	    // Ends with `ma`.
	    ['stigma', 'stigmata'],
	    ['stoma', 'stomata'],
	    ['dogma', 'dogmata'],
	    ['lemma', 'lemmata'],
	    ['schema', 'schemata'],
	    ['anathema', 'anathemata'],
	    // Other irregular rules.
	    ['ox', 'oxen'],
	    ['axe', 'axes'],
	    ['die', 'dice'],
	    ['yes', 'yeses'],
	    ['foot', 'feet'],
	    ['eave', 'eaves'],
	    ['goose', 'geese'],
	    ['tooth', 'teeth'],
	    ['quiz', 'quizzes'],
	    ['human', 'humans'],
	    ['proof', 'proofs'],
	    ['carve', 'carves'],
	    ['valve', 'valves'],
	    ['thief', 'thieves'],
	    ['genie', 'genies'],
	    ['groove', 'grooves'],
	    ['pickaxe', 'pickaxes'],
	    ['whiskey', 'whiskies']
	  ].forEach(function (rule) {
	    return pluralize.addIrregularRule(rule[0], rule[1]);
	  });

	  /**
	   * Pluralization rules.
	   */
	  [
	    [/s?$/i, 's'],
	    [/([^aeiou]ese)$/i, '$1'],
	    [/(ax|test)is$/i, '$1es'],
	    [/(alias|[^aou]us|tlas|gas|ris)$/i, '$1es'],
	    [/(e[mn]u)s?$/i, '$1s'],
	    [/([^l]ias|[aeiou]las|[emjzr]as|[iu]am)$/i, '$1'],
	    [/(alumn|syllab|octop|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$/i, '$1i'],
	    [/(alumn|alg|vertebr)(?:a|ae)$/i, '$1ae'],
	    [/(seraph|cherub)(?:im)?$/i, '$1im'],
	    [/(her|at|gr)o$/i, '$1oes'],
	    [/(agend|addend|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|automat|quor)(?:a|um)$/i, '$1a'],
	    [/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)(?:a|on)$/i, '$1a'],
	    [/sis$/i, 'ses'],
	    [/(?:(kni|wi|li)fe|(ar|l|ea|eo|oa|hoo)f)$/i, '$1$2ves'],
	    [/([^aeiouy]|qu)y$/i, '$1ies'],
	    [/([^ch][ieo][ln])ey$/i, '$1ies'],
	    [/(x|ch|ss|sh|zz)$/i, '$1es'],
	    [/(matr|cod|mur|sil|vert|ind|append)(?:ix|ex)$/i, '$1ices'],
	    [/(m|l)(?:ice|ouse)$/i, '$1ice'],
	    [/(pe)(?:rson|ople)$/i, '$1ople'],
	    [/(child)(?:ren)?$/i, '$1ren'],
	    [/eaux$/i, '$0'],
	    [/m[ae]n$/i, 'men'],
	    ['thou', 'you']
	  ].forEach(function (rule) {
	    return pluralize.addPluralRule(rule[0], rule[1]);
	  });

	  /**
	   * Singularization rules.
	   */
	  [
	    [/s$/i, ''],
	    [/(ss)$/i, '$1'],
	    [/((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)(?:sis|ses)$/i, '$1sis'],
	    [/(^analy)(?:sis|ses)$/i, '$1sis'],
	    [/(wi|kni|(?:after|half|high|low|mid|non|night|[^\w]|^)li)ves$/i, '$1fe'],
	    [/(ar|(?:wo|[ae])l|[eo][ao])ves$/i, '$1f'],
	    [/([^aeiouy]|qu)ies$/i, '$1y'],
	    [/(^[pl]|zomb|^(?:neck)?t|[aeo][lt]|cut)ies$/i, '$1ie'],
	    [/([^c][eor]n|smil)ies$/i, '$1ey'],
	    [/(m|l)ice$/i, '$1ouse'],
	    [/(seraph|cherub)im$/i, '$1'],
	    [/(x|ch|ss|sh|zz|tto|go|cho|alias|[^aou]us|tlas|gas|(?:her|at|gr)o|ris)(?:es)?$/i, '$1'],
	    [/(e[mn]u)s?$/i, '$1'],
	    [/(movie|twelve)s$/i, '$1'],
	    [/(cris|test|diagnos)(?:is|es)$/i, '$1is'],
	    [/(alumn|syllab|octop|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$/i, '$1us'],
	    [/(agend|addend|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|quor)a$/i, '$1um'],
	    [/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)a$/i, '$1on'],
	    [/(alumn|alg|vertebr)ae$/i, '$1a'],
	    [/(cod|mur|sil|vert|ind)ices$/i, '$1ex'],
	    [/(matr|append)ices$/i, '$1ix'],
	    [/(pe)(rson|ople)$/i, '$1rson'],
	    [/(child)ren$/i, '$1'],
	    [/(eau)x?$/i, '$1'],
	    [/men$/i, 'man']
	  ].forEach(function (rule) {
	    return pluralize.addSingularRule(rule[0], rule[1]);
	  });

	  /**
	   * Uncountable rules.
	   */
	  [
	    // Singular words with no plurals.
	    'advice',
	    'agenda',
	    'bison',
	    'bream',
	    'buffalo',
	    'carp',
	    'chassis',
	    'cod',
	    'cooperation',
	    'corps',
	    'digestion',
	    'debris',
	    'diabetes',
	    'energy',
	    'equipment',
	    'elk',
	    'excretion',
	    'expertise',
	    'flounder',
	    'gallows',
	    'garbage',
	    'graffiti',
	    'headquarters',
	    'health',
	    'herpes',
	    'highjinks',
	    'homework',
	    'information',
	    'jeans',
	    'justice',
	    'kudos',
	    'labour',
	    'machinery',
	    'mackerel',
	    'media',
	    'mews',
	    'moose',
	    'news',
	    'pike',
	    'plankton',
	    'pliers',
	    'pollution',
	    'premises',
	    'rain',
	    'rice',
	    'salmon',
	    'scissors',
	    'series',
	    'sewage',
	    'shambles',
	    'shrimp',
	    'species',
	    'staff',
	    'swine',
	    'trout',
	    'tuna',
	    'whiting',
	    'wildebeest',
	    'wildlife',
	    'you',
	    // Regexes.
	    /pox$/i, // "chickpox", "smallpox"
	    /ois$/i,
	    /deer$/i, // "deer", "reindeer"
	    /fish$/i, // "fish", "blowfish", "angelfish"
	    /sheep$/i,
	    /measles$/i,
	    /[^aeiou]ese$/i // "chinese", "japanese"
	  ].forEach(pluralize.addUncountableRule);

	  return pluralize;
	});


/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {/**
	 * Copyright 2013-2015, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 *
	 * @providesModule invariant
	 */

	'use strict';

	/**
	 * Use invariant() to assert state which your program assumes to be true.
	 *
	 * Provide sprintf-style format (only %s is supported) and arguments
	 * to provide information about what broke and what you were
	 * expecting.
	 *
	 * The invariant message will be stripped in production, but the invariant
	 * will remain to ensure logic does not differ in production.
	 */

	var invariant = function(condition, format, a, b, c, d, e, f) {
	  if (process.env.NODE_ENV !== 'production') {
	    if (format === undefined) {
	      throw new Error('invariant requires an error message argument');
	    }
	  }

	  if (!condition) {
	    var error;
	    if (format === undefined) {
	      error = new Error(
	        'Minified exception occurred; use the non-minified dev environment ' +
	        'for the full error message and additional helpful warnings.'
	      );
	    } else {
	      var args = [a, b, c, d, e, f];
	      var argIndex = 0;
	      error = new Error(
	        'Invariant Violation: ' +
	        format.replace(/%s/g, function() { return args[argIndex++]; })
	      );
	    }

	    error.framesToPop = 1; // we don't care about invariant's own frame
	    throw error;
	  }
	};

	module.exports = invariant;

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(72)))

/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;//     Underscore.js 1.8.3
	//     http://underscorejs.org
	//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	//     Underscore may be freely distributed under the MIT license.

	(function() {

	  // Baseline setup
	  // --------------

	  // Establish the root object, `window` in the browser, or `exports` on the server.
	  var root = this;

	  // Save the previous value of the `_` variable.
	  var previousUnderscore = root._;

	  // Save bytes in the minified (but not gzipped) version:
	  var ArrayProto = Array.prototype, ObjProto = Object.prototype, FuncProto = Function.prototype;

	  // Create quick reference variables for speed access to core prototypes.
	  var
	    push             = ArrayProto.push,
	    slice            = ArrayProto.slice,
	    toString         = ObjProto.toString,
	    hasOwnProperty   = ObjProto.hasOwnProperty;

	  // All **ECMAScript 5** native function implementations that we hope to use
	  // are declared here.
	  var
	    nativeIsArray      = Array.isArray,
	    nativeKeys         = Object.keys,
	    nativeBind         = FuncProto.bind,
	    nativeCreate       = Object.create;

	  // Naked function reference for surrogate-prototype-swapping.
	  var Ctor = function(){};

	  // Create a safe reference to the Underscore object for use below.
	  var _ = function(obj) {
	    if (obj instanceof _) return obj;
	    if (!(this instanceof _)) return new _(obj);
	    this._wrapped = obj;
	  };

	  // Export the Underscore object for **Node.js**, with
	  // backwards-compatibility for the old `require()` API. If we're in
	  // the browser, add `_` as a global object.
	  if (true) {
	    if (typeof module !== 'undefined' && module.exports) {
	      exports = module.exports = _;
	    }
	    exports._ = _;
	  } else {
	    root._ = _;
	  }

	  // Current version.
	  _.VERSION = '1.8.3';

	  // Internal function that returns an efficient (for current engines) version
	  // of the passed-in callback, to be repeatedly applied in other Underscore
	  // functions.
	  var optimizeCb = function(func, context, argCount) {
	    if (context === void 0) return func;
	    switch (argCount == null ? 3 : argCount) {
	      case 1: return function(value) {
	        return func.call(context, value);
	      };
	      case 2: return function(value, other) {
	        return func.call(context, value, other);
	      };
	      case 3: return function(value, index, collection) {
	        return func.call(context, value, index, collection);
	      };
	      case 4: return function(accumulator, value, index, collection) {
	        return func.call(context, accumulator, value, index, collection);
	      };
	    }
	    return function() {
	      return func.apply(context, arguments);
	    };
	  };

	  // A mostly-internal function to generate callbacks that can be applied
	  // to each element in a collection, returning the desired result — either
	  // identity, an arbitrary callback, a property matcher, or a property accessor.
	  var cb = function(value, context, argCount) {
	    if (value == null) return _.identity;
	    if (_.isFunction(value)) return optimizeCb(value, context, argCount);
	    if (_.isObject(value)) return _.matcher(value);
	    return _.property(value);
	  };
	  _.iteratee = function(value, context) {
	    return cb(value, context, Infinity);
	  };

	  // An internal function for creating assigner functions.
	  var createAssigner = function(keysFunc, undefinedOnly) {
	    return function(obj) {
	      var length = arguments.length;
	      if (length < 2 || obj == null) return obj;
	      for (var index = 1; index < length; index++) {
	        var source = arguments[index],
	            keys = keysFunc(source),
	            l = keys.length;
	        for (var i = 0; i < l; i++) {
	          var key = keys[i];
	          if (!undefinedOnly || obj[key] === void 0) obj[key] = source[key];
	        }
	      }
	      return obj;
	    };
	  };

	  // An internal function for creating a new object that inherits from another.
	  var baseCreate = function(prototype) {
	    if (!_.isObject(prototype)) return {};
	    if (nativeCreate) return nativeCreate(prototype);
	    Ctor.prototype = prototype;
	    var result = new Ctor;
	    Ctor.prototype = null;
	    return result;
	  };

	  var property = function(key) {
	    return function(obj) {
	      return obj == null ? void 0 : obj[key];
	    };
	  };

	  // Helper for collection methods to determine whether a collection
	  // should be iterated as an array or as an object
	  // Related: http://people.mozilla.org/~jorendorff/es6-draft.html#sec-tolength
	  // Avoids a very nasty iOS 8 JIT bug on ARM-64. #2094
	  var MAX_ARRAY_INDEX = Math.pow(2, 53) - 1;
	  var getLength = property('length');
	  var isArrayLike = function(collection) {
	    var length = getLength(collection);
	    return typeof length == 'number' && length >= 0 && length <= MAX_ARRAY_INDEX;
	  };

	  // Collection Functions
	  // --------------------

	  // The cornerstone, an `each` implementation, aka `forEach`.
	  // Handles raw objects in addition to array-likes. Treats all
	  // sparse array-likes as if they were dense.
	  _.each = _.forEach = function(obj, iteratee, context) {
	    iteratee = optimizeCb(iteratee, context);
	    var i, length;
	    if (isArrayLike(obj)) {
	      for (i = 0, length = obj.length; i < length; i++) {
	        iteratee(obj[i], i, obj);
	      }
	    } else {
	      var keys = _.keys(obj);
	      for (i = 0, length = keys.length; i < length; i++) {
	        iteratee(obj[keys[i]], keys[i], obj);
	      }
	    }
	    return obj;
	  };

	  // Return the results of applying the iteratee to each element.
	  _.map = _.collect = function(obj, iteratee, context) {
	    iteratee = cb(iteratee, context);
	    var keys = !isArrayLike(obj) && _.keys(obj),
	        length = (keys || obj).length,
	        results = Array(length);
	    for (var index = 0; index < length; index++) {
	      var currentKey = keys ? keys[index] : index;
	      results[index] = iteratee(obj[currentKey], currentKey, obj);
	    }
	    return results;
	  };

	  // Create a reducing function iterating left or right.
	  function createReduce(dir) {
	    // Optimized iterator function as using arguments.length
	    // in the main function will deoptimize the, see #1991.
	    function iterator(obj, iteratee, memo, keys, index, length) {
	      for (; index >= 0 && index < length; index += dir) {
	        var currentKey = keys ? keys[index] : index;
	        memo = iteratee(memo, obj[currentKey], currentKey, obj);
	      }
	      return memo;
	    }

	    return function(obj, iteratee, memo, context) {
	      iteratee = optimizeCb(iteratee, context, 4);
	      var keys = !isArrayLike(obj) && _.keys(obj),
	          length = (keys || obj).length,
	          index = dir > 0 ? 0 : length - 1;
	      // Determine the initial value if none is provided.
	      if (arguments.length < 3) {
	        memo = obj[keys ? keys[index] : index];
	        index += dir;
	      }
	      return iterator(obj, iteratee, memo, keys, index, length);
	    };
	  }

	  // **Reduce** builds up a single result from a list of values, aka `inject`,
	  // or `foldl`.
	  _.reduce = _.foldl = _.inject = createReduce(1);

	  // The right-associative version of reduce, also known as `foldr`.
	  _.reduceRight = _.foldr = createReduce(-1);

	  // Return the first value which passes a truth test. Aliased as `detect`.
	  _.find = _.detect = function(obj, predicate, context) {
	    var key;
	    if (isArrayLike(obj)) {
	      key = _.findIndex(obj, predicate, context);
	    } else {
	      key = _.findKey(obj, predicate, context);
	    }
	    if (key !== void 0 && key !== -1) return obj[key];
	  };

	  // Return all the elements that pass a truth test.
	  // Aliased as `select`.
	  _.filter = _.select = function(obj, predicate, context) {
	    var results = [];
	    predicate = cb(predicate, context);
	    _.each(obj, function(value, index, list) {
	      if (predicate(value, index, list)) results.push(value);
	    });
	    return results;
	  };

	  // Return all the elements for which a truth test fails.
	  _.reject = function(obj, predicate, context) {
	    return _.filter(obj, _.negate(cb(predicate)), context);
	  };

	  // Determine whether all of the elements match a truth test.
	  // Aliased as `all`.
	  _.every = _.all = function(obj, predicate, context) {
	    predicate = cb(predicate, context);
	    var keys = !isArrayLike(obj) && _.keys(obj),
	        length = (keys || obj).length;
	    for (var index = 0; index < length; index++) {
	      var currentKey = keys ? keys[index] : index;
	      if (!predicate(obj[currentKey], currentKey, obj)) return false;
	    }
	    return true;
	  };

	  // Determine if at least one element in the object matches a truth test.
	  // Aliased as `any`.
	  _.some = _.any = function(obj, predicate, context) {
	    predicate = cb(predicate, context);
	    var keys = !isArrayLike(obj) && _.keys(obj),
	        length = (keys || obj).length;
	    for (var index = 0; index < length; index++) {
	      var currentKey = keys ? keys[index] : index;
	      if (predicate(obj[currentKey], currentKey, obj)) return true;
	    }
	    return false;
	  };

	  // Determine if the array or object contains a given item (using `===`).
	  // Aliased as `includes` and `include`.
	  _.contains = _.includes = _.include = function(obj, item, fromIndex, guard) {
	    if (!isArrayLike(obj)) obj = _.values(obj);
	    if (typeof fromIndex != 'number' || guard) fromIndex = 0;
	    return _.indexOf(obj, item, fromIndex) >= 0;
	  };

	  // Invoke a method (with arguments) on every item in a collection.
	  _.invoke = function(obj, method) {
	    var args = slice.call(arguments, 2);
	    var isFunc = _.isFunction(method);
	    return _.map(obj, function(value) {
	      var func = isFunc ? method : value[method];
	      return func == null ? func : func.apply(value, args);
	    });
	  };

	  // Convenience version of a common use case of `map`: fetching a property.
	  _.pluck = function(obj, key) {
	    return _.map(obj, _.property(key));
	  };

	  // Convenience version of a common use case of `filter`: selecting only objects
	  // containing specific `key:value` pairs.
	  _.where = function(obj, attrs) {
	    return _.filter(obj, _.matcher(attrs));
	  };

	  // Convenience version of a common use case of `find`: getting the first object
	  // containing specific `key:value` pairs.
	  _.findWhere = function(obj, attrs) {
	    return _.find(obj, _.matcher(attrs));
	  };

	  // Return the maximum element (or element-based computation).
	  _.max = function(obj, iteratee, context) {
	    var result = -Infinity, lastComputed = -Infinity,
	        value, computed;
	    if (iteratee == null && obj != null) {
	      obj = isArrayLike(obj) ? obj : _.values(obj);
	      for (var i = 0, length = obj.length; i < length; i++) {
	        value = obj[i];
	        if (value > result) {
	          result = value;
	        }
	      }
	    } else {
	      iteratee = cb(iteratee, context);
	      _.each(obj, function(value, index, list) {
	        computed = iteratee(value, index, list);
	        if (computed > lastComputed || computed === -Infinity && result === -Infinity) {
	          result = value;
	          lastComputed = computed;
	        }
	      });
	    }
	    return result;
	  };

	  // Return the minimum element (or element-based computation).
	  _.min = function(obj, iteratee, context) {
	    var result = Infinity, lastComputed = Infinity,
	        value, computed;
	    if (iteratee == null && obj != null) {
	      obj = isArrayLike(obj) ? obj : _.values(obj);
	      for (var i = 0, length = obj.length; i < length; i++) {
	        value = obj[i];
	        if (value < result) {
	          result = value;
	        }
	      }
	    } else {
	      iteratee = cb(iteratee, context);
	      _.each(obj, function(value, index, list) {
	        computed = iteratee(value, index, list);
	        if (computed < lastComputed || computed === Infinity && result === Infinity) {
	          result = value;
	          lastComputed = computed;
	        }
	      });
	    }
	    return result;
	  };

	  // Shuffle a collection, using the modern version of the
	  // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher–Yates_shuffle).
	  _.shuffle = function(obj) {
	    var set = isArrayLike(obj) ? obj : _.values(obj);
	    var length = set.length;
	    var shuffled = Array(length);
	    for (var index = 0, rand; index < length; index++) {
	      rand = _.random(0, index);
	      if (rand !== index) shuffled[index] = shuffled[rand];
	      shuffled[rand] = set[index];
	    }
	    return shuffled;
	  };

	  // Sample **n** random values from a collection.
	  // If **n** is not specified, returns a single random element.
	  // The internal `guard` argument allows it to work with `map`.
	  _.sample = function(obj, n, guard) {
	    if (n == null || guard) {
	      if (!isArrayLike(obj)) obj = _.values(obj);
	      return obj[_.random(obj.length - 1)];
	    }
	    return _.shuffle(obj).slice(0, Math.max(0, n));
	  };

	  // Sort the object's values by a criterion produced by an iteratee.
	  _.sortBy = function(obj, iteratee, context) {
	    iteratee = cb(iteratee, context);
	    return _.pluck(_.map(obj, function(value, index, list) {
	      return {
	        value: value,
	        index: index,
	        criteria: iteratee(value, index, list)
	      };
	    }).sort(function(left, right) {
	      var a = left.criteria;
	      var b = right.criteria;
	      if (a !== b) {
	        if (a > b || a === void 0) return 1;
	        if (a < b || b === void 0) return -1;
	      }
	      return left.index - right.index;
	    }), 'value');
	  };

	  // An internal function used for aggregate "group by" operations.
	  var group = function(behavior) {
	    return function(obj, iteratee, context) {
	      var result = {};
	      iteratee = cb(iteratee, context);
	      _.each(obj, function(value, index) {
	        var key = iteratee(value, index, obj);
	        behavior(result, value, key);
	      });
	      return result;
	    };
	  };

	  // Groups the object's values by a criterion. Pass either a string attribute
	  // to group by, or a function that returns the criterion.
	  _.groupBy = group(function(result, value, key) {
	    if (_.has(result, key)) result[key].push(value); else result[key] = [value];
	  });

	  // Indexes the object's values by a criterion, similar to `groupBy`, but for
	  // when you know that your index values will be unique.
	  _.indexBy = group(function(result, value, key) {
	    result[key] = value;
	  });

	  // Counts instances of an object that group by a certain criterion. Pass
	  // either a string attribute to count by, or a function that returns the
	  // criterion.
	  _.countBy = group(function(result, value, key) {
	    if (_.has(result, key)) result[key]++; else result[key] = 1;
	  });

	  // Safely create a real, live array from anything iterable.
	  _.toArray = function(obj) {
	    if (!obj) return [];
	    if (_.isArray(obj)) return slice.call(obj);
	    if (isArrayLike(obj)) return _.map(obj, _.identity);
	    return _.values(obj);
	  };

	  // Return the number of elements in an object.
	  _.size = function(obj) {
	    if (obj == null) return 0;
	    return isArrayLike(obj) ? obj.length : _.keys(obj).length;
	  };

	  // Split a collection into two arrays: one whose elements all satisfy the given
	  // predicate, and one whose elements all do not satisfy the predicate.
	  _.partition = function(obj, predicate, context) {
	    predicate = cb(predicate, context);
	    var pass = [], fail = [];
	    _.each(obj, function(value, key, obj) {
	      (predicate(value, key, obj) ? pass : fail).push(value);
	    });
	    return [pass, fail];
	  };

	  // Array Functions
	  // ---------------

	  // Get the first element of an array. Passing **n** will return the first N
	  // values in the array. Aliased as `head` and `take`. The **guard** check
	  // allows it to work with `_.map`.
	  _.first = _.head = _.take = function(array, n, guard) {
	    if (array == null) return void 0;
	    if (n == null || guard) return array[0];
	    return _.initial(array, array.length - n);
	  };

	  // Returns everything but the last entry of the array. Especially useful on
	  // the arguments object. Passing **n** will return all the values in
	  // the array, excluding the last N.
	  _.initial = function(array, n, guard) {
	    return slice.call(array, 0, Math.max(0, array.length - (n == null || guard ? 1 : n)));
	  };

	  // Get the last element of an array. Passing **n** will return the last N
	  // values in the array.
	  _.last = function(array, n, guard) {
	    if (array == null) return void 0;
	    if (n == null || guard) return array[array.length - 1];
	    return _.rest(array, Math.max(0, array.length - n));
	  };

	  // Returns everything but the first entry of the array. Aliased as `tail` and `drop`.
	  // Especially useful on the arguments object. Passing an **n** will return
	  // the rest N values in the array.
	  _.rest = _.tail = _.drop = function(array, n, guard) {
	    return slice.call(array, n == null || guard ? 1 : n);
	  };

	  // Trim out all falsy values from an array.
	  _.compact = function(array) {
	    return _.filter(array, _.identity);
	  };

	  // Internal implementation of a recursive `flatten` function.
	  var flatten = function(input, shallow, strict, startIndex) {
	    var output = [], idx = 0;
	    for (var i = startIndex || 0, length = getLength(input); i < length; i++) {
	      var value = input[i];
	      if (isArrayLike(value) && (_.isArray(value) || _.isArguments(value))) {
	        //flatten current level of array or arguments object
	        if (!shallow) value = flatten(value, shallow, strict);
	        var j = 0, len = value.length;
	        output.length += len;
	        while (j < len) {
	          output[idx++] = value[j++];
	        }
	      } else if (!strict) {
	        output[idx++] = value;
	      }
	    }
	    return output;
	  };

	  // Flatten out an array, either recursively (by default), or just one level.
	  _.flatten = function(array, shallow) {
	    return flatten(array, shallow, false);
	  };

	  // Return a version of the array that does not contain the specified value(s).
	  _.without = function(array) {
	    return _.difference(array, slice.call(arguments, 1));
	  };

	  // Produce a duplicate-free version of the array. If the array has already
	  // been sorted, you have the option of using a faster algorithm.
	  // Aliased as `unique`.
	  _.uniq = _.unique = function(array, isSorted, iteratee, context) {
	    if (!_.isBoolean(isSorted)) {
	      context = iteratee;
	      iteratee = isSorted;
	      isSorted = false;
	    }
	    if (iteratee != null) iteratee = cb(iteratee, context);
	    var result = [];
	    var seen = [];
	    for (var i = 0, length = getLength(array); i < length; i++) {
	      var value = array[i],
	          computed = iteratee ? iteratee(value, i, array) : value;
	      if (isSorted) {
	        if (!i || seen !== computed) result.push(value);
	        seen = computed;
	      } else if (iteratee) {
	        if (!_.contains(seen, computed)) {
	          seen.push(computed);
	          result.push(value);
	        }
	      } else if (!_.contains(result, value)) {
	        result.push(value);
	      }
	    }
	    return result;
	  };

	  // Produce an array that contains the union: each distinct element from all of
	  // the passed-in arrays.
	  _.union = function() {
	    return _.uniq(flatten(arguments, true, true));
	  };

	  // Produce an array that contains every item shared between all the
	  // passed-in arrays.
	  _.intersection = function(array) {
	    var result = [];
	    var argsLength = arguments.length;
	    for (var i = 0, length = getLength(array); i < length; i++) {
	      var item = array[i];
	      if (_.contains(result, item)) continue;
	      for (var j = 1; j < argsLength; j++) {
	        if (!_.contains(arguments[j], item)) break;
	      }
	      if (j === argsLength) result.push(item);
	    }
	    return result;
	  };

	  // Take the difference between one array and a number of other arrays.
	  // Only the elements present in just the first array will remain.
	  _.difference = function(array) {
	    var rest = flatten(arguments, true, true, 1);
	    return _.filter(array, function(value){
	      return !_.contains(rest, value);
	    });
	  };

	  // Zip together multiple lists into a single array -- elements that share
	  // an index go together.
	  _.zip = function() {
	    return _.unzip(arguments);
	  };

	  // Complement of _.zip. Unzip accepts an array of arrays and groups
	  // each array's elements on shared indices
	  _.unzip = function(array) {
	    var length = array && _.max(array, getLength).length || 0;
	    var result = Array(length);

	    for (var index = 0; index < length; index++) {
	      result[index] = _.pluck(array, index);
	    }
	    return result;
	  };

	  // Converts lists into objects. Pass either a single array of `[key, value]`
	  // pairs, or two parallel arrays of the same length -- one of keys, and one of
	  // the corresponding values.
	  _.object = function(list, values) {
	    var result = {};
	    for (var i = 0, length = getLength(list); i < length; i++) {
	      if (values) {
	        result[list[i]] = values[i];
	      } else {
	        result[list[i][0]] = list[i][1];
	      }
	    }
	    return result;
	  };

	  // Generator function to create the findIndex and findLastIndex functions
	  function createPredicateIndexFinder(dir) {
	    return function(array, predicate, context) {
	      predicate = cb(predicate, context);
	      var length = getLength(array);
	      var index = dir > 0 ? 0 : length - 1;
	      for (; index >= 0 && index < length; index += dir) {
	        if (predicate(array[index], index, array)) return index;
	      }
	      return -1;
	    };
	  }

	  // Returns the first index on an array-like that passes a predicate test
	  _.findIndex = createPredicateIndexFinder(1);
	  _.findLastIndex = createPredicateIndexFinder(-1);

	  // Use a comparator function to figure out the smallest index at which
	  // an object should be inserted so as to maintain order. Uses binary search.
	  _.sortedIndex = function(array, obj, iteratee, context) {
	    iteratee = cb(iteratee, context, 1);
	    var value = iteratee(obj);
	    var low = 0, high = getLength(array);
	    while (low < high) {
	      var mid = Math.floor((low + high) / 2);
	      if (iteratee(array[mid]) < value) low = mid + 1; else high = mid;
	    }
	    return low;
	  };

	  // Generator function to create the indexOf and lastIndexOf functions
	  function createIndexFinder(dir, predicateFind, sortedIndex) {
	    return function(array, item, idx) {
	      var i = 0, length = getLength(array);
	      if (typeof idx == 'number') {
	        if (dir > 0) {
	            i = idx >= 0 ? idx : Math.max(idx + length, i);
	        } else {
	            length = idx >= 0 ? Math.min(idx + 1, length) : idx + length + 1;
	        }
	      } else if (sortedIndex && idx && length) {
	        idx = sortedIndex(array, item);
	        return array[idx] === item ? idx : -1;
	      }
	      if (item !== item) {
	        idx = predicateFind(slice.call(array, i, length), _.isNaN);
	        return idx >= 0 ? idx + i : -1;
	      }
	      for (idx = dir > 0 ? i : length - 1; idx >= 0 && idx < length; idx += dir) {
	        if (array[idx] === item) return idx;
	      }
	      return -1;
	    };
	  }

	  // Return the position of the first occurrence of an item in an array,
	  // or -1 if the item is not included in the array.
	  // If the array is large and already in sort order, pass `true`
	  // for **isSorted** to use binary search.
	  _.indexOf = createIndexFinder(1, _.findIndex, _.sortedIndex);
	  _.lastIndexOf = createIndexFinder(-1, _.findLastIndex);

	  // Generate an integer Array containing an arithmetic progression. A port of
	  // the native Python `range()` function. See
	  // [the Python documentation](http://docs.python.org/library/functions.html#range).
	  _.range = function(start, stop, step) {
	    if (stop == null) {
	      stop = start || 0;
	      start = 0;
	    }
	    step = step || 1;

	    var length = Math.max(Math.ceil((stop - start) / step), 0);
	    var range = Array(length);

	    for (var idx = 0; idx < length; idx++, start += step) {
	      range[idx] = start;
	    }

	    return range;
	  };

	  // Function (ahem) Functions
	  // ------------------

	  // Determines whether to execute a function as a constructor
	  // or a normal function with the provided arguments
	  var executeBound = function(sourceFunc, boundFunc, context, callingContext, args) {
	    if (!(callingContext instanceof boundFunc)) return sourceFunc.apply(context, args);
	    var self = baseCreate(sourceFunc.prototype);
	    var result = sourceFunc.apply(self, args);
	    if (_.isObject(result)) return result;
	    return self;
	  };

	  // Create a function bound to a given object (assigning `this`, and arguments,
	  // optionally). Delegates to **ECMAScript 5**'s native `Function.bind` if
	  // available.
	  _.bind = function(func, context) {
	    if (nativeBind && func.bind === nativeBind) return nativeBind.apply(func, slice.call(arguments, 1));
	    if (!_.isFunction(func)) throw new TypeError('Bind must be called on a function');
	    var args = slice.call(arguments, 2);
	    var bound = function() {
	      return executeBound(func, bound, context, this, args.concat(slice.call(arguments)));
	    };
	    return bound;
	  };

	  // Partially apply a function by creating a version that has had some of its
	  // arguments pre-filled, without changing its dynamic `this` context. _ acts
	  // as a placeholder, allowing any combination of arguments to be pre-filled.
	  _.partial = function(func) {
	    var boundArgs = slice.call(arguments, 1);
	    var bound = function() {
	      var position = 0, length = boundArgs.length;
	      var args = Array(length);
	      for (var i = 0; i < length; i++) {
	        args[i] = boundArgs[i] === _ ? arguments[position++] : boundArgs[i];
	      }
	      while (position < arguments.length) args.push(arguments[position++]);
	      return executeBound(func, bound, this, this, args);
	    };
	    return bound;
	  };

	  // Bind a number of an object's methods to that object. Remaining arguments
	  // are the method names to be bound. Useful for ensuring that all callbacks
	  // defined on an object belong to it.
	  _.bindAll = function(obj) {
	    var i, length = arguments.length, key;
	    if (length <= 1) throw new Error('bindAll must be passed function names');
	    for (i = 1; i < length; i++) {
	      key = arguments[i];
	      obj[key] = _.bind(obj[key], obj);
	    }
	    return obj;
	  };

	  // Memoize an expensive function by storing its results.
	  _.memoize = function(func, hasher) {
	    var memoize = function(key) {
	      var cache = memoize.cache;
	      var address = '' + (hasher ? hasher.apply(this, arguments) : key);
	      if (!_.has(cache, address)) cache[address] = func.apply(this, arguments);
	      return cache[address];
	    };
	    memoize.cache = {};
	    return memoize;
	  };

	  // Delays a function for the given number of milliseconds, and then calls
	  // it with the arguments supplied.
	  _.delay = function(func, wait) {
	    var args = slice.call(arguments, 2);
	    return setTimeout(function(){
	      return func.apply(null, args);
	    }, wait);
	  };

	  // Defers a function, scheduling it to run after the current call stack has
	  // cleared.
	  _.defer = _.partial(_.delay, _, 1);

	  // Returns a function, that, when invoked, will only be triggered at most once
	  // during a given window of time. Normally, the throttled function will run
	  // as much as it can, without ever going more than once per `wait` duration;
	  // but if you'd like to disable the execution on the leading edge, pass
	  // `{leading: false}`. To disable execution on the trailing edge, ditto.
	  _.throttle = function(func, wait, options) {
	    var context, args, result;
	    var timeout = null;
	    var previous = 0;
	    if (!options) options = {};
	    var later = function() {
	      previous = options.leading === false ? 0 : _.now();
	      timeout = null;
	      result = func.apply(context, args);
	      if (!timeout) context = args = null;
	    };
	    return function() {
	      var now = _.now();
	      if (!previous && options.leading === false) previous = now;
	      var remaining = wait - (now - previous);
	      context = this;
	      args = arguments;
	      if (remaining <= 0 || remaining > wait) {
	        if (timeout) {
	          clearTimeout(timeout);
	          timeout = null;
	        }
	        previous = now;
	        result = func.apply(context, args);
	        if (!timeout) context = args = null;
	      } else if (!timeout && options.trailing !== false) {
	        timeout = setTimeout(later, remaining);
	      }
	      return result;
	    };
	  };

	  // Returns a function, that, as long as it continues to be invoked, will not
	  // be triggered. The function will be called after it stops being called for
	  // N milliseconds. If `immediate` is passed, trigger the function on the
	  // leading edge, instead of the trailing.
	  _.debounce = function(func, wait, immediate) {
	    var timeout, args, context, timestamp, result;

	    var later = function() {
	      var last = _.now() - timestamp;

	      if (last < wait && last >= 0) {
	        timeout = setTimeout(later, wait - last);
	      } else {
	        timeout = null;
	        if (!immediate) {
	          result = func.apply(context, args);
	          if (!timeout) context = args = null;
	        }
	      }
	    };

	    return function() {
	      context = this;
	      args = arguments;
	      timestamp = _.now();
	      var callNow = immediate && !timeout;
	      if (!timeout) timeout = setTimeout(later, wait);
	      if (callNow) {
	        result = func.apply(context, args);
	        context = args = null;
	      }

	      return result;
	    };
	  };

	  // Returns the first function passed as an argument to the second,
	  // allowing you to adjust arguments, run code before and after, and
	  // conditionally execute the original function.
	  _.wrap = function(func, wrapper) {
	    return _.partial(wrapper, func);
	  };

	  // Returns a negated version of the passed-in predicate.
	  _.negate = function(predicate) {
	    return function() {
	      return !predicate.apply(this, arguments);
	    };
	  };

	  // Returns a function that is the composition of a list of functions, each
	  // consuming the return value of the function that follows.
	  _.compose = function() {
	    var args = arguments;
	    var start = args.length - 1;
	    return function() {
	      var i = start;
	      var result = args[start].apply(this, arguments);
	      while (i--) result = args[i].call(this, result);
	      return result;
	    };
	  };

	  // Returns a function that will only be executed on and after the Nth call.
	  _.after = function(times, func) {
	    return function() {
	      if (--times < 1) {
	        return func.apply(this, arguments);
	      }
	    };
	  };

	  // Returns a function that will only be executed up to (but not including) the Nth call.
	  _.before = function(times, func) {
	    var memo;
	    return function() {
	      if (--times > 0) {
	        memo = func.apply(this, arguments);
	      }
	      if (times <= 1) func = null;
	      return memo;
	    };
	  };

	  // Returns a function that will be executed at most one time, no matter how
	  // often you call it. Useful for lazy initialization.
	  _.once = _.partial(_.before, 2);

	  // Object Functions
	  // ----------------

	  // Keys in IE < 9 that won't be iterated by `for key in ...` and thus missed.
	  var hasEnumBug = !{toString: null}.propertyIsEnumerable('toString');
	  var nonEnumerableProps = ['valueOf', 'isPrototypeOf', 'toString',
	                      'propertyIsEnumerable', 'hasOwnProperty', 'toLocaleString'];

	  function collectNonEnumProps(obj, keys) {
	    var nonEnumIdx = nonEnumerableProps.length;
	    var constructor = obj.constructor;
	    var proto = (_.isFunction(constructor) && constructor.prototype) || ObjProto;

	    // Constructor is a special case.
	    var prop = 'constructor';
	    if (_.has(obj, prop) && !_.contains(keys, prop)) keys.push(prop);

	    while (nonEnumIdx--) {
	      prop = nonEnumerableProps[nonEnumIdx];
	      if (prop in obj && obj[prop] !== proto[prop] && !_.contains(keys, prop)) {
	        keys.push(prop);
	      }
	    }
	  }

	  // Retrieve the names of an object's own properties.
	  // Delegates to **ECMAScript 5**'s native `Object.keys`
	  _.keys = function(obj) {
	    if (!_.isObject(obj)) return [];
	    if (nativeKeys) return nativeKeys(obj);
	    var keys = [];
	    for (var key in obj) if (_.has(obj, key)) keys.push(key);
	    // Ahem, IE < 9.
	    if (hasEnumBug) collectNonEnumProps(obj, keys);
	    return keys;
	  };

	  // Retrieve all the property names of an object.
	  _.allKeys = function(obj) {
	    if (!_.isObject(obj)) return [];
	    var keys = [];
	    for (var key in obj) keys.push(key);
	    // Ahem, IE < 9.
	    if (hasEnumBug) collectNonEnumProps(obj, keys);
	    return keys;
	  };

	  // Retrieve the values of an object's properties.
	  _.values = function(obj) {
	    var keys = _.keys(obj);
	    var length = keys.length;
	    var values = Array(length);
	    for (var i = 0; i < length; i++) {
	      values[i] = obj[keys[i]];
	    }
	    return values;
	  };

	  // Returns the results of applying the iteratee to each element of the object
	  // In contrast to _.map it returns an object
	  _.mapObject = function(obj, iteratee, context) {
	    iteratee = cb(iteratee, context);
	    var keys =  _.keys(obj),
	          length = keys.length,
	          results = {},
	          currentKey;
	      for (var index = 0; index < length; index++) {
	        currentKey = keys[index];
	        results[currentKey] = iteratee(obj[currentKey], currentKey, obj);
	      }
	      return results;
	  };

	  // Convert an object into a list of `[key, value]` pairs.
	  _.pairs = function(obj) {
	    var keys = _.keys(obj);
	    var length = keys.length;
	    var pairs = Array(length);
	    for (var i = 0; i < length; i++) {
	      pairs[i] = [keys[i], obj[keys[i]]];
	    }
	    return pairs;
	  };

	  // Invert the keys and values of an object. The values must be serializable.
	  _.invert = function(obj) {
	    var result = {};
	    var keys = _.keys(obj);
	    for (var i = 0, length = keys.length; i < length; i++) {
	      result[obj[keys[i]]] = keys[i];
	    }
	    return result;
	  };

	  // Return a sorted list of the function names available on the object.
	  // Aliased as `methods`
	  _.functions = _.methods = function(obj) {
	    var names = [];
	    for (var key in obj) {
	      if (_.isFunction(obj[key])) names.push(key);
	    }
	    return names.sort();
	  };

	  // Extend a given object with all the properties in passed-in object(s).
	  _.extend = createAssigner(_.allKeys);

	  // Assigns a given object with all the own properties in the passed-in object(s)
	  // (https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object/assign)
	  _.extendOwn = _.assign = createAssigner(_.keys);

	  // Returns the first key on an object that passes a predicate test
	  _.findKey = function(obj, predicate, context) {
	    predicate = cb(predicate, context);
	    var keys = _.keys(obj), key;
	    for (var i = 0, length = keys.length; i < length; i++) {
	      key = keys[i];
	      if (predicate(obj[key], key, obj)) return key;
	    }
	  };

	  // Return a copy of the object only containing the whitelisted properties.
	  _.pick = function(object, oiteratee, context) {
	    var result = {}, obj = object, iteratee, keys;
	    if (obj == null) return result;
	    if (_.isFunction(oiteratee)) {
	      keys = _.allKeys(obj);
	      iteratee = optimizeCb(oiteratee, context);
	    } else {
	      keys = flatten(arguments, false, false, 1);
	      iteratee = function(value, key, obj) { return key in obj; };
	      obj = Object(obj);
	    }
	    for (var i = 0, length = keys.length; i < length; i++) {
	      var key = keys[i];
	      var value = obj[key];
	      if (iteratee(value, key, obj)) result[key] = value;
	    }
	    return result;
	  };

	   // Return a copy of the object without the blacklisted properties.
	  _.omit = function(obj, iteratee, context) {
	    if (_.isFunction(iteratee)) {
	      iteratee = _.negate(iteratee);
	    } else {
	      var keys = _.map(flatten(arguments, false, false, 1), String);
	      iteratee = function(value, key) {
	        return !_.contains(keys, key);
	      };
	    }
	    return _.pick(obj, iteratee, context);
	  };

	  // Fill in a given object with default properties.
	  _.defaults = createAssigner(_.allKeys, true);

	  // Creates an object that inherits from the given prototype object.
	  // If additional properties are provided then they will be added to the
	  // created object.
	  _.create = function(prototype, props) {
	    var result = baseCreate(prototype);
	    if (props) _.extendOwn(result, props);
	    return result;
	  };

	  // Create a (shallow-cloned) duplicate of an object.
	  _.clone = function(obj) {
	    if (!_.isObject(obj)) return obj;
	    return _.isArray(obj) ? obj.slice() : _.extend({}, obj);
	  };

	  // Invokes interceptor with the obj, and then returns obj.
	  // The primary purpose of this method is to "tap into" a method chain, in
	  // order to perform operations on intermediate results within the chain.
	  _.tap = function(obj, interceptor) {
	    interceptor(obj);
	    return obj;
	  };

	  // Returns whether an object has a given set of `key:value` pairs.
	  _.isMatch = function(object, attrs) {
	    var keys = _.keys(attrs), length = keys.length;
	    if (object == null) return !length;
	    var obj = Object(object);
	    for (var i = 0; i < length; i++) {
	      var key = keys[i];
	      if (attrs[key] !== obj[key] || !(key in obj)) return false;
	    }
	    return true;
	  };


	  // Internal recursive comparison function for `isEqual`.
	  var eq = function(a, b, aStack, bStack) {
	    // Identical objects are equal. `0 === -0`, but they aren't identical.
	    // See the [Harmony `egal` proposal](http://wiki.ecmascript.org/doku.php?id=harmony:egal).
	    if (a === b) return a !== 0 || 1 / a === 1 / b;
	    // A strict comparison is necessary because `null == undefined`.
	    if (a == null || b == null) return a === b;
	    // Unwrap any wrapped objects.
	    if (a instanceof _) a = a._wrapped;
	    if (b instanceof _) b = b._wrapped;
	    // Compare `[[Class]]` names.
	    var className = toString.call(a);
	    if (className !== toString.call(b)) return false;
	    switch (className) {
	      // Strings, numbers, regular expressions, dates, and booleans are compared by value.
	      case '[object RegExp]':
	      // RegExps are coerced to strings for comparison (Note: '' + /a/i === '/a/i')
	      case '[object String]':
	        // Primitives and their corresponding object wrappers are equivalent; thus, `"5"` is
	        // equivalent to `new String("5")`.
	        return '' + a === '' + b;
	      case '[object Number]':
	        // `NaN`s are equivalent, but non-reflexive.
	        // Object(NaN) is equivalent to NaN
	        if (+a !== +a) return +b !== +b;
	        // An `egal` comparison is performed for other numeric values.
	        return +a === 0 ? 1 / +a === 1 / b : +a === +b;
	      case '[object Date]':
	      case '[object Boolean]':
	        // Coerce dates and booleans to numeric primitive values. Dates are compared by their
	        // millisecond representations. Note that invalid dates with millisecond representations
	        // of `NaN` are not equivalent.
	        return +a === +b;
	    }

	    var areArrays = className === '[object Array]';
	    if (!areArrays) {
	      if (typeof a != 'object' || typeof b != 'object') return false;

	      // Objects with different constructors are not equivalent, but `Object`s or `Array`s
	      // from different frames are.
	      var aCtor = a.constructor, bCtor = b.constructor;
	      if (aCtor !== bCtor && !(_.isFunction(aCtor) && aCtor instanceof aCtor &&
	                               _.isFunction(bCtor) && bCtor instanceof bCtor)
	                          && ('constructor' in a && 'constructor' in b)) {
	        return false;
	      }
	    }
	    // Assume equality for cyclic structures. The algorithm for detecting cyclic
	    // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.

	    // Initializing stack of traversed objects.
	    // It's done here since we only need them for objects and arrays comparison.
	    aStack = aStack || [];
	    bStack = bStack || [];
	    var length = aStack.length;
	    while (length--) {
	      // Linear search. Performance is inversely proportional to the number of
	      // unique nested structures.
	      if (aStack[length] === a) return bStack[length] === b;
	    }

	    // Add the first object to the stack of traversed objects.
	    aStack.push(a);
	    bStack.push(b);

	    // Recursively compare objects and arrays.
	    if (areArrays) {
	      // Compare array lengths to determine if a deep comparison is necessary.
	      length = a.length;
	      if (length !== b.length) return false;
	      // Deep compare the contents, ignoring non-numeric properties.
	      while (length--) {
	        if (!eq(a[length], b[length], aStack, bStack)) return false;
	      }
	    } else {
	      // Deep compare objects.
	      var keys = _.keys(a), key;
	      length = keys.length;
	      // Ensure that both objects contain the same number of properties before comparing deep equality.
	      if (_.keys(b).length !== length) return false;
	      while (length--) {
	        // Deep compare each member
	        key = keys[length];
	        if (!(_.has(b, key) && eq(a[key], b[key], aStack, bStack))) return false;
	      }
	    }
	    // Remove the first object from the stack of traversed objects.
	    aStack.pop();
	    bStack.pop();
	    return true;
	  };

	  // Perform a deep comparison to check if two objects are equal.
	  _.isEqual = function(a, b) {
	    return eq(a, b);
	  };

	  // Is a given array, string, or object empty?
	  // An "empty" object has no enumerable own-properties.
	  _.isEmpty = function(obj) {
	    if (obj == null) return true;
	    if (isArrayLike(obj) && (_.isArray(obj) || _.isString(obj) || _.isArguments(obj))) return obj.length === 0;
	    return _.keys(obj).length === 0;
	  };

	  // Is a given value a DOM element?
	  _.isElement = function(obj) {
	    return !!(obj && obj.nodeType === 1);
	  };

	  // Is a given value an array?
	  // Delegates to ECMA5's native Array.isArray
	  _.isArray = nativeIsArray || function(obj) {
	    return toString.call(obj) === '[object Array]';
	  };

	  // Is a given variable an object?
	  _.isObject = function(obj) {
	    var type = typeof obj;
	    return type === 'function' || type === 'object' && !!obj;
	  };

	  // Add some isType methods: isArguments, isFunction, isString, isNumber, isDate, isRegExp, isError.
	  _.each(['Arguments', 'Function', 'String', 'Number', 'Date', 'RegExp', 'Error'], function(name) {
	    _['is' + name] = function(obj) {
	      return toString.call(obj) === '[object ' + name + ']';
	    };
	  });

	  // Define a fallback version of the method in browsers (ahem, IE < 9), where
	  // there isn't any inspectable "Arguments" type.
	  if (!_.isArguments(arguments)) {
	    _.isArguments = function(obj) {
	      return _.has(obj, 'callee');
	    };
	  }

	  // Optimize `isFunction` if appropriate. Work around some typeof bugs in old v8,
	  // IE 11 (#1621), and in Safari 8 (#1929).
	  if (typeof /./ != 'function' && typeof Int8Array != 'object') {
	    _.isFunction = function(obj) {
	      return typeof obj == 'function' || false;
	    };
	  }

	  // Is a given object a finite number?
	  _.isFinite = function(obj) {
	    return isFinite(obj) && !isNaN(parseFloat(obj));
	  };

	  // Is the given value `NaN`? (NaN is the only number which does not equal itself).
	  _.isNaN = function(obj) {
	    return _.isNumber(obj) && obj !== +obj;
	  };

	  // Is a given value a boolean?
	  _.isBoolean = function(obj) {
	    return obj === true || obj === false || toString.call(obj) === '[object Boolean]';
	  };

	  // Is a given value equal to null?
	  _.isNull = function(obj) {
	    return obj === null;
	  };

	  // Is a given variable undefined?
	  _.isUndefined = function(obj) {
	    return obj === void 0;
	  };

	  // Shortcut function for checking if an object has a given property directly
	  // on itself (in other words, not on a prototype).
	  _.has = function(obj, key) {
	    return obj != null && hasOwnProperty.call(obj, key);
	  };

	  // Utility Functions
	  // -----------------

	  // Run Underscore.js in *noConflict* mode, returning the `_` variable to its
	  // previous owner. Returns a reference to the Underscore object.
	  _.noConflict = function() {
	    root._ = previousUnderscore;
	    return this;
	  };

	  // Keep the identity function around for default iteratees.
	  _.identity = function(value) {
	    return value;
	  };

	  // Predicate-generating functions. Often useful outside of Underscore.
	  _.constant = function(value) {
	    return function() {
	      return value;
	    };
	  };

	  _.noop = function(){};

	  _.property = property;

	  // Generates a function for a given object that returns a given property.
	  _.propertyOf = function(obj) {
	    return obj == null ? function(){} : function(key) {
	      return obj[key];
	    };
	  };

	  // Returns a predicate for checking whether an object has a given set of
	  // `key:value` pairs.
	  _.matcher = _.matches = function(attrs) {
	    attrs = _.extendOwn({}, attrs);
	    return function(obj) {
	      return _.isMatch(obj, attrs);
	    };
	  };

	  // Run a function **n** times.
	  _.times = function(n, iteratee, context) {
	    var accum = Array(Math.max(0, n));
	    iteratee = optimizeCb(iteratee, context, 1);
	    for (var i = 0; i < n; i++) accum[i] = iteratee(i);
	    return accum;
	  };

	  // Return a random integer between min and max (inclusive).
	  _.random = function(min, max) {
	    if (max == null) {
	      max = min;
	      min = 0;
	    }
	    return min + Math.floor(Math.random() * (max - min + 1));
	  };

	  // A (possibly faster) way to get the current timestamp as an integer.
	  _.now = Date.now || function() {
	    return new Date().getTime();
	  };

	   // List of HTML entities for escaping.
	  var escapeMap = {
	    '&': '&amp;',
	    '<': '&lt;',
	    '>': '&gt;',
	    '"': '&quot;',
	    "'": '&#x27;',
	    '`': '&#x60;'
	  };
	  var unescapeMap = _.invert(escapeMap);

	  // Functions for escaping and unescaping strings to/from HTML interpolation.
	  var createEscaper = function(map) {
	    var escaper = function(match) {
	      return map[match];
	    };
	    // Regexes for identifying a key that needs to be escaped
	    var source = '(?:' + _.keys(map).join('|') + ')';
	    var testRegexp = RegExp(source);
	    var replaceRegexp = RegExp(source, 'g');
	    return function(string) {
	      string = string == null ? '' : '' + string;
	      return testRegexp.test(string) ? string.replace(replaceRegexp, escaper) : string;
	    };
	  };
	  _.escape = createEscaper(escapeMap);
	  _.unescape = createEscaper(unescapeMap);

	  // If the value of the named `property` is a function then invoke it with the
	  // `object` as context; otherwise, return it.
	  _.result = function(object, property, fallback) {
	    var value = object == null ? void 0 : object[property];
	    if (value === void 0) {
	      value = fallback;
	    }
	    return _.isFunction(value) ? value.call(object) : value;
	  };

	  // Generate a unique integer id (unique within the entire client session).
	  // Useful for temporary DOM ids.
	  var idCounter = 0;
	  _.uniqueId = function(prefix) {
	    var id = ++idCounter + '';
	    return prefix ? prefix + id : id;
	  };

	  // By default, Underscore uses ERB-style template delimiters, change the
	  // following template settings to use alternative delimiters.
	  _.templateSettings = {
	    evaluate    : /<%([\s\S]+?)%>/g,
	    interpolate : /<%=([\s\S]+?)%>/g,
	    escape      : /<%-([\s\S]+?)%>/g
	  };

	  // When customizing `templateSettings`, if you don't want to define an
	  // interpolation, evaluation or escaping regex, we need one that is
	  // guaranteed not to match.
	  var noMatch = /(.)^/;

	  // Certain characters need to be escaped so that they can be put into a
	  // string literal.
	  var escapes = {
	    "'":      "'",
	    '\\':     '\\',
	    '\r':     'r',
	    '\n':     'n',
	    '\u2028': 'u2028',
	    '\u2029': 'u2029'
	  };

	  var escaper = /\\|'|\r|\n|\u2028|\u2029/g;

	  var escapeChar = function(match) {
	    return '\\' + escapes[match];
	  };

	  // JavaScript micro-templating, similar to John Resig's implementation.
	  // Underscore templating handles arbitrary delimiters, preserves whitespace,
	  // and correctly escapes quotes within interpolated code.
	  // NB: `oldSettings` only exists for backwards compatibility.
	  _.template = function(text, settings, oldSettings) {
	    if (!settings && oldSettings) settings = oldSettings;
	    settings = _.defaults({}, settings, _.templateSettings);

	    // Combine delimiters into one regular expression via alternation.
	    var matcher = RegExp([
	      (settings.escape || noMatch).source,
	      (settings.interpolate || noMatch).source,
	      (settings.evaluate || noMatch).source
	    ].join('|') + '|$', 'g');

	    // Compile the template source, escaping string literals appropriately.
	    var index = 0;
	    var source = "__p+='";
	    text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {
	      source += text.slice(index, offset).replace(escaper, escapeChar);
	      index = offset + match.length;

	      if (escape) {
	        source += "'+\n((__t=(" + escape + "))==null?'':_.escape(__t))+\n'";
	      } else if (interpolate) {
	        source += "'+\n((__t=(" + interpolate + "))==null?'':__t)+\n'";
	      } else if (evaluate) {
	        source += "';\n" + evaluate + "\n__p+='";
	      }

	      // Adobe VMs need the match returned to produce the correct offest.
	      return match;
	    });
	    source += "';\n";

	    // If a variable is not specified, place data values in local scope.
	    if (!settings.variable) source = 'with(obj||{}){\n' + source + '}\n';

	    source = "var __t,__p='',__j=Array.prototype.join," +
	      "print=function(){__p+=__j.call(arguments,'');};\n" +
	      source + 'return __p;\n';

	    try {
	      var render = new Function(settings.variable || 'obj', '_', source);
	    } catch (e) {
	      e.source = source;
	      throw e;
	    }

	    var template = function(data) {
	      return render.call(this, data, _);
	    };

	    // Provide the compiled source as a convenience for precompilation.
	    var argument = settings.variable || 'obj';
	    template.source = 'function(' + argument + '){\n' + source + '}';

	    return template;
	  };

	  // Add a "chain" function. Start chaining a wrapped Underscore object.
	  _.chain = function(obj) {
	    var instance = _(obj);
	    instance._chain = true;
	    return instance;
	  };

	  // OOP
	  // ---------------
	  // If Underscore is called as a function, it returns a wrapped object that
	  // can be used OO-style. This wrapper holds altered versions of all the
	  // underscore functions. Wrapped objects may be chained.

	  // Helper function to continue chaining intermediate results.
	  var result = function(instance, obj) {
	    return instance._chain ? _(obj).chain() : obj;
	  };

	  // Add your own custom functions to the Underscore object.
	  _.mixin = function(obj) {
	    _.each(_.functions(obj), function(name) {
	      var func = _[name] = obj[name];
	      _.prototype[name] = function() {
	        var args = [this._wrapped];
	        push.apply(args, arguments);
	        return result(this, func.apply(_, args));
	      };
	    });
	  };

	  // Add all of the Underscore functions to the wrapper object.
	  _.mixin(_);

	  // Add all mutator Array functions to the wrapper.
	  _.each(['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'], function(name) {
	    var method = ArrayProto[name];
	    _.prototype[name] = function() {
	      var obj = this._wrapped;
	      method.apply(obj, arguments);
	      if ((name === 'shift' || name === 'splice') && obj.length === 0) delete obj[0];
	      return result(this, obj);
	    };
	  });

	  // Add all accessor Array functions to the wrapper.
	  _.each(['concat', 'join', 'slice'], function(name) {
	    var method = ArrayProto[name];
	    _.prototype[name] = function() {
	      return result(this, method.apply(this._wrapped, arguments));
	    };
	  });

	  // Extracts the result from a wrapped and chained object.
	  _.prototype.value = function() {
	    return this._wrapped;
	  };

	  // Provide unwrapping proxy for some methods used in engine operations
	  // such as arithmetic and JSON stringification.
	  _.prototype.valueOf = _.prototype.toJSON = _.prototype.value;

	  _.prototype.toString = function() {
	    return '' + this._wrapped;
	  };

	  // AMD registration happens at the end for compatibility with AMD loaders
	  // that may not enforce next-turn semantics on modules. Even though general
	  // practice for AMD registration is to be anonymous, underscore registers
	  // as a named module because, like jQuery, it is a base library that is
	  // popular enough to be bundled in a third party lib, but not be part of
	  // an AMD load request. Those cases could generate an error when an
	  // anonymous define() is called outside of a loader request.
	  if (true) {
	    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function() {
	      return _;
	    }.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	  }
	}.call(this));


/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global) {(function() {
	  var vm,
	    __slice = [].slice;

	  vm = __webpack_require__(103);

	  exports.allowUnsafeEval = function(fn) {
	    var previousEval;
	    previousEval = global["eval"];
	    try {
	      global["eval"] = function(source) {
	        return vm.runInThisContext(source);
	      };
	      return fn();
	    } finally {
	      global["eval"] = previousEval;
	    }
	  };

	  exports.allowUnsafeNewFunction = function(fn) {
	    var previousFunction;
	    previousFunction = global.Function;
	    try {
	      global.Function = exports.Function;
	      return fn();
	    } finally {
	      global.Function = previousFunction;
	    }
	  };

	  exports.Function = function() {
	    var body, paramList, paramLists, params, _i, _j, _len;
	    paramLists = 2 <= arguments.length ? __slice.call(arguments, 0, _i = arguments.length - 1) : (_i = 0, []), body = arguments[_i++];
	    params = [];
	    for (_j = 0, _len = paramLists.length; _j < _len; _j++) {
	      paramList = paramLists[_j];
	      if (typeof paramList === 'string') {
	        paramList = paramList.split(/\s*,\s*/);
	      }
	      params.push.apply(params, paramList);
	    }
	    return vm.runInThisContext("(function(" + (params.join(', ')) + ") {\n  " + body + "\n})");
	  };

	}).call(this);

	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
		{
			"classes": [
				{
					"name": "GlobalSchema",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [
						{
							"typeName": "Sys.Referencable",
							"nameSpace": "Sys",
							"basicName": "Referencable",
							"typeKind": 0,
							"typeArguments": [
								{
									"typeName": "Sys.SchemaString",
									"nameSpace": "Sys",
									"basicName": "SchemaString",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								}
							],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
						}
					],
					"fields": [
						{
							"name": "key",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.key",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Name of the global schema, used to refer on schema content"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "value",
							"type": {
								"typeName": "Sys.SchemaString",
								"nameSpace": "Sys",
								"basicName": "SchemaString",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"Content of the schema"
									]
								},
								{
									"name": "MetaModel.canBeValue",
									"arguments": []
								},
								{
									"name": "MetaModel.value",
									"arguments": []
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.actuallyExports",
							"arguments": [
								"value"
							]
						},
						{
							"name": "MetaModel.description",
							"arguments": [
								"Content of the schema"
							]
						}
					],
					"extends": [
						{
							"typeName": "Common.RAMLSimpleElement",
							"nameSpace": "Common",
							"basicName": "RAMLSimpleElement",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "ImportDeclaration",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "key",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.key",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Name prefix (without dot) used to refer imported declarations"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "value",
							"type": {
								"typeName": "Library",
								"nameSpace": "",
								"basicName": "Library",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"Content of the declared namespace"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "Common.RAMLSimpleElement",
							"nameSpace": "Common",
							"basicName": "RAMLSimpleElement",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "Library",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "name",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.key",
									"arguments": []
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "schemas",
							"type": {
								"base": {
									"typeName": "GlobalSchema",
									"nameSpace": "",
									"basicName": "GlobalSchema",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Alias for the types property, for compatibility with RAML 0.8. Deprecated - may be removed in a future RAML version."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										""
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "usage",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"contains description of why library exist"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "annotations",
							"type": {
								"base": {
									"typeName": "Decls.AnnotationRef",
									"nameSpace": "Decls",
									"basicName": "AnnotationRef",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.version",
									"arguments": [
										"MetaModel.RAMLVersion.RAML10"
									]
								},
								{
									"name": "MetaModel.noDirectParse",
									"arguments": []
								},
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"locationKind",
										"datamodel.LocationKind.APISTRUCTURE"
									]
								},
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"location",
										"datamodel.ModelLocation.ANNOTATION"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Most of RAML model elements may have attached annotations decribing additional meta data about this element"
									]
								},
								{
									"name": "MetaModel.documentationTableLabel",
									"arguments": [
										"(&lt;annotationName&gt;)"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"A value corresponding to the declared type of this annotation."
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "types",
							"type": {
								"base": {
									"typeName": "models.DataElement",
									"nameSpace": "models",
									"basicName": "DataElement",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"locationKind",
										"models.LocationKind.MODELS"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Declarations of (data) types for use within this API"
									]
								},
								{
									"name": "MetaModel.markdownDescription",
									"arguments": [
										"Declarations of (data) types for use within this API. See [[raml-10-spec-types|Types]]."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An object whose properties map type names to type declarations; or an array of such objects"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "traits",
							"type": {
								"base": {
									"typeName": "RM.Trait",
									"nameSpace": "RM",
									"basicName": "Trait",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Declarations of traits used in this API"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Declarations of traits for use within this API"
									]
								},
								{
									"name": "MetaModel.markdownDescription",
									"arguments": [
										"Declarations of traits for use within this API. See [[raml-10-spec-resource-types-and-traits|Resource Types and Traits]]."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An object whose properties map trait names to trait declarations; or an array of such objects"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "resourceTypes",
							"type": {
								"base": {
									"typeName": "RM.ResourceType",
									"nameSpace": "RM",
									"basicName": "ResourceType",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Declaration of resource types used in this API"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Declarations of resource types for use within this API"
									]
								},
								{
									"name": "MetaModel.markdownDescription",
									"arguments": [
										"Declarations of resource types for use within this API. See [[raml-10-spec-resource-types-and-traits|Resource Types and Traits]]."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An object whose properties map resource type names to resource type declarations; or an array of such objects"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "annotationTypes",
							"type": {
								"base": {
									"typeName": "Decls.AnnotationType",
									"nameSpace": "Decls",
									"basicName": "AnnotationType",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.version",
									"arguments": [
										"MetaModel.RAMLVersion.RAML10"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Declarations of annotation types for use by annotations"
									]
								},
								{
									"name": "MetaModel.markdownDescription",
									"arguments": [
										"Declarations of annotation types for use by annotations. See [[raml-10-spec-declaring-annotation-types|Annotation Types]]."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An object whose properties map annotation type names to annotation type declarations; or an array of such objects"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "securitySchemaTypes",
							"type": {
								"base": {
									"typeName": "RM.SecuritySchemaType",
									"nameSpace": "RM",
									"basicName": "SecuritySchemaType",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Security schemas types declarations"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "securitySchemes",
							"type": {
								"base": {
									"typeName": "RM.SecuritySchema",
									"nameSpace": "RM",
									"basicName": "SecuritySchema",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Security schemas declarations"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Declarations of security schemes for use within this API."
									]
								},
								{
									"name": "MetaModel.markdownDescription",
									"arguments": [
										"Declarations of security schemes for use within this API. See [[raml-10-spec-security|Security Schemes]]."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An object whose properties map security scheme names to security scheme declarations; or an array of such objects"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "uses",
							"type": {
								"base": {
									"typeName": "Library",
									"nameSpace": "",
									"basicName": "Library",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Importing libraries"
									]
								},
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"decls",
										"true"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An array of libraries"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [],
					"extends": [],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "OLibrary",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "name",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.key",
									"arguments": []
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "schemas",
							"type": {
								"base": {
									"typeName": "GlobalSchema",
									"nameSpace": "",
									"basicName": "GlobalSchema",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Alias for the types property, for compatibility with RAML 0.8. Deprecated - may be removed in a future RAML version."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										""
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "types",
							"type": {
								"base": {
									"typeName": "models.DataElement",
									"nameSpace": "models",
									"basicName": "DataElement",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"locationKind",
										"models.LocationKind.MODELS"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Declarations of (data) types for use within this API"
									]
								},
								{
									"name": "MetaModel.markdownDescription",
									"arguments": [
										"Declarations of (data) types for use within this API. See [[raml-10-spec-types|Types]]."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An object whose properties map type names to type declarations; or an array of such objects"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "traits",
							"type": {
								"base": {
									"typeName": "RM.Trait",
									"nameSpace": "RM",
									"basicName": "Trait",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Declarations of traits used in this API"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Declarations of traits for use within this API"
									]
								},
								{
									"name": "MetaModel.markdownDescription",
									"arguments": [
										"Declarations of traits for use within this API. See [[raml-10-spec-resource-types-and-traits|Resource Types and Traits]]."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An object whose properties map trait names to trait declarations; or an array of such objects"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "resourceTypes",
							"type": {
								"base": {
									"typeName": "RM.ResourceType",
									"nameSpace": "RM",
									"basicName": "ResourceType",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Declaration of resource types used in this API"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Declarations of resource types for use within this API"
									]
								},
								{
									"name": "MetaModel.markdownDescription",
									"arguments": [
										"Declarations of resource types for use within this API. See [[raml-10-spec-resource-types-and-traits|Resource Types and Traits]]."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An object whose properties map resource type names to resource type declarations; or an array of such objects"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "annotationTypes",
							"type": {
								"base": {
									"typeName": "Decls.AnnotationType",
									"nameSpace": "Decls",
									"basicName": "AnnotationType",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"decls",
										"true"
									]
								},
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.version",
									"arguments": [
										"MetaModel.RAMLVersion.RAML10"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Declarations of annotation types for use by annotations"
									]
								},
								{
									"name": "MetaModel.markdownDescription",
									"arguments": [
										"Declarations of annotation types for use by annotations. See [[raml-10-spec-declaring-annotation-types|Annotation Types]]."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An object whose properties map annotation type names to annotation type declarations; or an array of such objects"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "securitySchemaTypes",
							"type": {
								"base": {
									"typeName": "RM.SecuritySchemaType",
									"nameSpace": "RM",
									"basicName": "SecuritySchemaType",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Security schemas types declarations"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "securitySchemes",
							"type": {
								"base": {
									"typeName": "RM.SecuritySchema",
									"nameSpace": "RM",
									"basicName": "SecuritySchema",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Security schemas declarations"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Declarations of security schemes for use within this API."
									]
								},
								{
									"name": "MetaModel.markdownDescription",
									"arguments": [
										"Declarations of security schemes for use within this API. See [[raml-10-spec-security|Security Schemes]]."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An object whose properties map security scheme names to security scheme declarations; or an array of such objects"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "uses",
							"type": {
								"base": {
									"typeName": "Library",
									"nameSpace": "",
									"basicName": "Library",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Importing libraries"
									]
								},
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"decls",
										"true"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An array of libraries or a single library"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "Common.RAMLLanguageElement",
							"nameSpace": "Common",
							"basicName": "RAMLLanguageElement",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "Overlay",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "usage",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"contains description of why overlay exist"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "masterRef",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.required",
									"arguments": []
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "title",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"Short plain-text label for the API"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "Api",
							"nameSpace": "",
							"basicName": "Api",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "Extension",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "usage",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"contains description of why extension exist"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "masterRef",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.required",
									"arguments": []
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "title",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"Short plain-text label for the API"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "Api",
							"nameSpace": "",
							"basicName": "Api",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "Api",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "title",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.required",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Short plain-text label for the API"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "version",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"The version of the API, e.g. \"v1\""
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "baseUri",
							"type": {
								"typeName": "Sys.FullUriTemplate",
								"nameSpace": "Sys",
								"basicName": "FullUriTemplate",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"A URI that's to be used as the base of all the resources' URIs. Often used as the base of the URL of each resource, containing the location of the API. Can be a template URI."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"URI template string"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "baseUriParameters",
							"type": {
								"base": {
									"typeName": "models.DataElement",
									"nameSpace": "models",
									"basicName": "DataElement",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"location",
										"models.ModelLocation.BURI"
									]
								},
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"locationKind",
										"models.LocationKind.APISTRUCTURE"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Named parameters used in the baseUri (template)"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"Object whose properties are base URI parameter names"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "protocols",
							"type": {
								"base": {
									"typeName": "string",
									"nameSpace": "",
									"basicName": "string",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": null
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.oneOf",
									"arguments": [
										[
											"HTTP",
											"HTTPS"
										]
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"The protocols supported by the API"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"Array of strings, with each being \"HTTP\" or \"HTTPS\", case-insensitive"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "mediaType",
							"type": {
								"typeName": "Bodies.MimeType",
								"nameSpace": "Bodies",
								"basicName": "MimeType",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
							},
							"annotations": [
								{
									"name": "MetaModel.oftenKeys",
									"arguments": [
										[
											"application/json",
											"application/xml",
											"application/x-www-form-urlencoded",
											"multipart/formdata"
										]
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"The default media type to use for request and response bodies (payloads), e.g. \"application/json\""
									]
								},
								{
									"name": "MetaModel.inherited",
									"arguments": []
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"Media type string"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "securedBy",
							"type": {
								"base": {
									"typeName": "RM.SecuritySchemaRef",
									"nameSpace": "RM",
									"basicName": "SecuritySchemaRef",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"The security schemes that apply to every resource and method in the API"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"Array of security scheme names or a single security scheme name"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "resources",
							"type": {
								"base": {
									"typeName": "RM.Resource",
									"nameSpace": "RM",
									"basicName": "Resource",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.documentationTableLabel",
									"arguments": [
										"/&lt;relativeUri&gt;"
									]
								},
								{
									"name": "MetaModel.newInstanceName",
									"arguments": [
										"New Resource"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"The resources of the API, identified as relative URIs that begin with a slash (/). Every property whose key begins with a slash (/), and is either at the root of the API definition or is the child property of a resource property, is a resource property, e.g.: /users, /{groupId}, etc"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"Object whose properties describe the resource"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "documentation",
							"type": {
								"base": {
									"typeName": "DocumentationItem",
									"nameSpace": "",
									"basicName": "DocumentationItem",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"Additional overall documentation for the API"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An array of document objects (or a single document object), each having exactly two string-valued properties: title and content."
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "OLibrary",
							"nameSpace": "",
							"basicName": "OLibrary",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {
						"displayName": [
							{
								"name": "MetaModel.hide",
								"arguments": []
							}
						],
						"name": [
							{
								"name": "MetaModel.hide",
								"arguments": []
							}
						],
						"description": [
							{
								"name": "MetaModel.description",
								"arguments": [
									"A longer, human-friendly description of the API"
								]
							}
						],
						"annotations": [
							{
								"name": "MetaModel.markdownDescription",
								"arguments": [
									"Annotations to be applied to this API. Annotations are any property whose key begins with \"(\" and ends with \")\" and whose name (the part between the beginning and ending parentheses) is a declared annotation name. See the [[raml-10-spec-annotations|section on annotations]]."
								]
							}
						],
						"securitySchemaTypes": [
							{
								"name": "MetaModel.hide",
								"arguments": []
							}
						]
					}
				},
				{
					"name": "DocumentationItem",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "title",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"Title of documentation section"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "content",
							"type": {
								"typeName": "Sys.MarkdownString",
								"nameSpace": "Sys",
								"basicName": "MarkdownString",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"Content of documentation section"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"markdown string"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "Common.RAMLLanguageElement",
							"nameSpace": "Common",
							"basicName": "RAMLLanguageElement",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "ScriptSpec",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "language",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "content",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "Common.RAMLLanguageElement",
							"nameSpace": "Common",
							"basicName": "RAMLLanguageElement",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "ApiDescription",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "apiFiles",
							"type": {
								"base": {
									"typeName": "Api",
									"nameSpace": "",
									"basicName": "Api",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "script",
							"type": {
								"base": {
									"typeName": "ScriptSpec",
									"nameSpace": "",
									"basicName": "ScriptSpec",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "type",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.oneOf",
									"arguments": [
										[
											"endpoint",
											"callback"
										]
									]
								},
								{
									"name": "MetaModel.descriminatingProperty",
									"arguments": []
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "Common.RAMLLanguageElement",
							"nameSpace": "Common",
							"basicName": "RAMLLanguageElement",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "CallbackAPIDescription",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "type",
							"type": null,
							"annotations": [],
							"valueConstraint": {
								"isCallConstraint": false,
								"value": "callback"
							},
							"optional": false
						},
						{
							"name": "callbackFor",
							"type": {
								"typeName": "Api",
								"nameSpace": "",
								"basicName": "Api",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "ApiDescription",
							"nameSpace": "",
							"basicName": "ApiDescription",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "RAMLProject",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "relatedProjects",
							"type": {
								"base": {
									"typeName": "RAMLProject",
									"nameSpace": "",
									"basicName": "RAMLProject",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "declaredApis",
							"type": {
								"base": {
									"typeName": "ApiDescription",
									"nameSpace": "",
									"basicName": "ApiDescription",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
								},
								"typeKind": 1
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "license",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "overview",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "url",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "Common.RAMLLanguageElement",
							"nameSpace": "Common",
							"basicName": "RAMLLanguageElement",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				}
			],
			"aliases": [],
			"enumDeclarations": [],
			"imports": {
				"MetaModel": "c:\\GIT-repos\\raml-labs\\src\\raml1\\metamodel.ts",
				"Sys": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts",
				"RM": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts",
				"Decls": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\declarations.ts",
				"Params": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\parameters.ts",
				"Common": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\common.ts",
				"Bodies": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\bodies.ts",
				"models": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\datamodel.ts"
			},
			"name": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\api.ts"
		},
		{
			"classes": [
				{
					"name": "SpecPartMetaData",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "title",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": true,
					"annotations": [],
					"extends": [],
					"moduleName": null,
					"annotationOverridings": {}
				}
			],
			"aliases": [],
			"enumDeclarations": [
				{
					"name": "RAMLVersion",
					"members": [
						"RAML08",
						"RAML10"
					]
				}
			],
			"imports": {},
			"name": "c:\\GIT-repos\\raml-labs\\src\\raml1\\metamodel.ts"
		},
		{
			"classes": [
				{
					"name": "ValueType",
					"methods": [
						{
							"name": "parse",
							"start": 69,
							"end": 234,
							"text": "\n    /**\n     * parses inner structure of value type if value type has invalid value you should throw error\n     * with descriptive message\n     */\n    parse():any{}"
						}
					],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [],
					"extends": [],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "StringType",
					"methods": [
						{
							"name": "value",
							"start": 321,
							"end": 349,
							"text": " value():string{return null}"
						}
					],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.nameAtRuntime",
							"arguments": [
								"string"
							]
						}
					],
					"extends": [
						{
							"typeName": "ValueType",
							"nameSpace": "",
							"basicName": "ValueType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "NumberType",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.nameAtRuntime",
							"arguments": [
								"number"
							]
						},
						{
							"name": "MetaModel.alias",
							"arguments": [
								"integer"
							]
						},
						{
							"name": "MetaModel.alias",
							"arguments": [
								"number"
							]
						}
					],
					"extends": [
						{
							"typeName": "ValueType",
							"nameSpace": "",
							"basicName": "ValueType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "BooleanType",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.nameAtRuntime",
							"arguments": [
								"boolean"
							]
						},
						{
							"name": "MetaModel.alias",
							"arguments": [
								"boolean"
							]
						}
					],
					"extends": [
						{
							"typeName": "ValueType",
							"nameSpace": "",
							"basicName": "ValueType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "Referencable",
					"methods": [],
					"typeParameters": [
						"T"
					],
					"typeParameterConstraint": [
						null
					],
					"implements": [],
					"fields": [],
					"isInterface": true,
					"annotations": [],
					"extends": [],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "Reference",
					"methods": [],
					"typeParameters": [
						"T"
					],
					"typeParameterConstraint": [
						null
					],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "ValueType",
							"nameSpace": "",
							"basicName": "ValueType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "DeclaresDynamicType",
					"methods": [],
					"typeParameters": [
						"T"
					],
					"typeParameterConstraint": [
						null
					],
					"implements": [],
					"fields": [],
					"isInterface": true,
					"annotations": [],
					"extends": [
						{
							"typeName": "Referencable",
							"nameSpace": "",
							"basicName": "Referencable",
							"typeKind": 0,
							"typeArguments": [
								{
									"typeName": "T",
									"nameSpace": "",
									"basicName": "T",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
								}
							],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "UriTemplate",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.description",
							"arguments": [
								"This type currently serves both for absolute and relative urls"
							]
						},
						{
							"name": "MetaModel.issue",
							"arguments": [
								"https://github.com/raml-org/raml-spec/issues/115"
							]
						}
					],
					"extends": [
						{
							"typeName": "StringType",
							"nameSpace": "",
							"basicName": "StringType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "StatusCode",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "StringType",
							"nameSpace": "",
							"basicName": "StringType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "ramlexpression",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "ValueType",
							"nameSpace": "",
							"basicName": "ValueType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "RelativeUri",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.description",
							"arguments": [
								"This  type describes relative uri templates"
							]
						}
					],
					"extends": [
						{
							"typeName": "UriTemplate",
							"nameSpace": "",
							"basicName": "UriTemplate",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "FullUriTemplate",
					"methods": [
						{
							"name": "validate",
							"start": 2412,
							"end": 3342,
							"text": "\n    //parse():string[]{\n    //    var value=this.value();\n    //    var result=[]\n    //    var temp=\"\";\n    //    var inPar=false;\n    //    var count=0;\n    //    for (var a=0;a<value.length;a++){\n    //        var c=value[a];\n    //        if (c=='{'){\n    //            count++;\n    //            inPar=true;\n    //            continue;\n    //        }\n    //        if (c=='}'){\n    //            count--;\n    //            inPar=false;\n    //            result.push(temp);\n    //            temp=\"\";\n    //            continue;\n    //        }\n    //        if (inPar){\n    //            temp+=c;\n    //        }\n    //    }\n    //    if (count>0){\n    //        throw new Error(\"Unmatched '{'\")\n    //    }\n    //    if (count<0){\n    //        throw new Error(\"Unmatched '}'\")\n    //    }\n    //    return result;\n    //}\n\n    validate(){\n        var str=this.value();\n        //write something to validate Url here\n    }"
						}
					],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.description",
							"arguments": [
								"This  type describes absolute uri templates"
							]
						}
					],
					"extends": [
						{
							"typeName": "UriTemplate",
							"nameSpace": "",
							"basicName": "UriTemplate",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "FixedUri",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.description",
							"arguments": [
								"This  type describes fixed uris"
							]
						}
					],
					"extends": [
						{
							"typeName": "StringType",
							"nameSpace": "",
							"basicName": "StringType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "ContentType",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "StringType",
							"nameSpace": "",
							"basicName": "StringType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "ValidityExpression",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "StringType",
							"nameSpace": "",
							"basicName": "StringType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "MarkdownString",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.innerType",
							"arguments": [
								"markdown"
							]
						},
						{
							"name": "MetaModel.issue",
							"arguments": [
								"https://github.com/raml-org/raml-spec/issues/80"
							]
						},
						{
							"name": "MetaModel.description",
							"arguments": [
								"Mardown string is a string which can contain markdown as an extension this markdown should support links with RAML Pointers since 1.0"
							]
						}
					],
					"extends": [
						{
							"typeName": "StringType",
							"nameSpace": "",
							"basicName": "StringType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "DateFormatSpec",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "StringType",
							"nameSpace": "",
							"basicName": "StringType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "FunctionalInterface",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "StringType",
							"nameSpace": "",
							"basicName": "StringType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "SchemaString",
					"methods": [
						{
							"name": "validate",
							"start": 4227,
							"end": 4410,
							"text": "\n\n    validate(){\n        var str=this.value();\n        //write something to validate schema here here\n        //in fact it should check that content is valid json or xsd schema\n    }"
						}
					],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.description",
							"arguments": [
								"Schema at this moment only two subtypes are supported (json schema and xsd)"
							]
						},
						{
							"name": "MetaModel.alias",
							"arguments": [
								"schema"
							]
						}
					],
					"extends": [
						{
							"typeName": "StringType",
							"nameSpace": "",
							"basicName": "StringType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "ExampleString",
					"methods": [
						{
							"name": "validate",
							"start": 4564,
							"end": 4747,
							"text": "\n\n    validate(){\n        var str=this.value();\n        //write something to validate schema here here\n        //in fact it should check that content is valid json or xsd schema\n    }"
						}
					],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.description",
							"arguments": [
								"Examples at this moment only two subtypes are supported (json  and xml)"
							]
						}
					],
					"extends": [
						{
							"typeName": "StringType",
							"nameSpace": "",
							"basicName": "StringType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "JSonSchemaString",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.innerType",
							"arguments": [
								"json"
							]
						},
						{
							"name": "MetaModel.description",
							"arguments": [
								"JSON schema"
							]
						}
					],
					"extends": [
						{
							"typeName": "SchemaString",
							"nameSpace": "",
							"basicName": "SchemaString",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "XMLSchemaString",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.innerType",
							"arguments": [
								"xsd"
							]
						},
						{
							"name": "MetaModel.description",
							"arguments": [
								"XSD schema"
							]
						}
					],
					"extends": [
						{
							"typeName": "SchemaString",
							"nameSpace": "",
							"basicName": "SchemaString",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "ScriptingHook",
					"methods": [],
					"typeParameters": [
						"T"
					],
					"typeParameterConstraint": [
						null
					],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.description",
							"arguments": [
								"script to inject to tooling environment"
							]
						}
					],
					"extends": [
						{
							"typeName": "StringType",
							"nameSpace": "",
							"basicName": "StringType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "RAMLPointer",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "StringType",
							"nameSpace": "",
							"basicName": "StringType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "RAMLSelector",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "StringType",
							"nameSpace": "",
							"basicName": "StringType",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				}
			],
			"aliases": [],
			"enumDeclarations": [],
			"imports": {
				"MetaModel": "c:\\GIT-repos\\raml-labs\\src\\raml1\\metamodel.ts"
			},
			"name": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\systemTypes.ts"
		},
		{
			"classes": [
				{
					"name": "ResourceTypeRef",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "Sys.Reference",
							"nameSpace": "Sys",
							"basicName": "Reference",
							"typeKind": 0,
							"typeArguments": [
								{
									"typeName": "ResourceType",
									"nameSpace": "",
									"basicName": "ResourceType",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								}
							],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "TraitRef",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "Sys.Reference",
							"nameSpace": "Sys",
							"basicName": "Reference",
							"typeKind": 0,
							"typeArguments": [
								{
									"typeName": "Trait",
									"nameSpace": "",
									"basicName": "Trait",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								}
							],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "SecuritySchemaPart",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "MethodBase",
							"nameSpace": "",
							"basicName": "MethodBase",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {
						"headers": [
							{
								"name": "MetaModel.markdownDescription",
								"arguments": [
									"Optional array of headers, documenting the possible headers that could be accepted. See [[raml-10-spec-headers|Headers]] section."
								]
							},
							{
								"name": "MetaModel.valueDescription",
								"arguments": [
									"Object whose property names are the request header names and whose values describe the values."
								]
							}
						],
						"queryParameters": [
							{
								"name": "MetaModel.markdownDescription",
								"arguments": [
									"Query parameters, used by the schema in order to authorize the request. Mutually exclusive with queryString. See [[raml-10-spec-query-parameters-in-a-query-string|Query Parameters]] section."
								]
							},
							{
								"name": "MetaModel.valueDescription",
								"arguments": [
									"Object whose property names are the query parameter names and whose values describe the values."
								]
							}
						],
						"queryString": [
							{
								"name": "MetaModel.description",
								"arguments": [
									"Specifies the query string, used by the schema in order to authorize the request. Mutually exclusive with queryParameters."
								]
							},
							{
								"name": "MetaModel.valueDescription",
								"arguments": [
									"Type name or type declaration"
								]
							}
						],
						"responses": [
							{
								"name": "MetaModel.description",
								"arguments": [
									"Optional array of responses, describing the possible responses that could be sent. See [[raml-10-spec-responses|Responses]] section."
								]
							}
						],
						"is": [
							{
								"name": "MetaModel.hide",
								"arguments": []
							}
						],
						"securedBy": [
							{
								"name": "MetaModel.hide",
								"arguments": []
							}
						],
						"displayName": [
							{
								"name": "MetaModel.description",
								"arguments": [
									"An alternate, human-friendly name for the security scheme part"
								]
							}
						],
						"description": [
							{
								"name": "MetaModel.description",
								"arguments": [
									"A longer, human-friendly description of the security scheme part"
								]
							},
							{
								"name": "MetaModel.valueDescription",
								"arguments": [
									"Markdown string"
								]
							}
						],
						"annotations": [
							{
								"name": "MetaModel.description",
								"arguments": [
									"Annotations to be applied to this security scheme part. Annotations are any property whose key begins with \"(\" and ends with \")\" and whose name (the part between the beginning and ending parentheses) is a declared annotation name. See [[raml-10-spec-annotations|the section on annotations]]."
								]
							}
						]
					}
				},
				{
					"name": "SecuritySchemaHook",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "parameters",
							"type": {
								"base": {
									"typeName": "models.DataElement",
									"nameSpace": "models",
									"basicName": "DataElement",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								},
								"typeKind": 1
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "script",
							"type": {
								"typeName": "SecuritySchemaHookScript",
								"nameSpace": "",
								"basicName": "SecuritySchemaHookScript",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.description",
							"arguments": [
								"Allows customization of security schemeas"
							]
						}
					],
					"extends": [],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "SecuritySchemaHookScript",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "Sys.ScriptingHook",
							"nameSpace": "Sys",
							"basicName": "ScriptingHook",
							"typeKind": 0,
							"typeArguments": [
								{
									"typeName": "auth.SecuritySchemeHook",
									"nameSpace": "auth",
									"basicName": "SecuritySchemeHook",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								}
							],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "SecuritySchemaType",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "requiredSettings",
							"type": {
								"base": {
									"typeName": "models.DataElement",
									"nameSpace": "models",
									"basicName": "DataElement",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"You may declare settings needed to use this type of security security schemas"
									]
								},
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"locationKind",
										"models.LocationKind.DECLARATIONS"
									]
								},
								{
									"name": "MetaModel.declaringFields",
									"arguments": []
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "describedBy",
							"type": {
								"typeName": "SecuritySchemaPart",
								"nameSpace": "",
								"basicName": "SecuritySchemaPart",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"The describedBy attribute MAY be used to apply a trait-like structure to a security scheme mechanism so as to extend the mechanism, such as specifying response codes, HTTP headers or custom documentation.\n        This extension allows API designers to describe security schemes. As a best practice, even for standard security schemes, API designers SHOULD describe the security schemes' required artifacts, such as headers, URI parameters, and so on. Including the security schemes' description completes an API's documentation."
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.declaresSubTypeOf",
							"arguments": [
								"SecuritySchemaSettings"
							]
						},
						{
							"name": "MetaModel.description",
							"arguments": [
								"Security schema type allows you to contribute your own security schema type with settings and optinal configurator for plugging into client sdks auth mechanism"
							]
						}
					],
					"extends": [
						{
							"typeName": "Common.RAMLLanguageElement",
							"nameSpace": "Common",
							"basicName": "RAMLLanguageElement",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "SecuritySchemaSettings",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.issue",
							"arguments": [
								"Specification is actually very vague here"
							]
						},
						{
							"name": "MetaModel.functionalDescriminator",
							"arguments": [
								"$parent.type"
							]
						}
					],
					"extends": [],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "OAuth1SecuritySchemeSettings",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "requestTokenUri",
							"type": {
								"typeName": "Sys.FixedUri",
								"nameSpace": "Sys",
								"basicName": "FixedUri",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
							},
							"annotations": [
								{
									"name": "MetaModel.required",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"The URI of the Temporary Credential Request endpoint as defined in RFC5849 Section 2.1"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"FixedUri"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "authorizationUri",
							"type": {
								"typeName": "Sys.FixedUri",
								"nameSpace": "Sys",
								"basicName": "FixedUri",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
							},
							"annotations": [
								{
									"name": "MetaModel.required",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"The URI of the Resource Owner Authorization endpoint as defined in RFC5849 Section 2.2"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"FixedUri"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "tokenCredentialsUri",
							"type": {
								"typeName": "Sys.FixedUri",
								"nameSpace": "Sys",
								"basicName": "FixedUri",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
							},
							"annotations": [
								{
									"name": "MetaModel.required",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"The URI of the Token Request endpoint as defined in RFC5849 Section 2.3"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"FixedUri"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "signatures",
							"type": {
								"base": {
									"typeName": "string",
									"nameSpace": "",
									"basicName": "string",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": null
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.oneOf",
									"arguments": [
										[
											"HMAC-SHA1",
											"RSA-SHA1",
											"PLAINTEXT"
										]
									]
								},
								{
									"name": "MetaModel.hide",
									"arguments": []
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.functionalDescriminator",
							"arguments": [
								"$parent.type=='OAuth 1.0'"
							]
						},
						{
							"name": "MetaModel.issue",
							"arguments": [
								"Specification is actually very vague here"
							]
						}
					],
					"extends": [
						{
							"typeName": "SecuritySchemaSettings",
							"nameSpace": "",
							"basicName": "SecuritySchemaSettings",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {
						"displayName": [
							{
								"name": "MetaModel.hide",
								"arguments": []
							}
						],
						"description": [
							{
								"name": "MetaModel.hide",
								"arguments": []
							}
						],
						"annotations": [
							{
								"name": "MetaModel.hide",
								"arguments": []
							}
						],
						"authentificationConfigurator": [
							{
								"name": "MetaModel.hide",
								"arguments": []
							}
						]
					}
				},
				{
					"name": "OAuth2SecuritySchemeSettings",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "accessTokenUri",
							"type": {
								"typeName": "Sys.FixedUri",
								"nameSpace": "Sys",
								"basicName": "FixedUri",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
							},
							"annotations": [
								{
									"name": "MetaModel.required",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"The URI of the Token Endpoint as defined in RFC6749 [RFC6748] Section 3.2. Not required forby implicit grant type."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"FixedUri"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "authorizationUri",
							"type": {
								"typeName": "Sys.FixedUri",
								"nameSpace": "Sys",
								"basicName": "FixedUri",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
							},
							"annotations": [
								{
									"name": "MetaModel.required",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"The URI of the Authorization Endpoint as defined in RFC6749 [RFC6748] Section 3.1. Required forby authorization_code and implicit grant types."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"FixedUri"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "authorizationGrants",
							"type": {
								"base": {
									"typeName": "string",
									"nameSpace": "",
									"basicName": "string",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": null
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.required",
									"arguments": []
								},
								{
									"name": "MetaModel.markdownDescription",
									"arguments": [
										"A list of the Authorization grants supported by the API as defined in RFC6749 [RFC6749] Sections 4.1, 4.2, 4.3 and 4.4, can be any of:<br>* authorization_code<br>* password<br>* client_credentials<br>* implicit<br>* refresh_token."
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "scopes",
							"type": {
								"base": {
									"typeName": "string",
									"nameSpace": "",
									"basicName": "string",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": null
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"A list of scopes supported by the security scheme as defined in RFC6749 [RFC6749] Section 3.3"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.functionalDescriminator",
							"arguments": [
								"$parent.type=='OAuth 2.0'"
							]
						},
						{
							"name": "MetaModel.issue",
							"arguments": [
								"Specification is actually very vague here"
							]
						}
					],
					"extends": [
						{
							"typeName": "SecuritySchemaSettings",
							"nameSpace": "",
							"basicName": "SecuritySchemaSettings",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {
						"displayName": [
							{
								"name": "MetaModel.hide",
								"arguments": []
							}
						],
						"description": [
							{
								"name": "MetaModel.hide",
								"arguments": []
							}
						],
						"annotations": [
							{
								"name": "MetaModel.hide",
								"arguments": []
							}
						],
						"authentificationConfigurator": [
							{
								"name": "MetaModel.hide",
								"arguments": []
							}
						]
					}
				},
				{
					"name": "PassThroughSettings",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "queryParameterName",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "headerName",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.functionalDescriminator",
							"arguments": [
								"$parent.type=='PassThrough'"
							]
						},
						{
							"name": "MetaModel.issue",
							"arguments": [
								"Specification is actually very vague here"
							]
						}
					],
					"extends": [
						{
							"typeName": "SecuritySchemaSettings",
							"nameSpace": "",
							"basicName": "SecuritySchemaSettings",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "SecuritySchemaRef",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "Sys.Reference",
							"nameSpace": "Sys",
							"basicName": "Reference",
							"typeKind": 0,
							"typeArguments": [
								{
									"typeName": "SecuritySchema",
									"nameSpace": "",
									"basicName": "SecuritySchema",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								}
							],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "SecuritySchema",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [
						{
							"typeName": "Sys.Referencable",
							"nameSpace": "Sys",
							"basicName": "Referencable",
							"typeKind": 0,
							"typeArguments": [
								{
									"typeName": "SecuritySchema",
									"nameSpace": "",
									"basicName": "SecuritySchema",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								}
							],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"fields": [
						{
							"name": "name",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.key",
									"arguments": []
								},
								{
									"name": "MetaModel.startFrom",
									"arguments": [
										""
									]
								},
								{
									"name": "MetaModel.hide",
									"arguments": []
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "type",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.required",
									"arguments": []
								},
								{
									"name": "MetaModel.oneOf",
									"arguments": [
										[
											"OAuth 1.0",
											"OAuth 2.0",
											"Basic Authentication",
											"Digest Authentication",
											"Pass Through",
											"x-{other}"
										]
									]
								},
								{
									"name": "MetaModel.descriminatingProperty",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"The securitySchemes property MUST be used to specify an API's security mechanisms, including the required settings and the authentication methods that the API supports. one authentication method is allowed if the API supports them."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"string<br><br>The value MUST be one of<br>* OAuth 1.0,<br>* OAuth 2.0,<br>* Basic Authentication<br>* Digest Authentication<br>* Pass Through<br>* x-&lt;other&gt;"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "description",
							"type": {
								"typeName": "Sys.MarkdownString",
								"nameSpace": "Sys",
								"basicName": "MarkdownString",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"The description attribute MAY be used to describe a security schemes property."
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"The description MAY be used to describe a securityScheme."
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "describedBy",
							"type": {
								"typeName": "SecuritySchemaPart",
								"nameSpace": "",
								"basicName": "SecuritySchemaPart",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"A description of the request components related to Security that are determined by the scheme: the headers, query parameters or responses. As a best practice, even for standard security schemes, API designers SHOULD describe these properties of security schemes.\nIncluding the security scheme description completes an API documentation."
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "settings",
							"type": {
								"typeName": "SecuritySchemaSettings",
								"nameSpace": "",
								"basicName": "SecuritySchemaSettings",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"The settings attribute MAY be used to provide security scheme-specific information. The required attributes vary depending on the type of security scheme is being declared.\nIt describes the minimum set of properties which any processing application MUST provide and validate if it chooses to implement the security scheme. Processing applications MAY choose to recognize other properties for things such as token lifetime, preferred cryptographic algorithms, and more."
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.description",
							"arguments": [
								"Declares globally referable security schema definition"
							]
						},
						{
							"name": "MetaModel.actuallyExports",
							"arguments": [
								"$self"
							]
						},
						{
							"name": "MetaModel.referenceIs",
							"arguments": [
								"settings"
							]
						}
					],
					"extends": [
						{
							"typeName": "Common.RAMLLanguageElement",
							"nameSpace": "Common",
							"basicName": "RAMLLanguageElement",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "Oath2",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "type",
							"type": null,
							"annotations": [],
							"valueConstraint": {
								"isCallConstraint": false,
								"value": "OAuth 2.0"
							},
							"optional": false
						},
						{
							"name": "settings",
							"type": {
								"typeName": "OAuth2SecuritySchemeSettings",
								"nameSpace": "",
								"basicName": "OAuth2SecuritySchemeSettings",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.description",
							"arguments": [
								"Declares globally referable security schema definition"
							]
						},
						{
							"name": "MetaModel.actuallyExports",
							"arguments": [
								"$self"
							]
						},
						{
							"name": "MetaModel.referenceIs",
							"arguments": [
								"settings"
							]
						}
					],
					"extends": [
						{
							"typeName": "SecuritySchema",
							"nameSpace": "",
							"basicName": "SecuritySchema",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "Oath1",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "type",
							"type": null,
							"annotations": [],
							"valueConstraint": {
								"isCallConstraint": false,
								"value": "OAuth 1.0"
							},
							"optional": false
						},
						{
							"name": "settings",
							"type": {
								"typeName": "OAuth1SecuritySchemeSettings",
								"nameSpace": "",
								"basicName": "OAuth1SecuritySchemeSettings",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.description",
							"arguments": [
								"Declares globally referable security schema definition"
							]
						},
						{
							"name": "MetaModel.actuallyExports",
							"arguments": [
								"$self"
							]
						},
						{
							"name": "MetaModel.referenceIs",
							"arguments": [
								"settings"
							]
						}
					],
					"extends": [
						{
							"typeName": "SecuritySchema",
							"nameSpace": "",
							"basicName": "SecuritySchema",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "PassThrough",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "type",
							"type": null,
							"annotations": [],
							"valueConstraint": {
								"isCallConstraint": false,
								"value": "PassThrough"
							},
							"optional": false
						},
						{
							"name": "settings",
							"type": {
								"typeName": "PassThroughSettings",
								"nameSpace": "",
								"basicName": "PassThroughSettings",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.description",
							"arguments": [
								"Declares globally referable security schema definition"
							]
						},
						{
							"name": "MetaModel.actuallyExports",
							"arguments": [
								"$self"
							]
						},
						{
							"name": "MetaModel.referenceIs",
							"arguments": [
								"settings"
							]
						}
					],
					"extends": [
						{
							"typeName": "SecuritySchema",
							"nameSpace": "",
							"basicName": "SecuritySchema",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "Basic",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "type",
							"type": null,
							"annotations": [],
							"valueConstraint": {
								"isCallConstraint": false,
								"value": "Basic Authentication"
							},
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.description",
							"arguments": [
								"Declares globally referable security schema definition"
							]
						},
						{
							"name": "MetaModel.actuallyExports",
							"arguments": [
								"$self"
							]
						},
						{
							"name": "MetaModel.referenceIs",
							"arguments": [
								"settings"
							]
						}
					],
					"extends": [
						{
							"typeName": "SecuritySchema",
							"nameSpace": "",
							"basicName": "SecuritySchema",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "Digest",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "type",
							"type": null,
							"annotations": [],
							"valueConstraint": {
								"isCallConstraint": false,
								"value": "Digest Authentication"
							},
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.description",
							"arguments": [
								"Declares globally referable security schema definition"
							]
						},
						{
							"name": "MetaModel.actuallyExports",
							"arguments": [
								"$self"
							]
						},
						{
							"name": "MetaModel.referenceIs",
							"arguments": [
								"settings"
							]
						}
					],
					"extends": [
						{
							"typeName": "SecuritySchema",
							"nameSpace": "",
							"basicName": "SecuritySchema",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "Custom",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "type",
							"type": null,
							"annotations": [],
							"valueConstraint": {
								"isCallConstraint": false,
								"value": "x-{other}"
							},
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.description",
							"arguments": [
								"Declares globally referable security schema definition"
							]
						},
						{
							"name": "MetaModel.actuallyExports",
							"arguments": [
								"$self"
							]
						},
						{
							"name": "MetaModel.referenceIs",
							"arguments": [
								"settings"
							]
						}
					],
					"extends": [
						{
							"typeName": "SecuritySchema",
							"nameSpace": "",
							"basicName": "SecuritySchema",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "MethodBase",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "responses",
							"type": {
								"base": {
									"typeName": "Bodies.Response",
									"nameSpace": "Bodies",
									"basicName": "Response",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"response",
										"true"
									]
								},
								{
									"name": "MetaModel.newInstanceName",
									"arguments": [
										"New Response"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Information about the expected responses to a request"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An object whose keys are the HTTP status codes of the responses and whose values describe the responses."
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "body",
							"type": {
								"base": {
									"typeName": "models.DataElement",
									"nameSpace": "models",
									"basicName": "DataElement",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.newInstanceName",
									"arguments": [
										"New Body"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Some method verbs expect the resource to be sent as a request body. For example, to create a resource, the request must include the details of the resource to create.\nResources CAN have alternate representations. For example, an API might support both JSON and XML representations.\nA method's body is defined in the body property as a hashmap, in which the key MUST be a valid media type."
									]
								},
								{
									"name": "MetaModel.needsClarification",
									"arguments": [
										"Ensure that forms spec is consistent with it"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "protocols",
							"type": {
								"base": {
									"typeName": "string",
									"nameSpace": "",
									"basicName": "string",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": null
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.oneOf",
									"arguments": [
										[
											"HTTP",
											"HTTPS"
										]
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"A method can override the protocols specified in the resource or at the API root, by employing this property."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"array of strings of value HTTP or HTTPS, or a single string of such kind, case-insensitive"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "is",
							"type": {
								"base": {
									"typeName": "TraitRef",
									"nameSpace": "",
									"basicName": "TraitRef",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"Instantiation of applyed traits"
									]
								},
								{
									"name": "MetaModel.thisFeatureCovers",
									"arguments": [
										"https://github.com/raml-org/raml-spec/issues/98"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "securedBy",
							"type": {
								"base": {
									"typeName": "SecuritySchemaRef",
									"nameSpace": "",
									"basicName": "SecuritySchemaRef",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.allowNull",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										" securityScheme may also be applied to a resource by using the securedBy key, which is equivalent to applying the securityScheme to all methods that may be declared, explicitly or implicitly, by defining the resourceTypes or traits property for that resource.\nTo indicate that the method may be called without applying any securityScheme, the method may be annotated with the null securityScheme."
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "Params.HasNormalParameters",
							"nameSpace": "Params",
							"basicName": "HasNormalParameters",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "Trait",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [
						{
							"typeName": "Sys.DeclaresDynamicType",
							"nameSpace": "Sys",
							"basicName": "DeclaresDynamicType",
							"typeKind": 0,
							"typeArguments": [
								{
									"typeName": "Trait",
									"nameSpace": "",
									"basicName": "Trait",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								}
							],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"fields": [
						{
							"name": "name",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.key",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Name of the trait"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "usage",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "uses",
							"type": {
								"base": {
									"typeName": "api.Library",
									"nameSpace": "api",
									"basicName": "Library",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"You may import library locally here it contents is accessible only inside of this trait"
									]
								},
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"decls",
										"true"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An array of libraries or a single library"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.inlinedTemplates",
							"arguments": []
						},
						{
							"name": "MetaModel.allowQuestion",
							"arguments": []
						}
					],
					"extends": [
						{
							"typeName": "MethodBase",
							"nameSpace": "",
							"basicName": "MethodBase",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "ResourceBase",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [],
					"fields": [
						{
							"name": "methods",
							"type": {
								"base": {
									"typeName": "Method",
									"nameSpace": "",
									"basicName": "Method",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"Methods that are part of this resource type definition"
									]
								},
								{
									"name": "MetaModel.markdownDescription",
									"arguments": [
										"The methods available on this resource. See [[raml-10-spec-methods|the section on method properties]]."
									]
								},
								{
									"name": "MetaModel.documentationTableLabel",
									"arguments": [
										"get?<br>patch?<br>put?<br>post?<br>delete?<br>options?<br>head?"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"Object describing the method"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "is",
							"type": {
								"base": {
									"typeName": "TraitRef",
									"nameSpace": "",
									"basicName": "TraitRef",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"A list of the traits to apply to all methods declared (implicitly or explicitly) for this resource. See [[raml-10-spec-applying-resource-types-and-traits|Applying Resource Types and Traits]] section. Individual methods may override this declaration"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"array, which can contain each of the following elements:<br>* name of unparametrized trait<br>* a key-value pair with trait name as key and a map of trait parameters as value<br>* inline trait declaration<br><br>(or a single element of any above kind)"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "type",
							"type": {
								"typeName": "ResourceTypeRef",
								"nameSpace": "",
								"basicName": "ResourceTypeRef",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
							},
							"annotations": [
								{
									"name": "MetaModel.description",
									"arguments": [
										"The resource type which this resource inherits. . See [[raml-10-spec-applying-resource-types-and-traits|Applying Resource Types and Traits]] section."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"one of the following elements:<br>* name of unparametrized resource type<br>* a key-value pair with resource type name as key and a map of its parameters as value<br>* inline resource type declaration"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "securedBy",
							"type": {
								"base": {
									"typeName": "SecuritySchemaRef",
									"nameSpace": "",
									"basicName": "SecuritySchemaRef",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.allowNull",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"The security schemes that apply to all methods declared (implicitly or explicitly) for this resource."
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"array of security scheme names or a single security scheme name"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "uriParameters",
							"type": {
								"base": {
									"typeName": "models.DataElement",
									"nameSpace": "models",
									"basicName": "DataElement",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"location",
										"models.ModelLocation.URI"
									]
								},
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"locationKind",
										"models.LocationKind.APISTRUCTURE"
									]
								},
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"fieldOrParam",
										true
									]
								},
								{
									"name": "MetaModel.valueRestriction",
									"arguments": [
										"_.find(<br>&nbsp;&nbsp;relativeUri.templateArguments(),<br>&nbsp;&nbsp;$value.name)",
										"Uri parameter names should match to template names in relative uri"
									]
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Detailed information about any URI parameters of this resource"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"object whose property names are the URI parameter names and whose values describe the values"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [],
					"extends": [
						{
							"typeName": "Common.RAMLLanguageElement",
							"nameSpace": "Common",
							"basicName": "RAMLLanguageElement",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
				},
				{
					"name": "ResourceType",
					"methods": [],
					"typeParameters": [],
					"typeParameterConstraint": [],
					"implements": [
						{
							"typeName": "Sys.DeclaresDynamicType",
							"nameSpace": "Sys",
							"basicName": "DeclaresDynamicType",
							"typeKind": 0,
							"typeArguments": [
								{
									"typeName": "ResourceType",
									"nameSpace": "",
									"basicName": "ResourceType",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								}
							],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"fields": [
						{
							"name": "name",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [
								{
									"name": "MetaModel.key",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"Name of the resource type"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "usage",
							"type": {
								"typeName": "string",
								"nameSpace": "",
								"basicName": "string",
								"typeKind": 0,
								"typeArguments": [],
								"modulePath": null
							},
							"annotations": [],
							"valueConstraint": null,
							"optional": false
						},
						{
							"name": "uses",
							"type": {
								"base": {
									"typeName": "api.Library",
									"nameSpace": "api",
									"basicName": "Library",
									"typeKind": 0,
									"typeArguments": [],
									"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
								},
								"typeKind": 1
							},
							"annotations": [
								{
									"name": "MetaModel.embeddedInMaps",
									"arguments": []
								},
								{
									"name": "MetaModel.description",
									"arguments": [
										"You may import library locally here it contents is accessible only inside of this resource type"
									]
								},
								{
									"name": "MetaModel.setsContextValue",
									"arguments": [
										"decls",
										"true"
									]
								},
								{
									"name": "MetaModel.valueDescription",
									"arguments": [
										"An array of libraries"
									]
								}
							],
							"valueConstraint": null,
							"optional": false
						}
					],
					"isInterface": false,
					"annotations": [
						{
							"name": "MetaModel.inlinedTemplates",
							"arguments": []
						},
						{
							"name": "MetaModel.allowQuestion",
							"arguments": []
						}
					],
					"extends": [
						{
							"typeName": "ResourceBase",
							"nameSpace": "",
							"basicName": "ResourceBase",
							"typeKind": 0,
							"typeArguments": [],
							"modulePath": "c:\\GIT-repos\\raml-labs\\src\\raml1\\spec-1.0\\methodsAndResources.ts"
						}
					],
					"moduleName": null,
					"annotationOverridings": {}
		