/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.raml1.java.parser.core;

import com.mulesoft.raml.webpack.holders.JSChildProcess;
import com.mulesoft.raml.webpack.holders.JSConsole;
import com.mulesoft.raml.webpack.holders.JSFileSystem;
import com.mulesoft.raml.webpack.holders.JSHolder;
import com.mulesoft.raml.webpack.holders.JSHttp;
import com.mulesoft.raml.webpack.holders.JSPlatformExecution;
import com.mulesoft.raml.webpack.holders.JSReportManager;
import com.mulesoft.raml.webpack.holders.JSSchema;
import com.mulesoft.raml.webpack.holders.JSZ;
import com.mulesoft.raml1.java.parser.core.CustomType;
import com.mulesoft.raml1.java.parser.core.CustomTypeRegistry;
import com.mulesoft.raml1.java.parser.core.IssueCode;
import com.mulesoft.raml1.java.parser.core.ValidationIssue;
import com.mulesoft.raml1.java.parser.core.Wrapper;
import com.mulesoft.raml1.java.parser.impl.api.ApiImpl;
import com.mulesoft.raml1.java.parser.model.api.Api;
import com.mulesoft.raml1.java.parser.path.resolver.IJavaPathResolver;
import com.mulesoft.raml1.java.parser.path.resolver.JavaFSPathResolver;
import com.mulesoft.raml1.java.parser.path.resolver.JavaPathResolverHolder;
import com.mulesoft.raml1.java.parser.registry.ModelRegistry;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class JavaNodeFactory {
    private String rootPath = "";
    private ScriptEngine engine;
    public Wrapper wrapper;
    private CustomTypeRegistry customTypesRegistry;
    private JavaPathResolverHolder pathResolverHolder;

    public JavaNodeFactory() {
        this.init();
    }

    public Api createApi(String apiFile) {
        return new ApiImpl(this.wrapper.getApiJsObject(apiFile), this);
    }

    public <T, S extends T> T getAttribute(Object jsNode, String name, Class<S> clazz) {
        return this.getValue(jsNode, name, clazz);
    }

    public <T, S extends T> List<T> getAttributes(Object jsNode, String name, Class<S> clazz) {
        return this.getValueList(jsNode, name, clazz);
    }

    public <T, S extends T> T getElement(Object jsNode, String name, Class<S> clazz) {
        return this.getObject(jsNode, name, clazz);
    }

    public <T, S extends T> List<T> getElements(Object jsNode, String name, Class<S> clazz) {
        return this.getObjectList(jsNode, name, clazz);
    }

    public String attributeValue(Object jsNode) {
        String result = null;
        try {
            Bindings bindings = this.getBindings();
            bindings.put("node", jsNode);
            Object obj = this.engine.eval("node.value()", bindings);
            if (obj != null) {
                result = obj.toString();
            }
        }
        catch (IllegalArgumentException | SecurityException | ScriptException e) {
            e.printStackTrace();
        }
        return result;
    }

    private <T, S extends T> T getValue(Object jsNode, String name, Class<S> clazz) {
        T result = null;
        try {
            Bindings bindings = this.getBindings();
            bindings.put("node", jsNode);
            Object jsResult = this.engine.eval("node." + name + "()", bindings);
            if (jsResult == null) {
                return null;
            }
            result = this.convert(clazz, jsResult);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | ScriptException e) {
            e.printStackTrace();
        }
        return result;
    }

    private <T, S extends T> T convert(Class<S> clazz, Object jsResult) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        T result;
        if (jsResult == null) {
            result = null;
        } else if (clazz.equals(String.class)) {
            result = (T)clazz.cast(jsResult.toString());
        } else if (clazz.equals(Boolean.class)) {
            result = (T)clazz.cast(Boolean.parseBoolean(jsResult.toString()));
        } else if (Number.class.isAssignableFrom(clazz)) {
            result = (T)clazz.cast(Double.parseDouble(jsResult.toString()));
        } else if (clazz.isEnum()) {
            S anEnum = Enum.valueOf(clazz, jsResult.toString());
            result = (T)clazz.cast(anEnum);
        } else {
            Constructor<S> constr = clazz.getConstructor(Object.class, JavaNodeFactory.class);
            result = (T)constr.newInstance(jsResult, this);
        }
        return result;
    }

    private <T, S extends T> List<T> getValueList(Object jsNode, String name, Class<S> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            Bindings bindings = this.getBindings();
            bindings.put("node", jsNode);
            ScriptObjectMirror jsResult = (ScriptObjectMirror)this.engine.eval("node." + name + "()", bindings);
            if (jsResult != null) {
                for (Object obj : jsResult.values()) {
                    list.add(this.convert(clazz, obj));
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | ScriptException e) {
            e.printStackTrace();
        }
        ArrayList list1 = new ArrayList();
        for (Object o : list) {
            list1.add(o);
        }
        return list1;
    }

    private <T, S extends T> T getObject(Object jsNode, String name, Class<S> clazz) {
        T result = null;
        try {
            Bindings bindings = this.getBindings();
            bindings.put("node", jsNode);
            Object jsResult = this.engine.eval("node." + name + "()", bindings);
            if (jsResult == null) {
                return null;
            }
            Class<S> actualClazz = this.getActualClass(jsResult, clazz);
            Constructor<S> constr = actualClazz.getConstructor(Object.class, JavaNodeFactory.class);
            result = (T)constr.newInstance(jsResult, this);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | ScriptException e) {
            e.printStackTrace();
        }
        return result;
    }

    private <S> Class<? extends S> getActualClass(Object jsNode, Class<S> clazz) {
        Bindings bindings = this.getBindings();
        bindings.put("node", jsNode);
        try {
            Object classNameObj = this.engine.eval("node.wrapperClassName()", bindings);
            if (classNameObj != null) {
                Class<S> result;
                String className = classNameObj.toString();
                if (!clazz.getSimpleName().equals(className) && (result = ModelRegistry.getInstance().getModelClass(className, clazz)) != null) {
                    return result;
                }
            }
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return clazz;
    }

    private <T, S extends T> List<T> getObjectList(Object jsNode, String name, Class<S> clazz) {
        ArrayList<S> list = new ArrayList<S>();
        try {
            Bindings bindings = this.getBindings();
            bindings.put("node", jsNode);
            ScriptObjectMirror jsResult = (ScriptObjectMirror)this.engine.eval("node." + name + "()", bindings);
            if (jsResult != null) {
                for (Object obj : jsResult.values()) {
                    Class<S> actualClazz = this.getActualClass(obj, clazz);
                    Constructor<S> constr = actualClazz.getConstructor(Object.class, JavaNodeFactory.class);
                    list.add(constr.newInstance(obj, this));
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | ScriptException e) {
            e.printStackTrace();
        }
        return list;
    }

    public Bindings getBindings() {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("console", (Object)JSConsole.getInstance((ScriptEngine)this.engine));
        return bindings;
    }

    public CustomType customClassValue(Object jsNode) {
        return this.customTypesRegistry.customClassValue(jsNode);
    }

    private void init() {
        this.engine = new ScriptEngineManager().getEngineByName("nashorn");
        this.wrapper = new Wrapper(this.engine);
        this.customTypesRegistry = new CustomTypeRegistry(this.engine, this.wrapper);
        this.pathResolverHolder = new JavaPathResolverHolder(this.engine, new JavaFSPathResolver());
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("endpoints", new Object());
        bindings.put("z", (Object)new JSZ(this.engine));
        bindings.put("schema", (Object)new JSSchema(this.engine));
        bindings.put("fs", (Object)JSFileSystem.getInstance((ScriptEngine)this.engine, (String)this.rootPath));
        bindings.put("executionReportManager", (Object)new JSReportManager(this.engine));
        bindings.put("http", (Object)new JSHttp(this.engine, false));
        bindings.put("https", (Object)new JSHttp(this.engine, true));
        bindings.put("javaPathResolver", (Object)this.pathResolverHolder);
        bindings.put("platformExecution", (Object)new JSPlatformExecution(this.engine));
        bindings.put("child_process", (Object)new JSChildProcess(this.engine, this.rootPath));
        bindings.put("_spawn_sync", (Object)new JSChildProcess(this.engine, this.rootPath));
        bindings.put("console", (Object)JSConsole.getInstance((ScriptEngine)this.engine));
        bindings.put("apiCreatorWrapper", (Object)this.wrapper);
        bindings.put("typescript", (Object)new JSHolder(this.engine));
        bindings.put("_try_thread_sleep", (Object)new JSHolder(this.engine));
        try {
            InputStreamReader scriptSrc = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("bundle.js"), "UTF-8");
            CompiledScript script = ((Compilable)((Object)this.engine)).compile(scriptSrc);
            bindings.put("script", (Object)script);
            script.eval(bindings);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setPathResolver(IJavaPathResolver resolver) {
        this.pathResolverHolder.setResolver(resolver);
    }

    public List<ValidationIssue> getErrors(Object jsNode) {
        ArrayList<ValidationIssue> result = new ArrayList<ValidationIssue>();
        Bindings bindings = this.getBindings();
        bindings.put("node", jsNode);
        try {
            Object errorsObj = this.engine.eval("node.errors()", bindings);
            if (errorsObj instanceof ScriptObjectMirror) {
                ScriptObjectMirror errors = (ScriptObjectMirror)errorsObj;
                for (Object obj : errors.values()) {
                    ScriptObjectMirror error = (ScriptObjectMirror)obj;
                    IssueCode code = null;
                    Integer intCode = this.getIntegerValue(error, "code");
                    if (intCode != null) {
                        IssueCode[] codes = IssueCode.values();
                        if (intCode >= 0 && intCode < codes.length) {
                            code = codes[intCode];
                        }
                    }
                    String message = this.getStringValue(error, "message");
                    String path = this.getStringValue(error, "path");
                    Integer start = this.getIntegerValue(error, "start");
                    Integer end = this.getIntegerValue(error, "end");
                    boolean isWarning = this.getBooleanValue(error, "isWarning");
                    ValidationIssue vi = new ValidationIssue(code, message, path, start, end, isWarning);
                    result.add(vi);
                }
            }
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String getStringValue(ScriptObjectMirror error, String name) {
        return error.get((Object)name) != null ? error.get((Object)name).toString() : null;
    }

    private Integer getIntegerValue(ScriptObjectMirror error, String name) {
        Integer result = null;
        Object obj = error.get((Object)name);
        if (obj instanceof Integer) {
            result = (Integer)obj;
        } else if (obj instanceof Double) {
            result = (int)Math.round((Double)obj);
        } else if (obj instanceof String) {
            Double doubleVal = Double.parseDouble(obj.toString());
            result = (int)Math.round(doubleVal);
        }
        return result;
    }

    private Boolean getBooleanValue(ScriptObjectMirror error, String name) {
        Boolean result = null;
        if (error.get((Object)name) != null) {
            try {
                result = Boolean.parseBoolean(error.get((Object)name).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

