/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.raml1.java.parser.core;

import com.mulesoft.raml1.java.parser.core.IJavaElementNode;
import com.mulesoft.raml1.java.parser.core.IJavaNode;
import com.mulesoft.raml1.java.parser.core.JavaNodeFactory;
import com.mulesoft.raml1.java.parser.core.ValidationIssue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import org.apache.commons.lang3.StringEscapeUtils;

public class JavaElementNode
implements IJavaElementNode {
    private Object jsNode;
    private JavaNodeFactory factory;

    public JavaElementNode(Object jsNode, JavaNodeFactory factory) {
        this.jsNode = jsNode;
        this.factory = factory;
    }

    protected JavaElementNode() {
    }

    protected <T, S extends T> T getAttribute(String name, Class<S> clazz) {
        return this.factory.getAttribute(this.jsNode, name, clazz);
    }

    protected <T, S extends T> List<T> getAttributes(String name, Class<S> clazz) {
        return this.factory.getAttributes(this.jsNode, name, clazz);
    }

    protected <T, S extends T> T getElement(String name, Class<S> clazz) {
        return this.factory.getElement(this.jsNode, name, clazz);
    }

    public <T, S extends T> List<T> getElements(String name, Class<S> clazz) {
        return this.factory.getElements(this.jsNode, name, clazz);
    }

    @Override
    public List<ValidationIssue> getErrors() {
        return this.factory.getErrors(this.jsNode);
    }

    @Override
    public String toJSON() {
        return this.toJSON(0);
    }

    @Override
    public String toJSON(int offset) {
        String indent = "";
        for (int i = 0; i < offset; ++i) {
            indent = indent + " ";
        }
        String bodyIndent = indent + "    ";
        String arrayIndent = indent + "        ";
        StringBuilder bld = new StringBuilder("{");
        for (Method m : this.getClass().getMethods()) {
            XmlElement prop = m.getAnnotation(XmlElement.class);
            if (prop == null) continue;
            String propName = prop.name();
            Class<?> returnType = m.getReturnType();
            try {
                Object value = m.invoke((Object)this, new Object[0]);
                if (value == null) continue;
                if (returnType == List.class) {
                    String str = m.getGenericReturnType().getTypeName();
                    String qName = str.substring(str.indexOf("<") + 1, str.lastIndexOf(">"));
                    returnType = this.getClass().getClassLoader().loadClass(qName);
                    boolean isElement = IJavaNode.class.isAssignableFrom(returnType);
                    List lst = (List)value;
                    if (lst.size() <= 0) continue;
                    bld.append("\n").append(bodyIndent).append("\"").append(propName).append("\" : [");
                    for (Object component : lst) {
                        if (isElement) {
                            String elementStr = ((IJavaNode)component).toJSON(offset + 8);
                            bld.append(" " + (elementStr != null ? elementStr.trim() : "NULL"));
                            bld.append(",");
                            continue;
                        }
                        String valStr = this.prepareStringValue(component);
                        bld.append("\n").append(arrayIndent).append(valStr).append(",");
                    }
                    if (lst.size() > 0) {
                        bld.setCharAt(bld.length() - 1, '\n');
                        bld.append(bodyIndent);
                    }
                    bld.append("],");
                    continue;
                }
                boolean isElement = IJavaNode.class.isAssignableFrom(returnType);
                bld.append("\n").append(bodyIndent).append("\"").append(propName).append("\" : ");
                if (isElement) {
                    String elementStr = ((IJavaNode)value).toJSON(offset + 4);
                    bld.append(elementStr);
                } else {
                    String valStr = this.prepareStringValue(value);
                    bld.append(valStr.toString());
                }
                bld.append(",");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (bld.length() > 1) {
            bld.setCharAt(bld.length() - 1, '\n');
        }
        bld.append(indent + "}");
        return bld.toString();
    }

    private String prepareStringValue(Object component) {
        boolean isString = component.getClass() == String.class;
        String valStr = component.toString();
        if (valStr.indexOf(34) >= 0) {
            valStr = StringEscapeUtils.escapeEcmaScript((String)valStr);
        }
        if (isString) {
            valStr = "\"" + valStr + "\"";
        }
        return valStr;
    }
}

