/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.raml1.java.parser.core;

import com.mulesoft.raml.webpack.holders.JSConsole;
import com.mulesoft.raml1.java.parser.core.CustomType;
import com.mulesoft.raml1.java.parser.core.Wrapper;
import com.mulesoft.raml1.java.parser.registry.ModelRegistry;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.SimpleBindings;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.eclipse.jdt.internal.compiler.tool.EclipseCompiler;

public class CustomTypeRegistry {
    private ScriptEngine engine;
    private Wrapper wrapper;
    private LinkedHashSet<String> customClassPackages;
    private final HashMap<String, byte[]> resourcesMap = new HashMap();
    private final LinkedHashMap<String, byte[]> classCodeMap = new LinkedHashMap();
    private final CustomClassLoader customClassLoader = this.createClassLoader();
    private final HashMap<String, Set<String>> jaxbIndexMap = new HashMap();

    public CustomTypeRegistry(ScriptEngine engine, Wrapper wrapper) {
        this.engine = engine;
        this.wrapper = wrapper;
    }

    public CustomType customClassValue(Object jsNode) {
        try {
            ArrayList<UserClassData> classesList = new ArrayList<UserClassData>();
            Bindings bindings = this.getBindings();
            bindings.put("node", jsNode);
            bindings.put("env", (Object)this.wrapper);
            bindings.put("pkg", (Object)ModelRegistry.getInstance().rootPackage());
            ScriptObjectMirror svData = (ScriptObjectMirror)this.engine.eval("env.generateClasses(node.value(),pkg)", bindings);
            String jsonData = null;
            String valueName = null;
            if (svData != null) {
                jsonData = svData.get((Object)"data").toString();
                valueName = svData.get((Object)"valueName").toString();
                ScriptObjectMirror classes = (ScriptObjectMirror)svData.get((Object)"classes");
                for (Object obj : classes.values()) {
                    ScriptObjectMirror cls = (ScriptObjectMirror)obj;
                    String classContent = cls.get((Object)"content").toString();
                    String qName = cls.get((Object)"qualifiedName").toString();
                    String sName = cls.get((Object)"simpleName").toString();
                    classesList.add(new UserClassData(qName, sName, classContent));
                }
            }
            String sName = ((UserClassData)classesList.get(0)).getSimpleName();
            String qName = ((UserClassData)classesList.get(0)).getQualifiedName();
            Class<CustomType> customClass = this.loadCustomClassFromLibrary(sName);
            if (customClass == null) {
                this.compileUserClass(classesList);
                Class<?> c = this.customClassLoader.loadClass(qName);
                if (c != null && CustomType.class.isAssignableFrom(c)) {
                    customClass = c;
                }
            }
            if (customClass != null) {
                CustomType result = this.unmarshalCustomType(jsonData, customClass);
                result.setRAMLValueName(valueName);
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CustomType customType = new CustomType();
        customType.setFactory(this);
        return customType;
    }

    private Class<? extends CustomType> loadCustomClassFromLibrary(String simpleName) {
        if (this.customClassPackages == null) {
            this.customClassPackages = new LinkedHashSet();
            try {
                Enumeration<URL> resources = this.getClass().getClassLoader().getResources("customClassesPackages.txt");
                try {
                    URL url;
                    while ((url = resources.nextElement()) != null) {
                        String ln;
                        BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                        while ((ln = br.readLine()) != null) {
                            if ((ln = ln.trim()).isEmpty()) continue;
                            this.customClassPackages.add(ln);
                        }
                    }
                }
                catch (NoSuchElementException br) {
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        Class<?> result = null;
        for (String pkg : this.customClassPackages) {
            Class<?> clz = null;
            try {
                clz = this.getClass().getClassLoader().loadClass(pkg + "." + simpleName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clz == null || !CustomType.class.isAssignableFrom(clz)) continue;
            result = clz;
            break;
        }
        return result;
    }

    private void compileUserClass(List<UserClassData> classesList) {
        String packagePath = classesList.get(0).getPackagePath();
        Set<String> set = this.jaxbIndexMap.get(packagePath);
        if (set == null) {
            set = new LinkedHashSet<String>();
            this.jaxbIndexMap.put(packagePath, set);
        }
        for (UserClassData userClassData : classesList) {
            EclipseCompiler javac = new EclipseCompiler();
            StandardJavaFileManager standardFileManager = javac.getStandardFileManager(null, null, null);
            CustomFileManager fileManager = new CustomFileManager(standardFileManager, this.customClassLoader);
            List<String> options = Collections.emptyList();
            List<CustomSourceFileObject> compilationUnits = Arrays.asList(new CustomSourceFileObject(userClassData.simpleName, userClassData.content));
            PrintWriter out = new PrintWriter(System.err);
            JavaCompiler.CompilationTask compile = javac.getTask(out, fileManager, null, options, null, compilationUnits);
            compile.call();
            set.add(userClassData.getSimpleName());
        }
        StringBuilder bld = new StringBuilder();
        for (String n : set) {
            bld.append(n).append("\n");
        }
        String string = bld.toString();
        try {
            this.resourcesMap.put(packagePath + "/jaxb.properties", "javax.xml.bind.context.factory=org.eclipse.persistence.jaxb.JAXBContextFactory".getBytes("UTF-8"));
            this.resourcesMap.put(packagePath + "/jaxb.index", string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public CustomType unmarshalCustomType(String jsonData, Class<? extends CustomType> clz) throws JAXBException, PropertyException {
        JAXBContext ctx = this.createJaxbContext(clz);
        Unmarshaller um = ctx.createUnmarshaller();
        um.setProperty("eclipselink.media-type", (Object)"application/json");
        um.setProperty("eclipselink.json.include-root", (Object)false);
        CustomType result = (CustomType)um.unmarshal((Source)new StreamSource(new StringReader(jsonData)), clz).getValue();
        result.setFactory(this);
        return result;
    }

    private JAXBContext createJaxbContext(Class<? extends CustomType> clz) throws JAXBException {
        String qName = clz.getCanonicalName();
        String packageName = qName.substring(0, qName.lastIndexOf(46));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.xml.bind.context.factory", "org.eclipse.persistence.jaxb.JAXBContextFactory");
        JAXBContext ctx = JAXBContext.newInstance((String)packageName, (ClassLoader)clz.getClassLoader(), props);
        return ctx;
    }

    public String marshalCustomType(CustomType obj) throws JAXBException, PropertyException {
        Class<?> clz = obj.getClass();
        JAXBContext ctx = this.createJaxbContext(clz);
        Marshaller m = ctx.createMarshaller();
        m.setProperty("eclipselink.media-type", (Object)"application/json");
        m.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter sw = new StringWriter();
        m.marshal((Object)obj, (Writer)sw);
        String result = sw.toString();
        return result;
    }

    private CustomClassLoader createClassLoader() {
        CustomClassLoader cl = null;
        cl = new CustomClassLoader(this.resourcesMap);
        return cl;
    }

    public Bindings getBindings() {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("console", (Object)JSConsole.getInstance((ScriptEngine)this.engine));
        return bindings;
    }

    private static class UserClassData {
        private String qualifiedName;
        private String simpleName;
        private String content;

        public UserClassData(String qualifiedName, String simpleName, String content) {
            this.qualifiedName = qualifiedName;
            this.simpleName = simpleName;
            this.content = content;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        public String getContent() {
            return this.content;
        }

        public String getPath() {
            return this.getQualifiedName().replace('.', '/') + ".java";
        }

        public String getPackage() {
            String qName = this.getQualifiedName();
            return qName.substring(0, qName.lastIndexOf(46));
        }

        public byte[] getBytes() throws UnsupportedEncodingException {
            return this.getContent().getBytes("UTF-8");
        }

        public String getPackagePath() {
            return this.getPackage().replace('.', '/');
        }
    }

    class CustomFileObject
    extends SimpleJavaFileObject {
        private ByteArrayOutputStream baos;

        public CustomFileObject(String name) {
            super(URI.create("byte:///" + name + ".class"), JavaFileObject.Kind.CLASS);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            throw new IllegalStateException();
        }

        @Override
        public OutputStream openOutputStream() {
            this.baos = new ByteArrayOutputStream();
            return this.baos;
        }

        @Override
        public InputStream openInputStream() {
            throw new IllegalStateException();
        }

        public byte[] getBytes() {
            return this.baos.toByteArray();
        }
    }

    class CustomFileManager
    extends ForwardingJavaFileManager {
        private CustomClassLoader classLoader;

        public CustomFileManager(StandardJavaFileManager fileManager, CustomClassLoader classLoader) {
            super(fileManager);
            this.classLoader = classLoader;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location loc, String name, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            CustomFileObject mbc = new CustomFileObject(name);
            this.classLoader.addClass(name, mbc);
            return mbc;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return this.classLoader;
        }
    }

    class CustomSourceFileObject
    extends SimpleJavaFileObject {
        private String content;

        public CustomSourceFileObject(String simpleName, String content) {
            super(URI.create("file:///" + simpleName + ".java"), JavaFileObject.Kind.SOURCE);
            this.content = content;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.content;
        }

        @Override
        public OutputStream openOutputStream() {
            throw new IllegalStateException();
        }

        @Override
        public InputStream openInputStream() {
            byte[] bytes;
            try {
                bytes = this.content.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                bytes = this.content.getBytes();
            }
            return new ByteArrayInputStream(bytes);
        }
    }

    private static class CustomClassLoader
    extends ClassLoader {
        private Map<String, byte[]> resourcesMap;
        private Map<String, CustomFileObject> byteCodeMap = new HashMap<String, CustomFileObject>();

        private CustomClassLoader(Map<String, byte[]> resourcesMap) {
            super(ClassLoader.getSystemClassLoader());
            this.resourcesMap = resourcesMap;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            CustomFileObject mbc = this.byteCodeMap.get(name);
            if (mbc == null && (mbc = this.byteCodeMap.get(name.replace(".", "/"))) == null) {
                return super.findClass(name);
            }
            return this.defineClass(name, mbc.getBytes(), 0, mbc.getBytes().length);
        }

        public void addClass(String name, CustomFileObject mbc) {
            this.byteCodeMap.put(name, mbc);
        }

        @Override
        protected URL findResource(String name) {
            final byte[] bArr = this.resourcesMap.get(name);
            if (bArr == null) {
                return super.findResource(name);
            }
            try {
                return new URL("file", "", -1, "", new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) throws IOException {
                        return new URLConnection(u){

                            @Override
                            public void connect() throws IOException {
                            }

                            @Override
                            public InputStream getInputStream() throws IOException {
                                return new ByteArrayInputStream(bArr);
                            }
                        };
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                return super.findResource(name);
            }
        }
    }
}

