/*
 * Decompiled with CFR 0.152.
 */
package eu.ill.webx.utils;

import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexString {
    private static final Logger logger = LoggerFactory.getLogger(HexString.class);
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);

    public static String toDebugString(byte[] data) {
        return HexString.toDebugString(data, data.length);
    }

    public static String toDebugString(byte[] data, int length) {
        length = Math.min(length, data.length);
        byte[] hexChars = new byte[length * 3 - 1];
        for (int j = 0; j < length; ++j) {
            int v = data[j] & 0xFF;
            hexChars[j * 3] = HEX_ARRAY[v >>> 4];
            hexChars[j * 3 + 1] = HEX_ARRAY[v & 0xF];
            if (j >= length - 1) continue;
            hexChars[j * 3 + 2] = 32;
        }
        return "[" + new String(hexChars, StandardCharsets.UTF_8) + (data.length > length ? " ...]" : "]");
    }

    public static String fromByteArray(byte[] data) {
        return HexString.fromByteArray(data, data.length);
    }

    public static String fromByteArray(byte[] data, int length) {
        byte[] hexChars = new byte[length * 2];
        for (int j = 0; j < length; ++j) {
            int v = data[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    public static byte[] toByteArray(String hexString, int expectedBytesLength) {
        if (expectedBytesLength != hexString.length() / 2) {
            logger.error("Received invalid HexString of expected length {}: {}", (Object)expectedBytesLength, (Object)hexString);
        }
        int length = hexString.length();
        byte[] data = new byte[length / 2];
        int index = 0;
        for (int i = 0; i < length; i += 2) {
            data[index++] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }
}

