/*
 * Decompiled with CFR 0.152.
 */
package eu.ill.webx.transport;

import eu.ill.webx.WebXClientConfiguration;
import eu.ill.webx.exceptions.WebXDisconnectedException;
import eu.ill.webx.model.ConnectionData;
import eu.ill.webx.model.SocketResponse;
import eu.ill.webx.transport.ClientConnector;
import eu.ill.webx.transport.InstructionPublisher;
import eu.ill.webx.transport.MessageSubscriber;
import eu.ill.webx.transport.SessionChannel;
import org.zeromq.ZContext;

public class Transport {
    private ZContext context;
    private boolean connected = false;
    private boolean isStandalone;
    private ClientConnector connector;
    private MessageSubscriber messageSubscriber;
    private InstructionPublisher instructionPublisher;
    private SessionChannel sessionChannel;

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void connect(String hostname, int port, int socketTimeoutMs, boolean isStandalone, MessageSubscriber.MessageHandler messageHandler) throws WebXDisconnectedException {
        if (this.context == null) {
            this.isStandalone = isStandalone;
            this.connected = false;
            this.context = new ZContext();
            try {
                this.connector = new ClientConnector();
                ConnectionData connectionData = this.connector.connect(this.context, "tcp://" + hostname + ":" + port, socketTimeoutMs, isStandalone);
                this.messageSubscriber = new MessageSubscriber(messageHandler);
                this.messageSubscriber.connect(this.context, "tcp://" + hostname + ":" + connectionData.publisherPort());
                this.instructionPublisher = new InstructionPublisher();
                this.instructionPublisher.connect(this.context, "tcp://" + hostname + ":" + connectionData.subscriberPort());
                if (!isStandalone) {
                    this.sessionChannel = new SessionChannel();
                    this.sessionChannel.connect(this.context, "tcp://" + hostname + ":" + connectionData.sessionPort(), socketTimeoutMs, connectionData.serverPublicKey());
                }
                this.connected = true;
            }
            catch (WebXDisconnectedException e) {
                this.disconnect();
                throw e;
            }
            catch (Exception e) {
                this.disconnect();
                throw new WebXDisconnectedException();
            }
        }
    }

    public synchronized void disconnect() {
        if (this.context != null) {
            this.connected = false;
            if (this.connector != null) {
                this.connector.disconnect();
                this.connector = null;
            }
            if (this.messageSubscriber != null) {
                this.messageSubscriber.disconnect();
                this.messageSubscriber = null;
            }
            if (this.instructionPublisher != null) {
                this.instructionPublisher.disconnect();
                this.instructionPublisher = null;
            }
            if (this.sessionChannel != null) {
                this.sessionChannel.disconnect();
                this.sessionChannel = null;
            }
            this.context.destroy();
            this.context = null;
        }
    }

    public synchronized void sendInstruction(byte[] instructionData) {
        if (this.connected) {
            this.instructionPublisher.queueInstruction(instructionData);
        }
    }

    public synchronized SocketResponse sendRequest(String request) throws WebXDisconnectedException {
        if (!this.connected) {
            throw new WebXDisconnectedException();
        }
        if (this.isStandalone) {
            return this.connector.sendRequest(request);
        }
        return this.sessionChannel.sendRequest(request);
    }

    public synchronized String startSession(WebXClientConfiguration configuration) throws WebXDisconnectedException {
        if (!this.isStandalone) {
            return this.sessionChannel.startSession(configuration);
        }
        throw new WebXDisconnectedException("Cannot start session in standalone mode");
    }
}

