/*
 * Decompiled with CFR 0.152.
 */
package eu.ill.webx.transport;

import eu.ill.webx.WebXClientConfiguration;
import eu.ill.webx.exceptions.WebXDisconnectedException;
import eu.ill.webx.model.SocketResponse;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;
import zmq.util.Z85;

public class SessionChannel {
    private static final Logger logger = LoggerFactory.getLogger(SessionChannel.class);
    private ZMQ.Socket socket;

    SessionChannel() {
    }

    void connect(ZContext context, String address, int socketTimeoutMs, String serverPublicKey) {
        if (this.socket == null) {
            this.socket = context.createSocket(SocketType.REQ);
            this.socket.setReceiveTimeOut(socketTimeoutMs);
            this.socket.setLinger(0);
            ZMQ.Curve.KeyPair keypair = ZMQ.Curve.generateKeyPair();
            this.socket.setCurveServerKey(Z85.decode((String)serverPublicKey));
            this.socket.setCurveSecretKey(keypair.secretKey.getBytes());
            this.socket.setCurvePublicKey(keypair.publicKey.getBytes());
            this.socket.connect(address);
            logger.debug("WebX Session Channel connected");
        }
    }

    void disconnect() {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
            logger.debug("WebX Session Channel disconnected");
        }
    }

    synchronized SocketResponse sendRequest(String request) throws WebXDisconnectedException {
        try {
            if (this.socket != null) {
                this.socket.send(request);
                return new SocketResponse(this.socket.recv());
            }
            throw new WebXDisconnectedException();
        }
        catch (ZMQException e) {
            logger.error("Caught ZMQ Exception: {}", (Object)e.getMessage());
            throw new WebXDisconnectedException();
        }
    }

    synchronized String startSession(WebXClientConfiguration configuration) throws WebXDisconnectedException {
        String usernameBase64 = Base64.getEncoder().encodeToString(configuration.getUsername().getBytes());
        String passwordBase64 = Base64.getEncoder().encodeToString(configuration.getPassword().getBytes());
        String request = "create," + usernameBase64 + "," + passwordBase64 + "," + configuration.getScreenWidth() + "," + configuration.getScreenHeight() + "," + configuration.getKeyboardLayout();
        return this.sendRequest(request).toString();
    }
}

