/*
 * Decompiled with CFR 0.152.
 */
package eu.ill.webx.transport;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class MessageSubscriber {
    private static final Logger logger = LoggerFactory.getLogger(MessageSubscriber.class);
    private ZMQ.Socket socket;
    private Thread messageThread;
    private boolean running = false;
    private final MessageHandler messageHandler;

    MessageSubscriber(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    synchronized void connect(ZContext context, String address) {
        if (!this.running) {
            this.socket = context.createSocket(SocketType.SUB);
            this.socket.setLinger(0);
            this.socket.subscribe(ZMQ.SUBSCRIPTION_ALL);
            this.socket.connect(address);
            this.running = true;
            this.messageThread = new Thread(this::loop);
            this.messageThread.start();
            logger.debug("WebX Message Subscriber started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        if (this.running) {
            MessageSubscriber messageSubscriber = this;
            synchronized (messageSubscriber) {
                this.running = false;
            }
            try {
                this.messageThread.interrupt();
                this.messageThread.join();
                this.messageThread = null;
                this.socket.close();
                logger.debug("WebX Message Subscriber disconnected");
            }
            catch (InterruptedException exception) {
                logger.error("Stop of WebX Subscriber thread interrupted");
            }
        }
    }

    private void loop() {
        while (this.running) {
            try {
                byte[] messageData = this.socket.recv();
                this.messageHandler.onMessage(messageData);
            }
            catch (ZMQException e) {
                if (!this.running) continue;
                logger.info("WebX Subscriber thread interrupted");
            }
        }
    }

    public static interface MessageHandler {
        public void onMessage(byte[] var1);
    }
}

