/*
 * Decompiled with CFR 0.152.
 */
package eu.ill.webx.transport;

import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

public class InstructionPublisher {
    private static final Logger logger = LoggerFactory.getLogger(InstructionPublisher.class);
    private ZMQ.Socket socket;
    private final LinkedBlockingDeque<byte[]> instructionQueue = new LinkedBlockingDeque();
    private Thread instructionThread;
    private boolean connected = false;

    InstructionPublisher() {
    }

    void connect(ZContext context, String address) {
        if (this.socket == null) {
            this.socket = context.createSocket(SocketType.PUB);
            this.socket.setLinger(0);
            this.socket.connect(address);
            this.connected = true;
            this.instructionThread = new Thread(this::instructionLoop);
            this.instructionThread.start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.debug("WebX Instruction Publisher connected");
        }
    }

    synchronized void disconnect() {
        if (this.connected) {
            try {
                this.connected = false;
                this.instructionQueue.clear();
                this.socket.close();
                this.socket = null;
                this.instructionThread.interrupt();
                this.instructionThread.join();
                this.instructionThread = null;
                logger.debug("WebX Instruction Publisher disconnected");
            }
            catch (InterruptedException exception) {
                logger.error("Stop of instruction publisher threads interrupted", (Throwable)exception);
            }
        }
    }

    synchronized void queueInstruction(byte[] instructionData) {
        try {
            this.instructionQueue.put(instructionData);
        }
        catch (InterruptedException exception) {
            logger.error("Interrupted when adding instruction to instruction queue");
        }
    }

    private void instructionLoop() {
        while (this.connected) {
            try {
                byte[] instructionData = this.instructionQueue.take();
                if (!this.connected) continue;
                this.socket.send(instructionData, 0);
            }
            catch (InterruptedException exception) {
                if (!this.connected) continue;
                logger.info("Instruction loop thread interrupted");
            }
        }
    }
}

