/*
 * Decompiled with CFR 0.152.
 */
package eu.ill.webx.relay;

import eu.ill.webx.exceptions.WebXDisconnectedException;
import eu.ill.webx.model.SessionId;
import eu.ill.webx.model.SocketResponse;
import eu.ill.webx.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebXSessionValidator
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(WebXSessionValidator.class);
    private static final int PING_DELAY_MS = 15000;
    private final SessionId sessionId;
    private final Transport transport;
    private final OnErrorHandler onErrorHandler;
    private boolean running = false;

    WebXSessionValidator(SessionId sessionId, Transport transport, OnErrorHandler onErrorHandler) {
        this.sessionId = sessionId;
        this.transport = transport;
        this.onErrorHandler = onErrorHandler != null ? onErrorHandler : error -> {};
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void start() {
        if (!this.running) {
            this.running = true;
            super.start();
        }
    }

    @Override
    public void interrupt() {
        if (this.running) {
            this.running = false;
            super.interrupt();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(15000L);
                if (!this.running) continue;
                try {
                    logger.trace("Sending ping to session {}", (Object)this.sessionId.hexString());
                    SocketResponse response = this.transport.sendRequest("ping," + this.sessionId.hexString());
                    if (response.toString() == null) {
                        this.onErrorHandler.onError(String.format("Failed to ping webX Session %s", this.sessionId.hexString()));
                        continue;
                    }
                    String[] responseElements = response.toString().split(",");
                    if (!responseElements[0].equals("pang")) continue;
                    this.onErrorHandler.onError(String.format("Failed to ping webX Session %s: %s", this.sessionId.hexString(), responseElements[2]));
                }
                catch (WebXDisconnectedException e) {
                    this.onErrorHandler.onError(String.format("Failed to get response from connector ping to session %s", this.sessionId.hexString()));
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static interface OnErrorHandler {
        public void onError(String var1);
    }
}

