/*
 * Decompiled with CFR 0.152.
 */
package eu.ill.webx.relay;

import eu.ill.webx.model.ClientIdentifier;
import eu.ill.webx.model.Message;
import eu.ill.webx.model.SessionId;
import eu.ill.webx.relay.WebXClient;
import eu.ill.webx.relay.WebXSessionValidator;
import eu.ill.webx.transport.Transport;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebXSession {
    private static final Logger logger = LoggerFactory.getLogger(WebXSession.class);
    private final SessionId sessionId;
    private final Transport transport;
    private final List<WebXClient> clients = new ArrayList<WebXClient>();
    private final WebXSessionValidator sessionValidator;

    WebXSession(SessionId sessionId, Transport transport) {
        this.sessionId = sessionId;
        this.transport = transport;
        this.sessionValidator = new WebXSessionValidator(this.sessionId, transport, error -> {
            logger.error("Session validation error: {}", (Object)error);
            this.sendMessageToClients(new Message.InterruptMessage("Failed to ping WebX Session"));
        });
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public void start() {
        this.sessionValidator.start();
    }

    public void stop() {
        try {
            if (this.sessionValidator.isRunning()) {
                this.sessionValidator.interrupt();
                this.sessionValidator.join();
                logger.debug("Session {} stopped", (Object)this.sessionId.hexString());
            }
        }
        catch (InterruptedException exception) {
            logger.error("Stop of relay message listener and client instruction threads interrupted", (Throwable)exception);
        }
    }

    public synchronized WebXClient createClient(ClientIdentifier clientIdentifier) {
        WebXClient client = new WebXClient(clientIdentifier, this);
        this.clients.add(client);
        return client;
    }

    public synchronized void onClientDisconnected(WebXClient client) {
        client.onDisconnected();
        this.clients.remove(client);
    }

    public synchronized int getClientCount() {
        return this.clients.size();
    }

    public void sendInstruction(byte[] instructionData) {
        this.transport.sendInstruction(instructionData);
    }

    public synchronized void onMessage(byte[] messageData) {
        List<WebXClient> indexAssociatedClients = this.clients.stream().filter(webXClient -> webXClient.matchesMessageIndexMask(messageData)).toList();
        for (WebXClient client : indexAssociatedClients) {
            client.onMessage(messageData);
        }
    }

    private void sendMessageToClients(Message message) {
        for (WebXClient client : this.clients) {
            client.onMessage(message);
        }
    }
}

