/*
 * Decompiled with CFR 0.152.
 */
package eu.ill.webx.relay;

import eu.ill.webx.WebXHostConfiguration;
import eu.ill.webx.exceptions.WebXConnectionException;
import eu.ill.webx.relay.WebXHost;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebXRelay {
    private static final Logger logger = LoggerFactory.getLogger(WebXRelay.class);
    private final List<WebXHost> hosts = new ArrayList<WebXHost>();

    private WebXRelay() {
    }

    public static WebXRelay getInstance() {
        return Holder.INSTANCE;
    }

    public synchronized WebXHost connectToHost(WebXHostConfiguration configuration) throws WebXConnectionException {
        Optional<WebXHost> existingHost = this.getHost(configuration);
        if (existingHost.isPresent()) {
            return existingHost.get();
        }
        WebXHost host = new WebXHost(configuration);
        try {
            host.connect();
            this.hosts.add(host);
            return host;
        }
        catch (WebXConnectionException exception) {
            host.disconnect();
            logger.error("Failed to create WebX host at {}:{} : {}", new Object[]{configuration.getHostname(), configuration.getPort(), exception.getMessage()});
            throw exception;
        }
    }

    public synchronized void onClientDisconnect(WebXHost host) {
        if (this.hosts.contains(host) && host.getClientCount() == 0) {
            this.hosts.remove(host);
            host.disconnect();
        }
    }

    private Optional<WebXHost> getHost(WebXHostConfiguration configuration) {
        return this.hosts.stream().filter(host -> host.getHostname().equals(configuration.getHostname()) && host.getPort() == configuration.getPort().intValue()).findFirst();
    }

    private static class Holder {
        private static final WebXRelay INSTANCE = new WebXRelay();

        private Holder() {
        }
    }
}

