/*
 * Decompiled with CFR 0.152.
 */
package eu.ill.webx.relay;

import eu.ill.webx.exceptions.WebXClientException;
import eu.ill.webx.exceptions.WebXConnectionInterruptException;
import eu.ill.webx.exceptions.WebXDisconnectedException;
import eu.ill.webx.model.ClientIdentifier;
import eu.ill.webx.model.Message;
import eu.ill.webx.model.SessionId;
import eu.ill.webx.relay.WebXSession;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.PriorityBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebXClient {
    private static final Logger logger = LoggerFactory.getLogger(WebXClient.class);
    private final ClientIdentifier clientIdentifier;
    private final WebXSession session;
    private final PriorityBlockingQueue<Message> messageQueue = new PriorityBlockingQueue();
    private boolean connected = true;
    private final ByteBuffer instructionPrefix = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);

    WebXClient(ClientIdentifier clientIdentifier, WebXSession session) {
        this.clientIdentifier = clientIdentifier;
        this.session = session;
        this.instructionPrefix.put(0, session.getSessionId().bytes(), 0, 16);
        ByteBuffer clientIdBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        clientIdBuffer.putInt(clientIdentifier.clientId());
        this.instructionPrefix.put(16, clientIdBuffer.array(), 0, 4);
    }

    public ClientIdentifier getClientIdentifier() {
        return this.clientIdentifier;
    }

    public SessionId getSessionId() {
        return this.session.getSessionId();
    }

    public void onDisconnected() {
        if (this.connected) {
            this.onMessage(new Message.CloseMessage());
            this.connected = false;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void onMessage(byte[] messageData) {
        if (this.connected) {
            logger.trace("Got client message of length {}", (Object)messageData.length);
            Message message = new Message(messageData);
            this.messageQueue.add(message);
        }
    }

    void onMessage(Message message) {
        if (this.connected) {
            this.messageQueue.add(message);
        }
    }

    public void sendInstruction(byte[] instructionData) {
        if (this.connected) {
            logger.trace("Got instruction of length {}", (Object)instructionData.length);
            System.arraycopy(this.instructionPrefix.array(), 0, instructionData, 0, 20);
            this.session.sendInstruction(instructionData);
        }
    }

    public byte[] getMessage() throws WebXClientException, WebXConnectionInterruptException, WebXDisconnectedException {
        if (this.connected) {
            try {
                Message message = this.messageQueue.take();
                if (message.getType().equals((Object)Message.Type.INTERRUPT)) {
                    throw new WebXConnectionInterruptException(message.getStringData());
                }
                if (message.getType().equals((Object)Message.Type.DISCONNECT)) {
                    logger.info("Client (Id \"{}\" and index \"{}\") received disconnect message from WebX session \"{}\"", new Object[]{this.getClientIdentifier().clientIdString(), this.getClientIdentifier().clientIndexString(), this.getSessionId().hexString()});
                    this.connected = false;
                    throw new WebXDisconnectedException("Disconnect message received from the server");
                }
                if (message.getType().equals((Object)Message.Type.CLOSE)) {
                    return null;
                }
                byte[] messageData = message.getData();
                if (messageData == null) {
                    return null;
                }
                logger.trace("Read client message of length {}", (Object)messageData.length);
                return messageData;
            }
            catch (InterruptedException exception) {
                throw new WebXConnectionInterruptException("Client message listener thread interrupted");
            }
        }
        throw new WebXClientException("WebXClient is not connected");
    }

    boolean matchesMessageIndexMask(byte[] messageData) {
        if (messageData.length < 24) {
            return false;
        }
        ByteBuffer messageMetadataWrapper = ByteBuffer.wrap(messageData, 16, 8).order(ByteOrder.LITTLE_ENDIAN);
        long clientIndexMask = messageMetadataWrapper.getLong();
        return (clientIndexMask & this.clientIdentifier.clientIndex()) != 0L;
    }
}

