/*
 * Decompiled with CFR 0.152.
 */
package eu.ill.webx.model;

import eu.ill.webx.utils.HexString;
import java.nio.ByteBuffer;

public class SessionId {
    private final long lower;
    private final long upper;
    private final byte[] sessionId;
    private String hexString;

    public SessionId(String sessionIdString) {
        this.hexString = sessionIdString;
        this.sessionId = HexString.toByteArray(sessionIdString, 16);
        ByteBuffer sessionIdBuffer = ByteBuffer.wrap(this.sessionId);
        this.upper = sessionIdBuffer.getLong();
        this.lower = sessionIdBuffer.getLong();
    }

    public SessionId(byte[] sessionId) {
        this.sessionId = sessionId;
        ByteBuffer sessionIdBuffer = ByteBuffer.wrap(sessionId);
        this.upper = sessionIdBuffer.getLong();
        this.lower = sessionIdBuffer.getLong();
    }

    public String hexString() {
        if (this.hexString == null) {
            this.hexString = HexString.fromByteArray(this.sessionId);
        }
        return this.hexString;
    }

    public byte[] bytes() {
        return this.sessionId;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionId sessionId = (SessionId)o;
        return this.lower == sessionId.lower && this.upper == sessionId.upper;
    }

    public int hashCode() {
        int result = Long.hashCode(this.lower);
        result = 31 * result + Long.hashCode(this.upper);
        return result;
    }
}

