/*
 * Decompiled with CFR 0.152.
 */
package eu.ill.webx.model;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Date;

public class Message
implements Comparable<Message> {
    private static final int TYPE_OFFSET = 32;
    private final byte[] data;
    private final Type type;
    private final Long timestamp = new Date().getTime();
    private final Integer priority;

    public Message(byte[] data) {
        this.data = data;
        int type = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getInt(32);
        if (type == 6) {
            this.type = Type.MOUSE;
            this.priority = 1;
        } else if (type == 7) {
            this.type = Type.CURSOR;
            this.priority = 2;
        } else if (type == 9) {
            this.type = Type.DISCONNECT;
            this.priority = 1;
        } else {
            this.type = Type.OTHER;
            this.priority = 3;
        }
    }

    private Message(Type type, Integer priority) {
        this.data = null;
        this.type = type;
        this.priority = priority;
    }

    private Message(Type type, Integer priority, byte[] message) {
        this.data = message;
        this.type = type;
        this.priority = priority;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getStringData() {
        return new String(this.data, StandardCharsets.UTF_8);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int compareTo(Message msg) {
        int priorityComparison = this.priority.compareTo(msg.priority);
        if (priorityComparison == 0) {
            return this.timestamp.compareTo(msg.timestamp);
        }
        return priorityComparison;
    }

    public static enum Type {
        INTERRUPT,
        CLOSE,
        MOUSE,
        CURSOR,
        DISCONNECT,
        OTHER;

    }

    public static class CloseMessage
    extends Message {
        public CloseMessage() {
            super(Type.CLOSE, 0);
        }
    }

    public static class InterruptMessage
    extends Message {
        public InterruptMessage(String message) {
            super(Type.INTERRUPT, 0, message.getBytes(StandardCharsets.UTF_8));
        }
    }
}

