/*
 * Decompiled with CFR 0.152.
 */
package eu.ill.webx;

import eu.ill.webx.WebXClientConfiguration;
import eu.ill.webx.WebXHostConfiguration;
import eu.ill.webx.exceptions.WebXClientException;
import eu.ill.webx.exceptions.WebXConnectionException;
import eu.ill.webx.exceptions.WebXConnectionInterruptException;
import eu.ill.webx.exceptions.WebXDisconnectedException;
import eu.ill.webx.relay.WebXClient;
import eu.ill.webx.relay.WebXHost;
import eu.ill.webx.relay.WebXRelay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebXTunnel {
    private static final Logger logger = LoggerFactory.getLogger(WebXTunnel.class);
    private WebXHost host;
    private WebXClient client;

    public static WebXTunnel Connect(WebXHostConfiguration hostConfiguration, WebXClientConfiguration clientConfiguration) throws WebXConnectionException {
        WebXTunnel tunnel = new WebXTunnel();
        tunnel.connect(hostConfiguration, clientConfiguration);
        return tunnel;
    }

    public void connect(WebXHostConfiguration hostConfiguration, WebXClientConfiguration clientConfiguration) throws WebXConnectionException {
        if (this.client == null) {
            this.host = WebXRelay.getInstance().connectToHost(hostConfiguration);
            try {
                logger.debug("Creating client for {}...", (Object)this.host.getHostname());
                this.client = this.host.onClientConnection(clientConfiguration);
                logger.info("... client created.");
            }
            catch (WebXConnectionException error) {
                logger.info("... client connection failed: {}", (Object)error.getMessage());
                this.host.cleanupSessions();
                WebXRelay.getInstance().onClientDisconnect(this.host);
                throw error;
            }
        }
    }

    public String getConnectionId() throws WebXClientException {
        if (this.client != null) {
            return this.client.getSessionId().hexString();
        }
        throw new WebXClientException("Client is not connected");
    }

    public void disconnect() {
        if (this.client != null) {
            this.host.onClientDisconnected(this.client);
            WebXRelay.getInstance().onClientDisconnect(this.host);
        }
    }

    public boolean isConnected() {
        if (this.client != null) {
            return this.client.isConnected();
        }
        return false;
    }

    public byte[] read() throws WebXClientException, WebXConnectionInterruptException, WebXDisconnectedException {
        if (this.client != null) {
            try {
                return this.client.getMessage();
            }
            catch (WebXDisconnectedException exception) {
                this.disconnect();
                throw exception;
            }
        }
        throw new WebXClientException("Client is not connected");
    }

    public void write(byte[] payload) throws WebXClientException {
        if (this.client == null) {
            throw new WebXClientException("Client is not connected");
        }
        this.client.sendInstruction(payload);
    }
}

