/*
 * Decompiled with CFR 0.152.
 */
package eu.ill.webx;

public class WebXClientConfiguration {
    private final String username;
    private final String password;
    private final String sessionId;
    private final Integer screenWidth;
    private final Integer screenHeight;
    private final String keyboardLayout;

    public static WebXClientConfiguration ForLogin(String username, String password, Integer screenWidth, Integer screenHeight, String keyboardLayout) {
        return new WebXClientConfiguration(username, password, screenWidth, screenHeight, keyboardLayout);
    }

    public static WebXClientConfiguration ForLogin(String username, String password, Integer screenWidth, Integer screenHeight) {
        return new WebXClientConfiguration(username, password, screenWidth, screenHeight, "gb");
    }

    public static WebXClientConfiguration ForLogin(String username, String password) {
        return new WebXClientConfiguration(username, password, 1920, 1024, "gb");
    }

    public static WebXClientConfiguration ForExistingSession(String sessionId) {
        return new WebXClientConfiguration(sessionId);
    }

    public static WebXClientConfiguration ForStandaloneSession() {
        return new WebXClientConfiguration("00000000000000000000000000000000");
    }

    private WebXClientConfiguration(String username, String password, Integer screenWidth, Integer screenHeight, String keyboardLayout) {
        this.username = username;
        this.password = password;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.keyboardLayout = keyboardLayout;
        this.sessionId = null;
    }

    private WebXClientConfiguration(String sessionId) {
        this.username = null;
        this.password = null;
        this.screenWidth = null;
        this.screenHeight = null;
        this.keyboardLayout = null;
        this.sessionId = sessionId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getScreenWidth() {
        return this.screenWidth;
    }

    public Integer getScreenHeight() {
        return this.screenHeight;
    }

    public String getKeyboardLayout() {
        return this.keyboardLayout;
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

