/*
 * Decompiled with CFR 0.152.
 */
package eu.hoefel.chemistry;

import eu.hoefel.chemistry.ChemicalCompound;
import eu.hoefel.chemistry.Element;
import eu.hoefel.chemistry.Isotope;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Nuclide
extends ChemicalCompound {
    public Element element();

    public boolean isIsotope();

    public static boolean isNuclide(String name) {
        return name != null && Element.parseName(name) != null || Isotope.parseName(name) != null;
    }

    public static Nuclide named(String name) {
        Objects.requireNonNull(name);
        Element e = Element.parseName(name);
        if (e != null) {
            return e;
        }
        Isotope i = Isotope.parseName(name);
        if (i != null) {
            return i;
        }
        throw new IllegalArgumentException("Found no nuclide named '" + name + "'");
    }
}

