/*
 * Decompiled with CFR 0.152.
 */
package eu.hoefel.chemistry;

import eu.hoefel.chemistry.Element;
import eu.hoefel.chemistry.Nuclide;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

record MoleculeInfo(String name, String formula, boolean isValid, String key, Map<Nuclide, Integer> components, double mass, String iupac, List<String> names) {
    static final String REF_URL = "https://cactus.nci.nih.gov/chemical/structure/";
    static final String STD_IN_CH_I_TARGET = "/stdinchikey";
    static final String CHEMICAL_FORMULA_TARGET = "/formula";
    static final String IUPAC_NAME = "/iupac_name";
    static final String NAMES = "/names";
    static final String VISUALIZATION = "/twirl";
    static final MoleculeInfo INVALID_NAME = new MoleculeInfo("", "", false, "", Map.of(), Double.NaN, "", List.of());

    public static final MoleculeInfo forMolecule(String name) {
        String formula;
        boolean isValid;
        boolean bl = isValid = !Nuclide.isNuclide(name);
        if (!isValid) {
            return INVALID_NAME;
        }
        try {
            formula = MoleculeInfo.toFormula(name);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Cannot fetch information for molecule named \"" + name + "\". Are you sure the spelling is correct?");
        }
        boolean bl2 = isValid = !Nuclide.isNuclide(formula);
        if (!isValid) {
            return INVALID_NAME;
        }
        String key = MoleculeInfo.toKey(name);
        Map<Nuclide, Integer> components = MoleculeInfo.getComponents(key);
        double mass = MoleculeInfo.calculateMass(components);
        String iupac = MoleculeInfo.toIupac(key);
        List<String> names = MoleculeInfo.getNames(key);
        return new MoleculeInfo(name, formula, isValid, key, components, mass, iupac, names);
    }

    private static final String toKey(String name) {
        return MoleculeInfo.readUrl(REF_URL + name + STD_IN_CH_I_TARGET);
    }

    private static final String toFormula(String name) {
        return MoleculeInfo.readUrl(REF_URL + name + CHEMICAL_FORMULA_TARGET);
    }

    private static final String toIupac(String name) {
        return MoleculeInfo.readUrl(REF_URL + name + IUPAC_NAME);
    }

    private static final List<String> getNames(String name) {
        return Arrays.asList(MoleculeInfo.readUrl(REF_URL + name + NAMES).split("\\R"));
    }

    private static final Map<Nuclide, Integer> getComponents(String name) {
        String formula = MoleculeInfo.readUrl(REF_URL + name + CHEMICAL_FORMULA_TARGET);
        LinkedHashMap<Element, Integer> moleculeComponents = new LinkedHashMap<Element, Integer>();
        for (int i = 0; i < formula.length(); ++i) {
            char c;
            int j;
            Object number;
            if (Character.isDigit(formula.charAt(i))) continue;
            if (i < formula.length() - 1) {
                for (Element element : Element.values()) {
                    if (!element.name().equals(formula.substring(i, i + 2))) continue;
                    number = "0";
                    for (j = (i += 2) + 2; j < formula.length() && Character.isDigit(c = formula.charAt(j)); ++j) {
                        number = (String)number + c;
                        ++i;
                    }
                    moleculeComponents.put(element, moleculeComponents.getOrDefault(element, 0) + Math.max(1, Integer.parseInt((String)number)));
                }
            }
            for (Element element : Element.values()) {
                if (!element.name().equals(formula.substring(i, i + 1))) continue;
                number = "0";
                for (j = i + 1; j < formula.length() && Character.isDigit(c = formula.charAt(j)); ++j) {
                    number = (String)number + c;
                }
                moleculeComponents.put(element, moleculeComponents.getOrDefault(element, 0) + Math.max(1, Integer.parseInt((String)number)));
            }
        }
        return Map.copyOf(moleculeComponents);
    }

    private static final double calculateMass(Map<Nuclide, Integer> components) {
        double mass = components.entrySet().stream().mapToDouble(component -> ((Nuclide)component.getKey()).mass() * (double)((Integer)component.getValue()).intValue()).sum();
        return mass == 0.0 ? Double.NaN : mass;
    }

    private static final String readUrl(String url) {
        String string;
        block10: {
            URI u;
            try {
                u = new URI(url);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            InputStream in = u.toURL().openStream();
            try {
                string = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Cannot read from " + String.valueOf(u), e);
                }
            }
            in.close();
        }
        return string;
    }
}

