/*
 * Decompiled with CFR 0.152.
 */
package eu.hoefel.chemistry;

import eu.hoefel.chemistry.ChemicalCompound;
import eu.hoefel.chemistry.MoleculeInfo;
import eu.hoefel.chemistry.Nuclide;
import eu.hoefel.jatex.LatexPackage;
import eu.hoefel.jatex.LatexPreambleEntry;
import eu.hoefel.jatex.Texable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public record Molecule(String name) implements ChemicalCompound,
Texable
{
    private static final ConcurrentMap<String, MoleculeInfo> info = new ConcurrentHashMap<String, MoleculeInfo>();

    public Molecule {
        Objects.requireNonNull(name);
        MoleculeInfo mi = info.computeIfAbsent(name, MoleculeInfo::forMolecule);
        if (!mi.isValid()) {
            throw new IllegalArgumentException("You requested a nuclide (%s), not a molecule. Please use the nuclide classes!".formatted(name));
        }
    }

    @Override
    public double mass() {
        return info.getOrDefault(this.name, MoleculeInfo.INVALID_NAME).mass();
    }

    @Override
    public Set<Nuclide> nuclides() {
        return info.getOrDefault(this.name, MoleculeInfo.INVALID_NAME).components().keySet();
    }

    public final String iupac() {
        return info.getOrDefault(this.name, MoleculeInfo.INVALID_NAME).iupac();
    }

    public final List<String> names() {
        return info.getOrDefault(this.name, MoleculeInfo.INVALID_NAME).names();
    }

    public final Map<Nuclide, Integer> components() {
        return info.getOrDefault(this.name, MoleculeInfo.INVALID_NAME).components();
    }

    public final String formula() {
        return info.getOrDefault(this.name, MoleculeInfo.INVALID_NAME).formula();
    }

    public final String key() {
        return info.getOrDefault(this.name, MoleculeInfo.INVALID_NAME).key();
    }

    public List<LatexPackage> neededPackages() {
        return List.of(new LatexPackage("chemformula", Map.of(), Map.of("mhchem", Set.of(Molecule.class))));
    }

    public List<LatexPreambleEntry> preambleExtras() {
        return List.of();
    }

    public List<String> latexCode() {
        return List.of("\\ch{" + this.formula() + "}");
    }
}

